/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.util.Date;

public class Cookie {
    private final String name;
    private final String value;
    private final String path;
    private final Date expiry;

    public Cookie(String name, String value, String path, Date expiry) {
        this.name = name;
        this.value = value;
        this.path = path == null || "".equals(path) ? "/" : path;
        this.expiry = expiry != null ? new Date(expiry.getTime() / 1000L * 1000L) : null;
        this.validate();
    }

    public Cookie(String name, String value) {
        this(name, value, "/", null);
    }

    public Cookie(String name, String value, String path) {
        this(name, value, path, null);
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getDomain() {
        return null;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isSecure() {
        return false;
    }

    public Date getExpiry() {
        return this.expiry;
    }

    protected void validate() {
        if (this.name == null || "".equals(this.name) || this.value == null || this.path == null) {
            throw new IllegalArgumentException("Required attribuets are not set or any non-null attribute set to null");
        }
        if (this.name.indexOf(59) != -1) {
            throw new IllegalArgumentException("Cookie names cannot contain a ';': " + this.name);
        }
    }

    public String toString() {
        return this.name + "=" + this.value + (this.expiry == null ? "" : ";expires=" + this.expiry) + ("".equals(this.path) ? "" : ";path=" + this.path);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Cookie)) {
            return false;
        }
        Cookie cookie = (Cookie)o;
        return this.name.equals(cookie.name);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        return result;
    }
}

