/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.internal;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Date;
import org.openqa.selenium.Cookie;

public class ReturnedCookie
extends Cookie {
    private String domain;
    private boolean isSecure;

    public ReturnedCookie(String name, String value, String domain, String path, Date expiry, boolean isSecure) {
        super(name, value, path, expiry);
        this.domain = domain;
        this.isSecure = isSecure;
        this.validate();
    }

    public String getDomain() {
        return this.domain;
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    protected void validate() {
        super.validate();
        if (this.domain != null && !"".equals(this.domain)) {
            try {
                String domainToUse = this.domain.startsWith("http") ? this.domain : "http://" + this.domain;
                URL url = new URL(domainToUse);
                InetAddress.getByName(url.getHost());
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(String.format("URL not valid: %s", this.domain));
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException(String.format("Domain does not exist: %s", this.domain));
            }
        }
    }

    public String toString() {
        return this.getName() + "=" + this.getValue() + (this.getExpiry() == null ? "" : ";expires=" + this.getExpiry()) + ("".equals(this.getPath()) ? "" : ";path=" + this.getPath()) + (this.isSecure ? ";secure;" : "");
    }
}

