/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.NoSuchFrameException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.Speed;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.firefox.Command;
import org.openqa.selenium.firefox.Context;
import org.openqa.selenium.firefox.ExtensionConnection;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.firefox.FirefoxWebElement;
import org.openqa.selenium.firefox.Response;
import org.openqa.selenium.firefox.internal.ExtensionConnectionFactory;
import org.openqa.selenium.firefox.internal.ProfilesIni;
import org.openqa.selenium.internal.FindsByClassName;
import org.openqa.selenium.internal.FindsById;
import org.openqa.selenium.internal.FindsByLinkText;
import org.openqa.selenium.internal.FindsByXPath;
import org.openqa.selenium.internal.OperatingSystem;
import org.openqa.selenium.internal.ReturnedCookie;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FirefoxDriver
implements WebDriver,
SearchContext,
JavascriptExecutor,
FindsById,
FindsByClassName,
FindsByLinkText,
FindsByXPath {
    public static final String DEFAULT_PROFILE = "WebDriver";
    public static final int DEFAULT_PORT = 7055;
    private final ExtensionConnection extension;
    protected Context context;

    public FirefoxDriver() {
        this(FirefoxDriver.getProfileName(), 7055);
    }

    public FirefoxDriver(String profileName) {
        this(FirefoxDriver.findProfile(profileName), 7055);
    }

    public FirefoxDriver(String profileName, int port) {
        this(FirefoxDriver.findProfile(profileName), port);
    }

    public FirefoxDriver(File profileDir) {
        this(profileDir, 7055);
    }

    public FirefoxDriver(File profileDir, int port) {
        this(new FirefoxProfile(profileDir), port);
    }

    public FirefoxDriver(FirefoxProfile profile) {
        this(profile, 7055);
    }

    public FirefoxDriver(FirefoxProfile profile, int port) {
        if (profile == null) {
            profile = new FirefoxProfile();
        }
        try {
            profile.init();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.prepareEnvironment();
        this.extension = this.connectTo(profile, "localhost", port);
        if (!this.extension.isConnected()) {
            throw new RuntimeException("Unable to connect to Firefox. Is the WebDriver extension installed, and is there a profile called WebDriver?" + OperatingSystem.getCurrentPlatform().getLineEnding() + "To set up a profile for WebDriver, simply start firefox from the command line with the \"ProfileManager\" switch" + OperatingSystem.getCurrentPlatform().getLineEnding() + "This will look like: firefox -ProfileManager. Alternatively, use the FirefoxLauncher support class from this project");
        }
        this.fixId();
    }

    private FirefoxDriver(ExtensionConnection extension, Context context) {
        this.extension = extension;
        this.context = context;
    }

    private static String getProfileName() {
        return System.getProperty("webdriver.firefox.profile", DEFAULT_PROFILE);
    }

    private static FirefoxProfile findProfile(String profileName) {
        return new ProfilesIni().getProfile(profileName);
    }

    protected ExtensionConnection connectTo(FirefoxProfile profile, String host, int port) {
        return ExtensionConnectionFactory.connectTo(profile, host, port);
    }

    protected void prepareEnvironment() {
    }

    public void close() {
        try {
            this.sendMessage(RuntimeException.class, "close", new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getPageSource() {
        return this.sendMessage(RuntimeException.class, "getPageSource", new Object[0]);
    }

    public void get(String url) {
        this.sendMessage(RuntimeException.class, "get", url);
    }

    public String getCurrentUrl() {
        return this.sendMessage(RuntimeException.class, "getCurrentUrl", new Object[0]);
    }

    public String getTitle() {
        return this.sendMessage(RuntimeException.class, "title", new Object[0]);
    }

    public boolean getVisible() {
        return true;
    }

    public List<WebElement> findElements(By by) {
        return by.findElements((SearchContext)this);
    }

    public WebElement findElement(By by) {
        return by.findElement((SearchContext)this);
    }

    public WebElement findElementById(String using) {
        return this.findElement("selectElementById", using);
    }

    public List<WebElement> findElementsById(String using) {
        throw new UnsupportedOperationException("findElementsById");
    }

    public List<WebElement> findElementsByLinkText(String using) {
        throw new UnsupportedOperationException("findElementsByLinkText");
    }

    public List<WebElement> findElementsByXPath(String using) {
        return this.findElements("selectElementsUsingXPath", using);
    }

    public List<WebElement> findElementsByClassName(String using) {
        return this.findElements("selectElementsUsingClassName", using);
    }

    public WebElement findElementByClassName(String using) {
        return this.findElement("selectElementUsingClassName", using);
    }

    public WebElement findElementByLinkText(String using) {
        return this.findElement("selectElementUsingLink", using);
    }

    public WebElement findElementByXPath(String using) {
        return this.findElement("selectElementUsingXPath", using);
    }

    private WebElement findElement(String commandName, String argument) {
        String elementId = this.sendMessage(NoSuchElementException.class, commandName, argument);
        return new FirefoxWebElement(this, elementId);
    }

    private List<WebElement> findElements(String commandName, String argument) {
        String[] ids;
        String returnedIds = this.sendMessage(RuntimeException.class, commandName, argument);
        ArrayList<WebElement> elements = new ArrayList<WebElement>();
        if (returnedIds.length() == 0) {
            return elements;
        }
        for (String id : ids = returnedIds.split(",")) {
            elements.add((WebElement)new FirefoxWebElement(this, id));
        }
        return elements;
    }

    public void setVisible(boolean visible) {
    }

    public WebDriver.TargetLocator switchTo() {
        return new FirefoxTargetLocator();
    }

    public WebDriver.Navigation navigate() {
        return new FirefoxNavigation();
    }

    protected WebDriver findActiveDriver() {
        String response = this.sendMessage(RuntimeException.class, "findActiveDriver", new Object[0]);
        Context newContext = new Context(response);
        if (newContext.getDriverId().equals(newContext.getDriverId())) {
            return this;
        }
        return new FirefoxDriver(this.extension, newContext);
    }

    private String sendMessage(Class<? extends RuntimeException> throwOnFailure, String methodName, Object ... parameters) {
        return this.sendMessage(throwOnFailure, new Command(this.context, methodName, parameters));
    }

    protected String sendMessage(Class<? extends RuntimeException> throwOnFailure, Command command) {
        Response response = this.extension.sendMessageAndWaitForResponse(throwOnFailure, command);
        this.context = response.getContext();
        response.ifNecessaryThrow(throwOnFailure);
        return response.getResponseText();
    }

    private void fixId() {
        String response = this.sendMessage(RuntimeException.class, "findActiveDriver", new Object[0]);
        this.context = new Context(response);
    }

    public void quit() {
        this.extension.quit();
    }

    public Object executeScript(String script, Object ... args) {
        script = script.replaceAll("\"", "\\\"");
        Object[] convertedArgs = this.convertToJsObjects(args);
        Command command = new Command(this.context, null, "executeScript", script, convertedArgs);
        Response response = this.extension.sendMessageAndWaitForResponse(RuntimeException.class, command);
        this.context = response.getContext();
        response.ifNecessaryThrow(RuntimeException.class);
        if ("NULL".equals(response.getExtraResult("resultType"))) {
            return null;
        }
        String resultType = (String)response.getExtraResult("resultType");
        if ("ELEMENT".equals(resultType)) {
            return new FirefoxWebElement(this, response.getResponseText());
        }
        Object result = response.getExtraResult("response");
        if (result instanceof Integer) {
            return new Long(response.getResponseText());
        }
        return result;
    }

    private Object[] convertToJsObjects(Object[] args) {
        if (args.length == 0) {
            return null;
        }
        Object[] converted = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            converted[i] = this.convertToJsObject(args[i]);
        }
        return converted;
    }

    private Object convertToJsObject(Object arg) {
        HashMap<String, Object> converted = new HashMap<String, Object>();
        if (arg instanceof String) {
            converted.put("type", "STRING");
            converted.put("value", arg);
        } else if (arg instanceof Number) {
            converted.put("type", "NUMBER");
            converted.put("value", ((Number)arg).longValue());
        } else if (this.isPrimitiveNumberType(arg)) {
            converted.put("type", "NUMBER");
            converted.put("value", this.getPrimitiveTypeAsLong(arg));
        } else if (arg instanceof Boolean) {
            converted.put("type", "BOOLEAN");
            converted.put("value", (Boolean)arg);
        } else if (arg.getClass() == Boolean.TYPE) {
            converted.put("type", "BOOLEAN");
            converted.put("value", arg);
        } else if (arg instanceof FirefoxWebElement) {
            converted.put("type", "ELEMENT");
            converted.put("value", ((FirefoxWebElement)arg).getElementId());
        } else {
            throw new IllegalArgumentException("Argument is of an illegal type: " + arg);
        }
        return converted;
    }

    private Long getPrimitiveTypeAsLong(Object arg) {
        return Long.valueOf(String.valueOf(arg));
    }

    private boolean isPrimitiveNumberType(Object arg) {
        if (!arg.getClass().isPrimitive()) {
            return false;
        }
        return arg.getClass() == Long.TYPE || arg.getClass() == Integer.TYPE || arg.getClass() == Short.TYPE;
    }

    public WebDriver.Options manage() {
        return new FirefoxOptions();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FirefoxDriverIterator
    implements Iterator<WebDriver> {
        private String[] allHandles;
        private int index = 0;

        public FirefoxDriverIterator(String handlesString) {
            this.allHandles = handlesString.split(",");
        }

        @Override
        public boolean hasNext() {
            return this.allHandles.length > this.index;
        }

        @Override
        public WebDriver next() {
            return new FirefoxDriver(FirefoxDriver.this.extension, new Context(this.allHandles[this.index++] + " ?"));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }

    private class FirefoxNavigation
    implements WebDriver.Navigation {
        private FirefoxNavigation() {
        }

        public void back() {
            FirefoxDriver.this.sendMessage(RuntimeException.class, "goBack", new Object[0]);
        }

        public void forward() {
            FirefoxDriver.this.sendMessage(RuntimeException.class, "goForward", new Object[0]);
        }

        public void to(String url) {
            FirefoxDriver.this.get(url);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FirefoxTargetLocator
    implements WebDriver.TargetLocator {
        private FirefoxTargetLocator() {
        }

        public WebDriver frame(int frameIndex) {
            return this.frame(String.valueOf(frameIndex));
        }

        public WebDriver frame(String frameName) {
            FirefoxDriver.this.sendMessage(NoSuchFrameException.class, "switchToFrame", new Object[]{frameName});
            return FirefoxDriver.this;
        }

        public WebDriver window(String windowName) {
            String response = FirefoxDriver.this.sendMessage(RuntimeException.class, "switchToWindow", new Object[]{String.valueOf(windowName)});
            if (response == null || "No window found".equals(response)) {
                return null;
            }
            try {
                FirefoxDriver.this.context = new Context(response);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("When switching to window: " + windowName + " ---- " + response);
            }
            return FirefoxDriver.this;
        }

        public Iterable<WebDriver> windowIterable() {
            final String handles = FirefoxDriver.this.sendMessage(RuntimeException.class, "getAllWindowHandles", new Object[0]);
            return new Iterable<WebDriver>(){

                @Override
                public Iterator<WebDriver> iterator() {
                    return new FirefoxDriverIterator(handles);
                }
            };
        }

        public WebDriver defaultContent() {
            FirefoxDriver.this.sendMessage(RuntimeException.class, "switchToDefaultContent", new Object[0]);
            return FirefoxDriver.this;
        }

        public WebElement activeElement() {
            return FirefoxDriver.this.findElement("switchToActiveElement", "active element");
        }

        public Alert alert() {
            throw new UnsupportedOperationException("alert");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FirefoxOptions
    implements WebDriver.Options {
        private final List<String> fieldNames = Arrays.asList("domain", "expiry", "name", "path", "value", "secure");
        private final DateFormat RFC_1123_DATE_FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'Z", Locale.US);
        private final int SLOW_SPEED = 1;
        private final int MEDIUM_SPEED = 10;
        private final int FAST_SPEED = 100;

        private FirefoxOptions() {
        }

        public void addCookie(Cookie cookie) {
            FirefoxDriver.this.sendMessage(RuntimeException.class, "addCookie", new Object[]{this.convertToJson(cookie)});
        }

        private String convertToJson(Cookie cookie) {
            PropertyDescriptor[] properties;
            BeanInfo info;
            JSONObject json = new JSONObject();
            try {
                info = Introspector.getBeanInfo(Cookie.class);
            }
            catch (IntrospectionException e) {
                throw new RuntimeException(e);
            }
            for (PropertyDescriptor property : properties = info.getPropertyDescriptors()) {
                if (!this.fieldNames.contains(property.getName())) continue;
                try {
                    Object result = property.getReadMethod().invoke((Object)cookie, new Object[0]);
                    json.put(property.getName(), result);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            if (cookie.getExpiry() != null) {
                try {
                    json.put("expiry", (Object)this.RFC_1123_DATE_FORMAT.format(cookie.getExpiry()));
                }
                catch (JSONException e) {
                    throw new RuntimeException(e);
                }
            }
            return json.toString();
        }

        public Set<Cookie> getCookies() {
            String response = FirefoxDriver.this.sendMessage(RuntimeException.class, "getCookie", new Object[0]).trim();
            HashSet<Cookie> cookies = new HashSet<Cookie>();
            if (!"".equals(response)) {
                for (String cookieString : response.split("\n")) {
                    HashMap<String, String> attributesMap = new HashMap<String, String>();
                    attributesMap.put("name", "");
                    attributesMap.put("value", "");
                    attributesMap.put("domain", "");
                    attributesMap.put("path", "");
                    attributesMap.put("expires", "");
                    attributesMap.put("secure", "false");
                    for (String attribute : cookieString.split(";")) {
                        if (attribute.contains("=")) {
                            String[] tokens = attribute.trim().split("=");
                            if (((String)attributesMap.get("name")).equals("")) {
                                attributesMap.put("name", tokens[0]);
                                attributesMap.put("value", tokens[1]);
                                continue;
                            }
                            if ("domain".equals(tokens[0]) && tokens[1].trim().startsWith(".")) {
                                int offset = tokens[1].indexOf(".") + 1;
                                attributesMap.put("domain", tokens[1].substring(offset));
                                continue;
                            }
                            if (tokens.length <= 1) continue;
                            attributesMap.put(tokens[0], tokens[1]);
                            continue;
                        }
                        if (!attribute.equals("secure")) continue;
                        attributesMap.put("secure", "true");
                    }
                    Date expires = null;
                    if (!((String)attributesMap.get("expires")).equals("0")) {
                        expires = new Date(Long.parseLong((String)attributesMap.get("expires")));
                    }
                    cookies.add((Cookie)new ReturnedCookie((String)attributesMap.get("name"), (String)attributesMap.get("value"), (String)attributesMap.get("domain"), (String)attributesMap.get("path"), expires, Boolean.parseBoolean((String)attributesMap.get("secure"))));
                }
            }
            return cookies;
        }

        public void deleteCookieNamed(String name) {
            Cookie toDelete = new Cookie(name, "");
            FirefoxDriver.this.sendMessage(RuntimeException.class, "deleteCookie", new Object[]{this.convertToJson(toDelete)});
        }

        public void deleteCookie(Cookie cookie) {
            FirefoxDriver.this.sendMessage(RuntimeException.class, "deleteCookie", new Object[]{this.convertToJson(cookie)});
        }

        public void deleteAllCookies() {
            Set<Cookie> cookies = this.getCookies();
            for (Cookie c : cookies) {
                this.deleteCookie(c);
            }
        }

        public Speed getSpeed() {
            Speed speed;
            int pixelSpeed = Integer.parseInt(FirefoxDriver.this.sendMessage(RuntimeException.class, "getMouseSpeed", new Object[0]));
            switch (pixelSpeed) {
                case 1: {
                    speed = Speed.SLOW;
                    break;
                }
                case 10: {
                    speed = Speed.MEDIUM;
                    break;
                }
                case 100: {
                    speed = Speed.FAST;
                    break;
                }
                default: {
                    speed = Speed.FAST;
                }
            }
            return speed;
        }

        public void setSpeed(Speed speed) {
            int pixelSpeed;
            switch (speed) {
                case SLOW: {
                    pixelSpeed = 1;
                    break;
                }
                case MEDIUM: {
                    pixelSpeed = 10;
                    break;
                }
                case FAST: {
                    pixelSpeed = 100;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            FirefoxDriver.this.sendMessage(RuntimeException.class, "setMouseSpeed", new Object[]{"" + pixelSpeed});
        }
    }
}

