/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox.internal;

import java.io.IOException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.firefox.ExtensionConnection;
import org.openqa.selenium.firefox.FirefoxBinary;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.firefox.NotConnectedException;
import org.openqa.selenium.firefox.internal.NewProfileExtensionConnection;
import org.openqa.selenium.firefox.internal.RunningInstanceConnection;
import org.openqa.selenium.firefox.internal.SocketLock;

public class ExtensionConnectionFactory {
    public static ExtensionConnection connectTo(FirefoxBinary binary, FirefoxProfile profile, String host) {
        int profilePort = profile.getPort();
        boolean isDev = Boolean.getBoolean("webdriver.firefox.useExisting");
        if (isDev) {
            try {
                return new RunningInstanceConnection(host, profilePort);
            }
            catch (NotConnectedException e) {
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        try {
            SocketLock lock = new SocketLock(profilePort - 1);
            return new NewProfileExtensionConnection(lock, binary, profile, host);
        }
        catch (Exception e) {
            throw new WebDriverException((Throwable)e);
        }
    }
}

