/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.ie;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.Speed;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.ie.Finder;
import org.openqa.selenium.ie.InternetExplorerElement;
import org.openqa.selenium.internal.ReturnedCookie;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternetExplorerDriver
implements WebDriver,
SearchContext,
JavascriptExecutor {
    private long iePointer;
    private static boolean comStarted;

    public InternetExplorerDriver() {
        this.startCom();
        this.openIe();
    }

    private InternetExplorerDriver(long iePointer) {
        this.iePointer = iePointer;
    }

    public String getPageSource() {
        throw new UnsupportedOperationException("getPageSource");
    }

    public native void close();

    public void quit() {
        this.close();
    }

    private native Object doExecuteScript(String var1, Object[] var2);

    public Object executeScript(String script, Object ... args) {
        for (Object arg : args) {
            if (arg instanceof String || arg instanceof Boolean || arg instanceof Number || arg instanceof InternetExplorerElement) continue;
            throw new IllegalArgumentException("Parameter is not of recognized type: " + arg);
        }
        script = script.replace("\"", "\\\"");
        script = "(function() { return function(){" + script + "};})();";
        return this.doExecuteScript(script, args);
    }

    public native void get(String var1);

    public native String getCurrentUrl();

    public native String getTitle();

    public native boolean getVisible();

    public native void setVisible(boolean var1);

    public List<WebElement> findElements(By by) {
        return new Finder(this.iePointer, 0L).findElements(by);
    }

    public WebElement findElement(By by) {
        return new Finder(this.iePointer, 0L).findElement(by);
    }

    public String toString() {
        return this.getClass().getName() + ":" + this.iePointer;
    }

    public WebDriver.TargetLocator switchTo() {
        return new InternetExplorerTargetLocator();
    }

    public WebDriver.Navigation navigate() {
        return new InternetExplorerNavigation();
    }

    public WebDriver.Options manage() {
        return new InternetExplorerOptions();
    }

    protected native void waitForLoadToComplete();

    private void startCom() {
        if (!comStarted) {
            this.loadLibrary();
            this.startComNatively();
            comStarted = true;
        }
    }

    private void loadLibrary() {
        try {
            System.loadLibrary("InternetExplorerDriver");
        }
        catch (UnsatisfiedLinkError e) {
            File dll = this.writeResourceToDisk("InternetExplorerDriver.dll");
            System.load(dll.getAbsolutePath());
        }
    }

    private File writeResourceToDisk(String resourceName) throws UnsatisfiedLinkError {
        InputStream is = InternetExplorerDriver.class.getResourceAsStream(resourceName);
        if (is == null) {
            is = InternetExplorerDriver.class.getResourceAsStream("/" + resourceName);
        }
        FileOutputStream fos = null;
        try {
            int count;
            File dll = File.createTempFile("webdriver", null);
            dll.deleteOnExit();
            fos = new FileOutputStream(dll);
            byte[] buf = new byte[4096];
            while ((count = is.read(buf, 0, buf.length)) > 0) {
                fos.write(buf, 0, count);
            }
            File file = dll;
            return file;
        }
        catch (IOException e2) {
            throw new UnsatisfiedLinkError("Cannot create temporary DLL: " + e2.getMessage());
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e2) {}
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e2) {}
            }
        }
    }

    private native void startComNatively();

    private native void openIe();

    protected void finalize() throws Throwable {
        if (this.iePointer != 0L) {
            this.deleteStoredObject();
        }
    }

    private native void deleteStoredObject();

    private native void setFrameIndex(String var1);

    private native void goBack();

    private native void goForward();

    private native void doAddCookie(String var1);

    private native String doGetCookies();

    private native void doSetMouseSpeed(int var1);

    private native WebElement doSwitchToActiveElement();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InternetExplorerOptions
    implements WebDriver.Options {
        private InternetExplorerOptions() {
        }

        public void addCookie(Cookie cookie) {
            InternetExplorerDriver.this.doAddCookie(cookie.toString());
        }

        public void deleteAllCookies() {
            Set<Cookie> cookies = this.getCookies();
            for (Cookie cookie : cookies) {
                this.deleteCookie(cookie);
            }
        }

        public void deleteCookie(Cookie cookie) {
            Date dateInPast = new Date(0L);
            ReturnedCookie toDelete = new ReturnedCookie(cookie.getName(), cookie.getValue(), cookie.getDomain(), cookie.getPath(), dateInPast, false);
            this.addCookie((Cookie)toDelete);
        }

        public void deleteCookieNamed(String name) {
            this.deleteCookie((Cookie)new ReturnedCookie(name, "", this.getCurrentHost(), "", null, false));
        }

        public Set<Cookie> getCookies() {
            String[] cookies;
            String currentUrl = this.getCurrentHost();
            HashSet<Cookie> toReturn = new HashSet<Cookie>();
            String allDomainCookies = InternetExplorerDriver.this.doGetCookies();
            for (String cookie : cookies = allDomainCookies.split("; ")) {
                String[] parts = cookie.split("=");
                if (parts.length != 2) continue;
                toReturn.add((Cookie)new ReturnedCookie(parts[0], parts[1], currentUrl, "", null, false));
            }
            return toReturn;
        }

        private String getCurrentHost() {
            try {
                URL url = new URL(InternetExplorerDriver.this.getCurrentUrl());
                return url.getHost();
            }
            catch (MalformedURLException e) {
                return "";
            }
        }

        public Speed getSpeed() {
            throw new UnsupportedOperationException();
        }

        public void setSpeed(Speed speed) {
            InternetExplorerDriver.this.doSetMouseSpeed(speed.getTimeOut());
        }
    }

    private class InternetExplorerNavigation
    implements WebDriver.Navigation {
        private InternetExplorerNavigation() {
        }

        public void back() {
            InternetExplorerDriver.this.goBack();
        }

        public void forward() {
            InternetExplorerDriver.this.goForward();
        }

        public void to(String url) {
            InternetExplorerDriver.this.get(url);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InternetExplorerTargetLocator
    implements WebDriver.TargetLocator {
        private InternetExplorerTargetLocator() {
        }

        public WebDriver frame(int frameIndex) {
            return this.frame(String.valueOf(frameIndex));
        }

        public WebDriver frame(String frameName) {
            InternetExplorerDriver.this.setFrameIndex(frameName);
            return InternetExplorerDriver.this;
        }

        public WebDriver window(String windowName) {
            return null;
        }

        public Iterable<WebDriver> windowIterable() {
            throw new UnsupportedOperationException("windowIterable");
        }

        public WebDriver defaultContent() {
            return this.frame("");
        }

        public WebElement activeElement() {
            return InternetExplorerDriver.this.doSwitchToActiveElement();
        }

        public Alert alert() {
            throw new UnsupportedOperationException("alert");
        }
    }
}

