/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.parser.sparql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.query.algebra.And;
import org.openrdf.query.algebra.BNodeGenerator;
import org.openrdf.query.algebra.Bound;
import org.openrdf.query.algebra.Compare;
import org.openrdf.query.algebra.Datatype;
import org.openrdf.query.algebra.Distinct;
import org.openrdf.query.algebra.EmptySet;
import org.openrdf.query.algebra.Extension;
import org.openrdf.query.algebra.ExtensionElem;
import org.openrdf.query.algebra.Filter;
import org.openrdf.query.algebra.FunctionCall;
import org.openrdf.query.algebra.IsBNode;
import org.openrdf.query.algebra.IsLiteral;
import org.openrdf.query.algebra.IsURI;
import org.openrdf.query.algebra.Join;
import org.openrdf.query.algebra.Lang;
import org.openrdf.query.algebra.LangMatches;
import org.openrdf.query.algebra.LeftJoin;
import org.openrdf.query.algebra.MathExpr;
import org.openrdf.query.algebra.MultiProjection;
import org.openrdf.query.algebra.Not;
import org.openrdf.query.algebra.Or;
import org.openrdf.query.algebra.Order;
import org.openrdf.query.algebra.OrderElem;
import org.openrdf.query.algebra.Projection;
import org.openrdf.query.algebra.ProjectionElem;
import org.openrdf.query.algebra.ProjectionElemList;
import org.openrdf.query.algebra.QueryModelNode;
import org.openrdf.query.algebra.Regex;
import org.openrdf.query.algebra.SameTerm;
import org.openrdf.query.algebra.Slice;
import org.openrdf.query.algebra.StatementPattern;
import org.openrdf.query.algebra.Str;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.Union;
import org.openrdf.query.algebra.ValueConstant;
import org.openrdf.query.algebra.ValueExpr;
import org.openrdf.query.algebra.Var;
import org.openrdf.query.algebra.helpers.StatementPatternCollector;
import org.openrdf.query.parser.sparql.ASTVisitorBase;
import org.openrdf.query.parser.sparql.GraphPattern;
import org.openrdf.query.parser.sparql.ast.ASTAnd;
import org.openrdf.query.parser.sparql.ast.ASTAskQuery;
import org.openrdf.query.parser.sparql.ast.ASTBlankNode;
import org.openrdf.query.parser.sparql.ast.ASTBlankNodePropertyList;
import org.openrdf.query.parser.sparql.ast.ASTBound;
import org.openrdf.query.parser.sparql.ast.ASTCollection;
import org.openrdf.query.parser.sparql.ast.ASTCompare;
import org.openrdf.query.parser.sparql.ast.ASTConstraint;
import org.openrdf.query.parser.sparql.ast.ASTConstruct;
import org.openrdf.query.parser.sparql.ast.ASTConstructQuery;
import org.openrdf.query.parser.sparql.ast.ASTDatatype;
import org.openrdf.query.parser.sparql.ast.ASTDescribe;
import org.openrdf.query.parser.sparql.ast.ASTDescribeQuery;
import org.openrdf.query.parser.sparql.ast.ASTFalse;
import org.openrdf.query.parser.sparql.ast.ASTFunctionCall;
import org.openrdf.query.parser.sparql.ast.ASTGraphGraphPattern;
import org.openrdf.query.parser.sparql.ast.ASTGraphPatternGroup;
import org.openrdf.query.parser.sparql.ast.ASTIRI;
import org.openrdf.query.parser.sparql.ast.ASTIsBlank;
import org.openrdf.query.parser.sparql.ast.ASTIsIRI;
import org.openrdf.query.parser.sparql.ast.ASTIsLiteral;
import org.openrdf.query.parser.sparql.ast.ASTLang;
import org.openrdf.query.parser.sparql.ast.ASTLangMatches;
import org.openrdf.query.parser.sparql.ast.ASTLimit;
import org.openrdf.query.parser.sparql.ast.ASTMath;
import org.openrdf.query.parser.sparql.ast.ASTNot;
import org.openrdf.query.parser.sparql.ast.ASTNumericLiteral;
import org.openrdf.query.parser.sparql.ast.ASTObjectList;
import org.openrdf.query.parser.sparql.ast.ASTOffset;
import org.openrdf.query.parser.sparql.ast.ASTOptionalGraphPattern;
import org.openrdf.query.parser.sparql.ast.ASTOr;
import org.openrdf.query.parser.sparql.ast.ASTOrderClause;
import org.openrdf.query.parser.sparql.ast.ASTOrderCondition;
import org.openrdf.query.parser.sparql.ast.ASTPropertyList;
import org.openrdf.query.parser.sparql.ast.ASTQName;
import org.openrdf.query.parser.sparql.ast.ASTQueryContainer;
import org.openrdf.query.parser.sparql.ast.ASTRDFLiteral;
import org.openrdf.query.parser.sparql.ast.ASTRegexExpression;
import org.openrdf.query.parser.sparql.ast.ASTSameTerm;
import org.openrdf.query.parser.sparql.ast.ASTSelect;
import org.openrdf.query.parser.sparql.ast.ASTSelectQuery;
import org.openrdf.query.parser.sparql.ast.ASTStr;
import org.openrdf.query.parser.sparql.ast.ASTString;
import org.openrdf.query.parser.sparql.ast.ASTTrue;
import org.openrdf.query.parser.sparql.ast.ASTUnionGraphPattern;
import org.openrdf.query.parser.sparql.ast.ASTVar;
import org.openrdf.query.parser.sparql.ast.Node;
import org.openrdf.query.parser.sparql.ast.VisitorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TupleExprBuilder
extends ASTVisitorBase {
    private ValueFactory valueFactory;
    private GraphPattern graphPattern;
    private int constantVarID = 1;

    public TupleExprBuilder(ValueFactory valueFactory) {
        this.valueFactory = valueFactory;
    }

    private Var valueExpr2Var(ValueExpr valueExpr) {
        if (valueExpr instanceof Var) {
            return (Var)valueExpr;
        }
        if (valueExpr instanceof ValueConstant) {
            return this.createConstVar(((ValueConstant)valueExpr).getValue());
        }
        if (valueExpr == null) {
            throw new IllegalArgumentException("valueExpr is null");
        }
        throw new IllegalArgumentException("valueExpr is a: " + valueExpr.getClass());
    }

    private Var createConstVar(Value value) {
        Var var = this.createAnonVar("-const-" + this.constantVarID++);
        var.setValue(value);
        return var;
    }

    private Var createAnonVar(String varName) {
        Var var = new Var(varName);
        var.setAnonymous(true);
        return var;
    }

    public TupleExpr visit(ASTQueryContainer node, Object data) throws VisitorException {
        return (TupleExpr)node.getQuery().jjtAccept(this, null);
    }

    public TupleExpr visit(ASTSelectQuery node, Object data) throws VisitorException {
        this.graphPattern = new GraphPattern();
        node.getWhereClause().jjtAccept(this, null);
        TupleExpr tupleExpr = this.graphPattern.buildTupleExpr();
        ASTOrderClause orderNode = node.getOrderClause();
        if (orderNode != null) {
            List orderElemements = (List)orderNode.jjtAccept(this, null);
            tupleExpr = new Order(tupleExpr, (Iterable)orderElemements);
        }
        tupleExpr = (TupleExpr)node.getSelect().jjtAccept(this, tupleExpr);
        ASTLimit limitNode = node.getLimit();
        int limit = -1;
        if (limitNode != null) {
            limit = (Integer)limitNode.jjtAccept(this, null);
        }
        ASTOffset offsetNode = node.getOffset();
        int offset = -1;
        if (offsetNode != null) {
            offset = (Integer)offsetNode.jjtAccept(this, null);
        }
        if (offset >= 1 || limit >= 0) {
            tupleExpr = new Slice(tupleExpr, offset, limit);
        }
        return tupleExpr;
    }

    public TupleExpr visit(ASTSelect node, Object data) throws VisitorException {
        TupleExpr result = (TupleExpr)data;
        ProjectionElemList projElemList = new ProjectionElemList();
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            Var projVar = (Var)node.jjtGetChild(i).jjtAccept(this, null);
            projElemList.addElement(new ProjectionElem(projVar.getName()));
        }
        result = new Projection(result, projElemList);
        if (node.isDistinct()) {
            result = new Distinct(result);
        }
        return result;
    }

    public TupleExpr visit(ASTConstructQuery node, Object data) throws VisitorException {
        this.graphPattern = new GraphPattern();
        node.getWhereClause().jjtAccept(this, null);
        TupleExpr tupleExpr = this.graphPattern.buildTupleExpr();
        ASTOrderClause orderNode = node.getOrderClause();
        if (orderNode != null) {
            List orderElemements = (List)orderNode.jjtAccept(this, null);
            tupleExpr = new Order(tupleExpr, (Iterable)orderElemements);
        }
        tupleExpr = (TupleExpr)node.getConstruct().jjtAccept(this, tupleExpr);
        ASTLimit limitNode = node.getLimit();
        int limit = -1;
        if (limitNode != null) {
            limit = (Integer)limitNode.jjtAccept(this, null);
        }
        ASTOffset offsetNode = node.getOffset();
        int offset = -1;
        if (offsetNode != null) {
            offset = (Integer)offsetNode.jjtAccept(this, null);
        }
        if (offset >= 1 || limit >= 0) {
            tupleExpr = new Slice(tupleExpr, offset, limit);
        }
        return tupleExpr;
    }

    public TupleExpr visit(ASTConstruct node, Object data) throws VisitorException {
        Object result = (TupleExpr)data;
        this.graphPattern = new GraphPattern();
        super.visit(node, null);
        TupleExpr constructExpr = this.graphPattern.buildTupleExpr();
        List statementPatterns = StatementPatternCollector.process((QueryModelNode)constructExpr);
        Set<Var> constructVars = this.getConstructVars(statementPatterns);
        HashMap<Var, ExtensionElem> extElemMap = new HashMap<Var, ExtensionElem>();
        for (Var var : constructVars) {
            if (!var.isAnonymous() || extElemMap.containsKey(var)) continue;
            Object valueExpr = var.hasValue() ? new ValueConstant(var.getValue()) : new BNodeGenerator();
            extElemMap.put(var, new ExtensionElem((ValueExpr)valueExpr, var.getName()));
        }
        if (!extElemMap.isEmpty()) {
            result = new Extension(result, extElemMap.values());
        }
        ArrayList<ProjectionElemList> projList = new ArrayList<ProjectionElemList>();
        for (StatementPattern sp : statementPatterns) {
            ProjectionElemList projElemList = new ProjectionElemList();
            projElemList.addElement(new ProjectionElem(sp.getSubjectVar().getName(), "subject"));
            projElemList.addElement(new ProjectionElem(sp.getPredicateVar().getName(), "predicate"));
            projElemList.addElement(new ProjectionElem(sp.getObjectVar().getName(), "object"));
            projList.add(projElemList);
        }
        result = projList.size() == 1 ? new Projection(result, (ProjectionElemList)projList.get(0)) : (projList.size() > 1 ? new MultiProjection(result, projList) : new EmptySet());
        return result;
    }

    private Set<Var> getConstructVars(Collection<StatementPattern> statementPatterns) {
        LinkedHashSet<Var> vars = new LinkedHashSet<Var>(statementPatterns.size() * 2);
        for (StatementPattern sp : statementPatterns) {
            vars.add(sp.getSubjectVar());
            vars.add(sp.getPredicateVar());
            vars.add(sp.getObjectVar());
        }
        return vars;
    }

    public TupleExpr visit(ASTDescribeQuery node, Object data) throws VisitorException {
        TupleExpr tupleExpr = null;
        if (node.getWhereClause() != null) {
            this.graphPattern = new GraphPattern();
            node.getWhereClause().jjtAccept(this, null);
            tupleExpr = this.graphPattern.buildTupleExpr();
            ASTOrderClause orderNode = node.getOrderClause();
            if (orderNode != null) {
                List orderElemements = (List)orderNode.jjtAccept(this, null);
                tupleExpr = new Order(tupleExpr, (Iterable)orderElemements);
            }
            ASTLimit limitNode = node.getLimit();
            int limit = -1;
            if (limitNode != null) {
                limit = (Integer)limitNode.jjtAccept(this, null);
            }
            ASTOffset offsetNode = node.getOffset();
            int offset = -1;
            if (offsetNode != null) {
                offset = (Integer)offsetNode.jjtAccept(this, null);
            }
            if (offset >= 1 || limit >= 0) {
                tupleExpr = new Slice(tupleExpr, offset, limit);
            }
        }
        return (TupleExpr)node.getDescribe().jjtAccept(this, tupleExpr);
    }

    public TupleExpr visit(ASTDescribe node, Object data) throws VisitorException {
        Object result = (TupleExpr)data;
        Var subjVar = this.createAnonVar("-descr-subj");
        Var predVar = this.createAnonVar("-descr-pred");
        Var objVar = this.createAnonVar("-descr-obj");
        StatementPattern sp = new StatementPattern(subjVar, predVar, objVar);
        result = result == null ? sp : new Join(result, (TupleExpr)sp);
        ArrayList<SameTerm> sameTerms = new ArrayList<SameTerm>(2 * node.jjtGetNumChildren());
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            ValueExpr resource = (ValueExpr)node.jjtGetChild(i).jjtAccept(this, null);
            sameTerms.add(new SameTerm((ValueExpr)subjVar.clone(), resource));
            sameTerms.add(new SameTerm((ValueExpr)objVar.clone(), resource));
        }
        ValueExpr constraint = (ValueExpr)sameTerms.get(0);
        for (int i = 0; i < sameTerms.size(); ++i) {
            constraint = new Or(constraint, (ValueExpr)sameTerms.get(i));
        }
        result = new Filter(result, constraint);
        ProjectionElemList projElemList = new ProjectionElemList();
        projElemList.addElement(new ProjectionElem(subjVar.getName(), "subject"));
        projElemList.addElement(new ProjectionElem(predVar.getName(), "predicate"));
        projElemList.addElement(new ProjectionElem(objVar.getName(), "object"));
        result = new Projection(result, projElemList);
        return result;
    }

    public TupleExpr visit(ASTAskQuery node, Object data) throws VisitorException {
        this.graphPattern = new GraphPattern();
        super.visit(node, null);
        TupleExpr tupleExpr = this.graphPattern.buildTupleExpr();
        tupleExpr = new Slice(tupleExpr, 0, 1);
        return tupleExpr;
    }

    @Override
    public List<OrderElem> visit(ASTOrderClause node, Object data) throws VisitorException {
        int childCount = node.jjtGetNumChildren();
        ArrayList<OrderElem> elements = new ArrayList<OrderElem>(childCount);
        for (int i = 0; i < childCount; ++i) {
            elements.add((OrderElem)node.jjtGetChild(i).jjtAccept(this, null));
        }
        return elements;
    }

    public OrderElem visit(ASTOrderCondition node, Object data) throws VisitorException {
        ValueExpr valueExpr = (ValueExpr)node.jjtGetChild(0).jjtAccept(this, null);
        return new OrderElem(valueExpr, node.isAscending());
    }

    @Override
    public Integer visit(ASTLimit node, Object data) throws VisitorException {
        return node.getValue();
    }

    @Override
    public Integer visit(ASTOffset node, Object data) throws VisitorException {
        return node.getValue();
    }

    @Override
    public Object visit(ASTGraphPatternGroup node, Object data) throws VisitorException {
        GraphPattern parentGP = this.graphPattern;
        this.graphPattern = new GraphPattern(parentGP);
        super.visit(node, null);
        parentGP.addRequiredTE(this.graphPattern.buildTupleExpr());
        this.graphPattern = parentGP;
        return null;
    }

    @Override
    public Object visit(ASTOptionalGraphPattern node, Object data) throws VisitorException {
        LeftJoin leftJoin;
        GraphPattern parentGP = this.graphPattern;
        this.graphPattern = new GraphPattern(parentGP);
        super.visit(node, null);
        List<ValueExpr> constraints = this.graphPattern.removeAllConstraints();
        TupleExpr leftArg = parentGP.buildTupleExpr();
        TupleExpr rightArg = this.graphPattern.buildTupleExpr();
        if (constraints.isEmpty()) {
            leftJoin = new LeftJoin(leftArg, rightArg);
        } else {
            ValueExpr constraint = constraints.get(0);
            for (int i = 1; i < constraints.size(); ++i) {
                constraint = new And(constraint, constraints.get(i));
            }
            leftJoin = new LeftJoin(leftArg, rightArg, constraint);
        }
        this.graphPattern = parentGP;
        this.graphPattern.clear();
        this.graphPattern.addRequiredTE((TupleExpr)leftJoin);
        return null;
    }

    @Override
    public Object visit(ASTGraphGraphPattern node, Object data) throws VisitorException {
        Var oldContext = this.graphPattern.getContextVar();
        StatementPattern.Scope oldScope = this.graphPattern.getStatementPatternScope();
        ValueExpr newContext = (ValueExpr)node.jjtGetChild(0).jjtAccept(this, null);
        this.graphPattern.setContextVar(this.valueExpr2Var(newContext));
        this.graphPattern.setStatementPatternScope(StatementPattern.Scope.NAMED_CONTEXTS);
        node.jjtGetChild(1).jjtAccept(this, null);
        this.graphPattern.setContextVar(oldContext);
        this.graphPattern.setStatementPatternScope(oldScope);
        return null;
    }

    @Override
    public Object visit(ASTUnionGraphPattern node, Object data) throws VisitorException {
        GraphPattern parentGP = this.graphPattern;
        this.graphPattern = new GraphPattern(parentGP);
        node.jjtGetChild(0).jjtAccept(this, null);
        TupleExpr leftArg = this.graphPattern.buildTupleExpr();
        this.graphPattern = new GraphPattern(parentGP);
        node.jjtGetChild(1).jjtAccept(this, null);
        TupleExpr rightArg = this.graphPattern.buildTupleExpr();
        parentGP.addRequiredTE((TupleExpr)new Union(leftArg, rightArg));
        this.graphPattern = parentGP;
        return null;
    }

    @Override
    public Object visit(ASTPropertyList propListNode, Object data) throws VisitorException {
        ValueExpr subject = (ValueExpr)data;
        ValueExpr predicate = (ValueExpr)propListNode.getVerb().jjtAccept(this, null);
        List objectList = (List)propListNode.getObjectList().jjtAccept(this, null);
        Var subjVar = this.valueExpr2Var(subject);
        Var predVar = this.valueExpr2Var(predicate);
        for (ValueExpr object : objectList) {
            Var objVar = this.valueExpr2Var(object);
            this.graphPattern.addRequiredSP(subjVar, predVar, objVar);
        }
        ASTPropertyList nextPropList = propListNode.getNextPropertyList();
        if (nextPropList != null) {
            nextPropList.jjtAccept(this, subject);
        }
        return null;
    }

    @Override
    public List<ValueExpr> visit(ASTObjectList node, Object data) throws VisitorException {
        int childCount = node.jjtGetNumChildren();
        ArrayList<ValueExpr> result = new ArrayList<ValueExpr>(childCount);
        for (int i = 0; i < childCount; ++i) {
            result.add((ValueExpr)node.jjtGetChild(i).jjtAccept(this, null));
        }
        return result;
    }

    public Var visit(ASTBlankNodePropertyList node, Object data) throws VisitorException {
        Var bnodeVar = this.createAnonVar(node.getVarName());
        super.visit(node, (Object)bnodeVar);
        return bnodeVar;
    }

    public Var visit(ASTCollection node, Object data) throws VisitorException {
        Var rootListVar;
        String listVarName = node.getVarName();
        Var listVar = rootListVar = this.createAnonVar(listVarName);
        int childCount = node.jjtGetNumChildren();
        for (int i = 0; i < childCount; ++i) {
            ValueExpr childValue = (ValueExpr)node.jjtGetChild(i).jjtAccept(this, null);
            Var childVar = this.valueExpr2Var(childValue);
            this.graphPattern.addRequiredSP(listVar, this.createConstVar((Value)RDF.FIRST), childVar);
            Var nextListVar = i == childCount - 1 ? this.createConstVar((Value)RDF.NIL) : this.createAnonVar(listVarName + "-" + (i + 1));
            this.graphPattern.addRequiredSP(listVar, this.createConstVar((Value)RDF.REST), nextListVar);
            listVar = nextListVar;
        }
        return rootListVar;
    }

    @Override
    public Object visit(ASTConstraint node, Object data) throws VisitorException {
        ValueExpr valueExpr = (ValueExpr)super.visit(node, null);
        this.graphPattern.addConstraint(valueExpr);
        return null;
    }

    public Or visit(ASTOr node, Object data) throws VisitorException {
        ValueExpr leftArg = (ValueExpr)node.jjtGetChild(0).jjtAccept(this, null);
        ValueExpr rightArg = (ValueExpr)node.jjtGetChild(1).jjtAccept(this, null);
        return new Or(leftArg, rightArg);
    }

    @Override
    public Object visit(ASTAnd node, Object data) throws VisitorException {
        ValueExpr leftArg = (ValueExpr)node.jjtGetChild(0).jjtAccept(this, null);
        ValueExpr rightArg = (ValueExpr)node.jjtGetChild(1).jjtAccept(this, null);
        return new And(leftArg, rightArg);
    }

    public Not visit(ASTNot node, Object data) throws VisitorException {
        ValueExpr arg = (ValueExpr)super.visit(node, null);
        return new Not(arg);
    }

    public Compare visit(ASTCompare node, Object data) throws VisitorException {
        ValueExpr leftArg = (ValueExpr)node.jjtGetChild(0).jjtAccept(this, null);
        ValueExpr rightArg = (ValueExpr)node.jjtGetChild(1).jjtAccept(this, null);
        return new Compare(leftArg, rightArg, node.getOperator());
    }

    public SameTerm visit(ASTSameTerm node, Object data) throws VisitorException {
        ValueExpr leftArg = (ValueExpr)node.jjtGetChild(0).jjtAccept(this, null);
        ValueExpr rightArg = (ValueExpr)node.jjtGetChild(1).jjtAccept(this, null);
        return new SameTerm(leftArg, rightArg);
    }

    public MathExpr visit(ASTMath node, Object data) throws VisitorException {
        ValueExpr leftArg = (ValueExpr)node.jjtGetChild(0).jjtAccept(this, null);
        ValueExpr rightArg = (ValueExpr)node.jjtGetChild(1).jjtAccept(this, null);
        return new MathExpr(leftArg, rightArg, node.getOperator());
    }

    @Override
    public Object visit(ASTFunctionCall node, Object data) throws VisitorException {
        ValueConstant uriNode = (ValueConstant)node.jjtGetChild(0).jjtAccept(this, null);
        URI functionURI = (URI)uriNode.getValue();
        FunctionCall functionCall = new FunctionCall(functionURI.toString(), new ValueExpr[0]);
        for (int i = 1; i < node.jjtGetNumChildren(); ++i) {
            Node argNode = node.jjtGetChild(i);
            functionCall.addArg((ValueExpr)argNode.jjtAccept(this, null));
        }
        return functionCall;
    }

    @Override
    public Object visit(ASTStr node, Object data) throws VisitorException {
        ValueExpr arg = (ValueExpr)node.jjtGetChild(0).jjtAccept(this, null);
        return new Str(arg);
    }

    public Lang visit(ASTLang node, Object data) throws VisitorException {
        ValueExpr arg = (ValueExpr)node.jjtGetChild(0).jjtAccept(this, null);
        return new Lang(arg);
    }

    public Datatype visit(ASTDatatype node, Object data) throws VisitorException {
        ValueExpr arg = (ValueExpr)node.jjtGetChild(0).jjtAccept(this, null);
        return new Datatype(arg);
    }

    @Override
    public Object visit(ASTLangMatches node, Object data) throws VisitorException {
        ValueExpr leftArg = (ValueExpr)node.jjtGetChild(0).jjtAccept(this, null);
        ValueExpr rightArg = (ValueExpr)node.jjtGetChild(1).jjtAccept(this, null);
        return new LangMatches(leftArg, rightArg);
    }

    public ValueExpr visit(ASTBound node, Object data) throws VisitorException {
        Var var = (Var)node.getArg().jjtAccept(this, null);
        return new Bound(var);
    }

    public IsURI visit(ASTIsIRI node, Object data) throws VisitorException {
        ValueExpr arg = (ValueExpr)node.jjtGetChild(0).jjtAccept(this, null);
        return new IsURI(arg);
    }

    public IsBNode visit(ASTIsBlank node, Object data) throws VisitorException {
        ValueExpr arg = (ValueExpr)node.jjtGetChild(0).jjtAccept(this, null);
        return new IsBNode(arg);
    }

    public IsLiteral visit(ASTIsLiteral node, Object data) throws VisitorException {
        ValueExpr arg = (ValueExpr)node.jjtGetChild(0).jjtAccept(this, null);
        return new IsLiteral(arg);
    }

    @Override
    public Object visit(ASTRegexExpression node, Object data) throws VisitorException {
        ValueExpr arg = (ValueExpr)node.jjtGetChild(0).jjtAccept(this, null);
        ValueExpr pattern = (ValueExpr)node.jjtGetChild(1).jjtAccept(this, null);
        ValueExpr flags = null;
        if (node.jjtGetNumChildren() > 2) {
            flags = (ValueExpr)node.jjtGetChild(2).jjtAccept(this, null);
        }
        return new Regex(arg, pattern, flags);
    }

    public Var visit(ASTVar node, Object data) throws VisitorException {
        Var var = new Var(node.getName());
        var.setAnonymous(node.isAnonymous());
        return var;
    }

    public ValueConstant visit(ASTIRI node, Object data) throws VisitorException {
        return new ValueConstant((Value)this.valueFactory.createURI(node.getValue()));
    }

    @Override
    public Object visit(ASTQName node, Object data) throws VisitorException {
        throw new VisitorException("QNames must be resolved before building the query model");
    }

    @Override
    public Object visit(ASTBlankNode node, Object data) throws VisitorException {
        throw new VisitorException("Blank nodes must be replaced with variables before building the query model");
    }

    public ValueConstant visit(ASTRDFLiteral node, Object data) throws VisitorException {
        Literal literal;
        String label = (String)node.getLabel().jjtAccept(this, null);
        String lang = node.getLang();
        ASTIRI datatypeNode = node.getDatatype();
        if (datatypeNode != null) {
            URI datatype = this.valueFactory.createURI(datatypeNode.getValue());
            literal = this.valueFactory.createLiteral(label, datatype);
        } else {
            literal = lang != null ? this.valueFactory.createLiteral(label, lang) : this.valueFactory.createLiteral(label);
        }
        return new ValueConstant((Value)literal);
    }

    public ValueConstant visit(ASTNumericLiteral node, Object data) throws VisitorException {
        Literal literal = this.valueFactory.createLiteral(node.getValue(), node.getDatatype());
        return new ValueConstant((Value)literal);
    }

    public ValueConstant visit(ASTTrue node, Object data) throws VisitorException {
        return new ValueConstant((Value)this.valueFactory.createLiteral(true));
    }

    public ValueConstant visit(ASTFalse node, Object data) throws VisitorException {
        return new ValueConstant((Value)this.valueFactory.createLiteral(false));
    }

    @Override
    public String visit(ASTString node, Object data) throws VisitorException {
        return node.getValue();
    }
}

