/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.parser.sparql;

import java.util.LinkedHashSet;
import java.util.Set;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.parser.sparql.ASTVisitorBase;
import org.openrdf.query.parser.sparql.ast.ASTDescribe;
import org.openrdf.query.parser.sparql.ast.ASTDescribeQuery;
import org.openrdf.query.parser.sparql.ast.ASTQuery;
import org.openrdf.query.parser.sparql.ast.ASTQueryContainer;
import org.openrdf.query.parser.sparql.ast.ASTSelect;
import org.openrdf.query.parser.sparql.ast.ASTSelectQuery;
import org.openrdf.query.parser.sparql.ast.ASTVar;
import org.openrdf.query.parser.sparql.ast.Node;
import org.openrdf.query.parser.sparql.ast.VisitorException;

class WildcardProjectionProcessor
extends ASTVisitorBase {
    WildcardProjectionProcessor() {
    }

    public static void process(ASTQueryContainer qc) throws MalformedQueryException {
        ASTDescribe describeNode;
        ASTQuery queryNode = qc.getQuery();
        if (queryNode instanceof ASTSelectQuery) {
            ASTSelect selectNode = ((ASTSelectQuery)queryNode).getSelect();
            if (selectNode.isWildcard()) {
                WildcardProjectionProcessor.addQueryVars(qc, selectNode);
                selectNode.setWildcard(false);
            }
        } else if (queryNode instanceof ASTDescribeQuery && (describeNode = ((ASTDescribeQuery)queryNode).getDescribe()).isWildcard()) {
            WildcardProjectionProcessor.addQueryVars(qc, describeNode);
            describeNode.setWildcard(false);
        }
    }

    private static void addQueryVars(ASTQueryContainer qc, Node wildcardNode) throws MalformedQueryException {
        QueryVariableCollector visitor = new QueryVariableCollector();
        try {
            qc.jjtAccept(visitor, null);
            for (String varName : visitor.getVariableNames()) {
                ASTVar varNode = new ASTVar(30);
                varNode.setName(varName);
                wildcardNode.jjtAppendChild(varNode);
                varNode.jjtSetParent(wildcardNode);
            }
        }
        catch (VisitorException e) {
            throw new MalformedQueryException((Throwable)e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class QueryVariableCollector
    extends ASTVisitorBase {
        private Set<String> variableNames = new LinkedHashSet<String>();

        private QueryVariableCollector() {
        }

        public Set<String> getVariableNames() {
            return this.variableNames;
        }

        @Override
        public Object visit(ASTVar node, Object data) throws VisitorException {
            if (!node.isAnonymous()) {
                this.variableNames.add(node.getName());
            }
            return super.visit(node, data);
        }
    }
}

