/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.text;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CronUtil {
    public static String cron2description(String cronExpr, String partSeparator) {
        try {
            StringTokenizer tokenizer = new StringTokenizer(cronExpr, " \t");
            String minutes = tokenizer.nextToken();
            String hours = tokenizer.nextToken();
            String daysofmonth = tokenizer.nextToken();
            String months = tokenizer.nextToken();
            String daysofweek = tokenizer.nextToken();
            String dayofweekPart = CronUtil.dayofweekSpec2description(daysofweek);
            String dayofmonthPart = CronUtil.dayofmonthSpec2description(daysofmonth);
            String monthPart = CronUtil.monthSpec2description(months);
            String minutePart = CronUtil.minuteSpec2description(minutes);
            String hourPart = CronUtil.hourSpec2description(hours);
            StringBuilder result = new StringBuilder(512);
            if (dayofweekPart != null && dayofweekPart.trim().length() > 0) {
                result.append(dayofweekPart).append(partSeparator);
            }
            if (dayofmonthPart != null && dayofmonthPart.trim().length() > 0) {
                result.append(dayofmonthPart).append(partSeparator);
            }
            if (monthPart != null && monthPart.trim().length() > 0) {
                result.append(monthPart).append(partSeparator);
            }
            result.append(minutePart).append(partSeparator);
            result.append(hourPart);
            return result.toString();
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    private static String dayofweekSpec2description(String dayofweekSpec) {
        List<Range> rangesList = CronUtil.getRangesList(dayofweekSpec);
        int rangeCount = rangesList.size();
        if (rangeCount == 1) {
            Range range = rangesList.get(0);
            if (range.isAny()) {
                return null;
            }
            if (range.isAll()) {
                return "every day of the week";
            }
        }
        StringBuilder result = new StringBuilder(64);
        result.append("on ");
        for (int i = 0; i < rangeCount - 2; ++i) {
            CronUtil.daysofweekrange2description(rangesList.get(i), result);
            result.append(", ");
        }
        if (rangeCount >= 2) {
            CronUtil.daysofweekrange2description(rangesList.get(rangeCount - 2), result);
            result.append(" and ");
        }
        if (rangeCount >= 1) {
            CronUtil.daysofweekrange2description(rangesList.get(rangeCount - 1), result);
        }
        return result.toString();
    }

    private static void daysofweekrange2description(Range daysofweekrange, StringBuilder buf) {
        if (daysofweekrange.interval != null) {
            buf.append("every ").append(daysofweekrange.interval).append(" days");
            if (daysofweekrange.end != null) {
                buf.append(" from ");
                CronUtil.weekday2description(daysofweekrange.start, buf);
                buf.append(" to ");
                CronUtil.weekday2description(daysofweekrange.end, buf);
            } else if (!daysofweekrange.start.equals("*")) {
                buf.append(" starting from ");
                CronUtil.weekday2description(daysofweekrange.start, buf);
            }
        } else {
            CronUtil.weekday2description(daysofweekrange.start, buf);
            if (daysofweekrange.end != null) {
                buf.append(" to ");
                CronUtil.weekday2description(daysofweekrange.end, buf);
            }
        }
    }

    private static void weekday2description(String dayofweek, StringBuilder buf) {
        if (dayofweek.equals("1") || dayofweek.equalsIgnoreCase("SUN")) {
            buf.append("Sunday");
        } else if (dayofweek.equals("2") || dayofweek.equalsIgnoreCase("MON")) {
            buf.append("Monday");
        } else if (dayofweek.equals("3") || dayofweek.equalsIgnoreCase("TUE")) {
            buf.append("Tuesday");
        } else if (dayofweek.equals("4") || dayofweek.equalsIgnoreCase("WED")) {
            buf.append("Wednesday");
        } else if (dayofweek.equals("5") || dayofweek.equalsIgnoreCase("THU")) {
            buf.append("Thursday");
        } else if (dayofweek.equals("6") || dayofweek.equalsIgnoreCase("FRI")) {
            buf.append("Friday");
        } else if (dayofweek.equals("7") || dayofweek.equalsIgnoreCase("SAT")) {
            buf.append("Saturday");
        } else {
            buf.append(dayofweek);
        }
    }

    private static String monthSpec2description(String monthSpec) {
        Range range;
        List<Range> rangesList = CronUtil.getRangesList(monthSpec);
        int rangeCount = rangesList.size();
        if (rangeCount == 1 && ((range = rangesList.get(0)).isAny() || range.isAll())) {
            return null;
        }
        StringBuilder result = new StringBuilder(64);
        for (int i = 0; i < rangeCount - 2; ++i) {
            CronUtil.monthRange2description(rangesList.get(i), result);
            result.append(", ");
        }
        if (rangeCount >= 2) {
            CronUtil.monthRange2description(rangesList.get(rangeCount - 2), result);
            result.append(" and ");
        }
        if (rangeCount >= 1) {
            CronUtil.monthRange2description(rangesList.get(rangeCount - 1), result);
        }
        return result.toString();
    }

    private static void monthRange2description(Range monthrange, StringBuilder buf) {
        if (monthrange.interval != null) {
            buf.append("every ").append(monthrange.interval).append(" months");
            if (monthrange.end != null) {
                buf.append(" from ");
                CronUtil.month2description(monthrange.start, buf);
                buf.append(" to ");
                CronUtil.month2description(monthrange.end, buf);
            } else if (!monthrange.start.equals("*")) {
                buf.append(" starting from ");
                CronUtil.month2description(monthrange.start, buf);
            }
        } else if (monthrange.end != null) {
            buf.append("from ");
            CronUtil.month2description(monthrange.start, buf);
            buf.append(" to ");
            CronUtil.month2description(monthrange.end, buf);
        } else {
            buf.append("in ");
            CronUtil.month2description(monthrange.start, buf);
        }
    }

    private static void month2description(String month, StringBuilder buf) {
        if (month.equals("1") || month.equalsIgnoreCase("JAN")) {
            buf.append("January");
        } else if (month.equals("2") || month.equalsIgnoreCase("FEB")) {
            buf.append("February");
        } else if (month.equals("3") || month.equalsIgnoreCase("MAR")) {
            buf.append("March");
        } else if (month.equals("4") || month.equalsIgnoreCase("APR")) {
            buf.append("April");
        } else if (month.equals("5") || month.equalsIgnoreCase("MAY")) {
            buf.append("May");
        } else if (month.equals("6") || month.equalsIgnoreCase("JUN")) {
            buf.append("June");
        } else if (month.equals("7") || month.equalsIgnoreCase("JUL")) {
            buf.append("July");
        } else if (month.equals("8") || month.equalsIgnoreCase("AUG")) {
            buf.append("August");
        } else if (month.equals("9") || month.equalsIgnoreCase("SEP")) {
            buf.append("September");
        } else if (month.equals("10") || month.equalsIgnoreCase("OCT")) {
            buf.append("October");
        } else if (month.equals("11") || month.equalsIgnoreCase("NOV")) {
            buf.append("November");
        } else if (month.equals("12") || month.equalsIgnoreCase("DEC")) {
            buf.append("December");
        } else {
            buf.append(month);
        }
    }

    private static String dayofmonthSpec2description(String dayofmonthSpec) {
        List<Range> rangesList = CronUtil.getRangesList(dayofmonthSpec);
        int rangeCount = rangesList.size();
        if (rangeCount == 1) {
            Range range = rangesList.get(0);
            if (range.isAny()) {
                return null;
            }
            if (range.isAll()) {
                return "every day of the month";
            }
        }
        StringBuilder result = new StringBuilder(64);
        for (int i = 0; i < rangeCount - 2; ++i) {
            CronUtil.dayofmonthRange2description(rangesList.get(i), result);
            result.append(", ");
        }
        if (rangeCount >= 2) {
            CronUtil.dayofmonthRange2description(rangesList.get(rangeCount - 2), result);
            result.append(" and ");
        }
        if (rangeCount >= 1) {
            CronUtil.dayofmonthRange2description(rangesList.get(rangeCount - 1), result);
        }
        result.append(" of the month");
        return result.toString();
    }

    private static void dayofmonthRange2description(Range dayofmonthRange, StringBuilder buf) {
        if (dayofmonthRange.interval != null) {
            buf.append("every ").append(dayofmonthRange.interval).append(" days");
            if (dayofmonthRange.end != null) {
                buf.append(" between day ").append(dayofmonthRange.start);
                buf.append(" and ").append(dayofmonthRange.end);
            } else if (!dayofmonthRange.start.equals("*")) {
                buf.append(" starting at day ").append(dayofmonthRange.start);
            }
        } else if (dayofmonthRange.end != null) {
            buf.append("from day ").append(dayofmonthRange.start);
            buf.append(" to ").append(dayofmonthRange.end);
        } else {
            buf.append("at day ").append(dayofmonthRange.start);
        }
    }

    private static String minuteSpec2description(String minuteSpec) {
        Range range;
        List<Range> rangesList = CronUtil.getRangesList(minuteSpec);
        int rangeCount = rangesList.size();
        if (rangeCount == 1 && ((range = rangesList.get(0)).isAny() || range.isAll())) {
            return "every minute";
        }
        StringBuilder result = new StringBuilder(64);
        for (int i = 0; i < rangeCount - 2; ++i) {
            CronUtil.minuteRange2description(rangesList.get(i), result);
            result.append(", ");
        }
        if (rangeCount >= 2) {
            CronUtil.minuteRange2description(rangesList.get(rangeCount - 2), result);
            result.append(" and ");
        }
        if (rangeCount >= 1) {
            CronUtil.minuteRange2description(rangesList.get(rangeCount - 1), result);
        }
        result.append(" minutes past the hour");
        return result.toString();
    }

    private static void minuteRange2description(Range minuteRange, StringBuilder buf) {
        if (minuteRange.interval != null) {
            buf.append("every ").append(minuteRange.interval).append(" minutes");
            if (minuteRange.end != null) {
                buf.append(" from ").append(minuteRange.start);
                buf.append(" to ").append(minuteRange.end);
            } else if (!minuteRange.start.equals("*")) {
                buf.append(" starting at ").append(minuteRange.start);
            }
        } else if (minuteRange.end != null) {
            buf.append("from ").append(minuteRange.start);
            buf.append(" to ").append(minuteRange.end);
        } else {
            buf.append("at ").append(minuteRange.start);
        }
    }

    private static String hourSpec2description(String hourSpec) {
        Range range;
        List<Range> rangesList = CronUtil.getRangesList(hourSpec);
        int rangeCount = rangesList.size();
        if (rangeCount == 1 && ((range = rangesList.get(0)).isAny() || range.isAll())) {
            return "every hour";
        }
        StringBuilder result = new StringBuilder(64);
        for (int i = 0; i < rangeCount - 2; ++i) {
            CronUtil.hourRange2description(rangesList.get(i), result);
            result.append(", ");
        }
        if (rangeCount >= 2) {
            CronUtil.hourRange2description(rangesList.get(rangeCount - 2), result);
            result.append(" and ");
        }
        if (rangeCount >= 1) {
            CronUtil.hourRange2description(rangesList.get(rangeCount - 1), result);
        }
        result.append(" o'clock");
        return result.toString();
    }

    private static void hourRange2description(Range hourRange, StringBuilder buf) {
        if (hourRange.interval != null) {
            buf.append("every ").append(hourRange.interval).append(" hours");
            if (hourRange.end != null) {
                buf.append(" from ").append(hourRange.start);
                buf.append(" to ").append(hourRange.end);
            } else {
                buf.append(" starting at ").append(hourRange.start);
            }
        } else if (hourRange.end != null) {
            buf.append("from ").append(hourRange.start);
            buf.append(" to ").append(hourRange.end);
        } else {
            buf.append("at ").append(hourRange.start);
        }
    }

    private static List<Range> getRangesList(String rangesListSpec) {
        ArrayList<Range> result = new ArrayList<Range>(8);
        StringTokenizer commaTok = new StringTokenizer(rangesListSpec, ",");
        while (commaTok.hasMoreTokens()) {
            int rangeSepIdx;
            String range = commaTok.nextToken();
            String start = null;
            String end = null;
            String interval = null;
            int intervalSepIdx = range.indexOf("/");
            if (intervalSepIdx > 0) {
                interval = range.substring(intervalSepIdx + 1);
                range = range.substring(0, intervalSepIdx);
            }
            if ((rangeSepIdx = range.indexOf("-")) > 0) {
                start = range.substring(0, rangeSepIdx);
                end = range.substring(rangeSepIdx + 1);
            } else {
                start = range;
            }
            if (interval != null && start.equals("*")) {
                start = "0";
            }
            result.add(new Range(start, end, interval));
        }
        return result;
    }

    private static class Range {
        public String start = null;
        public String end = null;
        public String interval = null;

        public Range(String start, String end, String interval) {
            this.start = start;
            this.end = end;
            this.interval = interval;
        }

        public boolean isAny() {
            return this.start.equals("?") && this.end == null && this.interval == null;
        }

        public boolean isAll() {
            return this.start.equals("*") && this.end == null && this.interval == null;
        }
    }
}

