/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.manager;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import org.openrdf.http.client.HTTPClient;
import org.openrdf.http.protocol.UnauthorizedException;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.util.LiteralUtil;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.config.RepositoryConfigException;
import org.openrdf.repository.config.RepositoryConfigUtil;
import org.openrdf.repository.http.HTTPRepository;
import org.openrdf.repository.manager.RepositoryInfo;
import org.openrdf.repository.manager.RepositoryManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteRepositoryManager
extends RepositoryManager {
    private String serverURL;
    private String username;
    private String password;

    public static RemoteRepositoryManager getInstance(String serverURL) throws RepositoryException {
        RemoteRepositoryManager manager = new RemoteRepositoryManager(serverURL);
        manager.initialize();
        return manager;
    }

    public static RemoteRepositoryManager getInstance(String serverURL, String username, String password) throws RepositoryException {
        RemoteRepositoryManager manager = new RemoteRepositoryManager(serverURL);
        manager.setUsernameAndPassword(username, password);
        manager.initialize();
        return manager;
    }

    public RemoteRepositoryManager(String serverURL) {
        this.serverURL = serverURL;
    }

    public void setUsernameAndPassword(String username, String password) {
        this.username = username;
        this.password = password;
    }

    @Override
    protected Repository createSystemRepository() throws RepositoryException {
        HTTPRepository systemRepository = new HTTPRepository(this.serverURL, "SYSTEM");
        systemRepository.initialize();
        return systemRepository;
    }

    public String getServerURL() {
        return this.serverURL;
    }

    @Override
    public HTTPRepository getSystemRepository() {
        HTTPRepository result = (HTTPRepository)super.getSystemRepository();
        result.setUsernameAndPassword(this.username, this.password);
        return result;
    }

    @Override
    protected Repository createRepository(String id) throws RepositoryConfigException, RepositoryException {
        HTTPRepository result = null;
        if (RepositoryConfigUtil.hasRepositoryConfig(this.getSystemRepository(), id)) {
            result = new HTTPRepository(this.serverURL, id);
            result.initialize();
        }
        return result;
    }

    @Override
    public RepositoryInfo getRepositoryInfo(String id) throws RepositoryException {
        for (RepositoryInfo repInfo : this.getAllRepositoryInfos()) {
            if (!repInfo.getId().equals(id)) continue;
            return repInfo;
        }
        return null;
    }

    @Override
    public Collection<RepositoryInfo> getAllRepositoryInfos(boolean skipSystemRepo) throws RepositoryException {
        ArrayList<RepositoryInfo> result = new ArrayList<RepositoryInfo>();
        try {
            HTTPClient httpClient = new HTTPClient();
            httpClient.setServerURL(this.serverURL);
            httpClient.setUsernameAndPassword(this.username, this.password);
            TupleQueryResult responseFromServer = httpClient.getRepositoryList();
            while (responseFromServer.hasNext()) {
                BindingSet bindingSet = (BindingSet)responseFromServer.next();
                RepositoryInfo repInfo = new RepositoryInfo();
                String id = LiteralUtil.getLabel(bindingSet.getValue("id"), null);
                if (skipSystemRepo && id.equals("SYSTEM")) continue;
                Value uri = bindingSet.getValue("uri");
                String description = LiteralUtil.getLabel(bindingSet.getValue("title"), null);
                boolean readable = LiteralUtil.getBooleanValue(bindingSet.getValue("readable"), false);
                boolean writable = LiteralUtil.getBooleanValue(bindingSet.getValue("writable"), false);
                if (uri instanceof URI) {
                    try {
                        repInfo.setLocation(new URL(uri.toString()));
                    }
                    catch (MalformedURLException e) {
                        this.logger.warn("Server reported malformed repository URL: {}", (Object)uri);
                    }
                }
                repInfo.setId(id);
                repInfo.setDescription(description);
                repInfo.setReadable(readable);
                repInfo.setWritable(writable);
                result.add(repInfo);
            }
        }
        catch (IOException ioe) {
            this.logger.warn("Unable to retrieve list of repositories", (Throwable)ioe);
            throw new RepositoryException(ioe);
        }
        catch (QueryEvaluationException qee) {
            this.logger.warn("Unable to retrieve list of repositories", (Throwable)qee);
            throw new RepositoryException(qee);
        }
        catch (UnauthorizedException ue) {
            this.logger.warn("Not authorized to retrieve list of repositories", (Throwable)ue);
            throw new RepositoryException(ue);
        }
        catch (RepositoryException re) {
            this.logger.warn("Unable to retrieve list of repositories", (Throwable)re);
            throw re;
        }
        return result;
    }

    @Override
    protected void cleanUpRepository(String repositoryID) throws IOException {
    }
}

