import ts from "typescript";
import { Resource } from "@ui5/fs";
import LinterContext, { RawLintMessage, ResourcePath } from "../linter/LinterContext.js";
import { ModuleDeclaration } from "../linter/ui5Types/amdTranspiler/parseModuleDeclaration.js";
import { RequireExpression } from "../linter/ui5Types/amdTranspiler/parseRequire.js";
export interface AutofixResource {
    resource: Resource;
    messages: RawLintMessage[];
}
export interface AutofixOptions {
    rootDir: string;
    namespace?: string;
    resources: Map<ResourcePath, AutofixResource>;
    context: LinterContext;
}
export type AutofixResult = Map<ResourcePath, string>;
export interface Position {
    line: number;
    column: number;
    pos: number;
}
export interface DeprecatedApiAccessNode {
    apiName: string;
    position: Position;
    node?: ts.CallExpression | ts.Identifier | ts.PropertyAccessExpression | ts.ElementAccessExpression;
}
export type ImportRequests = Map<string, {
    nodeInfos?: DeprecatedApiAccessNode[];
    identifier: string;
}>;
export interface ExistingModuleDeclarationInfo {
    moduleDeclaration: ModuleDeclaration | RequireExpression;
    importRequests: ImportRequests;
    obsoleteModules: Set<string>;
}
export declare function getFactoryPosition(moduleDeclaration: ExistingModuleDeclarationInfo): {
    start: number;
    end: number;
};
export default function ({ rootDir: _unused1, namespace: _unused2, resources: autofixResources, context, }: AutofixOptions): Promise<AutofixResult>;
