import { LinterOptions, LintResult } from "./LinterContext.js";
import { ProjectGraph } from "@ui5/project";
import type { AbstractReader } from "@ui5/fs";
import { UI5LintConfigType } from "../utils/ConfigManager.js";
import type SharedLanguageService from "./ui5Types/SharedLanguageService.js";
import { FSToVirtualPathOptions } from "../utils/virtualPathToFilePath.js";
export declare function lintProject({ rootDir, filePatterns, ignorePatterns, coverage, details, fix, configPath, ui5Config, noConfig, }: LinterOptions, sharedLanguageService: SharedLanguageService): Promise<LintResult[]>;
export declare function lintFile({ rootDir, filePatterns, ignorePatterns, namespace, coverage, details, fix, configPath, noConfig, }: LinterOptions, sharedLanguageService: SharedLanguageService): Promise<LintResult[]>;
declare function getProjectGraph(rootDir: string, ui5Config?: string | object): Promise<ProjectGraph>;
export declare function resolveReader({ patterns, resourceReader, inverseResult, patternsMatch, fsToVirtualPathOptions, }: {
    patterns: string[];
    resourceReader: AbstractReader;
    inverseResult?: boolean;
    patternsMatch: Set<string>;
    fsToVirtualPathOptions: FSToVirtualPathOptions;
}): AbstractReader;
export declare function mergeIgnorePatterns(options: LinterOptions, config: UI5LintConfigType): string[];
export declare const __localFunctions__: {
    getProjectGraph: typeof getProjectGraph;
} | undefined;
export {};
