import ts from "typescript";
import type SourceFileMetadataCollector from "./SourceFileMetadataCollector.js";
import type { ApiExtract } from "../../utils/ApiExtract.js";
import { AbstractAdapter } from "@ui5/fs";
import type { AmbientModuleCache } from "./AmbientModuleCache.js";
import type TypeLinter from "./TypeLinter.js";
import { Ui5TypeInfo } from "./Ui5TypeInfo.js";
import FixFactory from "./fix/FixFactory.js";
import Fix from "./fix/Fix.js";
import { JSONSchemaForSAPUI5Namespace } from "../../manifest.js";
interface DeprecationInfo {
    symbol: ts.Symbol;
    messageDetails: string;
    ui5TypeInfo?: Ui5TypeInfo;
}
export default class SourceFileLinter {
    #private;
    private typeLinter;
    private sourceFile;
    private checker;
    private reportCoverage;
    private messageDetails;
    private apiExtract;
    private filePathsWorkspace;
    private workspace;
    private ambientModuleCache;
    private fixFactory?;
    private manifestContent?;
    private libraryDependencies?;
    private metadataCollector?;
    private fixHelpers;
    private resourcePath;
    constructor(typeLinter: TypeLinter, sourceFile: ts.SourceFile, checker: ts.TypeChecker, reportCoverage: boolean | undefined, messageDetails: boolean | undefined, apiExtract: ApiExtract, filePathsWorkspace: AbstractAdapter, workspace: AbstractAdapter, ambientModuleCache: AmbientModuleCache, fixFactory?: FixFactory | undefined, manifestContent?: string | undefined, libraryDependencies?: JSONSchemaForSAPUI5Namespace["dependencies"]["libs"], metadataCollector?: SourceFileMetadataCollector | undefined);
    lint(): Promise<void>;
    visitNode(node: ts.Node): void;
    isUi5ClassDeclaration(node: ts.ClassDeclaration, baseClassModule: string | string[]): boolean;
    analyzeControlRendererDeclaration(node: ts.ClassDeclaration): void;
    analyzeControlRendererInternals(node: ts.Node): void;
    analyzeIconCallInRenderMethod(node: ts.Node): void;
    analyzeControlRerenderMethod(node: ts.ClassDeclaration): void;
    analyzeMetadataProperty(node: ts.PropertyAssignment): void;
    analyzeIdentifier(node: ts.Identifier): boolean;
    analyzeObjectBindingPattern(node: ts.ObjectBindingPattern): void;
    analyzeNewExpression(node: ts.NewExpression): void;
    getDeprecationText(deprecatedTag: ts.JSDocTagInfo): string;
    getDeprecationInfo(symbol: ts.Symbol | undefined): DeprecationInfo | null;
    analyzeCallExpression(node: ts.CallExpression): void;
    getDeprecationInfoForAccess(node: ts.AccessExpression): DeprecationInfo | null;
    analyzePropertyAccessExpressionForDeprecation(node: ts.AccessExpression): boolean;
    handleCallExpressionUnknownType(nodeType: ts.Type, node: ts.CallExpression): void;
    analyzeExportedValuesByLib(node: ts.PropertyAccessExpression | ts.ElementAccessExpression): void;
    analyzePropertyAccessExpression(node: ts.AccessExpression | ts.CallExpression): void;
    isAllowedPropertyAccess(node: ts.PropertyAccessExpression | ts.ElementAccessExpression): boolean;
    analyzeImportDeclaration(importDeclarationNode: ts.ImportDeclaration): void;
    isSymbolOfUi5Type(symbol: ts.Symbol): boolean;
    isSymbolOfUi5OrThirdPartyType(symbol: ts.Symbol): boolean;
    isSymbolOfJquerySapType(symbol: ts.Symbol): boolean;
    isSymbolOfPseudoModuleType(symbol: ts.Symbol): boolean;
    checkSymbolDeclarationSourceFile(symbol: ts.Symbol, checkFunction: (sourceFile: ts.SourceFile) => boolean): boolean;
    analyzeTestsuiteThemeProperty(node: ts.PropertyAssignment): void;
    hasQUnitFileExtension(): boolean;
    getFix(node: ts.Node, ui5TypeInfo: Ui5TypeInfo | undefined): Fix | undefined;
    getJqueryFix(node: ts.AccessExpression | ts.CallExpression, ui5TypeInfo: Ui5TypeInfo | undefined): Fix | undefined;
    getGlobalFix(node: ts.CallExpression | ts.AccessExpression): Fix | undefined;
}
export {};
