import ts from "typescript";
import { ChangeAction } from "../../../utils/textChanges.js";
import CallExpressionBaseFix, { CallExpressionBaseFixParams } from "./CallExpressionBaseFix.js";
import { FixScope } from "./BaseFix.js";
import { Ui5TypeInfo } from "../Ui5TypeInfo.js";
export interface CallExpressionFixParams extends CallExpressionBaseFixParams {
    /**
     * Which scope, i.e. number of access expressions (counting from the call expression) should the replacement
     * affect.
     *
     * Examples for the code "sap.module.method()":
     * - "scope = 0" will replace the whole "sap.module.method()"
     * - "scope = 1" will replace "sap.module.method"
     * - "scope = 2" will replace "sap.module"
     *
     * If not set, the default value is 1.
     */
    scope?: number | FixScope;
    /**
     * Whether to add a "new" keyword before the expression
     */
    newExpression?: boolean;
    /**
     * Property access on the module or global
     *
     * Example: Migrating "module.property" to "otherModule.otherProperty"
     * would require this to be set to "otherProperty"
     */
    propertyAccess?: string;
}
export default class CallExpressionFix extends CallExpressionBaseFix {
    protected params: CallExpressionFixParams;
    constructor(params: CallExpressionFixParams, ui5TypeInfo: Ui5TypeInfo);
    visitAutofixNode(node: ts.Node, position: number, sourceFile: ts.SourceFile): boolean;
    generateChanges(): {
        action: ChangeAction;
        start: number;
        end: number;
        value: string;
    } | undefined;
}
