import ts from "typescript";
import { PositionInfo } from "../../LinterContext.js";
import { Attribute, Position } from "sax-wasm";
import XmlEnabledFix from "./XmlEnabledFix.js";
import { ChangeSet } from "../../../utils/textChanges.js";
import SourceFileMetadataCollector from "../SourceFileMetadataCollector.js";
export default class EventHandlersFix extends XmlEnabledFix {
    private methodName;
    private controllerName;
    protected sourcePosition: PositionInfo | undefined;
    protected startPos: number | undefined;
    private isMethodInController;
    constructor(methodName: string, controllerName: string);
    visitLinterNode(_node: ts.Node, sourcePosition: PositionInfo): boolean;
    getNodeSearchParameters(): {
        nodeTypes: ts.SyntaxKind[];
        xmlEventTypes: 64[];
        position: PositionInfo;
    };
    private getClosestPath;
    methodExistsInController(checker: ts.TypeChecker, metadataCollector: SourceFileMetadataCollector, currentFilePath: string): void;
    visitAutofixXmlNode(node: Attribute, toPosition: (pos: Position) => number): boolean;
    visitAutofixNode(_node: ts.Node, _position: number, _sourceFile: ts.SourceFile): boolean;
    getAffectedSourceCodeRange(): {
        start: number;
        end: number;
    };
    generateChanges(): ChangeSet | ChangeSet[] | undefined;
}
