export default class ControllerByIdInfo {
    map = new Map();
    getControllerMapping(controllerName) {
        let controllerMap = this.map.get(controllerName);
        if (!controllerMap) {
            controllerMap = new Map();
            this.map.set(controllerName, controllerMap);
        }
        return controllerMap;
    }
    addMappings(controllerName, idModuleMap) {
        // Do not add empty mappings
        if (!idModuleMap.size) {
            return;
        }
        const controllerMapping = this.getControllerMapping(controllerName);
        for (const [id, module] of idModuleMap) {
            let existingModules = controllerMapping.get(id);
            if (!existingModules) {
                existingModules = new Set();
                controllerMapping.set(id, existingModules);
            }
            existingModules.add(module);
        }
    }
    getMappings() {
        return this.map;
    }
}
//# sourceMappingURL=ControllerByIdInfo.js.map