// For Library Version: 1.136.10

declare module "sap/fe/base/BuildingBlockBase" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  /**
   * Base class for building blocks.
   * This contains the low level functionality of having a content aggregation and handling the rendering
   * of the content without an actual DOM element.
   * The building block also defines a state object that can be used to store the state of the building block.
   * Accessibility and classes information are forwarded to the content control.
   *
   * @experimental
   */
  export default class BuildingBlockBase extends Control {}
  /**
   * Describes the settings that can be provided to the BuildingBlockBase constructor.
   *
   * @experimental
   */
  export interface $BuildingBlockBaseSettings extends $ControlSettings {}
}

declare module "sap/fe/base/library" {}

declare namespace sap {
  interface IUI5DefineDependencyNames {
    "sap/fe/base/BuildingBlockBase": undefined;

    "sap/fe/base/library": undefined;
  }
}
