// For Library Version: 1.136.1

declare module "sap/rules/ui/library" {
  /**
   * An enumeration that defines how a cell in a decision table is formulated by the rule creator.
   *
   * This enum is part of the 'sap/rules/ui/library' module export and must be accessed by the property 'DecisionTableCellFormat'.
   *
   * @deprecated As of version 1.52.8. use the property decisionTableFormat.
   */
  export enum DecisionTableCellFormat {
    /**
     * Specifies that both rule formats are available in the decision table; allowing the rule creator to choose
     * whether to formulate the decision table cells in either the basic or advanced format.
     */
    Both = "BOTH",
    /**
     * Specifies that the content of the decision table cell is restricted to values relevant to the data type
     * of the table column's expression.
     */
    Guided = "GUIDED",
    /**
     * Specifies that the content of the decision table cell receives all possible suggestions (relevant functions,
     * attributes and values) that are relevant to the data type of the table column's expression.
     */
    Text = "TEXT",
  }
  /**
   * An enumeration that decides the rendering format for decisionTable.
   *
   * This enum is part of the 'sap/rules/ui/library' module export and must be accessed by the property 'DecisionTableFormat'.
   */
  export enum DecisionTableFormat {
    /**
     * Specifies that the rendering of a cell is based on cellFormat and each cell can have a different format
     * during rendering
     *
     * @deprecated As of version 1.52.8. use the attribute RuleFormat instead.
     */
    CellFormat = "CELLFORMAT",
    /**
     * Specifies that the rendering is at the rule level. The value set here is applicable for all the cells
     * in the rule.
     */
    RuleFormat = "RULEFORMAT",
  }
  /**
   * An enumeration that defines the different business data types for an expression
   *
   * This enum is part of the 'sap/rules/ui/library' module export and must be accessed by the property 'ExpressionType'.
   */
  export enum ExpressionType {
    /**
     * Specifies that the expression can be of any of the supported business data types.
     */
    All = "All",
    /**
     * Specifies that the expression must represent a Boolean data type: true, false.
     */
    Boolean = "Boolean",
    /**
     * Specifies that the expression must represent a date only.
     */
    Date = "Date",
    /**
     * Specifies that the expression must represent a real number with or without dot-decimal notation.
     */
    Number = "Number",
    /**
     * Specifies that the expression must represent a single-quoted UTF-8 encoded string.
     */
    String = "String",
    /**
     * Specifies that the expression must represent a time only.
     */
    Time = "Time",
    /**
     * Specifies that the expression must represent a time difference in milliseconds.
     */
    TimeSpan = "TimeSpan",
    /**
     * Specifies that the expression must represent a date and timestamp.
     */
    Timestamp = "Timestamp",
  }
  /**
   * An enumeration that defines the output when more than one rule in the decision table is matched for a
   * given set of inputs.
   *
   * This enum is part of the 'sap/rules/ui/library' module export and must be accessed by the property 'RuleHitPolicy'.
   */
  export enum RuleHitPolicy {
    /**
     * Specifies that all conditions that match the input (each matching row in the decision table) are returned
     * as an output.
     */
    AllMatch = "AM",
    /**
     * Specifies that only the first condition that matches the input (the first matching row by order in the
     * decision table) is returned as an output.
     */
    FirstMatch = "FM",
  }
  /**
   * An enumeration that defines whether the rule is formulated as a table with multiple rules instead of
   * a rule with a single associated condition.
   *
   * This enum is part of the 'sap/rules/ui/library' module export and must be accessed by the property 'RuleType'.
   */
  export enum RuleType {
    /**
     * Specifies that the rule is formulated as a table that allows complex rules to be visualized according
     * to an if-then-else logic.
     */
    DecisionTable = "DT",
    /**
     * Specifies that the rule is formulated as a single condition, which is written directly in a business
     * language.
     */
    TextRule = "TextRule",
  }
}

declare module "sap/rules/ui/DecisionTableConfiguration" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import {
    DecisionTableCellFormat,
    DecisionTableFormat,
    RuleHitPolicy,
  } from "sap/rules/ui/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  import Event from "sap/ui/base/Event";

  /**
   * The `sap.rules.ui.DecisionTableConfiguration` element provides the ability to define specific properties
   * that will be applied when rendering the `sap.rules.ui.RuleBuilder` in decision table mode.
   *
   * @since 1.4
   */
  export default class DecisionTableConfiguration extends UI5Element {
    /**
     * Constructor for a new DecisionTableConfiguration.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $DecisionTableConfigurationSettings
    );
    /**
     * Constructor for a new DecisionTableConfiguration.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $DecisionTableConfigurationSettings
    );

    /**
     * Creates a new subclass of class sap.rules.ui.DecisionTableConfiguration with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, DecisionTableConfiguration>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.rules.ui.DecisionTableConfiguration.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:change change} event of this `sap.rules.ui.DecisionTableConfiguration`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.rules.ui.DecisionTableConfiguration` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachChange(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: DecisionTableConfiguration$ChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.rules.ui.DecisionTableConfiguration`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:change change} event of this `sap.rules.ui.DecisionTableConfiguration`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.rules.ui.DecisionTableConfiguration` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachChange(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: DecisionTableConfiguration$ChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.rules.ui.DecisionTableConfiguration`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:change change} event of this `sap.rules.ui.DecisionTableConfiguration`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachChange(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: DecisionTableConfiguration$ChangeEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:change change} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireChange(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: DecisionTableConfiguration$ChangeEventParameters
    ): this;
    /**
     * Gets current value of property {@link #getCellFormat cellFormat}.
     *
     * The value determines the user input mode for the corresponding rule cells when creating or editing a
     * rule.
     *
     * Default value is `Both`.
     *
     * @deprecated As of version 1.52.8. use the decisionTableFormat property.
     *
     * @returns Value of property `cellFormat`
     */
    getCellFormat(): DecisionTableCellFormat;
    /**
     * Gets current value of property {@link #getDecisionTableFormat decisionTableFormat}.
     *
     * The value determines whether the user can set the rendering of the decision Table to be based on cellFormat
     * or rule Format
     *
     * Default value is `RuleFormat`.
     *
     *
     * @returns Value of property `decisionTableFormat`
     */
    getDecisionTableFormat(): DecisionTableFormat;
    /**
     * Gets current value of property {@link #getEnableSettingResult enableSettingResult}.
     *
     * Default value is `true`.
     *
     * @deprecated As of version 1.120.2. to configure the settings, use the Manage Rules Project app or the
     * Rule Authoring APIs.
     *
     * @returns Value of property `enableSettingResult`
     */
    getEnableSettingResult(): boolean;
    /**
     * Gets current value of property {@link #getEnableSettings enableSettings}.
     *
     * The value determines whether the Settings button is displayed in a decision table when the control is
     * used with S/4 HANA 17.05 (Cloud) or 17.09 (On Premise) and higher (On Premise).
     *
     * Default value is `false`.
     *
     * @deprecated As of version 1.120.2. to configure the settings, use the Manage Rules Project app or the
     * Rule Authoring APIs.
     *
     * @returns Value of property `enableSettings`
     */
    getEnableSettings(): boolean;
    /**
     * Gets current value of property {@link #getHitPolicies hitPolicies}.
     *
     * The value determines how the results of the decision table are evaluated when more than one rule is matched
     * for a given set of inputs.
     *
     * Default value is `[FirstMatch, AllMatch]`.
     *
     * @deprecated As of version 1.120.2. to configure the settings, use the Manage Rules Project app or the
     * Rule Authoring APIs.
     *
     * @returns Value of property `hitPolicies`
     */
    getHitPolicies(): RuleHitPolicy[];
    /**
     * Gets current value of property {@link #getThreshold threshold}.
     *
     * The threshold defines how many additional (not yet visible records) shall be pre-fetched to enable smooth
     * scrolling. The threshold is always added to the visibleRowCount. If the visibleRowCount is 10 and the
     * threshold is 100, there will be 110 records fetched with the initial load.
     *
     * Default value is `30`.
     *
     *
     * @returns Value of property `threshold`
     */
    getThreshold(): int;
    /**
     * Gets current value of property {@link #getVisibleRowCount visibleRowCount}.
     *
     * Number of visible rows of the table.
     *
     * Default value is `30`.
     *
     *
     * @returns Value of property `visibleRowCount`
     */
    getVisibleRowCount(): int;
    /**
     * Sets a new value for property {@link #getCellFormat cellFormat}.
     *
     * The value determines the user input mode for the corresponding rule cells when creating or editing a
     * rule.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Both`.
     *
     * @deprecated As of version 1.52.8. use the decisionTableFormat property.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCellFormat(
      /**
       * New value for property `cellFormat`
       */
      sCellFormat?: DecisionTableCellFormat
    ): this;
    /**
     * Sets a new value for property {@link #getDecisionTableFormat decisionTableFormat}.
     *
     * The value determines whether the user can set the rendering of the decision Table to be based on cellFormat
     * or rule Format
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `RuleFormat`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDecisionTableFormat(
      /**
       * New value for property `decisionTableFormat`
       */
      sDecisionTableFormat?: DecisionTableFormat
    ): this;
    /**
     * Sets a new value for property {@link #getEnableSettingResult enableSettingResult}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     * @deprecated As of version 1.120.2. to configure the settings, use the Manage Rules Project app or the
     * Rule Authoring APIs.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnableSettingResult(
      /**
       * New value for property `enableSettingResult`
       */
      bEnableSettingResult?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getEnableSettings enableSettings}.
     *
     * The value determines whether the Settings button is displayed in a decision table when the control is
     * used with S/4 HANA 17.05 (Cloud) or 17.09 (On Premise) and higher (On Premise).
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @deprecated As of version 1.120.2. to configure the settings, use the Manage Rules Project app or the
     * Rule Authoring APIs.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnableSettings(
      /**
       * New value for property `enableSettings`
       */
      bEnableSettings?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getHitPolicies hitPolicies}.
     *
     * The value determines how the results of the decision table are evaluated when more than one rule is matched
     * for a given set of inputs.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `[FirstMatch, AllMatch]`.
     *
     * @deprecated As of version 1.120.2. to configure the settings, use the Manage Rules Project app or the
     * Rule Authoring APIs.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHitPolicies(
      /**
       * New value for property `hitPolicies`
       */
      sHitPolicies?: RuleHitPolicy[]
    ): this;
    /**
     * Sets a new value for property {@link #getThreshold threshold}.
     *
     * The threshold defines how many additional (not yet visible records) shall be pre-fetched to enable smooth
     * scrolling. The threshold is always added to the visibleRowCount. If the visibleRowCount is 10 and the
     * threshold is 100, there will be 110 records fetched with the initial load.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `30`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setThreshold(
      /**
       * New value for property `threshold`
       */
      iThreshold?: int
    ): this;
    /**
     * Sets a new value for property {@link #getVisibleRowCount visibleRowCount}.
     *
     * Number of visible rows of the table.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `30`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setVisibleRowCount(
      /**
       * New value for property `visibleRowCount`
       */
      iVisibleRowCount?: int
    ): this;
  }
  /**
   * Describes the settings that can be provided to the DecisionTableConfiguration constructor.
   */
  export interface $DecisionTableConfigurationSettings
    extends $ElementSettings {
    /**
     * The value determines the user input mode for the corresponding rule cells when creating or editing a
     * rule.
     *
     * @deprecated As of version 1.52.8. use the decisionTableFormat property.
     */
    cellFormat?: DecisionTableCellFormat | PropertyBindingInfo | `{${string}}`;

    /**
     * The value determines how the results of the decision table are evaluated when more than one rule is matched
     * for a given set of inputs.
     *
     * @deprecated As of version 1.120.2. to configure the settings, use the Manage Rules Project app or the
     * Rule Authoring APIs.
     */
    hitPolicies?: RuleHitPolicy[] | PropertyBindingInfo | `{${string}}`;

    /**
     * The value determines whether the Settings button is displayed in a decision table when the control is
     * used with S/4 HANA 17.05 (Cloud) or 17.09 (On Premise) and higher (On Premise).
     *
     * @deprecated As of version 1.120.2. to configure the settings, use the Manage Rules Project app or the
     * Rule Authoring APIs.
     */
    enableSettings?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * @deprecated As of version 1.120.2. to configure the settings, use the Manage Rules Project app or the
     * Rule Authoring APIs.
     */
    enableSettingResult?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * The value determines whether the user can set the rendering of the decision Table to be based on cellFormat
     * or rule Format
     */
    decisionTableFormat?:
      | DecisionTableFormat
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * The threshold defines how many additional (not yet visible records) shall be pre-fetched to enable smooth
     * scrolling. The threshold is always added to the visibleRowCount. If the visibleRowCount is 10 and the
     * threshold is 100, there will be 110 records fetched with the initial load.
     */
    threshold?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Number of visible rows of the table.
     */
    visibleRowCount?: int | PropertyBindingInfo | `{${string}}`;

    change?: (oEvent: DecisionTableConfiguration$ChangeEvent) => void;
  }

  /**
   * Parameters of the DecisionTableConfiguration#change event.
   */
  export interface DecisionTableConfiguration$ChangeEventParameters {
    name?: undefined;

    value?: undefined;
  }

  /**
   * Event object of the DecisionTableConfiguration#change event.
   */
  export type DecisionTableConfiguration$ChangeEvent = Event<
    DecisionTableConfiguration$ChangeEventParameters,
    DecisionTableConfiguration
  >;
}

declare module "sap/rules/ui/RuleBuilder" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import { ID } from "sap/ui/core/library";

  import DecisionTableConfiguration from "sap/rules/ui/DecisionTableConfiguration";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import TextRuleConfiguration from "sap/rules/ui/TextRuleConfiguration";

  import { RuleType } from "sap/rules/ui/library";

  import AstExpressionLanguage from "sap/rules/ui/services/AstExpressionLanguage";

  import ExpressionLanguage from "sap/rules/ui/services/ExpressionLanguage";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * The `sap.rules.ui.RuleBuilder` control allows business users to create rules using a business language.
   */
  export default class RuleBuilder extends Control {
    /**
     * Constructor for a new RuleBuilder control.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control.
       */
      mSettings?: $RuleBuilderSettings
    );
    /**
     * Constructor for a new RuleBuilder control.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given.
       */
      sId?: string,
      /**
       * Initial settings for the new control.
       */
      mSettings?: $RuleBuilderSettings
    );

    /**
     * Creates a new subclass of class sap.rules.ui.RuleBuilder with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, RuleBuilder>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.rules.ui.RuleBuilder.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Destroys the decisionTableConfiguration in the aggregation {@link #getDecisionTableConfiguration decisionTableConfiguration}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyDecisionTableConfiguration(): this;
    /**
     * Destroys the textRuleConfiguration in the aggregation {@link #getTextRuleConfiguration textRuleConfiguration}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyTextRuleConfiguration(): this;
    /**
     * ID of the element which is the current target of the association {@link #getAstExpressionLanguage astExpressionLanguage},
     * or `null`.
     */
    getAstExpressionLanguage(): ID | null;
    /**
     * Gets current value of property {@link #getBindingContextPath bindingContextPath}.
     *
     * Path to a Rule object in the model data, which is used for the definition of relative context bindings
     * inside the RuleBuilder control (mandatory). Example: "/Rules(Id='0050569181751ED683EFEEC6AA2B73C5',Version='000001')"
     *
     *
     * @returns Value of property `bindingContextPath`
     */
    getBindingContextPath(): string;
    /**
     * Gets content of aggregation {@link #getDecisionTableConfiguration decisionTableConfiguration}.
     *
     * Configuration for rule of type 'decision table'.
     */
    getDecisionTableConfiguration(): DecisionTableConfiguration;
    /**
     * Gets current value of property {@link #getEditable editable}.
     *
     * Indicates whether or not the controls of the RuleBuilder are editable.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `editable`
     */
    getEditable(): boolean;
    /**
     * ID of the element which is the current target of the association {@link #getExpressionLanguage expressionLanguage},
     * or `null`.
     *
     * @deprecated As of version 1.120.2. use the attribute astExpressionLanguage instead.
     */
    getExpressionLanguage(): ID | null;
    /**
     * Gets content of aggregation {@link #getTextRuleConfiguration textRuleConfiguration}.
     *
     * Configuration for rule of type 'Text Rule'.
     */
    getTextRuleConfiguration(): TextRuleConfiguration;
    /**
     * Gets current value of property {@link #getTypes types}.
     *
     * Available types that can be created using the `sap.rules.ui.RuleBuilder` control. If empty, all rule
     * types will be available for selection. If only one type exists, the Rule Builder will open it automatically.
     *
     * Default value is `[DecisionTable, TextRule]`.
     *
     *
     * @returns Value of property `types`
     */
    getTypes(): RuleType[];
    /**
     * Sets the associated {@link #getAstExpressionLanguage astExpressionLanguage}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAstExpressionLanguage(
      /**
       * ID of an element which becomes the new target of this astExpressionLanguage association; alternatively,
       * an element instance may be given
       */
      oAstExpressionLanguage: ID | AstExpressionLanguage
    ): this;
    /**
     * Sets a new value for property {@link #getBindingContextPath bindingContextPath}.
     *
     * Path to a Rule object in the model data, which is used for the definition of relative context bindings
     * inside the RuleBuilder control (mandatory). Example: "/Rules(Id='0050569181751ED683EFEEC6AA2B73C5',Version='000001')"
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setBindingContextPath(
      /**
       * New value for property `bindingContextPath`
       */
      sBindingContextPath: string
    ): this;
    /**
     * Sets the aggregated {@link #getDecisionTableConfiguration decisionTableConfiguration}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDecisionTableConfiguration(
      /**
       * The decisionTableConfiguration to set
       */
      oDecisionTableConfiguration: DecisionTableConfiguration
    ): this;
    /**
     * Sets a new value for property {@link #getEditable editable}.
     *
     * Indicates whether or not the controls of the RuleBuilder are editable.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEditable(
      /**
       * New value for property `editable`
       */
      bEditable?: boolean
    ): this;
    /**
     * Sets the associated {@link #getExpressionLanguage expressionLanguage}.
     *
     * @deprecated As of version 1.120.2. use the attribute astExpressionLanguage instead.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setExpressionLanguage(
      /**
       * ID of an element which becomes the new target of this expressionLanguage association; alternatively,
       * an element instance may be given
       */
      oExpressionLanguage: ID | ExpressionLanguage
    ): this;
    /**
     * Sets the aggregated {@link #getTextRuleConfiguration textRuleConfiguration}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTextRuleConfiguration(
      /**
       * The textRuleConfiguration to set
       */
      oTextRuleConfiguration: TextRuleConfiguration
    ): this;
    /**
     * Sets a new value for property {@link #getTypes types}.
     *
     * Available types that can be created using the `sap.rules.ui.RuleBuilder` control. If empty, all rule
     * types will be available for selection. If only one type exists, the Rule Builder will open it automatically.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `[DecisionTable, TextRule]`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTypes(
      /**
       * New value for property `types`
       */
      sTypes?: RuleType[]
    ): this;
  }
  /**
   * Describes the settings that can be provided to the RuleBuilder constructor.
   */
  export interface $RuleBuilderSettings extends $ControlSettings {
    /**
     * Available types that can be created using the `sap.rules.ui.RuleBuilder` control. If empty, all rule
     * types will be available for selection. If only one type exists, the Rule Builder will open it automatically.
     */
    types?: RuleType[] | PropertyBindingInfo | `{${string}}`;

    /**
     * Path to a Rule object in the model data, which is used for the definition of relative context bindings
     * inside the RuleBuilder control (mandatory). Example: "/Rules(Id='0050569181751ED683EFEEC6AA2B73C5',Version='000001')"
     */
    bindingContextPath?: string | PropertyBindingInfo;

    /**
     * Indicates whether or not the controls of the RuleBuilder are editable.
     */
    editable?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Configuration for rule of type 'decision table'.
     */
    decisionTableConfiguration?: DecisionTableConfiguration;

    /**
     * Configuration for rule of type 'Text Rule'.
     */
    textRuleConfiguration?: TextRuleConfiguration;

    /**
     * Expression language to model English like expressions. Should not be used when sap.rules.ui.services.AstExpressionLanguage
     * is used.
     *
     * @deprecated As of version 1.120.2. use the attribute astExpressionLanguage instead.
     */
    expressionLanguage?: ExpressionLanguage | string;

    /**
     * Expression language to use DMN SFEEL for modelling expressions. Should not be used when sap.rules.ui.services.ExpressionLanguage
     * is used.
     */
    astExpressionLanguage?: AstExpressionLanguage | string;
  }
}

declare module "sap/rules/ui/services/AstExpressionLanguage" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import Event from "sap/ui/base/Event";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Provides the AstExpressionLanguage service functionality, such as expression validations, expression
   * parsing, auto-complete suggestions, retrieving expression metadata and tokens, and performing runtime
   * services (fetching data objects, outputs, etc).
   */
  export default class AstExpressionLanguage extends UI5Element {
    /**
     * Constructor for a new AstExpressionLanguage element.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor();

    /**
     * Creates a new subclass of class sap.rules.ui.services.AstExpressionLanguage with name `sClassName` and
     * enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, AstExpressionLanguage>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.rules.ui.services.AstExpressionLanguage.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:dataChange dataChange} event of this `sap.rules.ui.services.AstExpressionLanguage`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.rules.ui.services.AstExpressionLanguage` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDataChange(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.rules.ui.services.AstExpressionLanguage`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:dataChange dataChange} event of this `sap.rules.ui.services.AstExpressionLanguage`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.rules.ui.services.AstExpressionLanguage` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDataChange(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.rules.ui.services.AstExpressionLanguage`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:dataChange dataChange} event of this `sap.rules.ui.services.AstExpressionLanguage`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachDataChange(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:dataChange dataChange} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireDataChange(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets current value of property {@link #getBindingContextPath bindingContextPath}.
     *
     * Path to a Vocabulary object in the model data, which is used for the definition of relative context bindings
     * inside the Ast Expression Language control (mandatory). Example: "/Vocabularies(Id='0050569181751ED683EFEEC6AA2B73C5')"
     *
     *
     * @returns Value of property `bindingContextPath`
     */
    getBindingContextPath(): string;
    /**
     * Sets a new value for property {@link #getBindingContextPath bindingContextPath}.
     *
     * Path to a Vocabulary object in the model data, which is used for the definition of relative context bindings
     * inside the Ast Expression Language control (mandatory). Example: "/Vocabularies(Id='0050569181751ED683EFEEC6AA2B73C5')"
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setBindingContextPath(
      /**
       * New value for property `bindingContextPath`
       */
      sBindingContextPath: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the AstExpressionLanguage constructor.
   */
  export interface $AstExpressionLanguageSettings extends $ElementSettings {
    /**
     * Path to a Vocabulary object in the model data, which is used for the definition of relative context bindings
     * inside the Ast Expression Language control (mandatory). Example: "/Vocabularies(Id='0050569181751ED683EFEEC6AA2B73C5')"
     */
    bindingContextPath?: string | PropertyBindingInfo;

    dataChange?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the AstExpressionLanguage#dataChange event.
   */
  export interface AstExpressionLanguage$DataChangeEventParameters {}

  /**
   * Event object of the AstExpressionLanguage#dataChange event.
   */
  export type AstExpressionLanguage$DataChangeEvent = Event<
    AstExpressionLanguage$DataChangeEventParameters,
    AstExpressionLanguage
  >;
}

declare module "sap/rules/ui/services/ExpressionLanguage" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import Event from "sap/ui/base/Event";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { ExpressionType } from "sap/rules/ui/library";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Provides the ExpressionLanguage service functionality, such as expression validations, expression parsing,
   * auto-complete suggestions, retrieving expression metadata and tokens, and performing runtime services
   * (fetching data objects, outputs, etc).
   *
   * @deprecated As of version 1.120.2. use the attribute astExpressionLanguage instead.
   */
  export default class ExpressionLanguage extends UI5Element {
    /**
     * Constructor for a new ExpressionLanguage element.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor();

    /**
     * Creates a new subclass of class sap.rules.ui.services.ExpressionLanguage with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ExpressionLanguage>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.rules.ui.services.ExpressionLanguage.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:dataChange dataChange} event of this `sap.rules.ui.services.ExpressionLanguage`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.rules.ui.services.ExpressionLanguage` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDataChange(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.rules.ui.services.ExpressionLanguage`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:dataChange dataChange} event of this `sap.rules.ui.services.ExpressionLanguage`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.rules.ui.services.ExpressionLanguage` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDataChange(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.rules.ui.services.ExpressionLanguage`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:dataChange dataChange} event of this `sap.rules.ui.services.ExpressionLanguage`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachDataChange(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:dataChange dataChange} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireDataChange(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets current value of property {@link #getBindingContextPath bindingContextPath}.
     *
     * Path to a Vocabulary object in the model data, which is used for the definition of relative context bindings
     * inside the Expression Language control (mandatory). Example: "/Vocabularies(Id='0050569181751ED683EFEEC6AA2B73C5')"
     *
     *
     * @returns Value of property `bindingContextPath`
     */
    getBindingContextPath(): string;
    /**
     * Separates the expression into individual tokens.
     *
     *
     * @returns [oResult] Returns the tokens and their semantic information.
     */
    getExpressionMetadata(
      /**
       * The expression that has to be tokenized.
       */
      sExpression?: string
    ): object;
    /**
     * Provides a context-sensitive suggestion list that assists the business user with the completion of the
     * input of an expression using the rule expression language.
     *
     *
     * @returns [oResult] Returns valid suggestions for the expression that needs to be completed. If tokenizing
     * was requested, returns the semantics of the tokens identified in the whole expression.
     */
    getSuggestions(
      /**
       * The rule expression to be completed.
       */
      sExpression?: string,
      /**
       * The expected business data type of the expression.
       */
      eType?: ExpressionType | keyof typeof ExpressionType,
      /**
       * Indicates whether the final expression is a collection.
       */
      bCollection?: boolean,
      /**
       * Indicates whether to return tokenizing sementics.
       */
      bToken?: boolean
    ): object;
    /**
     * Gets current value of property {@link #getValueHelpCallback valueHelpCallback}.
     *
     * The valueHelpCallback is a function that receives by reference an array of value help metadata and adds
     * to each item an OData model instance. The OData model is used for suggesting allowed values and for validating
     * values that are used in the rule.
     *
     *
     * @returns Value of property `valueHelpCallback`
     */
    getValueHelpCallback(): any;
    /**
     * Sets a new value for property {@link #getBindingContextPath bindingContextPath}.
     *
     * Path to a Vocabulary object in the model data, which is used for the definition of relative context bindings
     * inside the Expression Language control (mandatory). Example: "/Vocabularies(Id='0050569181751ED683EFEEC6AA2B73C5')"
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setBindingContextPath(
      /**
       * New value for property `bindingContextPath`
       */
      sBindingContextPath: string
    ): this;
    /**
     * Sets the expression language data (vocabulary and metadata).
     */
    setData(
      /**
       * Contains the language data
       */
      oData?: object
    ): void;
    /**
     * Sets a new value for property {@link #getValueHelpCallback valueHelpCallback}.
     *
     * The valueHelpCallback is a function that receives by reference an array of value help metadata and adds
     * to each item an OData model instance. The OData model is used for suggesting allowed values and for validating
     * values that are used in the rule.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setValueHelpCallback(
      /**
       * New value for property `valueHelpCallback`
       */
      oValueHelpCallback: any
    ): this;
    /**
     * Validates a given rule expression according to a specific business data type.
     *
     *
     * @returns [oResult] Sends the validation status. In case of success, returns the actual data type of the
     * whole expression). In case of error, returns error details and cursor position of error. If tokenizing
     * was requested, returns the semantics of the tokens identified in the whole expression. If value help
     * use is identified a promise deferredResult is added to the oResult object. deferredResult is resolved
     * with an oResult object that includes validation results also for value help.
     */
    validateExpression(
      /**
       * The expression to be validated.
       */
      sExpression?: string,
      /**
       * The expected data type of the expression.
       */
      eType?: ExpressionType | keyof typeof ExpressionType,
      /**
       * Indicates whether the expression is a collection.
       */
      bCollection?: boolean,
      /**
       * Indicates whether to return tokenizing semantics.
       */
      bToken?: boolean
    ): object;
  }
  /**
   * Describes the settings that can be provided to the ExpressionLanguage constructor.
   *
   * @deprecated As of version 1.120.2. use the attribute astExpressionLanguage instead.
   */
  export interface $ExpressionLanguageSettings extends $ElementSettings {
    /**
     * The valueHelpCallback is a function that receives by reference an array of value help metadata and adds
     * to each item an OData model instance. The OData model is used for suggesting allowed values and for validating
     * values that are used in the rule.
     */
    valueHelpCallback?: any | PropertyBindingInfo | `{${string}}`;

    /**
     * Path to a Vocabulary object in the model data, which is used for the definition of relative context bindings
     * inside the Expression Language control (mandatory). Example: "/Vocabularies(Id='0050569181751ED683EFEEC6AA2B73C5')"
     */
    bindingContextPath?: string | PropertyBindingInfo;

    dataChange?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the ExpressionLanguage#dataChange event.
   */
  export interface ExpressionLanguage$DataChangeEventParameters {}

  /**
   * Event object of the ExpressionLanguage#dataChange event.
   */
  export type ExpressionLanguage$DataChangeEvent = Event<
    ExpressionLanguage$DataChangeEventParameters,
    ExpressionLanguage
  >;
}

declare module "sap/rules/ui/TextRuleConfiguration" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  import Event from "sap/ui/base/Event";

  /**
   * The `sap.rules.ui.TextRuleConfiguration` element provides the ability to define specific properties that
   * will be applied when rendering the `sap.rules.ui.RuleBuilder` in decision table mode.
   *
   * @since 1.4
   */
  export default class TextRuleConfiguration extends UI5Element {
    /**
     * Constructor for a new TextRuleConfiguration.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $TextRuleConfigurationSettings
    );
    /**
     * Constructor for a new TextRuleConfiguration.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $TextRuleConfigurationSettings
    );

    /**
     * Creates a new subclass of class sap.rules.ui.TextRuleConfiguration with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, TextRuleConfiguration>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.rules.ui.TextRuleConfiguration.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:change change} event of this `sap.rules.ui.TextRuleConfiguration`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.rules.ui.TextRuleConfiguration` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachChange(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: TextRuleConfiguration$ChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.rules.ui.TextRuleConfiguration`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:change change} event of this `sap.rules.ui.TextRuleConfiguration`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.rules.ui.TextRuleConfiguration` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachChange(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: TextRuleConfiguration$ChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.rules.ui.TextRuleConfiguration`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:change change} event of this `sap.rules.ui.TextRuleConfiguration`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachChange(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: TextRuleConfiguration$ChangeEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:change change} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireChange(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: TextRuleConfiguration$ChangeEventParameters
    ): this;
    /**
     * Gets current value of property {@link #getEnableElse enableElse}.
     *
     * The value determines whether the Else section is displayed in a Text Rule when the control is used with
     * S/4 HANA 17.05 (Cloud) or 17.09 (On Premise) and higher (On Premise).
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `enableElse`
     */
    getEnableElse(): boolean;
    /**
     * Gets current value of property {@link #getEnableElseIf enableElseIf}.
     *
     * The value determines whether the Else If section is displayed in a Text Rule when the control is used
     * with S/4 HANA 17.05 (Cloud) or 17.09 (On Premise) and higher (On Premise).
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `enableElseIf`
     */
    getEnableElseIf(): boolean;
    /**
     * Gets current value of property {@link #getEnableSettingResult enableSettingResult}.
     *
     * Default value is `true`.
     *
     * @deprecated As of version 1.120.2. to configure the settings, use the Manage Rules Project app or the
     * Rule Authoring APIs.
     *
     * @returns Value of property `enableSettingResult`
     */
    getEnableSettingResult(): boolean;
    /**
     * Gets current value of property {@link #getEnableSettings enableSettings}.
     *
     * The value determines whether the Settings button is displayed in a Text Rule when the control is used
     * with S/4 HANA 17.05 (Cloud) or 17.09 (On Premise) and higher (On Premise).
     *
     * Default value is `false`.
     *
     * @deprecated As of version 1.120.2. to configure the settings, use the Manage Rules Project app or the
     * Rule Authoring APIs.
     *
     * @returns Value of property `enableSettings`
     */
    getEnableSettings(): boolean;
    /**
     * Sets a new value for property {@link #getEnableElse enableElse}.
     *
     * The value determines whether the Else section is displayed in a Text Rule when the control is used with
     * S/4 HANA 17.05 (Cloud) or 17.09 (On Premise) and higher (On Premise).
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnableElse(
      /**
       * New value for property `enableElse`
       */
      bEnableElse?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getEnableElseIf enableElseIf}.
     *
     * The value determines whether the Else If section is displayed in a Text Rule when the control is used
     * with S/4 HANA 17.05 (Cloud) or 17.09 (On Premise) and higher (On Premise).
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnableElseIf(
      /**
       * New value for property `enableElseIf`
       */
      bEnableElseIf?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getEnableSettingResult enableSettingResult}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     * @deprecated As of version 1.120.2. to configure the settings, use the Manage Rules Project app or the
     * Rule Authoring APIs.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnableSettingResult(
      /**
       * New value for property `enableSettingResult`
       */
      bEnableSettingResult?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getEnableSettings enableSettings}.
     *
     * The value determines whether the Settings button is displayed in a Text Rule when the control is used
     * with S/4 HANA 17.05 (Cloud) or 17.09 (On Premise) and higher (On Premise).
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @deprecated As of version 1.120.2. to configure the settings, use the Manage Rules Project app or the
     * Rule Authoring APIs.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnableSettings(
      /**
       * New value for property `enableSettings`
       */
      bEnableSettings?: boolean
    ): this;
  }
  /**
   * Describes the settings that can be provided to the TextRuleConfiguration constructor.
   */
  export interface $TextRuleConfigurationSettings extends $ElementSettings {
    /**
     * The value determines whether the Settings button is displayed in a Text Rule when the control is used
     * with S/4 HANA 17.05 (Cloud) or 17.09 (On Premise) and higher (On Premise).
     *
     * @deprecated As of version 1.120.2. to configure the settings, use the Manage Rules Project app or the
     * Rule Authoring APIs.
     */
    enableSettings?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * @deprecated As of version 1.120.2. to configure the settings, use the Manage Rules Project app or the
     * Rule Authoring APIs.
     */
    enableSettingResult?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * The value determines whether the Else section is displayed in a Text Rule when the control is used with
     * S/4 HANA 17.05 (Cloud) or 17.09 (On Premise) and higher (On Premise).
     */
    enableElse?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * The value determines whether the Else If section is displayed in a Text Rule when the control is used
     * with S/4 HANA 17.05 (Cloud) or 17.09 (On Premise) and higher (On Premise).
     */
    enableElseIf?: boolean | PropertyBindingInfo | `{${string}}`;

    change?: (oEvent: TextRuleConfiguration$ChangeEvent) => void;
  }

  /**
   * Parameters of the TextRuleConfiguration#change event.
   */
  export interface TextRuleConfiguration$ChangeEventParameters {
    name?: undefined;

    value?: undefined;
  }

  /**
   * Event object of the TextRuleConfiguration#change event.
   */
  export type TextRuleConfiguration$ChangeEvent = Event<
    TextRuleConfiguration$ChangeEventParameters,
    TextRuleConfiguration
  >;
}

declare namespace sap {
  interface IUI5DefineDependencyNames {
    "sap/rules/ui/DecisionTableConfiguration": undefined;

    "sap/rules/ui/library": undefined;

    "sap/rules/ui/RuleBuilder": undefined;

    "sap/rules/ui/services/AstExpressionLanguage": undefined;

    "sap/rules/ui/services/ExpressionLanguage": undefined;

    "sap/rules/ui/TextRuleConfiguration": undefined;
  }
}
