// For Library Version: 1.136.3

declare module "sap/ui/vk/library" {
  /**
   * Contract for objects that provide access to animation playbacks.
   */
  export interface IPlaybackCollection {
    __implements__sap_ui_vk_IPlaybackCollection: boolean;
  }
}

declare module "sap/ui/vk/AnimationPlayer" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import Event from "sap/ui/base/Event";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { ID } from "sap/ui/core/library";

  import ViewStateManagerBase from "sap/ui/vk/ViewStateManagerBase";

  /**
   * Provides definition for an animation playback
   *
   * @experimental As of version 1.67.0. This class is experimental and might be modified or removed in future
   * versions.
   */
  export default class AnimationPlayer extends UI5Element {
    /**
     * Constructor for a new AnimationPlayer.
     *
     * The objects of this class contain necessary information to define how an animation sequence is played
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor();

    /**
     * Creates a new subclass of class sap.ui.vk.AnimationPlayer with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, AnimationPlayer>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.AnimationPlayer.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:beforeTimeChanged beforeTimeChanged} event of
     * this `sap.ui.vk.AnimationPlayer`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.AnimationPlayer` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachBeforeTimeChanged(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.AnimationPlayer` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:beforeTimeChanged beforeTimeChanged} event of
     * this `sap.ui.vk.AnimationPlayer`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.AnimationPlayer` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachBeforeTimeChanged(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.AnimationPlayer` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:stateChanged stateChanged} event of this `sap.ui.vk.AnimationPlayer`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.AnimationPlayer` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachStateChanged(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.AnimationPlayer` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:stateChanged stateChanged} event of this `sap.ui.vk.AnimationPlayer`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.AnimationPlayer` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachStateChanged(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.AnimationPlayer` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:timeChanged timeChanged} event of this `sap.ui.vk.AnimationPlayer`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.AnimationPlayer` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachTimeChanged(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.AnimationPlayer` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:timeChanged timeChanged} event of this `sap.ui.vk.AnimationPlayer`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.AnimationPlayer` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachTimeChanged(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.AnimationPlayer` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:viewActivated viewActivated} event of this `sap.ui.vk.AnimationPlayer`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.AnimationPlayer` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachViewActivated(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.AnimationPlayer` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:viewActivated viewActivated} event of this `sap.ui.vk.AnimationPlayer`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.AnimationPlayer` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachViewActivated(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.AnimationPlayer` itself
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:beforeTimeChanged beforeTimeChanged} event
     * of this `sap.ui.vk.AnimationPlayer`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachBeforeTimeChanged(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:stateChanged stateChanged} event of this `sap.ui.vk.AnimationPlayer`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachStateChanged(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:timeChanged timeChanged} event of this `sap.ui.vk.AnimationPlayer`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachTimeChanged(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:viewActivated viewActivated} event of this
     * `sap.ui.vk.AnimationPlayer`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachViewActivated(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:beforeTimeChanged beforeTimeChanged} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireBeforeTimeChanged(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:stateChanged stateChanged} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireStateChanged(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:timeChanged timeChanged} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireTimeChanged(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:viewActivated viewActivated} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireViewActivated(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Get the animated property of a node at the current time, should be called after {@link sap.ui.vk.AnimationPlayer#setTime setTime}.
     *
     *
     * @returns An object with the following properties:
     * 	 - For `Translate`, `Rotate`, `Scale`:
     * 	`offsetToRest: float[]` - translation, scale or rotation in quaternion form relative to the values of
     * the rest transformation. If the property is not defined, `null` is assigned.
     * 	 - `offsetToPrevious: float[]` - translation, scale or rotation relative to the values at the end of
     *     the previous playback or the values of the rest transformation for the first playback. If the property
     *     is not defined, `null` is assigned. Rotation is assigned in the form in which the animation track is
     *     defined.
     * 	 - `absolute: float[]` - values of translation, scale or rotation in quaternion form in the parent's
     *     coordinate space.
     * 	 - `world: float[]` - values of translation, scale or rotation in quaternion form in the world coordinate
     *     space.
     * 	 - For `Opacity`:
     * 	`offsetToRest: float` - opacity relative to the rest opacity. If the property is not defined, `null`
     * is assigned.
     * 	 - `offsetToPrevious: float` - opacity relative to the value at the end of the previous playback or
     *     the rest opacity for the first playback. If the property is not defined, `null` is assigned.
     * 	 - `opacity: float` - the node's own opacity
     * 	 - `totalOpacity: float` - the product of opacity values from all the ancestors and the node's own opacity.
     */
    getAnimatedProperty(
      /**
       * A node reference
       */
      nodeRef: any,
      /**
       * A property name
       */
      property: /* was: sap.ui.vk.AnimationTrackType */ any
    ): object;
    /**
     * Gets animation playback currently playing.
     *
     *
     * @returns animation playback.
     */
    getCurrentPlayback(): /* was: sap.ui.vk.AnimationPlayback */ any;
    /**
     * Gets current animation time position in the current animation playback.
     *
     *
     * @returns animation time.
     */
    getCurrentPlaybackTime(): float;
    /**
     * Gets start time for specified animation playback.
     *
     *
     * @returns animation start time.
     */
    getStartTime(
      /**
       * Animation playback or animation playback index in the current view.
       */
      playback: /* was: sap.ui.vk.AnimationPlayback */ any | int
    ): float;
    /**
     * Gets current absolute animation time position.
     *
     *
     * @returns animation time.
     */
    getTime(): float;
    /**
     * Gets current total animation duration.
     *
     *
     * @returns animation duration.
     */
    getTotalDuration(): float;
    /**
     * ID of the element which is the current target of the association {@link #getViewStateManager viewStateManager},
     * or `null`.
     */
    getViewStateManager(): ID | null;
    /**
     * Starts playing animation from the current time position.
     *
     *
     * @returns `this` to allow method chaining.
     */
    play(): this;
    /**
     * Moves animation to a specified time.
     *
     *
     * @returns `this` to allow method chaining.
     */
    setTime(
      /**
       * Time to set
       */
      time: float,
      /**
       * Optional, when specified, `time` is relative to beginning of specified playback.
       */
      playbackIndex: int,
      /**
       * Optional, block the beforeTimeChanged and timeChanged events
       */
      blockTimeChangeEvents: boolean
    ): this;
    /**
     * Moves animation to a specified time.
     *
     *
     * @returns `this` to allow method chaining.
     */
    setTime(
      /**
       * Time to set
       */
      time: float,
      /**
       * Optional, block the beforeTimeChanged and timeChanged events
       */
      blockTimeChangeEvents: boolean
    ): this;
    /**
     * Sets the associated {@link #getViewStateManager viewStateManager}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setViewStateManager(
      /**
       * ID of an element which becomes the new target of this viewStateManager association; alternatively, an
       * element instance may be given
       */
      oViewStateManager: ID | ViewStateManagerBase
    ): this;
    /**
     * Stops playing animation.
     *
     *
     * @returns `this` to allow method chaining.
     */
    stop(): this;
  }
  /**
   * Describes the settings that can be provided to the AnimationPlayer constructor.
   *
   * @experimental As of version 1.67.0. This class is experimental and might be modified or removed in future
   * versions.
   */
  export interface $AnimationPlayerSettings extends $ElementSettings {
    viewStateManager?: ViewStateManagerBase | string;

    viewActivated?: (oEvent: Event) => void;

    beforeTimeChanged?: (oEvent: Event) => void;

    timeChanged?: (oEvent: Event) => void;

    stateChanged?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the AnimationPlayer#beforeTimeChanged event.
   */
  export interface AnimationPlayer$BeforeTimeChangedEventParameters {}

  /**
   * Event object of the AnimationPlayer#beforeTimeChanged event.
   */
  export type AnimationPlayer$BeforeTimeChangedEvent = Event<
    AnimationPlayer$BeforeTimeChangedEventParameters,
    AnimationPlayer
  >;

  /**
   * Parameters of the AnimationPlayer#stateChanged event.
   */
  export interface AnimationPlayer$StateChangedEventParameters {}

  /**
   * Event object of the AnimationPlayer#stateChanged event.
   */
  export type AnimationPlayer$StateChangedEvent = Event<
    AnimationPlayer$StateChangedEventParameters,
    AnimationPlayer
  >;

  /**
   * Parameters of the AnimationPlayer#timeChanged event.
   */
  export interface AnimationPlayer$TimeChangedEventParameters {}

  /**
   * Event object of the AnimationPlayer#timeChanged event.
   */
  export type AnimationPlayer$TimeChangedEvent = Event<
    AnimationPlayer$TimeChangedEventParameters,
    AnimationPlayer
  >;

  /**
   * Parameters of the AnimationPlayer#viewActivated event.
   */
  export interface AnimationPlayer$ViewActivatedEventParameters {}

  /**
   * Event object of the AnimationPlayer#viewActivated event.
   */
  export type AnimationPlayer$ViewActivatedEvent = Event<
    AnimationPlayer$ViewActivatedEventParameters,
    AnimationPlayer
  >;
}

declare module "sap/ui/vk/Annotation" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import Viewport from "sap/ui/vk/Viewport";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import AnnotationStyle from "sap/ui/vk/AnnotationStyle";

  import { ID } from "sap/ui/core/library";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Annotation allows applications to display custom html annotation on top of Viewport and associate it
   * with 3D object
   *
   * @experimental As of version 1.76.0. This class is experimental and might be modified or removed in future
   * versions.
   */
  export default class Annotation extends Control {
    /**
     * Constructor for a new Annotation.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor();

    /**
     * The main method for creation of annotations
     *
     *
     * @returns Newly create annotation
     */
    static createAnnotation(
      /**
       * Object with annotation settings
       */
      divAnnotation: any,
      /**
       * Viewport where annotation are displayed
       */
      viewport: Viewport
    ): Annotation;
    /**
     * Creates a new subclass of class sap.ui.vk.Annotation with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Annotation>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.Annotation.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Destroys the textEditor in the aggregation {@link #getTextEditor textEditor}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyTextEditor(): this;
    /**
     * Adjust annotation size to fit text
     *
     *
     * @returns `this` to allow method chaining
     */
    fitToText(
      /**
       * If set then maximum width of annotation will be limited to this number in pixels.
       */
      maxWidth?: number,
      /**
       * If set then maximum height of annotation will be limited to this number in pixels.
       */
      maxHeight?: number
    ): this;
    /**
     * Gets current value of property {@link #getAnimate animate}.
     *
     * Controls the animation of the annotation. If set to `false` then animation is not played.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `animate`
     */
    getAnimate(): boolean;
    /**
     * Gets current value of property {@link #getAnimationDelay animationDelay}.
     *
     * Amount of time in seconds to wait before animation is played. Default value of -1 means that this is
     * not set.
     *
     * Default value is `-1`.
     *
     *
     * @returns Value of property `animationDelay`
     */
    getAnimationDelay(): float;
    /**
     * Gets current value of property {@link #getAnnotationId annotationId}.
     *
     * Reference to the annotation Id
     *
     *
     * @returns Value of property `annotationId`
     */
    getAnnotationId(): string;
    /**
     * Gets current value of property {@link #getDisplay display}.
     *
     * Controls the visibility of the annotation
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `display`
     */
    getDisplay(): boolean;
    /**
     * Gets current value of property {@link #getEditable editable}.
     *
     * If annotation is editable then double click event is fired when user double clicks on the annotation
     * and text editing is allowed by calling openEditor() method. If annotation is also selected then resize
     * and reposition handles will be displayed.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `editable`
     */
    getEditable(): boolean;
    /**
     * Gets current value of property {@link #getHeight height}.
     *
     * Sets the height of the annotation. This uses a scale of 0 to 1, 0% to 100% respectively. This is relative
     * to the Viewport's safe area if present, otherwise it is relative to the Viewport. Negative values will
     * be ignored.
     *
     *
     * @returns Value of property `height`
     */
    getHeight(): float;
    /**
     * Gets current value of property {@link #getName name}.
     *
     * Reference to the annotation name
     *
     *
     * @returns Value of property `name`
     */
    getName(): string;
    /**
     * Gets current value of property {@link #getNodeRef nodeRef}.
     *
     * Reference to the node that represents the annotation
     *
     *
     * @returns Value of property `nodeRef`
     */
    getNodeRef(): any;
    /**
     * Gets current value of property {@link #getSelected selected}.
     *
     * Controls the annotation selected state
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `selected`
     */
    getSelected(): boolean;
    /**
     * Gets current value of property {@link #getStyle style}.
     *
     * The style of the annotation
     *
     * Default value is `Default`.
     *
     *
     * @returns Value of property `style`
     */
    getStyle(): AnnotationStyle;
    /**
     * Return list of target nodes.
     *
     *
     * @returns Target nodes for leader lines
     */
    getTargetNodes(): any[];
    /**
     * Gets current value of property {@link #getText text}.
     *
     * The text that will be displayed in the annotation
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `text`
     */
    getText(): string;
    /**
     * Gets content of aggregation {@link #getTextEditor textEditor}.
     */
    getTextEditor(): Control;
    /**
     * Get transformation matrix from the annotation node
     *
     *
     * @returns The transformation matrix
     */
    getTransform(): number[];
    /**
     * ID of the element which is the current target of the association {@link #getViewport viewport}, or `null`.
     */
    getViewport(): ID | null;
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * Sets the width of the annotation. This uses a scale of 0 to 1, 0% to 100% respectively. This is relative
     * to the Viewport's safe area if present, otherwise it is relative to the Viewport. Negative values will
     * be ignored.
     *
     *
     * @returns Value of property `width`
     */
    getWidth(): float;
    /**
     * Gets current value of property {@link #getXCoordinate xCoordinate}.
     *
     * Sets the X Coordinate of the annotation. This uses a scale of -0.5 to 0.5, left to right respectively.
     * This is relative to the Viewport's safe area if present, otherwise it is relative to the Viewport.
     *
     * Default value is `0`.
     *
     *
     * @returns Value of property `xCoordinate`
     */
    getXCoordinate(): float;
    /**
     * Gets current value of property {@link #getXOffset xOffset}.
     *
     * Sets horizontal offset of annotation's position relative to the point where it should be normally placed.
     * Can be used to offset annotation from attachment node (if set). This uses a scale of -0.5 to 0.5, left
     * to right respectively.
     *
     * Default value is `0`.
     *
     *
     * @returns Value of property `xOffset`
     */
    getXOffset(): float;
    /**
     * Gets current value of property {@link #getYCoordinate yCoordinate}.
     *
     * Sets the Y Coordinate of the annotation. This uses a scale of -0.5 to 0.5, top to bottom respectively.
     * This is relative to the Viewport's safe area if present, otherwise it is relative to the Viewport.
     *
     * Default value is `0`.
     *
     *
     * @returns Value of property `yCoordinate`
     */
    getYCoordinate(): float;
    /**
     * Gets current value of property {@link #getYOffset yOffset}.
     *
     * Sets horizontal offset of annotation's position relative to the point where it should be normally placed.
     * Can be used to offset annotation from attachment node (if set). This uses a scale of -0.5 to 0.5, top
     * to bottom respectively.
     *
     * Default value is `0`.
     *
     *
     * @returns Value of property `yOffset`
     */
    getYOffset(): float;
    /**
     * Sets a new value for property {@link #getAnimate animate}.
     *
     * Controls the animation of the annotation. If set to `false` then animation is not played.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAnimate(
      /**
       * New value for property `animate`
       */
      bAnimate?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getAnimationDelay animationDelay}.
     *
     * Amount of time in seconds to wait before animation is played. Default value of -1 means that this is
     * not set.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `-1`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAnimationDelay(
      /**
       * New value for property `animationDelay`
       */
      fAnimationDelay?: float
    ): this;
    /**
     * Sets a new value for property {@link #getAnnotationId annotationId}.
     *
     * Reference to the annotation Id
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAnnotationId(
      /**
       * New value for property `annotationId`
       */
      sAnnotationId: string
    ): this;
    /**
     * Sets a new value for property {@link #getDisplay display}.
     *
     * Controls the visibility of the annotation
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDisplay(
      /**
       * New value for property `display`
       */
      bDisplay?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getEditable editable}.
     *
     * If annotation is editable then double click event is fired when user double clicks on the annotation
     * and text editing is allowed by calling openEditor() method. If annotation is also selected then resize
     * and reposition handles will be displayed.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEditable(
      /**
       * New value for property `editable`
       */
      bEditable?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getHeight height}.
     *
     * Sets the height of the annotation. This uses a scale of 0 to 1, 0% to 100% respectively. This is relative
     * to the Viewport's safe area if present, otherwise it is relative to the Viewport. Negative values will
     * be ignored.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHeight(
      /**
       * New value for property `height`
       */
      fHeight: float
    ): this;
    /**
     * Adjust annotation size and position so it is placed close to the object it's pointing to. This method
     * can be used if precise position is not known by the application.
     *
     *
     * @returns `this` to allow method chaining
     */
    setInitialOffset(): this;
    /**
     * Sets a new value for property {@link #getName name}.
     *
     * Reference to the annotation name
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setName(
      /**
       * New value for property `name`
       */
      sName: string
    ): this;
    /**
     * Sets a new value for property {@link #getNodeRef nodeRef}.
     *
     * Reference to the node that represents the annotation
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setNodeRef(
      /**
       * New value for property `nodeRef`
       */
      oNodeRef: any
    ): this;
    /**
     * Sets a new value for property {@link #getSelected selected}.
     *
     * Controls the annotation selected state
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSelected(
      /**
       * New value for property `selected`
       */
      bSelected?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getStyle style}.
     *
     * The style of the annotation
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Default`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setStyle(
      /**
       * New value for property `style`
       */
      sStyle?: AnnotationStyle | keyof typeof AnnotationStyle
    ): this;
    /**
     * Sets a new value for property {@link #getText text}.
     *
     * The text that will be displayed in the annotation
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setText(
      /**
       * New value for property `text`
       */
      sText?: string
    ): this;
    /**
     * Sets the aggregated {@link #getTextEditor textEditor}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTextEditor(
      /**
       * The textEditor to set
       */
      oTextEditor: Control
    ): this;
    /**
     * Set transformation matrix to the annotation node
     *
     *
     * @returns `this` to allow method chaining.
     */
    setTransform(
      /**
       * The transformation matrix
       */
      transform: number[]
    ): this;
    /**
     * Sets the associated {@link #getViewport viewport}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setViewport(
      /**
       * ID of an element which becomes the new target of this viewport association; alternatively, an element
       * instance may be given
       */
      oViewport: ID | Viewport
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * Sets the width of the annotation. This uses a scale of 0 to 1, 0% to 100% respectively. This is relative
     * to the Viewport's safe area if present, otherwise it is relative to the Viewport. Negative values will
     * be ignored.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      fWidth: float
    ): this;
    /**
     * Sets a new value for property {@link #getXCoordinate xCoordinate}.
     *
     * Sets the X Coordinate of the annotation. This uses a scale of -0.5 to 0.5, left to right respectively.
     * This is relative to the Viewport's safe area if present, otherwise it is relative to the Viewport.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `0`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setXCoordinate(
      /**
       * New value for property `xCoordinate`
       */
      fXCoordinate?: float
    ): this;
    /**
     * Sets a new value for property {@link #getXOffset xOffset}.
     *
     * Sets horizontal offset of annotation's position relative to the point where it should be normally placed.
     * Can be used to offset annotation from attachment node (if set). This uses a scale of -0.5 to 0.5, left
     * to right respectively.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `0`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setXOffset(
      /**
       * New value for property `xOffset`
       */
      fXOffset?: float
    ): this;
    /**
     * Sets a new value for property {@link #getYCoordinate yCoordinate}.
     *
     * Sets the Y Coordinate of the annotation. This uses a scale of -0.5 to 0.5, top to bottom respectively.
     * This is relative to the Viewport's safe area if present, otherwise it is relative to the Viewport.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `0`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setYCoordinate(
      /**
       * New value for property `yCoordinate`
       */
      fYCoordinate?: float
    ): this;
    /**
     * Sets a new value for property {@link #getYOffset yOffset}.
     *
     * Sets horizontal offset of annotation's position relative to the point where it should be normally placed.
     * Can be used to offset annotation from attachment node (if set). This uses a scale of -0.5 to 0.5, top
     * to bottom respectively.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `0`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setYOffset(
      /**
       * New value for property `yOffset`
       */
      fYOffset?: float
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Annotation constructor.
   *
   * @experimental As of version 1.76.0. This class is experimental and might be modified or removed in future
   * versions.
   */
  export interface $AnnotationSettings extends $ControlSettings {
    /**
     * Reference to the annotation Id
     */
    annotationId?: string | PropertyBindingInfo;

    /**
     * Reference to the annotation name
     */
    name?: string | PropertyBindingInfo;

    /**
     * Reference to the node that represents the annotation
     */
    nodeRef?: any | PropertyBindingInfo | `{${string}}`;

    /**
     * The text that will be displayed in the annotation
     */
    text?: string | PropertyBindingInfo;

    /**
     * The style of the annotation
     */
    style?:
      | (AnnotationStyle | keyof typeof AnnotationStyle)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Controls the visibility of the annotation
     */
    display?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Controls the animation of the annotation. If set to `false` then animation is not played.
     */
    animate?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Amount of time in seconds to wait before animation is played. Default value of -1 means that this is
     * not set.
     */
    animationDelay?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * Controls the annotation selected state
     */
    selected?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * If annotation is editable then double click event is fired when user double clicks on the annotation
     * and text editing is allowed by calling openEditor() method. If annotation is also selected then resize
     * and reposition handles will be displayed.
     */
    editable?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Sets the X Coordinate of the annotation. This uses a scale of -0.5 to 0.5, left to right respectively.
     * This is relative to the Viewport's safe area if present, otherwise it is relative to the Viewport.
     */
    xCoordinate?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * Sets the Y Coordinate of the annotation. This uses a scale of -0.5 to 0.5, top to bottom respectively.
     * This is relative to the Viewport's safe area if present, otherwise it is relative to the Viewport.
     */
    yCoordinate?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * Sets horizontal offset of annotation's position relative to the point where it should be normally placed.
     * Can be used to offset annotation from attachment node (if set). This uses a scale of -0.5 to 0.5, left
     * to right respectively.
     */
    xOffset?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * Sets horizontal offset of annotation's position relative to the point where it should be normally placed.
     * Can be used to offset annotation from attachment node (if set). This uses a scale of -0.5 to 0.5, top
     * to bottom respectively.
     */
    yOffset?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * Sets the height of the annotation. This uses a scale of 0 to 1, 0% to 100% respectively. This is relative
     * to the Viewport's safe area if present, otherwise it is relative to the Viewport. Negative values will
     * be ignored.
     */
    height?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * Sets the width of the annotation. This uses a scale of 0 to 1, 0% to 100% respectively. This is relative
     * to the Viewport's safe area if present, otherwise it is relative to the Viewport. Negative values will
     * be ignored.
     */
    width?: float | PropertyBindingInfo | `{${string}}`;

    textEditor?: Control;

    viewport?: Viewport | string;
  }
}

declare module "sap/ui/vk/AnnotationStyle" {
  /**
   * Sets the animation style type for annotation text.
   */
  enum AnnotationStyle {
    /**
     * Style 1
     */
    Default = "Default",
    /**
     * Style 5
     */
    Expand = "Expand",
    /**
     * Style 2
     */
    Explode = "Explode",
    /**
     * Style 4
     */
    Random = "Random",
    /**
     * Style 3
     */
    Square = "Square",
  }
  export default AnnotationStyle;
}

declare module "sap/ui/vk/ContentConnector" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import ContentResource from "sap/ui/vk/ContentResource";

  import ViewStateManagerBase from "sap/ui/vk/ViewStateManagerBase";

  import Event from "sap/ui/base/Event";

  import { AggregationBindingInfo } from "sap/ui/base/ManagedObject";

  import ContentManager from "sap/ui/vk/ContentManager";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  /**
   * Contract for authorization callback function
   *
   * A callback function which can be implemented by an application to provide an authorization token. Such
   * a function receives a single parameter which is a connection URL and must return a promise which will
   * be resolved to {@link https://www.oauth.com/oauth2-servers/access-tokens/access-token-response/ Access Token Response }
   * when authorization token is obtained.
   *
   * A sample implementation of authorization handler::
   * ```javascript
   *
   * ...
   * var viewer = new sap.ui.vk.Viewer();
   * viewer.setAuthorizationHandler(function(url) {
   *     var headers = new Headers();
   *     headers.append("Content-Type", "application/x-www-form-urlencoded");
   *     headers.append("Authorization", "Basic " + basicAuth);
   *
   *     return fetch(accessTokenUrl, {
   *             method: "POST",
   *             body: "grant_type=client_credentials",
   *             headers: headers
   *         }).then(response => response.json())
   * });
   * ...
   * ```
   *
   *
   * @since 1.60.0
   */
  export interface AuthorizationHandler {
    __implements__sap_ui_vk_AuthorizationHandler: boolean;
  }

  /**
   * Provides an object that owns content resources, tracks their changes and loads and destroys the content
   * built from the content resources.
   */
  export default class ContentConnector extends UI5Element {
    /**
     * Constructor for a new ContentConnector.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new ContentConnector object.
       */
      mSettings?: $ContentConnectorSettings
    );
    /**
     * Constructor for a new ContentConnector.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new ContentConnector object. Generated automatically if no ID is given.
       */
      sId?: string,
      /**
       * Initial settings for the new ContentConnector object.
       */
      mSettings?: $ContentConnectorSettings
    );

    /**
     * Adds a new content manager resolver.
     *
     * The last added resolver will be executed the first.
     *
     * Content manager resolver analyzes the content resource definition and returns the type of the content
     * manager to use for loading the content resource.
     *
     * The simplest resolver tests the content resource source type. The test can be either a string comparison
     * or a regular expression.
     *
     * A more sophisticated resolver is a function that can use the full content resource definition to find
     * a proper content manager dynamically, e.g. the resolver can use the 'HEAD' HTTP request to get the 'Content-Type'
     * header to find out the type of the content resource.
     *
     * @since 1.50.0
     *
     * @returns The {@link sap.ui.vk.ContentConnector sap.ui.vk.ContentConnector} class to allow method chaining.
     */
    static addContentManagerResolver(
      /**
       * Object that defines how to find out the content manager class name.
       *  If `resolver` is a function then this function takes one parameter of type {@link sap.ui.vk.ContentResource sap.ui.vk.ContentResource }
       * and returns a {@link https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Promise Promise }
       * that resolves with an object with the following properties:
       * 	 - `dimension: int` - dimension of the model. E.g. 2 or 3.
       * 	 - `contentManagerClassName: string` - name of content manager class to use for loading the content
       *     resource.
       * 	 - `settings: object` - optional settings specific to the content manager.
       *  See {@link sap.ui.vk.threejs.ContentManager sap.ui.vk.threejs.ContentManager}.  If `resolver` is
       * an object then it has the following properties:
       */
      resolver:
        | Function
        | {
            /**
             * The pattern the {@link sap.ui.vk.ContentResource#getSourceType sourceType} property of the content resource
             * is compared with.
             */
            pattern?: string | RegExp;
            /**
             * Dimension of models of this source type. E.g. 2 or 3.
             */
            dimension?: int;
            /**
             * Name of the content manager class to use for loading content resources of this type. E.g. sap.ui.vk.dvl.ContentManager,
             * sap.ui.vk.threejs.ContentManager, sap.ui.vk.ImageContentManager.
             */
            contentManagerClassName?: string;
            /**
             * Optional settings specific to the content manager class.
             */
            settings?: object;
          }
    ): Function;
    /**
     * Creates a new subclass of class sap.ui.vk.ContentConnector with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ContentConnector>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.ContentConnector.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Removes all content manager resolvers.
     *
     * @since 1.50.0
     *
     * @returns The {@link sap.ui.vk.ContentConnector sap.ui.vk.ContentConnector} class to allow method chaining.
     */
    static removeAllContentManagerResolvers(): Function;
    /**
     * Removes a content manager resolver.
     *
     * If there are more than one content manager resolver matching the `resolver` the last added is removed.
     *
     * @since 1.50.0
     *
     * @returns `true` if a matching resolver is found and removed, `false` otherwise.
     */
    static removeContentManagerResolver(
      /**
       * Object that defines how to find out the content manager class name.
       */
      resolver: Function | string | RegExp | object
    ): boolean;
    /**
     * Adds some contentResource to the aggregation {@link #getContentResources contentResources}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addContentResource(
      /**
       * The contentResource to add; if empty, nothing is inserted
       */
      oContentResource: ContentResource
    ): this;
    /**
     * Adds some viewStateManager to the aggregation {@link #getViewStateManagers viewStateManagers}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addViewStateManager(
      /**
       * The viewStateManager to add; if empty, nothing is inserted
       */
      oViewStateManager: ViewStateManagerBase
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:contentChangesFinished contentChangesFinished }
     * event of this `sap.ui.vk.ContentConnector`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.ContentConnector` itself.
     *
     * This event will be fired when any content resource or the contentResources aggregation has been changed
     * and processed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachContentChangesFinished(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ContentConnector$ContentChangesFinishedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.ContentConnector` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:contentChangesFinished contentChangesFinished }
     * event of this `sap.ui.vk.ContentConnector`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.ContentConnector` itself.
     *
     * This event will be fired when any content resource or the contentResources aggregation has been changed
     * and processed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachContentChangesFinished(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ContentConnector$ContentChangesFinishedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.ContentConnector` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:contentChangesProgress contentChangesProgress }
     * event of this `sap.ui.vk.ContentConnector`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.ContentConnector` itself.
     *
     * This event will be fired to report the progress of content changes.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachContentChangesProgress(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ContentConnector$ContentChangesProgressEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.ContentConnector` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:contentChangesProgress contentChangesProgress }
     * event of this `sap.ui.vk.ContentConnector`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.ContentConnector` itself.
     *
     * This event will be fired to report the progress of content changes.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachContentChangesProgress(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ContentConnector$ContentChangesProgressEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.ContentConnector` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:contentChangesStarted contentChangesStarted }
     * event of this `sap.ui.vk.ContentConnector`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.ContentConnector` itself.
     *
     * This event will be fired when content resource changes are about to be processed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachContentChangesStarted(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.ContentConnector` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:contentChangesStarted contentChangesStarted }
     * event of this `sap.ui.vk.ContentConnector`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.ContentConnector` itself.
     *
     * This event will be fired when content resource changes are about to be processed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachContentChangesStarted(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.ContentConnector` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:contentDestroying contentDestroying} event of
     * this `sap.ui.vk.ContentConnector`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.ContentConnector` itself.
     *
     * This event will be fired when the current content is about to be destroyed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachContentDestroying(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ContentConnector$ContentDestroyingEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.ContentConnector` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:contentDestroying contentDestroying} event of
     * this `sap.ui.vk.ContentConnector`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.ContentConnector` itself.
     *
     * This event will be fired when the current content is about to be destroyed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachContentDestroying(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ContentConnector$ContentDestroyingEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.ContentConnector` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:contentLoadingFinished contentLoadingFinished }
     * event of this `sap.ui.vk.ContentConnector`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.ContentConnector` itself.
     *
     * This event will be fired when content loading is finished.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachContentLoadingFinished(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ContentConnector$ContentLoadingFinishedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.ContentConnector` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:contentLoadingFinished contentLoadingFinished }
     * event of this `sap.ui.vk.ContentConnector`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.ContentConnector` itself.
     *
     * This event will be fired when content loading is finished.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachContentLoadingFinished(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ContentConnector$ContentLoadingFinishedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.ContentConnector` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:contentReplaced contentReplaced} event of this
     * `sap.ui.vk.ContentConnector`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.ContentConnector` itself.
     *
     * This event will be fired when the current content is completely rebuilt or destroyed as a result of changes
     * in content resources.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachContentReplaced(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ContentConnector$ContentReplacedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.ContentConnector` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:contentReplaced contentReplaced} event of this
     * `sap.ui.vk.ContentConnector`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.ContentConnector` itself.
     *
     * This event will be fired when the current content is completely rebuilt or destroyed as a result of changes
     * in content resources.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachContentReplaced(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ContentConnector$ContentReplacedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.ContentConnector` itself
       */
      oListener?: object
    ): this;
    /**
     * Binds aggregation {@link #getContentResources contentResources} to model data.
     *
     * See {@link sap.ui.base.ManagedObject#bindAggregation ManagedObject.bindAggregation} for a detailed description
     * of the possible properties of `oBindingInfo`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    bindContentResources(
      /**
       * The binding information
       */
      oBindingInfo: AggregationBindingInfo
    ): this;
    /**
     * Destroys all the contentResources in the aggregation {@link #getContentResources contentResources}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyContentResources(): this;
    /**
     * Destroys all the viewStateManagers in the aggregation {@link #getViewStateManagers viewStateManagers}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyViewStateManagers(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:contentChangesFinished contentChangesFinished }
     * event of this `sap.ui.vk.ContentConnector`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachContentChangesFinished(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: ContentConnector$ContentChangesFinishedEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:contentChangesProgress contentChangesProgress }
     * event of this `sap.ui.vk.ContentConnector`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachContentChangesProgress(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: ContentConnector$ContentChangesProgressEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:contentChangesStarted contentChangesStarted }
     * event of this `sap.ui.vk.ContentConnector`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachContentChangesStarted(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:contentDestroying contentDestroying} event
     * of this `sap.ui.vk.ContentConnector`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachContentDestroying(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: ContentConnector$ContentDestroyingEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:contentLoadingFinished contentLoadingFinished }
     * event of this `sap.ui.vk.ContentConnector`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachContentLoadingFinished(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: ContentConnector$ContentLoadingFinishedEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:contentReplaced contentReplaced} event of
     * this `sap.ui.vk.ContentConnector`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachContentReplaced(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: ContentConnector$ContentReplacedEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:contentChangesFinished contentChangesFinished} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireContentChangesFinished(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: ContentConnector$ContentChangesFinishedEventParameters
    ): this;
    /**
     * Fires event {@link #event:contentChangesProgress contentChangesProgress} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireContentChangesProgress(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: ContentConnector$ContentChangesProgressEventParameters
    ): this;
    /**
     * Fires event {@link #event:contentChangesStarted contentChangesStarted} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireContentChangesStarted(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:contentDestroying contentDestroying} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireContentDestroying(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: ContentConnector$ContentDestroyingEventParameters
    ): this;
    /**
     * Fires event {@link #event:contentLoadingFinished contentLoadingFinished} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireContentLoadingFinished(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: ContentConnector$ContentLoadingFinishedEventParameters
    ): this;
    /**
     * Fires event {@link #event:contentReplaced contentReplaced} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireContentReplaced(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: ContentConnector$ContentReplacedEventParameters
    ): this;
    /**
     * Gets the content currently loaded.
     *
     * @since 1.50.0
     *
     * @returns The content loaded. It can be HTMLImageElement, sap.ui.vk.Scene etc.
     */
    getContent(): any;
    /**
     * Gets the content manager used to load the current content.
     *
     * @since 1.50.0
     *
     * @returns The content manager used to load the current content.
     */
    getContentManager(): ContentManager;
    /**
     * Gets content of aggregation {@link #getContentResources contentResources}.
     *
     * Content resources to load and display.
     */
    getContentResources(): ContentResource[];
    /**
     * Gets the default view state manager.
     *
     * The type of the default view state manager depends on the type of the currently loaded content.
     *
     * @since 1.99.0
     *
     * @returns The default view state manager or `null`.
     */
    getDefaultViewStateManager(): ViewStateManagerBase | null;
    /**
     * Gets content of aggregation {@link #getViewStateManagers viewStateManagers}.
     *
     * View state managers.
     */
    getViewStateManagers(): ViewStateManagerBase[];
    /**
     * Checks for the provided `sap.ui.vk.ContentResource` in the aggregation {@link #getContentResources contentResources}.
     * and returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfContentResource(
      /**
       * The contentResource whose index is looked for
       */
      oContentResource: ContentResource
    ): int;
    /**
     * Checks for the provided `sap.ui.vk.ViewStateManagerBase` in the aggregation {@link #getViewStateManagers viewStateManagers}.
     * and returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfViewStateManager(
      /**
       * The viewStateManager whose index is looked for
       */
      oViewStateManager: ViewStateManagerBase
    ): int;
    /**
     * Inserts a contentResource into the aggregation {@link #getContentResources contentResources}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertContentResource(
      /**
       * The contentResource to insert; if empty, nothing is inserted
       */
      oContentResource: ContentResource,
      /**
       * The `0`-based index the contentResource should be inserted at; for a negative value of `iIndex`, the
       * contentResource is inserted at position 0; for a value greater than the current size of the aggregation,
       * the contentResource is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Inserts a viewStateManager into the aggregation {@link #getViewStateManagers viewStateManagers}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertViewStateManager(
      /**
       * The viewStateManager to insert; if empty, nothing is inserted
       */
      oViewStateManager: ViewStateManagerBase,
      /**
       * The `0`-based index the viewStateManager should be inserted at; for a negative value of `iIndex`, the
       * viewStateManager is inserted at position 0; for a value greater than the current size of the aggregation,
       * the viewStateManager is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getContentResources contentResources}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllContentResources(): ContentResource[];
    /**
     * Removes all the controls from the aggregation {@link #getViewStateManagers viewStateManagers}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllViewStateManagers(): ViewStateManagerBase[];
    /**
     * Removes a contentResource from the aggregation {@link #getContentResources contentResources}.
     *
     *
     * @returns The removed contentResource or `null`
     */
    removeContentResource(
      /**
       * The contentResource to remove or its index or id
       */
      vContentResource: int | string | ContentResource
    ): ContentResource | null;
    /**
     * Removes a viewStateManager from the aggregation {@link #getViewStateManagers viewStateManagers}.
     *
     *
     * @returns The removed viewStateManager or `null`
     */
    removeViewStateManager(
      /**
       * The viewStateManager to remove or its index or id
       */
      vViewStateManager: int | string | ViewStateManagerBase
    ): ViewStateManagerBase | null;
    /**
     * Sets a callback function which will be used to obtain authorization token when connected to remote server.
     *
     * @since 1.60.0
     *
     * @returns Reference to `this` in order to allow method chaining.
     */
    setAuthorizationHandler(
      /**
       * An application defined callback function that can provide authorization token.
       */
      handler: AuthorizationHandler
    ): this;
    /**
     * Set the consumption scenario (used in SAP/partner applications).
     *
     * @since 1.114.0
     *
     * @returns `this` to allow method chaining.
     */
    setConsumptionScenario(
      /**
       * The consumption scenario.
       */
      consumptionScenario: string
    ): this;
    /**
     * Sets an object that decrypts content of encrypted models.
     *
     * @since 1.60.0
     *
     * @returns Reference to `this` in order to allow method chaining.
     */
    setDecryptionHandler(
      /**
       * An object that decrypts content of encrypted models.
       */
      handler: DecryptionHandler
    ): this;
    /**
     * Sets the maximum number of retry attempts for a download operation if the initial request to retrieve
     * a model from a remote server could not be fulfilled and the error with which the request failed is considered
     * recoverable.
     *
     * Retry Mechanism: Requests to retrieve (download) a model from a remote server may not always be fulfilled.
     * If the request failed with an error that is considered recoverable then the download manager will
     * keep on trying issuing new requests until the request is fulfilled or the specified `retryCount` is exceeded.
     *
     * The default number of retry attempts is 1, unless specified otherwise by calling this method. Note that,
     * specifying 0 as `retryCount` disables the retry mechanism altogether.
     *
     * **Timing of retry attempts**: There is no delay between subsequent attempts.
     *
     * **Events fired**: The download manager will not fire any events between subsequent attempts. For
     * each requested item there will be a single `itemSucceeded` or `itemFailed` event fired when the download
     * operation for that given item finishes.
     *
     * **Recoverable errors**: The following errors are considered recoverable:
     * 	 - Any kind of network error (e.g. due to temporary network outage). HTTP status code is expected to
     *     be 0.
     * 	 - Responses with the following 4xx-5xx HTTP status codes:
     * 	408: Request Timeout
     * 	 - 425: Too Early (RFC 8470)
     * 	 - 429: Too Many Requests (RFC 6585)
     * 	 - 500: Internal Server Error
     * 	 - 502: Bad Gateway
     * 	 - 503: Service Unavailable
     * 	 - 504: Gateway Timeout
     *
     * @since 1.95.0
     *
     * @returns Reference to `this` in order to allow method chaining.
     */
    setRetryCount(
      /**
       * Maximum number of retry attempts. Value must be non-negative. The default retry count is 1, unless specified
       * otherwise by calling this method and passing in the desired value. Passing in 0 disables any retry attempts.
       */
      retryCount: int
    ): this;
    /**
     * Unbinds aggregation {@link #getContentResources contentResources} from model data.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    unbindContentResources(): this;
  }
  /**
   * Contract for objects that implement decryption.
   *
   * An interface for an object provided by an application to decrypt content of encrypted models.
   *
   * Content is encrypted with the {@link https://en.wikipedia.org/wiki/Advanced_Encryption_Standard AES128 }
   * algorithm in the {@link https://en.wikipedia.org/wiki/Block_cipher_mode_of_operation#Cipher_Block_Chaining_.28CBC.29 CBC }
   * mode.
   *
   * A key is derived with the {@link https://en.wikipedia.org/wiki/PBKDF2 PBKDF2} algorithm by applying the
   * {@link https://en.wikipedia.org/wiki/Hash-based_message_authentication_code HMAC}-{@link https://en.wikipedia.org/wiki/SHA-2 SHA256 }
   * function 10,000 times.
   *
   * A sample implementation and usage of the sap.ui.vk.DecryptionHandler interface with the {@link https://cdnjs.cloudflare.com/ajax/libs/asmCrypto/0.16.4/asmcrypto.js asmCrypto }
   * library::
   * ```javascript
   *
   * ...
   * <script src="https://cdnjs.cloudflare.com/ajax/libs/asmCrypto/0.16.4/asmcrypto.js"></script>
   * ...
   * var decryptionHandler = {
   *     deriveKey: function(salt, password) {
   *         try {
   *             return asmCrypto.PBKDF2_HMAC_SHA256.bytes(password, salt, 10000, 16);
   *         } catch (ex) {
   *             return null;
   *         }
   *     },
   *     decrypt: function(key, iv, input) {
   *         try {
   *             return asmCrypto.AES_CBC.decrypt(input, key, true, iv);
   *         } catch (ex) {
   *             return null;
   *         }
   *     }
   * };
   * ...
   * var viewer = new sap.ui.vk.Viewer();
   * viewer.setDecryptionHandler(decryptionHandler);
   * var contentResource = new sap.ui.vk.ContentResource({
   *     source: "http://my-web-server.com/my-encrypted-model.vds",
   *     sourceType: "vds",
   *     sourceId: "abc",
   *     password: "abracadabra"
   * });
   * viewer.addContentResource(contentResource);
   * ```
   *
   *
   * @since 1.38.0
   */
  export interface DecryptionHandler {
    __implements__sap_ui_vk_DecryptionHandler: boolean;

    /**
     * Decrypts the input buffer with the {@link https://en.wikipedia.org/wiki/Advanced_Encryption_Standard AES128 }
     * algorithm in the {@link https://en.wikipedia.org/wiki/Block_cipher_mode_of_operation#Cipher_Block_Chaining_.28CBC.29 CBC }
     * mode.
     *
     *
     * @returns The decrypted buffer.
     */
    decrypt(
      /**
       * The derived key generated by the previous call to {@link sap.ui.vk.DecryptionHandler#deriveKey sap.ui.vk.DecryptionHandler.deriveKey}.
       */
      key: object,
      /**
       * The 128-bit {@link https://en.wikipedia.org/wiki/Initialization_vector initialization vector}.
       */
      iv: Uint8Array,
      /**
       * The encrypted buffer.
       */
      encryptedData: Uint8Array
    ): Uint8Array;
    /**
     * Generates a cryptographic session key derived from a base data value.
     *
     * The key must be derived with the {@link https://en.wikipedia.org/wiki/PBKDF2 PBKDF2} algorithm by applying
     * the {@link https://en.wikipedia.org/wiki/Hash-based_message_authentication_code HMAC}-{@link https://en.wikipedia.org/wiki/SHA-2 SHA256 }
     * function 10,000 times.
     *
     * The resulting 128-bit key should be passed to subsequent calls to {@link sap.ui.vk.DecryptionHandler#decrypt sap.ui.vk.DecryptionHandler.decrypt}.
     *
     *
     * @returns A derived 128-bit key that should be passed to subsequent calls to {@link sap.ui.vk.DecryptionHandler#decrypt sap.ui.vk.DecryptionHandler.decrypt}.
     */
    deriveKey(
      /**
       * Random data that is used as an additional input to a one-way function that "hashes" a password or passphrase.
       */
      salt: Uint8Array,
      /**
       * A password used for encryption/decryption.
       */
      password: Uint8Array
    ): object;
  }

  /**
   * Describes the settings that can be provided to the ContentConnector constructor.
   */
  export interface $ContentConnectorSettings extends $ElementSettings {
    /**
     * Content resources to load and display.
     */
    contentResources?:
      | ContentResource[]
      | ContentResource
      | AggregationBindingInfo
      | `{${string}}`;

    /**
     * View state managers.
     */
    viewStateManagers?:
      | ViewStateManagerBase[]
      | ViewStateManagerBase
      | AggregationBindingInfo
      | `{${string}}`;

    /**
     * This event will be fired when content resource changes are about to be processed.
     */
    contentChangesStarted?: (oEvent: Event) => void;

    /**
     * This event will be fired when any content resource or the contentResources aggregation has been changed
     * and processed.
     */
    contentChangesFinished?: (
      oEvent: ContentConnector$ContentChangesFinishedEvent
    ) => void;

    /**
     * This event will be fired to report the progress of content changes.
     */
    contentChangesProgress?: (
      oEvent: ContentConnector$ContentChangesProgressEvent
    ) => void;

    /**
     * This event will be fired when content loading is finished.
     */
    contentLoadingFinished?: (
      oEvent: ContentConnector$ContentLoadingFinishedEvent
    ) => void;

    /**
     * This event will be fired when the current content is completely rebuilt or destroyed as a result of changes
     * in content resources.
     */
    contentReplaced?: (oEvent: ContentConnector$ContentReplacedEvent) => void;

    /**
     * This event will be fired when the current content is about to be destroyed.
     */
    contentDestroying?: (
      oEvent: ContentConnector$ContentDestroyingEvent
    ) => void;
  }

  /**
   * Parameters of the ContentConnector#contentChangesFinished event.
   */
  export interface ContentConnector$ContentChangesFinishedEventParameters {
    /**
     * The content created or updated.
     *
     * The content can be of type HTMLImageElement, sap.ui.vk.Scene etc.
     */
    content?: any;

    /**
     * The failure reason if any.
     *  An single element or an array of elements with the following structure:
     * 	error - An object with details of the error. contentResource - A {@link sap.ui.vk.ContentResource sap.ui.vk.ContentResource }
     * object when it is possible to match the Error object to a {@link sap.ui.vk.ContentResource sap.ui.vk.ContentResource }
     * object.
     */
    failureReason?: any;
  }

  /**
   * Event object of the ContentConnector#contentChangesFinished event.
   */
  export type ContentConnector$ContentChangesFinishedEvent = Event<
    ContentConnector$ContentChangesFinishedEventParameters,
    ContentConnector
  >;

  /**
   * Parameters of the ContentConnector#contentChangesProgress event.
   */
  export interface ContentConnector$ContentChangesProgressEventParameters {
    /**
     * The name of the loading phase. It can be e.g. 'downloading', 'building the scene' etc. It might be null
     * if reporting this parameter does not make sense.
     */
    phase?: string;

    /**
     * The overall percentage of the loading process.
     */
    percentage?: float;

    /**
     * The content resource currently being loaded. It might be null if reporting this parameter does not make
     * sense.
     */
    source?: any;
  }

  /**
   * Event object of the ContentConnector#contentChangesProgress event.
   */
  export type ContentConnector$ContentChangesProgressEvent = Event<
    ContentConnector$ContentChangesProgressEventParameters,
    ContentConnector
  >;

  /**
   * Parameters of the ContentConnector#contentChangesStarted event.
   */
  export interface ContentConnector$ContentChangesStartedEventParameters {}

  /**
   * Event object of the ContentConnector#contentChangesStarted event.
   */
  export type ContentConnector$ContentChangesStartedEvent = Event<
    ContentConnector$ContentChangesStartedEventParameters,
    ContentConnector
  >;

  /**
   * Parameters of the ContentConnector#contentDestroying event.
   */
  export interface ContentConnector$ContentDestroyingEventParameters {
    /**
     * The content to be destroyed.
     *
     * The content can be of type HTMLImageElement, sap.ui.vk.Scene etc.
     */
    content?: any;

    /**
     * Returns a `function(prevent: boolean)` with one boolean parameter. To prevent garbage collection after
     * the content is destroyed call this function passing `true` as a parameter.
     */
    preventGarbageCollection?: Function;
  }

  /**
   * Event object of the ContentConnector#contentDestroying event.
   */
  export type ContentConnector$ContentDestroyingEvent = Event<
    ContentConnector$ContentDestroyingEventParameters,
    ContentConnector
  >;

  /**
   * Parameters of the ContentConnector#contentLoadingFinished event.
   */
  export interface ContentConnector$ContentLoadingFinishedEventParameters {
    source?: any;

    node?: any;
  }

  /**
   * Event object of the ContentConnector#contentLoadingFinished event.
   */
  export type ContentConnector$ContentLoadingFinishedEvent = Event<
    ContentConnector$ContentLoadingFinishedEventParameters,
    ContentConnector
  >;

  /**
   * Parameters of the ContentConnector#contentReplaced event.
   */
  export interface ContentConnector$ContentReplacedEventParameters {
    /**
     * New content.
     *
     * The content can be of type HTMLImageElement, sap.ui.vk.Scene etc.
     */
    newContent?: any;

    /**
     * Old content.
     *
     * The content can be of type HTMLImageElement, sap.ui.vk.Scene etc.
     */
    oldContent?: any;
  }

  /**
   * Event object of the ContentConnector#contentReplaced event.
   */
  export type ContentConnector$ContentReplacedEvent = Event<
    ContentConnector$ContentReplacedEventParameters,
    ContentConnector
  >;
}

declare module "sap/ui/vk/BaseNodeProxy" {
  import BaseObject from "sap/ui/base/Object";

  import { Poolable } from "sap/ui/base/ObjectPool";

  import Metadata from "sap/ui/base/Metadata";

  import NodeHierarchy from "sap/ui/vk/NodeHierarchy";

  /**
   * Provides a simple, lightweight proxy object to a node in a node hierarchy.
   *
   * The objects of this class should not be created directly, and should only be created through the use
   * of the following methods:
   * 	 - {@link sap.ui.vk.NodeHierarchy#enumerateChildren sap.ui.vk.NodeHierarchy.enumerateChildren}
   * 	 - {@link sap.ui.vk.NodeHierarchy#enumerateAncestors sap.ui.vk.NodeHierarchy.enumerateAncestors}
   * 	 - {@link sap.ui.vk.ViewStateManager#enumerateSelection sap.ui.vk.ViewStateManager.enumerateSelection }
   */
  export default abstract class BaseNodeProxy
    extends BaseObject
    implements Poolable, BaseNodeProxy
  {
    __implements__sap_ui_base_Poolable: boolean;
    __implements__sap_ui_vk_BaseNodeProxy: boolean;
    /**
     * Constructor for a new BaseNodeProxy. The objects of this class should not be created directly, and should
     * only be created through the use of the following methods:
     * 	 - {@link sap.ui.vk.NodeHierarchy#enumerateChildren sap.ui.vk.NodeHierarchy.enumerateChildren}
     * 	 - {@link sap.ui.vk.NodeHierarchy#enumerateAncestors sap.ui.vk.NodeHierarchy.enumerateAncestors}
     * 	 - {@link sap.ui.vk.ViewStateManager#enumerateSelection sap.ui.vk.ViewStateManager.enumerateSelection }
     *
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     *
     * This class does not have its own settings, but all settings applicable to the base type {@link sap.ui.base.Object#constructor sap.ui.base.Object }
     * can be used.
     */
    constructor();

    /**
     * Creates a new subclass of class sap.ui.vk.BaseNodeProxy with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.base.Object.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, BaseNodeProxy>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.BaseNodeProxy.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): Metadata;
    /**
     * Indicates whether the node has child nodes.
     *
     *
     * @returns A value of `true` indicates that the node has child nodes, and a value of `false` indicates
     * otherwise.
     */
    getHasChildren(): boolean;
    /**
     * Gets the name of the node.
     *
     *
     * @returns The node's name.
     */
    getName(): string;
    /**
     * Gets the ID of the node.
     *
     *
     * @returns The node's ID.
     */
    getNodeId(): string;
    /**
     * Gets the metadata of the node.
     *
     *
     * @returns A JSON object containing the node's metadata.
     */
    getNodeMetadata(): object;
    /**
     * Gets the reference object of the node.
     *
     *
     * @returns The node's reference object.
     */
    getNodeRef(): any;
    /**
     * Gets the scene reference that this BaseNodeProxy object wraps.
     *
     *
     * @returns A scene reference that this BaseNodeProxy object wraps.
     */
    getSceneRef(): any;
    /**
     * Initialize this BaseNodeProxy with its data.
     *
     * The `init` method is called by an object pool when the object is (re-)activated for a new caller.
     * See:
     * 	sap.ui.base.Poolable.prototype#init
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    init(
      /**
       * The NodeHierarchy object this BaseNodeProxy object belongs to.
       */
      nodeHierarchy: NodeHierarchy,
      /**
       * The ID or reference (depending on the concrete BaseNodeProxy implementation) of the node for which to
       * get BaseNodeProxy.
       */
      nodeRef: any
    ): void;
    /**
     * Reset BaseNodeProxy data, needed for pooling.
     * See:
     * 	sap.ui.base.Poolable.prototype#reset
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    reset(): void;
  }
}

declare module "sap/ui/vk/Camera" {
  import {
    default as ManagedObject,
    $ManagedObjectSettings,
    PropertyBindingInfo,
  } from "sap/ui/base/ManagedObject";

  import ManagedObjectMetadata from "sap/ui/base/ManagedObjectMetadata";

  /**
   * Provides the base interface for the camera.
   *
   * The objects of this class should not be created directly. Use PerspectiveCamera or OrthographicCamera
   * instead.
   *
   * @since 1.52.0
   */
  export default abstract class Camera extends ManagedObject {
    /**
     * Constructor for a new Camera.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor();

    /**
     * Creates a new subclass of class sap.ui.vk.Camera with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.base.ManagedObject.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Camera>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.Camera.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ManagedObjectMetadata;
    /**
     *
     * @returns Camera reference that this camera class wraps
     */
    getCameraRef(): any;
    /**
     * Gets current value of property {@link #getFarClipPlane farClipPlane}.
     *
     * Far clipping plane distance
     *
     * Default value is `1.0`.
     *
     *
     * @returns Value of property `farClipPlane`
     */
    getFarClipPlane(): float;
    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Flag indicating if camera object is modified
     */
    getIsModified(): boolean;
    /**
     * Gets current value of property {@link #getNearClipPlane nearClipPlane}.
     *
     * Near clipping plane distance
     *
     * Default value is `0.1`.
     *
     *
     * @returns Value of property `nearClipPlane`
     */
    getNearClipPlane(): float;
    /**
     * Gets current value of property {@link #getPosition position}.
     *
     * Camera position in global space (x, y, z coordinates)
     *
     * Default value is `[0, 0, 0]`.
     *
     *
     * @returns Value of property `position`
     */
    getPosition(): float[];
    /**
     * Gets current value of property {@link #getTargetDirection targetDirection}.
     *
     * Camera direction vector in global space (normalized x, y, z vector values)
     *
     * Default value is `[1, 0, 0]`.
     *
     *
     * @returns Value of property `targetDirection`
     */
    getTargetDirection(): float[];
    /**
     * Gets current value of property {@link #getUpDirection upDirection}.
     *
     * Camera up vector in global space (normalized x, y, z vector values)
     *
     * Default value is `[0, 1, 0]`.
     *
     *
     * @returns Value of property `upDirection`
     */
    getUpDirection(): float[];
    /**
     * Sets a new value for property {@link #getFarClipPlane farClipPlane}.
     *
     * Far clipping plane distance
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `1.0`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFarClipPlane(
      /**
       * New value for property `farClipPlane`
       */
      fFarClipPlane?: float
    ): this;
    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    setIsModified(
      /**
       * Set or reset flag to indicate if this object is modified
       */
      val: boolean
    ): void;
    /**
     * Sets a new value for property {@link #getNearClipPlane nearClipPlane}.
     *
     * Near clipping plane distance
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `0.1`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setNearClipPlane(
      /**
       * New value for property `nearClipPlane`
       */
      fNearClipPlane?: float
    ): this;
    /**
     * Sets a new value for property {@link #getPosition position}.
     *
     * Camera position in global space (x, y, z coordinates)
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `[0, 0, 0]`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPosition(
      /**
       * New value for property `position`
       */
      sPosition?: float[]
    ): this;
    /**
     * Sets a new value for property {@link #getTargetDirection targetDirection}.
     *
     * Camera direction vector in global space (normalized x, y, z vector values)
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `[1, 0, 0]`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTargetDirection(
      /**
       * New value for property `targetDirection`
       */
      sTargetDirection?: float[]
    ): this;
    /**
     * Sets a new value for property {@link #getUpDirection upDirection}.
     *
     * Camera up vector in global space (normalized x, y, z vector values)
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `[0, 1, 0]`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setUpDirection(
      /**
       * New value for property `upDirection`
       */
      sUpDirection?: float[]
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Camera constructor.
   */
  export interface $CameraSettings extends $ManagedObjectSettings {
    /**
     * Camera position in global space (x, y, z coordinates)
     */
    position?: float[] | PropertyBindingInfo | `{${string}}`;

    /**
     * Camera direction vector in global space (normalized x, y, z vector values)
     */
    targetDirection?: float[] | PropertyBindingInfo | `{${string}}`;

    /**
     * Camera up vector in global space (normalized x, y, z vector values)
     */
    upDirection?: float[] | PropertyBindingInfo | `{${string}}`;

    /**
     * Near clipping plane distance
     */
    nearClipPlane?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * Far clipping plane distance
     */
    farClipPlane?: float | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/ui/vk/CameraFOVBindingType" {
  /**
   * Camera field of view binding types.
   */
  enum CameraFOVBindingType {
    /**
     * The field of view is bound to the width of the viewport.
     */
    Horizontal = "horizontal",
    /**
     * The field of view is bound to the width or the height of the viewport, whichever is bigger.
     */
    Maximum = "maximum",
    /**
     * The field of view is bound to the width or the height of the viewport, whichever is smaller.
     */
    Minimum = "minimum",
    /**
     * The field of view is bound to the height of the viewport.
     */
    Vertical = "vertical",
  }
  export default CameraFOVBindingType;
}

declare module "sap/ui/vk/CameraProjectionType" {
  /**
   * Camera projection type.
   */
  enum CameraProjectionType {
    /**
     * {@link https://en.wikipedia.org/wiki/3D_projection#Orthographic_projection Orthographic projection}
     */
    Orthographic = "orthographic",
    /**
     * {@link https://en.wikipedia.org/wiki/3D_projection#Perspective_projection Perspective projection}
     */
    Perspective = "perspective",
  }
  export default CameraProjectionType;
}

declare module "sap/ui/vk/ContainerBase" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import { ID } from "sap/ui/core/library";

  import ContainerContent from "sap/ui/vk/ContainerContent";

  import Event from "sap/ui/base/Event";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  /**
   * Abstract Constructor for a new Container.
   *
   * @since 1.38.0
   * @deprecated As of version 1.120.2. This object is moved to sap.ui.vbm namespace, see {@link sap.ui.vbm.ContainerBase}
   */
  export default class ContainerBase extends Control {
    /**
     * Abstract Constructor for a new Container.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $ContainerBaseSettings
    );
    /**
     * Abstract Constructor for a new Container.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $ContainerBaseSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vk.ContainerBase with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ContainerBase>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.ContainerBase.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * adjusts customizable buttons of overflow toolbar, displays content buttons
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    _addToolbarContent(): void;
    /**
     * Adds some ariaDescribedBy into the association {@link #getAriaDescribedBy ariaDescribedBy}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addAriaDescribedBy(
      /**
       * The ariaDescribedBy to add; if empty, nothing is inserted
       */
      vAriaDescribedBy: ID | Control
    ): this;
    /**
     * Adds some ariaLabelledBy into the association {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addAriaLabelledBy(
      /**
       * The ariaLabelledBy to add; if empty, nothing is inserted
       */
      vAriaLabelledBy: ID | Control
    ): this;
    /**
     * add container content - map, table..
     */
    addContent(
      /**
       * content object to add
       */
      oObject: ContainerContent
    ): void;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:contentChange contentChange} event of this `sap.ui.vk.ContainerBase`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.ContainerBase` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachContentChange(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ContainerBase$ContentChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.ContainerBase` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:contentChange contentChange} event of this `sap.ui.vk.ContainerBase`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.ContainerBase` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachContentChange(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ContainerBase$ContentChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.ContainerBase` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:settingsPressed settingsPressed} event of this
     * `sap.ui.vk.ContainerBase`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.ContainerBase` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSettingsPressed(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.ContainerBase` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:settingsPressed settingsPressed} event of this
     * `sap.ui.vk.ContainerBase`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.ContainerBase` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSettingsPressed(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.ContainerBase` itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys all the content in the aggregation {@link #getContent content}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyContent(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:contentChange contentChange} event of this
     * `sap.ui.vk.ContainerBase`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachContentChange(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: ContainerBase$ContentChangeEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:settingsPressed settingsPressed} event of
     * this `sap.ui.vk.ContainerBase`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachSettingsPressed(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:contentChange contentChange} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireContentChange(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: ContainerBase$ContentChangeEventParameters
    ): this;
    /**
     * Fires event {@link #event:settingsPressed settingsPressed} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireSettingsPressed(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Returns array of IDs of the elements which are the current targets of the association {@link #getAriaDescribedBy ariaDescribedBy}.
     */
    getAriaDescribedBy(): ID[];
    /**
     * Returns array of IDs of the elements which are the current targets of the association {@link #getAriaLabelledBy ariaLabelledBy}.
     */
    getAriaLabelledBy(): ID[];
    /**
     * Gets current value of property {@link #getAutoAdjustHeight autoAdjustHeight}.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `autoAdjustHeight`
     */
    getAutoAdjustHeight(): boolean;
    /**
     * Gets content of aggregation {@link #getContent content}.
     *
     * Content Aggregation.
     */
    getContent(): ContainerContent[];
    /**
     * Gets current value of property {@link #getFullScreen fullScreen}.
     *
     * Controls whether the control is show fullscreen or embedded
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `fullScreen`
     */
    getFullScreen(): boolean;
    /**
     * get selected content
     *
     *
     * @returns the currently selected content container
     */
    getSelectedContent(): ContainerContent;
    /**
     * Gets current value of property {@link #getShowFullScreen showFullScreen}.
     *
     * Show fullscreen toggle button in toolbar
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `showFullScreen`
     */
    getShowFullScreen(): boolean;
    /**
     * Gets current value of property {@link #getShowSelection showSelection}.
     *
     * Show selection button in toolbar
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `showSelection`
     */
    getShowSelection(): boolean;
    /**
     * Gets current value of property {@link #getShowSettings showSettings}.
     *
     * Show settings button in toolbar
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `showSettings`
     */
    getShowSettings(): boolean;
    /**
     * Gets current value of property {@link #getTitle title}.
     *
     * Title to show in toolbar
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `title`
     */
    getTitle(): string;
    /**
     * Checks for the provided `sap.ui.vk.ContainerContent` in the aggregation {@link #getContent content}.
     * and returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfContent(
      /**
       * The content whose index is looked for
       */
      oContent: ContainerContent
    ): int;
    /**
     * insert container content - map, table..
     */
    insertContent(
      /**
       * content object to insert
       */
      oObject: ContainerContent,
      /**
       * index in the content aggregation where to insert the new content object
       */
      iIndex: int
    ): void;
    /**
     * Removes all the controls in the association named {@link #getAriaDescribedBy ariaDescribedBy}.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllAriaDescribedBy(): ID[];
    /**
     * Removes all the controls in the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllAriaLabelledBy(): ID[];
    /**
     * Removes all the controls from the aggregation {@link #getContent content}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllContent(): ContainerContent[];
    /**
     * Removes an ariaDescribedBy from the association named {@link #getAriaDescribedBy ariaDescribedBy}.
     *
     *
     * @returns The removed ariaDescribedBy or `null`
     */
    removeAriaDescribedBy(
      /**
       * The ariaDescribedBy to be removed or its index or ID
       */
      vAriaDescribedBy: int | ID | Control
    ): ID | null;
    /**
     * Removes an ariaLabelledBy from the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns The removed ariaLabelledBy or `null`
     */
    removeAriaLabelledBy(
      /**
       * The ariaLabelledBy to be removed or its index or ID
       */
      vAriaLabelledBy: int | ID | Control
    ): ID | null;
    /**
     * Removes a content from the aggregation {@link #getContent content}.
     *
     *
     * @returns The removed content or `null`
     */
    removeContent(
      /**
       * The content to remove or its index or id
       */
      vContent: int | string | ContainerContent
    ): ContainerContent | null;
    /**
     * Sets a new value for property {@link #getAutoAdjustHeight autoAdjustHeight}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAutoAdjustHeight(
      /**
       * New value for property `autoAdjustHeight`
       */
      bAutoAdjustHeight?: boolean
    ): this;
    /**
     * set FullScreen - default is normal mode, but app can call this method to set the default to full screen
     */
    setFullScreen(
      /**
       * Fullscreen mode on or off
       */
      bFullScreen: boolean
    ): void;
    /**
     * set selected content
     */
    setSelectedContent(
      /**
       * the selected content; involves no re-rendering
       */
      oContent: ContainerContent
    ): void;
    /**
     * Sets a new value for property {@link #getShowFullScreen showFullScreen}.
     *
     * Show fullscreen toggle button in toolbar
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowFullScreen(
      /**
       * New value for property `showFullScreen`
       */
      bShowFullScreen?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowSelection showSelection}.
     *
     * Show selection button in toolbar
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowSelection(
      /**
       * New value for property `showSelection`
       */
      bShowSelection?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowSettings showSettings}.
     *
     * Show settings button in toolbar
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowSettings(
      /**
       * New value for property `showSettings`
       */
      bShowSettings?: boolean
    ): this;
    /**
     * Display title
     */
    setTitle(
      /**
       * the title
       */
      sValue: string
    ): void;
    /**
     * default Content could be defined in application
     */
    switchContent(
      /**
       * the content to be visible; involves re-rendering
       */
      oContent: ContainerContent
    ): void;
    /**
     * update container to allow dynamic change button layout
     */
    updateContainer(): void;
  }
  /**
   * Describes the settings that can be provided to the ContainerBase constructor.
   *
   * @deprecated As of version 1.120.2. This object is moved to sap.ui.vbm namespace, see {@link sap.ui.vbm.ContainerBase}
   */
  export interface $ContainerBaseSettings extends $ControlSettings {
    /**
     * Show fullscreen toggle button in toolbar
     */
    showFullScreen?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Show settings button in toolbar
     */
    showSettings?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Show selection button in toolbar
     */
    showSelection?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Controls whether the control is show fullscreen or embedded
     */
    fullScreen?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Title to show in toolbar
     */
    title?: string | PropertyBindingInfo;

    autoAdjustHeight?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Content Aggregation.
     */
    content?:
      | ContainerContent[]
      | ContainerContent
      | AggregationBindingInfo
      | `{${string}}`;

    /**
     * Association to controls / ids which describe this control (see WAI-ARIA attribute aria-describedby).
     */
    ariaDescribedBy?: Array<Control | string>;

    /**
     * Association to controls / ids which label this control (see WAI-ARIA attribute aria-labelledBy).
     */
    ariaLabelledBy?: Array<Control | string>;

    contentChange?: (oEvent: ContainerBase$ContentChangeEvent) => void;

    settingsPressed?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the ContainerBase#contentChange event.
   */
  export interface ContainerBase$ContentChangeEventParameters {
    selectedItemId?: string;
  }

  /**
   * Event object of the ContainerBase#contentChange event.
   */
  export type ContainerBase$ContentChangeEvent = Event<
    ContainerBase$ContentChangeEventParameters,
    ContainerBase
  >;

  /**
   * Parameters of the ContainerBase#settingsPressed event.
   */
  export interface ContainerBase$SettingsPressedEventParameters {}

  /**
   * Event object of the ContainerBase#settingsPressed event.
   */
  export type ContainerBase$SettingsPressedEvent = Event<
    ContainerBase$SettingsPressedEventParameters,
    ContainerBase
  >;
}

declare module "sap/ui/vk/ContainerContent" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Aggregation element for the Container Base
   *
   * @since 1.38.0
   * @deprecated As of version 1.120.2. This object is moved to sap.ui.vbm namespace, see {@link sap.ui.vbm.ContainerContent}
   */
  export default class ContainerContent extends Control {
    /**
     * Constructor for a new ContainerContent.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $ContainerContentSettings
    );
    /**
     * Constructor for a new ContainerContent.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $ContainerContentSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vk.ContainerContent with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ContainerContent>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.ContainerContent.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Destroys the content in the aggregation {@link #getContent content}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyContent(): this;
    /**
     * Gets content of aggregation {@link #getContent content}.
     */
    getContent(): Control;
    /**
     * Gets current value of property {@link #getIcon icon}.
     *
     * Icon to show up in the toolbar
     *
     *
     * @returns Value of property `icon`
     */
    getIcon(): string;
    /**
     * Gets current value of property {@link #getTitle title}.
     *
     * Title for the icon in the toolbar
     *
     *
     * @returns Value of property `title`
     */
    getTitle(): string;
    /**
     * Sets the aggregated {@link #getContent content}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setContent(
      /**
       * The content to set
       */
      oContent: Control
    ): this;
    /**
     * Sets a new value for property {@link #getIcon icon}.
     *
     * Icon to show up in the toolbar
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIcon(
      /**
       * New value for property `icon`
       */
      sIcon?: string
    ): this;
    /**
     * Sets a new value for property {@link #getTitle title}.
     *
     * Title for the icon in the toolbar
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTitle(
      /**
       * New value for property `title`
       */
      sTitle?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the ContainerContent constructor.
   *
   * @deprecated As of version 1.120.2. This object is moved to sap.ui.vbm namespace, see {@link sap.ui.vbm.ContainerContent}
   */
  export interface $ContainerContentSettings extends $ControlSettings {
    /**
     * Icon to show up in the toolbar
     */
    icon?: string | PropertyBindingInfo;

    /**
     * Title for the icon in the toolbar
     */
    title?: string | PropertyBindingInfo;

    content?: Control;
  }
}

declare module "sap/ui/vk/ContentManager" {
  import {
    default as ManagedObject,
    $ManagedObjectSettings,
  } from "sap/ui/base/ManagedObject";

  import Event from "sap/ui/base/Event";

  import OrthographicCamera from "sap/ui/vk/OrthographicCamera";

  import PerspectiveCamera from "sap/ui/vk/PerspectiveCamera";

  import ManagedObjectMetadata from "sap/ui/base/ManagedObjectMetadata";

  import ContentResource from "sap/ui/vk/ContentResource";

  /**
   * Provides a base loader interface.
   *
   * To load content a concrete loader class is to be used.
   *
   * @since 1.50.0
   * @ui5-protected DO NOT USE IN APPLICATIONS (only for related classes in the framework)
   */
  export default abstract class ContentManager extends ManagedObject {
    /**
     * Constructor for a new ContentManager.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    protected constructor(
      /**
       * Initial settings for the new ContentManager object.
       */
      mSettings?: $ContentManagerSettings
    );
    /**
     * Constructor for a new ContentManager.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    protected constructor(
      /**
       * ID for the new ContentManager object. Generated automatically if no ID is given.
       */
      sId?: string,
      /**
       * Initial settings for the new ContentManager object.
       */
      mSettings?: $ContentManagerSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vk.ContentManager with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.base.ManagedObject.extend}.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ContentManager>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.ContentManager.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ManagedObjectMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:contentChangesFinished contentChangesFinished }
     * event of this `sap.ui.vk.ContentManager`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.ContentManager` itself.
     *
     * This event will be fired when content resources have been loaded successfully or with a failure.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachContentChangesFinished(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ContentManager$ContentChangesFinishedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.ContentManager` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:contentChangesFinished contentChangesFinished }
     * event of this `sap.ui.vk.ContentManager`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.ContentManager` itself.
     *
     * This event will be fired when content resources have been loaded successfully or with a failure.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachContentChangesFinished(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ContentManager$ContentChangesFinishedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.ContentManager` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:contentChangesProgress contentChangesProgress }
     * event of this `sap.ui.vk.ContentManager`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.ContentManager` itself.
     *
     * This event will be fired to report the progress of content changes.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachContentChangesProgress(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ContentManager$ContentChangesProgressEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.ContentManager` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:contentChangesProgress contentChangesProgress }
     * event of this `sap.ui.vk.ContentManager`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.ContentManager` itself.
     *
     * This event will be fired to report the progress of content changes.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachContentChangesProgress(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ContentManager$ContentChangesProgressEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.ContentManager` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:contentChangesStarted contentChangesStarted }
     * event of this `sap.ui.vk.ContentManager`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.ContentManager` itself.
     *
     * This event will be fired when content resources are about to be loaded.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachContentChangesStarted(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.ContentManager` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:contentChangesStarted contentChangesStarted }
     * event of this `sap.ui.vk.ContentManager`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.ContentManager` itself.
     *
     * This event will be fired when content resources are about to be loaded.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachContentChangesStarted(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.ContentManager` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:contentLoadingFinished contentLoadingFinished }
     * event of this `sap.ui.vk.ContentManager`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.ContentManager` itself.
     *
     * This event will be fired when content loading is finished.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachContentLoadingFinished(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ContentManager$ContentLoadingFinishedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.ContentManager` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:contentLoadingFinished contentLoadingFinished }
     * event of this `sap.ui.vk.ContentManager`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.ContentManager` itself.
     *
     * This event will be fired when content loading is finished.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachContentLoadingFinished(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ContentManager$ContentLoadingFinishedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.ContentManager` itself
       */
      oListener?: object
    ): this;
    /**
     * Collects and destroys unused objects and resources.
     *
     * @since 1.50.0
     *
     * @returns Reference to `this` in order to allow method chaining.
     */
    collectGarbage(): this;
    /**
     * Creates a Perspective camera
     *
     * @since 1.52.0
     *
     * @returns Created Camera.
     */
    createOrthographicCamera(): OrthographicCamera;
    /**
     * Creates a Orthographic camera
     *
     * @since 1.52.0
     *
     * @returns Created Camera.
     */
    createPerspectiveCamera(): PerspectiveCamera;
    /**
     * Destroys a camera for the content type
     *
     * @since 1.52.0
     *
     * @returns Reference to `this` in order to allow method chaining.
     */
    destroyCamera(
      /**
       * The camera to destroy.
       */
      camera: any
    ): this;
    /**
     * Destroys the content.
     *
     * @since 1.50.0
     *
     * @returns Reference to `this` in order to allow method chaining.
     */
    destroyContent(
      /**
       * The content to destroy.
       */
      content: any
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:contentChangesFinished contentChangesFinished }
     * event of this `sap.ui.vk.ContentManager`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachContentChangesFinished(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: ContentManager$ContentChangesFinishedEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:contentChangesProgress contentChangesProgress }
     * event of this `sap.ui.vk.ContentManager`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachContentChangesProgress(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: ContentManager$ContentChangesProgressEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:contentChangesStarted contentChangesStarted }
     * event of this `sap.ui.vk.ContentManager`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachContentChangesStarted(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:contentLoadingFinished contentLoadingFinished }
     * event of this `sap.ui.vk.ContentManager`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachContentLoadingFinished(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: ContentManager$ContentLoadingFinishedEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:contentChangesFinished contentChangesFinished} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireContentChangesFinished(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: ContentManager$ContentChangesFinishedEventParameters
    ): this;
    /**
     * Fires event {@link #event:contentChangesProgress contentChangesProgress} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireContentChangesProgress(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: ContentManager$ContentChangesProgressEventParameters
    ): this;
    /**
     * Fires event {@link #event:contentChangesStarted contentChangesStarted} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireContentChangesStarted(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:contentLoadingFinished contentLoadingFinished} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireContentLoadingFinished(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: ContentManager$ContentLoadingFinishedEventParameters
    ): this;
    /**
     * Starts downloading and building or updating the content from the content resources.
     *
     * This method is asynchronous.
     *
     * @since 1.50.0
     *
     * @returns Reference to `this` in order to allow method chaining.
     */
    loadContent(
      /**
       * The current content to update. It can be `null` if this is an initial loading call.
       */
      content: any,
      /**
       * The content resources to load or update.
       */
      contentResources: ContentResource[]
    ): this;
    /**
     * Set the consumption scenario for metering differention. This value is passed in SAP-ConsumptionScenario
     * HTTP headers in requests made to the EPD Visualization backend when viewing.
     *
     * @since 1.114.0
     *
     * @returns `this` to allow method chaining.
     */
    setConsumptionScenario(
      /**
       * The consumption scenario.
       */
      consumptionScenario: string
    ): this;
    /**
     * Sets the maximum number of retry attempts for a download operation if the initial request to retrieve
     * a model from a remote server could not be fulfilled and the error with which the request failed is considered
     * recoverable.
     *
     * See {@link sap.ui.vk.ContentConnector#setRetryCount} for details.
     *
     * @since 1.95.0
     *
     * @returns Reference to `this` in order to allow method chaining.
     */
    setRetryCount(
      /**
       * Maximum number of retry attempts. Value must be non-negative. The default number of retry attempts is
       * 1, unless specified otherwise by calling this method and passing in the desired value. Specifying 0 disables
       * any retry attempts.
       */
      retryCount: int
    ): this;
  }
  /**
   * Describes the settings that can be provided to the ContentManager constructor.
   *
   * @ui5-protected DO NOT USE IN APPLICATIONS (only for related classes in the framework)
   */
  export interface $ContentManagerSettings extends $ManagedObjectSettings {
    /**
     * This event will be fired when content resources are about to be loaded.
     */
    contentChangesStarted?: (oEvent: Event) => void;

    /**
     * This event will be fired when content resources have been loaded successfully or with a failure.
     */
    contentChangesFinished?: (
      oEvent: ContentManager$ContentChangesFinishedEvent
    ) => void;

    /**
     * This event will be fired to report the progress of content changes.
     */
    contentChangesProgress?: (
      oEvent: ContentManager$ContentChangesProgressEvent
    ) => void;

    /**
     * This event will be fired when content loading is finished.
     */
    contentLoadingFinished?: (
      oEvent: ContentManager$ContentLoadingFinishedEvent
    ) => void;
  }

  /**
   * Parameters of the ContentManager#contentChangesFinished event.
   *
   * @ui5-protected DO NOT USE IN APPLICATIONS (only for related classes in the framework)
   */
  export interface ContentManager$ContentChangesFinishedEventParameters {
    /**
     * The content created or updated.
     */
    content?: any;

    /**
     * The failure reason if any.
     *  An single element or an array of elements with the following structure:
     * 	error - An object with details of the error. contentResource - A {@link sap.ui.vk.ContentResource sap.ui.vk.ContentResource }
     * object when it is possible to match `error` to a {@link sap.ui.vk.ContentResource sap.ui.vk.ContentResource }
     * object.
     */
    failureReason?: object;
  }

  /**
   * Event object of the ContentManager#contentChangesFinished event.
   *
   * @ui5-protected DO NOT USE IN APPLICATIONS (only for related classes in the framework)
   */
  export type ContentManager$ContentChangesFinishedEvent = Event<
    ContentManager$ContentChangesFinishedEventParameters,
    ContentManager
  >;

  /**
   * Parameters of the ContentManager#contentChangesProgress event.
   *
   * @ui5-protected DO NOT USE IN APPLICATIONS (only for related classes in the framework)
   */
  export interface ContentManager$ContentChangesProgressEventParameters {
    /**
     * The name of the loading phase. It can be e.g. 'downloading', 'building the scene' etc. It might be null
     * if reporting this parameter does not make sense.
     */
    phase?: string;

    /**
     * The overall percentage of the loading process.
     */
    percentage?: float;

    /**
     * The content resource currently being loaded. It might be null if reporting this parameter does not make
     * sense.
     */
    source?: any;
  }

  /**
   * Event object of the ContentManager#contentChangesProgress event.
   *
   * @ui5-protected DO NOT USE IN APPLICATIONS (only for related classes in the framework)
   */
  export type ContentManager$ContentChangesProgressEvent = Event<
    ContentManager$ContentChangesProgressEventParameters,
    ContentManager
  >;

  /**
   * Parameters of the ContentManager#contentChangesStarted event.
   *
   * @ui5-protected DO NOT USE IN APPLICATIONS (only for related classes in the framework)
   */
  export interface ContentManager$ContentChangesStartedEventParameters {}

  /**
   * Event object of the ContentManager#contentChangesStarted event.
   *
   * @ui5-protected DO NOT USE IN APPLICATIONS (only for related classes in the framework)
   */
  export type ContentManager$ContentChangesStartedEvent = Event<
    ContentManager$ContentChangesStartedEventParameters,
    ContentManager
  >;

  /**
   * Parameters of the ContentManager#contentLoadingFinished event.
   *
   * @ui5-protected DO NOT USE IN APPLICATIONS (only for related classes in the framework)
   */
  export interface ContentManager$ContentLoadingFinishedEventParameters {
    source?: any;

    node?: any;
  }

  /**
   * Event object of the ContentManager#contentLoadingFinished event.
   *
   * @ui5-protected DO NOT USE IN APPLICATIONS (only for related classes in the framework)
   */
  export type ContentManager$ContentLoadingFinishedEvent = Event<
    ContentManager$ContentLoadingFinishedEventParameters,
    ContentManager
  >;
}

declare module "sap/ui/vk/ContentResource" {
  import {
    default as ManagedObject,
    $ManagedObjectSettings,
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  import IncludeUsageIdType from "sap/ui/vk/IncludeUsageIdType";

  import ManagedObjectMetadata from "sap/ui/base/ManagedObjectMetadata";

  import NodeProxy from "sap/ui/vk/NodeProxy";

  /**
   * Specifies a resource to load.
   */
  export default class ContentResource extends ManagedObject {
    /**
     * Constructor for a new ContentResource.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * An optional map/JSON object with initial property values, aggregated objects etc. for the new content
       * resource.
       */
      mSettings?: $ContentResourceSettings,
      /**
       * scope An object for resolving string-based type and formatter references in bindings.
       */
      oScope?: object
    );
    /**
     * Constructor for a new ContentResource.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID of the new content resource. `sId`is generated automatically if no non-empty ID is given. Note: this
       * can be omitted, regardless of whether `mSettings` will be provided or not.
       */
      sId?: string,
      /**
       * An optional map/JSON object with initial property values, aggregated objects etc. for the new content
       * resource.
       */
      mSettings?: $ContentResourceSettings,
      /**
       * scope An object for resolving string-based type and formatter references in bindings.
       */
      oScope?: object
    );

    /**
     * Collects content resource categories. The result is tested if the content resource hierarchy has the
     * same category - 2D or 3D.
     *
     * @deprecated As of version 1.50.0. Content resource categories shall not be used anymore. See {@link sap.ui.vk.ContentResource#sourceType }
     * property for selection of content type.
     *
     * @returns The array of distinct content resource categories.
     */
    static collectCategories(
      /**
       * The array of content resources.
       */
      resources: ContentResource[]
    ): /* was: sap.ui.vk.ContentResourceSourceCategory */ any[];
    /**
     * Creates a new subclass of class sap.ui.vk.ContentResource with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.base.ManagedObject.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ContentResource>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.ContentResource.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ManagedObjectMetadata;
    /**
     * Adds some contentResource to the aggregation {@link #getContentResources contentResources}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addContentResource(
      /**
       * The contentResource to add; if empty, nothing is inserted
       */
      oContentResource: ContentResource
    ): this;
    /**
     * Destroys all the contentResources in the aggregation {@link #getContentResources contentResources}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyContentResources(): this;
    /**
     * Gets current value of property {@link #getActivateView activateView}.
     *
     * Optional parameter with view id which shall be activated when scene is loaded.
     *
     *
     * @returns Value of property `activateView`
     */
    getActivateView(): string;
    /**
     * Gets content of aggregation {@link #getContentResources contentResources}.
     *
     * Child content resources.
     */
    getContentResources(): ContentResource[];
    /**
     * Gets current value of property {@link #getDependencyLoader dependencyLoader}.
     *
     * An object used to load content resource's dependencies.
     *
     * A content resource may have dependencies, e.g. if the loaded content resource is a shattered VDS file
     * it reference other VDS files.
     *
     * `dependencyLoader` should be an object with method `function load(uri: string, context: any): Promise<{buffer:
     * ArrayBuffer, context: any}>`, where `uri` is a reference to a dependency and `context` is opaque data.
     *
     * `uri` is application specific and can be a full URL or a relative file name or anything else, e.g. some
     * identifier known to `dependencyLoader`.
     *
     *
     * @returns Value of property `dependencyLoader`
     */
    getDependencyLoader(): any;
    /**
     * Gets current value of property {@link #getEnableLogger enableLogger}.
     *
     * Optional boolean parameter to enable detailed logging. Can be used to track performance issues during
     * data streaming from SAP 3D Visualization Service.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `enableLogger`
     */
    getEnableLogger(): boolean;
    /**
     * Gets current value of property {@link #getIncludeAnimation includeAnimation}.
     *
     * Send structural data for animation objects, if false they will be omitted, reducing data size. Default:
     * true.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `includeAnimation`
     */
    getIncludeAnimation(): boolean;
    /**
     * Gets current value of property {@link #getIncludeBackground includeBackground}.
     *
     * If set to true, will return nodes with the type background
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `includeBackground`
     */
    getIncludeBackground(): boolean;
    /**
     * Gets current value of property {@link #getIncludeHidden includeHidden}.
     *
     * Send structural data for hidden objects, if false they will be omitted, reducing data size. Default:
     * true.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `includeHidden`
     */
    getIncludeHidden(): boolean;
    /**
     * Gets current value of property {@link #getIncludeMetadata includeMetadata}.
     *
     * If set to true, will load metadata
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `includeMetadata`
     */
    getIncludeMetadata(): boolean;
    /**
     * Gets current value of property {@link #getIncludeParametric includeParametric}.
     *
     * If set to true, will load parametric nodes
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `includeParametric`
     */
    getIncludeParametric(): boolean;
    /**
     * Gets current value of property {@link #getIncludeUsageId includeUsageId}.
     *
     * Optional parameter to load UsageIds. Valid values:
     * 	`true` - Load all UsageIds. This is potentially very expensive, as there could be many UsageIds defined
     * for the tenant which are not relevant to the current application. `false` - Do not load any UsageIds.
     * `string` - A single non-empty string which defines the name of the requested UsageId. `string[]`
     * - An array of non-empty strings which define the names of requested UsageIds.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `includeUsageId`
     */
    getIncludeUsageId(): IncludeUsageIdType;
    /**
     * Gets current value of property {@link #getLocalMatrix localMatrix}.
     *
     * The local transformation matrix of the node created for this content resource.
     *
     *
     * @returns Value of property `localMatrix`
     */
    getLocalMatrix(): float[];
    /**
     * Gets current value of property {@link #getMetadataFilter metadataFilter}.
     *
     * Optional metadata filter that can trim the tree before sending to the client only keeping nodes that
     * passed the filter and their parents. Default: null. Format: Comma-separated list of meta.category1.tag1.value1,
     * meta.category2.tag2.value2. "meta." is the prefix and all metadata filters must start with it. Multiple
     * filters are supported, they are combined using `OR` operator. Includes parent nodes of matching nodes
     * (e.g. breadcrumb) even if they don't pass the filter.
     *
     *
     * @returns Value of property `metadataFilter`
     */
    getMetadataFilter(): string;
    /**
     * Gets current value of property {@link #getName name}.
     *
     * The name of the node created for this content resource.
     *
     *
     * @returns Value of property `name`
     */
    getName(): string;
    /**
     * Gets the {@link sap.ui.vk.NodeProxy NodeProxy} object created for this content resource.
     *
     * If this is the only top level content resource, the {@link sap.ui.vk.NodeProxy NodeProxy} object is not
     * set since the grouping node is not created, which means that there may be multiple top level nodes.
     *
     *
     * @returns The {@link sap.ui.vk.NodeProxy NodeProxy} object created for this content resource if any, otherwise
     * `null`.
     */
    getNodeProxy(): NodeProxy;
    /**
     * Gets current value of property {@link #getPassword password}.
     *
     * The password to use when opening the resource.
     *
     *
     * @returns Value of property `password`
     */
    getPassword(): string;
    /**
     * Gets current value of property {@link #getPushPMI pushPMI}.
     *
     * If set to true, elements for PMI rendering content will be returned. Default: false.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `pushPMI`
     */
    getPushPMI(): boolean;
    /**
     * Gets current value of property {@link #getPushViewGroups pushViewGroups}.
     *
     * If set to true, information of view groups will be returned. Default: true.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `pushViewGroups`
     */
    getPushViewGroups(): boolean;
    /**
     * Gets current value of property {@link #getSource source}.
     *
     * The source URL or the {@link https://developer.mozilla.org/en-US/docs/Web/API/File File} object of the
     * content resource/file to load from. The source may be omitted if a grouping node is needed.
     *
     *
     * @returns Value of property `source`
     */
    getSource(): any;
    /**
     * Gets current value of property {@link #getSourceId sourceId}.
     *
     * The unique ID of the content resource.
     *
     *
     * @returns Value of property `sourceId`
     */
    getSourceId(): string;
    /**
     * Gets content resource source properties.
     *
     * The content resource source properties depend on the content resource source type. They are different
     * for VDS and PNG for example. The list of possible source properties:
     * 	 - version - object
     * 	major - number
     * 	 - minor - number
     * 	 - compressed - boolean
     * 	 - encrypted - boolean  The source properties are optional and the list might be extended in future
     *     versions.
     *
     *
     * @returns A JSON like object containing the content resource source properties.
     */
    getSourceProperties(): object;
    /**
     * Gets current value of property {@link #getSourceType sourceType}.
     *
     * The source type of the content resource. Valid types:
     *
     *
     * 	 - vds
     * 	 - vds4
     * 	 - vds4-2d
     * 	 - svg
     * 	 - png
     * 	 - jpg
     * 	 - jpeg
     * 	 - gif
     * 	 - bmp
     * 	 - tif
     * 	 - tiff
     * 	 - stream
     * 	 - stream2d
     * 	 - ecad
     * 	 - pdf
     * 	 - auto
     *
     * The source type may be omitted if this is a grouping content node.  If the `source` property points
     * to an IPD Visualization service the `sourceType` property can be assigned value `auto`. The actual `sourceType`
     * property will be detected by making a request to the backend.  NOTE: The tif and tiff image formats
     * are not supported on all browsers. Source type "vds" initializes deprecated DVL namespace and uses legacy
     * library to load and display VDS file content. If source type of "vds4" is used then new namespace based
     * on Threejs rendering model will be used to load and display VDS file content. Since DVL namespace is
     * deprecated in one of future releases it will be removed and source type "vds" will also use Threejs model.
     *
     *
     * @returns Value of property `sourceType`
     */
    getSourceType(): string;
    /**
     * Gets current value of property {@link #getUseSecureConnection useSecureConnection}.
     *
     * If set to false, unsecure connections will be used. Default: true.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `useSecureConnection`
     */
    getUseSecureConnection(): boolean;
    /**
     * Gets current value of property {@link #getVeid veid}.
     *
     * Id of scene to retrieve tree for. Mandatory for the stream source type.
     *
     *
     * @returns Value of property `veid`
     */
    getVeid(): string;
    /**
     * Checks for the provided `sap.ui.vk.ContentResource` in the aggregation {@link #getContentResources contentResources}.
     * and returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfContentResource(
      /**
       * The contentResource whose index is looked for
       */
      oContentResource: ContentResource
    ): int;
    /**
     * Inserts a contentResource into the aggregation {@link #getContentResources contentResources}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertContentResource(
      /**
       * The contentResource to insert; if empty, nothing is inserted
       */
      oContentResource: ContentResource,
      /**
       * The `0`-based index the contentResource should be inserted at; for a negative value of `iIndex`, the
       * contentResource is inserted at position 0; for a value greater than the current size of the aggregation,
       * the contentResource is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getContentResources contentResources}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllContentResources(): ContentResource[];
    /**
     * Removes a contentResource from the aggregation {@link #getContentResources contentResources}.
     *
     *
     * @returns The removed contentResource or `null`
     */
    removeContentResource(
      /**
       * The contentResource to remove or its index or id
       */
      vContentResource: int | string | ContentResource
    ): ContentResource | null;
    /**
     * Sets a new value for property {@link #getActivateView activateView}.
     *
     * Optional parameter with view id which shall be activated when scene is loaded.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setActivateView(
      /**
       * New value for property `activateView`
       */
      sActivateView: string
    ): this;
    /**
     * Sets a new value for property {@link #getDependencyLoader dependencyLoader}.
     *
     * An object used to load content resource's dependencies.
     *
     * A content resource may have dependencies, e.g. if the loaded content resource is a shattered VDS file
     * it reference other VDS files.
     *
     * `dependencyLoader` should be an object with method `function load(uri: string, context: any): Promise<{buffer:
     * ArrayBuffer, context: any}>`, where `uri` is a reference to a dependency and `context` is opaque data.
     *
     * `uri` is application specific and can be a full URL or a relative file name or anything else, e.g. some
     * identifier known to `dependencyLoader`.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDependencyLoader(
      /**
       * New value for property `dependencyLoader`
       */
      oDependencyLoader: any
    ): this;
    /**
     * Sets a new value for property {@link #getEnableLogger enableLogger}.
     *
     * Optional boolean parameter to enable detailed logging. Can be used to track performance issues during
     * data streaming from SAP 3D Visualization Service.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnableLogger(
      /**
       * New value for property `enableLogger`
       */
      bEnableLogger?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getIncludeAnimation includeAnimation}.
     *
     * Send structural data for animation objects, if false they will be omitted, reducing data size. Default:
     * true.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIncludeAnimation(
      /**
       * New value for property `includeAnimation`
       */
      bIncludeAnimation?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getIncludeBackground includeBackground}.
     *
     * If set to true, will return nodes with the type background
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIncludeBackground(
      /**
       * New value for property `includeBackground`
       */
      bIncludeBackground?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getIncludeHidden includeHidden}.
     *
     * Send structural data for hidden objects, if false they will be omitted, reducing data size. Default:
     * true.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIncludeHidden(
      /**
       * New value for property `includeHidden`
       */
      bIncludeHidden?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getIncludeMetadata includeMetadata}.
     *
     * If set to true, will load metadata
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIncludeMetadata(
      /**
       * New value for property `includeMetadata`
       */
      bIncludeMetadata?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getIncludeParametric includeParametric}.
     *
     * If set to true, will load parametric nodes
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIncludeParametric(
      /**
       * New value for property `includeParametric`
       */
      bIncludeParametric?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getIncludeUsageId includeUsageId}.
     *
     * Optional parameter to load UsageIds. Valid values:
     * 	`true` - Load all UsageIds. This is potentially very expensive, as there could be many UsageIds defined
     * for the tenant which are not relevant to the current application. `false` - Do not load any UsageIds.
     * `string` - A single non-empty string which defines the name of the requested UsageId. `string[]`
     * - An array of non-empty strings which define the names of requested UsageIds.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIncludeUsageId(
      /**
       * New value for property `includeUsageId`
       */
      sIncludeUsageId?: IncludeUsageIdType
    ): this;
    /**
     * Sets a new value for property {@link #getLocalMatrix localMatrix}.
     *
     * The local transformation matrix of the node created for this content resource.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLocalMatrix(
      /**
       * New value for property `localMatrix`
       */
      sLocalMatrix: float[]
    ): this;
    /**
     * Sets a new value for property {@link #getMetadataFilter metadataFilter}.
     *
     * Optional metadata filter that can trim the tree before sending to the client only keeping nodes that
     * passed the filter and their parents. Default: null. Format: Comma-separated list of meta.category1.tag1.value1,
     * meta.category2.tag2.value2. "meta." is the prefix and all metadata filters must start with it. Multiple
     * filters are supported, they are combined using `OR` operator. Includes parent nodes of matching nodes
     * (e.g. breadcrumb) even if they don't pass the filter.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMetadataFilter(
      /**
       * New value for property `metadataFilter`
       */
      sMetadataFilter: string
    ): this;
    /**
     * Sets a new value for property {@link #getName name}.
     *
     * The name of the node created for this content resource.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setName(
      /**
       * New value for property `name`
       */
      sName: string
    ): this;
    /**
     * Sets a new value for property {@link #getPassword password}.
     *
     * The password to use when opening the resource.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPassword(
      /**
       * New value for property `password`
       */
      sPassword: string
    ): this;
    /**
     * Sets a new value for property {@link #getPushPMI pushPMI}.
     *
     * If set to true, elements for PMI rendering content will be returned. Default: false.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPushPMI(
      /**
       * New value for property `pushPMI`
       */
      bPushPMI?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getPushViewGroups pushViewGroups}.
     *
     * If set to true, information of view groups will be returned. Default: true.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPushViewGroups(
      /**
       * New value for property `pushViewGroups`
       */
      bPushViewGroups?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getSource source}.
     *
     * The source URL or the {@link https://developer.mozilla.org/en-US/docs/Web/API/File File} object of the
     * content resource/file to load from. The source may be omitted if a grouping node is needed.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSource(
      /**
       * New value for property `source`
       */
      oSource: any
    ): this;
    /**
     * Sets a new value for property {@link #getSourceId sourceId}.
     *
     * The unique ID of the content resource.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSourceId(
      /**
       * New value for property `sourceId`
       */
      sSourceId: string
    ): this;
    /**
     * Sets a new value for property {@link #getSourceType sourceType}.
     *
     * The source type of the content resource. Valid types:
     *
     *
     * 	 - vds
     * 	 - vds4
     * 	 - vds4-2d
     * 	 - svg
     * 	 - png
     * 	 - jpg
     * 	 - jpeg
     * 	 - gif
     * 	 - bmp
     * 	 - tif
     * 	 - tiff
     * 	 - stream
     * 	 - stream2d
     * 	 - ecad
     * 	 - pdf
     * 	 - auto
     *
     * The source type may be omitted if this is a grouping content node.  If the `source` property points
     * to an IPD Visualization service the `sourceType` property can be assigned value `auto`. The actual `sourceType`
     * property will be detected by making a request to the backend.  NOTE: The tif and tiff image formats
     * are not supported on all browsers. Source type "vds" initializes deprecated DVL namespace and uses legacy
     * library to load and display VDS file content. If source type of "vds4" is used then new namespace based
     * on Threejs rendering model will be used to load and display VDS file content. Since DVL namespace is
     * deprecated in one of future releases it will be removed and source type "vds" will also use Threejs model.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSourceType(
      /**
       * New value for property `sourceType`
       */
      sSourceType: string
    ): this;
    /**
     * Sets a new value for property {@link #getUseSecureConnection useSecureConnection}.
     *
     * If set to false, unsecure connections will be used. Default: true.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setUseSecureConnection(
      /**
       * New value for property `useSecureConnection`
       */
      bUseSecureConnection?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getVeid veid}.
     *
     * Id of scene to retrieve tree for. Mandatory for the stream source type.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setVeid(
      /**
       * New value for property `veid`
       */
      sVeid: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the ContentResource constructor.
   */
  export interface $ContentResourceSettings extends $ManagedObjectSettings {
    /**
     * The source URL or the {@link https://developer.mozilla.org/en-US/docs/Web/API/File File} object of the
     * content resource/file to load from. The source may be omitted if a grouping node is needed.
     */
    source?: any | PropertyBindingInfo | `{${string}}`;

    /**
     * The source type of the content resource. Valid types:
     *
     *
     * 	 - vds
     * 	 - vds4
     * 	 - vds4-2d
     * 	 - svg
     * 	 - png
     * 	 - jpg
     * 	 - jpeg
     * 	 - gif
     * 	 - bmp
     * 	 - tif
     * 	 - tiff
     * 	 - stream
     * 	 - stream2d
     * 	 - ecad
     * 	 - pdf
     * 	 - auto
     *
     * The source type may be omitted if this is a grouping content node.  If the `source` property points
     * to an IPD Visualization service the `sourceType` property can be assigned value `auto`. The actual `sourceType`
     * property will be detected by making a request to the backend.  NOTE: The tif and tiff image formats
     * are not supported on all browsers. Source type "vds" initializes deprecated DVL namespace and uses legacy
     * library to load and display VDS file content. If source type of "vds4" is used then new namespace based
     * on Threejs rendering model will be used to load and display VDS file content. Since DVL namespace is
     * deprecated in one of future releases it will be removed and source type "vds" will also use Threejs model.
     */
    sourceType?: string | PropertyBindingInfo;

    /**
     * The unique ID of the content resource.
     */
    sourceId?: string | PropertyBindingInfo;

    /**
     * The local transformation matrix of the node created for this content resource.
     */
    localMatrix?: float[] | PropertyBindingInfo | `{${string}}`;

    /**
     * The name of the node created for this content resource.
     */
    name?: string | PropertyBindingInfo;

    /**
     * The password to use when opening the resource.
     */
    password?: string | PropertyBindingInfo;

    /**
     * If set to false, unsecure connections will be used. Default: true.
     */
    useSecureConnection?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Id of scene to retrieve tree for. Mandatory for the stream source type.
     */
    veid?: string | PropertyBindingInfo;

    /**
     * Send structural data for hidden objects, if false they will be omitted, reducing data size. Default:
     * true.
     */
    includeHidden?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Send structural data for animation objects, if false they will be omitted, reducing data size. Default:
     * true.
     */
    includeAnimation?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * If set to true, elements for PMI rendering content will be returned. Default: false.
     */
    pushPMI?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Optional metadata filter that can trim the tree before sending to the client only keeping nodes that
     * passed the filter and their parents. Default: null. Format: Comma-separated list of meta.category1.tag1.value1,
     * meta.category2.tag2.value2. "meta." is the prefix and all metadata filters must start with it. Multiple
     * filters are supported, they are combined using `OR` operator. Includes parent nodes of matching nodes
     * (e.g. breadcrumb) even if they don't pass the filter.
     */
    metadataFilter?: string | PropertyBindingInfo;

    /**
     * Optional parameter with view id which shall be activated when scene is loaded.
     */
    activateView?: string | PropertyBindingInfo;

    /**
     * Optional boolean parameter to enable detailed logging. Can be used to track performance issues during
     * data streaming from SAP 3D Visualization Service.
     */
    enableLogger?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * If set to true, information of view groups will be returned. Default: true.
     */
    pushViewGroups?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * If set to true, will return nodes with the type background
     */
    includeBackground?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * If set to true, will load parametric nodes
     */
    includeParametric?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * If set to true, will load metadata
     */
    includeMetadata?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Optional parameter to load UsageIds. Valid values:
     * 	`true` - Load all UsageIds. This is potentially very expensive, as there could be many UsageIds defined
     * for the tenant which are not relevant to the current application. `false` - Do not load any UsageIds.
     * `string` - A single non-empty string which defines the name of the requested UsageId. `string[]`
     * - An array of non-empty strings which define the names of requested UsageIds.
     */
    includeUsageId?: IncludeUsageIdType | PropertyBindingInfo | `{${string}}`;

    /**
     * An object used to load content resource's dependencies.
     *
     * A content resource may have dependencies, e.g. if the loaded content resource is a shattered VDS file
     * it reference other VDS files.
     *
     * `dependencyLoader` should be an object with method `function load(uri: string, context: any): Promise<{buffer:
     * ArrayBuffer, context: any}>`, where `uri` is a reference to a dependency and `context` is opaque data.
     *
     * `uri` is application specific and can be a full URL or a relative file name or anything else, e.g. some
     * identifier known to `dependencyLoader`.
     */
    dependencyLoader?: any | PropertyBindingInfo | `{${string}}`;

    /**
     * Child content resources.
     */
    contentResources?:
      | ContentResource[]
      | ContentResource
      | AggregationBindingInfo
      | `{${string}}`;
  }
}

declare module "sap/ui/vk/DrawerToolbar" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import NavigationMode from "sap/ui/vk/NavigationMode";

  import { ID } from "sap/ui/core/library";

  import ViewportBase from "sap/ui/vk/ViewportBase";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  import Event from "sap/ui/base/Event";

  /**
   * Overflow toolbar that can be collapsed.
   */
  export default class DrawerToolbar extends Control {
    /**
     * Constructor for a new DrawerToolbar control.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $DrawerToolbarSettings
    );
    /**
     * Constructor for a new DrawerToolbar control.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $DrawerToolbarSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vk.DrawerToolbar with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, DrawerToolbar>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.DrawerToolbar.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some content to the aggregation {@link #getContent content}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addContent(
      /**
       * The content to add; if empty, nothing is inserted
       */
      oContent: Control
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:expanded expanded} event of this `sap.ui.vk.DrawerToolbar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.DrawerToolbar` itself.
     *
     * Indicates whether the DrawerToolbar is expanded or collapsed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachExpanded(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: DrawerToolbar$ExpandedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.DrawerToolbar` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:expanded expanded} event of this `sap.ui.vk.DrawerToolbar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.DrawerToolbar` itself.
     *
     * Indicates whether the DrawerToolbar is expanded or collapsed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachExpanded(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: DrawerToolbar$ExpandedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.DrawerToolbar` itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys all the content in the aggregation {@link #getContent content}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyContent(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:expanded expanded} event of this `sap.ui.vk.DrawerToolbar`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachExpanded(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: DrawerToolbar$ExpandedEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:expanded expanded} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireExpanded(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: DrawerToolbar$ExpandedEventParameters
    ): this;
    /**
     * Gets content of aggregation {@link #getContent content}.
     *
     * Determines the content of the DrawerToolbar. See {@link sap.m.OverflowToolbar} for list of allowed controls.
     * The content visible when the DrawerToolbar is expanded.
     */
    getContent(): Control[];
    /**
     * Gets current value of property {@link #getExpanded expanded}.
     *
     * Indicates whether the DrawerToolbar is expanded or not. If expanded is set to true, then both the toolbar
     * and 'Close' icon are rendered. If expanded is set to false, then only the 'Open' icon is rendered.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `expanded`
     */
    getExpanded(): boolean;
    /**
     * Gets current value of property {@link #getNavigationMode navigationMode}.
     *
     * Default value is `Turntable`.
     *
     *
     * @returns Value of property `navigationMode`
     */
    getNavigationMode(): NavigationMode;
    /**
     * ID of the element which is the current target of the association {@link #getViewport viewport}, or `null`.
     */
    getViewport(): ID | null;
    /**
     * Checks for the provided `sap.ui.core.Control` in the aggregation {@link #getContent content}. and returns
     * its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfContent(
      /**
       * The content whose index is looked for
       */
      oContent: Control
    ): int;
    /**
     * Inserts a content into the aggregation {@link #getContent content}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertContent(
      /**
       * The content to insert; if empty, nothing is inserted
       */
      oContent: Control,
      /**
       * The `0`-based index the content should be inserted at; for a negative value of `iIndex`, the content
       * is inserted at position 0; for a value greater than the current size of the aggregation, the content
       * is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getContent content}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllContent(): Control[];
    /**
     * Removes a content from the aggregation {@link #getContent content}.
     *
     *
     * @returns The removed content or `null`
     */
    removeContent(
      /**
       * The content to remove or its index or id
       */
      vContent: int | string | Control
    ): Control | null;
    /**
     * Sets the expanded property of the control.
     *
     *
     * @returns Pointer to the control instance to allow method chaining.
     */
    setExpanded(
      /**
       * Defines whether control is expanded or not.
       */
      bExpanded: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getNavigationMode navigationMode}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Turntable`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setNavigationMode(
      /**
       * New value for property `navigationMode`
       */
      sNavigationMode?: NavigationMode | keyof typeof NavigationMode
    ): this;
    /**
     * Sets the associated {@link #getViewport viewport}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setViewport(
      /**
       * ID of an element which becomes the new target of this viewport association; alternatively, an element
       * instance may be given
       */
      oViewport: ID | ViewportBase
    ): this;
  }
  /**
   * Describes the settings that can be provided to the DrawerToolbar constructor.
   */
  export interface $DrawerToolbarSettings extends $ControlSettings {
    /**
     * Indicates whether the DrawerToolbar is expanded or not. If expanded is set to true, then both the toolbar
     * and 'Close' icon are rendered. If expanded is set to false, then only the 'Open' icon is rendered.
     */
    expanded?: boolean | PropertyBindingInfo | `{${string}}`;

    navigationMode?:
      | (NavigationMode | keyof typeof NavigationMode)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Determines the content of the DrawerToolbar. See {@link sap.m.OverflowToolbar} for list of allowed controls.
     * The content visible when the DrawerToolbar is expanded.
     */
    content?: Control[] | Control | AggregationBindingInfo | `{${string}}`;

    viewport?: ViewportBase | string;
  }

  /**
   * Parameters of the DrawerToolbar#expanded event.
   */
  export interface DrawerToolbar$ExpandedEventParameters {
    /**
     * If the DrawerToolbar is expanded, this is true. If the DrawerToolbar is collapsed, this is false.
     */
    expand?: boolean;
  }

  /**
   * Event object of the DrawerToolbar#expanded event.
   */
  export type DrawerToolbar$ExpandedEvent = Event<
    DrawerToolbar$ExpandedEventParameters,
    DrawerToolbar
  >;
}

declare module "sap/ui/vk/DrawerToolbarButton" {
  /**
   * Button identifiers for {@link sap.ui.vk.DrawerToolbar}.
   */
  enum DrawerToolbarButton {
    CrossSection = "VIT-Cross-Section",

    EcadSeparator = "VIT-ECAD-Separator",

    FitToPage = "VIT-Fit-To-Page",

    FitToView = "VIT-Fit-To-View",

    FitToWidth = "VIT-Fit-To-Width",

    Flip = "VIT-Flip",

    FullScreen = "VIT-Fullscreen",

    Hide = "VIT-Hide",

    Measurements = "VIT-Measurements",

    MeasurementsSeparator = "VIT-Measurements-Separator",

    Orbit = "VIT-Orbit",

    PageNavigation = "VIT-Page-Navigation",

    Pan = "VIT-Pan",

    PMI = "VIT-PMI",

    PMISeparator = "VIT-PMI-Separator",

    PredefinedViews = "VIT-Predefined-Views",

    RectangularSelection = "VIT-Rectangular-Selection",

    RotateCCW = "VIT-Rotate-CCW",

    RotateCW = "VIT-Rotate-CW",

    Show = "VIT-Show",

    Turntable = "VIT-Turntable",

    Zoom = "VIT-Zoom",

    ZoomIn = "VIT-Zoom-In",

    ZoomOut = "VIT-Zoom-Out",
  }
  export default DrawerToolbarButton;
}

declare module "sap/ui/vk/dvl/BaseNodeProxy" {
  import BaseNodeProxy1 from "sap/ui/vk/BaseNodeProxy";

  import { Poolable } from "sap/ui/base/ObjectPool";

  import Metadata from "sap/ui/base/Metadata";

  import NodeHierarchy from "sap/ui/vk/dvl/NodeHierarchy";

  /**
   * Provides a simple, lightweight proxy object to a node in a node hierarchy.
   *
   * The objects of this class should not be created directly, and should only be created through the use
   * of the following methods:
   * 	 - {@link sap.ui.vk.NodeHierarchy#enumerateChildren sap.ui.vk.NodeHierarchy.enumerateChildren}
   * 	 - {@link sap.ui.vk.NodeHierarchy#enumerateAncestors sap.ui.vk.NodeHierarchy.enumerateAncestors}
   * 	 - {@link sap.ui.vk.ViewStateManager#enumerateSelection sap.ui.vk.ViewStateManager.enumerateSelection }
   *
   *
   * @deprecated As of version 1.72.0. DVL namespace will be removed in future. Use {@link sap.ui.vk.BaseNodeProxy }
   * instead.
   */
  export default class BaseNodeProxy
    extends BaseNodeProxy1
    implements Poolable
  {
    __implements__sap_ui_base_Poolable: boolean;
    /**
     * Constructor for a new BaseNodeProxy. The objects of this class should not be created directly, and should
     * only be created through the use of the following methods:
     * 	 - {@link sap.ui.vk.NodeHierarchy#enumerateChildren sap.ui.vk.NodeHierarchy.enumerateChildren}
     * 	 - {@link sap.ui.vk.NodeHierarchy#enumerateAncestors sap.ui.vk.NodeHierarchy.enumerateAncestors}
     * 	 - {@link sap.ui.vk.ViewStateManager#enumerateSelection sap.ui.vk.ViewStateManager.enumerateSelection }
     *
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     *
     * This class does not have its own settings, but all settings applicable to the base type {@link sap.ui.vk.BaseNodeProxy#constructor sap.ui.vk.BaseNodeProxy }
     * can be used.
     */
    constructor();

    /**
     * Creates a new subclass of class sap.ui.vk.dvl.BaseNodeProxy with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.vk.BaseNodeProxy.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, BaseNodeProxy>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.dvl.BaseNodeProxy.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): Metadata;
    /**
     * Indicates whether the node has child nodes.
     *
     *
     * @returns A value of `true` indicates that the node has child nodes, and a value of `false` indicates
     * otherwise.
     */
    getHasChildren(): boolean;
    /**
     * Gets the name of the node.
     *
     *
     * @returns The node's name.
     */
    getName(): string;
    /**
     * Gets the ID of the node.
     *
     *
     * @returns The node's ID.
     */
    getNodeId(): string;
    /**
     * Gets the metadata of the node.
     *
     *
     * @returns A JSON object containing the node's metadata.
     */
    getNodeMetadata(): object;
    /**
     * Gets the reference object of the node.
     *
     *
     * @returns The node's reference object.
     */
    getNodeRef(): string;
    /**
     * Gets the scene reference that this BaseNodeProxy object wraps.
     *
     *
     * @returns A scene reference that this BaseNodeProxy object wraps.
     */
    getSceneRef(): any;
    /**
     * Initialize this BaseNodeProxy with its data.
     *
     * The `init` method is called by an object pool when the object is (re-)activated for a new caller.
     * See:
     * 	sap.ui.base.Poolable.prototype#init
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    init(
      /**
       * The NodeHierarchy object this BaseNodeProxy object belongs to.
       */
      nodeHierarchy: NodeHierarchy,
      /**
       * The ID of the node for which to get BaseNodeProxy.
       */
      nodeRef: string
    ): void;
    /**
     * Reset BaseNodeProxy data, needed for pooling.
     * See:
     * 	sap.ui.base.Poolable.prototype#reset
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    reset(): void;
  }
}

declare module "sap/ui/vk/dvl/ContentManager" {
  import {
    default as ContentManager1,
    $ContentManagerSettings as $ContentManagerSettings1,
  } from "sap/ui/vk/ContentManager";

  import ManagedObjectMetadata from "sap/ui/base/ManagedObjectMetadata";

  import ContentResource from "sap/ui/vk/ContentResource";

  /**
   * Provides a loader that uses the DVL library to load VDS and VDSL files.
   *
   * @since 1.50.0
   * @deprecated As of version 1.72.0. DVL namespace will be removed in future. Use {@link sap.ui.vk.ContentManager }
   * instead.
   */
  export default class ContentManager extends ContentManager1 {
    /**
     * Constructor for a new ContentManager.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     *
     * This class does not have its own settings, but all settings applicable to the base type {@link sap.ui.vk.ContentManager#constructor sap.ui.vk.ContentManager }
     * can be used.
     */
    constructor(
      /**
       * Initial settings for the new ContentManager object.
       */
      mSettings?: $ContentManagerSettings
    );
    /**
     * Constructor for a new ContentManager.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     *
     * This class does not have its own settings, but all settings applicable to the base type {@link sap.ui.vk.ContentManager#constructor sap.ui.vk.ContentManager }
     * can be used.
     */
    constructor(
      /**
       * ID for the new ContentManager object. Generated automatically if no ID is given.
       */
      sId?: string,
      /**
       * Initial settings for the new ContentManager object.
       */
      mSettings?: $ContentManagerSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vk.dvl.ContentManager with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.vk.ContentManager.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ContentManager>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.dvl.ContentManager.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ManagedObjectMetadata;
    /**
     * Gets optional Emscripten runtime module settings.
     *
     * @since 1.50.0
     *
     * @returns A JSON-like object. See {@link ContentManager.setRuntimeSettings ContentManager.setRuntimeSettings}.
     */
    static getRuntimeSettings(): object;
    /**
     * Gets optional WebGL context attributes.
     *
     * @since 1.50.0
     *
     * @returns A JSON-like object. See {@link ContentManager.setWebGLContextAttributes ContentManager.setWebGLContextAttributes}.
     */
    static getWebGLContextAttributes(): object;
    /**
     * Sets optional Emscripten runtime module settings.
     *
     * Emscripten runtime module settings cannot be changed after the Emscripten module is initialized.
     *
     * @since 1.50.0
     */
    static setRuntimeSettings(
      /**
       * A JSON object with the following properties.
       */
      settings: {
        /**
         * The size of Emscripten module memory in bytes, default value: 512 MB.
         */
        totalMemory?: int;
        /**
         * ID of a textarea DOM element to write the log to.
         */
        logElementId?: string;
        /**
         * ID of a DOM element to write the status messages to.
         */
        statusElementId?: string;
      }
    ): void;
    /**
     * Sets optional WebGL context attributes.
     *
     * @since 1.50.0
     */
    static setWebGLContextAttributes(
      /**
       * A JSON object with the following properties.
       */
      attributes: {
        /**
         * If set to `true`, the context will attempt to perform antialiased rendering if possible.
         */
        antialias?: boolean;
        /**
         * If set to `true`, the context will have an alpha (transparency) channel.
         */
        alpha?: boolean;
        /**
         * If set to `true`, the color channels in the framebuffer will be stored premultiplied by the alpha channel
         * to improve performance. Other {@link https://www.khronos.org/registry/webgl/specs/latest/1.0/#5.2 WebGL context attributes }
         * are also supported. WebGL context attributes cannot be changed after the control is fully initialized.
         */
        premultipliedAlpha?: boolean;
      }
    ): void;
    /**
     * Collects and destroys unused objects and resources.
     *
     * @since 1.50.0
     *
     * @returns `this` to allow method chaining.
     */
    collectGarbage(): this;
    /**
     * Destroys the content.
     *
     * @since 1.50.0
     *
     * @returns `this` to allow method chaining.
     */
    destroyContent(
      /**
       * The content to destroy.
       */
      content: any
    ): this;
    /**
     * Starts downloading and building or updating the content from the content resources.
     *
     * This method is asynchronous.
     *
     * @since 1.50.0
     *
     * @returns `this` to allow method chaining.
     */
    loadContent(
      /**
       * The current content to update. It can be `null` if this is an initial loading call.
       */
      content: any,
      /**
       * The content resources to load or update.
       */
      contentResources: ContentResource[]
    ): this;
  }
  /**
   * Describes the settings that can be provided to the ContentManager constructor.
   *
   * @deprecated As of version 1.72.0. DVL namespace will be removed in future. Use {@link sap.ui.vk.ContentManager }
   * instead.
   */
  export interface $ContentManagerSettings extends $ContentManagerSettings1 {}
}

declare module "sap/ui/vk/dvl/GraphicsCore" {
  import EventProvider from "sap/ui/base/EventProvider";

  import ContentResource from "sap/ui/vk/ContentResource";

  import Scene from "sap/ui/vk/dvl/Scene";

  import NodeHierarchy from "sap/ui/vk/NodeHierarchy";

  import ViewStateManager from "sap/ui/vk/ViewStateManager";

  import GraphicsCoreApi from "sap/ui/vk/dvl/GraphicsCoreApi";

  import { DecryptionHandler } from "sap/ui/vk/ContentConnector";

  import Metadata from "sap/ui/base/Metadata";

  /**
   * Loads the DVL library, wraps it, and makes the wrapper available for the application.
   *
   * Example:
   *
   * ```javascript
   *    var oGraphicsCore = new GraphicsCore();```
   *
   *
   *
   * @since 1.32.0
   * @deprecated As of version 1.72.0. DVL namespace will be removed in future. Use {@link sap.ui.vk.ContentConnector }
   * instead.
   */
  export default class GraphicsCore extends EventProvider {
    /**
     * Constructor for a new GraphicsCore.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     *
     * This class does not have its own settings, but all settings applicable to the base type {@link sap.ui.base.EventProvider#constructor sap.ui.base.EventProvider }
     * can be used.
     */
    constructor(
      /**
       * The Emscripten runtime settings.
       */
      runtimeSettings: {
        /**
         * The size of Emscripten module memory in bytes.
         */
        totalMemory: int;
        /**
         * The ID of a textarea DOM element to write the log to.
         */
        logElementId: string;
        /**
         * The ID of a DOM element to write the status messages to.
         */
        statusElementId: string;
      },
      /**
       * The WebGL context attributes. See {@link https://www.khronos.org/registry/webgl/specs/latest/1.0/#5.2 WebGL context attributes}.
       */
      webGLContextAttributes: object
    );

    /**
     * Creates a new subclass of class sap.ui.vk.dvl.GraphicsCore with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.base.EventProvider.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, GraphicsCore>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.dvl.GraphicsCore.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): Metadata;
    /**
     * Builds a scene tree from the hierarchy of content resources. The content resources must be already downloaded.
     *
     *
     * @returns The scene built from the content resources.
     */
    buildSceneTree(
      /**
       * The array of content resources to build the scene from.
       */
      contentResources: ContentResource[]
    ): Scene;
    /**
     * Builds a scene tree from the hierarchy of content resources. The content resources must be already loaded.
     *
     *
     * @returns A {@link https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Promise Promise }
     * object that resolves with an object with two fields:
     * 	 - `scene` - {@link sap.ui.vk.dvl.Scene sap.ui.vk.dvl.Scene} - the scene object.
     * 	 - `failureReason` - object[] - the list of errors if any.
     */
    buildSceneTreeAsync(
      /**
       * The array of content resources to build the scene from.
       */
      contentResources: ContentResource[]
    ): Promise<any>;
    /**
     * Collects and destroys unused objects and resources.
     *
     *
     * @returns `this` to allow method chaining.
     */
    collectGarbage(): this;
    /**
     * Creates a new ViewStateManager object.
     *
     * GraphicsCore owns the new ViewStateManager object. The object must be destroyed with the {@link #destroyViewStateManager destroyViewStateManager }
     * method;
     *
     * @deprecated As of version 1.50.0. Create instance of {@link sap.ui.vk.ViewStateManager} instead.
     *
     * @returns The newly created ViewStateManager object.
     */
    createViewStateManager(
      /**
       * The NodeHierarchy object the view state manager is created for.
       */
      nodeHierarchy: NodeHierarchy,
      /**
       * Flag set by the application to decide whether the {sap.ui.vk.ViewStateManager} should track the visibility
       * changes or not.
       */
      shouldTrackVisibilityChanges: boolean
    ): ViewStateManager;
    /**
     * Destroys the scene object.
     *
     *
     * @returns `this` to allow method chaining.
     */
    destroyScene(
      /**
       * The scene to destroy.
       */
      vkScene: Scene
    ): this;
    /**
     * Destroys the ViewStateManager object created with the {@link #createViewStateManager createViewStateManager }
     * method.
     *
     * @deprecated As of version 1.50.0. Use your reference to {@link sap.ui.vk.ViewStateManager} to properly
     * destroy this object.
     *
     * @returns `this` to allow method chaining.
     */
    destroyViewStateManager(
      /**
       * The ViewStateManagerObject to destroy.
       */
      viewStateManager: ViewStateManager
    ): this;
    /**
     * Gets one of APIs supported by the DVL library.
     *
     *
     * @returns The object that implements the requested API or null if the API is not supported.
     */
    getApi(
      /**
       * The API identifier.
       */
      apiId: GraphicsCoreApi | keyof typeof GraphicsCoreApi
    ): object;
    /**
     * Gets an object that decrypts content of encrypted models.
     *
     *
     * @returns An object that decrypts content of encrypted models.
     */
    getDecryptionHandler(): DecryptionHandler;
    /**
     * Loads content resources.
     *
     * Content resources can be downloaded from a URL or loaded from a local file.
     *
     *
     * @returns `this` to allow method chaining.
     */
    loadContentResourcesAsync(
      /**
       * The content resources to build the scene from.
       */
      contentResources: ContentResource[],
      /**
       * The callback function to call when all content resources are processed. The onComplete callback parameter
       * `sourcesFailedToLoad` takes an array of objects with the properties: source (The content resource that
       * failed to load), status (The VIT Message code i.e 'VIT22') and statusText (VIT Message Summary).
       */
      onComplete: Function,
      /**
       * The callback function to call to report the file loading progress.
       */
      onProgress: Function
    ): this;
    /**
     * Sets an object that decrypts content of encrypted models.
     *
     *
     * @returns `this` to allow method chaining.
     */
    setDecryptionHandler(
      /**
       * An object that decrypts content of encrypted models.
       */
      handler: DecryptionHandler
    ): this;
    /**
     * Sets the maximum number of retry attempts for a download operation if the initial request to retrieve
     * a model from a remote server could not be fulfilled and the error with which the request failed is considered
     * recoverable.
     *
     * See {@link sap.ui.vk.ContentConnector#setRetryCount} for details.
     *
     * @since 1.95.0
     *
     * @returns `this` to allow method chaining.
     */
    setRetryCount(
      /**
       * Maximum number of retry attempts. Value must be non-negative. The default number of retry attempts is
       * 1, unless specified otherwise by calling this method and passing in the desired value. Specifying 0 disables
       * any retry attempts.
       */
      retryCount: int
    ): this;
    /**
     * Shows or hides debug information in the viewports.
     *
     *
     * @returns `this` to allow method chaining.
     */
    showDebugInfo(
      /**
       * `true` to show debug information, `false` to hide debug information.
       */
      enable: boolean
    ): this;
    /**
     * Updates or rebuilds a scene tree from the hierarchy of content resources.
     *
     * The content resources must be already loaded. Some changes in the content resource hierarchy can lead
     * to rebuilding the scene completely. In this case a new scene is created.
     *
     *
     * @returns The scene updated or created.
     */
    updateSceneTree(
      /**
       * The scene to update or null to force to create a new one.
       */
      vkScene: Scene,
      /**
       * The array of content resources to update or build the scene from.
       */
      contentResources: ContentResource[],
      /**
       * The callback function to call when an error happens.
       */
      onError?: Function
    ): Scene;
    /**
     * Updates or rebuilds a scene tree from the hierarchy of content resources.
     *
     * The content resources must be already loaded. Some changes in the content resource hierarchy can lead
     * to rebuilding the scene completely. In this case a new scene is created.
     *
     *
     * @returns A {@link https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Promise Promise }
     * object that resolves with an object with two fields:
     * 	 - `scene` - {@link sap.ui.vk.dvl.Scene sap.ui.vk.dvl.Scene} - the scene object.
     * 	 - `failureReason` - object[] - the list of errors if any.
     */
    updateSceneTreeAsync(
      /**
       * The scene to update or null to force to create a new one.
       */
      vkScene: Scene,
      /**
       * The array of content resources to update or build the scene from.
       */
      contentResources: ContentResource[]
    ): Promise<any>;
  }
}

declare module "sap/ui/vk/dvl/GraphicsCoreApi" {
  /**
   * The types of APIs supported by the {@link sap.ui.vk.dvl.GraphicsCore} class.
   *
   * @deprecated As of version 1.72.0. DVL namespace will be removed in future. This object does not have
   * replacement.
   */
  enum GraphicsCoreApi {
    /**
     * The legacy DVL API implemented in the com.sap.ve.dvl library (dvl.js).
     */
    LegacyDvl = "LegacyDvl",
  }
  export default GraphicsCoreApi;
}

declare module "sap/ui/vk/dvl/LayerProxy" {
  import LayerProxy1 from "sap/ui/vk/LayerProxy";

  import Metadata from "sap/ui/base/Metadata";

  /**
   * Provides a proxy object to the layer in the node hierarchy.
   *
   * Layer is a list of nodes. One node hierarchy can have multiple layers. One node can be included in multiple
   * layers.
   *
   * Objects of this type should only be created with the {@link sap.ui.vk.NodeHierarchy#createLayerProxy sap.ui.vk.NodeHierarchy.createLayerProxy }
   * method and destroyed with the {@link sap.ui.vk.NodeHierarchy#destroyLayerProxy sap.ui.vk.NodeHierarchy.destroyLayerProxy }
   * method.
   *
   * @deprecated As of version 1.72.0. DVL namespace will be removed in future. Use {@link sap.ui.vk.LayerProxy }
   * instead.
   */
  export default class LayerProxy extends LayerProxy1 {
    /**
     * Constructor for a new LayerProxy.
     *
     * Objects of this type should only be created with the {@link sap.ui.vk.NodeHierarchy#createLayerProxy sap.ui.vk.NodeHierarchy.createLayerProxy }
     * method and destroyed with the {@link sap.ui.vk.NodeHierarchy#destroyLayerProxy sap.ui.vk.NodeHierarchy.destroyLayerProxy }
     * method.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     *
     * This class does not have its own settings, but all settings applicable to the base type {@link sap.ui.vk.LayerProxy#constructor sap.ui.vk.LayerProxy }
     * can be used.
     */
    constructor();

    /**
     * Creates a new subclass of class sap.ui.vk.dvl.LayerProxy with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.vk.LayerProxy.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, LayerProxy>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.dvl.LayerProxy.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): Metadata;
    /**
     * Gets the description of the layer.
     *
     *
     * @returns The description of the layer.
     */
    getDescription(): string;
    /**
     * Gets the layer ID.
     *
     *
     * @returns The layer ID.
     */
    getLayerId(): string;
    /**
     * Gets the layer metadata.
     *
     *
     * @returns The layer metadata.
     */
    getLayerMetadata(): object;
    /**
     * Gets the name of the layer
     *
     *
     * @returns The name of the layer.
     */
    getName(): string;
    /**
     * Gets an array of IDs of nodes belonging to the layer.
     *
     *
     * @returns An array of IDs of nodes belonging to the layer.
     */
    getNodes(): string[];
    /**
     * Gets the layer VE IDs.
     *
     *
     * @returns The layer VE IDs.
     */
    getVeIds(): object[];
  }
}

declare module "sap/ui/vk/dvl/NodeHierarchy" {
  import {
    default as NodeHierarchy1,
    $NodeHierarchySettings as $NodeHierarchySettings1,
  } from "sap/ui/vk/NodeHierarchy";

  import LayerProxy from "sap/ui/vk/LayerProxy";

  import NodeProxy from "sap/ui/vk/dvl/NodeProxy";

  import GraphicsCore from "sap/ui/vk/dvl/GraphicsCore";

  import ManagedObjectMetadata from "sap/ui/base/ManagedObjectMetadata";

  import NodeContentType from "sap/ui/vk/NodeContentType";

  import Scene from "sap/ui/vk/Scene";

  /**
   * Provides the ability to explore a Scene object's node structure.
   *
   * The objects of this class should not be created directly, and should only be created via a call to {@link sap.ui.vk.Scene#getDefaultNodeHierarchy sap.ui.vk.Scene.getDefaultNodeHierarchy}.
   *
   * @since 1.32.0
   * @deprecated As of version 1.72.0. DVL namespace will be removed in future. Use {@link sap.ui.vk.NodeHierarchy }
   * instead.
   */
  export default class NodeHierarchy extends NodeHierarchy1 {
    /**
     * Constructor for a new NodeHierarchy.
     *
     * The objects of this class should not be created directly, and should only be created via a call to {@link sap.ui.vk.Scene#getDefaultNodeHierarchy sap.ui.vk.Scene.getDefaultNodeHierarchy}.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     *
     * This class does not have its own settings, but all settings applicable to the base type {@link sap.ui.vk.NodeHierarchy#constructor sap.ui.vk.NodeHierarchy }
     * can be used.
     */
    constructor();

    /**
     * Creates a new subclass of class sap.ui.vk.dvl.NodeHierarchy with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.vk.NodeHierarchy.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, NodeHierarchy>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.dvl.NodeHierarchy.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ManagedObjectMetadata;
    /**
     * Creates a layer proxy object.
     *
     * The layer proxy object must be destroyed with the {@link #destroyLayerProxy destroyLayerProxy} method.
     *
     *
     * @returns The proxy object.
     */
    createLayerProxy(
      /**
       * The layer ID for which to create a proxy object.
       */
      layerId: string
    ): LayerProxy;
    /**
     * Creates a new node.
     *
     * @since 1.48.0
     *
     * @returns The node reference of the newly created node.
     */
    createNode(
      /**
       * The parent node reference where the created node is added to. If equals `null` the newly created node
       * is a top level node.
       */
      parentNode: any,
      /**
       * The name of the new node.
       */
      name: string,
      /**
       * The created node is added before this specified node. If equals `null` the newly created node is added
       * at the end of the parent's list of nodes.
       */
      insertBeforeNode: any
    ): any;
    /**
     * Creates a copy of an existing node.
     *
     * @since 1.48.0
     *
     * @returns The node reference of the newly created node.
     */
    createNodeCopy(
      /**
       * The reference to the node to copy.
       */
      nodeToCopy: any,
      /**
       * The reference to the parent node where the created node is added to. If equals `null` the newly created
       * node is a top level node.
       */
      parentNode: any,
      /**
       * The name of the new node.
       */
      name: string,
      /**
       * The created node is added before this specified node. If equals `null` the newly created node is added
       * at the end of the parent's list of nodes.
       */
      insertBeforeNode: any
    ): any;
    /**
     * Creates a node proxy object.
     *
     * The node proxy object must be destroyed with the {@link #destroyNodeProxy destroyNodeProxy} method.
     *
     *
     * @returns The proxy object.
     */
    createNodeProxy(
      /**
       * The node reference for which to create a proxy object.
       */
      nodeRef: any
    ): NodeProxy;
    /**
     * Destroys the layer proxy object.
     *
     *
     * @returns `this` to allow method chaining.
     */
    destroyLayerProxy(
      /**
       * The layer proxy object.
       */
      layerProxy: LayerProxy
    ): this;
    /**
     * Destroys the node proxy object.
     *
     *
     * @returns `this` to allow method chaining.
     */
    destroyNodeProxy(
      /**
       * The node proxy object.
       */
      nodeProxy: NodeProxy
    ): this;
    /**
     * Enumerates the ancestor nodes of a particular node in the Scene object.
     *
     * This method enumerates the ancestor nodes of a particular node, and then calls the `callback` function,
     * to which it passes the ancestor nodes to one by one.
     *  The BaseNodeProxy objects passed to `callback` are temporary objects, they are reset after each call
     * to the `callback` function.
     *  The ancestor nodes are enumerated starting from the top level node, and progresses down the node hierarchy.
     *
     *
     * @returns `this` to allow method chaining.
     */
    enumerateAncestors(
      /**
       * The node reference whose ancestor nodes we want enumerated.
       */
      nodeRef: any,
      /**
       * A function to call when the ancestor nodes are enumerated. The function takes one parameter of type {@link sap.ui.vk.dvl.BaseNodeProxy},
       * or string if parameter `passNodeRef` parameter is `true`.
       */
      callback: Function,
      /**
       * Indicates whether to pass the node references of the ancestor nodes, or the whole node proxy to the `callback`
       * function.
       *  If `true`, then only the node references of the ancestor nodes are passed to the `callback` function.
       *
       *  If `false`, then the node proxies of the ancestor nodes are passed to the `callback` function.
       */
      passNodeRef?: boolean
    ): this;
    /**
     * Enumerates the child nodes of a particular node in the Scene object.
     *
     * This method gets the child nodes of a particular node, and then calls the `callback` function to which
     * it passes the child nodes to one by one.
     *  The `BaseNodeProxy` objects passed to the `callback` function are temporary objects, which are reset
     * after each call to the `callback` function.
     *
     *
     *
     * @returns `this` to allow method chaining.
     */
    enumerateChildren(
      /**
       * The node reference whose child nodes we want enumerated.
       *  When `nodeRef` is specified, the child nodes of this node are enumerated.
       *  When no `nodeRef` is specified, only the top level nodes are enumerated.
       */
      nodeRef: any,
      /**
       * A function to call when the child nodes are enumerated. The function takes one parameter of type {@link sap.ui.vk.dvl.BaseNodeProxy},
       * or string if parameter `passNodeRef` parameter is `true`.
       */
      callback: Function,
      /**
       * Indicates whether to enumerate the child nodes if the node is closed.
       *  If `true`, the children of that closed node will be enumerated
       *  If `false`, the children of that node will not be enumerated
       */
      stepIntoClosedNodes?: boolean,
      /**
       * Indicates whether to pass the node references of the child nodes, or the whole node proxy to the `callback`
       * function.
       *  If `true`, then only the node references of the child nodes are passed to the `callback` function.
       *  If `false`, then the node proxies created from the child node references are passed to the `callback`
       * function.
       */
      passNodeRef?: boolean
    ): this;
    /**
     * Enumerates the child nodes of a particular node in the Scene object.
     *
     * This method gets the child nodes of a particular node, and then calls the `callback` function to which
     * it passes the child nodes to one by one.
     *  The `BaseNodeProxy` objects passed to the `callback` function are temporary objects, which are reset
     * after each call to the `callback` function.
     *
     *
     *
     * @returns `this` to allow method chaining.
     */
    enumerateChildren(
      /**
       * A function to call when the child nodes are enumerated. The function takes one parameter of type {@link sap.ui.vk.dvl.BaseNodeProxy},
       * or string if parameter `passNodeRef` parameter is `true`.
       */
      callback: Function,
      /**
       * Indicates whether to enumerate the child nodes if the node is closed.
       *  If `true`, the children of that closed node will be enumerated
       *  If `false`, the children of that node will not be enumerated
       */
      stepIntoClosedNodes?: boolean,
      /**
       * Indicates whether to pass the node references of the child nodes, or the whole node proxy to the `callback`
       * function.
       *  If `true`, then only the node references of the child nodes are passed to the `callback` function.
       *  If `false`, then the node proxies created from the child node references are passed to the `callback`
       * function.
       */
      passNodeRef?: boolean
    ): this;
    /**
     * Finds nodes in a scene via node name.
     *
     *
     * @returns A list of IDs belonging to nodes that matched the search criteria.
     */
    findNodesByName(
      /**
       * JSON object containing the search parameters.
       *  The following example shows what the structure of the `query` object should look like:
       * ```javascript
       * query = {
       * 	value: string | string[],
       * 	predicate: "equals" | "contains" | "startsWith",
       * 	caseSensitive: true | false
       * }```
       *
       *
       * 	 -  **query.value**
       *  A string or an array of strings containing the name of a node or names of nodes. If no value is specified,
       * then all nodes in the scene will be returned.
       *  The following example shows a single string being passed in:
       * ```javascript
       * value: "Box #14"```
       *  The following example shows an array of strings being passed in:
       * ```javascript
       * value: ["Box #3", "box #4", "BOX #5"]```
       *
       * 	 -  **query.predicate**
       *  Represents a search mode. The available search modes are `"equals"`, `"contains"`, and `"startsWith"`.
       *
       *  Using `"equals"` will search for nodes with names that exactly match the provided string or array of
       * strings.
       *  Using `"contains"` will search for nodes with names containing all or part of the provided string or
       * array of strings.
       *  Using `"startsWith"` will search for nodes with names starting with the provided string or array of
       * strings.
       *  If no value is specified, the search mode will default to `"equals"`.
       *
       *
       * 	 -  **query.caseSensitive**
       *  Indicates whether the search should be case sensitive or not.
       *  If `true`, the search will be case sensitive, and `false` indicates otherwise.
       *  If no value is specified, `caseSensitive` will default to `false` (that is, the search will be a case-insensitive
       * search).
       */
      query: object
    ): string[];
    /**
     * Returns a list of IDs belonging to the ancestors of a particular node.
     *
     *
     * @returns A list of IDs belonging to the ancestors of `nodeRef`.
     */
    getAncestors(
      /**
       * The node reference of the node whose ancestors will be returned.
       */
      nodeRef: any
    ): string[];
    /**
     * Returns a list of IDs belonging to the children of a particular node.
     *
     *
     * @returns A list of IDs belonging to the children of `nodeRef`.
     */
    getChildren(
      /**
       * The node reference of the node whose children will be returned. If `nodeRef` is not passed to the `getChildren`
       * function, the IDs of the root nodes will be returned.
       */
      nodeRef: any,
      /**
       * Indicates whether to return only the child nodes of a closed node or not. If `true`, then the
       * children of that closed node will be returned. If `false`, then the children of that closed node
       * will not be returned.
       */
      stepIntoClosedNodes?: boolean
    ): string[];
    /**
     * Gets the GraphicsCore object this Scene object belongs to.
     *
     *
     * @returns The GraphicsCore object this Scene object belongs to.
     */
    getGraphicsCore(): GraphicsCore;
    /**
     * Returns a list of hotspot node references.
     *
     *
     * @returns A list of hotspot node references.
     */
    getHotspotNodeRefs(): any[];
    /**
     * Returns a list of layer IDs.
     *
     *
     * @returns A list of layer IDs.
     */
    getLayers(): string[];
    /**
     * Get node content type
     *
     * @since 1.73.0
     *
     * @returns Node content type
     */
    getNodeContentType(
      /**
       * The node reference
       */
      nodeRef: any
    ): NodeContentType;
    /**
     * Gets the Scene object the node hierarchy belongs to.
     *
     *
     * @returns The Scene object the node hierarchy belongs to.
     */
    getScene(): Scene;
    /**
     * Gets the scene reference that this NodeHierarchy object wraps.
     *
     *
     * @returns The scene reference that this NodeHierarchy object wraps.
     */
    getSceneRef(): any;
    /**
     * Deletes a node and destroys it.
     *
     * @since 1.48.0
     *
     * @returns `this` to allow method chaining.
     */
    removeNode(
      /**
       * The reference to a node or an array of nodes to destroy.
       */
      nodeRef: any
    ): this;
  }
  /**
   * Describes the settings that can be provided to the NodeHierarchy constructor.
   *
   * @deprecated As of version 1.72.0. DVL namespace will be removed in future. Use {@link sap.ui.vk.NodeHierarchy }
   * instead.
   */
  export interface $NodeHierarchySettings extends $NodeHierarchySettings1 {}
}

declare module "sap/ui/vk/dvl/NodeProxy" {
  import {
    default as NodeProxy1,
    $NodeProxySettings as $NodeProxySettings1,
  } from "sap/ui/vk/NodeProxy";

  import ManagedObjectMetadata from "sap/ui/base/ManagedObjectMetadata";

  /**
   * Provides a proxy object to the node in the node hierarchy.
   *
   * Objects of this type should only be created with the {@link sap.ui.vk.NodeHierarchy#createNodeProxy sap.ui.vk.NodeHierarchy.createNodeProxy }
   * method. and destroyed with the {@link sap.ui.vk.NodeHierarchy#destroyNodeProxy sap.ui.vk.NodeHierarchy.destroyNodeProxy }
   * method.
   *
   * @since 1.32.0
   * @deprecated As of version 1.72.0. DVL namespace will be removed in future. Use {@link sap.ui.vk.NodeProxy }
   * instead.
   */
  export default class NodeProxy extends NodeProxy1 {
    /**
     * Constructor for a new NodeProxy.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     *
     * This class does not have its own settings, but all settings applicable to the base type {@link sap.ui.vk.NodeProxy#constructor sap.ui.vk.NodeProxy }
     * can be used.
     */
    constructor();

    /**
     * Creates a new subclass of class sap.ui.vk.dvl.NodeProxy with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.vk.NodeProxy.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, NodeProxy>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.dvl.NodeProxy.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ManagedObjectMetadata;
  }
  /**
   * Describes the settings that can be provided to the NodeProxy constructor.
   *
   * @deprecated As of version 1.72.0. DVL namespace will be removed in future. Use {@link sap.ui.vk.NodeProxy }
   * instead.
   */
  export interface $NodeProxySettings extends $NodeProxySettings1 {}
}

declare module "sap/ui/vk/dvl/Scene" {
  import {
    default as Scene1,
    $SceneSettings as $SceneSettings1,
  } from "sap/ui/vk/Scene";

  import NodeHierarchy from "sap/ui/vk/NodeHierarchy";

  import GraphicsCore from "sap/ui/vk/dvl/GraphicsCore";

  import ManagedObjectMetadata from "sap/ui/base/ManagedObjectMetadata";

  /**
   * Provides the interface for the 3D model.
   *
   * The objects of this class should not be created directly. They should be created via {@link sap.ui.vk.ContentConnector sap.ui.vk.ContentConnector}.
   *
   * @deprecated As of version 1.72.0. DVL namespace will be removed in future. Use {@link sap.ui.vk.Scene }
   * instead.
   */
  export default class Scene extends Scene1 {
    /**
     * Constructor for a new Scene.
     *
     * The objects of this class should not be created directly. They should be created via {@link sap.ui.vk.ContentConnector sap.ui.vk.ContentConnector}.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     *
     * This class does not have its own settings, but all settings applicable to the base type {@link sap.ui.vk.Scene#constructor sap.ui.vk.Scene }
     * can be used.
     */
    constructor();

    /**
     * Creates a new subclass of class sap.ui.vk.dvl.Scene with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.vk.Scene.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Scene>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.dvl.Scene.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ManagedObjectMetadata;
    /**
     * Gets the default node hierarchy in the Scene object.
     *
     *
     * @returns The default node hierarchy in the Scene object.
     */
    getDefaultNodeHierarchy(): NodeHierarchy;
    /**
     * Gets the GraphicsCore object this Scene object belongs to.
     *
     *
     * @returns The GraphicsCore object this Scene object belongs to.
     */
    getGraphicsCore(): GraphicsCore;
    /**
     * Gets the unique ID of the Scene object.
     *
     *
     * @returns The unique ID of the Scene object.
     */
    getId(): string;
    /**
     * Gets the DVL scene ID.
     *
     *
     * @returns The DVL scene ID.
     */
    getSceneRef(): string;
  }
  /**
   * Describes the settings that can be provided to the Scene constructor.
   *
   * @deprecated As of version 1.72.0. DVL namespace will be removed in future. Use {@link sap.ui.vk.Scene }
   * instead.
   */
  export interface $SceneSettings extends $SceneSettings1 {}
}

declare module "sap/ui/vk/dvl/Viewport" {
  import {
    default as ViewportBase,
    $ViewportBaseSettings,
  } from "sap/ui/vk/ViewportBase";

  import Event from "sap/ui/base/Event";

  import Viewport1 from "sap/ui/vk/Viewport";

  import GraphicsCore from "sap/ui/vk/dvl/GraphicsCore";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import Scene from "sap/ui/vk/Scene";

  import CameraFOVBindingType from "sap/ui/vk/CameraFOVBindingType";

  import CameraProjectionType from "sap/ui/vk/CameraProjectionType";

  import { CSSColor } from "sap/ui/core/library";

  import ZoomTo from "sap/ui/vk/ZoomTo";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Provides a rendering canvas for the 3D elements of a loaded scene.
   *
   * @deprecated As of version 1.72.0. DVL namespace will be removed in future. Use {@link sap.ui.vk.Viewport }
   * instead.
   */
  export default class Viewport extends ViewportBase {
    /**
     * Constructor for a new Viewport.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new Viewport control.
       */
      mSettings?: $ViewportSettings
    );
    /**
     * Constructor for a new Viewport.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new Viewport control. Generated automatically if no ID is given.
       */
      sId?: string,
      /**
       * Initial settings for the new Viewport control.
       */
      mSettings?: $ViewportSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vk.dvl.Viewport with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.vk.ViewportBase.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Viewport>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.dvl.Viewport.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:frameRenderingFinished frameRenderingFinished }
     * event of this `sap.ui.vk.dvl.Viewport`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.dvl.Viewport` itself.
     *
     * This event will be fired when the frame rendering has finished.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachFrameRenderingFinished(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.dvl.Viewport` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:frameRenderingFinished frameRenderingFinished }
     * event of this `sap.ui.vk.dvl.Viewport`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.dvl.Viewport` itself.
     *
     * This event will be fired when the frame rendering has finished.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachFrameRenderingFinished(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.dvl.Viewport` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:pan pan} event of this `sap.ui.vk.dvl.Viewport`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.dvl.Viewport` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPan(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Viewport$PanEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.dvl.Viewport` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:pan pan} event of this `sap.ui.vk.dvl.Viewport`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.dvl.Viewport` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPan(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Viewport$PanEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.dvl.Viewport` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:rotate rotate} event of this `sap.ui.vk.dvl.Viewport`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.dvl.Viewport` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachRotate(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Viewport$RotateEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.dvl.Viewport` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:rotate rotate} event of this `sap.ui.vk.dvl.Viewport`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.dvl.Viewport` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachRotate(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Viewport$RotateEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.dvl.Viewport` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:zoom zoom} event of this `sap.ui.vk.dvl.Viewport`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.dvl.Viewport` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachZoom(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Viewport$ZoomEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.dvl.Viewport` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:zoom zoom} event of this `sap.ui.vk.dvl.Viewport`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.dvl.Viewport` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachZoom(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Viewport$ZoomEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.dvl.Viewport` itself
       */
      oListener?: object
    ): this;
    /**
     * Marks the start of the current gesture operation.
     *
     *
     * @returns this
     */
    beginGesture(
      /**
       * The x-coordinate of the gesture.
       */
      x: int,
      /**
       * The y-coordinate of the gesture.
       */
      y: int
    ): Viewport1;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:frameRenderingFinished frameRenderingFinished }
     * event of this `sap.ui.vk.dvl.Viewport`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachFrameRenderingFinished(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:pan pan} event of this `sap.ui.vk.dvl.Viewport`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachPan(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Viewport$PanEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:rotate rotate} event of this `sap.ui.vk.dvl.Viewport`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachRotate(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Viewport$RotateEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:zoom zoom} event of this `sap.ui.vk.dvl.Viewport`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachZoom(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Viewport$ZoomEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Marks the end of the current gesture operation.
     *
     *
     * @returns this
     */
    endGesture(): Viewport1;
    /**
     * Fires event {@link #event:frameRenderingFinished frameRenderingFinished} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireFrameRenderingFinished(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:pan pan} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    firePan(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: Viewport$PanEventParameters
    ): this;
    /**
     * Fires event {@link #event:rotate rotate} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireRotate(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: Viewport$RotateEventParameters
    ): this;
    /**
     * Fires event {@link #event:zoom zoom} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireZoom(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: Viewport$ZoomEventParameters
    ): this;
    /**
     * Gets current value of property {@link #getBackgroundColorBottomABGR backgroundColorBottomABGR}.
     *
     * Viewport background bottom color in the ABGR format
     *
     * Default value is `0xffffffff`.
     *
     *
     * @returns Value of property `backgroundColorBottomABGR`
     */
    getBackgroundColorBottomABGR(): int;
    /**
     * Gets current value of property {@link #getBackgroundColorTopABGR backgroundColorTopABGR}.
     *
     * Viewport background top color in the ABGR format
     *
     * Default value is `0xff000000`.
     *
     *
     * @returns Value of property `backgroundColorTopABGR`
     */
    getBackgroundColorTopABGR(): int;
    /**
     * Gets the {@link sap.ui.vk.dvl.GraphicsCore GraphicsCore} object the Viewport is attached to.
     *
     * @deprecated As of version 1.50.0. Create instance of {@link sap.ui.vk.ContentConnector} instead.
     *
     * @returns The {@link sap.ui.vk.dvl.GraphicsCore GraphicsCore} object the Viewport is attached to, or `null`.
     */
    getGraphicsCore(): GraphicsCore;
    /**
     *
     * @returns The ID of the node that is currently set as isolated.
     */
    getIsolatedNode(): string;
    /**
     * Gets position and size of the viewport square. The information can be used for making calculations when
     * restoring Redlining elements.
     *
     *
     * @returns The information in this object:
     * 	 - **left** - The x coordinate of the top-left corner of the square.
     * 	 - **top** - The y coordinate of the top-left corner of the square.
     * 	 - **sideLength** - The length of the square.
     */
    getOutputSize(): object;
    /**
     * Retrieves information about the current camera view in the scene, and saves the information in a JSON-like
     * object. The information can then be used at a later time to restore the scene to the same camera view
     * using the {@link sap.ui.vk.Viewport#setViewInfo setViewInfo} method.
     *
     *
     *
     * @returns JSON-like object which holds the current view information. See {@link sap.ui.vk.Viewport#setViewInfo setViewInfo}.
     * In addition to properties defined in {@link sap.ui.vk.Viewport#setViewInfo setViewInfo} the output from
     * {@link sap.ui.vk.Viewport#getViewInfo getViewInfo} contains camera view and projection matrices
     * ```javascript
     *
     *   {
     *     ...
     *     camera: {
     *       ...
     *       matrices: {
     *         view:       [number, ...],
     *         projection: [number, ...],
     *       }
     *       ...
     *     },
     *     ...
     *   }
     * ```
     */
    getViewInfo(
      /**
       * Query object which indicates what information to be retrieved.
       */
      query?: {
        /**
         * Indicator to retrieve camera information.
         */
        camera?:
          | boolean
          | {
              /**
               * Indicator to retrieve camera view and projection matrices.
               */
              matrices?: boolean;
              /**
               * Indicator to retrieve the transition camera properties instead of regular one's.
               */
              useTransitionCamera?: boolean;
            };
        /**
         * Indicator to retrieve animation information.
         */
        animation?: boolean;
        /**
         * Indicator to retrieve visibility information.
         */
        visibility?:
          | boolean
          | {
              /**
               * Indicator to retrieve the complete visibility definition or just the difference.
               */
              mode?: /* was: sap.ui.vk.VisibilityMode */ any;
            };
      }
    ): object;
    /**
     * Performs a `pan` gesture to pan across the Viewport.
     *
     *
     * @returns this
     */
    pan(
      /**
       * The change in distance along the x-coordinate.
       */
      dx: int,
      /**
       * The change in distance along the y-coordinate.
       */
      dy: int
    ): Viewport1;
    /**
     * Queues a command for execution during the rendering cycle. All gesture operations should be called using
     * this method.
     *
     *
     * @returns this
     */
    queueCommand(
      /**
       * The command to be executed.
       */
      command: Function
    ): Viewport1;
    /**
     * Executes a rectangular selection.
     *
     *
     * @returns The array of node references that are selected.
     */
    rectSelect(
      /**
       * The x-coordinate of starting vertex of selection rectangle.
       */
      x1: int,
      /**
       * The y-coordinate of starting vertex of selection rectangle.
       */
      y1: int,
      /**
       * The x-coordinate of ending vertex of selection rectangle.
       */
      x2: int,
      /**
       * The y-coordinate of ending vertex of selection rectangle.
       */
      y2: int
    ): any[];
    /**
     * Rotates the content resource displayed on the Viewport.
     *
     *
     * @returns this
     */
    rotate(
      /**
       * The change in x-coordinate used to define the desired rotation.
       */
      dx: int,
      /**
       * The change in y-coordinate used to define the desired rotation.
       */
      dy: int
    ): Viewport1;
    /**
     * Sets the background color for the bottom area of the Viewport.
     *
     *
     * @returns `this` to allow method chaining.
     */
    setBackgroundColorBottomABGR(
      /**
       * Takes an integer value as parameter. For example: 0xffffffff as hexadecimal value (0x prefix, FF alpha,
       * FF blue, FF green, FF red)
       */
      integerColor: int
    ): this;
    /**
     * Sets the background color for the top area of the Viewport.
     *
     *
     * @returns `this` to allow method chaining.
     */
    setBackgroundColorTopABGR(
      /**
       * Takes an integer value as parameter. For example: 0xffffffff as hexadecimal value (0x prefix, FF alpha,
       * FF blue, FF green, FF red)
       */
      integerColor: int
    ): this;
    /**
     * Attaches or detaches the Viewport to the {@link sap.ui.vk.dvl.GraphicsCore GraphicsCore} object.
     *
     * @deprecated As of version 1.50.0. Create instance of {@link sap.ui.vk.ContentConnector} instead.
     *
     * @returns `this` to allow method chaining.
     */
    setGraphicsCore(
      /**
       * The {@link sap.ui.vk.dvl.GraphicsCore GraphicsCore} object or `null`. If the `graphicsCore` parameter
       * is not `null`, a rendering object corresponding to the Viewport is created. If the `graphicsCore` parameter
       * is `null`, the rendering object corresponding to the Viewport is destroyed.
       */
      graphicsCore: GraphicsCore
    ): this;
    /**
     * Attaches the scene to the Viewport for rendering.
     *
     * @deprecated As of version 1.50.0. Viewport now gets reference to the scene via {@link sap.ui.vk.ContentConnector}.
     *
     * @returns `this` to allow method chaining.
     */
    setScene(
      /**
       * The scene to attach to the Viewport.
       */
      scene: Scene
    ): this;
    /**
     * Set selection rectangle for rendering
     */
    setSelectionRect(
      /**
       * coordinates of selection rectangle
       */
      rect: object
    ): void;
    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns `this` to allow method chaining.
     */
    setShouldRenderFrame(): this;
    /**
     * Sets the current scene to use the camera view information acquired from the {@link sap.ui.vk.Viewport#getViewInfo getViewInfo }
     * method.
     *  Internally, the `setViewInfo` method activates certain steps at certain animation times, and then changes
     * the camera position, rotation and field of view (FOV) / zoom factor.
     *
     *
     * @returns `this` to allow method chaining.
     */
    setViewInfo(
      /**
       * A JSON-like object containing view information acquired using the {@link sap.ui.vk.Viewport#getViewInfo getViewInfo }
       * method.
       */
      viewInfo: {
        /**
         * A JSON-like object containing the camera information.
         */
        camera?: {
          /**
           * Rotation defined in {@link https://en.wikipedia.org/wiki/Aircraft_principal_axes Aircraft principal axes}.
           */
          rotation: {
            /**
             * Angle around the vertical axis in degrees.
             */
            yaw: float;
            /**
             * Angle around the lateral axis in degrees.
             */
            pitch: float;
            /**
             * Angle around the longitudinal axis in degrees.
             */
            roll: float;
          };
          /**
           * Position defined in 3-dimensional space.
           */
          position: {
            /**
             * X coordinate.
             */
            x: float;
            /**
             * Y coordinate.
             */
            y: float;
            /**
             * Z coordinate.
             */
            z: float;
          };
          /**
           * Camera field of view binding type.
           */
          bindingType: CameraFOVBindingType;
          /**
           * Camera projection type.
           */
          projectionType: CameraProjectionType;
          /**
           * Camera field of view in degrees. Applicable only to perspective cameras.
           */
          fieldOfView: float;
          /**
           * Camera zoom factor. Applicable only to orthographic cameras.
           */
          zoomFactor: float;
        };
        /**
         * A JSON-like object containing the animation information.
         */
        animation?: {
          /**
           * Step VE ID. If it is omitted then procedure and step indices are used.
           */
          stepVeId?: string;
          /**
           * Procedure index in the list of procedures.
           */
          procedureIndex?: int;
          /**
           * Step index in the list of steps in the procedure.
           */
          stepIndex?: int;
          /**
           * Time at which to activate the step.
           */
          animationTime?: float;
        };
        /**
         * A JSON-like object containing the visibility information.
         */
        visibility?: {
          /**
           * If the mode equals to {@link sap.ui.vk.VisibilityMode.Complete complete} then the visible and hidden
           * fields are defined. If the mode equals {@link sap.ui.vk.VisibilityMode.Differences differences} then
           * the changes field is defined.
           */
          mode: /* was: sap.ui.vk.VisibilityMode */ any;
          /**
           * List of Ids of visible nodes.
           */
          visible: string[];
          /**
           * List of Ids of hidden nodes.
           */
          hidden: string[];
          /**
           * List of Ids of nodes with inverted visibility.
           */
          changes: string[];
        };
      },
      /**
       * Fly-to animation duration in seconds.
       */
      flyToDuration?: float
    ): this;
    /**
     *
     * @returns `this` to allow method chaining.
     */
    showHotspots(
      /**
       * The node reference or the array of node references that we want to tint.
       */
      nodeRefs: any | any[],
      /**
       * Whether to highlight the nodes or remove the highlight.
       */
      show: boolean,
      /**
       * The color to use for highlighting the nodes passed as argument.
       */
      color: int | CSSColor
    ): this;
    /**
     * Executes a click or tap gesture.
     *
     *
     * @returns this
     */
    tap(
      /**
       * The tap gesture's x-coordinate.
       */
      x: int,
      /**
       * The tap gesture's y-coordinate.
       */
      y: int,
      /**
       * Indicates whether the tap gesture should be interpreted as a double-click. A value of `true` indicates
       * a double-click gesture, and `false` indicates a single click gesture.
       */
      isDoubleClick: boolean
    ): Viewport;
    /**
     * Performs a `zoom` gesture to zoom in or out on the beginGesture coordinate.
     *
     *
     * @returns this
     */
    zoom(
      /**
       * Zoom factor. A scale factor that specifies how much to zoom in or out by.
       */
      dy: float
    ): Viewport1;
    /**
     * Zooms the scene to a bounding box created from a particular set of nodes.
     *
     *
     * @returns this
     */
    zoomTo(
      /**
       * What set of nodes to zoom to.
       */
      what: ZoomTo | ZoomTo[],
      /**
       * Is only used if what == sap.ui.vk.ZoomTo.Node.
       */
      nodeRef: any,
      /**
       * Time to perform the "fly to" animation. Set to 0 to do this immediately.
       */
      crossFadeSeconds: float,
      /**
       * Margin. Set to 0 to zoom to the entire screen.
       */
      margin: float
    ): Viewport1;
  }
  /**
   * Describes the settings that can be provided to the Viewport constructor.
   *
   * @deprecated As of version 1.72.0. DVL namespace will be removed in future. Use {@link sap.ui.vk.Viewport }
   * instead.
   */
  export interface $ViewportSettings extends $ViewportBaseSettings {
    /**
     * Viewport background top color in the ABGR format
     */
    backgroundColorTopABGR?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Viewport background bottom color in the ABGR format
     */
    backgroundColorBottomABGR?: int | PropertyBindingInfo | `{${string}}`;

    pan?: (oEvent: Viewport$PanEvent) => void;

    zoom?: (oEvent: Viewport$ZoomEvent) => void;

    rotate?: (oEvent: Viewport$RotateEvent) => void;

    /**
     * This event will be fired when the frame rendering has finished.
     */
    frameRenderingFinished?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the Viewport#frameRenderingFinished event.
   */
  export interface Viewport$FrameRenderingFinishedEventParameters {}

  /**
   * Event object of the Viewport#frameRenderingFinished event.
   */
  export type Viewport$FrameRenderingFinishedEvent = Event<
    Viewport$FrameRenderingFinishedEventParameters,
    Viewport
  >;

  /**
   * Parameters of the Viewport#pan event.
   */
  export interface Viewport$PanEventParameters {
    dx?: int;

    dy?: int;
  }

  /**
   * Event object of the Viewport#pan event.
   */
  export type Viewport$PanEvent = Event<Viewport$PanEventParameters, Viewport>;

  /**
   * Parameters of the Viewport#rotate event.
   */
  export interface Viewport$RotateEventParameters {
    dx?: int;

    dy?: int;
  }

  /**
   * Event object of the Viewport#rotate event.
   */
  export type Viewport$RotateEvent = Event<
    Viewport$RotateEventParameters,
    Viewport
  >;

  /**
   * Parameters of the Viewport#zoom event.
   */
  export interface Viewport$ZoomEventParameters {
    zoomFactor?: float;
  }

  /**
   * Event object of the Viewport#zoom event.
   */
  export type Viewport$ZoomEvent = Event<
    Viewport$ZoomEventParameters,
    Viewport
  >;
}

declare module "sap/ui/vk/dvl/ViewStateManager" {
  import {
    default as ViewStateManagerBase,
    $ViewStateManagerBaseSettings,
  } from "sap/ui/vk/ViewStateManagerBase";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import NodeHierarchy from "sap/ui/vk/NodeHierarchy";

  import { CSSColor } from "sap/ui/core/library";

  /**
   * Manages the visibility and selection states of nodes in the scene.
   *
   * @deprecated As of version 1.72.0. DVL namespace will be removed in future. Use {@link sap.ui.vk.ViewStateManager }
   * instead.
   */
  export default class ViewStateManager extends ViewStateManagerBase {
    /**
     * Constructor for a new ViewStateManager.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     *
     * This class does not have its own settings, but all settings applicable to the base type {@link sap.ui.vk.ViewStateManagerBase#constructor sap.ui.vk.ViewStateManagerBase }
     * can be used.
     */
    constructor(
      /**
       * Initial settings for the new ViewStateManager object.
       */
      mSettings?: $ViewStateManagerSettings
    );
    /**
     * Constructor for a new ViewStateManager.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     *
     * This class does not have its own settings, but all settings applicable to the base type {@link sap.ui.vk.ViewStateManagerBase#constructor sap.ui.vk.ViewStateManagerBase }
     * can be used.
     */
    constructor(
      /**
       * ID for the new ViewStateManager object. Generated automatically if no ID is given.
       */
      sId?: string,
      /**
       * Initial settings for the new ViewStateManager object.
       */
      mSettings?: $ViewStateManagerSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vk.dvl.ViewStateManager with name `sClassName` and enriches it
     * with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.vk.ViewStateManagerBase.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ViewStateManager>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.dvl.ViewStateManager.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Enumerates IDs of the selected nodes.
     *
     *
     * @returns `this` to allow method chaining.
     */
    enumerateSelection(
      /**
       * A function to call when the selected nodes are enumerated. The function takes one parameter of type `string`.
       */
      callback: Function
    ): this;
    /**
     * Gets the NodeHierarchy object associated with this ViewStateManager object.
     *
     *
     * @returns The node hierarchy associated with this ViewStateManager object.
     */
    getNodeHierarchy(): NodeHierarchy;
    /**
     * Gets the opacity of the node.
     *
     * If a single node reference is passed to the method then a single value is returned.
     *  If an array of node references is passed to the method then an array of values is returned.
     *
     *
     * @returns A single value or an array of values. Value `null` means that the node's own opacity should
     * be used.
     */
    getOpacity(
      /**
       * The node reference or the array of node references.
       */
      nodeRefs: any | any[]
    ): float | float[];
    /**
     * Gets the selection state of the node.
     *
     * If a single node reference is passed to the method then a single selection state is returned.
     *  If an array of node references is passed to the method then an array of selection states is returned.
     *
     *
     * @returns A single value or an array of values where the value is `true` if the node is selected, `false`
     * otherwise.
     */
    getSelectionState(
      /**
       * The node reference or the array of node references.
       */
      nodeRefs: any | any[]
    ): boolean | boolean[];
    /**
     * Gets the tint color of the node.
     *
     * If a single node reference is passed to the method then a single value is returned.
     *  If an array of node references is passed to the method then an array of values is returned.
     *
     *
     * @returns A single value or an array of values. Value `null` means that the node's own tint color should
     * be used.
     */
    getTintColor(
      /**
       * The node reference or the array of node references.
       */
      nodeRefs: any | any[],
      /**
       * This flag indicates to return the tint color in the ABGR format, if it equals `false` then the color
       * is returned in the CSS color format.
       */
      inABGRFormat?: boolean
    ): CSSColor | CSSColor[] | int | int[];
    /**
     * Gets the visibility changes in the current ViewStateManager object.
     *
     *
     * @returns The visibility changes are in the form of an array. The array is a list of node VE ids which
     * suffered a visibility changed relative to the default state.
     */
    getVisibilityChanges(): string[];
    /**
     * Gets the visibility state of nodes.
     *
     * If a single node reference is passed to the method then a single visibility state is returned.
     *  If an array of node references is passed to the method then an array of visibility states is returned.
     *
     *
     * @returns A single value or an array of values where the value is `true` if the node is visible, `false`
     * otherwise.
     */
    getVisibilityState(
      /**
       * The node reference or the array of node references.
       */
      nodeRefs: any | any[]
    ): boolean | boolean[];
    /**
     * Sets the opacity of the nodes.
     *
     *
     * @returns `this` to allow method chaining.
     */
    setOpacity(
      /**
       * The node reference or the array of node references.
       */
      nodeRefs: any | any[],
      /**
       * The new opacity of the nodes. If `null` is passed then the opacity is reset and the node's own opacity
       * should be used.
       */
      opacity: float | null,
      /**
       * The flags indicates if the change needs to propagate recursively to child nodes.
       */
      recursive?: boolean
    ): this;
    /**
     * Sets the selection state of the nodes.
     *
     * @deprecated As of version 1.56.3. Use {@link sap.ui.vk.dvl.ViewStateManager#setSelectionStates} instead.
     *
     * @returns `this` to allow method chaining.
     */
    setSelectionState(
      /**
       * The node reference or the array of node references.
       */
      nodeRefs: any | any[],
      /**
       * The new selection state of the nodes.
       */
      selected: boolean,
      /**
       * The flags indicates if the change needs to propagate recursively to child nodes.
       */
      recursive: boolean,
      /**
       * The flag to suppress selectionChanged event.
       */
      blockNotification: boolean
    ): this;
    /**
     * Sets or resets the selection state of the nodes.
     *
     *
     * @returns `this` to allow method chaining.
     */
    setSelectionStates(
      /**
       * The node reference or the array of node references of selected nodes.
       */
      selectedNodeRefs: any | any[],
      /**
       * The node reference or the array of node references of unselected nodes.
       */
      unselectedNodeRefs: any | any[],
      /**
       * The flags indicates if the change needs to propagate recursively to child nodes.
       */
      recursive: boolean,
      /**
       * The flag to suppress selectionChanged event.
       */
      blockNotification: boolean
    ): this;
    /**
     * Sets the tint color of the nodes.
     *
     *
     * @returns `this` to allow method chaining.
     */
    setTintColor(
      /**
       * The node reference or the array of node references.
       */
      nodeRefs: any | any[],
      /**
       * The new tint color of the nodes. The value can be defined as a string in the CSS color format or as an
       * integer in the ABGR format. If `null` is passed then the tint color is reset and the node's own tint
       * color should be used.
       */
      tintColor: CSSColor | int | null,
      /**
       * This flag indicates if the change needs to propagate recursively to child nodes.
       */
      recursive?: boolean
    ): this;
    /**
     * Sets the visibility state of the nodes.
     *
     *
     * @returns `this` to allow method chaining.
     */
    setVisibilityState(
      /**
       * The node reference or the array of node references.
       */
      nodeRefs: any | any[],
      /**
       * The new visibility state of the nodes.
       */
      visible: boolean,
      /**
       * The flags indicates if the change needs to propagate recursively to child nodes.
       */
      recursive: boolean,
      /**
       * If a node is made visible but its parent is hidden then it will still be hidden in Viewport. This flag
       * will force node to be visible regardless of parent's state.
       */
      force: boolean
    ): this;
  }
  /**
   * Describes the settings that can be provided to the ViewStateManager constructor.
   *
   * @deprecated As of version 1.72.0. DVL namespace will be removed in future. Use {@link sap.ui.vk.ViewStateManager }
   * instead.
   */
  export interface $ViewStateManagerSettings
    extends $ViewStateManagerBaseSettings {}
}

declare module "sap/ui/vk/ecad/LayersPanel" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import Event from "sap/ui/base/Event";

  import { ID, CSSSize } from "sap/ui/core/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import ContentConnector from "sap/ui/vk/ContentConnector";

  import ViewStateManagerBase from "sap/ui/vk/ViewStateManagerBase";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Provides a flat list view of all the ECAD layers in a given scene in table format.
   *
   * @since 1.136.0
   */
  export default class LayersPanel extends Control {
    /**
     * Constructor for a new LayersPanel.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $LayersPanelSettings
    );
    /**
     * Constructor for a new LayersPanel.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $LayersPanelSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vk.ecad.LayersPanel with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, LayersPanel>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.ecad.LayersPanel.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:contentChanged contentChanged} event of this
     * `sap.ui.vk.ecad.LayersPanel`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.ecad.LayersPanel` itself.
     *
     * This event will be fired when content is replaced.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachContentChanged(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.ecad.LayersPanel` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:contentChanged contentChanged} event of this
     * `sap.ui.vk.ecad.LayersPanel`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.ecad.LayersPanel` itself.
     *
     * This event will be fired when content is replaced.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachContentChanged(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.ecad.LayersPanel` itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys the content in the aggregation {@link #getContent content}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyContent(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:contentChanged contentChanged} event of this
     * `sap.ui.vk.ecad.LayersPanel`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachContentChanged(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:contentChanged contentChanged} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireContentChanged(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets content of aggregation {@link #getContent content}.
     */
    getContent(): Control;
    /**
     * ID of the element which is the current target of the association {@link #getContentConnector contentConnector},
     * or `null`.
     */
    getContentConnector(): ID | null;
    /**
     * Gets current value of property {@link #getHeight height}.
     *
     * Default value is `"100%"`.
     *
     *
     * @returns Value of property `height`
     */
    getHeight(): CSSSize;
    /**
     * ID of the element which is the current target of the association {@link #getViewStateManager viewStateManager},
     * or `null`.
     */
    getViewStateManager(): ID | null;
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * Default value is `"auto"`.
     *
     *
     * @returns Value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * Sets the aggregated {@link #getContent content}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setContent(
      /**
       * The content to set
       */
      oContent: Control
    ): this;
    /**
     * Sets the associated {@link #getContentConnector contentConnector}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setContentConnector(
      /**
       * ID of an element which becomes the new target of this contentConnector association; alternatively, an
       * element instance may be given
       */
      oContentConnector: ID | ContentConnector
    ): this;
    /**
     * Sets a new value for property {@link #getHeight height}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"100%"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHeight(
      /**
       * New value for property `height`
       */
      sHeight?: CSSSize
    ): this;
    /**
     * Sets the associated {@link #getViewStateManager viewStateManager}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setViewStateManager(
      /**
       * ID of an element which becomes the new target of this viewStateManager association; alternatively, an
       * element instance may be given
       */
      oViewStateManager: ID | ViewStateManagerBase
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"auto"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      sWidth?: CSSSize
    ): this;
  }
  /**
   * Describes the settings that can be provided to the LayersPanel constructor.
   */
  export interface $LayersPanelSettings extends $ControlSettings {
    width?: CSSSize | PropertyBindingInfo | `{${string}}`;

    height?: CSSSize | PropertyBindingInfo | `{${string}}`;

    content?: Control;

    /**
     * An association to the `ContentConnector` instance that manages content resources.
     */
    contentConnector?: ContentConnector | string;

    /**
     * An association to the `ViewStateManager` instance.
     */
    viewStateManager?: ViewStateManagerBase | string;

    /**
     * This event will be fired when content is replaced.
     */
    contentChanged?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the LayersPanel#contentChanged event.
   */
  export interface LayersPanel$ContentChangedEventParameters {}

  /**
   * Event object of the LayersPanel#contentChanged event.
   */
  export type LayersPanel$ContentChangedEvent = Event<
    LayersPanel$ContentChangedEventParameters,
    LayersPanel
  >;
}

declare module "sap/ui/vk/FlexibleControl" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import { CSSSize } from "sap/ui/core/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  /**
   * Holds layout data for the FlexibleControl contents.
   *
   * @since 1.16.0
   * @experimental As of version 1.32.0. This class is experimental and might be modified or removed in future
   * versions.
   */
  export default class FlexibleControl extends Control {
    /**
     * Constructor for a new FlexibleControl.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $FlexibleControlSettings
    );
    /**
     * Constructor for a new FlexibleControl.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $FlexibleControlSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vk.FlexibleControl with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, FlexibleControl>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.FlexibleControl.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some content to the aggregation {@link #getContent content}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addContent(
      /**
       * The content to add; if empty, nothing is inserted
       */
      oContent: Control
    ): this;
    /**
     * Destroys all the content in the aggregation {@link #getContent content}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyContent(): this;
    /**
     * Gets content of aggregation {@link #getContent content}.
     *
     * Child Controls within the layout.
     */
    getContent(): Control[];
    /**
     * Gets current value of property {@link #getEnabled enabled}.
     *
     * If not enabled all controls inside are not enabled automatically.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `enabled`
     */
    getEnabled(): boolean;
    /**
     * Gets current value of property {@link #getHeight height}.
     *
     *
     * @returns Value of property `height`
     */
    getHeight(): CSSSize;
    /**
     * Gets current value of property {@link #getLayout layout}.
     *
     * Default value is `"Stacked"`.
     *
     *
     * @returns Value of property `layout`
     */
    getLayout(): string;
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * CSS width of the vertical layout.
     *
     *
     * @returns Value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * Checks for the provided `sap.ui.core.Control` in the aggregation {@link #getContent content}. and returns
     * its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfContent(
      /**
       * The content whose index is looked for
       */
      oContent: Control
    ): int;
    /**
     * Inserts a content into the aggregation {@link #getContent content}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertContent(
      /**
       * The content to insert; if empty, nothing is inserted
       */
      oContent: Control,
      /**
       * The `0`-based index the content should be inserted at; for a negative value of `iIndex`, the content
       * is inserted at position 0; for a value greater than the current size of the aggregation, the content
       * is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getContent content}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllContent(): Control[];
    /**
     * Removes a content from the aggregation {@link #getContent content}.
     *
     *
     * @returns The removed content or `null`
     */
    removeContent(
      /**
       * The content to remove or its index or id
       */
      vContent: int | string | Control
    ): Control | null;
    /**
     * Sets a new value for property {@link #getEnabled enabled}.
     *
     * If not enabled all controls inside are not enabled automatically.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnabled(
      /**
       * New value for property `enabled`
       */
      bEnabled?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getHeight height}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHeight(
      /**
       * New value for property `height`
       */
      sHeight?: CSSSize
    ): this;
    /**
     * Sets a new value for property {@link #getLayout layout}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"Stacked"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLayout(
      /**
       * New value for property `layout`
       */
      sLayout?: string
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * CSS width of the vertical layout.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      sWidth?: CSSSize
    ): this;
  }
  /**
   * Describes the settings that can be provided to the FlexibleControl constructor.
   *
   * @experimental As of version 1.32.0. This class is experimental and might be modified or removed in future
   * versions.
   */
  export interface $FlexibleControlSettings extends $ControlSettings {
    /**
     * CSS width of the vertical layout.
     */
    width?: CSSSize | PropertyBindingInfo | `{${string}}`;

    height?: CSSSize | PropertyBindingInfo | `{${string}}`;

    layout?: string | PropertyBindingInfo;

    /**
     * If not enabled all controls inside are not enabled automatically.
     */
    enabled?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Child Controls within the layout.
     */
    content?: Control[] | Control | AggregationBindingInfo | `{${string}}`;
  }
}

declare module "sap/ui/vk/FlexibleControlLayoutData" {
  import {
    default as LayoutData,
    $LayoutDataSettings,
  } from "sap/ui/core/LayoutData";

  import { CSSSize } from "sap/ui/core/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Holds layout data for the FlexibleControl contents. Allowed size values are numeric values ending in
   * "px" and "%" and the special case "auto". (The CSS value "auto" is used internally to recalculate the
   * size of the content dynamically and is not directly set as style property.)
   *
   * @since 1.32.0
   * @experimental As of version 1.32.0. This class is experimental and might be modified or removed in future
   * versions.
   */
  export default class FlexibleControlLayoutData extends LayoutData {
    /**
     * Constructor for a new FlexibleControlLayoutData.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $FlexibleControlLayoutDataSettings
    );
    /**
     * Constructor for a new FlexibleControlLayoutData.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $FlexibleControlLayoutDataSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vk.FlexibleControlLayoutData with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.LayoutData.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, FlexibleControlLayoutData>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.FlexibleControlLayoutData.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getMarginBottom marginBottom}.
     *
     * Default value is `"0px"`.
     *
     *
     * @returns Value of property `marginBottom`
     */
    getMarginBottom(): CSSSize;
    /**
     * Gets current value of property {@link #getMarginTop marginTop}.
     *
     * Sets the margin-bottom of the content in px.
     *
     * Default value is `"0px"`.
     *
     *
     * @returns Value of property `marginTop`
     */
    getMarginTop(): CSSSize;
    /**
     * Gets current value of property {@link #getMinSize minSize}.
     *
     * Sets the minimum size of the content in px.
     *
     * Default value is `"0px"`.
     *
     *
     * @returns Value of property `minSize`
     */
    getMinSize(): CSSSize;
    /**
     * Gets current value of property {@link #getSize size}.
     *
     * Sets the size of the content.
     *
     * Default value is `"auto"`.
     *
     *
     * @returns Value of property `size`
     */
    getSize(): CSSSize;
    /**
     * Sets a new value for property {@link #getMarginBottom marginBottom}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"0px"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMarginBottom(
      /**
       * New value for property `marginBottom`
       */
      sMarginBottom?: CSSSize
    ): this;
    /**
     * Sets a new value for property {@link #getMarginTop marginTop}.
     *
     * Sets the margin-bottom of the content in px.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"0px"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMarginTop(
      /**
       * New value for property `marginTop`
       */
      sMarginTop?: CSSSize
    ): this;
    /**
     * Sets a new value for property {@link #getMinSize minSize}.
     *
     * Sets the minimum size of the content in px.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"0px"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMinSize(
      /**
       * New value for property `minSize`
       */
      sMinSize?: CSSSize
    ): this;
    /**
     * Sets a new value for property {@link #getSize size}.
     *
     * Sets the size of the content.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"auto"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSize(
      /**
       * New value for property `size`
       */
      sSize?: CSSSize
    ): this;
  }
  /**
   * Describes the settings that can be provided to the FlexibleControlLayoutData constructor.
   *
   * @experimental As of version 1.32.0. This class is experimental and might be modified or removed in future
   * versions.
   */
  export interface $FlexibleControlLayoutDataSettings
    extends $LayoutDataSettings {
    /**
     * Sets the size of the content.
     */
    size?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Sets the minimum size of the content in px.
     */
    minSize?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Sets the margin-bottom of the content in px.
     */
    marginTop?: CSSSize | PropertyBindingInfo | `{${string}}`;

    marginBottom?: CSSSize | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/ui/vk/ImageContentManager" {
  import {
    default as ContentManager,
    $ContentManagerSettings,
  } from "sap/ui/vk/ContentManager";

  import ManagedObjectMetadata from "sap/ui/base/ManagedObjectMetadata";

  /**
   * Provides a loader that loads a 2D raster or vector image into an HTMLImageElement or HTMLObjectElement
   * object.
   *
   * @since 1.50.0
   */
  export default class ImageContentManager extends ContentManager {
    /**
     * Constructor for a new ImageContentManager.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     *
     * This class does not have its own settings, but all settings applicable to the base type {@link sap.ui.vk.ContentManager#constructor sap.ui.vk.ContentManager }
     * can be used.
     */
    constructor(
      /**
       * Initial settings for the new ImageContentManager object.
       */
      mSettings?: $ImageContentManagerSettings
    );
    /**
     * Constructor for a new ImageContentManager.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     *
     * This class does not have its own settings, but all settings applicable to the base type {@link sap.ui.vk.ContentManager#constructor sap.ui.vk.ContentManager }
     * can be used.
     */
    constructor(
      /**
       * ID for the new ImageContentManager object. Generated automatically if no ID is given.
       */
      sId?: string,
      /**
       * Initial settings for the new ImageContentManager object.
       */
      mSettings?: $ImageContentManagerSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vk.ImageContentManager with name `sClassName` and enriches it
     * with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.vk.ContentManager.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ImageContentManager>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.ImageContentManager.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ManagedObjectMetadata;
  }
  /**
   * Describes the settings that can be provided to the ImageContentManager constructor.
   */
  export interface $ImageContentManagerSettings
    extends $ContentManagerSettings {}
}

declare module "sap/ui/vk/IncludeUsageIdType" {
  /**
   * This type defines possible valid values for property {@link sap.ui.vk.ContentResource#getIncludeUsageId ContentResource.includeUsageId}.
   *
   * The possible valid values:
   * 	`true` - Load all UsageIds. This is potentially very expensive, as there could be many UsageIds defined
   * for the tenant which are not relevant to the current application. `false` - Do not load any UsageIds.
   * `string` - A single non-empty string which defines the name of the requested UsageId. `string[]`
   * - An array of non-empty strings which define the names of requested UsageIds.
   *
   * @since 1.96.0
   */
  interface IncludeUsageIdType {}
  const IncludeUsageIdType: IncludeUsageIdType;
  export default IncludeUsageIdType;
}

declare module "sap/ui/vk/LayerProxy" {
  import BaseObject from "sap/ui/base/Object";

  import Metadata from "sap/ui/base/Metadata";

  /**
   * Provides a proxy object to the layer in the node hierarchy.
   *
   * Layer is a list of nodes. One node hierarchy can have multiple layers. One node can be included in multiple
   * layers.
   *
   * Objects of this type should only be created with the {@link sap.ui.vk.NodeHierarchy#createLayerProxy sap.ui.vk.NodeHierarchy.createLayerProxy }
   * method and destroyed with the {@link sap.ui.vk.NodeHierarchy#destroyLayerProxy sap.ui.vk.NodeHierarchy.destroyLayerProxy }
   * method.
   */
  export default abstract class LayerProxy extends BaseObject {
    /**
     * Constructor for a new LayerProxy.
     *
     * Objects of this type should only be created with the {@link sap.ui.vk.NodeHierarchy#createLayerProxy sap.ui.vk.NodeHierarchy.createLayerProxy }
     * method and destroyed with the {@link sap.ui.vk.NodeHierarchy#destroyLayerProxy sap.ui.vk.NodeHierarchy.destroyLayerProxy }
     * method.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     *
     * This class does not have its own settings, but all settings applicable to the base type {@link sap.ui.base.Object#constructor sap.ui.base.Object }
     * can be used.
     */
    constructor();

    /**
     * Creates a new subclass of class sap.ui.vk.LayerProxy with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.base.Object.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, LayerProxy>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.LayerProxy.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): Metadata;
    /**
     * Gets the description of the layer.
     *
     *
     * @returns The description of the layer.
     */
    getDescription(): string;
    /**
     * Gets the layer ID.
     *
     *
     * @returns The layer ID.
     */
    getLayerId(): string;
    /**
     * Gets the layer metadata.
     *
     *
     * @returns The layer metadata.
     */
    getLayerMetadata(): object;
    /**
     * Gets the name of the layer
     *
     *
     * @returns The name of the layer.
     */
    getName(): string;
    /**
     * Gets an array of IDs of nodes belonging to the layer.
     *
     *
     * @returns An array of IDs of nodes belonging to the layer.
     */
    getNodes(): string[];
    /**
     * Gets the layer VE IDs.
     *
     *
     * @returns The layer VE IDs.
     */
    getVeIds(): object[];
  }
}

declare module "sap/ui/vk/LegendItem" {
  import {
    default as StandardListItem,
    $StandardListItemSettings,
  } from "sap/m/StandardListItem";

  import { CSSColor } from "sap/ui/core/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { SemanticType } from "sap/ui/vbm/library";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Legend item control
   *
   * @deprecated As of version 1.120.2. This object is moved to sap.ui.vbm namespace, see {@link sap.ui.vbm.ContainerLegendItem}
   * @experimental As of version 1.38.0. This class is experimental and might be modified or removed in future
   * versions.
   */
  export default class LegendItem extends StandardListItem {
    /**
     * Constructor for a new LegendItem.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $LegendItemSettings
    );
    /**
     * Constructor for a new LegendItem.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $LegendItemSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vk.LegendItem with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.m.StandardListItem.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, LegendItem>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.LegendItem.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getColor color}.
     *
     * show color square
     *
     *
     * @returns Value of property `color`
     */
    getColor(): CSSColor;
    /**
     * Gets current value of property {@link #getSemanticSpotType semanticSpotType}.
     *
     * The semantic spot type for the legend marker.
     *
     *
     * @returns Value of property `semanticSpotType`
     */
    getSemanticSpotType(): SemanticType;
    /**
     * Sets a new value for property {@link #getColor color}.
     *
     * show color square
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setColor(
      /**
       * New value for property `color`
       */
      sColor?: CSSColor
    ): this;
    /**
     * Sets a new value for property {@link #getSemanticSpotType semanticSpotType}.
     *
     * The semantic spot type for the legend marker.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSemanticSpotType(
      /**
       * New value for property `semanticSpotType`
       */
      sSemanticSpotType?: SemanticType | keyof typeof SemanticType
    ): this;
  }
  /**
   * Describes the settings that can be provided to the LegendItem constructor.
   *
   * @deprecated As of version 1.120.2. This object is moved to sap.ui.vbm namespace, see {@link sap.ui.vbm.ContainerLegendItem}
   * @experimental As of version 1.38.0. This class is experimental and might be modified or removed in future
   * versions.
   */
  export interface $LegendItemSettings extends $StandardListItemSettings {
    /**
     * show color square
     */
    color?: CSSColor | PropertyBindingInfo | `{${string}}`;

    /**
     * The semantic spot type for the legend marker.
     */
    semanticSpotType?:
      | (SemanticType | keyof typeof SemanticType)
      | PropertyBindingInfo
      | `{${string}}`;
  }
}

declare module "sap/ui/vk/ListPanel" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import ListItemBase from "sap/m/ListItemBase";

  import Event from "sap/ui/base/Event";

  import { URI } from "sap/ui/core/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { ListMode } from "sap/m/library";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  /**
   * Aggregation control for the Legend
   *
   * @deprecated As of version 1.120.2. This object is moved to sap.ui.vbm namespace, see {@link sap.ui.vbm.ListPanel}
   * @experimental As of version 1.38.0. This class is experimental and might be modified or removed in future
   * versions.
   */
  export default class ListPanel extends Control {
    /**
     * Constructor for a new ListPanel.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $ListPanelSettings
    );
    /**
     * Constructor for a new ListPanel.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $ListPanelSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vk.ListPanel with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ListPanel>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.ListPanel.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some item to the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addItem(
      /**
       * The item to add; if empty, nothing is inserted
       */
      oItem: ListItemBase
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:expand expand} event of this `sap.ui.vk.ListPanel`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.ListPanel` itself.
     *
     * Event is fired if the panel is expanded of collapsed
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachExpand(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.ListPanel` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:expand expand} event of this `sap.ui.vk.ListPanel`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.ListPanel` itself.
     *
     * Event is fired if the panel is expanded of collapsed
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachExpand(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.ListPanel` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:headerIconPress headerIconPress} event of this
     * `sap.ui.vk.ListPanel`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.ListPanel` itself.
     *
     * Event is fired if the header icon is pressed
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachHeaderIconPress(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.ListPanel` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:headerIconPress headerIconPress} event of this
     * `sap.ui.vk.ListPanel`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.ListPanel` itself.
     *
     * Event is fired if the header icon is pressed
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachHeaderIconPress(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.ListPanel` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:itemPress itemPress} event of this `sap.ui.vk.ListPanel`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.ListPanel` itself.
     *
     * Event is fired when an item is pressed unless the item's `type` property is `Inactive`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachItemPress(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ListPanel$ItemPressEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.ListPanel` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:itemPress itemPress} event of this `sap.ui.vk.ListPanel`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.ListPanel` itself.
     *
     * Event is fired when an item is pressed unless the item's `type` property is `Inactive`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachItemPress(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ListPanel$ItemPressEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.ListPanel` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:selectionChange selectionChange} event of this
     * `sap.ui.vk.ListPanel`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.ListPanel` itself.
     *
     * Event is fired when selection is changed via user interaction inside the control.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelectionChange(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ListPanel$SelectionChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.ListPanel` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:selectionChange selectionChange} event of this
     * `sap.ui.vk.ListPanel`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.ListPanel` itself.
     *
     * Event is fired when selection is changed via user interaction inside the control.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelectionChange(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ListPanel$SelectionChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.ListPanel` itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys all the items in the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyItems(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:expand expand} event of this `sap.ui.vk.ListPanel`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachExpand(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:headerIconPress headerIconPress} event of
     * this `sap.ui.vk.ListPanel`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachHeaderIconPress(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:itemPress itemPress} event of this `sap.ui.vk.ListPanel`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachItemPress(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: ListPanel$ItemPressEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:selectionChange selectionChange} event of
     * this `sap.ui.vk.ListPanel`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachSelectionChange(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: ListPanel$SelectionChangeEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:expand expand} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireExpand(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:headerIconPress headerIconPress} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireHeaderIconPress(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:itemPress itemPress} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireItemPress(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: ListPanel$ItemPressEventParameters
    ): this;
    /**
     * Fires event {@link #event:selectionChange selectionChange} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireSelectionChange(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: ListPanel$SelectionChangeEventParameters
    ): this;
    /**
     * Gets current value of property {@link #getExpandAnimation expandAnimation}.
     *
     * Expand animation
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `expandAnimation`
     */
    getExpandAnimation(): boolean;
    /**
     * Gets current value of property {@link #getExpanded expanded}.
     *
     * Expansion state
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `expanded`
     */
    getExpanded(): boolean;
    /**
     * Gets current value of property {@link #getHeaderIcon headerIcon}.
     *
     * Header icon
     *
     *
     * @returns Value of property `headerIcon`
     */
    getHeaderIcon(): URI;
    /**
     * Gets current value of property {@link #getHeaderText headerText}.
     *
     * Header text
     *
     *
     * @returns Value of property `headerText`
     */
    getHeaderText(): string;
    /**
     * Gets content of aggregation {@link #getItems items}.
     *
     * Item aggregation
     */
    getItems(): ListItemBase[];
    /**
     * Returns selected list item. When no item is selected, "null" is returned. When "multi-selection" is enabled
     * and multiple items are selected, only the up-most selected item is returned.
     *
     *
     * @returns Selected item.
     */
    getSelectedItem(): ListItemBase;
    /**
     * Returns an array containing the selected list items. If no items are selected, an empty array is returned.
     *
     *
     * @returns Selected items
     */
    getSelectedItems(): ListItemBase[];
    /**
     * Gets current value of property {@link #getSelectionMode selectionMode}.
     *
     * Selection Mode
     *
     * Default value is `MultiSelect`.
     *
     *
     * @returns Value of property `selectionMode`
     */
    getSelectionMode(): ListMode;
    /**
     * Checks for the provided `sap.m.ListItemBase` in the aggregation {@link #getItems items}. and returns
     * its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfItem(
      /**
       * The item whose index is looked for
       */
      oItem: ListItemBase
    ): int;
    /**
     * Inserts a item into the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertItem(
      /**
       * The item to insert; if empty, nothing is inserted
       */
      oItem: ListItemBase,
      /**
       * The `0`-based index the item should be inserted at; for a negative value of `iIndex`, the item is inserted
       * at position 0; for a value greater than the current size of the aggregation, the item is inserted at
       * the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getItems items}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllItems(): ListItemBase[];
    /**
     * Removes a item from the aggregation {@link #getItems items}.
     *
     *
     * @returns The removed item or `null`
     */
    removeItem(
      /**
       * The item to remove or its index or id
       */
      vItem: int | string | ListItemBase
    ): ListItemBase | null;
    /**
     * Sets a new value for property {@link #getExpandAnimation expandAnimation}.
     *
     * Expand animation
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setExpandAnimation(
      /**
       * New value for property `expandAnimation`
       */
      bExpandAnimation?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getExpanded expanded}.
     *
     * Expansion state
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setExpanded(
      /**
       * New value for property `expanded`
       */
      bExpanded?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getHeaderIcon headerIcon}.
     *
     * Header icon
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHeaderIcon(
      /**
       * New value for property `headerIcon`
       */
      sHeaderIcon: URI
    ): this;
    /**
     * Sets a new value for property {@link #getHeaderText headerText}.
     *
     * Header text
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHeaderText(
      /**
       * New value for property `headerText`
       */
      sHeaderText: string
    ): this;
    /**
     * Selects or deselects the given list item.
     */
    setSelectedItem(
      /**
       * The list item whose selection to be changed. This parameter is mandatory.
       */
      oListItem: ListItemBase,
      /**
       * Sets selected status of the list item. Default value is true.
       */
      bSelect: boolean,
      /**
       * Whether to fire the event or not.
       */
      bFireEvent: boolean
    ): void;
    /**
     * Sets a new value for property {@link #getSelectionMode selectionMode}.
     *
     * Selection Mode
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `MultiSelect`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSelectionMode(
      /**
       * New value for property `selectionMode`
       */
      sSelectionMode?: ListMode | keyof typeof ListMode
    ): this;
  }
  /**
   * Describes the settings that can be provided to the ListPanel constructor.
   *
   * @deprecated As of version 1.120.2. This object is moved to sap.ui.vbm namespace, see {@link sap.ui.vbm.ListPanel}
   * @experimental As of version 1.38.0. This class is experimental and might be modified or removed in future
   * versions.
   */
  export interface $ListPanelSettings extends $ControlSettings {
    /**
     * Header text
     */
    headerText?: string | PropertyBindingInfo;

    /**
     * Header icon
     */
    headerIcon?: URI | PropertyBindingInfo | `{${string}}`;

    /**
     * Expansion state
     */
    expanded?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Expand animation
     */
    expandAnimation?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Selection Mode
     */
    selectionMode?:
      | (ListMode | keyof typeof ListMode)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Item aggregation
     */
    items?:
      | ListItemBase[]
      | ListItemBase
      | AggregationBindingInfo
      | `{${string}}`;

    /**
     * Event is fired if the header icon is pressed
     */
    headerIconPress?: (oEvent: Event) => void;

    /**
     * Event is fired if the panel is expanded of collapsed
     */
    expand?: (oEvent: Event) => void;

    /**
     * Event is fired when selection is changed via user interaction inside the control.
     */
    selectionChange?: (oEvent: ListPanel$SelectionChangeEvent) => void;

    /**
     * Event is fired when an item is pressed unless the item's `type` property is `Inactive`.
     */
    itemPress?: (oEvent: ListPanel$ItemPressEvent) => void;
  }

  /**
   * Parameters of the ListPanel#expand event.
   */
  export interface ListPanel$ExpandEventParameters {}

  /**
   * Event object of the ListPanel#expand event.
   */
  export type ListPanel$ExpandEvent = Event<
    ListPanel$ExpandEventParameters,
    ListPanel
  >;

  /**
   * Parameters of the ListPanel#headerIconPress event.
   */
  export interface ListPanel$HeaderIconPressEventParameters {}

  /**
   * Event object of the ListPanel#headerIconPress event.
   */
  export type ListPanel$HeaderIconPressEvent = Event<
    ListPanel$HeaderIconPressEventParameters,
    ListPanel
  >;

  /**
   * Parameters of the ListPanel#itemPress event.
   */
  export interface ListPanel$ItemPressEventParameters {
    /**
     * The item which fired the pressed event.
     */
    listItem?: ListItemBase;

    /**
     * The control which caused the press event within the container.
     */
    srcControl?: Control;
  }

  /**
   * Event object of the ListPanel#itemPress event.
   */
  export type ListPanel$ItemPressEvent = Event<
    ListPanel$ItemPressEventParameters,
    ListPanel
  >;

  /**
   * Parameters of the ListPanel#selectionChange event.
   */
  export interface ListPanel$SelectionChangeEventParameters {
    /**
     * The item whose selection has changed. In `MultiSelect` mode, only the up-most selected item is returned.
     * This parameter can be used for single-selection modes.
     */
    listItem?: ListItemBase;

    /**
     * Array of items whose selection has changed. This parameter can be used for `MultiSelect` mode.
     */
    listItems?: ListItemBase[];

    /**
     * Indicates whether the `listItem` parameter is selected or not.
     */
    selected?: boolean;
  }

  /**
   * Event object of the ListPanel#selectionChange event.
   */
  export type ListPanel$SelectionChangeEvent = Event<
    ListPanel$SelectionChangeEventParameters,
    ListPanel
  >;
}

declare module "sap/ui/vk/ListPanelStack" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import ListPanel from "sap/ui/vk/ListPanel";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { CSSSize } from "sap/ui/core/library";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  /**
   * ListPanelStack control
   *
   * @deprecated As of version 1.120.2. This object is moved to sap.ui.vbm namespace, see {@link sap.ui.vbm.ListPanelStack}
   * @experimental As of version 1.38.0. This class is experimental and might be modified or removed in future
   * versions.
   */
  export default class ListPanelStack extends Control {
    /**
     * Constructor for a new ListPanelStack.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $ListPanelStackSettings
    );
    /**
     * Constructor for a new ListPanelStack.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $ListPanelStackSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vk.ListPanelStack with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ListPanelStack>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.ListPanelStack.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some content to the aggregation {@link #getContent content}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addContent(
      /**
       * The content to add; if empty, nothing is inserted
       */
      oContent: ListPanel
    ): this;
    /**
     * Destroys all the content in the aggregation {@link #getContent content}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyContent(): this;
    /**
     * Gets current value of property {@link #getCollapsible collapsible}.
     *
     * Ability to collapse
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `collapsible`
     */
    getCollapsible(): boolean;
    /**
     * Gets content of aggregation {@link #getContent content}.
     */
    getContent(): ListPanel[];
    /**
     * Gets current value of property {@link #getExpandAnimation expandAnimation}.
     *
     * Expand animation
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `expandAnimation`
     */
    getExpandAnimation(): boolean;
    /**
     * Gets current value of property {@link #getExpanded expanded}.
     *
     * Expansion state
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `expanded`
     */
    getExpanded(): boolean;
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * Control width
     *
     * Default value is `"100%"`.
     *
     *
     * @returns Value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * Checks for the provided `sap.ui.vk.ListPanel` in the aggregation {@link #getContent content}. and returns
     * its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfContent(
      /**
       * The content whose index is looked for
       */
      oContent: ListPanel
    ): int;
    /**
     * Inserts a content into the aggregation {@link #getContent content}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertContent(
      /**
       * The content to insert; if empty, nothing is inserted
       */
      oContent: ListPanel,
      /**
       * The `0`-based index the content should be inserted at; for a negative value of `iIndex`, the content
       * is inserted at position 0; for a value greater than the current size of the aggregation, the content
       * is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getContent content}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllContent(): ListPanel[];
    /**
     * Removes a content from the aggregation {@link #getContent content}.
     *
     *
     * @returns The removed content or `null`
     */
    removeContent(
      /**
       * The content to remove or its index or id
       */
      vContent: int | string | ListPanel
    ): ListPanel | null;
    /**
     * Sets a new value for property {@link #getCollapsible collapsible}.
     *
     * Ability to collapse
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCollapsible(
      /**
       * New value for property `collapsible`
       */
      bCollapsible?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getExpandAnimation expandAnimation}.
     *
     * Expand animation
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setExpandAnimation(
      /**
       * New value for property `expandAnimation`
       */
      bExpandAnimation?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getExpanded expanded}.
     *
     * Expansion state
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setExpanded(
      /**
       * New value for property `expanded`
       */
      bExpanded?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * Control width
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"100%"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      sWidth?: CSSSize
    ): this;
  }
  /**
   * Describes the settings that can be provided to the ListPanelStack constructor.
   *
   * @deprecated As of version 1.120.2. This object is moved to sap.ui.vbm namespace, see {@link sap.ui.vbm.ListPanelStack}
   * @experimental As of version 1.38.0. This class is experimental and might be modified or removed in future
   * versions.
   */
  export interface $ListPanelStackSettings extends $ControlSettings {
    /**
     * Control width
     */
    width?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Expansion state
     */
    expanded?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Expand animation
     */
    expandAnimation?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Ability to collapse
     */
    collapsible?: boolean | PropertyBindingInfo | `{${string}}`;

    content?: ListPanel[] | ListPanel | AggregationBindingInfo | `{${string}}`;
  }
}

declare module "sap/ui/vk/Loco" {
  import Viewport from "sap/ui/vk/Viewport";

  import Metadata from "sap/ui/base/Metadata";

  /**
   * Loco is a utility class that provides a set of methods to handle input events for UI5 controls.
   *
   * @since 1.32.0
   */
  export default class Loco extends /* was: sap.ui.base.BaseObject */ Object {
    /**
     * Constructor for a new Loco instance.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     *
     * This class does not have its own settings, but all settings applicable to the base type {@link sap.ui.base.BaseObject#constructor sap.ui.base.BaseObject }
     * can be used.
     */
    constructor(
      /**
       * The viewport to attach the event handlers to.
       */
      viewport?: Viewport
    );

    /**
     * Creates a new subclass of class sap.ui.vk.Loco with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.base.BaseObject.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Loco>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.Loco.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): Metadata;
    /**
     * Adds a viewport event handler to the Loco.
     *
     * Handlers with higher priority are called first.
     *
     * If the viewport already has the event handler attached, the handler is not added again, but its priority
     * is updated and the handler is moved to the correct position in the list of handlers.
     *
     *
     * @returns Reference to `this` in order to allow method chaining.
     */
    addHandler(
      /**
       * The event handler to be added.
       */
      handler: object,
      /**
       * The priority of the handler.
       */
      priority: number
    ): this;
    /**
     * Cleans up, removes all handlers.
     */
    destroy(): void;
    /**
     * Removes a viewport event handler from Loco.
     *
     *
     * @returns Reference to `this` in order to allow method chaining.
     */
    removeHandler(
      /**
       * The event handler to be removed.
       */
      handler: object
    ): this;
  }
}

declare module "sap/ui/vk/MapContainer" {
  import {
    default as ContainerBase,
    $ContainerBaseSettings,
  } from "sap/ui/vk/ContainerBase";

  import ListPanelStack from "sap/ui/vk/ListPanelStack";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { URI } from "sap/ui/core/library";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Abstract Constructor for a new Container.
   *
   * @deprecated As of version 1.120.2. This object is moved to sap.ui.vbm namespace, see {@link sap.ui.vbm.MapContainer}
   */
  export default class MapContainer extends ContainerBase {
    /**
     * Constructor for a new MapContainer.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $MapContainerSettings
    );
    /**
     * Constructor for a new MapContainer.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $MapContainerSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vk.MapContainer with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.vk.ContainerBase.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, MapContainer>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.MapContainer.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Destroys the listPanelStack in the aggregation {@link #getListPanelStack listPanelStack}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyListPanelStack(): this;
    /**
     * Gets content of aggregation {@link #getListPanelStack listPanelStack}.
     *
     * List Panel aggregation
     */
    getListPanelStack(): ListPanelStack;
    /**
     * Gets current value of property {@link #getShowHome showHome}.
     *
     * Controls the visibility of the home button
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `showHome`
     */
    getShowHome(): boolean;
    /**
     * Gets current value of property {@link #getShowMapLayer showMapLayer}.
     *
     * Controls the visibility of the Map Layer Select
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `showMapLayer`
     */
    getShowMapLayer(): boolean;
    /**
     * Gets current value of property {@link #getShowNavbar showNavbar}.
     *
     * Show navbar
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `showNavbar`
     */
    getShowNavbar(): boolean;
    /**
     * Gets current value of property {@link #getShowRectangularZoom showRectangularZoom}.
     *
     * Controls the visibility of the rectangular zoom button
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `showRectangularZoom`
     */
    getShowRectangularZoom(): boolean;
    /**
     * Gets current value of property {@link #getShowZoom showZoom}.
     *
     * Controls the visibility of the zoom buttons
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `showZoom`
     */
    getShowZoom(): boolean;
    /**
     * Sets the aggregated {@link #getListPanelStack listPanelStack}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setListPanelStack(
      /**
       * The listPanelStack to set
       */
      oListPanelStack: ListPanelStack
    ): this;
    /**
     * Sets a new value for property {@link #getShowHome showHome}.
     *
     * Controls the visibility of the home button
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowHome(
      /**
       * New value for property `showHome`
       */
      bShowHome?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowMapLayer showMapLayer}.
     *
     * Controls the visibility of the Map Layer Select
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowMapLayer(
      /**
       * New value for property `showMapLayer`
       */
      bShowMapLayer?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowNavbar showNavbar}.
     *
     * Show navbar
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowNavbar(
      /**
       * New value for property `showNavbar`
       */
      bShowNavbar?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowRectangularZoom showRectangularZoom}.
     *
     * Controls the visibility of the rectangular zoom button
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowRectangularZoom(
      /**
       * New value for property `showRectangularZoom`
       */
      bShowRectangularZoom?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowZoom showZoom}.
     *
     * Controls the visibility of the zoom buttons
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowZoom(
      /**
       * New value for property `showZoom`
       */
      bShowZoom?: boolean
    ): this;
    /**
     * Set custom item on the MapContainer toolbar. All custom items added between selection segment button
     * and setting button.
     *
     *
     * @returns Item configuration object
     */
    setToolbarItem(
      /**
       * Item configuration object.
       */
      item: {
        /**
         * Id of the item for future references.
         */
        id: string;
        /**
         * Relative index of an item across all custom items.
         */
        index: int;
        /**
         * Visibility of an item.
         */
        visible: boolean;
        /**
         * Active item or not.
         */
        active: boolean;
        /**
         * Text of an item.
         */
        text: string;
        /**
         * Tooltip of an item.
         */
        tooltip: string;
        /**
         * If true create Overflow button or standard if false.
         */
        overflow: boolean;
        /**
         * Icon of an item.
         */
        icon: URI;
        /**
         * Alternative icon of an item, see {@link sap.m.Button} for details.
         */
        activeIcon: URI;
        /**
         * The {@link sap.ui.vk.MapContainerButtonType} enum.
         */
        type: string;
        /**
         * Callback function which is called when item gets pressed.
         */
        press: Function;
        /**
         * sets the initial pressed state for a {@link sap.ui.vk.MapContainerButtonType} Toggle button. This does
         * not fire the pressed event handler. It should be used if pressed logic is activated by application code
         * on first load.
         */
        toggled: boolean;
      }
    ): object;
  }
  /**
   * Describes the settings that can be provided to the MapContainer constructor.
   *
   * @deprecated As of version 1.120.2. This object is moved to sap.ui.vbm namespace, see {@link sap.ui.vbm.MapContainer}
   */
  export interface $MapContainerSettings extends $ContainerBaseSettings {
    /**
     * Show navbar
     */
    showNavbar?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Controls the visibility of the home button
     */
    showHome?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Controls the visibility of the Map Layer Select
     */
    showMapLayer?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Controls the visibility of the rectangular zoom button
     */
    showRectangularZoom?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Controls the visibility of the zoom buttons
     */
    showZoom?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * List Panel aggregation
     */
    listPanelStack?: ListPanelStack;
  }
}

declare module "sap/ui/vk/MapContainerButtonType" {
  /**
   * Types of custom buttons supported on the MapContainer toolbar
   *
   * @deprecated As of version 1.120.2. This object is moved to sap.ui.vbm namespace, see {@link sap.ui.vbm.MapContainerButtonType}
   */
  enum MapContainerButtonType {
    Click = "Click",

    Toggle = "Toggle",
  }
  export default MapContainerButtonType;
}

declare module "sap/ui/vk/Material" {
  import BaseObject from "sap/ui/base/Object";

  import { CSSColor } from "sap/ui/core/library";

  import Metadata from "sap/ui/base/Metadata";

  import Texture from "sap/ui/vk/Texture";

  /**
   * Provides the interface for the material.
   *
   * The objects of this class should not be created directly.
   */
  export default abstract class Material extends BaseObject {
    /**
     * Constructor for a new Material.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     *
     * This class does not have its own settings, but all settings applicable to the base type {@link sap.ui.base.Object#constructor sap.ui.base.Object }
     * can be used.
     */
    constructor();

    /**
     * Creates a new subclass of class sap.ui.vk.Material with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.base.Object.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Material>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.Material.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): Metadata;
    /**
     * Gets current value of material ambient colour Default value is "rgba(0, 0, 0, 1)".
     *
     *
     * @returns Ambient colour - red, green, blue, and alpha
     */
    getAmbientColour(): CSSColor;
    /**
     * Gets current value of material diffuse colour Default value is "rgba(0, 0, 0, 1)".
     *
     *
     * @returns Diffuse colour - red, green, blue, and alpha
     */
    getDiffuseColour(): CSSColor;
    /**
     * Gets current value of material emissive colour Default value is "rgba(0, 0, 0, 1)".
     *
     *
     * @returns Emissive colour - red, green, blue, and alpha
     */
    getEmissiveColour(): CSSColor;
    /**
     * Gets current value of material glossiness Default value is 0.0
     *
     *
     * @returns Glossiness
     */
    getGlossiness(): float;
    /**
     * Gets current value of material line colour Default value is "rgba(0, 0, 0, 1)".
     *
     *
     * @returns Line colour - red, green, blue, and alpha
     */
    getLineColour(): CSSColor;
    /**
     * Gets current value of material line width Default value is 0.0
     *
     *
     * @returns Line width
     */
    getLineWidth(): float;
    /**
     * Gets the reference to the native material object
     *
     *
     * @returns Material reference that this material class wraps
     */
    getMaterialRef(): any;
    /**
     * Gets current value of material name
     *
     *
     * @returns Material name
     */
    getName(): string;
    /**
     * Gets current value of material opacity Default value is 1.0
     *
     *
     * @returns Opacity
     */
    getOpacity(): float;
    /**
     * Gets current value of material specular colour Default value is "rgba(0, 0, 0, 1)".
     *
     *
     * @returns Specular colour - red, green, blue, and alpha
     */
    getSpecularColour(): CSSColor;
    /**
     * Gets current value of material ambient occlusion texture
     *
     *
     * @returns Ambient occlusion texture
     */
    getTextureAmbientOcclusion(): Texture;
    /**
     * Gets current value of material bump texture
     *
     *
     * @returns Bump texture
     */
    getTextureBump(): Texture;
    /**
     * Gets current value of material diffuse texture
     *
     *
     * @returns Diffuse texture
     */
    getTextureDiffuse(): Texture;
    /**
     * Gets current value of material emissive texture
     *
     *
     * @returns Emissive texture
     */
    getTextureEmissive(): Texture;
    /**
     * Gets current value of material opacity texture
     *
     *
     * @returns Opacity texture
     */
    getTextureOpacity(): Texture;
    /**
     * Gets current value of material reflection texture
     *
     *
     * @returns Reflection texture
     */
    getTextureReflection(): Texture;
    /**
     * Sets a new value for material ambient colour When called with a value of null or undefined, the default
     * value of the property will be restored. Default value is "rgba(0, 0, 0, 1)".
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAmbientColour(
      /**
       * New value for material ambient colour
       */
      sAmbientColour: CSSColor
    ): this;
    /**
     * Sets a new value for material diffuse colour When called with a value of null or undefined, the default
     * value of the property will be restored. Default value is "rgba(0, 0, 0, 1)".
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDiffuseColour(
      /**
       * New value for material diffuse colour
       */
      sDiffuseColour: CSSColor
    ): this;
    /**
     * Sets a new value for material emissive colour When called with a value of null or undefined, the default
     * value of the property will be restored. Default value is "rgba(0, 0, 0, 1)".
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEmissiveColour(
      /**
       * New value for material emissive colour
       */
      sEmissiveColour: CSSColor
    ): this;
    /**
     * Sets a new value for material glossiness When called with a value of null or undefined, the default value
     * of the property will be restored. Default value is 0.0
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setGlossiness(
      /**
       * New value for material glossiness
       */
      fGlossiness: float
    ): this;
    /**
     * Sets a new value for material line colour When called with a value of null or undefined, the default
     * value of the property will be restored. Default value is "rgba(0, 0, 0, 1)".
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLineColour(
      /**
       * New value for material line colour
       */
      sLineColour: CSSColor
    ): this;
    /**
     * Sets a new value for material line width When called with a value of null or undefined, the default value
     * of the property will be restored. Default value is 0.0
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLineWidth(
      /**
       * New value for material line width
       */
      fLineWidth: float
    ): this;
    /**
     * Sets a new value for material name
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setName(
      /**
       * New value for material name
       */
      sName: string
    ): this;
    /**
     * Sets a new value for material opacity When called with a value of null or undefined, the default value
     * of the property will be restored. Default value is 1.0
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setOpacity(
      /**
       * New value for material opacity
       */
      fOpacity: float
    ): this;
    /**
     * Sets a new value for material specular colour When called with a value of null or undefined, the default
     * value of the property will be restored. Default value is "rgba(0, 0, 0, 1)".
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSpecularColour(
      /**
       * New value for material specular colour
       */
      sSpecularColour: CSSColor
    ): this;
    /**
     * Sets a new value for material ambient occlusion texture
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTextureAmbientOcclusion(
      /**
       * New value for material ambient occlusion texture
       */
      sTextureAmbientOcclusion: Texture
    ): this;
    /**
     * Sets a new value for material bump texture
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTextureBump(
      /**
       * New value for material bump texture
       */
      sTextureBump: Texture
    ): this;
    /**
     * Sets a new value for material diffuse texture
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTextureDiffuse(
      /**
       * New value for material diffuse texture
       */
      sTextureDiffuse: Texture
    ): this;
    /**
     * Sets a new value for material emissive texture
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTextureEmissive(
      /**
       * New value for material emissive texture
       */
      sTextureEmissive: Texture
    ): this;
    /**
     * Sets a new value for material opacity texture
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTextureOpacity(
      /**
       * New value for material opacity texture
       */
      sTextureOpacity: Texture
    ): this;
    /**
     * Sets a new value for material reflection texture
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTextureReflection(
      /**
       * New value for material reflection texture
       */
      sTextureReflection: Texture
    ): this;
  }
}

declare module "sap/ui/vk/NativeViewport" {
  import {
    default as ViewportBase,
    $ViewportBaseSettings,
    ViewportBase$ResizeEventParameters,
  } from "sap/ui/vk/ViewportBase";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  import Event from "sap/ui/base/Event";

  /**
   * Enables loading, pan, zoom and overlay capabilities for a subset of file formats capable of being loaded
   * into a browser natively.
   *
   * @since 1.32.0
   */
  export default class NativeViewport extends ViewportBase {
    /**
     * Constructor for a new NativeViewport.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new Native Viewport control.
       */
      mSettings?: $NativeViewportSettings
    );
    /**
     * Constructor for a new NativeViewport.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new Native Viewport control, generated automatically if no ID is given.
       */
      sId?: string,
      /**
       * Initial settings for the new Native Viewport control.
       */
      mSettings?: $NativeViewportSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vk.NativeViewport with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.vk.ViewportBase.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, NativeViewport>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.NativeViewport.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:move move} event of this `sap.ui.vk.NativeViewport`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.NativeViewport` itself.
     *
     * Raised when the display position or magnification of the image in the Native Viewport changes.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachMove(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: NativeViewport$MoveEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.NativeViewport` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:move move} event of this `sap.ui.vk.NativeViewport`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.NativeViewport` itself.
     *
     * Raised when the display position or magnification of the image in the Native Viewport changes.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachMove(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: NativeViewport$MoveEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.NativeViewport` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:resize resize} event of this `sap.ui.vk.NativeViewport`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.NativeViewport` itself.
     *
     * Raised when the display size of the image in the Native Viewport changes.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachResize(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: NativeViewport$ResizeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.NativeViewport` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:resize resize} event of this `sap.ui.vk.NativeViewport`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.NativeViewport` itself.
     *
     * Raised when the display size of the image in the Native Viewport changes.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachResize(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: NativeViewport$ResizeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.NativeViewport` itself
       */
      oListener?: object
    ): this;
    /**
     * Marks the start of the current gesture operation.
     *
     *
     * @returns this
     */
    beginGesture(
      /**
       * x-coordinate in screen space.
       */
      x: int,
      /**
       * y-coordinate in screen space.
       */
      y: int
    ): NativeViewport;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:move move} event of this `sap.ui.vk.NativeViewport`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachMove(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: NativeViewport$MoveEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:resize resize} event of this `sap.ui.vk.NativeViewport`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachResize(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: NativeViewport$ResizeEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Marks the end of the current gesture operation.
     *
     *
     * @returns this
     */
    endGesture(): NativeViewport;
    /**
     * Fires event {@link #event:move move} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireMove(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: NativeViewport$MoveEventParameters
    ): this;
    /**
     * Fires event {@link #event:resize resize} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireResize(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: NativeViewport$ResizeEventParameters
    ): this;
    /**
     * Gets current value of property {@link #getLimitZoomOut limitZoomOut}.
     *
     * Limit the ability to zoom out. If enabled the zoom out stops if the image size reaches 25% of the full
     * view (best fit).
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `limitZoomOut`
     */
    getLimitZoomOut(): boolean;
    /**
     * It retrieves information about the current virtual native viewport. The information can used for making
     * calculations when restoring Redlining elements.
     *
     *
     * @returns outputSize The information in this object:
     * 	 - **left** - The x coordinate of the top-left corner of the virtual native viewport
     * 	 - **top** - The y coordinate of the top-left corner of the virtual native viewport
     * 	 - **sideLength** - The side length of the virtual native viewport
     */
    getOutputSize(): object;
    /**
     * Gets information about the Viewport's attributes; for example, camera.
     *
     *
     * @returns ViewInfo object.
     */
    getViewInfo(): object;
    /**
     * Loads a image URL into Viewport.
     *
     * @deprecated As of version 1.50.0. Use {@link sap.ui.vk.ContentResource} and {@link sap.ui.vk.ContentConnector#contentResources }
     * aggregation instead.
     *
     * @returns this
     */
    loadUrl(
      /**
       * The URL of the resource.
       */
      url: string,
      /**
       * onload callback, called when the resource is loaded successfully.
       */
      onload: Function,
      /**
       * onerror callback, called when an error occurs during the loading process.
       */
      onerror: Function,
      /**
       * onprogress callback, called during the loading process.
       */
      onprogress: Function,
      /**
       * an array of type of resources to load.
       */
      resourceType: any[]
    ): NativeViewport;
    /**
     * Performs a `pan` gesture to pan across the Viewport.
     *
     *
     * @returns this
     */
    pan(
      /**
       * The change in distance along the x-coordinate.
       */
      dx: int,
      /**
       * The change in distance along the y-coordinate.
       */
      dy: int
    ): NativeViewport;
    /**
     * Queues a command for execution during the rendering cycle. All gesture operations should be called using
     * this method.
     *
     *
     * @returns this
     */
    queueCommand(
      /**
       * The function to be executed.
       */
      command: Function
    ): NativeViewport;
    /**
     * Rotates the content of the Viewport.
     *
     *
     * @returns this
     */
    rotate(
      /**
       * The change in x-coordinate used to define the desired rotation.
       */
      dx: int,
      /**
       * The change in y-coordinate used to define the desired rotation.
       */
      dy: int
    ): NativeViewport;
    /**
     * Sets a new value for property {@link #getLimitZoomOut limitZoomOut}.
     *
     * Limit the ability to zoom out. If enabled the zoom out stops if the image size reaches 25% of the full
     * view (best fit).
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLimitZoomOut(
      /**
       * New value for property `limitZoomOut`
       */
      bLimitZoomOut?: boolean
    ): this;
    /**
     * Sets information about the Viewport's attributes; for example, camera.
     *
     *
     * @returns this
     */
    setViewInfo(
      /**
       * ViewInfo object.
       */
      viewInfo: object
    ): NativeViewport;
    /**
     * Executes a click or tap gesture.
     *
     *
     * @returns this
     */
    tap(
      /**
       * The tap gesture's x-coordinate.
       */
      x: int,
      /**
       * The tap gesture's y-coordinate.
       */
      y: int,
      /**
       * Indicates whether the tap gesture should be interpreted as a double-click. A value of `true` indicates
       * a double-click gesture, and `false` indicates a single click gesture.
       */
      isDoubleClick: boolean
    ): NativeViewport;
    /**
     * Performs a `zoom` gesture to zoom in or out on the beginGesture coordinate.
     *
     *
     * @returns this
     */
    zoom(
      /**
       * Zoom factor. A scale factor that specifies how much to zoom in or out by.
       */
      z: float
    ): NativeViewport;
    /**
     * Zooms the viewport to fit to the content bounds
     *
     *
     * @returns this
     */
    zoomTo(): NativeViewport;
  }
  /**
   * Describes the settings that can be provided to the NativeViewport constructor.
   */
  export interface $NativeViewportSettings extends $ViewportBaseSettings {
    /**
     * Limit the ability to zoom out. If enabled the zoom out stops if the image size reaches 25% of the full
     * view (best fit).
     */
    limitZoomOut?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Raised when the display size of the image in the Native Viewport changes.
     */
    resize?: (oEvent: NativeViewport$ResizeEvent) => void;

    /**
     * Raised when the display position or magnification of the image in the Native Viewport changes.
     */
    move?: (oEvent: NativeViewport$MoveEvent) => void;
  }

  /**
   * Parameters of the NativeViewport#move event.
   */
  export interface NativeViewport$MoveEventParameters {
    pan?: object;

    zoom?: float;
  }

  /**
   * Event object of the NativeViewport#move event.
   */
  export type NativeViewport$MoveEvent = Event<
    NativeViewport$MoveEventParameters,
    NativeViewport
  >;

  /**
   * Parameters of the NativeViewport#resize event.
   */
  export interface NativeViewport$ResizeEventParameters
    extends ViewportBase$ResizeEventParameters {
    oldSize?: object;
  }

  /**
   * Event object of the NativeViewport#resize event.
   */
  export type NativeViewport$ResizeEvent = Event<
    NativeViewport$ResizeEventParameters,
    NativeViewport
  >;
}

declare module "sap/ui/vk/NavigationMode" {
  /**
   * Navigation mode
   */
  enum NavigationMode {
    /**
     * Navigation mode stays the same.
     */
    NoChange = "NoChange",
    /**
     * The orbit navigation mode.
     */
    Orbit = "Orbit",
    /**
     * The pan navigation mode.
     */
    Pan = "Pan",
    /**
     * The turntable navigation mode.
     */
    Turntable = "Turntable",
    /**
     * The zoom navigation mode.
     */
    Zoom = "Zoom",
  }
  export default NavigationMode;
}

declare module "sap/ui/vk/NodeContentType" {
  /**
   * Node content type for {@link sap.ui.vk.NodeHierarchy.createNode}.
   */
  enum NodeContentType {
    /**
     * Annotation node
     */
    Annotation = "Annotation",
    /**
     * Background node
     */
    Background = "Background",
    /**
     * Hotspot node
     */
    Hotspot = "Hotspot",
    /**
     * PMI node
     */
    PMI = "PMI",
    /**
     * Point cloud group node
     */
    PointCloudGroup = "PointCloudGroup",
    /**
     * Reference node
     */
    Reference = "Reference",
    /**
     * Regular node
     */
    Regular = "Regular",
    /**
     * Svg image node
     */
    SvgImage = "SvgImage",
    /**
     * Symbol node
     */
    Symbol = "Symbol",
  }
  export default NodeContentType;
}

declare module "sap/ui/vk/NodeHierarchy" {
  import {
    default as ManagedObject,
    $ManagedObjectSettings,
  } from "sap/ui/base/ManagedObject";

  import Event from "sap/ui/base/Event";

  import LayerProxy from "sap/ui/vk/LayerProxy";

  import NodeContentType from "sap/ui/vk/NodeContentType";

  import NodeProxy from "sap/ui/vk/NodeProxy";

  import ManagedObjectMetadata from "sap/ui/base/ManagedObjectMetadata";

  import Scene from "sap/ui/vk/Scene";

  /**
   * Provides the ability to explore a Scene object's node structure.
   *
   * The objects of this class should not be created directly, and should only be created via a call to {@link sap.ui.vk.Scene#getDefaultNodeHierarchy sap.ui.vk.Scene.getDefaultNodeHierarchy}.
   */
  export default abstract class NodeHierarchy extends ManagedObject {
    /**
     * Constructor for a new NodeHierarchy.
     *
     * The objects of this class should not be created directly, and should only be created via a call to {@link sap.ui.vk.Scene#getDefaultNodeHierarchy sap.ui.vk.Scene.getDefaultNodeHierarchy}.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor();

    /**
     * Creates a new subclass of class sap.ui.vk.NodeHierarchy with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.base.ManagedObject.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, NodeHierarchy>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.NodeHierarchy.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ManagedObjectMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:changed changed} event of this `sap.ui.vk.NodeHierarchy`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.NodeHierarchy` itself.
     *
     * This event will be fired when the node hierarchy changes, e.g. a node is added or removed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachChanged(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.NodeHierarchy` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:changed changed} event of this `sap.ui.vk.NodeHierarchy`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.NodeHierarchy` itself.
     *
     * This event will be fired when the node hierarchy changes, e.g. a node is added or removed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachChanged(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.NodeHierarchy` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:nodeCreated nodeCreated} event of this `sap.ui.vk.NodeHierarchy`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.NodeHierarchy` itself.
     *
     * This event will be fired when a new node is created.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachNodeCreated(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: NodeHierarchy$NodeCreatedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.NodeHierarchy` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:nodeCreated nodeCreated} event of this `sap.ui.vk.NodeHierarchy`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.NodeHierarchy` itself.
     *
     * This event will be fired when a new node is created.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachNodeCreated(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: NodeHierarchy$NodeCreatedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.NodeHierarchy` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:nodeRemoving nodeRemoving} event of this `sap.ui.vk.NodeHierarchy`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.NodeHierarchy` itself.
     *
     * This event will be fired when a node is about to be removed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachNodeRemoving(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: NodeHierarchy$NodeRemovingEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.NodeHierarchy` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:nodeRemoving nodeRemoving} event of this `sap.ui.vk.NodeHierarchy`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.NodeHierarchy` itself.
     *
     * This event will be fired when a node is about to be removed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachNodeRemoving(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: NodeHierarchy$NodeRemovingEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.NodeHierarchy` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:nodeReplaced nodeReplaced} event of this `sap.ui.vk.NodeHierarchy`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.NodeHierarchy` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachNodeReplaced(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: NodeHierarchy$NodeReplacedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.NodeHierarchy` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:nodeReplaced nodeReplaced} event of this `sap.ui.vk.NodeHierarchy`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.NodeHierarchy` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachNodeReplaced(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: NodeHierarchy$NodeReplacedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.NodeHierarchy` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:nodeUpdated nodeUpdated} event of this `sap.ui.vk.NodeHierarchy`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.NodeHierarchy` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachNodeUpdated(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: NodeHierarchy$NodeUpdatedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.NodeHierarchy` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:nodeUpdated nodeUpdated} event of this `sap.ui.vk.NodeHierarchy`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.NodeHierarchy` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachNodeUpdated(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: NodeHierarchy$NodeUpdatedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.NodeHierarchy` itself
       */
      oListener?: object
    ): this;
    /**
     * Creates a layer proxy object.
     *
     * The layer proxy object must be destroyed with the {@link #destroyLayerProxy destroyLayerProxy} method.
     *
     * @since 1.50.0
     *
     * @returns The proxy object.
     */
    createLayerProxy(
      /**
       * The layer ID for which to create a proxy object.
       */
      layerId: string
    ): LayerProxy;
    /**
     * Creates a new node.
     *
     * @since 1.50.0
     *
     * @returns The reference object of the newly created node.
     */
    createNode(
      /**
       * The reference object of the parent node where the created node is added to. If equals `null` the newly
       * created node is a top level node.
       */
      parentNode: any,
      /**
       * The name of the new node.
       */
      name: string,
      /**
       * The created node is added before this specified node. If equals `null` the newly created node is added
       * at the end of the parent's list of nodes.
       */
      insertBeforeNode: any,
      /**
       * The created node content type.
       */
      nodeContentType?: NodeContentType | keyof typeof NodeContentType,
      /**
       * Optional Json structure used to define node properties.
       */
      content?: object
    ): any;
    /**
     * Creates a copy of an existing node.
     *
     * @since 1.50.0
     *
     * @returns The reference object of the newly created node.
     */
    createNodeCopy(
      /**
       * The reference object of the node to copy.
       */
      nodeToCopy: any,
      /**
       * The reference object of the parent node where the created node is added to. If equals `null` the newly
       * created node is a top level node.
       */
      parentNode: any,
      /**
       * The name of the new node.
       */
      name: string,
      /**
       * The created node is added before this specified node. If equals `null` the newly created node is added
       * at the end of the parent's list of nodes.
       */
      insertBeforeNode: any
    ): any;
    /**
     * Creates a node proxy object.
     *
     * The node proxy object must be destroyed with the {@link #destroyNodeProxy destroyNodeProxy} method.
     *
     * @since 1.50.0
     *
     * @returns The proxy object.
     */
    createNodeProxy(
      /**
       * The reference object for which to create a proxy object.
       */
      nodeRef: any
    ): NodeProxy;
    /**
     * Destroys the layer proxy object.
     *
     * @since 1.50.0
     *
     * @returns `this` to allow method chaining.
     */
    destroyLayerProxy(
      /**
       * The layer proxy object.
       */
      layerProxy: LayerProxy
    ): this;
    /**
     * Destroys the node proxy object.
     *
     * @since 1.50.0
     *
     * @returns `this` to allow method chaining.
     */
    destroyNodeProxy(
      /**
       * The node proxy object.
       */
      nodeProxy: NodeProxy
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:changed changed} event of this `sap.ui.vk.NodeHierarchy`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachChanged(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:nodeCreated nodeCreated} event of this `sap.ui.vk.NodeHierarchy`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachNodeCreated(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: NodeHierarchy$NodeCreatedEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:nodeRemoving nodeRemoving} event of this `sap.ui.vk.NodeHierarchy`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachNodeRemoving(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: NodeHierarchy$NodeRemovingEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:nodeReplaced nodeReplaced} event of this `sap.ui.vk.NodeHierarchy`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachNodeReplaced(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: NodeHierarchy$NodeReplacedEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:nodeUpdated nodeUpdated} event of this `sap.ui.vk.NodeHierarchy`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachNodeUpdated(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: NodeHierarchy$NodeUpdatedEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Enumerates the ancestor nodes of a particular node in the Scene object.
     *
     * This method enumerates the ancestor nodes of a particular node, and then calls the `callback` function,
     * to which it passes the ancestor nodes to one by one.
     *  The BaseNodeProxy objects passed to `callback` are temporary objects, they are reset after each call
     * to the `callback` function.
     *  The ancestor nodes are enumerated starting from the top level node, and progresses down the node hierarchy.
     *
     * @since 1.50.0
     *
     * @returns `this` to allow method chaining.
     */
    enumerateAncestors(
      /**
       * The reference object of a node whose ancestor nodes we want enumerated.
       */
      nodeRef: any,
      /**
       * A function to call when the ancestor nodes are enumerated. The function takes one parameter of type {@link sap.ui.vk.BaseNodeProxy},
       * or string if parameter `passNodeRef` parameter is `true`.
       */
      callback: Function,
      /**
       * Indicates whether to pass the reference objects of the ancestor nodes, or the whole node proxy to the
       * `callback` function.
       *  If `true`, then only the reference objects of the ancestor nodes are passed to the `callback` function.
       *
       *  If `false`, then the node proxies of the ancestor nodes are passed to the `callback` function.
       */
      passNodeRef?: boolean
    ): this;
    /**
     * Enumerates the child nodes of a particular node in the Scene object.
     *
     * This method gets the child nodes of a particular node, and then calls the `callback` function to which
     * it passes the child nodes to one by one.
     *  The `BaseNodeProxy` objects passed to the `callback` function are temporary objects, which are reset
     * after each call to the `callback` function.
     *
     *
     * @since 1.50.0
     *
     * @returns `this` to allow method chaining.
     */
    enumerateChildren(
      /**
       * The reference object of a node whose child nodes we want enumerated.
       *  When `nodeRef` is specified, the child nodes of this node are enumerated.
       *  When no `nodeRef` is specified, only the top level nodes are enumerated.
       */
      nodeRef: any,
      /**
       * A function to call when the child nodes are enumerated. The function takes one parameter of type {@link sap.ui.vk.BaseNodeProxy},
       * or string if parameter `passNodeRef` parameter is `true`.
       */
      callback: Function,
      /**
       * Indicates whether to enumerate the child nodes if the node is closed.
       *  If `true`, the children of that closed node will be enumerated
       *  If `false`, the children of that node will not be enumerated
       */
      stepIntoClosedNodes?: boolean,
      /**
       * Indicates whether to pass the reference objects of the child nodes, or the whole node proxy to the `callback`
       * function.
       *  If `true`, then only the reference objects of the child nodes are passed to the `callback` function.
       *
       *  If `false`, then the node proxies created from the child reference objects are passed to the `callback`
       * function.
       */
      passNodeRef?: boolean
    ): this;
    /**
     * Enumerates the child nodes of a particular node in the Scene object.
     *
     * This method gets the child nodes of a particular node, and then calls the `callback` function to which
     * it passes the child nodes to one by one.
     *  The `BaseNodeProxy` objects passed to the `callback` function are temporary objects, which are reset
     * after each call to the `callback` function.
     *
     *
     * @since 1.50.0
     *
     * @returns `this` to allow method chaining.
     */
    enumerateChildren(
      /**
       * A function to call when the child nodes are enumerated. The function takes one parameter of type {@link sap.ui.vk.BaseNodeProxy},
       * or string if parameter `passNodeRef` parameter is `true`.
       */
      callback: Function,
      /**
       * Indicates whether to enumerate the child nodes if the node is closed.
       *  If `true`, the children of that closed node will be enumerated
       *  If `false`, the children of that node will not be enumerated
       */
      stepIntoClosedNodes?: boolean,
      /**
       * Indicates whether to pass the reference objects of the child nodes, or the whole node proxy to the `callback`
       * function.
       *  If `true`, then only the reference objects of the child nodes are passed to the `callback` function.
       *
       *  If `false`, then the node proxies created from the child reference objects are passed to the `callback`
       * function.
       */
      passNodeRef?: boolean
    ): this;
    /**
     * Searches for VE IDs, and returns a list of reference objects of nodes with VE IDs matching the search.
     * The query is run specifically against VE ID structures, which are strictly related to VDS4 models.
     *
     * @since 1.50.0
     *
     * @returns A list of reference objects belonging to nodes that matched the VE IDs search criteria.
     */
    findNodesById(
      /**
       * JSON object containing the search parameters.
       *  The following example shows what the structure of the `query` object should look like:
       * ```javascript
       * query = {
       * 	source: string (if not specified, the query returns an empty array),
       *
       * 	type: string (if not specified, the query returns an empty array),
       *
       * 	fields: field[]
       * 	}```
       *
       *
       * 	 -  **field.name**
       *  A string containing the name of the VE ID. If no value is specified, then the query will return an empty
       * array.
       *
       * 	 -  **field.value**
       *  A string representing the search keyword. If no value is specified, it defaults to empty string.
       *  The following example shows a string being passed in:
       * ```javascript
       * value: "Box #14"```
       *
       * 	 -  **field.predicate**
       *  Represents a search mode. The available search modes are `"equals"`, `"contains"`, and `"startsWith"`.
       *
       *  Using `"equals"` will search for IDs with names that exactly match the provided string.
       *  Using `"contains"` will search for IDs with names containing the provided string.
       *  Using `"startsWith"` will search for IDs with names starting with the provided string.
       *  If no value is specified, the search mode will default to `"equals"`.
       *
       *
       * 	 -  **field.caseSensitive**
       *  Indicates whether the search should be case sensitive or not.
       *  If `true`, the search will be case sensitive, and `false` indicates otherwise.
       *  If no value is specified, `caseSensitive` will default to `false` (that is, the search will be a case-insensitive
       * search).
       */
      query: object
    ): any[];
    /**
     * Finds nodes in a scene via metadata information.
     *
     * @since 1.50.0
     *
     * @returns A list of reference objects belonging to nodes that matched the search criteria.
     */
    findNodesByMetadata(
      /**
       * JSON object containing the search parameters.
       *  The following example shows what the structure of the `query` object should look like:
       * ```javascript
       * query = {
       *   category: string,
       *   key: string,
       *   value: string | string[],
       *   predicate: "equals" | "contains" | "startsWith",
       *   caseSensitive: true | false
       * }```
       *
       *  NOTE: `query.predicate` and `query.caseSensitive` refer to `query.value`.
       *
       * 	 -  **query.category**
       *  A string indicating the name of the metadata category.
       *  If no value is specified for `query.category`, all nodes in the scene will be returned in the search.
       *
       *
       * 	 -  **query.key**
       *  A string indicating the key which belongs to the metadata category specified in `query.category`. You
       * can only use `query.key` if `query.category` has been specified.
       *  If no value is specified for `query.key`, then all nodes grouped under the specified category will be
       * returned in the search.
       *
       *
       * 	 -  **query.value**
       *  A string or an array of strings containing the value or values associated with `query.key`. You can
       * only use `query.value` in the search if `query.key` has been specified.
       *  If no value is specified for `query.value`, then all nodes containing the specified key will be returned,
       * regardless of what the value of the key is.
       *  The following example shows a single string being passed in:
       * ```javascript
       * value: "Box #14"```
       *  The following example shows an array of strings being passed in:
       * ```javascript
       * value: ["Box #3", "box #4", "BOX #5"]```
       *
       * 	 -  **query.predicate**
       *  Represents a search mode. The available search modes are `"equals"`, `"contains"`, and `"startsWith"`.
       *
       *  Using `"equals"` will search for key values that exactly match the provided string or array of strings.
       *
       *  Using `"contains"` will search for key values containing all or part of the provided string or array
       * of strings.
       *  Using `"startsWith"` will search key values starting with the provided string or array of strings.
       *  If no value is specified, the search mode will default to `"equals"`.
       *
       *
       * 	 -  **query.caseSensitive**
       *  Indicates whether the search should be case sensitive or not.
       *  If `true`, the search will be case sensitive, and `false` indicates otherwise.
       *  If no value is specified, `caseSensitive` will default to `false` (that is, the search will be a case-insensitive
       * search).
       */
      query: object
    ): any[];
    /**
     * Finds nodes in a scene via node name.
     *
     * @since 1.50.0
     *
     * @returns A list of reference objects belonging to nodes that matched the search criteria.
     */
    findNodesByName(
      /**
       * JSON object containing the search parameters.
       *  The following example shows what the structure of the `query` object should look like:
       * ```javascript
       * query = {
       * 	value: string | string[],
       * 	predicate: "equals" | "contains" | "startsWith",
       * 	caseSensitive: true | false
       * }```
       *
       *
       * 	 -  **query.value**
       *  A string or an array of strings containing the name of a node or names of nodes. If no value is specified,
       * then all nodes in the scene will be returned.
       *  The following example shows a single string being passed in:
       * ```javascript
       * value: "Box #14"```
       *  The following example shows an array of strings being passed in:
       * ```javascript
       * value: ["Box #3", "box #4", "BOX #5"]```
       *
       * 	 -  **query.predicate**
       *  Represents a search mode. The available search modes are `"equals"`, `"contains"`, and `"startsWith"`.
       *
       *  Using `"equals"` will search for nodes with names that exactly match the provided string or array of
       * strings.
       *  Using `"contains"` will search for nodes with names containing all or part of the provided string or
       * array of strings.
       *  Using `"startsWith"` will search for nodes with names starting with the provided string or array of
       * strings.
       *  If no value is specified, the search mode will default to `"equals"`.
       *
       *
       * 	 -  **query.caseSensitive**
       *  Indicates whether the search should be case sensitive or not.
       *  If `true`, the search will be case sensitive, and `false` indicates otherwise.
       *  If no value is specified, `caseSensitive` will default to `false` (that is, the search will be a case-insensitive
       * search).
       */
      query: object
    ): any[];
    /**
     * Fires event {@link #event:changed changed} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireChanged(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:nodeCreated nodeCreated} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireNodeCreated(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: NodeHierarchy$NodeCreatedEventParameters
    ): this;
    /**
     * Fires event {@link #event:nodeRemoving nodeRemoving} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireNodeRemoving(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: NodeHierarchy$NodeRemovingEventParameters
    ): this;
    /**
     * Fires event {@link #event:nodeReplaced nodeReplaced} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireNodeReplaced(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: NodeHierarchy$NodeReplacedEventParameters
    ): this;
    /**
     * Fires event {@link #event:nodeUpdated nodeUpdated} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireNodeUpdated(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: NodeHierarchy$NodeUpdatedEventParameters
    ): this;
    /**
     * Returns a list of reference objects belonging to the ancestors of a particular node.
     *
     * @since 1.50.0
     *
     * @returns A list of reference objects belonging to the ancestors of `nodeRef`.
     */
    getAncestors(
      /**
       * The reference object of the node whose ancestors will be returned.
       */
      nodeRef: any
    ): any[];
    /**
     * Returns a list of reference objects belonging to the children of a particular node.
     *
     * @since 1.50.0
     *
     * @returns A list of reference objects belonging to the children of `nodeRef`.
     */
    getChildren(
      /**
       * The reference object of the node whose children will be returned. If `nodeRef` is not passed to the `getChildren`
       * function, the reference objects of the root nodes will be returned.
       */
      nodeRef: any,
      /**
       * Indicates whether to return only the child nodes of a closed node or not. If `true`, then the
       * children of that closed node will be returned. If `false`, then the children of that closed node
       * will not be returned.
       */
      stepIntoClosedNodes?: boolean
    ): any[];
    /**
     * Returns a list of hotspot IDs.
     *
     * @since 1.50.0
     * @deprecated As of version 1.128.0. please use {@link sap.ui.vk.NodeHierarchy#getHotspotNodeRefs getHotspotNodeRefs }
     * instead.
     *
     * @returns A list of hotspot IDs.
     */
    getHotspotNodeIds(): string[];
    /**
     * Returns a list of hotspot node references.
     *
     * @since 1.128.0
     *
     * @returns A list of hotspot node references.
     */
    getHotspotNodeRefs(): any[];
    /**
     * Returns a list of layer IDs.
     *
     * @since 1.50.0
     *
     * @returns A list of layer IDs.
     */
    getLayers(): string[];
    /**
     * Get node content type
     *
     * @since 1.73.0
     *
     * @returns Node content type
     */
    getNodeContentType(
      /**
       * The node reference
       */
      nodeRef: any
    ): NodeContentType;
    /**
     * Gets the Scene object the node hierarchy belongs to.
     *
     * @since 1.50.0
     *
     * @returns The Scene object the node hierarchy belongs to.
     */
    getScene(): Scene;
    /**
     * Gets the scene reference that this NodeHierarchy object wraps.
     *
     *
     * @returns The scene reference that this NodeHierarchy object wraps.
     */
    getSceneRef(): any;
    /**
     * Deletes a node and destroys it.
     *
     * @since 1.50.0
     *
     * @returns `this` to allow method chaining.
     */
    removeNode(
      /**
       * The reference object of the node to destroy.
       */
      nodeRef: any
    ): this;
  }
  /**
   * Describes the settings that can be provided to the NodeHierarchy constructor.
   */
  export interface $NodeHierarchySettings extends $ManagedObjectSettings {
    /**
     * This event will be fired when the node hierarchy changes, e.g. a node is added or removed.
     */
    changed?: (oEvent: Event) => void;

    /**
     * This event will be fired when a new node is created.
     */
    nodeCreated?: (oEvent: NodeHierarchy$NodeCreatedEvent) => void;

    /**
     * This event will be fired when a node is about to be removed.
     */
    nodeRemoving?: (oEvent: NodeHierarchy$NodeRemovingEvent) => void;

    nodeReplaced?: (oEvent: NodeHierarchy$NodeReplacedEvent) => void;

    nodeUpdated?: (oEvent: NodeHierarchy$NodeUpdatedEvent) => void;
  }

  /**
   * Parameters of the NodeHierarchy#changed event.
   */
  export interface NodeHierarchy$ChangedEventParameters {}

  /**
   * Event object of the NodeHierarchy#changed event.
   */
  export type NodeHierarchy$ChangedEvent = Event<
    NodeHierarchy$ChangedEventParameters,
    NodeHierarchy
  >;

  /**
   * Parameters of the NodeHierarchy#nodeCreated event.
   */
  export interface NodeHierarchy$NodeCreatedEventParameters {
    nodeRef?: any;

    nodeId?: string;
  }

  /**
   * Event object of the NodeHierarchy#nodeCreated event.
   */
  export type NodeHierarchy$NodeCreatedEvent = Event<
    NodeHierarchy$NodeCreatedEventParameters,
    NodeHierarchy
  >;

  /**
   * Parameters of the NodeHierarchy#nodeRemoving event.
   */
  export interface NodeHierarchy$NodeRemovingEventParameters {
    nodeRef?: any;

    nodeId?: string;
  }

  /**
   * Event object of the NodeHierarchy#nodeRemoving event.
   */
  export type NodeHierarchy$NodeRemovingEvent = Event<
    NodeHierarchy$NodeRemovingEventParameters,
    NodeHierarchy
  >;

  /**
   * Parameters of the NodeHierarchy#nodeReplaced event.
   */
  export interface NodeHierarchy$NodeReplacedEventParameters {
    ReplacedNodeRef?: any;

    ReplacementNodeRef?: any;

    ReplacedNodeId?: string;

    ReplacementNodeId?: string;
  }

  /**
   * Event object of the NodeHierarchy#nodeReplaced event.
   */
  export type NodeHierarchy$NodeReplacedEvent = Event<
    NodeHierarchy$NodeReplacedEventParameters,
    NodeHierarchy
  >;

  /**
   * Parameters of the NodeHierarchy#nodeUpdated event.
   */
  export interface NodeHierarchy$NodeUpdatedEventParameters {
    nodeRef?: any;

    nodeId?: string;
  }

  /**
   * Event object of the NodeHierarchy#nodeUpdated event.
   */
  export type NodeHierarchy$NodeUpdatedEvent = Event<
    NodeHierarchy$NodeUpdatedEventParameters,
    NodeHierarchy
  >;
}

declare module "sap/ui/vk/NodeProxy" {
  import {
    default as ManagedObject,
    PropertyBindingInfo,
    $ManagedObjectSettings,
  } from "sap/ui/base/ManagedObject";

  import Material from "sap/ui/vk/Material";

  import ManagedObjectMetadata from "sap/ui/base/ManagedObjectMetadata";

  import { CSSColor } from "sap/ui/core/library";

  /**
   * Provides a proxy object to the node in the node hierarchy.
   *
   * Objects of this type should only be created with the {@link sap.ui.vk.NodeHierarchy#createNodeProxy sap.ui.vk.NodeHierarchy.createNodeProxy }
   * method. and destroyed with the {@link sap.ui.vk.NodeHierarchy#destroyNodeProxy sap.ui.vk.NodeHierarchy.destroyNodeProxy }
   * method.
   *
   * @since 1.32.0
   */
  export default class NodeProxy extends ManagedObject {
    /**
     * Constructor for a new NodeProxy.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor();

    /**
     * Creates a new subclass of class sap.ui.vk.NodeProxy with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.base.ManagedObject.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, NodeProxy>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.NodeProxy.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ManagedObjectMetadata;
    /**
     * Binds property {@link #getLocalMatrix localMatrix} to model data.
     *
     * See {@link sap.ui.base.ManagedObject#bindProperty ManagedObject.bindProperty} for a detailed description
     * of the possible properties of `oBindingInfo`
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    bindLocalMatrix(
      /**
       * The binding information
       */
      oBindingInfo: PropertyBindingInfo
    ): this;
    /**
     * Binds property {@link #getOpacity opacity} to model data.
     *
     * See {@link sap.ui.base.ManagedObject#bindProperty ManagedObject.bindProperty} for a detailed description
     * of the possible properties of `oBindingInfo`
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    bindOpacity(
      /**
       * The binding information
       */
      oBindingInfo: PropertyBindingInfo
    ): this;
    /**
     * Binds property {@link #getTintColor tintColor} to model data.
     *
     * See {@link sap.ui.base.ManagedObject#bindProperty ManagedObject.bindProperty} for a detailed description
     * of the possible properties of `oBindingInfo`
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    bindTintColor(
      /**
       * The binding information
       */
      oBindingInfo: PropertyBindingInfo
    ): this;
    /**
     * Binds property {@link #getTintColorABGR tintColorABGR} to model data.
     *
     * See {@link sap.ui.base.ManagedObject#bindProperty ManagedObject.bindProperty} for a detailed description
     * of the possible properties of `oBindingInfo`
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    bindTintColorABGR(
      /**
       * The binding information
       */
      oBindingInfo: PropertyBindingInfo
    ): this;
    /**
     * Binds property {@link #getWorldMatrix worldMatrix} to model data.
     *
     * See {@link sap.ui.base.ManagedObject#bindProperty ManagedObject.bindProperty} for a detailed description
     * of the possible properties of `oBindingInfo`
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    bindWorldMatrix(
      /**
       * The binding information
       */
      oBindingInfo: PropertyBindingInfo
    ): this;
    /**
     * Gets current value of property {@link #getClosed closed}.
     *
     * The indicator showing if the node is closed. This property is read-only.
     *
     *
     * @returns Value of property `closed`
     */
    getClosed(): boolean;
    /**
     * Gets current value of property {@link #getHasChildren hasChildren}.
     *
     * The indicator showing if the node has child nodes. This property is read-only.
     *
     *
     * @returns Value of property `hasChildren`
     */
    getHasChildren(): boolean;
    /**
     * Gets current value of property {@link #getLocalMatrix localMatrix}.
     *
     * The local transformation matrix of the node.
     *
     *
     * @returns Value of property `localMatrix`
     */
    getLocalMatrix(): float[];
    /**
     * get local rotation represented by axis and angle
     *
     *
     * @returns angleAxis rotation [x, y, z, angle], (x, y, z) - rotation axis
     */
    getLocalRotationInAngleAxis(): float[];
    /**
     * get local rotation in Euler form
     *
     *
     * @returns angleAxis rotation [a1, a2, a3, order] a1, a2, a3 - rotation angles about 1st, 2nd, 3nd axis
     * order - int encoding order of XYZ axis (e.g, order "XZY" - 011100, 01 - 3rd axis(Y), 11 - 2nd axis(Z),
     * 00 - 1st axis(X))
     */
    getLocalRotationInEuler(): float[];
    /**
     * get local rotation represented by quaternion
     *
     *
     * @returns quaternion [x, y, z, w]
     */
    getLocalRotationInQuaternion(): float[];
    /**
     * get local scale vector
     *
     *
     * @returns scale vector
     */
    getLocalScale(): float[];
    /**
     * get local translate vector
     *
     *
     * @returns translate vector
     */
    getLocalTranslate(): float[];
    /**
     * Gets current value of property {@link #getMaterial material}.
     *
     * The material of the node (optional).
     *
     *
     * @returns Value of property `material`
     */
    getMaterial(): Material;
    /**
     * Gets current value of property {@link #getName name}.
     *
     * The name of the node. This property is read-only.
     *
     *
     * @returns Value of property `name`
     */
    getName(): string;
    /**
     * Gets current value of property {@link #getNodeMetadata nodeMetadata}.
     *
     * The node metadata. This property is read-only.
     *
     *
     * @returns Value of property `nodeMetadata`
     */
    getNodeMetadata(): object;
    /**
     * Gets current value of property {@link #getNodeRef nodeRef}.
     *
     * The node reference. This property is read-only.
     *
     *
     * @returns Value of property `nodeRef`
     */
    getNodeRef(): any;
    /**
     * Gets current value of property {@link #getOpacity opacity}.
     *
     * The node opacity.
     *
     *
     * @returns Value of property `opacity`
     */
    getOpacity(): float;
    /**
     * Gets current value of property {@link #getTintColor tintColor}.
     *
     * The tint color.
     *
     *
     * @returns Value of property `tintColor`
     */
    getTintColor(): CSSColor;
    /**
     * Gets current value of property {@link #getTintColorABGR tintColorABGR}.
     *
     * The tint color.
     *
     *
     * The tint color is a 32-bit integer in the ABGR notation, where A is amount of blending between material
     * color and tint color.
     *
     *
     * @returns Value of property `tintColorABGR`
     */
    getTintColorABGR(): int;
    /**
     * Gets current value of property {@link #getVeIds veIds}.
     *
     * The node VE IDs. This property is read-only.
     *
     *
     * @returns Value of property `veIds`
     */
    getVeIds(): object[];
    /**
     * Gets current value of property {@link #getWorldMatrix worldMatrix}.
     *
     * The world transformation matrix of the node.
     *
     *
     * @returns Value of property `worldMatrix`
     */
    getWorldMatrix(): float[];
    /**
     * Gets the scene reference that this NodeProxy object wraps.
     *
     *
     * @returns The scene reference that this NodeProxy object wraps.
     */
    setClosed(): any;
    /**
     * Sets a new value for property {@link #getHasChildren hasChildren}.
     *
     * The indicator showing if the node has child nodes. This property is read-only.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHasChildren(
      /**
       * New value for property `hasChildren`
       */
      bHasChildren: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getLocalMatrix localMatrix}.
     *
     * The local transformation matrix of the node.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLocalMatrix(
      /**
       * New value for property `localMatrix`
       */
      sLocalMatrix: float[]
    ): this;
    /**
     * Sets a new value for property {@link #getMaterial material}.
     *
     * The material of the node (optional).
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMaterial(
      /**
       * New value for property `material`
       */
      sMaterial: Material
    ): this;
    /**
     * Sets a new value for property {@link #getName name}.
     *
     * The name of the node. This property is read-only.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setName(
      /**
       * New value for property `name`
       */
      sName: string
    ): this;
    /**
     * Sets a new value for property {@link #getNodeMetadata nodeMetadata}.
     *
     * The node metadata. This property is read-only.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setNodeMetadata(
      /**
       * New value for property `nodeMetadata`
       */
      oNodeMetadata: object
    ): this;
    /**
     * Sets a new value for property {@link #getNodeRef nodeRef}.
     *
     * The node reference. This property is read-only.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setNodeRef(
      /**
       * New value for property `nodeRef`
       */
      oNodeRef: any
    ): this;
    /**
     * Sets a new value for property {@link #getOpacity opacity}.
     *
     * The node opacity.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setOpacity(
      /**
       * New value for property `opacity`
       */
      fOpacity: float
    ): this;
    /**
     * Sets a new value for property {@link #getTintColor tintColor}.
     *
     * The tint color.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTintColor(
      /**
       * New value for property `tintColor`
       */
      sTintColor: CSSColor
    ): this;
    /**
     * Sets a new value for property {@link #getTintColorABGR tintColorABGR}.
     *
     * The tint color.
     *
     *
     * The tint color is a 32-bit integer in the ABGR notation, where A is amount of blending between material
     * color and tint color.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTintColorABGR(
      /**
       * New value for property `tintColorABGR`
       */
      iTintColorABGR: int
    ): this;
    /**
     * Sets a new value for property {@link #getVeIds veIds}.
     *
     * The node VE IDs. This property is read-only.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setVeIds(
      /**
       * New value for property `veIds`
       */
      sVeIds: object[]
    ): this;
    /**
     * Sets a new value for property {@link #getWorldMatrix worldMatrix}.
     *
     * The world transformation matrix of the node.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWorldMatrix(
      /**
       * New value for property `worldMatrix`
       */
      sWorldMatrix: float[]
    ): this;
    /**
     * Unbinds property {@link #getLocalMatrix localMatrix} from model data.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    unbindLocalMatrix(): this;
    /**
     * Unbinds property {@link #getOpacity opacity} from model data.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    unbindOpacity(): this;
    /**
     * Unbinds property {@link #getTintColor tintColor} from model data.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    unbindTintColor(): this;
    /**
     * Unbinds property {@link #getTintColorABGR tintColorABGR} from model data.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    unbindTintColorABGR(): this;
    /**
     * Unbinds property {@link #getWorldMatrix worldMatrix} from model data.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    unbindWorldMatrix(): this;
  }
  /**
   * Describes the settings that can be provided to the NodeProxy constructor.
   */
  export interface $NodeProxySettings extends $ManagedObjectSettings {
    /**
     * The node reference. This property is read-only.
     */
    nodeRef?: any | PropertyBindingInfo | `{${string}}`;

    /**
     * The node VE IDs. This property is read-only.
     */
    veIds?: object[] | PropertyBindingInfo | `{${string}}`;

    /**
     * The name of the node. This property is read-only.
     */
    name?: string | PropertyBindingInfo;

    /**
     * The local transformation matrix of the node.
     */
    localMatrix?: float[] | PropertyBindingInfo | `{${string}}`;

    /**
     * The world transformation matrix of the node.
     */
    worldMatrix?: float[] | PropertyBindingInfo | `{${string}}`;

    /**
     * The material of the node (optional).
     */
    material?: Material | PropertyBindingInfo | `{${string}}`;

    /**
     * The node opacity.
     */
    opacity?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * The tint color.
     *
     *
     * The tint color is a 32-bit integer in the ABGR notation, where A is amount of blending between material
     * color and tint color.
     */
    tintColorABGR?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * The tint color.
     */
    tintColor?: CSSColor | PropertyBindingInfo | `{${string}}`;

    /**
     * The node metadata. This property is read-only.
     */
    nodeMetadata?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * The indicator showing if the node has child nodes. This property is read-only.
     */
    hasChildren?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * The indicator showing if the node is closed. This property is read-only.
     */
    closed?: boolean | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/ui/vk/Notifications" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import Event from "sap/ui/base/Event";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  /**
   * Provides the ability to display logged console messages within your application.
   *
   * @since 1.38.0
   */
  export default class Notifications extends Control {
    /**
     * Constructor for a new Notifications.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new Notifications control.
       */
      mSettings?: $NotificationsSettings
    );
    /**
     * Constructor for a new Notifications.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new Notifications control. Generated automatically if no ID is given.
       */
      sId?: string,
      /**
       * Initial settings for the new Notifications control.
       */
      mSettings?: $NotificationsSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vk.Notifications with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Notifications>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.Notifications.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:allMessagesCleared allMessagesCleared} event
     * of this `sap.ui.vk.Notifications`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.Notifications` itself.
     *
     * This event will be fired when all messages in the log are deleted.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachAllMessagesCleared(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.Notifications` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:allMessagesCleared allMessagesCleared} event
     * of this `sap.ui.vk.Notifications`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.Notifications` itself.
     *
     * This event will be fired when all messages in the log are deleted.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachAllMessagesCleared(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.Notifications` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:messageAdded messageAdded} event of this `sap.ui.vk.Notifications`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.Notifications` itself.
     *
     * This event will be fired when a new log message is added.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachMessageAdded(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.Notifications` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:messageAdded messageAdded} event of this `sap.ui.vk.Notifications`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.Notifications` itself.
     *
     * This event will be fired when a new log message is added.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachMessageAdded(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.Notifications` itself
       */
      oListener?: object
    ): this;
    /**
     * Clears the items in the Message Popover list.
     *
     *
     * @returns `this` to allow method chaining.
     */
    clearAllMessages(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:allMessagesCleared allMessagesCleared} event
     * of this `sap.ui.vk.Notifications`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachAllMessagesCleared(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:messageAdded messageAdded} event of this `sap.ui.vk.Notifications`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachMessageAdded(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:allMessagesCleared allMessagesCleared} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireAllMessagesCleared(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:messageAdded messageAdded} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireMessageAdded(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Notifications constructor.
   */
  export interface $NotificationsSettings extends $ControlSettings {
    /**
     * This event will be fired when all messages in the log are deleted.
     */
    allMessagesCleared?: (oEvent: Event) => void;

    /**
     * This event will be fired when a new log message is added.
     */
    messageAdded?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the Notifications#allMessagesCleared event.
   */
  export interface Notifications$AllMessagesClearedEventParameters {}

  /**
   * Event object of the Notifications#allMessagesCleared event.
   */
  export type Notifications$AllMessagesClearedEvent = Event<
    Notifications$AllMessagesClearedEventParameters,
    Notifications
  >;

  /**
   * Parameters of the Notifications#messageAdded event.
   */
  export interface Notifications$MessageAddedEventParameters {}

  /**
   * Event object of the Notifications#messageAdded event.
   */
  export type Notifications$MessageAddedEvent = Event<
    Notifications$MessageAddedEventParameters,
    Notifications
  >;
}

declare module "sap/ui/vk/ObjectType" {
  /**
   * Object type
   */
  enum ObjectType {
    Hotspot = "1",

    PMI = "0",
  }
  export default ObjectType;
}

declare module "sap/ui/vk/OrthographicCamera" {
  import { default as Camera, $CameraSettings } from "sap/ui/vk/Camera";

  import ManagedObjectMetadata from "sap/ui/base/ManagedObjectMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Provides the interface for the orthographic camera.
   *
   * @since 1.52.0
   */
  export default class OrthographicCamera extends Camera {
    /**
     * Constructor for a new OrthographicCamera.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor();

    /**
     * Creates a new subclass of class sap.ui.vk.OrthographicCamera with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.vk.Camera.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, OrthographicCamera>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.OrthographicCamera.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ManagedObjectMetadata;
    /**
     * Gets current value of property {@link #getZoomFactor zoomFactor}.
     *
     * Camera zoom factor
     *
     *
     * @returns Value of property `zoomFactor`
     */
    getZoomFactor(): float;
    /**
     * Sets a new value for property {@link #getZoomFactor zoomFactor}.
     *
     * Camera zoom factor
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setZoomFactor(
      /**
       * New value for property `zoomFactor`
       */
      fZoomFactor: float
    ): this;
  }
  /**
   * Describes the settings that can be provided to the OrthographicCamera constructor.
   */
  export interface $OrthographicCameraSettings extends $CameraSettings {
    /**
     * Camera zoom factor
     */
    zoomFactor?: float | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/ui/vk/OutputSettings" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Aggregation element for the output settings of the Viewport
   *
   * @since 1.92.0
   * @experimental As of version 1.92.0. This class is experimental and might be modified or removed in future
   * versions.
   */
  export default class OutputSettings extends UI5Element {
    /**
     * Constructor for a new OutputSettings.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $OutputSettingsSettings
    );
    /**
     * Constructor for a new OutputSettings.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $OutputSettingsSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vk.OutputSettings with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, OutputSettings>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.OutputSettings.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getDpi dpi}.
     *
     * density of the output, unit in dpi (dots-per-inch)
     *
     *
     * @returns Value of property `dpi`
     */
    getDpi(): float;
    /**
     * Gets current value of property {@link #getHeight height}.
     *
     * height of the output, unit in mm
     *
     *
     * @returns Value of property `height`
     */
    getHeight(): float;
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * width of the output, unit in mm
     *
     *
     * @returns Value of property `width`
     */
    getWidth(): float;
    /**
     * Sets a new value for property {@link #getDpi dpi}.
     *
     * density of the output, unit in dpi (dots-per-inch)
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDpi(
      /**
       * New value for property `dpi`
       */
      fDpi: float
    ): this;
    /**
     * Sets a new value for property {@link #getHeight height}.
     *
     * height of the output, unit in mm
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHeight(
      /**
       * New value for property `height`
       */
      fHeight: float
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * width of the output, unit in mm
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      fWidth: float
    ): this;
  }
  /**
   * Describes the settings that can be provided to the OutputSettings constructor.
   *
   * @experimental As of version 1.92.0. This class is experimental and might be modified or removed in future
   * versions.
   */
  export interface $OutputSettingsSettings extends $ElementSettings {
    /**
     * width of the output, unit in mm
     */
    width?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * height of the output, unit in mm
     */
    height?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * density of the output, unit in dpi (dots-per-inch)
     */
    dpi?: float | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/ui/vk/Overlay" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import OverlayArea from "sap/ui/vk/OverlayArea";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { ID } from "sap/ui/core/library";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  import Event from "sap/ui/base/Event";

  import Menu from "sap/ui/unified/Menu";

  /**
   * Constructor for a new Overlay.
   *
   * @since 1.32.0
   * @deprecated As of version 1.120. This is not in use anymore. Please consider using Redline tool, see
   * {@link sap.ui.vk.RedlineTool}
   */
  export default class Overlay extends Control {
    /**
     * Constructor for a new Overlay.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $OverlaySettings
    );
    /**
     * Constructor for a new Overlay.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $OverlaySettings
    );

    /**
     * Creates a new subclass of class sap.ui.vk.Overlay with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Overlay>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.Overlay.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some area to the aggregation {@link #getAreas areas}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addArea(
      /**
       * The area to add; if empty, nothing is inserted
       */
      oArea: OverlayArea
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:click click} event of this `sap.ui.vk.Overlay`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.Overlay` itself.
     *
     * Raised when the Control is clicked.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachClick(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Overlay$ClickEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.Overlay` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:click click} event of this `sap.ui.vk.Overlay`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.Overlay` itself.
     *
     * Raised when the Control is clicked.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachClick(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Overlay$ClickEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.Overlay` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:contextMenu contextMenu} event of this `sap.ui.vk.Overlay`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.Overlay` itself.
     *
     * Raised when the Control is right clicked/longPress(tap and hold).
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachContextMenu(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Overlay$ContextMenuEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.Overlay` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:contextMenu contextMenu} event of this `sap.ui.vk.Overlay`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.Overlay` itself.
     *
     * Raised when the Control is right clicked/longPress(tap and hold).
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachContextMenu(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Overlay$ContextMenuEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.Overlay` itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys all the areas in the aggregation {@link #getAreas areas}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyAreas(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:click click} event of this `sap.ui.vk.Overlay`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachClick(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Overlay$ClickEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:contextMenu contextMenu} event of this `sap.ui.vk.Overlay`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachContextMenu(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Overlay$ContextMenuEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:click click} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireClick(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: Overlay$ClickEventParameters
    ): this;
    /**
     * Fires event {@link #event:contextMenu contextMenu} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireContextMenu(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: Overlay$ContextMenuEventParameters
    ): this;
    /**
     * Gets content of aggregation {@link #getAreas areas}.
     *
     * Aggregation of Highlight Areas.
     */
    getAreas(): OverlayArea[];
    /**
     * Trigger the interactive creation mode to get a position or position array.
     *
     *
     * @returns Indicator whether the creation mode could be triggered successfully or not.
     */
    getPositionInteractive(
      /**
       * Indicator if a single position or an array is requested
       */
      bPosArray: boolean,
      /**
       * Callback function func( sPosArray ) to be called when done. Position(array) sPosArray is provided in
       * format "x;y;0;..."
       */
      callback: Function
    ): boolean;
    /**
     * ID of the element which is the current target of the association {@link #getTarget target}, or `null`.
     */
    getTarget(): ID | null;
    /**
     * Gets current value of property {@link #getZoomOnResize zoomOnResize}.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `zoomOnResize`
     */
    getZoomOnResize(): boolean;
    /**
     * Checks for the provided `sap.ui.vk.OverlayArea` in the aggregation {@link #getAreas areas}. and returns
     * its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfArea(
      /**
       * The area whose index is looked for
       */
      oArea: OverlayArea
    ): int;
    /**
     * Inserts a area into the aggregation {@link #getAreas areas}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertArea(
      /**
       * The area to insert; if empty, nothing is inserted
       */
      oArea: OverlayArea,
      /**
       * The `0`-based index the area should be inserted at; for a negative value of `iIndex`, the area is inserted
       * at position 0; for a value greater than the current size of the aggregation, the area is inserted at
       * the last position
       */
      iIndex: int
    ): this;
    /**
     * open the context menu
     */
    openContextMenu(
      /**
       * the context menu to be opened
       */
      oMenu: object
    ): void;
    /**
     * Removes all the controls from the aggregation {@link #getAreas areas}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllAreas(): OverlayArea[];
    /**
     * Removes a area from the aggregation {@link #getAreas areas}.
     *
     *
     * @returns The removed area or `null`
     */
    removeArea(
      /**
       * The area to remove or its index or id
       */
      vArea: int | string | OverlayArea
    ): OverlayArea | null;
    /**
     * Reset the Overlay to its initial size and position.
     *
     *
     * @returns This allows method chaining
     */
    reset(): Overlay;
    /**
     * Pan and Zoom for the Overlay. The offsets `nDeltaX` and `nDeltaY` are applied to the current
     * center position. If zooming is involved as well the offsets are applied after the zooming.
     */
    setPanAndZoom(
      /**
       * the move of the center in x-direction in pixels
       */
      nDeltaX: int,
      /**
       * the move of the center in y-direction in pixels
       */
      nDeltaY: int,
      /**
       * the zoom factor to apply to the current state
       */
      fZoom: float
    ): void;
    /**
     * Sets the associated {@link #getTarget target}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTarget(
      /**
       * ID of an element which becomes the new target of this target association; alternatively, an element instance
       * may be given
       */
      oTarget: ID | Control
    ): this;
    /**
     * Sets a new value for property {@link #getZoomOnResize zoomOnResize}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setZoomOnResize(
      /**
       * New value for property `zoomOnResize`
       */
      bZoomOnResize?: boolean
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Overlay constructor.
   *
   * @deprecated As of version 1.120. This is not in use anymore. Please consider using Redline tool, see
   * {@link sap.ui.vk.RedlineTool}
   */
  export interface $OverlaySettings extends $ControlSettings {
    zoomOnResize?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Aggregation of Highlight Areas.
     */
    areas?:
      | OverlayArea[]
      | OverlayArea
      | AggregationBindingInfo
      | `{${string}}`;

    /**
     * Aggregation of Highlight Areas.
     */
    target?: Control | string;

    /**
     * Raised when the Control is clicked.
     */
    click?: (oEvent: Overlay$ClickEvent) => void;

    /**
     * Raised when the Control is right clicked/longPress(tap and hold).
     */
    contextMenu?: (oEvent: Overlay$ContextMenuEvent) => void;
  }

  /**
   * Parameters of the Overlay#click event.
   */
  export interface Overlay$ClickEventParameters {
    /**
     * Client coordinate X
     */
    clientX?: int;

    /**
     * Client coordinate Y
     */
    clientY?: int;

    /**
     * Coordinates of click position in format "x;y;0"
     */
    pos?: string;
  }

  /**
   * Event object of the Overlay#click event.
   */
  export type Overlay$ClickEvent = Event<Overlay$ClickEventParameters, Overlay>;

  /**
   * Parameters of the Overlay#contextMenu event.
   */
  export interface Overlay$ContextMenuEventParameters {
    /**
     * Coordinates of click position in format "x;y;0"
     */
    pos?: string;

    /**
     * Menu to open
     */
    menu?: Menu;
  }

  /**
   * Event object of the Overlay#contextMenu event.
   */
  export type Overlay$ContextMenuEvent = Event<
    Overlay$ContextMenuEventParameters,
    Overlay
  >;
}

declare module "sap/ui/vk/OverlayArea" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import Event from "sap/ui/base/Event";

  import { CSSColor } from "sap/ui/core/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  import Menu from "sap/ui/unified/Menu";

  /**
   * Aggregation element for the Overlay Control
   *
   * @since 1.32.0
   * @deprecated As of version 1.120. This is not in use anymore. Please consider using Redline tool, see
   * {@link sap.ui.vk.RedlineTool}
   */
  export default class OverlayArea extends UI5Element {
    /**
     * Constructor for a new OverlayArea.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $OverlayAreaSettings
    );
    /**
     * Constructor for a new OverlayArea.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $OverlayAreaSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vk.OverlayArea with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, OverlayArea>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.OverlayArea.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:click click} event of this `sap.ui.vk.OverlayArea`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.OverlayArea` itself.
     *
     * The event is raised when there is a click action on an OverlayArea.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachClick(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.OverlayArea` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:click click} event of this `sap.ui.vk.OverlayArea`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.OverlayArea` itself.
     *
     * The event is raised when there is a click action on an OverlayArea.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachClick(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.OverlayArea` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:contextMenu contextMenu} event of this `sap.ui.vk.OverlayArea`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.OverlayArea` itself.
     *
     * The event is raised when there is a right click or a tap and hold action on an OverlayArea.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachContextMenu(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: OverlayArea$ContextMenuEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.OverlayArea` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:contextMenu contextMenu} event of this `sap.ui.vk.OverlayArea`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.OverlayArea` itself.
     *
     * The event is raised when there is a right click or a tap and hold action on an OverlayArea.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachContextMenu(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: OverlayArea$ContextMenuEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.OverlayArea` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:edgeClick edgeClick} event of this `sap.ui.vk.OverlayArea`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.OverlayArea` itself.
     *
     * This event is raised when the edge of an OverlayArea is clicked.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachEdgeClick(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: OverlayArea$EdgeClickEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.OverlayArea` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:edgeClick edgeClick} event of this `sap.ui.vk.OverlayArea`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.OverlayArea` itself.
     *
     * This event is raised when the edge of an OverlayArea is clicked.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachEdgeClick(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: OverlayArea$EdgeClickEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.OverlayArea` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:edgeContextMenu edgeContextMenu} event of this
     * `sap.ui.vk.OverlayArea`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.OverlayArea` itself.
     *
     * This event is raised when the edge of an OverlayArea is right clicked.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachEdgeContextMenu(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: OverlayArea$EdgeContextMenuEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.OverlayArea` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:edgeContextMenu edgeContextMenu} event of this
     * `sap.ui.vk.OverlayArea`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.OverlayArea` itself.
     *
     * This event is raised when the edge of an OverlayArea is right clicked.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachEdgeContextMenu(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: OverlayArea$EdgeContextMenuEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.OverlayArea` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:handleClick handleClick} event of this `sap.ui.vk.OverlayArea`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.OverlayArea` itself.
     *
     * This event is raised when the design handle of a changeable OverlayArea is clicked.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachHandleClick(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.OverlayArea` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:handleClick handleClick} event of this `sap.ui.vk.OverlayArea`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.OverlayArea` itself.
     *
     * This event is raised when the design handle of a changeable OverlayArea is clicked.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachHandleClick(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.OverlayArea` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:handleContextMenu handleContextMenu} event of
     * this `sap.ui.vk.OverlayArea`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.OverlayArea` itself.
     *
     * This event is raised when the design handle of a changeable OverlayArea is right clicked.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachHandleContextMenu(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: OverlayArea$HandleContextMenuEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.OverlayArea` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:handleContextMenu handleContextMenu} event of
     * this `sap.ui.vk.OverlayArea`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.OverlayArea` itself.
     *
     * This event is raised when the design handle of a changeable OverlayArea is right clicked.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachHandleContextMenu(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: OverlayArea$HandleContextMenuEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.OverlayArea` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:handleMoved handleMoved} event of this `sap.ui.vk.OverlayArea`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.OverlayArea` itself.
     *
     * This event is raised when the design handle of a changeable OverlayArea is moved.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachHandleMoved(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.OverlayArea` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:handleMoved handleMoved} event of this `sap.ui.vk.OverlayArea`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.OverlayArea` itself.
     *
     * This event is raised when the design handle of a changeable OverlayArea is moved.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachHandleMoved(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.OverlayArea` itself
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:click click} event of this `sap.ui.vk.OverlayArea`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachClick(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:contextMenu contextMenu} event of this `sap.ui.vk.OverlayArea`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachContextMenu(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: OverlayArea$ContextMenuEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:edgeClick edgeClick} event of this `sap.ui.vk.OverlayArea`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachEdgeClick(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: OverlayArea$EdgeClickEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:edgeContextMenu edgeContextMenu} event of
     * this `sap.ui.vk.OverlayArea`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachEdgeContextMenu(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: OverlayArea$EdgeContextMenuEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:handleClick handleClick} event of this `sap.ui.vk.OverlayArea`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachHandleClick(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:handleContextMenu handleContextMenu} event
     * of this `sap.ui.vk.OverlayArea`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachHandleContextMenu(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: OverlayArea$HandleContextMenuEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:handleMoved handleMoved} event of this `sap.ui.vk.OverlayArea`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachHandleMoved(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:click click} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireClick(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:contextMenu contextMenu} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireContextMenu(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: OverlayArea$ContextMenuEventParameters
    ): this;
    /**
     * Fires event {@link #event:edgeClick edgeClick} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireEdgeClick(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: OverlayArea$EdgeClickEventParameters
    ): this;
    /**
     * Fires event {@link #event:edgeContextMenu edgeContextMenu} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireEdgeContextMenu(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: OverlayArea$EdgeContextMenuEventParameters
    ): this;
    /**
     * Fires event {@link #event:handleClick handleClick} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireHandleClick(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:handleContextMenu handleContextMenu} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireHandleContextMenu(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: OverlayArea$HandleContextMenuEventParameters
    ): this;
    /**
     * Fires event {@link #event:handleMoved handleMoved} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireHandleMoved(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets current value of property {@link #getChangeable changeable}.
     *
     * Set to true if OverlayArea is changeable.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `changeable`
     */
    getChangeable(): boolean;
    /**
     * Gets current value of property {@link #getColor color}.
     *
     * The fill color of the OverlayArea.
     *
     * Default value is `"rgba(200, 50, 50, 0.3)"`.
     *
     *
     * @returns Value of property `color`
     */
    getColor(): CSSColor;
    /**
     * Gets current value of property {@link #getColorBorder colorBorder}.
     *
     * The border color of the OverlayArea.
     *
     * Default value is `"rgba(200, 50, 50, 1.0)"`.
     *
     *
     * @returns Value of property `colorBorder`
     */
    getColorBorder(): CSSColor;
    /**
     * Gets current value of property {@link #getColorNonSelect colorNonSelect}.
     *
     * The non-select color of the OverlayArea in case non-selection de-highlighting is desired.
     *
     *
     * @returns Value of property `colorNonSelect`
     */
    getColorNonSelect(): string;
    /**
     * Gets current value of property {@link #getColorSelect colorSelect}.
     *
     * The select color of the OverlayArea in case selection highlighting is desired.
     *
     *
     * @returns Value of property `colorSelect`
     */
    getColorSelect(): string;
    /**
     * Gets current value of property {@link #getDeltaColorHot deltaColorHot}.
     *
     * Color or color delta when object is hovered. Color deltas can be declared in the format RHLSA(;;;)
     *
     * Default value is `"RHLSA(0;1.3;1.0;1.0)"`.
     *
     *
     * @returns Value of property `deltaColorHot`
     */
    getDeltaColorHot(): string;
    /**
     * Gets current value of property {@link #getKey key}.
     *
     * Unique identifier for the object. This is optional. If not provided the default identifier sId is used.
     * However, sId is generated if template binding is used and thus it is not stable. Provide the key if the
     * object really needs a unique and stable identifier.
     *
     *
     * @returns Value of property `key`
     */
    getKey(): string;
    /**
     * Gets current value of property {@link #getPosition position}.
     *
     * The position array for the OverlayArea. The format is "x0;y0;0;...;xN,yN,0".
     *
     *
     * @returns Value of property `position`
     */
    getPosition(): string;
    /**
     * Gets current value of property {@link #getSelect select}.
     *
     * set to true if the element is selected
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `select`
     */
    getSelect(): boolean;
    /**
     * open the context menu
     */
    openContextMenu(
      /**
       * the context menu to be opened
       */
      oMenu: object
    ): void;
    /**
     * Sets a new value for property {@link #getChangeable changeable}.
     *
     * Set to true if OverlayArea is changeable.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setChangeable(
      /**
       * New value for property `changeable`
       */
      bChangeable?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getColor color}.
     *
     * The fill color of the OverlayArea.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"rgba(200, 50, 50, 0.3)"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setColor(
      /**
       * New value for property `color`
       */
      sColor?: CSSColor
    ): this;
    /**
     * Sets a new value for property {@link #getColorBorder colorBorder}.
     *
     * The border color of the OverlayArea.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"rgba(200, 50, 50, 1.0)"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setColorBorder(
      /**
       * New value for property `colorBorder`
       */
      sColorBorder?: CSSColor
    ): this;
    /**
     * Sets a new value for property {@link #getColorNonSelect colorNonSelect}.
     *
     * The non-select color of the OverlayArea in case non-selection de-highlighting is desired.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setColorNonSelect(
      /**
       * New value for property `colorNonSelect`
       */
      sColorNonSelect?: string
    ): this;
    /**
     * Sets a new value for property {@link #getColorSelect colorSelect}.
     *
     * The select color of the OverlayArea in case selection highlighting is desired.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setColorSelect(
      /**
       * New value for property `colorSelect`
       */
      sColorSelect?: string
    ): this;
    /**
     * Sets a new value for property {@link #getDeltaColorHot deltaColorHot}.
     *
     * Color or color delta when object is hovered. Color deltas can be declared in the format RHLSA(;;;)
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"RHLSA(0;1.3;1.0;1.0)"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDeltaColorHot(
      /**
       * New value for property `deltaColorHot`
       */
      sDeltaColorHot?: string
    ): this;
    /**
     * Sets a new value for property {@link #getKey key}.
     *
     * Unique identifier for the object. This is optional. If not provided the default identifier sId is used.
     * However, sId is generated if template binding is used and thus it is not stable. Provide the key if the
     * object really needs a unique and stable identifier.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setKey(
      /**
       * New value for property `key`
       */
      sKey?: string
    ): this;
    /**
     * Sets a new value for property {@link #getPosition position}.
     *
     * The position array for the OverlayArea. The format is "x0;y0;0;...;xN,yN,0".
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPosition(
      /**
       * New value for property `position`
       */
      sPosition?: string
    ): this;
    /**
     * Sets a new value for property {@link #getSelect select}.
     *
     * set to true if the element is selected
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSelect(
      /**
       * New value for property `select`
       */
      bSelect?: boolean
    ): this;
  }
  /**
   * Describes the settings that can be provided to the OverlayArea constructor.
   *
   * @deprecated As of version 1.120. This is not in use anymore. Please consider using Redline tool, see
   * {@link sap.ui.vk.RedlineTool}
   */
  export interface $OverlayAreaSettings extends $ElementSettings {
    /**
     * Unique identifier for the object. This is optional. If not provided the default identifier sId is used.
     * However, sId is generated if template binding is used and thus it is not stable. Provide the key if the
     * object really needs a unique and stable identifier.
     */
    key?: string | PropertyBindingInfo;

    /**
     * The position array for the OverlayArea. The format is "x0;y0;0;...;xN,yN,0".
     */
    position?: string | PropertyBindingInfo;

    /**
     * The fill color of the OverlayArea.
     */
    color?: CSSColor | PropertyBindingInfo | `{${string}}`;

    /**
     * The border color of the OverlayArea.
     */
    colorBorder?: CSSColor | PropertyBindingInfo | `{${string}}`;

    /**
     * The select color of the OverlayArea in case selection highlighting is desired.
     */
    colorSelect?: string | PropertyBindingInfo;

    /**
     * The non-select color of the OverlayArea in case non-selection de-highlighting is desired.
     */
    colorNonSelect?: string | PropertyBindingInfo;

    /**
     * Color or color delta when object is hovered. Color deltas can be declared in the format RHLSA(;;;)
     */
    deltaColorHot?: string | PropertyBindingInfo;

    /**
     * set to true if the element is selected
     */
    select?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Set to true if OverlayArea is changeable.
     */
    changeable?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * The event is raised when there is a click action on an OverlayArea.
     */
    click?: (oEvent: Event) => void;

    /**
     * The event is raised when there is a right click or a tap and hold action on an OverlayArea.
     */
    contextMenu?: (oEvent: OverlayArea$ContextMenuEvent) => void;

    /**
     * This event is raised when the edge of an OverlayArea is clicked.
     */
    edgeClick?: (oEvent: OverlayArea$EdgeClickEvent) => void;

    /**
     * This event is raised when the edge of an OverlayArea is right clicked.
     */
    edgeContextMenu?: (oEvent: OverlayArea$EdgeContextMenuEvent) => void;

    /**
     * This event is raised when the design handle of a changeable OverlayArea is moved.
     */
    handleMoved?: (oEvent: Event) => void;

    /**
     * This event is raised when the design handle of a changeable OverlayArea is right clicked.
     */
    handleContextMenu?: (oEvent: OverlayArea$HandleContextMenuEvent) => void;

    /**
     * This event is raised when the design handle of a changeable OverlayArea is clicked.
     */
    handleClick?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the OverlayArea#click event.
   */
  export interface OverlayArea$ClickEventParameters {}

  /**
   * Event object of the OverlayArea#click event.
   */
  export type OverlayArea$ClickEvent = Event<
    OverlayArea$ClickEventParameters,
    OverlayArea
  >;

  /**
   * Parameters of the OverlayArea#contextMenu event.
   */
  export interface OverlayArea$ContextMenuEventParameters {
    /**
     * Menu to open
     */
    menu?: Menu;
  }

  /**
   * Event object of the OverlayArea#contextMenu event.
   */
  export type OverlayArea$ContextMenuEvent = Event<
    OverlayArea$ContextMenuEventParameters,
    OverlayArea
  >;

  /**
   * Parameters of the OverlayArea#edgeClick event.
   */
  export interface OverlayArea$EdgeClickEventParameters {
    /**
     * Index of the clicked edge. The numbering is zero based and the first edge with index 0 starts at the
     * first position in the position array and end at the second.
     */
    index?: int;
  }

  /**
   * Event object of the OverlayArea#edgeClick event.
   */
  export type OverlayArea$EdgeClickEvent = Event<
    OverlayArea$EdgeClickEventParameters,
    OverlayArea
  >;

  /**
   * Parameters of the OverlayArea#edgeContextMenu event.
   */
  export interface OverlayArea$EdgeContextMenuEventParameters {
    /**
     * Index of the clicked edge. The numbering is zero based and the first edge with index 0 starts at the
     * first position in the position array and end at the second.
     */
    index?: int;

    /**
     * Menu to open
     */
    menu?: Menu;
  }

  /**
   * Event object of the OverlayArea#edgeContextMenu event.
   */
  export type OverlayArea$EdgeContextMenuEvent = Event<
    OverlayArea$EdgeContextMenuEventParameters,
    OverlayArea
  >;

  /**
   * Parameters of the OverlayArea#handleClick event.
   */
  export interface OverlayArea$HandleClickEventParameters {}

  /**
   * Event object of the OverlayArea#handleClick event.
   */
  export type OverlayArea$HandleClickEvent = Event<
    OverlayArea$HandleClickEventParameters,
    OverlayArea
  >;

  /**
   * Parameters of the OverlayArea#handleContextMenu event.
   */
  export interface OverlayArea$HandleContextMenuEventParameters {
    /**
     * Index of the clicked handle. The numbering is zero based.
     */
    index?: int;

    /**
     * Menu to open
     */
    menu?: Menu;
  }

  /**
   * Event object of the OverlayArea#handleContextMenu event.
   */
  export type OverlayArea$HandleContextMenuEvent = Event<
    OverlayArea$HandleContextMenuEventParameters,
    OverlayArea
  >;

  /**
   * Parameters of the OverlayArea#handleMoved event.
   */
  export interface OverlayArea$HandleMovedEventParameters {}

  /**
   * Event object of the OverlayArea#handleMoved event.
   */
  export type OverlayArea$HandleMovedEvent = Event<
    OverlayArea$HandleMovedEventParameters,
    OverlayArea
  >;
}

declare module "sap/ui/vk/pdf/Viewport" {
  import {
    default as ViewportBase,
    $ViewportBaseSettings,
  } from "sap/ui/vk/ViewportBase";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  import Event from "sap/ui/base/Event";

  /**
   * Enables displaying PDF content..
   *
   * @since 1.123.0
   */
  export default class Viewport extends ViewportBase {
    /**
     * Constructor for a new Viewport.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new Native Viewport control.
       */
      mSettings?: $ViewportSettings
    );
    /**
     * Constructor for a new Viewport.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new Native Viewport control, generated automatically if no ID is given.
       */
      sId?: string,
      /**
       * Initial settings for the new Native Viewport control.
       */
      mSettings?: $ViewportSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vk.pdf.Viewport with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.vk.ViewportBase.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Viewport>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.pdf.Viewport.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:documentReplaced documentReplaced} event of
     * this `sap.ui.vk.pdf.Viewport`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.pdf.Viewport` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDocumentReplaced(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Viewport$DocumentReplacedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.pdf.Viewport` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:documentReplaced documentReplaced} event of
     * this `sap.ui.vk.pdf.Viewport`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.pdf.Viewport` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDocumentReplaced(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Viewport$DocumentReplacedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.pdf.Viewport` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:pageChanged pageChanged} event of this `sap.ui.vk.pdf.Viewport`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.pdf.Viewport` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPageChanged(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Viewport$PageChangedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.pdf.Viewport` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:pageChanged pageChanged} event of this `sap.ui.vk.pdf.Viewport`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.pdf.Viewport` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPageChanged(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Viewport$PageChangedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.pdf.Viewport` itself
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:documentReplaced documentReplaced} event of
     * this `sap.ui.vk.pdf.Viewport`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachDocumentReplaced(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Viewport$DocumentReplacedEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:pageChanged pageChanged} event of this `sap.ui.vk.pdf.Viewport`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachPageChanged(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Viewport$PageChangedEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:documentReplaced documentReplaced} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireDocumentReplaced(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: Viewport$DocumentReplacedEventParameters
    ): this;
    /**
     * Fires event {@link #event:pageChanged pageChanged} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    firePageChanged(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: Viewport$PageChangedEventParameters
    ): this;
    /**
     * Gets current value of property {@link #getCurrentPageIndex currentPageIndex}.
     *
     * Default value is `0`.
     *
     *
     * @returns Value of property `currentPageIndex`
     */
    getCurrentPageIndex(): int;
    /**
     * Sets a new value for property {@link #getCurrentPageIndex currentPageIndex}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `0`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCurrentPageIndex(
      /**
       * New value for property `currentPageIndex`
       */
      iCurrentPageIndex?: int
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Viewport constructor.
   */
  export interface $ViewportSettings extends $ViewportBaseSettings {
    currentPageIndex?: int | PropertyBindingInfo | `{${string}}`;

    pageChanged?: (oEvent: Viewport$PageChangedEvent) => void;

    documentReplaced?: (oEvent: Viewport$DocumentReplacedEvent) => void;
  }

  /**
   * Parameters of the Viewport#documentReplaced event.
   */
  export interface Viewport$DocumentReplacedEventParameters {
    oldDocument?: /* was: sap.ui.vk.pdf.Document */ any;

    newDocument?: /* was: sap.ui.vk.pdf.Document */ any;
  }

  /**
   * Event object of the Viewport#documentReplaced event.
   */
  export type Viewport$DocumentReplacedEvent = Event<
    Viewport$DocumentReplacedEventParameters,
    Viewport
  >;

  /**
   * Parameters of the Viewport#pageChanged event.
   */
  export interface Viewport$PageChangedEventParameters {
    newPageIndex?: int;

    oldPageIndex?: int;
  }

  /**
   * Event object of the Viewport#pageChanged event.
   */
  export type Viewport$PageChangedEvent = Event<
    Viewport$PageChangedEventParameters,
    Viewport
  >;
}

declare module "sap/ui/vk/PerspectiveCamera" {
  import { default as Camera, $CameraSettings } from "sap/ui/vk/Camera";

  import ManagedObjectMetadata from "sap/ui/base/ManagedObjectMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Provides the interface for the perspective camera.
   *
   * @since 1.52.0
   */
  export default class PerspectiveCamera extends Camera {
    /**
     * Constructor for a new perspective camera.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor();

    /**
     * Creates a new subclass of class sap.ui.vk.PerspectiveCamera with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.vk.Camera.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, PerspectiveCamera>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.PerspectiveCamera.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ManagedObjectMetadata;
    /**
     * Gets current value of property {@link #getFov fov}.
     *
     * Camera frustum field of view in degree
     *
     *
     * @returns Value of property `fov`
     */
    getFov(): float;
    /**
     * Sets a new value for property {@link #getFov fov}.
     *
     * Camera frustum field of view in degree
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFov(
      /**
       * New value for property `fov`
       */
      fFov: float
    ): this;
  }
  /**
   * Describes the settings that can be provided to the PerspectiveCamera constructor.
   */
  export interface $PerspectiveCameraSettings extends $CameraSettings {
    /**
     * Camera frustum field of view in degree
     */
    fov?: float | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/ui/vk/ProgressIndicator" {
  import {
    default as ProgressIndicator1,
    $ProgressIndicatorSettings as $ProgressIndicatorSettings1,
  } from "sap/m/ProgressIndicator";

  /**
   * Shows the progress of a process in a graphical way. To indicate the progress, the inside of the ProgressIndicator
   * is filled with a color. Additionally, a user-defined string can be displayed on the ProgressIndicator.
   *
   * @since 1.50.0
   * @deprecated As of version 1.114.0. Use {@link sap.m.ProgressIndicator} instead.
   */
  export default class ProgressIndicator extends ProgressIndicator1 {
    /**
     * Constructor for a new ProgressIndicator.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $ProgressIndicatorSettings
    );
    /**
     * Constructor for a new ProgressIndicator.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $ProgressIndicatorSettings
    );
  }
  /**
   * Describes the settings that can be provided to the ProgressIndicator constructor.
   *
   * @deprecated As of version 1.114.0. Use {@link sap.m.ProgressIndicator} instead.
   */
  export interface $ProgressIndicatorSettings
    extends $ProgressIndicatorSettings1 {}
}

declare module "sap/ui/vk/RedlineCollaboration" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import RedlineConversation from "sap/ui/vk/RedlineConversation";

  import { ID } from "sap/ui/core/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { AggregationBindingInfo } from "sap/ui/base/ManagedObject";

  import Viewport from "sap/ui/vk/Viewport";

  import Event from "sap/ui/base/Event";

  /**
   * Provides a base class control for RedlineCollaborations.
   *
   * @since 1.89.0
   */
  export default class RedlineCollaboration extends UI5Element {
    /**
     * Constructor for a new RedlineCollaboration.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor();

    /**
     * Creates a new subclass of class sap.ui.vk.RedlineCollaboration with name `sClassName` and enriches it
     * with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, RedlineCollaboration>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.RedlineCollaboration.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some conversation to the aggregation {@link #getConversations conversations}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addConversation(
      /**
       * The conversation to add; if empty, nothing is inserted
       */
      oConversation: RedlineConversation
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:conversationActivated conversationActivated }
     * event of this `sap.ui.vk.RedlineCollaboration`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.RedlineCollaboration` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachConversationActivated(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: RedlineCollaboration$ConversationActivatedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.RedlineCollaboration` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:conversationActivated conversationActivated }
     * event of this `sap.ui.vk.RedlineCollaboration`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.RedlineCollaboration` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachConversationActivated(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: RedlineCollaboration$ConversationActivatedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.RedlineCollaboration` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:conversationActivating conversationActivating }
     * event of this `sap.ui.vk.RedlineCollaboration`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.RedlineCollaboration` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachConversationActivating(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (
        p1: RedlineCollaboration$ConversationActivatingEvent
      ) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.RedlineCollaboration` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:conversationActivating conversationActivating }
     * event of this `sap.ui.vk.RedlineCollaboration`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.RedlineCollaboration` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachConversationActivating(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (
        p1: RedlineCollaboration$ConversationActivatingEvent
      ) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.RedlineCollaboration` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:elementClicked elementClicked} event of this
     * `sap.ui.vk.RedlineCollaboration`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.RedlineCollaboration` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachElementClicked(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: RedlineCollaboration$ElementClickedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.RedlineCollaboration` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:elementClicked elementClicked} event of this
     * `sap.ui.vk.RedlineCollaboration`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.RedlineCollaboration` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachElementClicked(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: RedlineCollaboration$ElementClickedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.RedlineCollaboration` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:elementCreated elementCreated} event of this
     * `sap.ui.vk.RedlineCollaboration`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.RedlineCollaboration` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachElementCreated(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: RedlineCollaboration$ElementCreatedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.RedlineCollaboration` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:elementCreated elementCreated} event of this
     * `sap.ui.vk.RedlineCollaboration`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.RedlineCollaboration` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachElementCreated(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: RedlineCollaboration$ElementCreatedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.RedlineCollaboration` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:elementHovered elementHovered} event of this
     * `sap.ui.vk.RedlineCollaboration`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.RedlineCollaboration` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachElementHovered(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: RedlineCollaboration$ElementHoveredEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.RedlineCollaboration` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:elementHovered elementHovered} event of this
     * `sap.ui.vk.RedlineCollaboration`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.RedlineCollaboration` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachElementHovered(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: RedlineCollaboration$ElementHoveredEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.RedlineCollaboration` itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys all the conversations in the aggregation {@link #getConversations conversations}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyConversations(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:conversationActivated conversationActivated }
     * event of this `sap.ui.vk.RedlineCollaboration`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachConversationActivated(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: RedlineCollaboration$ConversationActivatedEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:conversationActivating conversationActivating }
     * event of this `sap.ui.vk.RedlineCollaboration`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachConversationActivating(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (
        p1: RedlineCollaboration$ConversationActivatingEvent
      ) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:elementClicked elementClicked} event of this
     * `sap.ui.vk.RedlineCollaboration`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachElementClicked(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: RedlineCollaboration$ElementClickedEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:elementCreated elementCreated} event of this
     * `sap.ui.vk.RedlineCollaboration`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachElementCreated(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: RedlineCollaboration$ElementCreatedEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:elementHovered elementHovered} event of this
     * `sap.ui.vk.RedlineCollaboration`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachElementHovered(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: RedlineCollaboration$ElementHoveredEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:conversationActivated conversationActivated} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireConversationActivated(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: RedlineCollaboration$ConversationActivatedEventParameters
    ): this;
    /**
     * Fires event {@link #event:conversationActivating conversationActivating} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireConversationActivating(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: RedlineCollaboration$ConversationActivatingEventParameters
    ): this;
    /**
     * Fires event {@link #event:elementClicked elementClicked} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireElementClicked(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: RedlineCollaboration$ElementClickedEventParameters
    ): this;
    /**
     * Fires event {@link #event:elementCreated elementCreated} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireElementCreated(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: RedlineCollaboration$ElementCreatedEventParameters
    ): this;
    /**
     * Fires event {@link #event:elementHovered elementHovered} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireElementHovered(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: RedlineCollaboration$ElementHoveredEventParameters
    ): this;
    /**
     * ID of the element which is the current target of the association {@link #getActiveComment activeComment},
     * or `null`.
     */
    getActiveComment(): ID | null;
    /**
     * ID of the element which is the current target of the association {@link #getActiveConversation activeConversation},
     * or `null`.
     */
    getActiveConversation(): ID | null;
    /**
     * Gets content of aggregation {@link #getConversations conversations}.
     *
     * A list of available conversations.
     */
    getConversations(): RedlineConversation[];
    /**
     * ID of the element which is the current target of the association {@link #getViewport viewport}, or `null`.
     */
    getViewport(): ID | null;
    /**
     * Checks for the provided `sap.ui.vk.RedlineConversation` in the aggregation {@link #getConversations conversations}.
     * and returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfConversation(
      /**
       * The conversation whose index is looked for
       */
      oConversation: RedlineConversation
    ): int;
    /**
     * Inserts a conversation into the aggregation {@link #getConversations conversations}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertConversation(
      /**
       * The conversation to insert; if empty, nothing is inserted
       */
      oConversation: RedlineConversation,
      /**
       * The `0`-based index the conversation should be inserted at; for a negative value of `iIndex`, the conversation
       * is inserted at position 0; for a value greater than the current size of the aggregation, the conversation
       * is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getConversations conversations}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllConversations(): RedlineConversation[];
    /**
     * Removes a conversation from the aggregation {@link #getConversations conversations}.
     *
     *
     * @returns The removed conversation or `null`
     */
    removeConversation(
      /**
       * The conversation to remove or its index or id
       */
      vConversation: int | string | RedlineConversation
    ): RedlineConversation | null;
    /**
     * Sets the associated {@link #getActiveComment activeComment}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setActiveComment(
      /**
       * ID of an element which becomes the new target of this activeComment association; alternatively, an element
       * instance may be given
       */
      oActiveComment: ID | /* was: sap.ui.vk.RedlineComment */ any
    ): this;
  }
  /**
   * Describes the settings that can be provided to the RedlineCollaboration constructor.
   */
  export interface $RedlineCollaborationSettings extends $ElementSettings {
    /**
     * A list of available conversations.
     */
    conversations?:
      | RedlineConversation[]
      | RedlineConversation
      | AggregationBindingInfo
      | `{${string}}`;

    viewport?: Viewport | string;

    /**
     * Currently active conversation.
     */
    activeConversation?: RedlineConversation | string;

    /**
     * Currently active comment.
     */
    activeComment?: /* was: sap.ui.vk.RedlineComment */ any | string;

    elementCreated?: (oEvent: RedlineCollaboration$ElementCreatedEvent) => void;

    elementClicked?: (oEvent: RedlineCollaboration$ElementClickedEvent) => void;

    elementHovered?: (oEvent: RedlineCollaboration$ElementHoveredEvent) => void;

    conversationActivating?: (
      oEvent: RedlineCollaboration$ConversationActivatingEvent
    ) => void;

    conversationActivated?: (
      oEvent: RedlineCollaboration$ConversationActivatedEvent
    ) => void;
  }

  /**
   * Parameters of the RedlineCollaboration#conversationActivated event.
   */
  export interface RedlineCollaboration$ConversationActivatedEventParameters {
    conversation?: RedlineConversation;

    viewportLocked?: boolean;
  }

  /**
   * Event object of the RedlineCollaboration#conversationActivated event.
   */
  export type RedlineCollaboration$ConversationActivatedEvent = Event<
    RedlineCollaboration$ConversationActivatedEventParameters,
    RedlineCollaboration
  >;

  /**
   * Parameters of the RedlineCollaboration#conversationActivating event.
   */
  export interface RedlineCollaboration$ConversationActivatingEventParameters {
    conversation?: RedlineConversation;
  }

  /**
   * Event object of the RedlineCollaboration#conversationActivating event.
   */
  export type RedlineCollaboration$ConversationActivatingEvent = Event<
    RedlineCollaboration$ConversationActivatingEventParameters,
    RedlineCollaboration
  >;

  /**
   * Parameters of the RedlineCollaboration#elementClicked event.
   */
  export interface RedlineCollaboration$ElementClickedEventParameters {
    elementId?: string;
  }

  /**
   * Event object of the RedlineCollaboration#elementClicked event.
   */
  export type RedlineCollaboration$ElementClickedEvent = Event<
    RedlineCollaboration$ElementClickedEventParameters,
    RedlineCollaboration
  >;

  /**
   * Parameters of the RedlineCollaboration#elementCreated event.
   */
  export interface RedlineCollaboration$ElementCreatedEventParameters {
    element?: object;
  }

  /**
   * Event object of the RedlineCollaboration#elementCreated event.
   */
  export type RedlineCollaboration$ElementCreatedEvent = Event<
    RedlineCollaboration$ElementCreatedEventParameters,
    RedlineCollaboration
  >;

  /**
   * Parameters of the RedlineCollaboration#elementHovered event.
   */
  export interface RedlineCollaboration$ElementHoveredEventParameters {
    elementId?: string;
  }

  /**
   * Event object of the RedlineCollaboration#elementHovered event.
   */
  export type RedlineCollaboration$ElementHoveredEvent = Event<
    RedlineCollaboration$ElementHoveredEventParameters,
    RedlineCollaboration
  >;
}

declare module "sap/ui/vk/RedlineConversation" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import RedlineElementComment from "sap/ui/vk/RedlineElementComment";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  /**
   * Provides a base class control for RedlineConversations.
   *
   * @since 1.89.0
   */
  export default class RedlineConversation extends UI5Element {
    /**
     * Constructor for a new RedlineConversation.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor();

    /**
     * Creates a new subclass of class sap.ui.vk.RedlineConversation with name `sClassName` and enriches it
     * with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, RedlineConversation>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.RedlineConversation.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some comment to the aggregation {@link #getComments comments}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addComment(
      /**
       * The comment to add; if empty, nothing is inserted
       */
      oComment: RedlineElementComment
    ): this;
    /**
     * Destroys all the comments in the aggregation {@link #getComments comments}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyComments(): this;
    /**
     * Gets current value of property {@link #getAnimationOffset animationOffset}.
     *
     * Default value is `0`.
     *
     *
     * @returns Value of property `animationOffset`
     */
    getAnimationOffset(): float;
    /**
     * Gets content of aggregation {@link #getComments comments}.
     */
    getComments(): RedlineElementComment[];
    /**
     * Gets current value of property {@link #getConversationName conversationName}.
     *
     *
     * @returns Value of property `conversationName`
     */
    getConversationName(): string;
    /**
     * Gets current value of property {@link #getMeasurementScale measurementScale}.
     *
     * Default value is `1`.
     *
     *
     * @returns Value of property `measurementScale`
     */
    getMeasurementScale(): float;
    /**
     * Gets current value of property {@link #getPageId pageId}.
     *
     * Default value is `-1`.
     *
     *
     * @returns Value of property `pageId`
     */
    getPageId(): int;
    /**
     * Gets current value of property {@link #getTimestamp timestamp}.
     *
     *
     * @returns Value of property `timestamp`
     */
    getTimestamp(): int;
    /**
     * Gets current value of property {@link #getViewId viewId}.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `viewId`
     */
    getViewId(): string;
    /**
     * Gets current value of property {@link #getViewInfo viewInfo}.
     *
     *
     * @returns Value of property `viewInfo`
     */
    getViewInfo(): any;
    /**
     * Checks for the provided `sap.ui.vk.RedlineElementComment` in the aggregation {@link #getComments comments}.
     * and returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfComment(
      /**
       * The comment whose index is looked for
       */
      oComment: RedlineElementComment
    ): int;
    /**
     * Inserts a comment into the aggregation {@link #getComments comments}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertComment(
      /**
       * The comment to insert; if empty, nothing is inserted
       */
      oComment: RedlineElementComment,
      /**
       * The `0`-based index the comment should be inserted at; for a negative value of `iIndex`, the comment
       * is inserted at position 0; for a value greater than the current size of the aggregation, the comment
       * is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getComments comments}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllComments(): RedlineElementComment[];
    /**
     * Removes a comment from the aggregation {@link #getComments comments}.
     *
     *
     * @returns The removed comment or `null`
     */
    removeComment(
      /**
       * The comment to remove or its index or id
       */
      vComment: int | string | RedlineElementComment
    ): RedlineElementComment | null;
    /**
     * Sets a new value for property {@link #getAnimationOffset animationOffset}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `0`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAnimationOffset(
      /**
       * New value for property `animationOffset`
       */
      fAnimationOffset?: float
    ): this;
    /**
     * Sets a new value for property {@link #getConversationName conversationName}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setConversationName(
      /**
       * New value for property `conversationName`
       */
      sConversationName: string
    ): this;
    /**
     * Sets a new value for property {@link #getMeasurementScale measurementScale}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `1`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMeasurementScale(
      /**
       * New value for property `measurementScale`
       */
      fMeasurementScale?: float
    ): this;
    /**
     * Sets a new value for property {@link #getPageId pageId}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `-1`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPageId(
      /**
       * New value for property `pageId`
       */
      iPageId?: int
    ): this;
    /**
     * Sets a new value for property {@link #getTimestamp timestamp}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTimestamp(
      /**
       * New value for property `timestamp`
       */
      iTimestamp: int
    ): this;
    /**
     * Sets a new value for property {@link #getViewId viewId}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setViewId(
      /**
       * New value for property `viewId`
       */
      sViewId?: string
    ): this;
    /**
     * Sets a new value for property {@link #getViewInfo viewInfo}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setViewInfo(
      /**
       * New value for property `viewInfo`
       */
      oViewInfo?: any
    ): this;
  }
  /**
   * Describes the settings that can be provided to the RedlineConversation constructor.
   */
  export interface $RedlineConversationSettings extends $ElementSettings {
    conversationName?: string | PropertyBindingInfo;

    timestamp?: int | PropertyBindingInfo | `{${string}}`;

    viewId?: string | PropertyBindingInfo;

    viewInfo?: any | PropertyBindingInfo | `{${string}}`;

    animationOffset?: float | PropertyBindingInfo | `{${string}}`;

    measurementScale?: float | PropertyBindingInfo | `{${string}}`;

    pageId?: int | PropertyBindingInfo | `{${string}}`;

    comments?:
      | RedlineElementComment[]
      | RedlineElementComment
      | AggregationBindingInfo
      | `{${string}}`;
  }
}

declare module "sap/ui/vk/RedlineDesign" {
  import {
    default as RedlineSurface,
    $RedlineSurfaceSettings,
  } from "sap/ui/vk/RedlineSurface";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import RedlineElement from "sap/ui/vk/RedlineElement";

  import Event from "sap/ui/base/Event";

  /**
   * Provides a control for designing redlining shapes.
   *
   * @since 1.40.0
   */
  export default class RedlineDesign extends RedlineSurface {
    /**
     * Constructor for a new RedlineDesign.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor();

    /**
     * Creates a new subclass of class sap.ui.vk.RedlineDesign with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.vk.RedlineSurface.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, RedlineDesign>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.RedlineDesign.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:elementCreated elementCreated} event of this
     * `sap.ui.vk.RedlineDesign`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.RedlineDesign` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachElementCreated(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: RedlineDesign$ElementCreatedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.RedlineDesign` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:elementCreated elementCreated} event of this
     * `sap.ui.vk.RedlineDesign`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.RedlineDesign` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachElementCreated(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: RedlineDesign$ElementCreatedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.RedlineDesign` itself
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:elementCreated elementCreated} event of this
     * `sap.ui.vk.RedlineDesign`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachElementCreated(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: RedlineDesign$ElementCreatedEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:elementCreated elementCreated} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireElementCreated(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: RedlineDesign$ElementCreatedEventParameters
    ): this;
    /**
     * Prepares the RedlineDesign control for adding a new instance of {sap.ui.vk.RedlineElement}.
     *
     *
     * @returns `this` to allow method chaining.
     */
    startAdding(
      /**
       * The redlining element which needs to be added.
       */
      elementInstance: RedlineElement
    ): this;
    /**
     * Stops the mode for adding redlining, which begins when the {@link sap.ui.vk.RedlineDesign#startAdding startAdding }
     * method is called.
     *
     *
     * @returns `this` to allow method chaining.
     */
    stopAdding(): this;
  }
  /**
   * Describes the settings that can be provided to the RedlineDesign constructor.
   */
  export interface $RedlineDesignSettings extends $RedlineSurfaceSettings {
    elementCreated?: (oEvent: RedlineDesign$ElementCreatedEvent) => void;
  }

  /**
   * Parameters of the RedlineDesign#elementCreated event.
   */
  export interface RedlineDesign$ElementCreatedEventParameters {
    element?: object;
  }

  /**
   * Event object of the RedlineDesign#elementCreated event.
   */
  export type RedlineDesign$ElementCreatedEvent = Event<
    RedlineDesign$ElementCreatedEventParameters,
    RedlineDesign
  >;
}

declare module "sap/ui/vk/RedlineElement" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { CSSColor } from "sap/ui/core/library";

  import RenderManager from "sap/ui/core/RenderManager";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Provides a base class for redline elements.
   *
   * @since 1.40.0
   */
  export default class RedlineElement extends UI5Element {
    /**
     * Base class for redline elements such as {@link sap.ui.vk.RedlineElementRectangle}, {@link sap.ui.vk.RedlineElementEllipse},
     * {@link sap.ui.vk.RedlineElementFreehand}, {@link sap.ui.vk.RedlineElementLine}, {@link sap.ui.vk.RedlineElementText}.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor();

    /**
     * Creates a new subclass of class sap.ui.vk.RedlineElement with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, RedlineElement>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.RedlineElement.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Exports all the relevant data contained in the redline element to a JSON-like object.
     *
     *
     * @returns JSON Relevant data that can be serialized and later used to restore the redline element.
     */
    exportJSON(): object;
    /**
     * Exports all the relevant data contained in the redline element to an SVG shape element.
     *
     *
     * @returns SVG shape element that can be used to restore the redline element.
     */
    exportSVG(): object;
    /**
     * Gets current value of property {@link #getCreatedByUser createdByUser}.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `createdByUser`
     */
    getCreatedByUser(): any;
    /**
     * Gets current value of property {@link #getCreateTimestamp createTimestamp}.
     *
     *
     * @returns Value of property `createTimestamp`
     */
    getCreateTimestamp(): int;
    /**
     * Gets current value of property {@link #getDeletedByUser deletedByUser}.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `deletedByUser`
     */
    getDeletedByUser(): any;
    /**
     * Gets current value of property {@link #getDeleteTimestamp deleteTimestamp}.
     *
     *
     * @returns Value of property `deleteTimestamp`
     */
    getDeleteTimestamp(): int;
    /**
     * Gets current value of property {@link #getElementId elementId}.
     *
     *
     * @returns Value of property `elementId`
     */
    getElementId(): string;
    /**
     * Gets current value of property {@link #getHalo halo}.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `halo`
     */
    getHalo(): boolean;
    /**
     * Gets current value of property {@link #getHaloColor haloColor}.
     *
     * Default value is `"rgba(255, 0, 0, 1)"`.
     *
     *
     * @returns Value of property `haloColor`
     */
    getHaloColor(): string;
    /**
     * Gets current value of property {@link #getOpacity opacity}.
     *
     * Default value is `1`.
     *
     *
     * @returns Value of property `opacity`
     */
    getOpacity(): float;
    /**
     * Gets current value of property {@link #getOriginX originX}.
     *
     * Default value is `0`.
     *
     *
     * @returns Value of property `originX`
     */
    getOriginX(): float;
    /**
     * Gets current value of property {@link #getOriginY originY}.
     *
     * Default value is `0`.
     *
     *
     * @returns Value of property `originY`
     */
    getOriginY(): float;
    /**
     * Gets current value of property {@link #getStrokeColor strokeColor}.
     *
     * Default value is `"#e6600d"`.
     *
     *
     * @returns Value of property `strokeColor`
     */
    getStrokeColor(): CSSColor;
    /**
     * Gets current value of property {@link #getStrokeDashArray strokeDashArray}.
     *
     * Default value is `[]`.
     *
     *
     * @returns Value of property `strokeDashArray`
     */
    getStrokeDashArray(): float[];
    /**
     * Gets current value of property {@link #getStrokeWidth strokeWidth}.
     *
     * Default value is `2`.
     *
     *
     * @returns Value of property `strokeWidth`
     */
    getStrokeWidth(): float;
    /**
     * Gets current value of property {@link #getSuppress suppress}.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `suppress`
     */
    getSuppress(): boolean;
    /**
     * Imports data from a JSON-like object into the redline element.
     *
     *
     * @returns `this` to allow method chaining.
     */
    importJSON(
      /**
       * Relevant data that can be used to restore the redline element.
       */
      json: object
    ): this;
    /**
     * Imports data from an SVG shape element into the redline element.
     *
     *
     * @returns `this` to allow method chaining.
     */
    importSVG(
      /**
       * SVG shape element that can be used to restore the redline element.
       */
      svg: object
    ): this;
    /**
     * This method is called by the RenderManager. The current method is empty because this is a base class
     * and the classes extending this class have their own implementations of the `render` method.
     */
    render(
      /**
       * Instance of RenderManager.
       */
      renderManager: RenderManager
    ): void;
    /**
     * This method is called by the RenderManager. The current method is empty because this is a base class
     * and the classes extending this class have their own implementations of the `render` method.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    renderElement(
      /**
       * Instance of RenderManager.
       */
      renderManager: RenderManager,
      /**
       * If set to true then halo effect is rendered, otherwise this will do normal object rendering
       */
      halo: boolean
    ): void;
    /**
     * Sets a new value for property {@link #getCreatedByUser createdByUser}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCreatedByUser(
      /**
       * New value for property `createdByUser`
       */
      oCreatedByUser?: any
    ): this;
    /**
     * Sets a new value for property {@link #getCreateTimestamp createTimestamp}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCreateTimestamp(
      /**
       * New value for property `createTimestamp`
       */
      iCreateTimestamp?: int
    ): this;
    /**
     * Sets a new value for property {@link #getDeletedByUser deletedByUser}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDeletedByUser(
      /**
       * New value for property `deletedByUser`
       */
      oDeletedByUser?: any
    ): this;
    /**
     * Sets a new value for property {@link #getDeleteTimestamp deleteTimestamp}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDeleteTimestamp(
      /**
       * New value for property `deleteTimestamp`
       */
      iDeleteTimestamp?: int
    ): this;
    /**
     * Sets a new value for property {@link #getElementId elementId}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setElementId(
      /**
       * New value for property `elementId`
       */
      sElementId?: string
    ): this;
    /**
     * Sets a new value for property {@link #getHalo halo}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHalo(
      /**
       * New value for property `halo`
       */
      bHalo?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getHaloColor haloColor}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"rgba(255, 0, 0, 1)"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHaloColor(
      /**
       * New value for property `haloColor`
       */
      sHaloColor?: string
    ): this;
    /**
     * Sets a new value for property {@link #getOpacity opacity}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `1`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setOpacity(
      /**
       * New value for property `opacity`
       */
      fOpacity?: float
    ): this;
    /**
     * Sets a new value for property {@link #getOriginX originX}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `0`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setOriginX(
      /**
       * New value for property `originX`
       */
      fOriginX?: float
    ): this;
    /**
     * Sets a new value for property {@link #getOriginY originY}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `0`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setOriginY(
      /**
       * New value for property `originY`
       */
      fOriginY?: float
    ): this;
    /**
     * Sets a new value for property {@link #getStrokeColor strokeColor}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"#e6600d"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setStrokeColor(
      /**
       * New value for property `strokeColor`
       */
      sStrokeColor?: CSSColor
    ): this;
    /**
     * Sets a new value for property {@link #getStrokeDashArray strokeDashArray}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `[]`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setStrokeDashArray(
      /**
       * New value for property `strokeDashArray`
       */
      sStrokeDashArray?: float[]
    ): this;
    /**
     * Sets a new value for property {@link #getStrokeWidth strokeWidth}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `2`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setStrokeWidth(
      /**
       * New value for property `strokeWidth`
       */
      fStrokeWidth?: float
    ): this;
    /**
     * Sets a new value for property {@link #getSuppress suppress}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSuppress(
      /**
       * New value for property `suppress`
       */
      bSuppress?: boolean
    ): this;
  }
  /**
   * Describes the settings that can be provided to the RedlineElement constructor.
   */
  export interface $RedlineElementSettings extends $ElementSettings {
    originX?: float | PropertyBindingInfo | `{${string}}`;

    originY?: float | PropertyBindingInfo | `{${string}}`;

    opacity?: float | PropertyBindingInfo | `{${string}}`;

    strokeWidth?: float | PropertyBindingInfo | `{${string}}`;

    strokeColor?: CSSColor | PropertyBindingInfo | `{${string}}`;

    strokeDashArray?: float[] | PropertyBindingInfo | `{${string}}`;

    halo?: boolean | PropertyBindingInfo | `{${string}}`;

    haloColor?: string | PropertyBindingInfo;

    createdByUser?: any | PropertyBindingInfo | `{${string}}`;

    createTimestamp?: int | PropertyBindingInfo | `{${string}}`;

    deletedByUser?: any | PropertyBindingInfo | `{${string}}`;

    deleteTimestamp?: int | PropertyBindingInfo | `{${string}}`;

    suppress?: boolean | PropertyBindingInfo | `{${string}}`;

    elementId?: string | PropertyBindingInfo;
  }
}

declare module "sap/ui/vk/RedlineElementComment" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Provides a control for creating RedlineElementComments.
   *
   * @since 1.89.0
   */
  export default class RedlineElementComment extends UI5Element {
    /**
     * Redline element control for comment.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor();

    /**
     * Creates a new subclass of class sap.ui.vk.RedlineElementComment with name `sClassName` and enriches it
     * with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, RedlineElementComment>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.RedlineElementComment.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getCreatedByUser createdByUser}.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `createdByUser`
     */
    getCreatedByUser(): any;
    /**
     * Gets current value of property {@link #getCreateTimestamp createTimestamp}.
     *
     *
     * @returns Value of property `createTimestamp`
     */
    getCreateTimestamp(): int;
    /**
     * Gets current value of property {@link #getText text}.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `text`
     */
    getText(): string;
    /**
     * Sets a new value for property {@link #getCreatedByUser createdByUser}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCreatedByUser(
      /**
       * New value for property `createdByUser`
       */
      oCreatedByUser?: any
    ): this;
    /**
     * Sets a new value for property {@link #getCreateTimestamp createTimestamp}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCreateTimestamp(
      /**
       * New value for property `createTimestamp`
       */
      iCreateTimestamp?: int
    ): this;
    /**
     * Sets a new value for property {@link #getText text}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setText(
      /**
       * New value for property `text`
       */
      sText?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the RedlineElementComment constructor.
   */
  export interface $RedlineElementCommentSettings extends $ElementSettings {
    text?: string | PropertyBindingInfo;

    createdByUser?: any | PropertyBindingInfo | `{${string}}`;

    createTimestamp?: int | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/ui/vk/RedlineElementEllipse" {
  import {
    default as RedlineElement,
    $RedlineElementSettings,
  } from "sap/ui/vk/RedlineElement";

  import { CSSColor } from "sap/ui/core/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Provides a control for creating ellipse redline elements.
   *
   * @since 1.40.0
   */
  export default class RedlineElementEllipse extends RedlineElement {
    /**
     * Redline element control for ellipse.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor();

    /**
     * Creates a new subclass of class sap.ui.vk.RedlineElementEllipse with name `sClassName` and enriches it
     * with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.vk.RedlineElement.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, RedlineElementEllipse>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.RedlineElementEllipse.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Changes the current radiusX and radiusY of the ellipse redline element by a factor which gets passed
     * as parameter.
     *
     *
     * @returns `this` to allow method chaining.
     */
    applyZoom(
      /**
       * The factor to be applied to the current radiusX and radiusY.
       */
      zoomBy: number
    ): this;
    /**
     * Changes the current radiusX, radiusY, originX and originY of the ellipse redline element with the values
     * passed as parameters.
     *
     *
     * @returns `this` to allow method chaining.
     */
    edit(
      /**
       * The value in pixels that radiusX and originX will be calculated from for the ellipse.
       */
      offsetX: number,
      /**
       * The value in pixels that radiusY and originY will be calculated from for the ellipse.
       */
      offsetY: number,
      /**
       * True if the element is circle or False/Undefined otherwise.
       */
      isCircle: boolean
    ): this;
    /**
     * Exports all the relevant data contained in the ellipse redline element to a JSON object.
     *
     *
     * @returns Data that can be serialized and later used to restore the ellipse redline element.
     */
    exportJSON(): object;
    /**
     * Exports all the relevant data contained in the ellipse redline element to an SVG ellipse element.
     *
     *
     * @returns SVG ellipse element that can be used to restore the ellipse redline element.
     */
    exportSVG(): object;
    /**
     * Gets current value of property {@link #getFillColor fillColor}.
     *
     * Default value is `"rgba(0, 0, 0, 0)"`.
     *
     *
     * @returns Value of property `fillColor`
     */
    getFillColor(): CSSColor;
    /**
     * Gets current value of property {@link #getRadiusX radiusX}.
     *
     * Default value is `0.0001`.
     *
     *
     * @returns Value of property `radiusX`
     */
    getRadiusX(): float;
    /**
     * Gets current value of property {@link #getRadiusY radiusY}.
     *
     * Default value is `0.0001`.
     *
     *
     * @returns Value of property `radiusY`
     */
    getRadiusY(): float;
    /**
     * Imports data from a JSON object into the ellipse redline element.
     *
     *
     * @returns `this` to allow method chaining.
     */
    importJSON(
      /**
       * Relevant data used to restore the ellipse redline element.
       */
      json: object
    ): this;
    /**
     * Imports data from an SVG ellipse element into the ellipse redline element.
     *
     *
     * @returns `this` to allow method chaining.
     */
    importSVG(
      /**
       * SVG ellipse element used to restore the ellipse redline element.
       */
      svg: object
    ): this;
    /**
     * Sets a new value for property {@link #getFillColor fillColor}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"rgba(0, 0, 0, 0)"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFillColor(
      /**
       * New value for property `fillColor`
       */
      sFillColor?: CSSColor
    ): this;
    /**
     * Sets a new value for property {@link #getRadiusX radiusX}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `0.0001`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setRadiusX(
      /**
       * New value for property `radiusX`
       */
      fRadiusX?: float
    ): this;
    /**
     * Sets a new value for property {@link #getRadiusY radiusY}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `0.0001`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setRadiusY(
      /**
       * New value for property `radiusY`
       */
      fRadiusY?: float
    ): this;
  }
  /**
   * Describes the settings that can be provided to the RedlineElementEllipse constructor.
   */
  export interface $RedlineElementEllipseSettings
    extends $RedlineElementSettings {
    radiusX?: float | PropertyBindingInfo | `{${string}}`;

    radiusY?: float | PropertyBindingInfo | `{${string}}`;

    fillColor?: CSSColor | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/ui/vk/RedlineElementFreehand" {
  import {
    default as RedlineElement,
    $RedlineElementSettings,
  } from "sap/ui/vk/RedlineElement";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Provides a control for creating freehand redline elements.
   *
   * @since 1.40.0
   */
  export default class RedlineElementFreehand extends RedlineElement {
    /**
     * Redline element control for freehand.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor();

    /**
     * Creates a new subclass of class sap.ui.vk.RedlineElementFreehand with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.vk.RedlineElement.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, RedlineElementFreehand>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.RedlineElementFreehand.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Creates a string path based on the current `path` property. The string path can then be used to set the
     * "d" attribute of an SVG  element.
     *
     *
     * @returns String to be used as "d" attribute value for  element.
     */
    _getProcessedPath(): string;
    /**
     * Applies a zoom factor to the current freehand redline element.
     *
     *
     * @returns `this` to allow method chaining.
     */
    applyZoom(
      /**
       * The factor to be applied to the current freehand drawing.
       */
      zoomBy: number
    ): this;
    /**
     * Adds a new point to the current freehand path.
     *
     *
     * @returns `this` to allow method chaining.
     */
    edit(
      /**
       * The value in pixels that will be set as the origin of the x-coordinate for a new point in the freehand
       * path.
       */
      offsetX: number,
      /**
       * The value in pixels that will be set as the origin of the y-coordinate for a new point in the freehand
       * path.
       */
      offsetY: number
    ): this;
    /**
     * Exports all the relevant data contained in the freehand redline element to a JSON object.
     *
     *
     * @returns Data that can be serialized and later used to restore the freehand redline element.
     */
    exportJSON(): object;
    /**
     * Exports all the relevant data contained in the freehand redline element to an SVG path element.
     *
     *
     * @returns SVG path element that can be used to restore the freehand redline element.
     */
    exportSVG(): object;
    /**
     * Gets current value of property {@link #getPath path}.
     *
     *
     * @returns Value of property `path`
     */
    getPath(): float[];
    /**
     * Imports data from JSON into the redline element.
     *
     *
     * @returns `this` to allow method chaining.
     */
    importJSON(
      /**
       * Relevant data that can be used to restore the freehand redline element.
       */
      json: object
    ): this;
    /**
     * Imports data from SVG path element into the freehand redline element.
     *
     *
     * @returns `this` to allow method chaining.
     */
    importSVG(
      /**
       * SVG path element that can be used to restore the freehand redline element.
       */
      svg: object
    ): this;
    /**
     * Sets a new value for property {@link #getPath path}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPath(
      /**
       * New value for property `path`
       */
      sPath?: float[]
    ): this;
  }
  /**
   * Describes the settings that can be provided to the RedlineElementFreehand constructor.
   */
  export interface $RedlineElementFreehandSettings
    extends $RedlineElementSettings {
    path?: float[] | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/ui/vk/RedlineElementLine" {
  import {
    default as RedlineElement,
    $RedlineElementSettings,
  } from "sap/ui/vk/RedlineElement";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Provides a control for creating line redline elements.
   *
   * @since 1.40.0
   */
  export default class RedlineElementLine extends RedlineElement {
    /**
     * Redline element control for line.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor();

    /**
     * Creates a new subclass of class sap.ui.vk.RedlineElementLine with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.vk.RedlineElement.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, RedlineElementLine>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.RedlineElementLine.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Changes the current deltaX and deltaY of the line redline element by a factor which gets passed as parameter.
     *
     *
     * @returns `this` to allow method chaining.
     */
    applyZoom(
      /**
       * The factor to be applied to the current deltaX and deltaY.
       */
      zoomBy: number
    ): this;
    /**
     * Changes the current deltaX and deltaY of the line redline element with the values passed as parameters.
     *
     *
     * @returns `this` to allow method chaining.
     */
    edit(
      /**
       * The value in pixels that will be set as deltaX for the line.
       */
      offsetX: number,
      /**
       * The value in pixels that will be set as deltaY for the line.
       */
      offsetY: number
    ): this;
    /**
     * Exports all the relevant data contained in the line redline element to a JSON object.
     *
     *
     * @returns Data that can be serialized and later used to restore the line redline element.
     */
    exportJSON(): object;
    /**
     * Exports all the relevant data contained in the line redline element to an SVG line element.
     *
     *
     * @returns SVG line element that can be used to restore the line redline element.
     */
    exportSVG(): object;
    /**
     * Gets current value of property {@link #getDeltaX deltaX}.
     *
     * Default value is `0`.
     *
     *
     * @returns Value of property `deltaX`
     */
    getDeltaX(): float;
    /**
     * Gets current value of property {@link #getDeltaY deltaY}.
     *
     * Default value is `0`.
     *
     *
     * @returns Value of property `deltaY`
     */
    getDeltaY(): float;
    /**
     * Gets current value of property {@link #getEndArrowHead endArrowHead}.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `endArrowHead`
     */
    getEndArrowHead(): boolean;
    /**
     * Imports data from a JSON object into the line redline element.
     *
     *
     * @returns `this` to allow method chaining.
     */
    importJSON(
      /**
       * Relevant data used to restore the line redline element.
       */
      json: object
    ): this;
    /**
     * Imports data from an SVG line element into the line redline element.
     *
     *
     * @returns `this` to allow method chaining.
     */
    importSVG(
      /**
       * SVG line element used to restore the line redline element.
       */
      svg: object
    ): this;
    /**
     * Sets a new value for property {@link #getDeltaX deltaX}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `0`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDeltaX(
      /**
       * New value for property `deltaX`
       */
      fDeltaX?: float
    ): this;
    /**
     * Sets a new value for property {@link #getDeltaY deltaY}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `0`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDeltaY(
      /**
       * New value for property `deltaY`
       */
      fDeltaY?: float
    ): this;
    /**
     * Sets a new value for property {@link #getEndArrowHead endArrowHead}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEndArrowHead(
      /**
       * New value for property `endArrowHead`
       */
      bEndArrowHead?: boolean
    ): this;
  }
  /**
   * Describes the settings that can be provided to the RedlineElementLine constructor.
   */
  export interface $RedlineElementLineSettings extends $RedlineElementSettings {
    deltaX?: float | PropertyBindingInfo | `{${string}}`;

    deltaY?: float | PropertyBindingInfo | `{${string}}`;

    endArrowHead?: boolean | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/ui/vk/RedlineElementRectangle" {
  import {
    default as RedlineElement,
    $RedlineElementSettings,
  } from "sap/ui/vk/RedlineElement";

  import { CSSColor } from "sap/ui/core/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Provides a control for creating rectangle redline elements.
   *
   * @since 1.40.0
   */
  export default class RedlineElementRectangle extends RedlineElement {
    /**
     * Redline element control for rectangle.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor();

    /**
     * Creates a new subclass of class sap.ui.vk.RedlineElementRectangle with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.vk.RedlineElement.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, RedlineElementRectangle>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.RedlineElementRectangle.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Changes the current width and height of the rectangle redline element by a factor which gets passed as
     * parameter.
     *
     *
     * @returns `this` to allow method chaining.
     */
    applyZoom(
      /**
       * The factor to be applied to the current width and height.
       */
      zoomBy: number
    ): this;
    /**
     * Changes the current width and height of the rectangle redline element with the values passed as parameters.
     *
     *
     * @returns `this` to allow method chaining.
     */
    edit(
      /**
       * The value in pixels that will be set as the width for the rectangle redline element.
       */
      offsetX: number,
      /**
       * The value in pixels that will be set as the height for the rectangle redline element.
       */
      offsetY: number,
      /**
       * True if the element is square False/Undefined otherwise.
       */
      isSquare: boolean
    ): this;
    /**
     * Exports all the relevant data contained in the rectangle redline element to a JSON object.
     *
     *
     * @returns Data that can be serialized and later used to restore the rectangle redline element.
     */
    exportJSON(): object;
    /**
     * Exports all the relevant data contained in the rectangle redline element to an SVG rect element.
     *
     *
     * @returns SVG rect element that can be used to restore the rectangle redline element.
     */
    exportSVG(): object;
    /**
     * Gets current value of property {@link #getFillColor fillColor}.
     *
     * Default value is `"rgba(0, 0, 0, 0)"`.
     *
     *
     * @returns Value of property `fillColor`
     */
    getFillColor(): CSSColor;
    /**
     * Gets current value of property {@link #getHeight height}.
     *
     * Default value is `0.001`.
     *
     *
     * @returns Value of property `height`
     */
    getHeight(): float;
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * Default value is `0.001`.
     *
     *
     * @returns Value of property `width`
     */
    getWidth(): float;
    /**
     * Imports data from a JSON object into the rectangle redline element.
     *
     *
     * @returns `this` to allow method chaining.
     */
    importJSON(
      /**
       * Relevant data used to restore the rectangle redline element.
       */
      json: object
    ): this;
    /**
     * Imports data from an SVG rect element into the rectangle redline element.
     *
     *
     * @returns `this` to allow method chaining.
     */
    importSVG(
      /**
       * SVG rect element used to restore the rectangle redline element.
       */
      svg: object
    ): this;
    /**
     * Sets a new value for property {@link #getFillColor fillColor}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"rgba(0, 0, 0, 0)"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFillColor(
      /**
       * New value for property `fillColor`
       */
      sFillColor?: CSSColor
    ): this;
    /**
     * Sets a new value for property {@link #getHeight height}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `0.001`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHeight(
      /**
       * New value for property `height`
       */
      fHeight?: float
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `0.001`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      fWidth?: float
    ): this;
  }
  /**
   * Describes the settings that can be provided to the RedlineElementRectangle constructor.
   */
  export interface $RedlineElementRectangleSettings
    extends $RedlineElementSettings {
    width?: float | PropertyBindingInfo | `{${string}}`;

    height?: float | PropertyBindingInfo | `{${string}}`;

    fillColor?: CSSColor | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/ui/vk/RedlineElementText" {
  import {
    default as RedlineElement,
    $RedlineElementSettings,
  } from "sap/ui/vk/RedlineElement";

  import { CSSColor } from "sap/ui/core/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Provides a control for creating text redline elements.
   *
   * @since 1.40.0
   */
  export default class RedlineElementText extends RedlineElement {
    /**
     * Redline element control for text.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor();

    /**
     * Creates a new subclass of class sap.ui.vk.RedlineElementText with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.vk.RedlineElement.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, RedlineElementText>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.RedlineElementText.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Changes the current font size of the text redline element by a factor which gets passed as parameter.
     *
     *
     * @returns `this` to allow method chaining.
     */
    applyZoom(
      /**
       * The factor to be applied to the current font size.
       */
      zoomBy: number
    ): this;
    /**
     * Changes the current originX and originY of the text redline element with the values passed as parameters.
     *
     *
     * @returns `this` to allow method chaining.
     */
    edit(
      /**
       * The value in pixels that will be set as originX for the text.
       */
      posX: number,
      /**
       * The value in pixels that will be set as originY for the text.
       */
      posY: number
    ): this;
    /**
     * Exports all the relevant data contained in the text redline element to a JSON object.
     *
     *
     * @returns Data that can be serialized and later used to restore the text redline element.
     */
    exportJSON(): object;
    /**
     * Exports all the relevant data contained in the text redline element to an SVG text element.
     *
     *
     * @returns SVG text element that can be used to restore the text redline element.
     */
    exportSVG(): object;
    /**
     * Gets current value of property {@link #getFillColor fillColor}.
     *
     * Default value is `"rgba(0,0,0,0)"`.
     *
     *
     * @returns Value of property `fillColor`
     */
    getFillColor(): CSSColor;
    /**
     * Gets current value of property {@link #getFont font}.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `font`
     */
    getFont(): string;
    /**
     * Gets current value of property {@link #getFontSize fontSize}.
     *
     * Default value is `32`.
     *
     *
     * @returns Value of property `fontSize`
     */
    getFontSize(): float;
    /**
     * Gets current value of property {@link #getHeight height}.
     *
     * Default value is `0`.
     *
     *
     * @returns Value of property `height`
     */
    getHeight(): float;
    /**
     * Gets current value of property {@link #getText text}.
     *
     * Default value is `"Text"`.
     *
     *
     * @returns Value of property `text`
     */
    getText(): string;
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * Default value is `300`.
     *
     *
     * @returns Value of property `width`
     */
    getWidth(): float;
    /**
     * Imports data from a JSON object into the text redline element.
     *
     *
     * @returns `this` to allow method chaining.
     */
    importJSON(
      /**
       * Relevant data used to restore the text redline element.
       */
      json: object
    ): this;
    /**
     * Imports data from an SVG text element into the text redline element.
     *
     *
     * @returns `this` to allow method chaining.
     */
    importSVG(
      /**
       * SVG text element used to restore the text redline element.
       */
      element: object
    ): this;
    /**
     * Sets a new value for property {@link #getFillColor fillColor}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"rgba(0,0,0,0)"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFillColor(
      /**
       * New value for property `fillColor`
       */
      sFillColor?: CSSColor
    ): this;
    /**
     * Sets a new value for property {@link #getFont font}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFont(
      /**
       * New value for property `font`
       */
      sFont?: string
    ): this;
    /**
     * Sets a new value for property {@link #getFontSize fontSize}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `32`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFontSize(
      /**
       * New value for property `fontSize`
       */
      fFontSize?: float
    ): this;
    /**
     * Sets a new value for property {@link #getHeight height}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `0`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHeight(
      /**
       * New value for property `height`
       */
      fHeight?: float
    ): this;
    /**
     * Sets a new value for property {@link #getText text}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"Text"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setText(
      /**
       * New value for property `text`
       */
      sText?: string
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `300`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      fWidth?: float
    ): this;
  }
  /**
   * Describes the settings that can be provided to the RedlineElementText constructor.
   */
  export interface $RedlineElementTextSettings extends $RedlineElementSettings {
    text?: string | PropertyBindingInfo;

    font?: string | PropertyBindingInfo;

    fontSize?: float | PropertyBindingInfo | `{${string}}`;

    fillColor?: CSSColor | PropertyBindingInfo | `{${string}}`;

    width?: float | PropertyBindingInfo | `{${string}}`;

    height?: float | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/ui/vk/RedlineSurface" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import RedlineElement from "sap/ui/vk/RedlineElement";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  import Event from "sap/ui/base/Event";

  /**
   * Provides a bass class control for redlining.
   *
   * @since 1.40.0
   */
  export default class RedlineSurface extends Control {
    /**
     * Constructor for a new RedlineSurface.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor();

    /**
     * Creates a new subclass of class sap.ui.vk.RedlineSurface with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, RedlineSurface>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.RedlineSurface.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some redlineElement to the aggregation {@link #getRedlineElements redlineElements}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addRedlineElement(
      /**
       * The redlineElement to add; if empty, nothing is inserted
       */
      oRedlineElement: RedlineElement
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:pan pan} event of this `sap.ui.vk.RedlineSurface`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.RedlineSurface` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPan(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: RedlineSurface$PanEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.RedlineSurface` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:pan pan} event of this `sap.ui.vk.RedlineSurface`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.RedlineSurface` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPan(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: RedlineSurface$PanEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.RedlineSurface` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:zoom zoom} event of this `sap.ui.vk.RedlineSurface`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.RedlineSurface` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachZoom(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: RedlineSurface$ZoomEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.RedlineSurface` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:zoom zoom} event of this `sap.ui.vk.RedlineSurface`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.RedlineSurface` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachZoom(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: RedlineSurface$ZoomEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.RedlineSurface` itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys all the redlineElements in the aggregation {@link #getRedlineElements redlineElements}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyRedlineElements(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:pan pan} event of this `sap.ui.vk.RedlineSurface`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachPan(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: RedlineSurface$PanEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:zoom zoom} event of this `sap.ui.vk.RedlineSurface`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachZoom(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: RedlineSurface$ZoomEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Exports all the current redline elements as an array of JSON objects.
     *
     *
     * @returns An array of JSON objects.
     */
    exportJSON(): object[];
    /**
     * Exports all the current redline elements as an array of SVG objects.
     *
     *
     * @returns An array of SVG objects.
     */
    exportSVG(): object[];
    /**
     * Fires event {@link #event:pan pan} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    firePan(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: RedlineSurface$PanEventParameters
    ): this;
    /**
     * Fires event {@link #event:zoom zoom} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireZoom(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: RedlineSurface$ZoomEventParameters
    ): this;
    /**
     * Gets current value of property {@link #getPanningRatio panningRatio}.
     *
     * Default value is `1`.
     *
     *
     * @returns Value of property `panningRatio`
     */
    getPanningRatio(): float;
    /**
     * Gets content of aggregation {@link #getRedlineElements redlineElements}.
     */
    getRedlineElements(): RedlineElement[];
    /**
     * Gets current value of property {@link #getVirtualLeft virtualLeft}.
     *
     *
     * @returns Value of property `virtualLeft`
     */
    getVirtualLeft(): float;
    /**
     * Gets current value of property {@link #getVirtualSideLength virtualSideLength}.
     *
     *
     * @returns Value of property `virtualSideLength`
     */
    getVirtualSideLength(): float;
    /**
     * Gets current value of property {@link #getVirtualTop virtualTop}.
     *
     *
     * @returns Value of property `virtualTop`
     */
    getVirtualTop(): float;
    /**
     * Iterates through all JSON objects from the array passed as parameter, and creates and restores the redline
     * elements serialized in the array.
     *
     *
     * @returns `this` to allow method chaining.
     */
    importJSON(
      /**
       * An array of serialized redline elements.
       */
      jsonElements: object[]
    ): this;
    /**
     * Iterates through all SVG objects from the array passed as parameter, and creates and restores the redline
     * elements in the array.
     *
     *
     * @returns `this` to allow method chaining.
     */
    importSVG(
      /**
       * An array of redline elements in SVG format.
       */
      svg: object[]
    ): this;
    /**
     * Checks for the provided `sap.ui.vk.RedlineElement` in the aggregation {@link #getRedlineElements redlineElements}.
     * and returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfRedlineElement(
      /**
       * The redlineElement whose index is looked for
       */
      oRedlineElement: RedlineElement
    ): int;
    /**
     * Inserts a redlineElement into the aggregation {@link #getRedlineElements redlineElements}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertRedlineElement(
      /**
       * The redlineElement to insert; if empty, nothing is inserted
       */
      oRedlineElement: RedlineElement,
      /**
       * The `0`-based index the redlineElement should be inserted at; for a negative value of `iIndex`, the redlineElement
       * is inserted at position 0; for a value greater than the current size of the aggregation, the redlineElement
       * is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getRedlineElements redlineElements}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllRedlineElements(): RedlineElement[];
    /**
     * Removes a redlineElement from the aggregation {@link #getRedlineElements redlineElements}.
     *
     *
     * @returns The removed redlineElement or `null`
     */
    removeRedlineElement(
      /**
       * The redlineElement to remove or its index or id
       */
      vRedlineElement: int | string | RedlineElement
    ): RedlineElement | null;
    /**
     * Sets a new value for property {@link #getPanningRatio panningRatio}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `1`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPanningRatio(
      /**
       * New value for property `panningRatio`
       */
      fPanningRatio?: float
    ): this;
    /**
     * Sets a new value for property {@link #getVirtualLeft virtualLeft}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setVirtualLeft(
      /**
       * New value for property `virtualLeft`
       */
      fVirtualLeft: float
    ): this;
    /**
     * Sets a new value for property {@link #getVirtualSideLength virtualSideLength}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setVirtualSideLength(
      /**
       * New value for property `virtualSideLength`
       */
      fVirtualSideLength: float
    ): this;
    /**
     * Sets a new value for property {@link #getVirtualTop virtualTop}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setVirtualTop(
      /**
       * New value for property `virtualTop`
       */
      fVirtualTop: float
    ): this;
    /**
     * Updates the panning ratio by making calculations based on virtual viewport size and actual viewport size.
     *
     *
     * @returns `this` to allow method chaining.
     */
    updatePanningRatio(): this;
  }
  /**
   * Describes the settings that can be provided to the RedlineSurface constructor.
   */
  export interface $RedlineSurfaceSettings extends $ControlSettings {
    virtualLeft?: float | PropertyBindingInfo | `{${string}}`;

    virtualTop?: float | PropertyBindingInfo | `{${string}}`;

    virtualSideLength?: float | PropertyBindingInfo | `{${string}}`;

    panningRatio?: float | PropertyBindingInfo | `{${string}}`;

    redlineElements?:
      | RedlineElement[]
      | RedlineElement
      | AggregationBindingInfo
      | `{${string}}`;

    pan?: (oEvent: RedlineSurface$PanEvent) => void;

    zoom?: (oEvent: RedlineSurface$ZoomEvent) => void;
  }

  /**
   * Parameters of the RedlineSurface#pan event.
   */
  export interface RedlineSurface$PanEventParameters {
    deltaX?: float;

    deltaY?: float;
  }

  /**
   * Event object of the RedlineSurface#pan event.
   */
  export type RedlineSurface$PanEvent = Event<
    RedlineSurface$PanEventParameters,
    RedlineSurface
  >;

  /**
   * Parameters of the RedlineSurface#zoom event.
   */
  export interface RedlineSurface$ZoomEventParameters {
    originX?: float;

    originY?: float;

    zoomFactor?: float;
  }

  /**
   * Event object of the RedlineSurface#zoom event.
   */
  export type RedlineSurface$ZoomEvent = Event<
    RedlineSurface$ZoomEventParameters,
    RedlineSurface
  >;
}

declare module "sap/ui/vk/RenderMode" {
  /**
   * Render mode for {@link sap.ui.vk.Viewport}.
   */
  enum RenderMode {
    /**
     * The default render mode.
     */
    Default = "Default",
    /**
     * The line illustration render mode.
     */
    LineIllustration = "LineIllustration",
    /**
     * The shaded illustration render mode.
     */
    ShadedIllustration = "ShadedIllustration",
    /**
     * The solid outline render mode.
     */
    SolidOutline = "SolidOutline",
    /**
     * The XRay render mode.
     */
    XRay = "XRay",
  }
  export default RenderMode;
}

declare module "sap/ui/vk/SafeArea" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  /**
   * SafeArea allows applications to define area of viewport which will be initially displayed regardless
   * of viewing device and its screen resolution or orientation.
   */
  export default class SafeArea extends Control {
    /**
     * Constructor for a new SafeArea.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor();

    /**
     * Creates a new subclass of class sap.ui.vk.SafeArea with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, SafeArea>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.SafeArea.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Destroys the settingsControl in the aggregation {@link #getSettingsControl settingsControl}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroySettingsControl(): this;
    /**
     * Gets content of aggregation {@link #getSettingsControl settingsControl}.
     *
     * Application defined setting control which can be used to control SafeArea and aspect ratio settings
     */
    getSettingsControl(): Control;
    /**
     * Sets the aggregated {@link #getSettingsControl settingsControl}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSettingsControl(
      /**
       * The settingsControl to set
       */
      oSettingsControl: Control
    ): this;
  }
  /**
   * Describes the settings that can be provided to the SafeArea constructor.
   */
  export interface $SafeAreaSettings extends $ControlSettings {
    /**
     * Application defined setting control which can be used to control SafeArea and aspect ratio settings
     */
    settingsControl?: Control;
  }
}

declare module "sap/ui/vk/Scene" {
  import {
    default as ManagedObject,
    $ManagedObjectSettings,
    PropertyBindingInfo,
  } from "sap/ui/base/ManagedObject";

  import NodeHierarchy from "sap/ui/vk/NodeHierarchy";

  import View from "sap/ui/vk/View";

  import ManagedObjectMetadata from "sap/ui/base/ManagedObjectMetadata";

  import ViewGroup from "sap/ui/vk/ViewGroup";

  /**
   * Provides the interface for the 3D model.
   *
   * The objects of this class should not be created directly. They should be created via {@link sap.ui.vk.ContentConnector sap.ui.vk.ContentConnector}.
   */
  export default abstract class Scene extends ManagedObject {
    /**
     * Constructor for a new Scene.
     *
     * The objects of this class should not be created directly. They should be created via {@link sap.ui.vk.ContentConnector sap.ui.vk.ContentConnector}.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor();

    /**
     * Creates a new subclass of class sap.ui.vk.Scene with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.base.ManagedObject.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Scene>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.Scene.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ManagedObjectMetadata;
    /**
     * Add a sequence to the scene
     *
     *
     * @returns `this` to allow method chaining.
     */
    addSequence(
      /**
       * sequence to add
       */
      sequence: /* was: sap.ui.vk.AnimationSequence */ any
    ): this;
    /**
     * Add an animation track to the scene
     *
     *
     * @returns `this` to allow method chaining.
     */
    addTrack(
      /**
       * animation track to add
       */
      track: /* was: sap.ui.vk.AnimationTrack */ any
    ): this;
    /**
     * Creates a highlight.
     *
     *
     * @returns created highlight
     */
    createHighlight(
      /**
       * persistent highlight ID
       */
      sId: string,
      /**
       * highlight creation parameters
       */
      parameters: any
    ): /* was: sap.ui.vk.Highlight */ any;
    /**
     * Creates an animation sequence.
     *
     *
     * @returns created sequence
     */
    createSequence(
      /**
       * persistent sequence ID
       */
      sId: string,
      /**
       * sequence creation parameters
       */
      parameters: any
    ): /* was: sap.ui.vk.AnimationSequence */ any;
    /**
     * Creates an animation track.
     *
     *
     * @returns created track
     */
    createTrack(
      /**
       * persistent track ID
       */
      sId: string,
      /**
       * track creation parameters
       */
      parameters: any
    ): /* was: sap.ui.vk.AnimationTrack */ any;
    /**
     * Finds sequence by ID
     *
     *
     * @returns sequence with given Id or undefined
     */
    findSequence(
      /**
       * sequence ID
       */
      sequenceId: string
    ): /* was: sap.ui.vk.AnimationSequence */ any;
    /**
     * Finds track by ID
     *
     *
     * @returns track with given Id or undefined
     */
    findTrack(
      /**
       * track ID
       */
      trackId: string
    ): /* was: sap.ui.vk.AnimationTrack */ any;
    /**
     * Gets the default node hierarchy in the Scene object.
     *
     *
     * @returns The default node hierarchy in the Scene object.
     */
    getDefaultNodeHierarchy(): NodeHierarchy;
    /**
     * Gets current value of property {@link #getDoubleSided doubleSided}.
     *
     * Enables or disables double-sided materials
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `doubleSided`
     */
    getDoubleSided(): boolean;
    /**
     * get highlight according to ID
     *
     *
     * @returns highlight
     */
    getHighlight(
      /**
       * persistent highlight ID
       */
      sId: string
    ): /* was: sap.ui.vk.Highlight */ any;
    /**
     * Gets the unique ID of the Scene object.
     *
     *
     * @returns The unique ID of the Scene object.
     */
    getId(): string;
    /**
     * Get initial view
     *
     *
     * @returns initial view
     */
    getInitialView(): View;
    /**
     * Gets the scene reference that this Scene object wraps.
     *
     *
     * @returns The scene reference that this Scene object wraps.
     */
    getSceneRef(): any;
    /**
     * Gets a list of sequences
     *
     *
     * @returns list of sequences
     */
    getSequences(): /* was: sap.ui.vk.AnimationSequence */ any[];
    /**
     * Gets a list of animation tracks
     *
     *
     * @returns list of animation tracks
     */
    getTracks(): /* was: sap.ui.vk.AnimationTrack */ any[];
    /**
     * Provides an array of all ViewGroups
     *
     *
     * @returns List of ViewGroups
     */
    getViewGroups(): ViewGroup[];
    /**
     * Provides an array of all views
     *
     *
     * @returns List of Views
     */
    getViews(): View[];
    /**
     * Gets index of a sequence in the scene
     *
     *
     * @returns sequence index of found or -1 otherwise
     */
    indexOfSequence(
      /**
       * sequence to locate
       */
      sequence: /* was: sap.ui.vk.AnimationSequence */ any
    ): int;
    /**
     * Gets index of an animation track in the scene
     *
     *
     * @returns sequence index of found or -1 otherwise
     */
    indexOfTrack(
      /**
       * animation track to locate
       */
      track: /* was: sap.ui.vk.AnimationTrack */ any
    ): int;
    /**
     * Inserts a sequence
     *
     *
     * @returns `this` to allow method chaining.
     */
    insertSequence(
      /**
       * sequence to insert
       */
      sequence: /* was: sap.ui.vk.AnimationSequence */ any,
      /**
       * index where to insert the sequence
       */
      index: int
    ): this;
    /**
     * Inserts an animation track
     *
     *
     * @returns `this` to allow method chaining.
     */
    insertTrack(
      /**
       * animation track to insert
       */
      track: /* was: sap.ui.vk.AnimationTrack */ any,
      /**
       * index where to insert the animation track
       */
      index: int
    ): this;
    /**
     * remove highlight according to ID
     *
     *
     * @returns `this` to allow method chaining.
     */
    removeHighlight(
      /**
       * persistent highlight ID
       */
      sId: string
    ): this;
    /**
     * Removes a sequence from the scene
     *
     *
     * @returns `this` to allow method chaining.
     */
    removeSequence(
      /**
       * sequence to remove
       */
      sequence: /* was: sap.ui.vk.AnimationSequence */ any
    ): this;
    /**
     * Removes all sequences from the scene
     *
     *
     * @returns `this` to allow method chaining.
     */
    removeSequences(): this;
    /**
     * Removes an animation track from the scene
     *
     *
     * @returns `this` to allow method chaining.
     */
    removeTrack(
      /**
       * animation track to remove
       */
      track: /* was: sap.ui.vk.AnimationTrack */ any
    ): this;
    /**
     * Removes all animation tracks from the scene
     *
     *
     * @returns `this` to allow method chaining.
     */
    removeTracks(): this;
    /**
     * Sets a new value for property {@link #getDoubleSided doubleSided}.
     *
     * Enables or disables double-sided materials
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDoubleSided(
      /**
       * New value for property `doubleSided`
       */
      bDoubleSided?: boolean
    ): this;
    /**
     * Set initial view
     */
    setInitialView(
      /**
       * Initial view
       */
      view: View
    ): void;
  }
  /**
   * Describes the settings that can be provided to the Scene constructor.
   */
  export interface $SceneSettings extends $ManagedObjectSettings {
    /**
     * Enables or disables double-sided materials
     */
    doubleSided?: boolean | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/ui/vk/SceneTree" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import Event from "sap/ui/base/Event";

  import { ID } from "sap/ui/core/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import ContentConnector from "sap/ui/vk/ContentConnector";

  import ViewStateManagerBase from "sap/ui/vk/ViewStateManagerBase";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Provides a hierarchical view of all the nodes in a given scene in table format.
   *
   * @since 1.32.0
   */
  export default class SceneTree extends Control {
    /**
     * Constructor for a new SceneTree.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $SceneTreeSettings
    );
    /**
     * Constructor for a new SceneTree.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $SceneTreeSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vk.SceneTree with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, SceneTree>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.SceneTree.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:contentChanged contentChanged} event of this
     * `sap.ui.vk.SceneTree`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.SceneTree` itself.
     *
     * This event will be fired when a scene tree content is replaced.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachContentChanged(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.SceneTree` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:contentChanged contentChanged} event of this
     * `sap.ui.vk.SceneTree`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.SceneTree` itself.
     *
     * This event will be fired when a scene tree content is replaced.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachContentChanged(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.SceneTree` itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys the treeTable in the aggregation {@link #getTreeTable treeTable}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyTreeTable(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:contentChanged contentChanged} event of this
     * `sap.ui.vk.SceneTree`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachContentChanged(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:contentChanged contentChanged} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireContentChanged(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * ID of the element which is the current target of the association {@link #getContentConnector contentConnector},
     * or `null`.
     */
    getContentConnector(): ID | null;
    /**
     * Gets current value of property {@link #getLegacyVisibilityMode legacyVisibilityMode}.
     *
     * In legacy visibility mode all changes in node visibility also apply to all descendent nodes
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `legacyVisibilityMode`
     */
    getLegacyVisibilityMode(): boolean;
    /**
     * Gets current value of property {@link #getShowSearchField showSearchField}.
     *
     * Show or hide search field
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `showSearchField`
     */
    getShowSearchField(): boolean;
    /**
     * Gets current value of property {@link #getShowTitle showTitle}.
     *
     * If set to `False` then title text will not bbe displayed
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `showTitle`
     */
    getShowTitle(): boolean;
    /**
     * Gets current value of property {@link #getTitle title}.
     *
     * Text to be displayed in title bar of scene tree
     *
     * Default value is `...see text or source`.
     *
     *
     * @returns Value of property `title`
     */
    getTitle(): string;
    /**
     * Gets content of aggregation {@link #getTreeTable treeTable}.
     */
    getTreeTable(): /* was: sap.ui.table.TreeTable */ any;
    /**
     * ID of the element which is the current target of the association {@link #getViewStateManager viewStateManager},
     * or `null`.
     */
    getViewStateManager(): ID | null;
    /**
     * Sets the associated {@link #getContentConnector contentConnector}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setContentConnector(
      /**
       * ID of an element which becomes the new target of this contentConnector association; alternatively, an
       * element instance may be given
       */
      oContentConnector: ID | ContentConnector
    ): this;
    /**
     * Sets a new value for property {@link #getLegacyVisibilityMode legacyVisibilityMode}.
     *
     * In legacy visibility mode all changes in node visibility also apply to all descendent nodes
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLegacyVisibilityMode(
      /**
       * New value for property `legacyVisibilityMode`
       */
      bLegacyVisibilityMode?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowSearchField showSearchField}.
     *
     * Show or hide search field
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowSearchField(
      /**
       * New value for property `showSearchField`
       */
      bShowSearchField?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowTitle showTitle}.
     *
     * If set to `False` then title text will not bbe displayed
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowTitle(
      /**
       * New value for property `showTitle`
       */
      bShowTitle?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getTitle title}.
     *
     * Text to be displayed in title bar of scene tree
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `...see text or source`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTitle(
      /**
       * New value for property `title`
       */
      sTitle?: string
    ): this;
    /**
     * Sets the aggregated {@link #getTreeTable treeTable}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTreeTable(
      /**
       * The treeTable to set
       */
      oTreeTable: /* was: sap.ui.table.TreeTable */ any
    ): this;
    /**
     * Sets the associated {@link #getViewStateManager viewStateManager}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setViewStateManager(
      /**
       * ID of an element which becomes the new target of this viewStateManager association; alternatively, an
       * element instance may be given
       */
      oViewStateManager: ID | ViewStateManagerBase
    ): this;
  }
  /**
   * Describes the settings that can be provided to the SceneTree constructor.
   */
  export interface $SceneTreeSettings extends $ControlSettings {
    /**
     * Text to be displayed in title bar of scene tree
     */
    title?: string | PropertyBindingInfo;

    /**
     * If set to `False` then title text will not bbe displayed
     */
    showTitle?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Show or hide search field
     */
    showSearchField?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * In legacy visibility mode all changes in node visibility also apply to all descendent nodes
     */
    legacyVisibilityMode?: boolean | PropertyBindingInfo | `{${string}}`;

    treeTable?: /* was: sap.ui.table.TreeTable */ any;

    /**
     * An association to the `ContentConnector` instance that manages content resources.
     */
    contentConnector?: ContentConnector | string;

    /**
     * An association to the `ViewStateManager` instance.
     */
    viewStateManager?: ViewStateManagerBase | string;

    /**
     * This event will be fired when a scene tree content is replaced.
     */
    contentChanged?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the SceneTree#contentChanged event.
   */
  export interface SceneTree$ContentChangedEventParameters {}

  /**
   * Event object of the SceneTree#contentChanged event.
   */
  export type SceneTree$ContentChangedEvent = Event<
    SceneTree$ContentChangedEventParameters,
    SceneTree
  >;
}

declare module "sap/ui/vk/SelectionDisplayMode" {
  /**
   * Selection display options.
   */
  enum SelectionDisplayMode {
    Highlight = "Highlight",

    Outline = "Outline",
  }
  export default SelectionDisplayMode;
}

declare module "sap/ui/vk/SelectionMode" {
  /**
   * SelectionMode options.
   */
  enum SelectionMode {
    Exclusive = "exclusive",

    None = "none",

    Sticky = "sticky",
  }
  export default SelectionMode;
}

declare module "sap/ui/vk/StepNavigation" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import { ID, CSSSize } from "sap/ui/core/library";

  import Toolbar from "sap/m/Toolbar";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import Item from "sap/ui/core/Item";

  import ScrollContainer from "sap/m/ScrollContainer";

  import ContentConnector from "sap/ui/vk/ContentConnector";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  import Event from "sap/ui/base/Event";

  /**
   * Enables capabilities for navigating and activating procedures and steps contained in a single 3D scene.
   *
   * @since 1.32.0
   * @deprecated As of version 1.72.0. This class is used only with DVL namespace which will be removed in
   * future. Use {@link sap.ui.vk.ViewGallery} instead.
   */
  export default class StepNavigation extends Control {
    /**
     * Constructor for a new StepNavigation.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new Step Navigation control.
       */
      mSettings?: $StepNavigationSettings
    );
    /**
     * Constructor for a new StepNavigation.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control. This ID is generated automatically if no ID is provided.
       */
      sId?: string,
      /**
       * Initial settings for the new Step Navigation control.
       */
      mSettings?: $StepNavigationSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vk.StepNavigation with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, StepNavigation>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.StepNavigation.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:resize resize} event of this `sap.ui.vk.StepNavigation`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.StepNavigation` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachResize(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: StepNavigation$ResizeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.StepNavigation` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:resize resize} event of this `sap.ui.vk.StepNavigation`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.StepNavigation` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachResize(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: StepNavigation$ResizeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.StepNavigation` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:stepChanged stepChanged} event of this `sap.ui.vk.StepNavigation`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.StepNavigation` itself.
     *
     * Raised each time a step starts, changes, or finishes.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachStepChanged(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: StepNavigation$StepChangedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.StepNavigation` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:stepChanged stepChanged} event of this `sap.ui.vk.StepNavigation`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.StepNavigation` itself.
     *
     * Raised each time a step starts, changes, or finishes.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachStepChanged(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: StepNavigation$StepChangedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.StepNavigation` itself
       */
      oListener?: object
    ): this;
    /**
     * Clears the content of the Step Navigation control.
     *
     *
     * @returns Returns `true` if the method was called successfully.
     */
    clear(): boolean;
    /**
     * Destroys the layout in the aggregation {@link #getLayout layout}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyLayout(): this;
    /**
     * Destroys the procedureItemTemplate in the aggregation {@link #getProcedureItemTemplate procedureItemTemplate}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyProcedureItemTemplate(): this;
    /**
     * Destroys the stepInfoPopup in the aggregation {@link #getStepInfoPopup stepInfoPopup}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyStepInfoPopup(): this;
    /**
     * Destroys the thumbnailsContainer in the aggregation {@link #getThumbnailsContainer thumbnailsContainer}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyThumbnailsContainer(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:resize resize} event of this `sap.ui.vk.StepNavigation`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachResize(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: StepNavigation$ResizeEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:stepChanged stepChanged} event of this `sap.ui.vk.StepNavigation`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachStepChanged(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: StepNavigation$StepChangedEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:resize resize} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireResize(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: StepNavigation$ResizeEventParameters
    ): this;
    /**
     * Fires event {@link #event:stepChanged stepChanged} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireStepChanged(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: StepNavigation$StepChangedEventParameters
    ): this;
    /**
     * ID of the element which is the current target of the association {@link #getContentConnector contentConnector},
     * or `null`.
     */
    getContentConnector(): ID | null;
    /**
     * Gets current value of property {@link #getHeight height}.
     *
     * Height of the Step Navigation control.
     *
     * Default value is `"100%"`.
     *
     *
     * @returns Value of property `height`
     */
    getHeight(): CSSSize;
    /**
     * Gets content of aggregation {@link #getLayout layout}.
     *
     * sap.m.Toolbar used to render the entire Step Navigation control's content.
     */
    getLayout(): Toolbar;
    /**
     * Cycles through steps and procedures for the lastLoadedScene and returns the step that follows after the
     * currentStepId.
     *
     *
     * @returns The step that follows after the current step.
     */
    getNextStep(
      /**
       * Optional integer representing the index of the target procedure in the procedures list.
       */
      procedureIndex?: number
    ): JSON;
    /**
     * Cycles through steps and procedures for the last loaded scene (`lastLoadedScene`), and returns the step
     * preceding the current step (currentStepId.
     *
     *
     * @returns The step preceding the current step.
     */
    getPreviousStep(
      /**
       * Optional integer representing the index of the target procedure in the procedures list.
       */
      procedureIndex?: number
    ): JSON;
    /**
     * Gets content of aggregation {@link #getProcedureItemTemplate procedureItemTemplate}.
     *
     * Template control for Procedure items.
     */
    getProcedureItemTemplate(): Item;
    /**
     * Returns the procedures list with steps for the current scene, and appends base64 data as thumbnailData
     * and an image type as thumbnailType.
     *
     *
     * @returns  For example: `{sceneId : string, hasThumbnails : boolean, "procedures" : [id:string,
     * name: string, steps: [{id: string, name: string, thumbnailData: string, thumbnailType: string}], "portfolios":
     * [] }`
     */
    getProceduresAndSteps(): JSON;
    /**
     * Gets current value of property {@link #getSettings settings}.
     *
     * Managed settings and properties for Step Navigation events.
     *
     *
     * @returns Value of property `settings`
     */
    getSettings(): object;
    /**
     * Gets current value of property {@link #getShowStepInfo showStepInfo}.
     *
     * Indicates that the Step Navigation control should display a popup containing information around the step
     * that is playing. If set to `true`, then the popup is rendered. If set to `false`, the popup is hidden.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `showStepInfo`
     */
    getShowStepInfo(): boolean;
    /**
     * Gets current value of property {@link #getShowThumbnails showThumbnails}.
     *
     * Indicates that the Step Navigation control should display thumbnails. If set to `true`, then thumbnails
     * are rendered. If set to `false`, then thumbnails are hidden.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `showThumbnails`
     */
    getShowThumbnails(): boolean;
    /**
     * Gets current value of property {@link #getShowToolbar showToolbar}.
     *
     * Indicates that the Step Navigation control should display a toolbar. If set to `true`, then the toolbar
     * is rendered. If set to `false`, then the toolbar is hidden.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `showToolbar`
     */
    getShowToolbar(): boolean;
    /**
     * Gets a step based on a positive or negative integer, which is used as an index relative to the index
     * of the current step. An index value of `0` can be used to retrieve the details of the current step.
     *
     *
     * @returns step
     */
    getStep(
      /**
       * Positive or negative integer representing the number to add or subtract from the index of the current
       * step to return the desired step; for example, //next 1, current 0, previous -1
       */
      relIndex: number,
      /**
       * Optional integer representing the index of the target procedure in the procedures list.
       */
      procedureIndex: number,
      /**
       * The ID of the step that we want to retrieve.
       */
      specificStepId: string
    ): JSON;
    /**
     * Gets a step based on a positive or negative integer, which is used as an index relative to the index
     * of the current step. An index value of `0` can be used to retrieve the details of the current step.
     *
     *
     * @returns step
     */
    getStep(
      /**
       * Positive or negative integer representing the number to add or subtract from the index of the current
       * step to return the desired step; for example, //next 1, current 0, previous -1
       */
      relIndex: number,
      /**
       * The ID of the step that we want to retrieve.
       */
      specificStepId: string
    ): JSON;
    /**
     * Gets content of aggregation {@link #getStepInfoPopup stepInfoPopup}.
     *
     * sap.ui.core.Popup used to render step information in a popup.
     */
    getStepInfoPopup(): Control;
    /**
     * Gets content of aggregation {@link #getThumbnailsContainer thumbnailsContainer}.
     *
     * sap.m.ScrollContainer used to render a list of thumbnails for the available steps.
     */
    getThumbnailsContainer(): ScrollContainer;
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * Width of the Step Navigation control.
     *
     * Default value is `"100%"`.
     *
     *
     * @returns Value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * Pauses the step that is currently playing.
     */
    pauseStep(): void;
    /**
     * Plays all the steps in the specified procedure.
     */
    playAllSteps(
      /**
       * The ID of the procedure for which to play all steps. If `procedureId == null`, then only the first step
       * is played.
       */
      procedureId?: string
    ): void;
    /**
     * Plays the specified procedure step.
     */
    playStep(
      /**
       * The ID of the procedure step to play.
       */
      stepId: string,
      /**
       * Default: true If `true`, tells the Viewer to play the step from the first frame.
       */
      fromTheBeginning: boolean,
      /**
       * Default: false If `true`, tells the Viewer to play the next step in sequence.
       */
      continueToTheNext: boolean
    ): void;
    /**
     * Rebuilds the content of the Step Navigation control from the current Scene.
     *
     *
     * @returns Returns `true` if the content of the Step Navigation control was rebuilt successfully.
     */
    refresh(
      /**
       * The scene object to be used.
       */
      oScene: object
    ): boolean;
    /**
     * Sets the associated {@link #getContentConnector contentConnector}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setContentConnector(
      /**
       * ID of an element which becomes the new target of this contentConnector association; alternatively, an
       * element instance may be given
       */
      oContentConnector: ID | ContentConnector
    ): this;
    /**
     * Sets a new value for property {@link #getHeight height}.
     *
     * Height of the Step Navigation control.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"100%"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHeight(
      /**
       * New value for property `height`
       */
      sHeight?: CSSSize
    ): this;
    /**
     * Sets the aggregated {@link #getLayout layout}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLayout(
      /**
       * The layout to set
       */
      oLayout: Toolbar
    ): this;
    /**
     * Sets the aggregated {@link #getProcedureItemTemplate procedureItemTemplate}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setProcedureItemTemplate(
      /**
       * The procedureItemTemplate to set
       */
      oProcedureItemTemplate: Item
    ): this;
    /**
     * Attaches a Scene object to the Step Navigation control so that it can access the Scene’s procedures and
     * steps.
     */
    setScene(
      /**
       * The Scene object to attach to the Step Navigation control.
       */
      scene: object
    ): void;
    /**
     * Sets a new value for property {@link #getSettings settings}.
     *
     * Managed settings and properties for Step Navigation events.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSettings(
      /**
       * New value for property `settings`
       */
      oSettings: object
    ): this;
    /**
     * Sets a new value for property {@link #getShowStepInfo showStepInfo}.
     *
     * Indicates that the Step Navigation control should display a popup containing information around the step
     * that is playing. If set to `true`, then the popup is rendered. If set to `false`, the popup is hidden.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowStepInfo(
      /**
       * New value for property `showStepInfo`
       */
      bShowStepInfo?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowThumbnails showThumbnails}.
     *
     * Indicates that the Step Navigation control should display thumbnails. If set to `true`, then thumbnails
     * are rendered. If set to `false`, then thumbnails are hidden.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowThumbnails(
      /**
       * New value for property `showThumbnails`
       */
      bShowThumbnails?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowToolbar showToolbar}.
     *
     * Indicates that the Step Navigation control should display a toolbar. If set to `true`, then the toolbar
     * is rendered. If set to `false`, then the toolbar is hidden.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowToolbar(
      /**
       * New value for property `showToolbar`
       */
      bShowToolbar?: boolean
    ): this;
    /**
     * Sets the aggregated {@link #getStepInfoPopup stepInfoPopup}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setStepInfoPopup(
      /**
       * The stepInfoPopup to set
       */
      oStepInfoPopup: Control
    ): this;
    /**
     * Sets the aggregated {@link #getThumbnailsContainer thumbnailsContainer}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setThumbnailsContainer(
      /**
       * The thumbnailsContainer to set
       */
      oThumbnailsContainer: ScrollContainer
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * Width of the Step Navigation control.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"100%"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      sWidth?: CSSSize
    ): this;
  }
  /**
   * Describes the settings that can be provided to the StepNavigation constructor.
   *
   * @deprecated As of version 1.72.0. This class is used only with DVL namespace which will be removed in
   * future. Use {@link sap.ui.vk.ViewGallery} instead.
   */
  export interface $StepNavigationSettings extends $ControlSettings {
    /**
     * Managed settings and properties for Step Navigation events.
     */
    settings?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * Width of the Step Navigation control.
     */
    width?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Height of the Step Navigation control.
     */
    height?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Indicates that the Step Navigation control should display thumbnails. If set to `true`, then thumbnails
     * are rendered. If set to `false`, then thumbnails are hidden.
     */
    showThumbnails?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Indicates that the Step Navigation control should display a toolbar. If set to `true`, then the toolbar
     * is rendered. If set to `false`, then the toolbar is hidden.
     */
    showToolbar?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Indicates that the Step Navigation control should display a popup containing information around the step
     * that is playing. If set to `true`, then the popup is rendered. If set to `false`, the popup is hidden.
     */
    showStepInfo?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Template control for Procedure items.
     */
    procedureItemTemplate?: Item;

    /**
     * sap.ui.core.Popup used to render step information in a popup.
     */
    stepInfoPopup?: Control;

    /**
     * sap.m.Toolbar used to render the entire Step Navigation control's content.
     */
    layout?: Toolbar;

    /**
     * sap.m.ScrollContainer used to render a list of thumbnails for the available steps.
     */
    thumbnailsContainer?: ScrollContainer;

    contentConnector?: ContentConnector | string;

    resize?: (oEvent: StepNavigation$ResizeEvent) => void;

    /**
     * Raised each time a step starts, changes, or finishes.
     */
    stepChanged?: (oEvent: StepNavigation$StepChangedEvent) => void;
  }

  /**
   * Parameters of the StepNavigation#resize event.
   */
  export interface StepNavigation$ResizeEventParameters {
    oldSize?: object;

    size?: object;
  }

  /**
   * Event object of the StepNavigation#resize event.
   */
  export type StepNavigation$ResizeEvent = Event<
    StepNavigation$ResizeEventParameters,
    StepNavigation
  >;

  /**
   * Parameters of the StepNavigation#stepChanged event.
   */
  export interface StepNavigation$StepChangedEventParameters {
    /**
     * The ID of the rendering client that raised the event.
     */
    clientId?: object;

    /**
     * The type of sap.ve.dvl.DVLSTEPEVENT that has been raised; for example, DVLSTEPEVENT_FINISHED, DVLSTEPEVENT_SWITCHED,
     * DVLSTEPEVENT_STARTED, DVLSTEPEVENT_PLAYING.
     */
    type?: object;

    /**
     * The ID of the step affected by this stepId event.
     */
    stepId?: object;
  }

  /**
   * Event object of the StepNavigation#stepChanged event.
   */
  export type StepNavigation$StepChangedEvent = Event<
    StepNavigation$StepChangedEventParameters,
    StepNavigation
  >;
}

declare module "sap/ui/vk/svg/BaseNodeProxy" {
  import BaseNodeProxy1 from "sap/ui/vk/BaseNodeProxy";

  import { Poolable } from "sap/ui/base/ObjectPool";

  import Metadata from "sap/ui/base/Metadata";

  import NodeHierarchy from "sap/ui/vk/svg/NodeHierarchy";

  /**
   * Provides a simple, lightweight proxy object to a node in a node hierarchy.
   *
   * The objects of this class should not be created directly, and should only be created through the use
   * of the following methods:
   * 	 - {@link sap.ui.vk.NodeHierarchy#enumerateChildren sap.ui.vk.NodeHierarchy.enumerateChildren}
   * 	 - {@link sap.ui.vk.NodeHierarchy#enumerateAncestors sap.ui.vk.NodeHierarchy.enumerateAncestors}
   * 	 - {@link sap.ui.vk.ViewStateManager#enumerateSelection sap.ui.vk.ViewStateManager.enumerateSelection }
   */
  export default class BaseNodeProxy
    extends BaseNodeProxy1
    implements Poolable
  {
    __implements__sap_ui_base_Poolable: boolean;
    /**
     * Constructor for a new BaseNodeProxy. The objects of this class should not be created directly, and should
     * only be created through the use of the following methods:
     * 	 - {@link sap.ui.vk.NodeHierarchy#enumerateChildren sap.ui.vk.NodeHierarchy.enumerateChildren}
     * 	 - {@link sap.ui.vk.NodeHierarchy#enumerateAncestors sap.ui.vk.NodeHierarchy.enumerateAncestors}
     * 	 - {@link sap.ui.vk.ViewStateManager#enumerateSelection sap.ui.vk.ViewStateManager.enumerateSelection }
     *
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     *
     * This class does not have its own settings, but all settings applicable to the base type {@link sap.ui.vk.BaseNodeProxy#constructor sap.ui.vk.BaseNodeProxy }
     * can be used.
     */
    constructor();

    /**
     * Creates a new subclass of class sap.ui.vk.svg.BaseNodeProxy with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.vk.BaseNodeProxy.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, BaseNodeProxy>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.svg.BaseNodeProxy.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): Metadata;
    /**
     * Gets the name of the node.
     *
     *
     * @returns The node's name.
     */
    getName(): string;
    /**
     * Gets the node reference.
     *
     *
     * @returns The node reference.
     */
    getNodeId(): any;
    /**
     * Gets the metadata of the node.
     *
     *
     * @returns A JSON object containing the node's metadata.
     */
    getNodeMetadata(): object;
    /**
     * Gets the reference object of the node.
     *
     *
     * @returns The node's reference object.
     */
    getNodeRef(): object;
    /**
     * Gets the scene reference that this BaseNodeProxy object wraps.
     *
     *
     * @returns A scene reference that this BaseNodeProxy object wraps.
     */
    getSceneRef(): any;
    /**
     * Initialize this BaseNodeProxy with its data.
     *
     * The `init` method is called by an object pool when the object is (re-)activated for a new caller.
     * See:
     * 	sap.ui.base.Poolable.prototype#init
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    init(
      /**
       * The NodeHierarchy object this BaseNodeProxy object belongs to.
       */
      nodeHierarchy: NodeHierarchy,
      /**
       * The reference object of the node for which to get BaseNodeProxy.
       */
      nodeRef: any
    ): void;
    /**
     * Reset BaseNodeProxy data, needed for pooling.
     * See:
     * 	sap.ui.base.Poolable.prototype#reset
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    reset(): void;
  }
}

declare module "sap/ui/vk/svg/ContentManager" {
  import {
    default as ContentManager1,
    $ContentManagerSettings as $ContentManagerSettings1,
  } from "sap/ui/vk/ContentManager";

  import ManagedObjectMetadata from "sap/ui/base/ManagedObjectMetadata";

  import ContentResource from "sap/ui/vk/ContentResource";

  import Event from "sap/ui/base/Event";

  /**
   * Provides a content manager object that uses to load 2D content.
   *
   * When registering a content manager resolver with {@link sap.ui.vk.ContentConnector.addContentManagerResolver sap.ui.vk.ContentConnector.addContentManagerResolver }
   * you can pass a function that will load a model and merge it into the three.js scene.
   *
   * @since 1.80.0
   * @ui5-protected DO NOT USE IN APPLICATIONS (only for related classes in the framework)
   */
  export default class ContentManager extends ContentManager1 {
    /**
     * Constructor for a new ContentManager.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     * See:
     * 	{@link sap.ui.vk.ContentConnector.addContentManagerResolver sap.ui.vk.ContentConnector.addContentManagerResolver }
     * for an example.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    protected constructor(
      /**
       * Initial settings for the new ContentManager object.
       */
      mSettings?: $ContentManagerSettings
    );
    /**
     * Constructor for a new ContentManager.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     * See:
     * 	{@link sap.ui.vk.ContentConnector.addContentManagerResolver sap.ui.vk.ContentConnector.addContentManagerResolver }
     * for an example.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    protected constructor(
      /**
       * ID for the new ContentManager object. Generated automatically if no ID is given.
       */
      sId?: string,
      /**
       * Initial settings for the new ContentManager object.
       */
      mSettings?: $ContentManagerSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vk.svg.ContentManager with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.vk.ContentManager.extend}.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ContentManager>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.svg.ContentManager.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ManagedObjectMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:errorReported errorReported} event of this `sap.ui.vk.svg.ContentManager`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.svg.ContentManager` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachErrorReported(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ContentManager$ErrorReportedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.svg.ContentManager` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:errorReported errorReported} event of this `sap.ui.vk.svg.ContentManager`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.svg.ContentManager` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachErrorReported(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ContentManager$ErrorReportedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.svg.ContentManager` itself
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:errorReported errorReported} event of this
     * `sap.ui.vk.svg.ContentManager`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachErrorReported(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: ContentManager$ErrorReportedEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:errorReported errorReported} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireErrorReported(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: ContentManager$ErrorReportedEventParameters
    ): this;
    /**
     * Starts downloading and building or updating the content from the content resources.
     *
     * This method is asynchronous.
     *
     * @since 1.80.0
     *
     * @returns `this` to allow method chaining.
     */
    loadContent(
      /**
       * The current content to update. It can be `null` if this is an initial loading call.
       */
      content: any,
      /**
       * The content resources to load or update.
       */
      contentResources: ContentResource[]
    ): this;
  }
  /**
   * Describes the settings that can be provided to the ContentManager constructor.
   *
   * @ui5-protected DO NOT USE IN APPLICATIONS (only for related classes in the framework)
   */
  export interface $ContentManagerSettings extends $ContentManagerSettings1 {
    errorReported?: (oEvent: ContentManager$ErrorReportedEvent) => void;
  }

  /**
   * Parameters of the ContentManager#errorReported event.
   *
   * @ui5-protected DO NOT USE IN APPLICATIONS (only for related classes in the framework)
   */
  export interface ContentManager$ErrorReportedEventParameters {
    error?: any;
  }

  /**
   * Event object of the ContentManager#errorReported event.
   *
   * @ui5-protected DO NOT USE IN APPLICATIONS (only for related classes in the framework)
   */
  export type ContentManager$ErrorReportedEvent = Event<
    ContentManager$ErrorReportedEventParameters,
    ContentManager
  >;
}

declare module "sap/ui/vk/svg/NodeHierarchy" {
  import {
    default as NodeHierarchy1,
    $NodeHierarchySettings as $NodeHierarchySettings1,
  } from "sap/ui/vk/NodeHierarchy";

  import LayerProxy from "sap/ui/vk/LayerProxy";

  import NodeContentType from "sap/ui/vk/NodeContentType";

  import NodeProxy from "sap/ui/vk/NodeProxy";

  import ManagedObjectMetadata from "sap/ui/base/ManagedObjectMetadata";

  import Scene from "sap/ui/vk/Scene";

  /**
   * Provides the ability to explore a Scene object's node structure.
   *
   * The objects of this class should not be created directly, and should only be created via a call to {@link sap.ui.vk.Scene#getDefaultNodeHierarchy sap.ui.vk.Scene#getDefaultNodeHierarchy}.
   */
  export default class NodeHierarchy extends NodeHierarchy1 {
    /**
     * Constructor for a new NodeHierarchy.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     *
     * This class does not have its own settings, but all settings applicable to the base type {@link sap.ui.vk.NodeHierarchy#constructor sap.ui.vk.NodeHierarchy }
     * can be used.
     */
    constructor();

    /**
     * Creates a new subclass of class sap.ui.vk.svg.NodeHierarchy with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.vk.NodeHierarchy.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, NodeHierarchy>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.svg.NodeHierarchy.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ManagedObjectMetadata;
    /**
     * Creates a layer proxy object.
     *
     * The layer proxy object must be destroyed with the {@link #destroyLayerProxy destroyLayerProxy} method.
     *
     *
     * @returns The proxy object.
     */
    createLayerProxy(
      /**
       * The layer ID for which to create a proxy object.
       */
      layerId: string
    ): LayerProxy;
    /**
     * Creates a new node.
     *
     * @since 1.80.0
     *
     * @returns The reference object of the newly created node.
     */
    createNode(
      /**
       * The reference object of the parent node where the created node is added to. If equals `null` the newly
       * created node is a top level node.
       */
      parentNode: /* was: sap.ui.vk.svg.Element */ any,
      /**
       * The name of the new node.
       */
      name: string,
      /**
       * The created node is added before this specified node. If equals `null` the newly created node is added
       * at the end of the parent's list of nodes.
       */
      insertBeforeNode: /* was: sap.ui.vk.svg.Element */ any,
      /**
       * The created node content type.
       */
      nodeContentType?: NodeContentType | keyof typeof NodeContentType,
      /**
       * Optional Json structure used to define node properties.
       */
      content?: object
    ): /* was: sap.ui.vk.svg.Element */ any;
    /**
     * Creates a copy of an existing node.
     *
     * @since 1.80.0
     *
     * @returns The reference object of the newly created node.
     */
    createNodeCopy(
      /**
       * The reference object of the node to copy.
       */
      nodeToCopy: any,
      /**
       * The reference object of the parent node where the created node is added to. If equals `null` the newly
       * created node is a top level node.
       */
      parentNode: any,
      /**
       * The name of the new node.
       */
      name: string,
      /**
       * The created node is added before this specified node. If equals `null` the newly created node is added
       * at the end of the parent's list of nodes.
       */
      insertBeforeNode: any
    ): any;
    /**
     * Creates a node proxy object.
     *
     * The node proxy object must be destroyed with the {@link #destroyNodeProxy destroyNodeProxy} method.
     *
     *
     * @returns The proxy object.
     */
    createNodeProxy(
      /**
       * The reference object for which to create a proxy object.
       */
      nodeRef: any
    ): NodeProxy;
    /**
     * Destroys the layer proxy object.
     *
     *
     * @returns `this` to allow method chaining.
     */
    destroyLayerProxy(
      /**
       * The layer proxy object.
       */
      layerProxy: LayerProxy
    ): this;
    /**
     * Destroys the node proxy object.
     *
     *
     * @returns `this` to allow method chaining.
     */
    destroyNodeProxy(
      /**
       * The node proxy object.
       */
      nodeProxy: NodeProxy
    ): this;
    /**
     * Enumerates the ancestor nodes of a particular node in the Scene object.
     *
     * This method enumerates the ancestor nodes of a particular node, and then calls the `callback` function,
     * to which it passes the ancestor nodes to one by one.
     *  The BaseNodeProxy objects passed to `callback` are temporary objects, they are reset after each call
     * to the `callback` function.
     *  The ancestor nodes are enumerated starting from the top level node, and progresses down the node hierarchy.
     *
     *
     * @returns `this` to allow method chaining.
     */
    enumerateAncestors(
      /**
       * The reference object of a node whose ancestor nodes we want enumerated.
       */
      nodeRef: any,
      /**
       * A function to call when the ancestor nodes are enumerated. The function takes one parameter of type {@link sap.ui.vk.BaseNodeProxy},
       * or string if parameter `passNodeRef` parameter is `true`.
       */
      callback: Function,
      /**
       * Indicates whether to pass the node references of the ancestor nodes, or the whole node proxy to the `callback`
       * function.
       *  If `true`, then only the node references of the ancestor nodes are passed to the `callback` function.
       *
       *  If `false`, then the node proxies of the ancestor nodes are passed to the `callback` function.
       */
      passNodeRef?: boolean
    ): this;
    /**
     * Enumerates the child nodes of a particular node in the Scene object.
     *
     * This method gets the child nodes of a particular node, and then calls the `callback` function to which
     * it passes the child nodes to one by one.
     *  The `BaseNodeProxy` objects passed to the `callback` function are temporary objects, which are reset
     * after each call to the `callback` function.
     *
     *
     *
     * @returns `this` to allow method chaining.
     */
    enumerateChildren(
      /**
       * The reference object of a node whose child nodes we want enumerated.
       *  When `nodeRef` is specified, the child nodes of this node are enumerated.
       *  When no `nodeRef` is specified, only the top level nodes are enumerated.
       */
      nodeRef: any,
      /**
       * A function to call when the child nodes are enumerated. The function takes one parameter of type {@link sap.ui.vk.BaseNodeProxy},
       * or string if parameter `passNodeRef` parameter is `true`.
       */
      callback: Function,
      /**
       * Indicates whether to enumerate the child nodes if the node is closed.
       *  If `true`, the children of that closed node will be enumerated
       *  If `false`, the children of that node will not be enumerated
       */
      stepIntoClosedNodes?: boolean,
      /**
       * Indicates whether to pass the node references of the child nodes, or the whole node proxy to the `callback`
       * function.
       *  If `true`, then only the node references of the child nodes are passed to the `callback` function.
       *  If `false`, then the node proxies created from the child node references are passed to the `callback`
       * function.
       */
      passNodeRef?: boolean
    ): this;
    /**
     * Enumerates the child nodes of a particular node in the Scene object.
     *
     * This method gets the child nodes of a particular node, and then calls the `callback` function to which
     * it passes the child nodes to one by one.
     *  The `BaseNodeProxy` objects passed to the `callback` function are temporary objects, which are reset
     * after each call to the `callback` function.
     *
     *
     *
     * @returns `this` to allow method chaining.
     */
    enumerateChildren(
      /**
       * A function to call when the child nodes are enumerated. The function takes one parameter of type {@link sap.ui.vk.BaseNodeProxy},
       * or string if parameter `passNodeRef` parameter is `true`.
       */
      callback: Function,
      /**
       * Indicates whether to enumerate the child nodes if the node is closed.
       *  If `true`, the children of that closed node will be enumerated
       *  If `false`, the children of that node will not be enumerated
       */
      stepIntoClosedNodes?: boolean,
      /**
       * Indicates whether to pass the node references of the child nodes, or the whole node proxy to the `callback`
       * function.
       *  If `true`, then only the node references of the child nodes are passed to the `callback` function.
       *  If `false`, then the node proxies created from the child node references are passed to the `callback`
       * function.
       */
      passNodeRef?: boolean
    ): this;
    /**
     * Finds nodes in a scene via node name.
     *
     *
     * @returns A list of reference objects belonging to nodes that matched the search criteria.
     */
    findNodesByName(
      /**
       * JSON object containing the search parameters.
       *  The following example shows what the structure of the `query` object should look like:
       * ```javascript
       * query = {
       * 	value: string | string[],
       * 	predicate: "equals" | "contains" | "startsWith",
       * 	caseSensitive: true | false
       * }```
       *
       *
       * 	 -  **query.value**
       *  A string or an array of strings containing the name of a node or names of nodes. If no value is specified,
       * then all nodes in the scene will be returned.
       *  The following example shows a single string being passed in:
       * ```javascript
       * value: "Box #14"```
       *  The following example shows an array of strings being passed in:
       * ```javascript
       * value: ["Box #3", "box #4", "BOX #5"]```
       *
       * 	 -  **query.predicate**
       *  Represents a search mode. The available search modes are `"equals"`, `"contains"`, and `"startsWith"`.
       *
       *  Using `"equals"` will search for nodes with names that exactly match the provided string or array of
       * strings.
       *  Using `"contains"` will search for nodes with names containing all or part of the provided string or
       * array of strings.
       *  Using `"startsWith"` will search for nodes with names starting with the provided string or array of
       * strings.
       *  If no value is specified, the search mode will default to `"equals"`.
       *
       *
       * 	 -  **query.caseSensitive**
       *  Indicates whether the search should be case sensitive or not.
       *  If `true`, the search will be case sensitive, and `false` indicates otherwise.
       *  If no value is specified, `caseSensitive` will default to `false` (that is, the search will be a case-insensitive
       * search).
       */
      query: object
    ): /* was: sap.ui.vk.svg.Element */ any[];
    /**
     * Returns a list of reference objects belonging to the ancestors of a particular node.
     *
     *
     * @returns A list of reference objects belonging to the ancestors of `nodeRef`.
     */
    getAncestors(
      /**
       * The reference object of the node whose ancestors will be returned.
       */
      nodeRef: any
    ): any[];
    /**
     * Returns a list of reference objects belonging to the children of a particular node.
     *
     *
     * @returns A list of reference objects belonging to the children of `nodeRef`.
     */
    getChildren(
      /**
       * The reference object of the node whose children will be returned. If `nodeRef` is not passed to the `getChildren`
       * function, the reference objects of the root nodes will be returned.
       */
      nodeRef: any,
      /**
       * Indicates whether to return only the child nodes of a closed node or not. If `true`, then the
       * children of that closed node will be returned. If `false`, then the children of that closed node
       * will not be returned.
       */
      stepIntoClosedNodes?: boolean
    ): any[];
    /**
     * Returns a list of hotspot node references.
     *
     *
     * @returns A list of hotspot node references.
     */
    getHotspotNodeRefs(): any[];
    /**
     * Returns a list of layer IDs.
     *
     *
     * @returns A list of layer IDs.
     */
    getLayers(): string[];
    /**
     * Get node content type
     *
     * @since 1.80.0
     *
     * @returns Node content type
     */
    getNodeContentType(
      /**
       * The node reference
       */
      nodeRef: any
    ): NodeContentType;
    /**
     * Gets the Scene object the node hierarchy belongs to.
     *
     *
     * @returns The Scene object the node hierarchy belongs to.
     */
    getScene(): Scene;
    /**
     * Gets the scene reference that this NodeHierarchy object wraps.
     *
     *
     * @returns The scene reference that this NodeHierarchy object wraps.
     */
    getSceneRef(): any;
    /**
     * Deletes a node and destroys it.
     *
     * @since 1.80.0
     *
     * @returns `this` to allow method chaining.
     */
    removeNode(
      /**
       * The reference object of a node or an array of nodes to destroy.
       */
      nodeRef: any
    ): this;
  }
  /**
   * Describes the settings that can be provided to the NodeHierarchy constructor.
   */
  export interface $NodeHierarchySettings extends $NodeHierarchySettings1 {}
}

declare module "sap/ui/vk/svg/NodeProxy" {
  import {
    default as NodeProxy1,
    $NodeProxySettings as $NodeProxySettings1,
  } from "sap/ui/vk/NodeProxy";

  import ManagedObjectMetadata from "sap/ui/base/ManagedObjectMetadata";

  /**
   * Provides a proxy object to the node in the node hierarchy.
   *
   * Objects of this type should only be created with the {@link sap.ui.vk.NodeHierarchy#createNodeProxy sap.ui.vk.NodeHierarchy.createNodeProxy }
   * method. and destroyed with the {@link sap.ui.vk.NodeHierarchy#destroyNodeProxy sap.ui.vk.NodeHierarchy.destroyNodeProxy }
   * method.
   */
  export default class NodeProxy extends NodeProxy1 {
    /**
     * Constructor for a new NodeProxy.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     *
     * This class does not have its own settings, but all settings applicable to the base type {@link sap.ui.vk.NodeProxy#constructor sap.ui.vk.NodeProxy }
     * can be used.
     */
    constructor();

    /**
     * Creates a new subclass of class sap.ui.vk.svg.NodeProxy with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.vk.NodeProxy.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, NodeProxy>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.svg.NodeProxy.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ManagedObjectMetadata;
  }
  /**
   * Describes the settings that can be provided to the NodeProxy constructor.
   */
  export interface $NodeProxySettings extends $NodeProxySettings1 {}
}

declare module "sap/ui/vk/svg/OrthographicCamera" {
  import {
    default as OrthographicCamera1,
    $OrthographicCameraSettings as $OrthographicCameraSettings1,
  } from "sap/ui/vk/OrthographicCamera";

  import ManagedObjectMetadata from "sap/ui/base/ManagedObjectMetadata";

  /**
   * Provides the interface for the camera.
   *
   * @since 1.80.0
   */
  export default class OrthographicCamera extends OrthographicCamera1 {
    /**
     * Constructor for a new OrthographicCamera.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     *
     * This class does not have its own settings, but all settings applicable to the base type {@link sap.ui.vk.OrthographicCamera#constructor sap.ui.vk.OrthographicCamera }
     * can be used.
     */
    constructor();

    /**
     * Creates a new subclass of class sap.ui.vk.svg.OrthographicCamera with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.vk.OrthographicCamera.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, OrthographicCamera>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.svg.OrthographicCamera.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ManagedObjectMetadata;
  }
  /**
   * Describes the settings that can be provided to the OrthographicCamera constructor.
   */
  export interface $OrthographicCameraSettings
    extends $OrthographicCameraSettings1 {}
}

declare module "sap/ui/vk/svg/Scene" {
  import {
    default as Scene1,
    $SceneSettings as $SceneSettings1,
  } from "sap/ui/vk/Scene";

  import NodeHierarchy from "sap/ui/vk/NodeHierarchy";

  import View from "sap/ui/vk/View";

  import ManagedObjectMetadata from "sap/ui/base/ManagedObjectMetadata";

  /**
   * Provides the interface for the 2D model.
   *
   * The objects of this class should not be created directly.
   */
  export default class Scene extends Scene1 {
    /**
     * Constructor for a new Scene.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     *
     * This class does not have its own settings, but all settings applicable to the base type {@link sap.ui.vk.Scene#constructor sap.ui.vk.Scene }
     * can be used.
     */
    constructor();

    /**
     * Creates a new subclass of class sap.ui.vk.svg.Scene with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.vk.Scene.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Scene>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.svg.Scene.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ManagedObjectMetadata;
    /**
     * Gets the default node hierarchy in the Scene object.
     *
     *
     * @returns The default node hierarchy in the Scene object.
     */
    getDefaultNodeHierarchy(): NodeHierarchy;
    /**
     * Gets the unique ID of the Scene object.
     *
     *
     * @returns The unique ID of the Scene object.
     */
    getId(): string;
    /**
     * Get initial view
     *
     *
     * @returns initial view
     */
    getInitialView(): View;
    /**
     * Gets the root element reference for the Scene object.
     *
     *
     * @returns The root element.
     */
    getRootElement(): /* was: sap.ui.vk.svg.Element */ any;
    /**
     * Gets the persistent ID from node reference.
     *
     *
     * @returns The persistent ID or the array of the persistent IDs.
     */
    nodeRefToPersistentId(
      /**
       * The reference to the node or the array of references to the nodes.
       */
      nodeRefs: /* was: sap.ui.vk.svg.Element */
        | any
        | /* was: sap.ui.vk.svg.Element */ any[]
    ): string | string[];
    /**
     * Gets the node reference from persistent ID.
     *
     *
     * @returns The reference to the node or the array of references to the nodes.
     */
    persistentIdToNodeRef(
      /**
       * The persistent ID or the array of the persistent IDs.
       */
      pIDs: string | string[]
    ): /* was: sap.ui.vk.svg.Element */
      | any
      | /* was: sap.ui.vk.svg.Element */ any[];
    /**
     * Set initial view
     */
    setInitialView(
      /**
       * Initial view
       */
      view: View
    ): void;
  }
  /**
   * Describes the settings that can be provided to the Scene constructor.
   */
  export interface $SceneSettings extends $SceneSettings1 {}
}

declare module "sap/ui/vk/svg/Viewport" {
  import {
    default as ViewportBase,
    $ViewportBaseSettings,
  } from "sap/ui/vk/ViewportBase";

  import View from "sap/ui/vk/View";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import Dialog from "sap/m/Dialog";

  import Scene from "sap/ui/vk/svg/Scene";

  import { CSSColor } from "sap/ui/core/library";

  import ZoomTo from "sap/ui/vk/ZoomTo";

  import Viewport1 from "sap/ui/vk/Viewport";

  import Event from "sap/ui/base/Event";

  /**
   * Provides a control for SVG representation of 2D drawing data.
   */
  export default class Viewport extends ViewportBase {
    /**
     * Constructor for a SVG viewport.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor();

    /**
     * Creates a new subclass of class sap.ui.vk.svg.Viewport with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.vk.ViewportBase.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Viewport>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.svg.Viewport.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Activates the view based on view object passed
     *
     *
     * @returns returns this
     */
    activateView(
      /**
       * View object definition
       */
      view: View
    ): Viewport;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:cameraChanged cameraChanged} event of this `sap.ui.vk.svg.Viewport`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.svg.Viewport` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachCameraChanged(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Viewport$CameraChangedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.svg.Viewport` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:cameraChanged cameraChanged} event of this `sap.ui.vk.svg.Viewport`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.svg.Viewport` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachCameraChanged(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Viewport$CameraChangedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.svg.Viewport` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:hotspotEnter hotspotEnter} event of this `sap.ui.vk.svg.Viewport`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.svg.Viewport` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachHotspotEnter(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Viewport$HotspotEnterEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.svg.Viewport` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:hotspotEnter hotspotEnter} event of this `sap.ui.vk.svg.Viewport`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.svg.Viewport` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachHotspotEnter(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Viewport$HotspotEnterEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.svg.Viewport` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:hotspotLeave hotspotLeave} event of this `sap.ui.vk.svg.Viewport`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.svg.Viewport` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachHotspotLeave(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Viewport$HotspotLeaveEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.svg.Viewport` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:hotspotLeave hotspotLeave} event of this `sap.ui.vk.svg.Viewport`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.svg.Viewport` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachHotspotLeave(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Viewport$HotspotLeaveEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.svg.Viewport` itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys the miniMap in the aggregation {@link #getMiniMap miniMap}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyMiniMap(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:cameraChanged cameraChanged} event of this
     * `sap.ui.vk.svg.Viewport`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachCameraChanged(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Viewport$CameraChangedEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:hotspotEnter hotspotEnter} event of this `sap.ui.vk.svg.Viewport`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachHotspotEnter(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Viewport$HotspotEnterEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:hotspotLeave hotspotLeave} event of this `sap.ui.vk.svg.Viewport`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachHotspotLeave(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Viewport$HotspotLeaveEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:cameraChanged cameraChanged} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireCameraChanged(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: Viewport$CameraChangedEventParameters
    ): this;
    /**
     * Fires event {@link #event:hotspotEnter hotspotEnter} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireHotspotEnter(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: Viewport$HotspotEnterEventParameters
    ): this;
    /**
     * Fires event {@link #event:hotspotLeave hotspotLeave} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireHotspotLeave(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: Viewport$HotspotLeaveEventParameters
    ): this;
    /**
     * Get current view - remembered when activateView function is called
     *
     *
     * @returns Current view
     */
    getCurrentView(): View;
    /**
     * Returns viewport content as an image of desired size.
     *
     *
     * @returns Base64 encoded PNG image
     */
    getImage(
      /**
       * Requested image width in pixels. Allowed values are 8 to 2048, default is 16
       */
      width: int,
      /**
       * Requested image height in pixels. Allowed values are 8 to 2048, default is 16
       */
      height: int,
      /**
       * The sap.ui.core.CSSColor to be used for top background color
       */
      topColor: string,
      /**
       * The sap.ui.core.CSSColor to be used for bottom background color
       */
      bottomColor: string,
      /**
       * Include selected nodes
       */
      includeSelection: boolean
    ): string;
    /**
     * Gets content of aggregation {@link #getMiniMap miniMap}.
     */
    getMiniMap(): Dialog;
    /**
     * Gets position and size of the viewport square. The information can be used for making calculations when
     * restoring Redlining elements.
     *
     *
     * @returns The information in this object:
     * 	 - **left** - The x coordinate of the top-left corner of the square.
     * 	 - **top** - The y coordinate of the top-left corner of the square.
     * 	 - **sideLength** - The length of the square.
     */
    getOutputSize(): object;
    /**
     * Gets the Viewport Scene
     *
     *
     * @returns returns Scene
     */
    getScene(): Scene;
    /**
     * Retrieves information about the current camera view in the scene, and saves the information in a JSON-like
     * object. The information can then be used at a later time to restore the scene to the same camera view
     * using the {@link sap.ui.vk.Viewport#setViewInfo setViewInfo} method.
     *
     *
     *
     * @returns JSON-like object which holds the current view information. See {@link sap.ui.vk.Viewport#setViewInfo setViewInfo}.
     * In addition to properties defined in {@link sap.ui.vk.Viewport#setViewInfo setViewInfo} the output from
     * {@link sap.ui.vk.Viewport#getViewInfo getViewInfo} contains camera view and projection matrices
     * ```javascript
     *
     *   {
     *     ...
     *   }
     * ```
     */
    getViewInfo(
      /**
       * Query object which indicates what information to be retrieved.
       */
      query?: {
        /**
         * Indicator to retrieve visibility information.
         */
        visibility?:
          | boolean
          | {
              /**
               * Indicator to retrieve the complete visibility definition or just the difference.
               */
              mode?: /* was: sap.ui.vk.VisibilityMode */ any;
            };
        /**
         * Indicator to retrieve selection information.
         */
        selection?: boolean | object;
      }
    ): object;
    /**
     * Queues a command for execution during the rendering cycle. All gesture operations should be called using
     * this method.
     *
     *
     * @returns returns this
     */
    queueCommand(
      /**
       * The command to be executed.
       */
      command: Function
    ): Viewport;
    /**
     * Sets the aggregated {@link #getMiniMap miniMap}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMiniMap(
      /**
       * The miniMap to set
       */
      oMiniMap: Dialog
    ): this;
    /**
     * Attaches the scene to the Viewport for rendering.
     *
     * @deprecated As of version 1.80.0. Viewport now gets reference to the scene via {@link sap.ui.vk.ContentConnector}.
     *
     * @returns `this` to allow method chaining.
     */
    setScene(
      /**
       * The scene to attach to the Viewport.
       */
      scene: Scene
    ): this;
    /**
     * Sets the current scene to use the camera view information acquired from the {@link sap.ui.vk.Viewport#getViewInfo getViewInfo }
     * method.
     *  Internally, the `setViewInfo` method activates certain steps at certain animation times, and then changes
     * the camera position, rotation and field of view (FOV) / zoom factor.
     *
     *
     * @returns `this` to allow method chaining.
     */
    setViewInfo(
      /**
       * A JSON-like object containing view information acquired using the {@link sap.ui.vk.Viewport#getViewInfo getViewInfo }
       * method.
       */
      viewInfo: {
        /**
         * A JSON-like object containing the camera information.
         */
        camera?: object;
        /**
         * A JSON-like object containing the visibility information.
         */
        visibility?: {
          /**
           * If the mode equals to {@link sap.ui.vk.VisibilityMode.Complete complete} then the visible and hidden
           * fields are defined. If the mode equals {@link sap.ui.vk.VisibilityMode.Differences differences} then
           * the changes field is defined.
           */
          mode: /* was: sap.ui.vk.VisibilityMode */ any;
          /**
           * List of Ids of visible nodes.
           */
          visible: string[];
          /**
           * List of Ids of hidden nodes.
           */
          hidden: string[];
          /**
           * List of Ids of nodes with inverted visibility.
           */
          changes: string[];
        };
        /**
         * A JSON-like object containing the selection information.
         */
        selection?: {
          /**
           * List of Ids of selected nodes.
           */
          selected: string[];
          /**
           * List of Ids of outlined nodes.
           */
          outlined: string[];
        };
      },
      /**
       * Fly-to animation duration in seconds.
       */
      flyToDuration?: float
    ): this;
    /**
     *
     * @returns `this` to allow method chaining.
     */
    showHotspots(
      /**
       * The node reference or the array of node references that we want to tint.
       */
      nodeRefs: any | any[],
      /**
       * Whether to highlight the nodes or remove the highlight.
       */
      show: boolean,
      /**
       * The color to use for highlighting the nodes passed as argument.
       */
      color: int | CSSColor
    ): this;
    /**
     * Zooms the scene to a bounding box created from a particular set of nodes.
     *
     *
     * @returns this
     */
    zoomTo(
      /**
       * What set of nodes to zoom to.
       */
      what: ZoomTo | ZoomTo[],
      /**
       * Is used if what == (sap.ui.vk.ZoomTo.Node || ZoomTo.NodeSetIsolation)
       */
      nodeRef: any,
      /**
       * Time to perform the "fly to" animation. Set to 0 to do this immediately.
       */
      crossFadeSeconds: float,
      /**
       * Margin. Set to 0 to zoom to the entire screen.
       */
      margin: float
    ): Viewport1;
  }
  /**
   * Describes the settings that can be provided to the Viewport constructor.
   */
  export interface $ViewportSettings extends $ViewportBaseSettings {
    miniMap?: Dialog;

    cameraChanged?: (oEvent: Viewport$CameraChangedEvent) => void;

    hotspotEnter?: (oEvent: Viewport$HotspotEnterEvent) => void;

    hotspotLeave?: (oEvent: Viewport$HotspotLeaveEvent) => void;
  }

  /**
   * Parameters of the Viewport#cameraChanged event.
   */
  export interface Viewport$CameraChangedEventParameters {
    /**
     * Returns a new camera offset.
     */
    offset?: float[];

    /**
     * Returns a new camera zoom factor.
     */
    zoom?: float;
  }

  /**
   * Event object of the Viewport#cameraChanged event.
   */
  export type Viewport$CameraChangedEvent = Event<
    Viewport$CameraChangedEventParameters,
    Viewport
  >;

  /**
   * Parameters of the Viewport#hotspotEnter event.
   */
  export interface Viewport$HotspotEnterEventParameters {
    nodeRef?: any;
  }

  /**
   * Event object of the Viewport#hotspotEnter event.
   */
  export type Viewport$HotspotEnterEvent = Event<
    Viewport$HotspotEnterEventParameters,
    Viewport
  >;

  /**
   * Parameters of the Viewport#hotspotLeave event.
   */
  export interface Viewport$HotspotLeaveEventParameters {
    nodeRef?: any;
  }

  /**
   * Event object of the Viewport#hotspotLeave event.
   */
  export type Viewport$HotspotLeaveEvent = Event<
    Viewport$HotspotLeaveEventParameters,
    Viewport
  >;
}

declare module "sap/ui/vk/svg/ViewStateManager" {
  import {
    default as ViewStateManagerBase,
    $ViewStateManagerBaseSettings,
  } from "sap/ui/vk/ViewStateManagerBase";

  import { CSSColor } from "sap/ui/core/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import NodeHierarchy from "sap/ui/vk/NodeHierarchy";

  /**
   * Manages the visibility and selection states of nodes in the scene.
   *
   * @since 1.80.0
   */
  export default class ViewStateManager extends ViewStateManagerBase {
    /**
     * Constructor for a new ViewStateManager.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     *
     * This class does not have its own settings, but all settings applicable to the base type {@link sap.ui.vk.ViewStateManagerBase#constructor sap.ui.vk.ViewStateManagerBase }
     * can be used.
     */
    constructor(
      /**
       * Initial settings for the new ViewStateManager object.
       */
      mSettings?: $ViewStateManagerSettings
    );
    /**
     * Constructor for a new ViewStateManager.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     *
     * This class does not have its own settings, but all settings applicable to the base type {@link sap.ui.vk.ViewStateManagerBase#constructor sap.ui.vk.ViewStateManagerBase }
     * can be used.
     */
    constructor(
      /**
       * ID for the new ViewStateManager object. Generated automatically if no ID is given.
       */
      sId?: string,
      /**
       * Initial settings for the new ViewStateManager object.
       */
      mSettings?: $ViewStateManagerSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vk.svg.ViewStateManager with name `sClassName` and enriches it
     * with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.vk.ViewStateManagerBase.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ViewStateManager>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.svg.ViewStateManager.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Enumerates IDs of the selected nodes.
     *
     *
     * @returns `this` to allow method chaining.
     */
    enumerateSelection(
      /**
       * A function to call when the selected nodes are enumerated. The function takes one parameter of type `string`.
       */
      callback: Function
    ): this;
    /**
     * Gets the default highlighting color
     *
     *
     * @returns A single value or an array of values. Value `null` means that the node's own tint color should
     * be used.
     */
    getHighlightColor(
      /**
       * This flag indicates to return the highlighting color in the ABGR format, if it equals `false` then the
       * color is returned in the CSS color format.
       */
      inABGRFormat?: boolean
    ): CSSColor | string | int;
    /**
     * Gets the NodeHierarchy object associated with this ViewStateManager object.
     *
     *
     * @returns The node hierarchy associated with this ViewStateManager object.
     */
    getNodeHierarchy(): NodeHierarchy;
    /**
     * Gets the opacity of the node.
     *
     * If a single node is passed to the method then a single value is returned.
     *  If an array of nodes is passed to the method then an array of values is returned.
     *
     *
     * @returns A single value or an array of values. Value `null` means that the node's own opacity should
     * be used.
     */
    getOpacity(
      /**
       * The node reference or the array of node references.
       */
      nodeRefs: any | any[]
    ): float | float[];
    /**
     * Gets the selection state of the node.
     *
     * If a single node reference is passed to the method then a single selection state is returned.
     *  If an array of node references is passed to the method then an array of selection states is returned.
     *
     *
     * @returns A single value or an array of values where the value is `true` if the node is selected, `false`
     * otherwise.
     */
    getSelectionState(
      /**
       * The node reference or the array of node references.
       */
      nodeRefs: any | any[]
    ): boolean | boolean[];
    /**
     * Gets the tint color of the node.
     *
     * If a single node reference is passed to the method then a single value is returned.
     *  If an array of node references is passed to the method then an array of values is returned.
     *
     *
     * @returns A single value or an array of values. Value `null` means that the node's own tint color should
     * be used.
     */
    getTintColor(
      /**
       * The node reference or the array of node references.
       */
      nodeRefs: any | any[],
      /**
       * This flag indicates to return the tint color in the ABGR format, if it equals `false` then the color
       * is returned in the CSS color format.
       */
      inABGRFormat?: boolean
    ): CSSColor | CSSColor[] | int | int[];
    /**
     * Gets the visibility changes in the current ViewStateManager object.
     *
     *
     * @returns The visibility changes are in the form of an array. The array is a list of node VE ids which
     * suffered a visibility changed relative to the default state.
     */
    getVisibilityChanges(): string[];
    /**
     * Gets the visibility state of nodes.
     *
     * If a single node is passed to the method then a single visibility state is returned.
     *  If an array of nodes is passed to the method then an array of visibility states is returned.
     *
     *
     * @returns A single value or an array of values where the value is `true` if the node is visible, `false`
     * otherwise.
     */
    getVisibilityState(
      /**
       * The node reference or the array of node references.
       */
      nodeRefs: any | any[]
    ): boolean | boolean[];
    /**
     * Sets the default highlighting color
     *
     *
     * @returns `this` to allow method chaining.
     */
    setHighlightColor(
      /**
       * The new highlighting color. The value can be defined as a string in the CSS color format or as an integer
       * in the ABGR format. If `null` is passed then the tint color is reset and the node's own tint color should
       * be used.
       */
      color: CSSColor | string | int
    ): this;
    /**
     * Sets the opacity of the nodes.
     *
     *
     * @returns `this` to allow method chaining.
     */
    setOpacity(
      /**
       * The node reference or the array of node references.
       */
      nodeRefs: any | any[],
      /**
       * The new opacity of the nodes. If `null` is passed then the opacity is reset and the node's own opacity
       * should be used.
       */
      opacity: float | float[] | null,
      /**
       * This flag is not used, as opacity is always recursively applied to the offspring nodes by multiplication
       */
      recursive?: boolean
    ): this;
    /**
     * Sets the selection state of the nodes.
     *
     * @deprecated As of version 1.80.0. Use {@link sap.ui.vk.svg.ViewStateManager#setSelectionStates} instead.
     *
     * @returns `this` to allow method chaining.
     */
    setSelectionState(
      /**
       * The node reference or the array of node references.
       */
      nodeRefs: any | any[],
      /**
       * The new selection state of the nodes.
       */
      selected: boolean,
      /**
       * The flags indicates if the change needs to propagate recursively to child nodes.
       */
      recursive: boolean,
      /**
       * The flag to suppress selectionChanged event.
       */
      blockNotification: boolean
    ): this;
    /**
     * Sets or resets the selection state of the nodes.
     *
     *
     * @returns `this` to allow method chaining.
     */
    setSelectionStates(
      /**
       * The node reference or the array of node references of selected nodes.
       */
      selectedNodeRefs: any | any[],
      /**
       * The node reference or the array of node references of unselected nodes.
       */
      unselectedNodeRefs: any | any[],
      /**
       * The flags indicates if the change needs to propagate recursively to child nodes.
       */
      recursive: boolean,
      /**
       * The flag to suppress selectionChanged event.
       */
      blockNotification: boolean
    ): this;
    /**
     * Sets the tint color of the nodes.
     *
     *
     * @returns `this` to allow method chaining.
     */
    setTintColor(
      /**
       * The node reference or the array of node references.
       */
      nodeRefs: any | any[],
      /**
       * The new tint color of the nodes. The value can be defined as a string in the CSS color format or as an
       * integer in the ABGR format or it could be array of these values. If `null` is passed then the tint color
       * is reset and the node's own tint color should be used.
       */
      tintColor: CSSColor | int | CSSColor[] | int[] | null,
      /**
       * This flag indicates if the change needs to propagate recursively to child nodes.
       */
      recursive?: boolean
    ): this;
    /**
     * Sets the visibility state of the nodes.
     *
     *
     * @returns `this` to allow method chaining.
     */
    setVisibilityState(
      /**
       * The node reference or the array of node references.
       */
      nodeRefs: any | any[],
      /**
       * The new visibility state or array of states of the nodes.
       */
      visible: boolean | boolean[],
      /**
       * The flags indicates if the change needs to propagate recursively to child nodes.
       */
      recursive: boolean,
      /**
       * If a node is made visible but its parent is hidden then it will still be hidden in Viewport. This flag
       * will force node to be visible regardless of parent's state.
       */
      force: boolean
    ): this;
  }
  /**
   * Describes the settings that can be provided to the ViewStateManager constructor.
   */
  export interface $ViewStateManagerSettings
    extends $ViewStateManagerBaseSettings {}
}

declare module "sap/ui/vk/Texture" {
  import {
    default as ManagedObject,
    $ManagedObjectSettings,
    PropertyBindingInfo,
  } from "sap/ui/base/ManagedObject";

  import ManagedObjectMetadata from "sap/ui/base/ManagedObjectMetadata";

  /**
   * Provides the interface for the texture.
   *
   * @experimental As of version 1.58.0. This class is experimental and might be modified or removed in future
   * versions.
   */
  export default class Texture extends ManagedObject {
    /**
     * Constructor for a new texture
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor();

    /**
     * Creates a new subclass of class sap.ui.vk.Texture with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.base.ManagedObject.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Texture>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.Texture.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ManagedObjectMetadata;
    /**
     * Gets current value of property {@link #getFilterMode filterMode}.
     *
     * filter mode - Bilinear = 0, NearestNeighbor = 1
     *
     * Default value is `0`.
     *
     *
     * @returns Value of property `filterMode`
     */
    getFilterMode(): int;
    /**
     *
     * @returns Texture reference that this texture class wraps
     */
    getTextRef(): any;
    /**
     * Gets current value of property {@link #getUvHorizontalOffset uvHorizontalOffset}.
     *
     * Horizontal offset of uv coordinates
     *
     * Default value is `0.0`.
     *
     *
     * @returns Value of property `uvHorizontalOffset`
     */
    getUvHorizontalOffset(): float;
    /**
     * Gets current value of property {@link #getUvHorizontalScale uvHorizontalScale}.
     *
     * Horizontal scale of uv coordinates
     *
     * Default value is `0.0`.
     *
     *
     * @returns Value of property `uvHorizontalScale`
     */
    getUvHorizontalScale(): float;
    /**
     * Gets current value of property {@link #getUvHorizontalTilingEnabled uvHorizontalTilingEnabled}.
     *
     * Is the uv horizontal tiling enabled
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `uvHorizontalTilingEnabled`
     */
    getUvHorizontalTilingEnabled(): boolean;
    /**
     * Gets current value of property {@link #getUvRotationAngle uvRotationAngle}.
     *
     * Rotation angle of uv coordinates
     *
     * Default value is `0.0`.
     *
     *
     * @returns Value of property `uvRotationAngle`
     */
    getUvRotationAngle(): float;
    /**
     * Gets current value of property {@link #getUvVerticalOffset uvVerticalOffset}.
     *
     * VerticalOffset offset of uv coordinates
     *
     * Default value is `0.0`.
     *
     *
     * @returns Value of property `uvVerticalOffset`
     */
    getUvVerticalOffset(): float;
    /**
     * Gets current value of property {@link #getUvVerticalScale uvVerticalScale}.
     *
     * Vertical scale of uv coordinates
     *
     * Default value is `0.0`.
     *
     *
     * @returns Value of property `uvVerticalScale`
     */
    getUvVerticalScale(): float;
    /**
     * Gets current value of property {@link #getUvVerticalTilingEnabled uvVerticalTilingEnabled}.
     *
     * Is the uv vertical tiling enabled
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `uvVerticalTilingEnabled`
     */
    getUvVerticalTilingEnabled(): boolean;
    /**
     * Load texture image.
     *
     *
     * @returns This allows method chaining
     */
    load(
      /**
       * resource url for image.
       */
      imageUrl: string
    ): Texture;
    /**
     * Sets a new value for property {@link #getFilterMode filterMode}.
     *
     * filter mode - Bilinear = 0, NearestNeighbor = 1
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `0`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFilterMode(
      /**
       * New value for property `filterMode`
       */
      iFilterMode?: int
    ): this;
    /**
     * Sets a new value for property {@link #getUvHorizontalOffset uvHorizontalOffset}.
     *
     * Horizontal offset of uv coordinates
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `0.0`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setUvHorizontalOffset(
      /**
       * New value for property `uvHorizontalOffset`
       */
      fUvHorizontalOffset?: float
    ): this;
    /**
     * Sets a new value for property {@link #getUvHorizontalScale uvHorizontalScale}.
     *
     * Horizontal scale of uv coordinates
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `0.0`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setUvHorizontalScale(
      /**
       * New value for property `uvHorizontalScale`
       */
      fUvHorizontalScale?: float
    ): this;
    /**
     * Sets a new value for property {@link #getUvHorizontalTilingEnabled uvHorizontalTilingEnabled}.
     *
     * Is the uv horizontal tiling enabled
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setUvHorizontalTilingEnabled(
      /**
       * New value for property `uvHorizontalTilingEnabled`
       */
      bUvHorizontalTilingEnabled?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getUvRotationAngle uvRotationAngle}.
     *
     * Rotation angle of uv coordinates
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `0.0`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setUvRotationAngle(
      /**
       * New value for property `uvRotationAngle`
       */
      fUvRotationAngle?: float
    ): this;
    /**
     * Sets a new value for property {@link #getUvVerticalOffset uvVerticalOffset}.
     *
     * VerticalOffset offset of uv coordinates
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `0.0`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setUvVerticalOffset(
      /**
       * New value for property `uvVerticalOffset`
       */
      fUvVerticalOffset?: float
    ): this;
    /**
     * Sets a new value for property {@link #getUvVerticalScale uvVerticalScale}.
     *
     * Vertical scale of uv coordinates
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `0.0`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setUvVerticalScale(
      /**
       * New value for property `uvVerticalScale`
       */
      fUvVerticalScale?: float
    ): this;
    /**
     * Sets a new value for property {@link #getUvVerticalTilingEnabled uvVerticalTilingEnabled}.
     *
     * Is the uv vertical tiling enabled
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setUvVerticalTilingEnabled(
      /**
       * New value for property `uvVerticalTilingEnabled`
       */
      bUvVerticalTilingEnabled?: boolean
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Texture constructor.
   *
   * @experimental As of version 1.58.0. This class is experimental and might be modified or removed in future
   * versions.
   */
  export interface $TextureSettings extends $ManagedObjectSettings {
    /**
     * Rotation angle of uv coordinates
     */
    uvRotationAngle?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * Horizontal offset of uv coordinates
     */
    uvHorizontalOffset?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * VerticalOffset offset of uv coordinates
     */
    uvVerticalOffset?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * Horizontal scale of uv coordinates
     */
    uvHorizontalScale?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * Vertical scale of uv coordinates
     */
    uvVerticalScale?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * Is the uv horizontal tiling enabled
     */
    uvHorizontalTilingEnabled?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Is the uv vertical tiling enabled
     */
    uvVerticalTilingEnabled?: boolean | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/ui/vk/threejs/BaseNodeProxy" {
  import BaseNodeProxy1 from "sap/ui/vk/BaseNodeProxy";

  import { Poolable } from "sap/ui/base/ObjectPool";

  import Metadata from "sap/ui/base/Metadata";

  import NodeHierarchy from "sap/ui/vk/threejs/NodeHierarchy";

  /**
   * Provides a simple, lightweight proxy object to a node in a node hierarchy.
   *
   * The objects of this class should not be created directly, and should only be created through the use
   * of the following methods:
   * 	 - {@link sap.ui.vk.NodeHierarchy#enumerateChildren sap.ui.vk.NodeHierarchy.enumerateChildren}
   * 	 - {@link sap.ui.vk.NodeHierarchy#enumerateAncestors sap.ui.vk.NodeHierarchy.enumerateAncestors}
   * 	 - {@link sap.ui.vk.ViewStateManager#enumerateSelection sap.ui.vk.ViewStateManager.enumerateSelection }
   */
  export default class BaseNodeProxy
    extends BaseNodeProxy1
    implements Poolable
  {
    __implements__sap_ui_base_Poolable: boolean;
    /**
     * Constructor for a new BaseNodeProxy. The objects of this class should not be created directly, and should
     * only be created through the use of the following methods:
     * 	 - {@link sap.ui.vk.NodeHierarchy#enumerateChildren sap.ui.vk.NodeHierarchy.enumerateChildren}
     * 	 - {@link sap.ui.vk.NodeHierarchy#enumerateAncestors sap.ui.vk.NodeHierarchy.enumerateAncestors}
     * 	 - {@link sap.ui.vk.ViewStateManager#enumerateSelection sap.ui.vk.ViewStateManager.enumerateSelection }
     *
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     *
     * This class does not have its own settings, but all settings applicable to the base type {@link sap.ui.vk.BaseNodeProxy#constructor sap.ui.vk.BaseNodeProxy }
     * can be used.
     */
    constructor();

    /**
     * Creates a new subclass of class sap.ui.vk.threejs.BaseNodeProxy with name `sClassName` and enriches it
     * with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.vk.BaseNodeProxy.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, BaseNodeProxy>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.threejs.BaseNodeProxy.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): Metadata;
    /**
     * Indicates whether the node has child nodes.
     *
     *
     * @returns A value of `true` indicates that the node has child nodes, and a value of `false` indicates
     * otherwise.
     */
    getHasChildren(): boolean;
    /**
     * Gets the name of the node.
     *
     *
     * @returns The node's name.
     */
    getName(): string;
    /**
     * Gets the node reference.
     *
     *
     * @returns The node reference.
     */
    getNodeId(): any;
    /**
     * Gets the metadata of the node.
     *
     *
     * @returns A JSON object containing the node's metadata.
     */
    getNodeMetadata(): object;
    /**
     * Gets the reference object of the node.
     *
     *
     * @returns The node's reference object.
     */
    getNodeRef(): object;
    /**
     * Gets the scene reference that this BaseNodeProxy object wraps.
     *
     *
     * @returns A scene reference that this BaseNodeProxy object wraps.
     */
    getSceneRef(): any;
    /**
     * Initialize this BaseNodeProxy with its data.
     *
     * The `init` method is called by an object pool when the object is (re-)activated for a new caller.
     * See:
     * 	sap.ui.base.Poolable.prototype#init
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    init(
      /**
       * The NodeHierarchy object this BaseNodeProxy object belongs to.
       */
      nodeHierarchy: NodeHierarchy,
      /**
       * The reference object of the node for which to get BaseNodeProxy.
       */
      nodeRef: any
    ): void;
    /**
     * Reset BaseNodeProxy data, needed for pooling.
     * See:
     * 	sap.ui.base.Poolable.prototype#reset
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    reset(): void;
  }
}

declare module "sap/ui/vk/threejs/ContentManager" {
  import {
    default as ContentManager1,
    $ContentManagerSettings as $ContentManagerSettings1,
  } from "sap/ui/vk/ContentManager";

  import OrthographicCamera from "sap/ui/vk/OrthographicCamera";

  import PerspectiveCamera from "sap/ui/vk/PerspectiveCamera";

  import ManagedObjectMetadata from "sap/ui/base/ManagedObjectMetadata";

  import ContentResource from "sap/ui/vk/ContentResource";

  /**
   * Provides a content manager object that uses the three.js library to load 3D files.
   *
   * When registering a content manager resolver with {@link sap.ui.vk.ContentConnector.addContentManagerResolver sap.ui.vk.ContentConnector.addContentManagerResolver }
   * you can pass a function that will load a model and merge it into the three.js scene.
   *
   * The loader function takes two parameters:
   * 	 - parentNode - {@link https://threejs.org/docs/index.html#api/objects/Group THREE.Group} - a grouping
   *     node to merge the content into
   * 	 - contentResource - {@link sap.ui.vk.ContentResource sap.ui.vk.ContentResource} - a content resource
   *     to load  The loader function returns a {@link https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Promise Promise }
   *     object. If the loading the model succeeds the promise object resolves with a value with the following
   *     structure:
   * 	 - node - {@link https://threejs.org/docs/index.html#api/objects/Group THREE.Group} - the grouping node
   *     to which the content is merged into. It should be the `parentNode` parameter that was passed to the loader
   *     function.
   * 	 - contentResource - {@link sap.ui.vk.ContentResource sap.ui.vk.ContentResource} - the content resource
   *     that was loaded.
   *
   * @since 1.50.0
   * @ui5-protected DO NOT USE IN APPLICATIONS (only for related classes in the framework)
   */
  export default class ContentManager extends ContentManager1 {
    /**
     * Constructor for a new ContentManager.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     *
     * This class does not have its own settings, but all settings applicable to the base type {@link sap.ui.vk.ContentManager#constructor sap.ui.vk.ContentManager }
     * can be used.
     * See:
     * 	{@link sap.ui.vk.ContentConnector.addContentManagerResolver sap.ui.vk.ContentConnector.addContentManagerResolver }
     * for an example.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    protected constructor(
      /**
       * Initial settings for the new ContentManager object.
       */
      mSettings?: $ContentManagerSettings
    );
    /**
     * Constructor for a new ContentManager.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     *
     * This class does not have its own settings, but all settings applicable to the base type {@link sap.ui.vk.ContentManager#constructor sap.ui.vk.ContentManager }
     * can be used.
     * See:
     * 	{@link sap.ui.vk.ContentConnector.addContentManagerResolver sap.ui.vk.ContentConnector.addContentManagerResolver }
     * for an example.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    protected constructor(
      /**
       * ID for the new ContentManager object. Generated automatically if no ID is given.
       */
      sId?: string,
      /**
       * Initial settings for the new ContentManager object.
       */
      mSettings?: $ContentManagerSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vk.threejs.ContentManager with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.vk.ContentManager.extend}.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ContentManager>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.threejs.ContentManager.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ManagedObjectMetadata;
    /**
     * Collects and destroys unused objects and resources.
     *
     * @since 1.50.0
     *
     * @returns `this` to allow method chaining.
     */
    collectGarbage(): this;
    /**
     * Creates an Orthographic camera
     *
     * @since 1.52.0
     *
     * @returns Created Camera.
     */
    createOrthographicCamera(): OrthographicCamera;
    /**
     * Creates a Perspective camera
     *
     * @since 1.52.0
     *
     * @returns Created Camera.
     */
    createPerspectiveCamera(): PerspectiveCamera;
    /**
     * Destroys the content.
     *
     * @since 1.50.0
     *
     * @returns `this` to allow method chaining.
     */
    destroyContent(
      /**
       * The content to destroy.
       */
      content: any
    ): this;
    /**
     * Starts downloading and building or updating the content from the content resources.
     *
     * This method is asynchronous.
     *
     * @since 1.50.0
     *
     * @returns `this` to allow method chaining.
     */
    loadContent(
      /**
       * The current content to update. It can be `null` if this is an initial loading call.
       */
      content: any,
      /**
       * The content resources to load or update.
       */
      contentResources: ContentResource[]
    ): this;
  }
  /**
   * Describes the settings that can be provided to the ContentManager constructor.
   *
   * @ui5-protected DO NOT USE IN APPLICATIONS (only for related classes in the framework)
   */
  export interface $ContentManagerSettings extends $ContentManagerSettings1 {}
}

declare module "sap/ui/vk/threejs/Material" {
  import Material1 from "sap/ui/vk/Material";

  import Metadata from "sap/ui/base/Metadata";

  /**
   * Provides the interface for the material.
   *
   * @experimental As of version 1.60.0. This class is experimental and might be modified or removed in future
   * versions.
   */
  export default class Material extends Material1 {
    /**
     * Constructor for a new Material.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     *
     * This class does not have its own settings, but all settings applicable to the base type {@link sap.ui.vk.Material#constructor sap.ui.vk.Material }
     * can be used.
     */
    constructor();

    /**
     * Creates a new subclass of class sap.ui.vk.threejs.Material with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.vk.Material.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Material>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.threejs.Material.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): Metadata;
  }
}

declare module "sap/ui/vk/threejs/MaterialType" {
  /**
   * Defines the three.js material type.
   */
  enum MaterialType {
    /**
     * Line basic material
     */
    LineBasicMaterial = "LineBasicMaterial",
    /**
     * Mesh basic material
     */
    MeshBasicMaterial = "MeshBasicMaterial",
    /**
     * Mesh phong material
     */
    MeshPhongMaterial = "MeshPhongMaterial",
  }
  export default MaterialType;
}

declare module "sap/ui/vk/threejs/NodeHierarchy" {
  import {
    default as NodeHierarchy1,
    $NodeHierarchySettings as $NodeHierarchySettings1,
  } from "sap/ui/vk/NodeHierarchy";

  import LayerProxy from "sap/ui/vk/LayerProxy";

  import NodeContentType from "sap/ui/vk/NodeContentType";

  import NodeProxy from "sap/ui/vk/NodeProxy";

  import ManagedObjectMetadata from "sap/ui/base/ManagedObjectMetadata";

  import Scene from "sap/ui/vk/Scene";

  /**
   * Provides the ability to explore a Scene object's node structure.
   *
   * The objects of this class should not be created directly, and should only be created via a call to {@link sap.ui.vk.Scene#getDefaultNodeHierarchy sap.ui.vk.Scene#getDefaultNodeHierarchy}.
   */
  export default class NodeHierarchy extends NodeHierarchy1 {
    /**
     * Constructor for a new NodeHierarchy.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     *
     * This class does not have its own settings, but all settings applicable to the base type {@link sap.ui.vk.NodeHierarchy#constructor sap.ui.vk.NodeHierarchy }
     * can be used.
     */
    constructor();

    /**
     * Creates a new subclass of class sap.ui.vk.threejs.NodeHierarchy with name `sClassName` and enriches it
     * with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.vk.NodeHierarchy.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, NodeHierarchy>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.threejs.NodeHierarchy.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ManagedObjectMetadata;
    /**
     * Creates a layer proxy object.
     *
     * The layer proxy object must be destroyed with the {@link #destroyLayerProxy destroyLayerProxy} method.
     *
     *
     * @returns The proxy object.
     */
    createLayerProxy(
      /**
       * The layer ID for which to create a proxy object.
       */
      layerId: string
    ): LayerProxy;
    /**
     * Creates a new node.
     *
     * @since 1.48.0
     *
     * @returns The reference object of the newly created node.
     */
    createNode(
      /**
       * The reference object of the parent node where the created node is added to. If equals `null` the newly
       * created node is a top level node.
       */
      parentNode: THREE.Object3D,
      /**
       * The name of the new node.
       */
      name: string,
      /**
       * The created node is added before this specified node. If equals `null` the newly created node is added
       * at the end of the parent's list of nodes.
       */
      insertBeforeNode: THREE.Object3D,
      /**
       * The created node content type.
       */
      nodeContentType?: NodeContentType | keyof typeof NodeContentType,
      /**
       * Optional Json structure used to define node properties.
       */
      content?: object
    ): THREE.Object3D;
    /**
     * Creates a copy of an existing node.
     *
     * @since 1.48.0
     *
     * @returns The reference object of the newly created node.
     */
    createNodeCopy(
      /**
       * The reference object of the node to copy.
       */
      nodeToCopy: any,
      /**
       * The reference object of the parent node where the created node is added to. If equals `null` the newly
       * created node is a top level node.
       */
      parentNode: any,
      /**
       * The name of the new node.
       */
      name: string,
      /**
       * The created node is added before this specified node. If equals `null` the newly created node is added
       * at the end of the parent's list of nodes.
       */
      insertBeforeNode: any
    ): any;
    /**
     * Creates a node proxy object.
     *
     * The node proxy object must be destroyed with the {@link #destroyNodeProxy destroyNodeProxy} method.
     *
     *
     * @returns The proxy object.
     */
    createNodeProxy(
      /**
       * The reference object for which to create a proxy object.
       */
      nodeRef: any
    ): NodeProxy;
    /**
     * Destroys the layer proxy object.
     *
     *
     * @returns `this` to allow method chaining.
     */
    destroyLayerProxy(
      /**
       * The layer proxy object.
       */
      layerProxy: LayerProxy
    ): this;
    /**
     * Destroys the node proxy object.
     *
     *
     * @returns `this` to allow method chaining.
     */
    destroyNodeProxy(
      /**
       * The node proxy object.
       */
      nodeProxy: NodeProxy
    ): this;
    /**
     * Enumerates the ancestor nodes of a particular node in the Scene object.
     *
     * This method enumerates the ancestor nodes of a particular node, and then calls the `callback` function,
     * to which it passes the ancestor nodes to one by one.
     *  The BaseNodeProxy objects passed to `callback` are temporary objects, they are reset after each call
     * to the `callback` function.
     *  The ancestor nodes are enumerated starting from the top level node, and progresses down the node hierarchy.
     *
     *
     * @returns `this` to allow method chaining.
     */
    enumerateAncestors(
      /**
       * The reference object of a node whose ancestor nodes we want enumerated.
       */
      nodeRef: any,
      /**
       * A function to call when the ancestor nodes are enumerated. The function takes one parameter of type {@link sap.ui.vk.BaseNodeProxy},
       * or string if parameter `passNodeRef` parameter is `true`.
       */
      callback: Function,
      /**
       * Indicates whether to pass the node references of the ancestor nodes, or the whole node proxy to the `callback`
       * function.
       *  If `true`, then only the node references of the ancestor nodes are passed to the `callback` function.
       *
       *  If `false`, then the node proxies of the ancestor nodes are passed to the `callback` function.
       */
      passNodeRef?: boolean
    ): this;
    /**
     * Enumerates the child nodes of a particular node in the Scene object.
     *
     * This method gets the child nodes of a particular node, and then calls the `callback` function to which
     * it passes the child nodes to one by one.
     *  The `BaseNodeProxy` objects passed to the `callback` function are temporary objects, which are reset
     * after each call to the `callback` function.
     *
     *
     *
     * @returns `this` to allow method chaining.
     */
    enumerateChildren(
      /**
       * The reference object of a node whose child nodes we want enumerated.
       *  When `nodeRef` is specified, the child nodes of this node are enumerated.
       *  When no `nodeRef` is specified, only the top level nodes are enumerated.
       */
      nodeRef: any,
      /**
       * A function to call when the child nodes are enumerated. The function takes one parameter of type {@link sap.ui.vk.BaseNodeProxy},
       * or string if parameter `passNodeRef` parameter is `true`.
       */
      callback: Function,
      /**
       * Indicates whether to enumerate the child nodes if the node is closed.
       *  If `true`, the children of that closed node will be enumerated
       *  If `false`, the children of that node will not be enumerated
       */
      stepIntoClosedNodes?: boolean,
      /**
       * Indicates whether to pass the node references of the child nodes, or the whole node proxy to the `callback`
       * function.
       *  If `true`, then only the node references of the child nodes are passed to the `callback` function.
       *  If `false`, then the node proxies created from the child node references are passed to the `callback`
       * function.
       */
      passNodeRef?: boolean
    ): this;
    /**
     * Enumerates the child nodes of a particular node in the Scene object.
     *
     * This method gets the child nodes of a particular node, and then calls the `callback` function to which
     * it passes the child nodes to one by one.
     *  The `BaseNodeProxy` objects passed to the `callback` function are temporary objects, which are reset
     * after each call to the `callback` function.
     *
     *
     *
     * @returns `this` to allow method chaining.
     */
    enumerateChildren(
      /**
       * A function to call when the child nodes are enumerated. The function takes one parameter of type {@link sap.ui.vk.BaseNodeProxy},
       * or string if parameter `passNodeRef` parameter is `true`.
       */
      callback: Function,
      /**
       * Indicates whether to enumerate the child nodes if the node is closed.
       *  If `true`, the children of that closed node will be enumerated
       *  If `false`, the children of that node will not be enumerated
       */
      stepIntoClosedNodes?: boolean,
      /**
       * Indicates whether to pass the node references of the child nodes, or the whole node proxy to the `callback`
       * function.
       *  If `true`, then only the node references of the child nodes are passed to the `callback` function.
       *  If `false`, then the node proxies created from the child node references are passed to the `callback`
       * function.
       */
      passNodeRef?: boolean
    ): this;
    /**
     * Finds nodes in a scene via node name.
     *
     *
     * @returns A list of reference objects belonging to nodes that matched the search criteria.
     */
    findNodesByName(
      /**
       * JSON object containing the search parameters.
       *  The following example shows what the structure of the `query` object should look like:
       * ```javascript
       * query = {
       * 	value: string | string[],
       * 	predicate: "equals" | "contains" | "startsWith",
       * 	caseSensitive: true | false
       * }```
       *
       *
       * 	 -  **query.value**
       *  A string or an array of strings containing the name of a node or names of nodes. If no value is specified,
       * then all nodes in the scene will be returned.
       *  The following example shows a single string being passed in:
       * ```javascript
       * value: "Box #14"```
       *  The following example shows an array of strings being passed in:
       * ```javascript
       * value: ["Box #3", "box #4", "BOX #5"]```
       *
       * 	 -  **query.predicate**
       *  Represents a search mode. The available search modes are `"equals"`, `"contains"`, and `"startsWith"`.
       *
       *  Using `"equals"` will search for nodes with names that exactly match the provided string or array of
       * strings.
       *  Using `"contains"` will search for nodes with names containing all or part of the provided string or
       * array of strings.
       *  Using `"startsWith"` will search for nodes with names starting with the provided string or array of
       * strings.
       *  If no value is specified, the search mode will default to `"equals"`.
       *
       *
       * 	 -  **query.caseSensitive**
       *  Indicates whether the search should be case sensitive or not.
       *  If `true`, the search will be case sensitive, and `false` indicates otherwise.
       *  If no value is specified, `caseSensitive` will default to `false` (that is, the search will be a case-insensitive
       * search).
       */
      query: object
    ): THREE.Object3D[];
    /**
     * Find nodes by UsageId path.
     *
     * The method can return multiple nodes matching `path` especially when `path contains a string "**"`.
     *
     *
     * @returns An array of node references.
     */
    findNodesByUsageIdPath(
      /**
       * A UsageId name which the keys in `path` belong to.
       */
      usageIdName: string,
      /**
       * An array of UsageId keys where each item is a single JSON like object with properties `name` and `value`
       * for single-key UsageIds and an array of such objects for multi-key UsageIds. The item can can be a string
       * `"*"` to indicate that it can be any node or the item can be a string `"**"` to indicate that some nodes
       * can be skipped.
       */
      path: any[],
      /**
       * Optional settings for the method.
       */
      options?: {
        /**
         * An optional non-`null` node reference for limiting the scope of search with a subtree starting with the
         * `options.searchUnder` node excluding the `options.searchUnder` node itself.
         */
        searchUnder?: any;
        /**
         * An indicator to search in ***closed*** nodes as well.
         */
        stepIntoClosedNodes?: boolean;
      }
    ): any[];
    /**
     * Returns a list of reference objects belonging to the ancestors of a particular node.
     *
     *
     * @returns A list of reference objects belonging to the ancestors of `nodeRef`.
     */
    getAncestors(
      /**
       * The reference object of the node whose ancestors will be returned.
       */
      nodeRef: any
    ): any[];
    /**
     * Returns a list of reference objects belonging to the children of a particular node.
     *
     *
     * @returns A list of reference objects belonging to the children of `nodeRef`.
     */
    getChildren(
      /**
       * The reference object of the node whose children will be returned. If `nodeRef` is not passed to the `getChildren`
       * function, the reference objects of the root nodes will be returned.
       */
      nodeRef: any,
      /**
       * Indicates whether to return only the child nodes of a closed node or not. If `true`, then the
       * children of that closed node will be returned. If `false`, then the children of that closed node
       * will not be returned.
       */
      stepIntoClosedNodes?: boolean
    ): any[];
    /**
     * Returns a list of hotspot node references.
     *
     *
     * @returns A list of hotspot node references.
     */
    getHotspotNodeRefs(): any[];
    /**
     * Returns a list of layer IDs.
     *
     *
     * @returns A list of layer IDs.
     */
    getLayers(): string[];
    /**
     * Get node content type
     *
     * @since 1.73.0
     *
     * @returns Node content type
     */
    getNodeContentType(
      /**
       * The node reference
       */
      nodeRef: any
    ): NodeContentType;
    /**
     * Gets the Scene object the node hierarchy belongs to.
     *
     *
     * @returns The Scene object the node hierarchy belongs to.
     */
    getScene(): Scene;
    /**
     * Gets the scene reference that this NodeHierarchy object wraps.
     *
     *
     * @returns The scene reference that this NodeHierarchy object wraps.
     */
    getSceneRef(): any;
    /**
     * Deletes a node and destroys it.
     *
     * @since 1.48.0
     *
     * @returns `this` to allow method chaining.
     */
    removeNode(
      /**
       * The reference object of a node or an array of nodes to destroy.
       */
      nodeRef: any
    ): this;
  }
  /**
   * Describes the settings that can be provided to the NodeHierarchy constructor.
   */
  export interface $NodeHierarchySettings extends $NodeHierarchySettings1 {}
}

declare module "sap/ui/vk/threejs/NodeProxy" {
  import {
    default as NodeProxy1,
    $NodeProxySettings as $NodeProxySettings1,
  } from "sap/ui/vk/NodeProxy";

  import Material from "sap/ui/vk/Material";

  import ManagedObjectMetadata from "sap/ui/base/ManagedObjectMetadata";

  /**
   * Provides a proxy object to the node in the node hierarchy.
   *
   * Objects of this type should only be created with the {@link sap.ui.vk.NodeHierarchy#createNodeProxy sap.ui.vk.NodeHierarchy.createNodeProxy }
   * method. and destroyed with the {@link sap.ui.vk.NodeHierarchy#destroyNodeProxy sap.ui.vk.NodeHierarchy.destroyNodeProxy }
   * method.
   */
  export default class NodeProxy extends NodeProxy1 {
    /**
     * Constructor for a new NodeProxy.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     *
     * This class does not have its own settings, but all settings applicable to the base type {@link sap.ui.vk.NodeProxy#constructor sap.ui.vk.NodeProxy }
     * can be used.
     */
    constructor();

    /**
     * Creates a new subclass of class sap.ui.vk.threejs.NodeProxy with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.vk.NodeProxy.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, NodeProxy>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.threejs.NodeProxy.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ManagedObjectMetadata;
    /**
     * Assign material to all mesh nodes contained in the current node
     *
     *
     * @returns `this` to allow method chaining.
     */
    assignMaterial(
      /**
       * Material to be assigned.
       */
      value: Material
    ): this;
    /**
     * Retrieve all materials defined in the current node
     *
     *
     * @returns The array of materials.
     */
    enumerateMaterials(
      /**
       * If `true` then include materials defined in all child nodes
       */
      recursive: boolean
    ): Material[];
    /**
     * get local rotation represented by axis and angle
     *
     *
     * @returns angleAxis rotation [x, y, z, angle], (x, y, z) - rotation axis
     */
    getLocalRotationInAngleAxis(): float[];
    /**
     * get local rotation in Euler form
     *
     *
     * @returns angleAxis rotation [a1, a2, a3, order] a1, a2, a3 - rotation angles about 1st, 2nd, 3nd axis
     * order - int encoding order of XYZ axis (e.g, order "XZY" - 011100 (01 - 3rd axis(Y), 11 - 2nd axis(Z),
     * 00 - 1st axis(X)))
     */
    getLocalRotationInEuler(): float[];
    /**
     * get local rotation represented by quaternion
     *
     *
     * @returns quaternion [x, y, z, w]
     */
    getLocalRotationInQuaternion(): float[];
    /**
     * get local scale vector
     *
     *
     * @returns scale vector
     */
    getLocalScale(): float[];
    /**
     * get local translate vector
     *
     *
     * @returns translate vector
     */
    getLocalTranslate(): float[];
    /**
     * Replace material with another material
     *
     *
     * @returns `this` to allow method chaining.
     */
    replaceMaterial(
      /**
       * Material to be replaced.
       */
      materialToReplace: Material | THREE.Material,
      /**
       * Material replacement.
       */
      material: Material | THREE.Material
    ): this;
  }
  /**
   * Describes the settings that can be provided to the NodeProxy constructor.
   */
  export interface $NodeProxySettings extends $NodeProxySettings1 {}
}

declare module "sap/ui/vk/threejs/OrthographicCamera" {
  import {
    default as OrthographicCamera1,
    $OrthographicCameraSettings as $OrthographicCameraSettings1,
  } from "sap/ui/vk/OrthographicCamera";

  import ManagedObjectMetadata from "sap/ui/base/ManagedObjectMetadata";

  /**
   * Provides the interface for the camera.
   *
   * @since 1.52.0
   */
  export default class OrthographicCamera extends OrthographicCamera1 {
    /**
     * Constructor for a new OrthographicCamera.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     *
     * This class does not have its own settings, but all settings applicable to the base type {@link sap.ui.vk.OrthographicCamera#constructor sap.ui.vk.OrthographicCamera }
     * can be used.
     */
    constructor();

    /**
     * Creates a new subclass of class sap.ui.vk.threejs.OrthographicCamera with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.vk.OrthographicCamera.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, OrthographicCamera>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.threejs.OrthographicCamera.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ManagedObjectMetadata;
    /**
     * Adjust the camera near and far clipping planes to include the entire specified bounding box
     *
     *
     * @returns this
     */
    adjustClipPlanes(
      /**
       * Bounding box
       */
      boundingBox: THREE.Box3
    ): OrthographicCamera;
    /**
     * Adjust the camera zoom to include the entire specified bounding box
     *
     *
     * @returns this
     */
    adjustZoom(
      /**
       * Bounding box
       */
      boundingBox: THREE.Box3
    ): OrthographicCamera;
    /**
     * Updates the camera properties with width and height of viewport
     */
    update(
      /**
       * width of the viewport
       */
      width: float,
      /**
       * height of the viewport
       */
      height: float
    ): void;
  }
  /**
   * Describes the settings that can be provided to the OrthographicCamera constructor.
   */
  export interface $OrthographicCameraSettings
    extends $OrthographicCameraSettings1 {}
}

declare module "sap/ui/vk/threejs/PerspectiveCamera" {
  import {
    default as PerspectiveCamera1,
    $PerspectiveCameraSettings as $PerspectiveCameraSettings1,
  } from "sap/ui/vk/PerspectiveCamera";

  import ManagedObjectMetadata from "sap/ui/base/ManagedObjectMetadata";

  /**
   * Provides the interface for the camera.
   *
   * @since 1.52.0
   */
  export default class PerspectiveCamera extends PerspectiveCamera1 {
    /**
     * Constructor for a new PerspectiveCamera.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     *
     * This class does not have its own settings, but all settings applicable to the base type {@link sap.ui.vk.PerspectiveCamera#constructor sap.ui.vk.PerspectiveCamera }
     * can be used.
     */
    constructor();

    /**
     * Creates a new subclass of class sap.ui.vk.threejs.PerspectiveCamera with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.vk.PerspectiveCamera.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, PerspectiveCamera>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.threejs.PerspectiveCamera.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ManagedObjectMetadata;
    /**
     * Adjust the camera near and far clipping planes to include the entire specified bounding box
     *
     *
     * @returns this
     */
    adjustClipPlanes(
      /**
       * Bounding box
       */
      boundingBox: THREE.Box3
    ): PerspectiveCamera;
    /**
     * Updates the camera properties with width and height of viewport
     */
    update(
      /**
       * width of the viewport
       */
      width: float,
      /**
       * height of the viewport
       */
      height: float
    ): void;
  }
  /**
   * Describes the settings that can be provided to the PerspectiveCamera constructor.
   */
  export interface $PerspectiveCameraSettings
    extends $PerspectiveCameraSettings1 {}
}

declare module "sap/ui/vk/threejs/Scene" {
  import {
    default as Scene1,
    $SceneSettings as $SceneSettings1,
  } from "sap/ui/vk/Scene";

  import Material from "sap/ui/vk/Material";

  import NodeHierarchy from "sap/ui/vk/NodeHierarchy";

  import View from "sap/ui/vk/View";

  import ManagedObjectMetadata from "sap/ui/base/ManagedObjectMetadata";

  /**
   * Provides the interface for the 3D model.
   *
   * The objects of this class should not be created directly.
   */
  export default class Scene extends Scene1 {
    /**
     * Constructor for a new Scene.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     *
     * This class does not have its own settings, but all settings applicable to the base type {@link sap.ui.vk.Scene#constructor sap.ui.vk.Scene }
     * can be used.
     */
    constructor(
      /**
       * The three.js scene object.
       */
      scene: THREE.Scene
    );

    /**
     * Creates a new subclass of class sap.ui.vk.threejs.Scene with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.vk.Scene.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Scene>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.threejs.Scene.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ManagedObjectMetadata;
    /**
     * Add marker to node associations
     */
    bindMarkerNodeTransformationToReferenceNode(
      /**
       * Marker's reference node id
       */
      referenceNodeId: string,
      /**
       * Marker's node id
       */
      markerNodeId: string
    ): void;
    /**
     * Gets all materials defined in scene nodes
     *
     *
     * @returns the array of materials.
     */
    enumerateMaterials(): Material[];
    /**
     * Gets the default node hierarchy in the Scene object.
     *
     *
     * @returns The default node hierarchy in the Scene object.
     */
    getDefaultNodeHierarchy(): NodeHierarchy;
    /**
     * Gets the unique ID of the Scene object.
     *
     *
     * @returns The unique ID of the Scene object.
     */
    getId(): string;
    /**
     * Get initial view
     *
     *
     * @returns initial view
     */
    getInitialView(): View;
    /**
     * Get reference node for a given marker node sid
     *
     *
     * @returns reference node of given marker
     */
    getReferenceNodeFromMarkerNodeId(
      /**
       * Marker's sid
       */
      markNodeId: string
    ): /* was: sap.ui.vk.threejs.Node */ any;
    /**
     * Gets the scene reference for the Scene object.
     *
     *
     * @returns The three.js scene.
     */
    getSceneRef(): THREE.Scene;
    /**
     * Gets the persistent ID from node reference.
     *
     *
     * @returns The persistent ID or the array of the persistent IDs.
     */
    nodeRefToPersistentId(
      /**
       * The reference to the node or the array of references to the nodes.
       */
      nodeRefs: THREE.Object3D | THREE.Object3D[]
    ): string | string[];
    /**
     * Gets the node reference from persistent ID.
     *
     *
     * @returns The reference to the node or the array of references to the nodes.
     */
    persistentIdToNodeRef(
      /**
       * The persistent ID or the array of the persistent IDs.
       */
      pIDs: string | string[]
    ): THREE.Object3D | THREE.Object3D[];
    /**
     * Set initial view
     */
    setInitialView(
      /**
       * Initial view
       */
      view: View
    ): void;
    /**
     * Remove marker from node associations
     */
    unbindMarkerNodeTransformationFromReferenceNode(
      /**
       * Marker's reference node id
       */
      referenceNodeId: string,
      /**
       * Marker's node id
       */
      markerNodeId: string
    ): void;
  }
  /**
   * Describes the settings that can be provided to the Scene constructor.
   */
  export interface $SceneSettings extends $SceneSettings1 {}
}

declare module "sap/ui/vk/threejs/Texture" {
  import {
    default as Texture1,
    $TextureSettings as $TextureSettings1,
  } from "sap/ui/vk/Texture";

  import ManagedObjectMetadata from "sap/ui/base/ManagedObjectMetadata";

  /**
   * Provides the interface for the material.
   *
   * @experimental As of version 1.60.0. This class is experimental and might be modified or removed in future
   * versions.
   */
  export default class Texture extends Texture1 {
    /**
     * Constructor for a new Material.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     *
     * This class does not have its own settings, but all settings applicable to the base type {@link sap.ui.vk.Texture#constructor sap.ui.vk.Texture }
     * can be used.
     */
    constructor();

    /**
     * Creates a new subclass of class sap.ui.vk.threejs.Texture with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.vk.Texture.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Texture>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.threejs.Texture.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ManagedObjectMetadata;
  }
  /**
   * Describes the settings that can be provided to the Texture constructor.
   *
   * @experimental As of version 1.60.0. This class is experimental and might be modified or removed in future
   * versions.
   */
  export interface $TextureSettings extends $TextureSettings1 {}
}

declare module "sap/ui/vk/threejs/Viewport" {
  import {
    default as ViewportBase,
    $ViewportBaseSettings,
  } from "sap/ui/vk/ViewportBase";

  import View from "sap/ui/vk/View";

  import Event from "sap/ui/base/Event";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import Scene from "sap/ui/vk/threejs/Scene";

  import Camera from "sap/ui/vk/Camera";

  import CameraFOVBindingType from "sap/ui/vk/CameraFOVBindingType";

  import CameraProjectionType from "sap/ui/vk/CameraProjectionType";

  import ZoomTo from "sap/ui/vk/ZoomTo";

  import Viewport1 from "sap/ui/vk/Viewport";

  /**
   * Provides a control for three.js canvas.
   */
  export default class Viewport extends ViewportBase {
    /**
     * Constructor for a ThreeJs viewport.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor();

    /**
     * Creates a new subclass of class sap.ui.vk.threejs.Viewport with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.vk.ViewportBase.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Viewport>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.threejs.Viewport.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Activates the view based on view object passed
     *
     * @since 1.52.0
     *
     * @returns returns this
     */
    activateView(
      /**
       * View object definition
       */
      view: View,
      /**
       * true if view activation is part of playing view group
       */
      playViewGroup: boolean,
      /**
       * true if not animating the change of camera
       */
      skipCameraTransitionAnimation: boolean
    ): Viewport;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:cameraChanged cameraChanged} event of this `sap.ui.vk.threejs.Viewport`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.threejs.Viewport` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachCameraChanged(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Viewport$CameraChangedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.threejs.Viewport` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:cameraChanged cameraChanged} event of this `sap.ui.vk.threejs.Viewport`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.threejs.Viewport` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachCameraChanged(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Viewport$CameraChangedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.threejs.Viewport` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:frameRenderingFinished frameRenderingFinished }
     * event of this `sap.ui.vk.threejs.Viewport`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.threejs.Viewport` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachFrameRenderingFinished(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.threejs.Viewport` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:frameRenderingFinished frameRenderingFinished }
     * event of this `sap.ui.vk.threejs.Viewport`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.threejs.Viewport` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachFrameRenderingFinished(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.threejs.Viewport` itself
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:cameraChanged cameraChanged} event of this
     * `sap.ui.vk.threejs.Viewport`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachCameraChanged(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Viewport$CameraChangedEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:frameRenderingFinished frameRenderingFinished }
     * event of this `sap.ui.vk.threejs.Viewport`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachFrameRenderingFinished(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:cameraChanged cameraChanged} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireCameraChanged(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: Viewport$CameraChangedEventParameters
    ): this;
    /**
     * Fires event {@link #event:frameRenderingFinished frameRenderingFinished} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireFrameRenderingFinished(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Get current view - remembered when activateView function is called
     *
     *
     * @returns Current view
     */
    getCurrentView(): View;
    /**
     * Returns viewport content as an image of desired size.
     *
     *
     * @returns Base64 encoded PNG image
     */
    getImage(
      /**
       * Requested image width in pixels. Allowed values are 8 to 2048, default is 16
       */
      width: int,
      /**
       * Requested image height in pixels. Allowed values are 8 to 2048, default is 16
       */
      height: int,
      /**
       * The sap.ui.core.CSSColor to be used for top background color
       */
      topColor: string,
      /**
       * The sap.ui.core.CSSColor to be used for bottom background color
       */
      bottomColor: string,
      /**
       * Include selected nodes
       */
      includeSelection: boolean
    ): string;
    /**
     * Returns object as an image of desired size.
     *
     * @experimental As of version 1.82.0. This method is experimental and might be modified or removed in future
     * versions
     *
     * @returns Base64 encoded PNG image
     */
    getObjectImage(
      /**
       * The node reference.
       */
      nodeRef: any,
      /**
       * Requested image width in pixels. Allowed values are 8 to 2048, default is 256
       */
      width: int,
      /**
       * Requested image height in pixels. Allowed values are 8 to 2048, default is 256
       */
      height: int,
      /**
       * The sap.ui.core.CSSColor to be used for top background color
       */
      topColor: string,
      /**
       * The sap.ui.core.CSSColor to be used for bottom background color
       */
      bottomColor: string,
      /**
       * Optional camera rotation quaternion
       */
      quaternion: THREE.Quaternion,
      /**
       * The object margin
       */
      margin: float
    ): string;
    /**
     * Returns object/objects as an image of desired size.
     *
     * @experimental As of version 1.102.0. This method is experimental and might be modified or removed in
     * future versions
     *
     * @returns Base64 encoded image
     */
    getObjectImageEx(
      /**
       * The node reference or the array of node references.
       */
      nodeRefs: any | any[],
      /**
       * Requested image width in pixels. Allowed values are 8 to 2048, default is 256
       */
      width: int,
      /**
       * Requested image height in pixels. Allowed values are 8 to 2048, default is 256
       */
      height: int,
      /**
       * The sap.ui.core.CSSColor to be used for top background color
       */
      topColor: string,
      /**
       * The sap.ui.core.CSSColor to be used for bottom background color
       */
      bottomColor: string,
      /**
       * A map of parameters, optional
       */
      options: {
        /**
         * If set to `true`, the viewport camera will be used
         */
        useViewportCamera?: boolean;
        /**
         * Camera rotation quaternion (if options.useViewportCamera is not set to `false`)
         */
        quaternion: THREE.Quaternion;
        /**
         * The object margin (if options.useViewportCamera is not set to `false`)
         */
        margin: float;
        /**
         * Output image format. The default type is "image/png"
         */
        type: string;
        /**
         * A number between 0 and 1 indicating the output image quality
         */
        encoderOptions: number;
        /**
         * If set to `true` then overlay nodes will be rendered
         */
        includeOverlay?: boolean;
        /**
         * If set to `true` then underlay nodes will be rendered
         */
        includeUnderlay?: boolean;
      }
    ): string;
    /**
     * Gets position and size of the viewport square. The information can be used for making calculations when
     * restoring Redlining elements.
     *
     *
     * @returns The information in this object:
     * 	 - **left** - The x coordinate of the top-left corner of the square.
     * 	 - **top** - The y coordinate of the top-left corner of the square.
     * 	 - **sideLength** - The length of the square.
     */
    getOutputSize(): object;
    /**
     * Gets the Viewport Scene
     *
     *
     * @returns returns Scene
     */
    getScene(): Scene;
    /**
     * Retrieves information about the current camera view in the scene, and saves the information in a JSON-like
     * object. The information can then be used at a later time to restore the scene to the same camera view
     * using the {@link sap.ui.vk.Viewport#setViewInfo setViewInfo} method.
     *
     *
     *
     * @returns JSON-like object which holds the current view information. See {@link sap.ui.vk.Viewport#setViewInfo setViewInfo}.
     * In addition to properties defined in {@link sap.ui.vk.Viewport#setViewInfo setViewInfo} the output from
     * {@link sap.ui.vk.Viewport#getViewInfo getViewInfo} contains camera view and projection matrices
     * ```javascript
     *
     *   {
     *     ...
     *     camera: {
     *       ...
     *       matrices: {
     *         view:       [number, ...],
     *         projection: [number, ...],
     *       }
     *       ...
     *     },
     *     ...
     *   }
     * ```
     */
    getViewInfo(
      /**
       * Query object which indicates what information to be retrieved.
       */
      query?: {
        /**
         * Indicator to retrieve camera information.
         */
        camera?:
          | boolean
          | {
              /**
               * Indicator to retrieve camera view and projection matrices.
               */
              matrices?: boolean;
              /**
               * Indicator to retrieve the transition camera properties instead of regular one's.
               */
              useTransitionCamera?: boolean;
            };
        /**
         * Indicator to retrieve visibility information.
         */
        visibility?:
          | boolean
          | {
              /**
               * Indicator to retrieve the complete visibility definition or just the difference.
               */
              mode?: /* was: sap.ui.vk.VisibilityMode */ any;
            };
        /**
         * Indicator to retrieve selection information.
         */
        selection?: boolean | object;
      }
    ): object;
    /**
     * Queues a command for execution during the rendering cycle. All gesture operations should be called using
     * this method.
     *
     *
     * @returns returns this
     */
    queueCommand(
      /**
       * The command to be executed.
       */
      command: Function
    ): Viewport;
    /**
     * Sets the camera for the Viewport
     *
     *
     * @returns `this` to allow method chaining.
     */
    setCamera(
      /**
       * parameter
       */
      camera: Camera
    ): this;
    /**
     * Attaches the scene to the Viewport for rendering.
     *
     * @deprecated As of version 1.50.0. Viewport now gets reference to the scene via {@link sap.ui.vk.ContentConnector}.
     *
     * @returns `this` to allow method chaining.
     */
    setScene(
      /**
       * The scene to attach to the Viewport.
       */
      scene: Scene
    ): this;
    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns `this` to allow method chaining.
     */
    setShouldRenderFrame(
      /**
       * If set to 'true', then hierarchy and matrix recomputation is not required, only redraw.
       */
      skipHierarchyProcessing: boolean
    ): this;
    /**
     * Sets the current scene to use the camera view information acquired from the {@link sap.ui.vk.Viewport#getViewInfo getViewInfo }
     * method.
     *  Internally, the `setViewInfo` method activates certain steps at certain animation times, and then changes
     * the camera position, rotation and field of view (FOV) / zoom factor.
     *
     *
     * @returns `this` to allow method chaining.
     */
    setViewInfo(
      /**
       * A JSON-like object containing view information acquired using the {@link sap.ui.vk.Viewport#getViewInfo getViewInfo }
       * method.
       */
      viewInfo: {
        /**
         * A JSON-like object containing the camera information.
         */
        camera?: {
          /**
           * Rotation defined in {@link https://en.wikipedia.org/wiki/Aircraft_principal_axes Aircraft principal axes}.
           */
          rotation: {
            /**
             * Angle around the vertical axis in degrees.
             */
            yaw: float;
            /**
             * Angle around the lateral axis in degrees.
             */
            pitch: float;
            /**
             * Angle around the longitudinal axis in degrees.
             */
            roll: float;
          };
          /**
           * Position defined in 3-dimensional space.
           */
          position: {
            /**
             * X coordinate.
             */
            x: float;
            /**
             * Y coordinate.
             */
            y: float;
            /**
             * Z coordinate.
             */
            z: float;
          };
          /**
           * Camera field of view binding type.
           */
          bindingType: CameraFOVBindingType;
          /**
           * Camera projection type.
           */
          projectionType: CameraProjectionType;
          /**
           * Camera field of view in degrees. Applicable only to perspective cameras.
           */
          fieldOfView: float;
          /**
           * Camera zoom factor. Applicable only to orthographic cameras.
           */
          zoomFactor: float;
        };
        /**
         * A JSON-like object containing the animation information.
         */
        animation?: {
          /**
           * Step VE ID. If it is omitted then procedure and step indices are used.
           */
          stepVeId?: string;
          /**
           * Procedure index in the list of procedures.
           */
          procedureIndex?: int;
          /**
           * Step index in the list of steps in the procedure.
           */
          stepIndex?: int;
          /**
           * Time at which to activate the step.
           */
          animationTime?: float;
        };
        /**
         * A JSON-like object containing the visibility information.
         */
        visibility?: {
          /**
           * If the mode equals to {@link sap.ui.vk.VisibilityMode.Complete complete} then the visible and hidden
           * fields are defined. If the mode equals {@link sap.ui.vk.VisibilityMode.Differences differences} then
           * the changes field is defined.
           */
          mode: /* was: sap.ui.vk.VisibilityMode */ any;
          /**
           * List of Ids of visible nodes.
           */
          visible: string[];
          /**
           * List of Ids of hidden nodes.
           */
          hidden: string[];
          /**
           * List of Ids of nodes with inverted visibility.
           */
          changes: string[];
        };
        /**
         * A JSON-like object containing the selection information.
         */
        selection?: {
          /**
           * List of Ids of selected nodes.
           */
          selected: string[];
          /**
           * List of Ids of outlined nodes.
           */
          outlined: string[];
        };
      },
      /**
       * Fly-to animation duration in seconds.
       */
      flyToDuration?: float
    ): this;
    /**
     * Zooms the scene to a bounding box created from a particular set of nodes.
     *
     *
     * @returns this
     */
    zoomTo(
      /**
       * What set of nodes to zoom to.
       */
      what: ZoomTo | ZoomTo[],
      /**
       * Is used if what == (sap.ui.vk.ZoomTo.Node || ZoomTo.NodeSetIsolation)
       */
      nodeRef: any,
      /**
       * Time to perform the "fly to" animation. Set to 0 to do this immediately.
       */
      crossFadeSeconds: float,
      /**
       * Margin. Set to 0 to zoom to the entire screen.
       */
      margin: float
    ): Viewport1;
  }
  /**
   * Describes the settings that can be provided to the Viewport constructor.
   */
  export interface $ViewportSettings extends $ViewportBaseSettings {
    cameraChanged?: (oEvent: Viewport$CameraChangedEvent) => void;

    frameRenderingFinished?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the Viewport#cameraChanged event.
   */
  export interface Viewport$CameraChangedEventParameters {
    /**
     * Returns a new camera position.
     */
    position?: float[];

    /**
     * Returns a new camera rotation quaternion.
     */
    quaternion?: float[];

    /**
     * Returns a new camera orthographic zoom factor.
     */
    zoom?: float;
  }

  /**
   * Event object of the Viewport#cameraChanged event.
   */
  export type Viewport$CameraChangedEvent = Event<
    Viewport$CameraChangedEventParameters,
    Viewport
  >;

  /**
   * Parameters of the Viewport#frameRenderingFinished event.
   */
  export interface Viewport$FrameRenderingFinishedEventParameters {}

  /**
   * Event object of the Viewport#frameRenderingFinished event.
   */
  export type Viewport$FrameRenderingFinishedEvent = Event<
    Viewport$FrameRenderingFinishedEventParameters,
    Viewport
  >;
}

declare module "sap/ui/vk/threejs/ViewStateManager" {
  import {
    default as ViewStateManagerBase,
    $ViewStateManagerBaseSettings,
  } from "sap/ui/vk/ViewStateManagerBase";

  import { CSSColor } from "sap/ui/core/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import NodeHierarchy from "sap/ui/vk/NodeHierarchy";

  /**
   * Manages the visibility and selection states of nodes in the scene.
   *
   * @since 1.32.0
   */
  export default class ViewStateManager extends ViewStateManagerBase {
    /**
     * Constructor for a new ViewStateManager.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     *
     * This class does not have its own settings, but all settings applicable to the base type {@link sap.ui.vk.ViewStateManagerBase#constructor sap.ui.vk.ViewStateManagerBase }
     * can be used.
     */
    constructor(
      /**
       * Initial settings for the new ViewStateManager object.
       */
      mSettings?: $ViewStateManagerSettings
    );
    /**
     * Constructor for a new ViewStateManager.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     *
     * This class does not have its own settings, but all settings applicable to the base type {@link sap.ui.vk.ViewStateManagerBase#constructor sap.ui.vk.ViewStateManagerBase }
     * can be used.
     */
    constructor(
      /**
       * ID for the new ViewStateManager object. Generated automatically if no ID is given.
       */
      sId?: string,
      /**
       * Initial settings for the new ViewStateManager object.
       */
      mSettings?: $ViewStateManagerSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vk.threejs.ViewStateManager with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.vk.ViewStateManagerBase.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ViewStateManager>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.threejs.ViewStateManager.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Enumerates IDs of the outlined nodes.
     *
     *
     * @returns `this` to allow method chaining.
     */
    enumerateOutlinedNodes(
      /**
       * A function to call when the outlined nodes are enumerated. The function takes one parameter of type `string`.
       */
      callback: Function
    ): this;
    /**
     * Enumerates IDs of the selected nodes.
     *
     *
     * @returns `this` to allow method chaining.
     */
    enumerateSelection(
      /**
       * A function to call when the selected nodes are enumerated. The function takes one parameter of type `string`.
       */
      callback: Function
    ): this;
    /**
     * Gets the default highlighting color
     *
     *
     * @returns A single value or an array of values. Value `null` means that the node's own tint color should
     * be used.
     */
    getHighlightColor(
      /**
       * This flag indicates to return the highlighting color in the ABGR format, if it equals `false` then the
       * color is returned in the CSS color format.
       */
      inABGRFormat?: boolean
    ): CSSColor | string | int;
    /**
     * Gets the NodeHierarchy object associated with this ViewStateManager object.
     *
     *
     * @returns The node hierarchy associated with this ViewStateManager object.
     */
    getNodeHierarchy(): NodeHierarchy;
    /**
     * Gets the opacity of the node.
     *
     * If a single node is passed to the method then a single value is returned.
     *  If an array of nodes is passed to the method then an array of values is returned.
     *
     *
     * @returns A single value or an array of values. Value `null` means that the node's own opacity should
     * be used.
     */
    getOpacity(
      /**
       * The node reference or the array of node references.
       */
      nodeRefs: any | any[]
    ): float | float[];
    /**
     * Gets the outline color
     *
     *
     * @returns A single value or an array of values. Value `null` means that the node's own tint color should
     * be used.
     */
    getOutlineColor(
      /**
       * This flag indicates to return the outline color in the ABGR format, if it equals `false` then the color
       * is returned in the CSS color format.
       */
      inABGRFormat?: boolean
    ): CSSColor | string | int;
    /**
     * Gets the outline width
     *
     *
     * @returns width of outline
     */
    getOutlineWidth(): float;
    /**
     * Gets the outlining state of the node.
     *
     * If a single node reference is passed to the method then a single outlining state is returned.
     *  If an array of node references is passed to the method then an array of outlining states is returned.
     *
     *
     * @returns A single value or an array of values where the value is `true` if the node is selected, `false`
     * otherwise.
     */
    getOutliningState(
      /**
       * The node reference or the array of node references.
       */
      nodeRefs: any | any[]
    ): boolean | boolean[];
    /**
     * Gets the selection state of the node.
     *
     * If a single node reference is passed to the method then a single selection state is returned.
     *  If an array of node references is passed to the method then an array of selection states is returned.
     *
     *
     * @returns A single value or an array of values where the value is `true` if the node is selected, `false`
     * otherwise.
     */
    getSelectionState(
      /**
       * The node reference or the array of node references.
       */
      nodeRefs: any | any[]
    ): boolean | boolean[];
    /**
     * Gets if showing the bounding box when nodes are selected
     *
     *
     * @returns `true` if bounding boxes of selected nodes are shown, `false` otherwise.
     */
    getShowSelectionBoundingBox(): boolean;
    /**
     * Get the Symbol node from nodeId, if nodeId is not set, returns a collection of all Symbol nodes
     *
     * @experimental As of version 1.82.0. This method is experimental and might be modified or removed in future
     * versions
     *
     * @returns An array of nodes
     */
    getSymbolNodes(
      /**
       * node Id string, optional
       */
      nodeId: string
    ): any[];
    /**
     * Gets the tint color of the node.
     *
     * If a single node reference is passed to the method then a single value is returned.
     *  If an array of node references is passed to the method then an array of values is returned.
     *
     *
     * @returns A single value or an array of values. Value `null` means that the node's own tint color should
     * be used.
     */
    getTintColor(
      /**
       * The node reference or the array of node references.
       */
      nodeRefs: any | any[],
      /**
       * This flag indicates to return the tint color in the ABGR format, if it equals `false` then the color
       * is returned in the CSS color format.
       */
      inABGRFormat?: boolean
    ): CSSColor | CSSColor[] | int | int[];
    /**
     * Gets the visibility changes in the current ViewStateManager object.
     *
     *
     * @returns The visibility changes are in the form of an array. The array is a list of node VE ids which
     * suffered a visibility changed relative to the default state.
     */
    getVisibilityChanges(): string[];
    /**
     * Gets the visibility state of nodes.
     *
     * If a single node is passed to the method then a single visibility state is returned.
     *  If an array of nodes is passed to the method then an array of visibility states is returned.
     *
     *
     * @returns A single value or an array of values where the value is `true` if the node is visible, `false`
     * otherwise.
     */
    getVisibilityState(
      /**
       * The node reference or the array of node references.
       */
      nodeRefs: any | any[]
    ): boolean | boolean[];
    /**
     * Reset node property to the value defined by current view..
     */
    resetNodeProperty(
      /**
       * reference to node.
       */
      nodeRef: object,
      /**
       * node property
       */
      property: string
    ): void;
    /**
     * Replace node's current transformation with its rest transformation stored in active view..
     *
     *
     * @returns `this` to allow method chaining.
     */
    restoreRestTransformation(
      /**
       * The node reference.
       */
      nodeRef: any
    ): this;
    /**
     * Sets the default highlighting color
     *
     *
     * @returns `this` to allow method chaining.
     */
    setHighlightColor(
      /**
       * The new highlighting color. The value can be defined as a string in the CSS color format or as an integer
       * in the ABGR format. If `null` is passed then the tint color is reset and the node's own tint color should
       * be used.
       */
      color: CSSColor | string | int
    ): this;
    /**
     * Set highlight display state.
     *
     *
     * @returns `this` to allow method chaining.
     */
    setHighlightDisplayState(
      /**
       * for playing highlight - playing, pausing, and stopped
       */
      state: /* was: sap.ui.vk.HighlightDisplayState */ any
    ): this;
    /**
     * Sets the opacity of the nodes.
     *
     *
     * @returns `this` to allow method chaining.
     */
    setOpacity(
      /**
       * The node reference or the array of node references.
       */
      nodeRefs: any | any[],
      /**
       * The new opacity of the nodes. If `null` is passed then the opacity is reset and the node's own opacity
       * should be used.
       */
      opacity: float | float[] | null,
      /**
       * This flag is not used, as opacity is always recursively applied to the offspring nodes by multiplication
       */
      recursive?: boolean
    ): this;
    /**
     * Sets the outline color
     *
     *
     * @returns `this` to allow method chaining.
     */
    setOutlineColor(
      /**
       * The new outline color. The value can be defined as a string in the CSS color format or as an integer
       * in the ABGR format. If `null` is passed then the tint color is reset and the node's own tint color should
       * be used.
       */
      color: CSSColor | string | int
    ): this;
    /**
     * Sets the outline width
     *
     *
     * @returns `this` to allow method chaining.
     */
    setOutlineWidth(
      /**
       * width of outline
       */
      width: float
    ): this;
    /**
     * Sets or resets the outlining state of the nodes.
     *
     *
     * @returns `this` to allow method chaining.
     */
    setOutliningStates(
      /**
       * The node reference or the array of node references of outlined nodes.
       */
      outlinedNodeRefs: any | any[],
      /**
       * The node reference or the array of node references of un-outlined nodes.
       */
      unoutlinedNodeRefs: any | any[],
      /**
       * The flags indicates if the change needs to propagate recursively to child nodes.
       */
      recursive: boolean,
      /**
       * The flag to suppress outlineChanged event.
       */
      blockNotification: boolean
    ): this;
    /**
     * Sets the selection state of the nodes.
     *
     * @deprecated As of version 1.56.3. Use {@link sap.ui.vk.threejs.ViewStateManager#setSelectionStates} instead.
     *
     * @returns `this` to allow method chaining.
     */
    setSelectionState(
      /**
       * The node reference or the array of node references.
       */
      nodeRefs: any | any[],
      /**
       * The new selection state of the nodes.
       */
      selected: boolean,
      /**
       * The flags indicates if the change needs to propagate recursively to child nodes.
       */
      recursive: boolean,
      /**
       * The flag to suppress selectionChanged event.
       */
      blockNotification: boolean
    ): this;
    /**
     * Sets or resets the selection state of the nodes.
     *
     *
     * @returns `this` to allow method chaining.
     */
    setSelectionStates(
      /**
       * The node reference or the array of node references of selected nodes.
       */
      selectedNodeRefs: any | any[],
      /**
       * The node reference or the array of node references of unselected nodes.
       */
      unselectedNodeRefs: any | any[],
      /**
       * The flags indicates if the change needs to propagate recursively to child nodes.
       */
      recursive: boolean,
      /**
       * The flag to suppress selectionChanged event.
       */
      blockNotification: boolean
    ): this;
    /**
     * Sets if showing the bounding box when nodes are selected
     */
    setShowSelectionBoundingBox(
      /**
       * `true` if bounding boxes of selected nodes are shown, `false` otherwise.
       */
      val: boolean
    ): void;
    /**
     * Sets the tint color of the nodes.
     *
     *
     * @returns `this` to allow method chaining.
     */
    setTintColor(
      /**
       * The node reference or the array of node references.
       */
      nodeRefs: any | any[],
      /**
       * The new tint color of the nodes. The value can be defined as a string in the CSS color format or as an
       * integer in the ABGR format or it could be array of these values. If `null` is passed then the tint color
       * is reset and the node's own tint color should be used.
       */
      tintColor: CSSColor | int | CSSColor[] | int[] | null,
      /**
       * This flag indicates if the change needs to propagate recursively to child nodes.
       */
      recursive?: boolean
    ): this;
    /**
     * Sets the visibility state of the nodes.
     *
     *
     * @returns `this` to allow method chaining.
     */
    setVisibilityState(
      /**
       * The node reference or the array of node references.
       */
      nodeRefs: any | any[],
      /**
       * The new visibility state or array of states of the nodes.
       */
      visible: boolean | boolean[],
      /**
       * The flags indicates if the change needs to propagate recursively to child nodes.
       */
      recursive: boolean,
      /**
       * If a node is made visible but its parent is hidden then it will still be hidden in Viewport. This flag
       * will force node to be visible regardless of parent's state.
       */
      force: boolean
    ): this;
    /**
     * Copy nodes' current transformation into their rest transformation stored in active view.
     *
     *
     * @returns `this` to allow method chaining.
     */
    updateNodesRestTransformation(
      /**
       * Array of node references.
       */
      nodeRefs: any[]
    ): this;
    /**
     * Copy node's current transformation into its rest transformation stored in active view.
     *
     *
     * @returns `this` to allow method chaining.
     */
    updateRestTransformation(
      /**
       * The node reference.
       */
      nodeRef: any,
      /**
       * Do not fire sequence changed event if true
       */
      DoNotFireSequenceChanged: boolean
    ): this;
  }
  /**
   * Describes the settings that can be provided to the ViewStateManager constructor.
   */
  export interface $ViewStateManagerSettings
    extends $ViewStateManagerBaseSettings {}
}

declare module "sap/ui/vk/ToggleMenuButton" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import { IOverflowToolbarContent, ButtonType } from "sap/m/library";

  import { ID, TextDirection, CSSSize } from "sap/ui/core/library";

  import Event from "sap/ui/base/Event";

  import Popup from "sap/ui/core/Popup";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  /**
   * Enables users to trigger actions.
   */
  export default class ToggleMenuButton
    extends Control
    implements IOverflowToolbarContent
  {
    __implements__sap_m_IOverflowToolbarContent: boolean;
    /**
     * Constructor for a new `ToggleMenuButton`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $ToggleMenuButtonSettings
    );
    /**
     * Constructor for a new `ToggleMenuButton`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $ToggleMenuButtonSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vk.ToggleMenuButton with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ToggleMenuButton>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.ToggleMenuButton.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some ariaDescribedBy into the association {@link #getAriaDescribedBy ariaDescribedBy}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addAriaDescribedBy(
      /**
       * The ariaDescribedBy to add; if empty, nothing is inserted
       */
      vAriaDescribedBy: ID | Control
    ): this;
    /**
     * Adds some ariaLabelledBy into the association {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addAriaLabelledBy(
      /**
       * The ariaLabelledBy to add; if empty, nothing is inserted
       */
      vAriaLabelledBy: ID | Control
    ): this;
    /**
     * Adds some item to the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addItem(
      /**
       * The item to add; if empty, nothing is inserted
       */
      oItem: /* was: sap.ui.vk.ToggleMenuItem */ any
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:beforeMenuOpen beforeMenuOpen} event of this
     * `sap.ui.vk.ToggleMenuButton`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.ToggleMenuButton` itself.
     *
     * Fired before menu opening when the `buttonMode` is set to `Split` and the user presses the arrow button.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachBeforeMenuOpen(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.ToggleMenuButton` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:beforeMenuOpen beforeMenuOpen} event of this
     * `sap.ui.vk.ToggleMenuButton`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.ToggleMenuButton` itself.
     *
     * Fired before menu opening when the `buttonMode` is set to `Split` and the user presses the arrow button.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachBeforeMenuOpen(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.ToggleMenuButton` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:itemSelected itemSelected} event of this `sap.ui.vk.ToggleMenuButton`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.ToggleMenuButton` itself.
     *
     * Fired when a `ToggleMenuItem` is selected.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachItemSelected(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ToggleMenuButton$ItemSelectedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.ToggleMenuButton` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:itemSelected itemSelected} event of this `sap.ui.vk.ToggleMenuButton`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.ToggleMenuButton` itself.
     *
     * Fired when a `ToggleMenuItem` is selected.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachItemSelected(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ToggleMenuButton$ItemSelectedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.ToggleMenuButton` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:itemToggled itemToggled} event of this `sap.ui.vk.ToggleMenuButton`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.ToggleMenuButton` itself.
     *
     * Fired when a `ToggleMenuItem` is toggled.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachItemToggled(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ToggleMenuButton$ItemToggledEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.ToggleMenuButton` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:itemToggled itemToggled} event of this `sap.ui.vk.ToggleMenuButton`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.ToggleMenuButton` itself.
     *
     * Fired when a `ToggleMenuItem` is toggled.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachItemToggled(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ToggleMenuButton$ItemToggledEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.ToggleMenuButton` itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys all the items in the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyItems(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:beforeMenuOpen beforeMenuOpen} event of this
     * `sap.ui.vk.ToggleMenuButton`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachBeforeMenuOpen(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:itemSelected itemSelected} event of this `sap.ui.vk.ToggleMenuButton`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachItemSelected(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: ToggleMenuButton$ItemSelectedEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:itemToggled itemToggled} event of this `sap.ui.vk.ToggleMenuButton`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachItemToggled(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: ToggleMenuButton$ItemToggledEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:beforeMenuOpen beforeMenuOpen} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireBeforeMenuOpen(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:itemSelected itemSelected} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireItemSelected(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: ToggleMenuButton$ItemSelectedEventParameters
    ): this;
    /**
     * Fires event {@link #event:itemToggled itemToggled} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireItemToggled(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: ToggleMenuButton$ItemToggledEventParameters
    ): this;
    /**
     * Returns array of IDs of the elements which are the current targets of the association {@link #getAriaDescribedBy ariaDescribedBy}.
     */
    getAriaDescribedBy(): ID[];
    /**
     * Returns array of IDs of the elements which are the current targets of the association {@link #getAriaLabelledBy ariaLabelledBy}.
     */
    getAriaLabelledBy(): ID[];
    /**
     * ID of the element which is the current target of the association {@link #getDefaultItem defaultItem},
     * or `null`.
     */
    getDefaultItem(): ID | null;
    /**
     * Gets current value of property {@link #getEnabled enabled}.
     *
     * Boolean property to enable the control (default is `true`). **Note:** Depending on custom settings, the
     * buttons that are disabled have other colors than the enabled ones.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `enabled`
     */
    getEnabled(): boolean;
    /**
     * Gets current value of property {@link #getIconDensityAware iconDensityAware}.
     *
     * When set to `truefalse` to avoid the attempt of fetching density perfect image.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `iconDensityAware`
     */
    getIconDensityAware(): boolean;
    /**
     * Gets content of aggregation {@link #getItems items}.
     *
     * Defines the menu items contained within this control.
     */
    getItems(): /* was: sap.ui.vk.ToggleMenuItem */ any[];
    /**
     * Gets current value of property {@link #getMenuPosition menuPosition}.
     *
     * Specifies the position of the popup menu with enumerated options. By default, the control opens the menu
     * at its bottom left side.
     *
     * **Note:** In the case that the menu has no space to show itself in the view port of the current window
     * it tries to open itself to the inverted direction.
     *
     * Default value is `BeginBottom`.
     *
     *
     * @returns Value of property `menuPosition`
     */
    getMenuPosition(): typeof Popup.Dock;
    /**
     * Gets current value of property {@link #getPressed pressed}.
     *
     * The property is “true” when the control is toggled. The default state of this property is "false".
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `pressed`
     */
    getPressed(): boolean;
    /**
     * Gets current value of property {@link #getTextDirection textDirection}.
     *
     * This property specifies the element's text directionality with enumerated options. By default, the control
     * inherits text direction from the DOM.
     *
     * Default value is `Inherit`.
     *
     *
     * @returns Value of property `textDirection`
     */
    getTextDirection(): TextDirection;
    /**
     * Gets current value of property {@link #getType type}.
     *
     * Defines the type of the button (for example, Default, Accept, Reject, Transparent). Values `Back`, `Up`
     * and `Unstyled` are ignored.
     *
     * Default value is `Default`.
     *
     *
     * @returns Value of property `type`
     */
    getType(): ButtonType;
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * Defines the width of the button.
     *
     *
     * @returns Value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * Checks for the provided `sap.ui.vk.ToggleMenuItem` in the aggregation {@link #getItems items}. and returns
     * its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfItem(
      /**
       * The item whose index is looked for
       */
      oItem: /* was: sap.ui.vk.ToggleMenuItem */ any
    ): int;
    /**
     * Inserts a item into the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertItem(
      /**
       * The item to insert; if empty, nothing is inserted
       */
      oItem: /* was: sap.ui.vk.ToggleMenuItem */ any,
      /**
       * The `0`-based index the item should be inserted at; for a negative value of `iIndex`, the item is inserted
       * at position 0; for a value greater than the current size of the aggregation, the item is inserted at
       * the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls in the association named {@link #getAriaDescribedBy ariaDescribedBy}.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllAriaDescribedBy(): ID[];
    /**
     * Removes all the controls in the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllAriaLabelledBy(): ID[];
    /**
     * Removes all the controls from the aggregation {@link #getItems items}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllItems(): /* was: sap.ui.vk.ToggleMenuItem */ any[];
    /**
     * Removes an ariaDescribedBy from the association named {@link #getAriaDescribedBy ariaDescribedBy}.
     *
     *
     * @returns The removed ariaDescribedBy or `null`
     */
    removeAriaDescribedBy(
      /**
       * The ariaDescribedBy to be removed or its index or ID
       */
      vAriaDescribedBy: int | ID | Control
    ): ID | null;
    /**
     * Removes an ariaLabelledBy from the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns The removed ariaLabelledBy or `null`
     */
    removeAriaLabelledBy(
      /**
       * The ariaLabelledBy to be removed or its index or ID
       */
      vAriaLabelledBy: int | ID | Control
    ): ID | null;
    /**
     * Removes a item from the aggregation {@link #getItems items}.
     *
     *
     * @returns The removed item or `null`
     */
    removeItem(
      /**
       * The item to remove or its index or id
       */
      vItem: int | string | /* was: sap.ui.vk.ToggleMenuItem */ any
    ): /* was: sap.ui.vk.ToggleMenuItem */ any | null;
    /**
     * Sets the arrow state to down or not down.
     */
    setArrowState(
      /**
       * Is the arrow down
       */
      bIsDown: boolean
    ): void;
    /**
     * Sets the associated {@link #getDefaultItem defaultItem}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDefaultItem(
      /**
       * ID of an element which becomes the new target of this defaultItem association; alternatively, an element
       * instance may be given
       */
      oDefaultItem: ID | /* was: sap.ui.vk.ToggleMenuItem */ any
    ): this;
    /**
     * Sets a new value for property {@link #getEnabled enabled}.
     *
     * Boolean property to enable the control (default is `true`). **Note:** Depending on custom settings, the
     * buttons that are disabled have other colors than the enabled ones.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnabled(
      /**
       * New value for property `enabled`
       */
      bEnabled?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getIconDensityAware iconDensityAware}.
     *
     * When set to `truefalse` to avoid the attempt of fetching density perfect image.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIconDensityAware(
      /**
       * New value for property `iconDensityAware`
       */
      bIconDensityAware?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getMenuPosition menuPosition}.
     *
     * Specifies the position of the popup menu with enumerated options. By default, the control opens the menu
     * at its bottom left side.
     *
     * **Note:** In the case that the menu has no space to show itself in the view port of the current window
     * it tries to open itself to the inverted direction.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `BeginBottom`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMenuPosition(
      /**
       * New value for property `menuPosition`
       */
      sMenuPosition?: typeof Popup.Dock | keyof typeof Popup.Dock
    ): this;
    /**
     * Sets a new value for property {@link #getPressed pressed}.
     *
     * The property is “true” when the control is toggled. The default state of this property is "false".
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPressed(
      /**
       * New value for property `pressed`
       */
      bPressed?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getTextDirection textDirection}.
     *
     * This property specifies the element's text directionality with enumerated options. By default, the control
     * inherits text direction from the DOM.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Inherit`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTextDirection(
      /**
       * New value for property `textDirection`
       */
      sTextDirection?: TextDirection | keyof typeof TextDirection
    ): this;
    /**
     * Sets a new value for property {@link #getType type}.
     *
     * Defines the type of the button (for example, Default, Accept, Reject, Transparent). Values `Back`, `Up`
     * and `Unstyled` are ignored.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Default`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setType(
      /**
       * New value for property `type`
       */
      sType?: ButtonType | keyof typeof ButtonType
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * Defines the width of the button.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      sWidth?: CSSSize
    ): this;
  }
  /**
   * Describes the settings that can be provided to the ToggleMenuButton constructor.
   */
  export interface $ToggleMenuButtonSettings extends $ControlSettings {
    /**
     * Defines the type of the button (for example, Default, Accept, Reject, Transparent). Values `Back`, `Up`
     * and `Unstyled` are ignored.
     */
    type?:
      | (ButtonType | keyof typeof ButtonType)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Defines the width of the button.
     */
    width?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Boolean property to enable the control (default is `true`). **Note:** Depending on custom settings, the
     * buttons that are disabled have other colors than the enabled ones.
     */
    enabled?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * When set to `truefalse` to avoid the attempt of fetching density perfect image.
     */
    iconDensityAware?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Specifies the position of the popup menu with enumerated options. By default, the control opens the menu
     * at its bottom left side.
     *
     * **Note:** In the case that the menu has no space to show itself in the view port of the current window
     * it tries to open itself to the inverted direction.
     */
    menuPosition?:
      | (typeof Popup.Dock | keyof typeof Popup.Dock)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * This property specifies the element's text directionality with enumerated options. By default, the control
     * inherits text direction from the DOM.
     */
    textDirection?:
      | (TextDirection | keyof typeof TextDirection)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * The property is “true” when the control is toggled. The default state of this property is "false".
     */
    pressed?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the menu items contained within this control.
     */
    items?: /* was: sap.ui.vk.ToggleMenuItem */
      | any[]
      | /* was: sap.ui.vk.ToggleMenuItem */ any
      | AggregationBindingInfo
      | `{${string}}`;

    /**
     * Sets or retrieves the selected item from the aggregation named items.
     */
    defaultItem?: /* was: sap.ui.vk.ToggleMenuItem */ any | string;

    /**
     * Association to controls / IDs, which describe this control (see WAI-ARIA attribute aria-describedby).
     */
    ariaDescribedBy?: Array<Control | string>;

    /**
     * Association to controls / IDs, which label this control (see WAI-ARIA attribute aria-labelledby).
     */
    ariaLabelledBy?: Array<Control | string>;

    /**
     * Fired before menu opening when the `buttonMode` is set to `Split` and the user presses the arrow button.
     */
    beforeMenuOpen?: (oEvent: Event) => void;

    /**
     * Fired when a `ToggleMenuItem` is toggled.
     */
    itemToggled?: (oEvent: ToggleMenuButton$ItemToggledEvent) => void;

    /**
     * Fired when a `ToggleMenuItem` is selected.
     */
    itemSelected?: (oEvent: ToggleMenuButton$ItemSelectedEvent) => void;
  }

  /**
   * Parameters of the ToggleMenuButton#beforeMenuOpen event.
   */
  export interface ToggleMenuButton$BeforeMenuOpenEventParameters {}

  /**
   * Event object of the ToggleMenuButton#beforeMenuOpen event.
   */
  export type ToggleMenuButton$BeforeMenuOpenEvent = Event<
    ToggleMenuButton$BeforeMenuOpenEventParameters,
    ToggleMenuButton
  >;

  /**
   * Parameters of the ToggleMenuButton#itemSelected event.
   */
  export interface ToggleMenuButton$ItemSelectedEventParameters {
    /**
     * The `ToggleMenuItem` which was selected.
     */
    item?: /* was: sap.ui.vk.ToggleMenuItem */ any;
  }

  /**
   * Event object of the ToggleMenuButton#itemSelected event.
   */
  export type ToggleMenuButton$ItemSelectedEvent = Event<
    ToggleMenuButton$ItemSelectedEventParameters,
    ToggleMenuButton
  >;

  /**
   * Parameters of the ToggleMenuButton#itemToggled event.
   */
  export interface ToggleMenuButton$ItemToggledEventParameters {
    /**
     * The `ToggleMenuItem` which was unpressed.
     */
    oldItem?: /* was: sap.ui.vk.ToggleMenuItem */ any;

    /**
     * The `ToggleMenuItem` which was pressed.
     */
    newItem?: /* was: sap.ui.vk.ToggleMenuItem */ any;
  }

  /**
   * Event object of the ToggleMenuButton#itemToggled event.
   */
  export type ToggleMenuButton$ItemToggledEvent = Event<
    ToggleMenuButton$ItemToggledEventParameters,
    ToggleMenuButton
  >;
}

declare module "sap/ui/vk/Toolbar" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { AggregationBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Provides buttons to hide or show certain sap.ui.vk controls.
   *
   * @since 1.32.0
   */
  export default class Toolbar extends Control {
    /**
     * Constructor for a new Toolbar.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $ToolbarSettings
    );
    /**
     * Constructor for a new Toolbar.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $ToolbarSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vk.Toolbar with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Toolbar>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.Toolbar.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some content to the aggregation {@link #getContent content}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addContent(
      /**
       * The content to add; if empty, nothing is inserted
       */
      oContent: Control
    ): this;
    /**
     * Destroys all the content in the aggregation {@link #getContent content}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyContent(): this;
    /**
     * Gets content of aggregation {@link #getContent content}.
     *
     * Toolbar content, this can be used to add/remove buttons and other SAP UI5 controls to the toolbar
     */
    getContent(): Control[];
    /**
     * Checks for the provided `sap.ui.core.Control` in the aggregation {@link #getContent content}. and returns
     * its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfContent(
      /**
       * The content whose index is looked for
       */
      oContent: Control
    ): int;
    /**
     * Inserts a content into the aggregation {@link #getContent content}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertContent(
      /**
       * The content to insert; if empty, nothing is inserted
       */
      oContent: Control,
      /**
       * The `0`-based index the content should be inserted at; for a negative value of `iIndex`, the content
       * is inserted at position 0; for a value greater than the current size of the aggregation, the content
       * is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getContent content}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllContent(): Control[];
    /**
     * Removes a content from the aggregation {@link #getContent content}.
     *
     *
     * @returns The removed content or `null`
     */
    removeContent(
      /**
       * The content to remove or its index or id
       */
      vContent: int | string | Control
    ): Control | null;
  }
  /**
   * Describes the settings that can be provided to the Toolbar constructor.
   */
  export interface $ToolbarSettings extends $ControlSettings {
    /**
     * Toolbar content, this can be used to add/remove buttons and other SAP UI5 controls to the toolbar
     */
    content?: Control[] | Control | AggregationBindingInfo | `{${string}}`;
  }
}

declare module "sap/ui/vk/tools/AnchorPointTool" {
  import { default as Tool, $ToolSettings } from "sap/ui/vk/tools/Tool";

  import AnchorPointToolOperation from "sap/ui/vk/tools/AnchorPointToolOperation";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  import Event from "sap/ui/base/Event";

  /**
   * Tool used to define an anchor point and orientation in 3D space which can be used to rotate, move or
   * scale one or more selected objects
   */
  export default class AnchorPointTool extends Tool {
    /**
     * Constructor for an AnchorPointTool.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * An optional map/JSON object with initial property values, aggregated objects etc. for the new tool instance.
       */
      mSettings?: $AnchorPointToolSettings
    );
    /**
     * Constructor for an AnchorPointTool.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID of the new tool instance. `sId`is generated automatically if no non-empty ID is given. Note: this
       * can be omitted, regardless of whether `mSettings` will be provided or not.
       */
      sId?: string,
      /**
       * An optional map/JSON object with initial property values, aggregated objects etc. for the new tool instance.
       */
      mSettings?: $AnchorPointToolSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vk.tools.AnchorPointTool with name `sClassName` and enriches it
     * with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.vk.tools.Tool.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, AnchorPointTool>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.tools.AnchorPointTool.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Aligns the anchor point rotation to the object rotation.
     *
     *
     * @returns `this` to allow method chaining.
     */
    alignTo(
      /**
       * The node reference or Matrix4.
       */
      target: any
    ): this;
    /**
     * Aligns the anchor point rotation to the camera rotation.
     *
     *
     * @returns `this` to allow method chaining.
     */
    alignToScreen(): this;
    /**
     * Aligns the anchor point rotation to the world coordinate system.
     *
     *
     * @returns `this` to allow method chaining.
     */
    alignToWorld(): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:moved moved} event of this `sap.ui.vk.tools.AnchorPointTool`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.tools.AnchorPointTool` itself.
     *
     * This event will be fired when movement finished.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachMoved(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: AnchorPointTool$MovedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.tools.AnchorPointTool` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:moved moved} event of this `sap.ui.vk.tools.AnchorPointTool`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.tools.AnchorPointTool` itself.
     *
     * This event will be fired when movement finished.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachMoved(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: AnchorPointTool$MovedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.tools.AnchorPointTool` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:moving moving} event of this `sap.ui.vk.tools.AnchorPointTool`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.tools.AnchorPointTool` itself.
     *
     * This event will be fired when movement occurs.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachMoving(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: AnchorPointTool$MovingEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.tools.AnchorPointTool` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:moving moving} event of this `sap.ui.vk.tools.AnchorPointTool`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.tools.AnchorPointTool` itself.
     *
     * This event will be fired when movement occurs.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachMoving(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: AnchorPointTool$MovingEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.tools.AnchorPointTool` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:rotated rotated} event of this `sap.ui.vk.tools.AnchorPointTool`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.tools.AnchorPointTool` itself.
     *
     * This event will be fired when rotation finished.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachRotated(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: AnchorPointTool$RotatedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.tools.AnchorPointTool` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:rotated rotated} event of this `sap.ui.vk.tools.AnchorPointTool`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.tools.AnchorPointTool` itself.
     *
     * This event will be fired when rotation finished.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachRotated(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: AnchorPointTool$RotatedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.tools.AnchorPointTool` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:rotating rotating} event of this `sap.ui.vk.tools.AnchorPointTool`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.tools.AnchorPointTool` itself.
     *
     * This event will be fired when rotation occurs.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachRotating(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: AnchorPointTool$RotatingEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.tools.AnchorPointTool` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:rotating rotating} event of this `sap.ui.vk.tools.AnchorPointTool`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.tools.AnchorPointTool` itself.
     *
     * This event will be fired when rotation occurs.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachRotating(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: AnchorPointTool$RotatingEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.tools.AnchorPointTool` itself
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:moved moved} event of this `sap.ui.vk.tools.AnchorPointTool`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachMoved(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: AnchorPointTool$MovedEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:moving moving} event of this `sap.ui.vk.tools.AnchorPointTool`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachMoving(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: AnchorPointTool$MovingEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:rotated rotated} event of this `sap.ui.vk.tools.AnchorPointTool`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachRotated(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: AnchorPointTool$RotatedEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:rotating rotating} event of this `sap.ui.vk.tools.AnchorPointTool`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachRotating(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: AnchorPointTool$RotatingEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:moved moved} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireMoved(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: AnchorPointTool$MovedEventParameters
    ): this;
    /**
     * Fires event {@link #event:moving moving} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireMoving(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: AnchorPointTool$MovingEventParameters
    ): this;
    /**
     * Fires event {@link #event:rotated rotated} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireRotated(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: AnchorPointTool$RotatedEventParameters
    ): this;
    /**
     * Fires event {@link #event:rotating rotating} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireRotating(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: AnchorPointTool$RotatingEventParameters
    ): this;
    /**
     * Gets current value of property {@link #getAllowContextMenu allowContextMenu}.
     *
     * Whether or not to allow context menu on right-click
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `allowContextMenu`
     */
    getAllowContextMenu(): boolean;
    /**
     * Gets current value of property {@link #getAllowOperation allowOperation}.
     *
     * Indicates the type of allowed operations
     *
     * Default value is `All`.
     *
     *
     * @returns Value of property `allowOperation`
     */
    getAllowOperation(): AnchorPointToolOperation;
    /**
     * Gets current value of property {@link #getEnableStepping enableStepping}.
     *
     * If set to true values will change in round number increments instead of continual change
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `enableStepping`
     */
    getEnableStepping(): boolean;
    /**
     * Gets current value of property {@link #getPosition position}.
     *
     * The anchor point tool position in the world coordinate system. This property is read-only.
     *
     *
     * @returns Value of property `position`
     */
    getPosition(): any;
    /**
     * Gets current value of property {@link #getQuaternion quaternion}.
     *
     * The anchor point tool quaternion. This property is read-only.
     *
     *
     * @returns Value of property `quaternion`
     */
    getQuaternion(): any;
    /**
     * Gets current value of property {@link #getShowEditingUI showEditingUI}.
     *
     * Display text box with current value, which can also be used to directly modify the value
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `showEditingUI`
     */
    getShowEditingUI(): boolean;
    /**
     * Performs movement of the anchor point.
     *
     *
     * @returns `this` to allow method chaining.
     */
    move(
      /**
       * Movement offset along x axis.
       */
      x?: float,
      /**
       * Movement offset along y axis.
       */
      y?: float,
      /**
       * Movement offset along z axis.
       */
      z?: float
    ): this;
    /**
     * Moves the anchor point to the center of objects or object's origin.
     *
     *
     * @returns `this` to allow method chaining.
     */
    moveTo(
      /**
       * The node reference or the array of node references or Matrix4.
       */
      target: any | any[],
      /**
       * Use the object's origin if true or the center of objects if false.
       */
      useObjectsOrigin: boolean
    ): this;
    /**
     * MOVE TO BASE Queues a command for execution during the rendering cycle. All gesture operations should
     * be called using this method.
     *
     *
     * @returns `this` to allow method chaining.
     */
    queueCommand(
      /**
       * The command to be executed.
       */
      command: Function
    ): this;
    /**
     * Performs rotation of the anchor point.
     *
     *
     * @returns `this` to allow method chaining.
     */
    rotate(
      /**
       * Rotation angle around x axis in degrees.
       */
      x?: float,
      /**
       * Rotation angle around y axis in degrees.
       */
      y?: float,
      /**
       * Rotation angle around z axis in degrees.
       */
      z?: float
    ): this;
    /**
     * Sets a new value for property {@link #getAllowContextMenu allowContextMenu}.
     *
     * Whether or not to allow context menu on right-click
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAllowContextMenu(
      /**
       * New value for property `allowContextMenu`
       */
      bAllowContextMenu?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getAllowOperation allowOperation}.
     *
     * Indicates the type of allowed operations
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `All`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAllowOperation(
      /**
       * New value for property `allowOperation`
       */
      sAllowOperation?:
        | AnchorPointToolOperation
        | keyof typeof AnchorPointToolOperation
    ): this;
    /**
     * Sets a new value for property {@link #getEnableStepping enableStepping}.
     *
     * If set to true values will change in round number increments instead of continual change
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnableStepping(
      /**
       * New value for property `enableStepping`
       */
      bEnableStepping?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getPosition position}.
     *
     * The anchor point tool position in the world coordinate system. This property is read-only.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPosition(
      /**
       * New value for property `position`
       */
      oPosition?: any
    ): this;
    /**
     * Sets a new value for property {@link #getQuaternion quaternion}.
     *
     * The anchor point tool quaternion. This property is read-only.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setQuaternion(
      /**
       * New value for property `quaternion`
       */
      oQuaternion?: any
    ): this;
    /**
     * Sets a new value for property {@link #getShowEditingUI showEditingUI}.
     *
     * Display text box with current value, which can also be used to directly modify the value
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowEditingUI(
      /**
       * New value for property `showEditingUI`
       */
      bShowEditingUI?: boolean
    ): this;
  }
  /**
   * Describes the settings that can be provided to the AnchorPointTool constructor.
   */
  export interface $AnchorPointToolSettings extends $ToolSettings {
    /**
     * If set to true values will change in round number increments instead of continual change
     */
    enableStepping?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Display text box with current value, which can also be used to directly modify the value
     */
    showEditingUI?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Indicates the type of allowed operations
     */
    allowOperation?:
      | (AnchorPointToolOperation | keyof typeof AnchorPointToolOperation)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Whether or not to allow context menu on right-click
     */
    allowContextMenu?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * The anchor point tool position in the world coordinate system. This property is read-only.
     */
    position?: any | PropertyBindingInfo | `{${string}}`;

    /**
     * The anchor point tool quaternion. This property is read-only.
     */
    quaternion?: any | PropertyBindingInfo | `{${string}}`;

    /**
     * This event will be fired when movement occurs.
     */
    moving?: (oEvent: AnchorPointTool$MovingEvent) => void;

    /**
     * This event will be fired when movement finished.
     */
    moved?: (oEvent: AnchorPointTool$MovedEvent) => void;

    /**
     * This event will be fired when rotation occurs.
     */
    rotating?: (oEvent: AnchorPointTool$RotatingEvent) => void;

    /**
     * This event will be fired when rotation finished.
     */
    rotated?: (oEvent: AnchorPointTool$RotatedEvent) => void;
  }

  /**
   * Parameters of the AnchorPointTool#moved event.
   */
  export interface AnchorPointTool$MovedEventParameters {
    x?: float;

    y?: float;

    z?: float;
  }

  /**
   * Event object of the AnchorPointTool#moved event.
   */
  export type AnchorPointTool$MovedEvent = Event<
    AnchorPointTool$MovedEventParameters,
    AnchorPointTool
  >;

  /**
   * Parameters of the AnchorPointTool#moving event.
   */
  export interface AnchorPointTool$MovingEventParameters {
    x?: float;

    y?: float;

    z?: float;
  }

  /**
   * Event object of the AnchorPointTool#moving event.
   */
  export type AnchorPointTool$MovingEvent = Event<
    AnchorPointTool$MovingEventParameters,
    AnchorPointTool
  >;

  /**
   * Parameters of the AnchorPointTool#rotated event.
   */
  export interface AnchorPointTool$RotatedEventParameters {
    x?: float;

    y?: float;

    z?: float;
  }

  /**
   * Event object of the AnchorPointTool#rotated event.
   */
  export type AnchorPointTool$RotatedEvent = Event<
    AnchorPointTool$RotatedEventParameters,
    AnchorPointTool
  >;

  /**
   * Parameters of the AnchorPointTool#rotating event.
   */
  export interface AnchorPointTool$RotatingEventParameters {
    x?: float;

    y?: float;

    z?: float;
  }

  /**
   * Event object of the AnchorPointTool#rotating event.
   */
  export type AnchorPointTool$RotatingEvent = Event<
    AnchorPointTool$RotatingEventParameters,
    AnchorPointTool
  >;
}

declare module "sap/ui/vk/tools/AnchorPointToolOperation" {
  /**
   * Sets the allowed operations on the anchor point tool
   */
  enum AnchorPointToolOperation {
    /**
     * Allow both rotation and move
     */
    All = "All",
    /**
     * Allow only move
     */
    Move = "Move",
    /**
     * Allow only rotation
     */
    Rotate = "Rotate",
  }
  export default AnchorPointToolOperation;
}

declare module "sap/ui/vk/tools/AxisAngleRotationTool" {
  import { default as Tool, $ToolSettings } from "sap/ui/vk/tools/Tool";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import ToolNodeSet from "sap/ui/vk/tools/ToolNodeSet";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  import Event from "sap/ui/base/Event";

  /**
   * Tool to rotate 3D objects in space
   */
  export default class AxisAngleRotationTool extends Tool {
    /**
     * Constructor for a new AxisAngleRotationTool.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * An optional map/JSON object with initial property values, aggregated objects etc. for the new tool instance.
       */
      mSettings?: $AxisAngleRotationToolSettings
    );
    /**
     * Constructor for a new AxisAngleRotationTool.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID of the new tool instance. `sId`is generated automatically if no non-empty ID is given. Note: this
       * can be omitted, regardless of whether `mSettings` will be provided or not.
       */
      sId?: string,
      /**
       * An optional map/JSON object with initial property values, aggregated objects etc. for the new tool instance.
       */
      mSettings?: $AxisAngleRotationToolSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vk.tools.AxisAngleRotationTool with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.vk.tools.Tool.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, AxisAngleRotationTool>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.tools.AxisAngleRotationTool.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:rotated rotated} event of this `sap.ui.vk.tools.AxisAngleRotationTool`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.tools.AxisAngleRotationTool` itself.
     *
     * This event will be fired when rotation finished. This event contains parameter 'nodesProperties' that
     * is array of objects, each object has five properties:
     * 	 - `node: any` - A node reference.
     * 	 - `angle: float` - An angle of rotation about the axis.
     * 	 - `azimuth: float` - An azimuth of the axis of rotation in degrees in the parent's space.
     * 	 - `elevation: float` - An elevation of the axis of rotation in degrees in the parent's space.
     * 	 - `axis: float[]` - An axis of rotation in cartesian coordinates in the parent's space.  An axis
     *     of rotation in animation keys is stored in cartesian coordinates, in UI an axis of rotation is displayed
     *     in polar coordinates using azimuth and elevation.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachRotated(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: AxisAngleRotationTool$RotatedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.tools.AxisAngleRotationTool`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:rotated rotated} event of this `sap.ui.vk.tools.AxisAngleRotationTool`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.tools.AxisAngleRotationTool` itself.
     *
     * This event will be fired when rotation finished. This event contains parameter 'nodesProperties' that
     * is array of objects, each object has five properties:
     * 	 - `node: any` - A node reference.
     * 	 - `angle: float` - An angle of rotation about the axis.
     * 	 - `azimuth: float` - An azimuth of the axis of rotation in degrees in the parent's space.
     * 	 - `elevation: float` - An elevation of the axis of rotation in degrees in the parent's space.
     * 	 - `axis: float[]` - An axis of rotation in cartesian coordinates in the parent's space.  An axis
     *     of rotation in animation keys is stored in cartesian coordinates, in UI an axis of rotation is displayed
     *     in polar coordinates using azimuth and elevation.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachRotated(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: AxisAngleRotationTool$RotatedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.tools.AxisAngleRotationTool`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:rotating rotating} event of this `sap.ui.vk.tools.AxisAngleRotationTool`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.tools.AxisAngleRotationTool` itself.
     *
     * This event will be fired when rotation finished. This event contains parameter 'nodesProperties' that
     * is array of objects, each object has five properties:
     * 	 - `node: any` - A node reference.
     * 	 - `angle: float` - An angle of rotation about the axis.
     * 	 - `azimuth: float` - An azimuth of the axis of rotation in degrees in the parent's space.
     * 	 - `elevation: float` - An elevation of the axis of rotation in degrees in the parent's space.
     * 	 - `axis: float[]` - An axis of rotation in cartesian coordinates in the parent's space.  An axis
     *     of rotation in animation keys is stored in cartesian coordinates, in UI an axis of rotation is displayed
     *     in polar coordinates using azimuth and elevation.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachRotating(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: AxisAngleRotationTool$RotatingEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.tools.AxisAngleRotationTool`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:rotating rotating} event of this `sap.ui.vk.tools.AxisAngleRotationTool`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.tools.AxisAngleRotationTool` itself.
     *
     * This event will be fired when rotation finished. This event contains parameter 'nodesProperties' that
     * is array of objects, each object has five properties:
     * 	 - `node: any` - A node reference.
     * 	 - `angle: float` - An angle of rotation about the axis.
     * 	 - `azimuth: float` - An azimuth of the axis of rotation in degrees in the parent's space.
     * 	 - `elevation: float` - An elevation of the axis of rotation in degrees in the parent's space.
     * 	 - `axis: float[]` - An axis of rotation in cartesian coordinates in the parent's space.  An axis
     *     of rotation in animation keys is stored in cartesian coordinates, in UI an axis of rotation is displayed
     *     in polar coordinates using azimuth and elevation.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachRotating(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: AxisAngleRotationTool$RotatingEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.tools.AxisAngleRotationTool`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:rotated rotated} event of this `sap.ui.vk.tools.AxisAngleRotationTool`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachRotated(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: AxisAngleRotationTool$RotatedEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:rotating rotating} event of this `sap.ui.vk.tools.AxisAngleRotationTool`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachRotating(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: AxisAngleRotationTool$RotatingEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:rotated rotated} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireRotated(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: AxisAngleRotationTool$RotatedEventParameters
    ): this;
    /**
     * Fires event {@link #event:rotating rotating} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireRotating(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: AxisAngleRotationTool$RotatingEventParameters
    ): this;
    /**
     * Gets current value of property {@link #getAllowContextMenu allowContextMenu}.
     *
     * Whether or not to allow context menu on right-click
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `allowContextMenu`
     */
    getAllowContextMenu(): boolean;
    /**
     * Gets current value of property {@link #getEnableSnapping enableSnapping}.
     *
     * Determines if snapping when rotating is enabled
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `enableSnapping`
     */
    getEnableSnapping(): boolean;
    /**
     * Gets current value of property {@link #getEnableStepping enableStepping}.
     *
     * If set to `true` values will change in round number increments instead of continual change
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `enableStepping`
     */
    getEnableStepping(): boolean;
    /**
     * Gets current value of property {@link #getNodeSet nodeSet}.
     *
     * Determine what set of nodes will be transformed with this tool
     *
     * Default value is `Highlight`.
     *
     *
     * @returns Value of property `nodeSet`
     */
    getNodeSet(): ToolNodeSet;
    /**
     * Gets current value of property {@link #getShowEditingUI showEditingUI}.
     *
     * Display text box with current value, which can also be used to directly modify the value
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `showEditingUI`
     */
    getShowEditingUI(): boolean;
    /**
     * MOVE TO BASE Queues a command for execution during the rendering cycle. All gesture operations should
     * be called using this method.
     *
     *
     * @returns `this` to allow method chaining.
     */
    queueCommand(
      /**
       * The command to be executed.
       */
      command: Function
    ): this;
    /**
     * Sets a new value for property {@link #getAllowContextMenu allowContextMenu}.
     *
     * Whether or not to allow context menu on right-click
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAllowContextMenu(
      /**
       * New value for property `allowContextMenu`
       */
      bAllowContextMenu?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getEnableSnapping enableSnapping}.
     *
     * Determines if snapping when rotating is enabled
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnableSnapping(
      /**
       * New value for property `enableSnapping`
       */
      bEnableSnapping?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getEnableStepping enableStepping}.
     *
     * If set to `true` values will change in round number increments instead of continual change
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnableStepping(
      /**
       * New value for property `enableStepping`
       */
      bEnableStepping?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getNodeSet nodeSet}.
     *
     * Determine what set of nodes will be transformed with this tool
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Highlight`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setNodeSet(
      /**
       * New value for property `nodeSet`
       */
      sNodeSet?: ToolNodeSet | keyof typeof ToolNodeSet
    ): this;
    /**
     * Sets a new value for property {@link #getShowEditingUI showEditingUI}.
     *
     * Display text box with current value, which can also be used to directly modify the value
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowEditingUI(
      /**
       * New value for property `showEditingUI`
       */
      bShowEditingUI?: boolean
    ): this;
  }
  /**
   * Describes the settings that can be provided to the AxisAngleRotationTool constructor.
   */
  export interface $AxisAngleRotationToolSettings extends $ToolSettings {
    /**
     * If set to `true` values will change in round number increments instead of continual change
     */
    enableStepping?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Determines if snapping when rotating is enabled
     */
    enableSnapping?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Display text box with current value, which can also be used to directly modify the value
     */
    showEditingUI?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Whether or not to allow context menu on right-click
     */
    allowContextMenu?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Determine what set of nodes will be transformed with this tool
     */
    nodeSet?:
      | (ToolNodeSet | keyof typeof ToolNodeSet)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * This event will be fired when rotation finished. This event contains parameter 'nodesProperties' that
     * is array of objects, each object has five properties:
     * 	 - `node: any` - A node reference.
     * 	 - `angle: float` - An angle of rotation about the axis.
     * 	 - `azimuth: float` - An azimuth of the axis of rotation in degrees in the parent's space.
     * 	 - `elevation: float` - An elevation of the axis of rotation in degrees in the parent's space.
     * 	 - `axis: float[]` - An axis of rotation in cartesian coordinates in the parent's space.  An axis
     *     of rotation in animation keys is stored in cartesian coordinates, in UI an axis of rotation is displayed
     *     in polar coordinates using azimuth and elevation.
     */
    rotating?: (oEvent: AxisAngleRotationTool$RotatingEvent) => void;

    /**
     * This event will be fired when rotation finished. This event contains parameter 'nodesProperties' that
     * is array of objects, each object has five properties:
     * 	 - `node: any` - A node reference.
     * 	 - `angle: float` - An angle of rotation about the axis.
     * 	 - `azimuth: float` - An azimuth of the axis of rotation in degrees in the parent's space.
     * 	 - `elevation: float` - An elevation of the axis of rotation in degrees in the parent's space.
     * 	 - `axis: float[]` - An axis of rotation in cartesian coordinates in the parent's space.  An axis
     *     of rotation in animation keys is stored in cartesian coordinates, in UI an axis of rotation is displayed
     *     in polar coordinates using azimuth and elevation.
     */
    rotated?: (oEvent: AxisAngleRotationTool$RotatedEvent) => void;
  }

  /**
   * Parameters of the AxisAngleRotationTool#rotated event.
   */
  export interface AxisAngleRotationTool$RotatedEventParameters {
    nodesProperties?: object[];
  }

  /**
   * Event object of the AxisAngleRotationTool#rotated event.
   */
  export type AxisAngleRotationTool$RotatedEvent = Event<
    AxisAngleRotationTool$RotatedEventParameters,
    AxisAngleRotationTool
  >;

  /**
   * Parameters of the AxisAngleRotationTool#rotating event.
   */
  export interface AxisAngleRotationTool$RotatingEventParameters {
    nodesProperties?: object[];
  }

  /**
   * Event object of the AxisAngleRotationTool#rotating event.
   */
  export type AxisAngleRotationTool$RotatingEvent = Event<
    AxisAngleRotationTool$RotatingEventParameters,
    AxisAngleRotationTool
  >;
}

declare module "sap/ui/vk/tools/CoordinateSystem" {
  /**
   * Defines the coordinate system type.
   */
  enum CoordinateSystem {
    /**
     * Custom coordinate system, defined by anchor point tool
     */
    Custom = "Custom",
    /**
     * Local coordinate system
     */
    Local = "Local",
    /**
     * Parent coordinate system
     */
    Parent = "Parent",
    /**
     * Screen coordinate system
     */
    Screen = "Screen",
    /**
     * World coordinate system
     */
    World = "World",
  }
  export default CoordinateSystem;
}

declare module "sap/ui/vk/tools/CreateEllipseTool" {
  import { default as Tool, $ToolSettings } from "sap/ui/vk/tools/Tool";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  import Event from "sap/ui/base/Event";

  /**
   * The CreateEllipseTool allows applications to create an ellipse/circle svg element.
   */
  export default class CreateEllipseTool extends Tool {
    /**
     * Constructor for a new CreateEllipseTool.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * An optional map/JSON object with initial property values, aggregated objects etc. for the new tool instance.
       */
      mSettings?: $CreateEllipseToolSettings
    );
    /**
     * Constructor for a new CreateEllipseTool.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID of the new tool instance. `sId`is generated automatically if no non-empty ID is given. Note: this
       * can be omitted, regardless of whether `mSettings` will be provided or not.
       */
      sId?: string,
      /**
       * An optional map/JSON object with initial property values, aggregated objects etc. for the new tool instance.
       */
      mSettings?: $CreateEllipseToolSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vk.tools.CreateEllipseTool with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.vk.tools.Tool.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, CreateEllipseTool>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.tools.CreateEllipseTool.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:completed completed} event of this `sap.ui.vk.tools.CreateEllipseTool`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.tools.CreateEllipseTool` itself.
     *
     * Fired when a new element is created.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachCompleted(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: CreateEllipseTool$CompletedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.tools.CreateEllipseTool` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:completed completed} event of this `sap.ui.vk.tools.CreateEllipseTool`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.tools.CreateEllipseTool` itself.
     *
     * Fired when a new element is created.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachCompleted(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: CreateEllipseTool$CompletedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.tools.CreateEllipseTool` itself
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:completed completed} event of this `sap.ui.vk.tools.CreateEllipseTool`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachCompleted(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: CreateEllipseTool$CompletedEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:completed completed} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireCompleted(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: CreateEllipseTool$CompletedEventParameters
    ): this;
    /**
     * Gets current value of property {@link #getParentNode parentNode}.
     *
     * Parent node for new elements.
     *
     *
     * @returns Value of property `parentNode`
     */
    getParentNode(): any;
    /**
     * Gets current value of property {@link #getUniformMode uniformMode}.
     *
     * Indicates that the tool creates a circle instead of an ellipse.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `uniformMode`
     */
    getUniformMode(): boolean;
    /**
     * MOVE TO BASE Queues a command for execution during the rendering cycle. All gesture operations should
     * be called using this method.
     *
     *
     * @returns `this` to allow method chaining.
     */
    queueCommand(
      /**
       * The command to be executed.
       */
      command: Function
    ): this;
    /**
     * Sets a new value for property {@link #getParentNode parentNode}.
     *
     * Parent node for new elements.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setParentNode(
      /**
       * New value for property `parentNode`
       */
      oParentNode?: any
    ): this;
    /**
     * Sets a new value for property {@link #getUniformMode uniformMode}.
     *
     * Indicates that the tool creates a circle instead of an ellipse.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setUniformMode(
      /**
       * New value for property `uniformMode`
       */
      bUniformMode?: boolean
    ): this;
  }
  /**
   * Describes the settings that can be provided to the CreateEllipseTool constructor.
   */
  export interface $CreateEllipseToolSettings extends $ToolSettings {
    /**
     * Parent node for new elements.
     */
    parentNode?: any | PropertyBindingInfo | `{${string}}`;

    /**
     * Indicates that the tool creates a circle instead of an ellipse.
     */
    uniformMode?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Fired when a new element is created.
     */
    completed?: (oEvent: CreateEllipseTool$CompletedEvent) => void;
  }

  /**
   * Parameters of the CreateEllipseTool#completed event.
   */
  export interface CreateEllipseTool$CompletedEventParameters {
    /**
     * Created node.
     *
     * node.sid - node's sid node.nodeContentType - node content type node.materialId - assigned material sid
     * node.name - node's name node.matrix - node transformation matrix node.parametric - index of created parametric
     * object in parametrics array
     */
    node?: any;

    /**
     * Request payload for a storage server to create a parametric primitive.
     */
    request?: any;
  }

  /**
   * Event object of the CreateEllipseTool#completed event.
   */
  export type CreateEllipseTool$CompletedEvent = Event<
    CreateEllipseTool$CompletedEventParameters,
    CreateEllipseTool
  >;
}

declare module "sap/ui/vk/tools/CreatePathTool" {
  import { default as Tool, $ToolSettings } from "sap/ui/vk/tools/Tool";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  import Event from "sap/ui/base/Event";

  /**
   * The CreatePathTool allows applications to create a path svg element.
   */
  export default class CreatePathTool extends Tool {
    /**
     * Constructor for a new CreatePathTool.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * An optional map/JSON object with initial property values, aggregated objects etc. for the new tool instance.
       */
      mSettings?: $CreatePathToolSettings
    );
    /**
     * Constructor for a new CreatePathTool.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID of the new tool instance. `sId`is generated automatically if no non-empty ID is given. Note: this
       * can be omitted, regardless of whether `mSettings` will be provided or not.
       */
      sId?: string,
      /**
       * An optional map/JSON object with initial property values, aggregated objects etc. for the new tool instance.
       */
      mSettings?: $CreatePathToolSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vk.tools.CreatePathTool with name `sClassName` and enriches it
     * with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.vk.tools.Tool.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, CreatePathTool>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.tools.CreatePathTool.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:completed completed} event of this `sap.ui.vk.tools.CreatePathTool`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.tools.CreatePathTool` itself.
     *
     * Fired when a new element is created.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachCompleted(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: CreatePathTool$CompletedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.tools.CreatePathTool` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:completed completed} event of this `sap.ui.vk.tools.CreatePathTool`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.tools.CreatePathTool` itself.
     *
     * Fired when a new element is created.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachCompleted(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: CreatePathTool$CompletedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.tools.CreatePathTool` itself
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:completed completed} event of this `sap.ui.vk.tools.CreatePathTool`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachCompleted(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: CreatePathTool$CompletedEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:completed completed} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireCompleted(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: CreatePathTool$CompletedEventParameters
    ): this;
    /**
     * Gets current value of property {@link #getClosePath closePath}.
     *
     * Flag to always create closed path elements.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `closePath`
     */
    getClosePath(): boolean;
    /**
     * Gets current value of property {@link #getParentNode parentNode}.
     *
     * Parent node for new elements.
     *
     *
     * @returns Value of property `parentNode`
     */
    getParentNode(): any;
    /**
     * MOVE TO BASE Queues a command for execution during the rendering cycle. All gesture operations should
     * be called using this method.
     *
     *
     * @returns `this` to allow method chaining.
     */
    queueCommand(
      /**
       * The command to be executed.
       */
      command: Function
    ): this;
    /**
     * Sets a new value for property {@link #getClosePath closePath}.
     *
     * Flag to always create closed path elements.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setClosePath(
      /**
       * New value for property `closePath`
       */
      bClosePath?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getParentNode parentNode}.
     *
     * Parent node for new elements.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setParentNode(
      /**
       * New value for property `parentNode`
       */
      oParentNode?: any
    ): this;
  }
  /**
   * Describes the settings that can be provided to the CreatePathTool constructor.
   */
  export interface $CreatePathToolSettings extends $ToolSettings {
    /**
     * Parent node for new elements.
     */
    parentNode?: any | PropertyBindingInfo | `{${string}}`;

    /**
     * Flag to always create closed path elements.
     */
    closePath?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Fired when a new element is created.
     */
    completed?: (oEvent: CreatePathTool$CompletedEvent) => void;
  }

  /**
   * Parameters of the CreatePathTool#completed event.
   */
  export interface CreatePathTool$CompletedEventParameters {
    /**
     * Created node.
     *
     * node.sid - node's sid node.nodeContentType - node content type node.materialId - assigned material sid
     * node.name - node's name node.matrix - node transformation matrix node.parametric - index of created parametric
     * object in parametrics array
     */
    node?: any;

    /**
     * Request payload for a storage server to create a parametric primitive.
     */
    request?: any;

    /**
     * Indicates whether the created path is closed.
     */
    closed?: boolean;
  }

  /**
   * Event object of the CreatePathTool#completed event.
   */
  export type CreatePathTool$CompletedEvent = Event<
    CreatePathTool$CompletedEventParameters,
    CreatePathTool
  >;
}

declare module "sap/ui/vk/tools/CreateRectangleTool" {
  import { default as Tool, $ToolSettings } from "sap/ui/vk/tools/Tool";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  import Event from "sap/ui/base/Event";

  /**
   * The CreateRectangleTool allows applications to create a rectangle/square svg element.
   */
  export default class CreateRectangleTool extends Tool {
    /**
     * Constructor for a new CreateRectangleTool.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * An optional map/JSON object with initial property values, aggregated objects etc. for the new tool instance.
       */
      mSettings?: $CreateRectangleToolSettings
    );
    /**
     * Constructor for a new CreateRectangleTool.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID of the new tool instance. `sId`is generated automatically if no non-empty ID is given. Note: this
       * can be omitted, regardless of whether `mSettings` will be provided or not.
       */
      sId?: string,
      /**
       * An optional map/JSON object with initial property values, aggregated objects etc. for the new tool instance.
       */
      mSettings?: $CreateRectangleToolSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vk.tools.CreateRectangleTool with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.vk.tools.Tool.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, CreateRectangleTool>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.tools.CreateRectangleTool.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:completed completed} event of this `sap.ui.vk.tools.CreateRectangleTool`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.tools.CreateRectangleTool` itself.
     *
     * Fired when a new element is created.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachCompleted(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: CreateRectangleTool$CompletedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.tools.CreateRectangleTool`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:completed completed} event of this `sap.ui.vk.tools.CreateRectangleTool`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.tools.CreateRectangleTool` itself.
     *
     * Fired when a new element is created.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachCompleted(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: CreateRectangleTool$CompletedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.tools.CreateRectangleTool`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:completed completed} event of this `sap.ui.vk.tools.CreateRectangleTool`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachCompleted(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: CreateRectangleTool$CompletedEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:completed completed} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireCompleted(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: CreateRectangleTool$CompletedEventParameters
    ): this;
    /**
     * Gets current value of property {@link #getParentNode parentNode}.
     *
     * Parent node for the rectangle that will be created.
     *
     *
     * @returns Value of property `parentNode`
     */
    getParentNode(): any;
    /**
     * Gets current value of property {@link #getUniformMode uniformMode}.
     *
     * Indicates that the tool creates a square instead of a rectangle.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `uniformMode`
     */
    getUniformMode(): boolean;
    /**
     * MOVE TO BASE Queues a command for execution during the rendering cycle. All gesture operations should
     * be called using this method.
     *
     *
     * @returns `this` to allow method chaining.
     */
    queueCommand(
      /**
       * The command to be executed.
       */
      command: Function
    ): this;
    /**
     * Sets a new value for property {@link #getParentNode parentNode}.
     *
     * Parent node for the rectangle that will be created.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setParentNode(
      /**
       * New value for property `parentNode`
       */
      oParentNode?: any
    ): this;
    /**
     * Sets a new value for property {@link #getUniformMode uniformMode}.
     *
     * Indicates that the tool creates a square instead of a rectangle.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setUniformMode(
      /**
       * New value for property `uniformMode`
       */
      bUniformMode?: boolean
    ): this;
  }
  /**
   * Describes the settings that can be provided to the CreateRectangleTool constructor.
   */
  export interface $CreateRectangleToolSettings extends $ToolSettings {
    /**
     * Parent node for the rectangle that will be created.
     */
    parentNode?: any | PropertyBindingInfo | `{${string}}`;

    /**
     * Indicates that the tool creates a square instead of a rectangle.
     */
    uniformMode?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Fired when a new element is created.
     */
    completed?: (oEvent: CreateRectangleTool$CompletedEvent) => void;
  }

  /**
   * Parameters of the CreateRectangleTool#completed event.
   */
  export interface CreateRectangleTool$CompletedEventParameters {
    /**
     * Created node.
     *
     * node.sid - node's sid node.nodeContentType - node content type node.materialId - assigned material sid
     * node.name - node's name node.matrix - node transformation matrix node.parametric - index of created parametric
     * object in parametrics array
     */
    node?: any;

    /**
     * Request payload for a storage server to create a parametric primitive.
     */
    request?: any;
  }

  /**
   * Event object of the CreateRectangleTool#completed event.
   */
  export type CreateRectangleTool$CompletedEvent = Event<
    CreateRectangleTool$CompletedEventParameters,
    CreateRectangleTool
  >;
}

declare module "sap/ui/vk/tools/CreateTextTool" {
  import { default as Tool, $ToolSettings } from "sap/ui/vk/tools/Tool";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  import Event from "sap/ui/base/Event";

  /**
   * The CreateTextTool allows applications to create a text svg element.
   */
  export default class CreateTextTool extends Tool {
    /**
     * Constructor for a new CreateTextTool.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * An optional map/JSON object with initial property values, aggregated objects etc. for the new tool instance.
       */
      mSettings?: $CreateTextToolSettings
    );
    /**
     * Constructor for a new CreateTextTool.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID of the new tool instance. `sId`is generated automatically if no non-empty ID is given. Note: this
       * can be omitted, regardless of whether `mSettings` will be provided or not.
       */
      sId?: string,
      /**
       * An optional map/JSON object with initial property values, aggregated objects etc. for the new tool instance.
       */
      mSettings?: $CreateTextToolSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vk.tools.CreateTextTool with name `sClassName` and enriches it
     * with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.vk.tools.Tool.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, CreateTextTool>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.tools.CreateTextTool.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:completed completed} event of this `sap.ui.vk.tools.CreateTextTool`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.tools.CreateTextTool` itself.
     *
     * Fired when a new element is created.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachCompleted(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: CreateTextTool$CompletedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.tools.CreateTextTool` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:completed completed} event of this `sap.ui.vk.tools.CreateTextTool`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.tools.CreateTextTool` itself.
     *
     * Fired when a new element is created.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachCompleted(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: CreateTextTool$CompletedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.tools.CreateTextTool` itself
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:completed completed} event of this `sap.ui.vk.tools.CreateTextTool`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachCompleted(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: CreateTextTool$CompletedEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:completed completed} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireCompleted(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: CreateTextTool$CompletedEventParameters
    ): this;
    /**
     * Gets current value of property {@link #getFontFace fontFace}.
     *
     * Font face
     *
     * Default value is `"Verdana,Arial,Helvetica,sans-serif"`.
     *
     *
     * @returns Value of property `fontFace`
     */
    getFontFace(): string;
    /**
     * Gets current value of property {@link #getFontSize fontSize}.
     *
     * Font size
     *
     * Default value is `"14"`.
     *
     *
     * @returns Value of property `fontSize`
     */
    getFontSize(): string;
    /**
     * Gets current value of property {@link #getParentNode parentNode}.
     *
     * Parent node for new elements.
     *
     *
     * @returns Value of property `parentNode`
     */
    getParentNode(): any;
    /**
     * MOVE TO BASE Queues a command for execution during the rendering cycle. All gesture operations should
     * be called using this method.
     *
     *
     * @returns `this` to allow method chaining.
     */
    queueCommand(
      /**
       * The command to be executed.
       */
      command: Function
    ): this;
    /**
     * Sets a new value for property {@link #getFontFace fontFace}.
     *
     * Font face
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"Verdana,Arial,Helvetica,sans-serif"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFontFace(
      /**
       * New value for property `fontFace`
       */
      sFontFace?: string
    ): this;
    /**
     * Sets a new value for property {@link #getFontSize fontSize}.
     *
     * Font size
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"14"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFontSize(
      /**
       * New value for property `fontSize`
       */
      sFontSize?: string
    ): this;
    /**
     * Sets a new value for property {@link #getParentNode parentNode}.
     *
     * Parent node for new elements.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setParentNode(
      /**
       * New value for property `parentNode`
       */
      oParentNode?: any
    ): this;
  }
  /**
   * Describes the settings that can be provided to the CreateTextTool constructor.
   */
  export interface $CreateTextToolSettings extends $ToolSettings {
    /**
     * Parent node for new elements.
     */
    parentNode?: any | PropertyBindingInfo | `{${string}}`;

    /**
     * Font size
     */
    fontSize?: string | PropertyBindingInfo;

    /**
     * Font face
     */
    fontFace?: string | PropertyBindingInfo;

    /**
     * Fired when a new element is created.
     */
    completed?: (oEvent: CreateTextTool$CompletedEvent) => void;
  }

  /**
   * Parameters of the CreateTextTool#completed event.
   */
  export interface CreateTextTool$CompletedEventParameters {
    /**
     * Created node.
     *
     * node.sid - node's sid node.nodeContentType - node content type node.materialId - assigned material sid
     * node.name - node's name node.matrix - node transformation matrix node.parametric - index of created parametric
     * object in parametrics array
     */
    node?: any;

    /**
     * Request payload for a storage server to create a parametric primitive.
     */
    request?: any;
  }

  /**
   * Event object of the CreateTextTool#completed event.
   */
  export type CreateTextTool$CompletedEvent = Event<
    CreateTextTool$CompletedEventParameters,
    CreateTextTool
  >;
}

declare module "sap/ui/vk/tools/CrossSectionTool" {
  import { default as Tool, $ToolSettings } from "sap/ui/vk/tools/Tool";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import Viewport from "sap/ui/vk/Viewport";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * The CrossSection tool can be used to cut all 3D objects along one of three spatial axis to expose their
   * internal structures.
   */
  export default class CrossSectionTool extends Tool {
    /**
     * Constructor for a new CrossSectionTool.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * An optional map/JSON object with initial property values, aggregated objects etc. for the new tool instance.
       */
      mSettings?: $CrossSectionToolSettings
    );
    /**
     * Constructor for a new CrossSectionTool.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID of the new tool instance. `sId`is generated automatically if no non-empty ID is given. Note: this
       * can be omitted, regardless of whether `mSettings` will be provided or not.
       */
      sId?: string,
      /**
       * An optional map/JSON object with initial property values, aggregated objects etc. for the new tool instance.
       */
      mSettings?: $CrossSectionToolSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vk.tools.CrossSectionTool with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.vk.tools.Tool.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, CrossSectionTool>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.tools.CrossSectionTool.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getShowEditingUI showEditingUI}.
     *
     * Display text box with current value, which can also be used to directly modify the value
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `showEditingUI`
     */
    getShowEditingUI(): boolean;
    /**
     * MOVE TO BASE Queues a command for execution during the rendering cycle. All gesture operations should
     * be called using this method.
     *
     *
     * @returns this
     */
    queueCommand(
      /**
       * The command to be executed.
       */
      command: Function
    ): Viewport;
    /**
     * Sets the clipping plane axis.
     *
     *
     * @returns `this` to allow method chaining.
     */
    setAxis(
      /**
       * Axis index from 0 to 2: 0 - X, 1 - Y, 2 - Z.
       */
      index?: number
    ): this;
    /**
     * Flips the clipping plane.
     *
     *
     * @returns `this` to allow method chaining.
     */
    setFlip(
      /**
       * If set to `true`, the clipping plane will be flipped.
       */
      flip?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowEditingUI showEditingUI}.
     *
     * Display text box with current value, which can also be used to directly modify the value
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowEditingUI(
      /**
       * New value for property `showEditingUI`
       */
      bShowEditingUI?: boolean
    ): this;
  }
  /**
   * Describes the settings that can be provided to the CrossSectionTool constructor.
   */
  export interface $CrossSectionToolSettings extends $ToolSettings {
    /**
     * Display text box with current value, which can also be used to directly modify the value
     */
    showEditingUI?: boolean | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/ui/vk/tools/DuplicateSvgElementTool" {
  import { default as Tool, $ToolSettings } from "sap/ui/vk/tools/Tool";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  import Event from "sap/ui/base/Event";

  /**
   * The DuplicateSvgElementTool allows applications to duplicate svg elements.
   */
  export default class DuplicateSvgElementTool extends Tool {
    /**
     * Constructor for a new DuplicateSvgElementTool.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * An optional map/JSON object with initial property values, aggregated objects etc. for the new tool instance.
       */
      mSettings?: $DuplicateSvgElementToolSettings
    );
    /**
     * Constructor for a new DuplicateSvgElementTool.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID of the new tool instance. `sId`is generated automatically if no non-empty ID is given. Note: this
       * can be omitted, regardless of whether `mSettings` will be provided or not.
       */
      sId?: string,
      /**
       * An optional map/JSON object with initial property values, aggregated objects etc. for the new tool instance.
       */
      mSettings?: $DuplicateSvgElementToolSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vk.tools.DuplicateSvgElementTool with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.vk.tools.Tool.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, DuplicateSvgElementTool>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.tools.DuplicateSvgElementTool.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:nodesCreated nodesCreated} event of this `sap.ui.vk.tools.DuplicateSvgElementTool`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.tools.DuplicateSvgElementTool` itself.
     *
     * Fired when the duplicated nodes are created.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachNodesCreated(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: DuplicateSvgElementTool$NodesCreatedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.tools.DuplicateSvgElementTool`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:nodesCreated nodesCreated} event of this `sap.ui.vk.tools.DuplicateSvgElementTool`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.tools.DuplicateSvgElementTool` itself.
     *
     * Fired when the duplicated nodes are created.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachNodesCreated(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: DuplicateSvgElementTool$NodesCreatedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.tools.DuplicateSvgElementTool`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:nodesCreated nodesCreated} event of this `sap.ui.vk.tools.DuplicateSvgElementTool`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachNodesCreated(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: DuplicateSvgElementTool$NodesCreatedEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:nodesCreated nodesCreated} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireNodesCreated(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: DuplicateSvgElementTool$NodesCreatedEventParameters
    ): this;
    /**
     * Gets current value of property {@link #getNodeList nodeList}.
     *
     * Defines a list of nodes to be duplicated.
     *
     * Default value is `[]`.
     *
     *
     * @returns Value of property `nodeList`
     */
    getNodeList(): any[];
    /**
     * Gets current value of property {@link #getParentNode parentNode}.
     *
     * Parent node for new elements.
     *
     *
     * @returns Value of property `parentNode`
     */
    getParentNode(): any;
    /**
     * MOVE TO BASE Queues a command for execution during the rendering cycle. All gesture operations should
     * be called using this method.
     *
     *
     * @returns `this` to allow method chaining.
     */
    queueCommand(
      /**
       * The command to be executed.
       */
      command: Function
    ): this;
    /**
     * Sets a new value for property {@link #getNodeList nodeList}.
     *
     * Defines a list of nodes to be duplicated.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `[]`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setNodeList(
      /**
       * New value for property `nodeList`
       */
      sNodeList?: any[]
    ): this;
    /**
     * Sets a new value for property {@link #getParentNode parentNode}.
     *
     * Parent node for new elements.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setParentNode(
      /**
       * New value for property `parentNode`
       */
      oParentNode?: any
    ): this;
  }
  /**
   * Describes the settings that can be provided to the DuplicateSvgElementTool constructor.
   */
  export interface $DuplicateSvgElementToolSettings extends $ToolSettings {
    /**
     * Parent node for new elements.
     */
    parentNode?: any | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines a list of nodes to be duplicated.
     */
    nodeList?: any[] | PropertyBindingInfo | `{${string}}`;

    /**
     * Fired when the duplicated nodes are created.
     */
    nodesCreated?: (oEvent: DuplicateSvgElementTool$NodesCreatedEvent) => void;
  }

  /**
   * Parameters of the DuplicateSvgElementTool#nodesCreated event.
   */
  export interface DuplicateSvgElementTool$NodesCreatedEventParameters {
    /**
     * Offset in x direction
     */
    x?: float;

    /**
     * Offset in y direction
     */
    y?: float;

    /**
     * Created nodes.
     */
    nodes?: any[];

    /**
     * Request payload for a storage server to create a parametric primitive.
     */
    request?: object;
  }

  /**
   * Event object of the DuplicateSvgElementTool#nodesCreated event.
   */
  export type DuplicateSvgElementTool$NodesCreatedEvent = Event<
    DuplicateSvgElementTool$NodesCreatedEventParameters,
    DuplicateSvgElementTool
  >;
}

declare module "sap/ui/vk/tools/ExplodeAxis" {
  /**
   * Defines the explode axis type.
   */
  enum ExplodeAxis {
    X = "X",

    Y = "Y",

    Z = "Z",
  }
  export default ExplodeAxis;
}

declare module "sap/ui/vk/tools/ExplodeDirection" {
  /**
   * Defines the explode direction type.
   */
  enum ExplodeDirection {
    Negative = "Negative",

    Positive = "Positive",
  }
  export default ExplodeDirection;
}

declare module "sap/ui/vk/tools/ExplodeItemGroup" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import NodeProxy from "sap/ui/vk/NodeProxy";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  /**
   * Aggregation element for the output settings of the Viewport
   *
   * @experimental As of version 1.82.0. This method is experimental and might be modified or removed in future
   * versions
   */
  export default class ExplodeItemGroup extends UI5Element {
    /**
     * Constructor for a new ExplodeItemGroup.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $ExplodeItemGroupSettings
    );
    /**
     * Constructor for a new ExplodeItemGroup.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $ExplodeItemGroupSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vk.tools.ExplodeItemGroup with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ExplodeItemGroup>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.tools.ExplodeItemGroup.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some item to the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addItem(
      /**
       * The item to add; if empty, nothing is inserted
       */
      oItem: NodeProxy
    ): this;
    /**
     * Destroys all the items in the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyItems(): this;
    /**
     * Gets content of aggregation {@link #getItems items}.
     */
    getItems(): NodeProxy[];
    /**
     * Gets current value of property {@link #getMagnitudeAdjustmentMultiplier magnitudeAdjustmentMultiplier}.
     *
     * Default value is `0.0`.
     *
     *
     * @returns Value of property `magnitudeAdjustmentMultiplier`
     */
    getMagnitudeAdjustmentMultiplier(): float;
    /**
     * Gets current value of property {@link #getName name}.
     *
     *
     * @returns Value of property `name`
     */
    getName(): string;
    /**
     * Checks for the provided `sap.ui.vk.NodeProxy` in the aggregation {@link #getItems items}. and returns
     * its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfItem(
      /**
       * The item whose index is looked for
       */
      oItem: NodeProxy
    ): int;
    /**
     * Inserts a item into the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertItem(
      /**
       * The item to insert; if empty, nothing is inserted
       */
      oItem: NodeProxy,
      /**
       * The `0`-based index the item should be inserted at; for a negative value of `iIndex`, the item is inserted
       * at position 0; for a value greater than the current size of the aggregation, the item is inserted at
       * the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getItems items}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllItems(): NodeProxy[];
    /**
     * Removes a item from the aggregation {@link #getItems items}.
     *
     *
     * @returns The removed item or `null`
     */
    removeItem(
      /**
       * The item to remove or its index or id
       */
      vItem: int | string | NodeProxy
    ): NodeProxy | null;
    /**
     * Sets a new value for property {@link #getMagnitudeAdjustmentMultiplier magnitudeAdjustmentMultiplier}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `0.0`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMagnitudeAdjustmentMultiplier(
      /**
       * New value for property `magnitudeAdjustmentMultiplier`
       */
      fMagnitudeAdjustmentMultiplier?: float
    ): this;
    /**
     * Sets a new value for property {@link #getName name}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setName(
      /**
       * New value for property `name`
       */
      sName: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the ExplodeItemGroup constructor.
   *
   * @experimental As of version 1.82.0. This method is experimental and might be modified or removed in future
   * versions
   */
  export interface $ExplodeItemGroupSettings extends $ElementSettings {
    name?: string | PropertyBindingInfo;

    magnitudeAdjustmentMultiplier?: float | PropertyBindingInfo | `{${string}}`;

    items?: NodeProxy[] | NodeProxy | AggregationBindingInfo | `{${string}}`;
  }
}

declare module "sap/ui/vk/tools/ExplodeTool" {
  import { default as Tool, $ToolSettings } from "sap/ui/vk/tools/Tool";

  import ExplodeItemGroup from "sap/ui/vk/tools/ExplodeItemGroup";

  import ExplodeAxis from "sap/ui/vk/tools/ExplodeAxis";

  import ExplodeDirection from "sap/ui/vk/tools/ExplodeDirection";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { ID } from "sap/ui/core/library";

  import ExplodeType from "sap/ui/vk/tools/ExplodeType";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  import Event from "sap/ui/base/Event";

  /**
   * Tool used to move objects in 3D space
   */
  export default class ExplodeTool extends Tool {
    /**
     * Constructor for a new ExplodeTool.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * An optional map/JSON object with initial property values, aggregated objects etc. for the new tool instance.
       */
      mSettings?: $ExplodeToolSettings
    );
    /**
     * Constructor for a new ExplodeTool.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID of the new tool instance. `sId`is generated automatically if no non-empty ID is given. Note: this
       * can be omitted, regardless of whether `mSettings` will be provided or not.
       */
      sId?: string,
      /**
       * An optional map/JSON object with initial property values, aggregated objects etc. for the new tool instance.
       */
      mSettings?: $ExplodeToolSettings
    );

    /**
     * Creates a new subclass of class sap.ui.vk.tools.ExplodeTool with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.vk.tools.Tool.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ExplodeTool>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.vk.tools.ExplodeTool.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some item to the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addItem(
      /**
       * The item to add; if empty, nothing is inserted
       */
      oItem: ExplodeItemGroup
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:axisSelected axisSelected} event of this `sap.ui.vk.tools.ExplodeTool`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.tools.ExplodeTool` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachAxisSelected(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ExplodeTool$AxisSelectedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.tools.ExplodeTool` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:axisSelected axisSelected} event of this `sap.ui.vk.tools.ExplodeTool`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.tools.ExplodeTool` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachAxisSelected(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ExplodeTool$AxisSelectedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.tools.ExplodeTool` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:itemPositionAdjusted itemPositionAdjusted} event
     * of this `sap.ui.vk.tools.ExplodeTool`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.tools.ExplodeTool` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachItemPositionAdjusted(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ExplodeTool$ItemPositionAdjustedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.tools.ExplodeTool` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:itemPositionAdjusted itemPositionAdjusted} event
     * of this `sap.ui.vk.tools.ExplodeTool`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.tools.ExplodeTool` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachItemPositionAdjusted(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ExplodeTool$ItemPositionAdjustedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.tools.ExplodeTool` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:itemPositionAdjusting itemPositionAdjusting }
     * event of this `sap.ui.vk.tools.ExplodeTool`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.tools.ExplodeTool` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachItemPositionAdjusting(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ExplodeTool$ItemPositionAdjustingEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.tools.ExplodeTool` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:itemPositionAdjusting itemPositionAdjusting }
     * event of this `sap.ui.vk.tools.ExplodeTool`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.tools.ExplodeTool` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachItemPositionAdjusting(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ExplodeTool$ItemPositionAdjustingEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.tools.ExplodeTool` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:itemSequenceChangePressed itemSequenceChangePressed }
     * event of this `sap.ui.vk.tools.ExplodeTool`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.tools.ExplodeTool` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachItemSequenceChangePressed(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ExplodeTool$ItemSequenceChangePressedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.tools.ExplodeTool` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:itemSequenceChangePressed itemSequenceChangePressed }
     * event of this `sap.ui.vk.tools.ExplodeTool`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.tools.ExplodeTool` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachItemSequenceChangePressed(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ExplodeTool$ItemSequenceChangePressedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.tools.ExplodeTool` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:magnitudeChanged magnitudeChanged} event of
     * this `sap.ui.vk.tools.ExplodeTool`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.tools.ExplodeTool` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachMagnitudeChanged(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ExplodeTool$MagnitudeChangedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.tools.ExplodeTool` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:magnitudeChanged magnitudeChanged} event of
     * this `sap.ui.vk.tools.ExplodeTool`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.tools.ExplodeTool` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachMagnitudeChanged(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ExplodeTool$MagnitudeChangedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.tools.ExplodeTool` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:magnitudeChanging magnitudeChanging} event of
     * this `sap.ui.vk.tools.ExplodeTool`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.tools.ExplodeTool` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachMagnitudeChanging(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ExplodeTool$MagnitudeChangingEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.tools.ExplodeTool` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:magnitudeChanging magnitudeChanging} event of
     * this `sap.ui.vk.tools.ExplodeTool`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.vk.tools.ExplodeTool` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachMagnitudeChanging(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ExplodeTool$MagnitudeChangingEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.vk.tools.ExplodeTool` itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys all the items in the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyItems(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:axisSelected axisSelected} event of this `