export { lintRule } from "./lib/index.js";
export type Label = import("./lib/index.js").Label;
export type Meta = import("./lib/index.js").Meta;
export type Severity = import("./lib/index.js").Severity;
/**
 * Callback passed to rules.
 *
 * If the signature of a rule accepts a fourth argument,
 * the rule may perform asynchronous operations,
 * and must call it.
 */
export type Next = (error?: Error | undefined) => undefined;
/**
 * Rule.
 */
export type Rule<Tree extends Node = Node, Option extends unknown = unknown> = (tree: Tree, file: VFile, option: Option, next: Next) => Promise<undefined | void> | undefined | void;
export type Plugin<Tree extends Node = Node, Option extends unknown = unknown> = (config?: [level: Label | Severity | boolean, option?: Option] | Label | Option | Severity) => ((tree: Tree, file: VFile, next: TransformCallback<Tree>) => undefined) | undefined;
import type { Node } from 'unist';
import type { VFile } from 'vfile';
import type { TransformCallback } from 'unified';
//# sourceMappingURL=index.d.ts.map