/*
 * Copyright 2021 the original author or authors.
 * <p>
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * <p>
 * https://www.apache.org/licenses/LICENSE-2.0
 * <p>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.openrewrite.java.dependencies;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import lombok.EqualsAndHashCode;
import lombok.Value;

import java.time.ZonedDateTime;

@Value
@EqualsAndHashCode(onlyExplicitlyIncluded = true)
@JsonPropertyOrder({"cve", "publishedAt", "summary", "groupArtifact", "introducedVersion", "fixedVersion", "severity", "cwes"})
public class Vulnerability {
    @EqualsAndHashCode.Include
    String cve;

    ZonedDateTime publishedAt;
    String summary;
    String groupArtifact;
    @EqualsAndHashCode.Include
    String introducedVersion;
    String fixedVersion;
    Severity severity;
    /**
     * Common Weakness Enumerations are semicolon separated.
     */
    String cwes;

    public enum Severity {
        LOW,
        MODERATE,
        HIGH,
        CRITICAL
    }
}
