/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.guava;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public final class PreferJavaUtilOptionalOrSupplier
extends Recipe {
    static final MethodMatcher METHOD_MATCHER = new MethodMatcher("com.google.common.base.Optional or(com.google.common.base.Optional)");

    public String getDisplayName() {
        return "Prefer `java.util.Optional#or(Supplier<T extends java.util.Optional<T>>)`";
    }

    public String getDescription() {
        return "Prefer `java.util.Optional#or(Supplier<T extends java.util.Optional<T>>)` over `com.google.common.base.Optional#or(com.google.common.base.Optional).";
    }

    public Set<String> getTags() {
        return new HashSet<String>(Arrays.asList("RSPEC-S4738", "guava"));
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesJavaVersion(9), new UsesMethod(METHOD_MATCHER)}), (TreeVisitor)new PreferJavaUtilOptionalOrSupplierVisitor());
    }

    @NonNull
    public String toString() {
        return "PreferJavaUtilOptionalOrSupplier()";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PreferJavaUtilOptionalOrSupplier)) {
            return false;
        }
        PreferJavaUtilOptionalOrSupplier other = (PreferJavaUtilOptionalOrSupplier)((Object)o);
        return other.canEqual((Object)this);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof PreferJavaUtilOptionalOrSupplier;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    private static class PreferJavaUtilOptionalOrSupplierVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private PreferJavaUtilOptionalOrSupplierVisitor() {
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)ctx);
            if (METHOD_MATCHER.matches((MethodCall)method)) {
                mi = (J.MethodInvocation)JavaTemplate.builder((String)"#{any(java.util.Optional)}.or(() -> #{any(java.util.Optional)})").contextSensitive().imports(new String[]{"java.util.Optional"}).build().apply(this.updateCursor((Tree)mi), method.getCoordinates().replace(), new Object[]{mi.getSelect(), mi.getArguments().get(0)});
                this.maybeAddImport("java.util.Optional");
                this.maybeRemoveImport("com.google.common.base.Optional");
            }
            return mi;
        }
    }
}

