/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.openapi.swagger;

import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

public class ConvertApiResponseCodesToStrings
extends Recipe {
    private static final AnnotationMatcher ANNOTATION_MATCHER = new AnnotationMatcher("@io.swagger.v3.oas.annotations.responses.ApiResponse");

    public String getDisplayName() {
        return "Convert API response codes to strings";
    }

    public String getDescription() {
        return "Convert API response codes to strings.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType("io.swagger.v3.oas.annotations.responses.ApiResponse", Boolean.valueOf(true)), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.Annotation visitAnnotation(J.Annotation annotation, ExecutionContext ctx) {
                J.Annotation an = super.visitAnnotation(annotation, (Object)ctx);
                if (ANNOTATION_MATCHER.matches(an)) {
                    return an.withArguments(ListUtils.map((List)an.getArguments(), this::maybeReplaceResponseCodeTypeAndValue));
                }
                return an;
            }

            private Expression maybeReplaceResponseCodeTypeAndValue(Expression arg) {
                if (arg instanceof J.Assignment) {
                    boolean usesNumberLiteral;
                    J.Assignment assignment = (J.Assignment)arg;
                    boolean matchesField = assignment.getVariable() instanceof J.Identifier && "responseCode".equals(((J.Identifier)assignment.getVariable()).getSimpleName());
                    boolean bl = usesNumberLiteral = assignment.getAssignment() instanceof J.Literal && ((J.Literal)assignment.getAssignment()).getValue() instanceof Number;
                    if (matchesField && usesNumberLiteral) {
                        J.Literal assignedLiteral = (J.Literal)assignment.getAssignment();
                        return assignment.withType((JavaType)JavaType.Primitive.String).withAssignment((Expression)assignedLiteral.withValue((Object)String.valueOf(assignedLiteral.getValue())).withValueSource("\"" + assignedLiteral.getValue() + "\"").withType((JavaType)JavaType.Primitive.String));
                    }
                }
                return arg;
            }
        });
    }
}

