/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.service.AnnotationService;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeUtils;

public final class RemoveUnusedPrivateFields
extends Recipe {
    private static final AnnotationMatcher LOMBOK_ANNOTATION = new AnnotationMatcher("@lombok.*");

    public String getDisplayName() {
        return "Remove unused private fields";
    }

    public String getDescription() {
        return "If a private field is declared but not used in the program, it can be considered dead code and should therefore be removed.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-S1068");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)ctx);
                Iterator clz = this.getCursor().getPathAsCursors(c -> c.getValue() instanceof J.ClassDeclaration);
                if (clz.hasNext() && ((AnnotationService)this.service(AnnotationService.class)).matches((Cursor)clz.next(), LOMBOK_ANNOTATION)) {
                    return cd;
                }
                ArrayList<CheckField> checkFields = new ArrayList<CheckField>();
                boolean skipSerialVersionUID = cd.getType() == null || cd.getType().isAssignableTo("java.io.Serializable");
                List statements = cd.getBody().getStatements();
                for (int i = 0; i < statements.size(); ++i) {
                    J.MethodDeclaration md;
                    Statement statement = (Statement)statements.get(i);
                    if (statement instanceof J.VariableDeclarations) {
                        J.VariableDeclarations vd = (J.VariableDeclarations)statement;
                        if (skipSerialVersionUID && this.isSerialVersionUid(vd) || !vd.getLeadingAnnotations().isEmpty() || !vd.hasModifier(J.Modifier.Type.Private)) continue;
                        Statement nextStatement = i < statements.size() - 1 ? (Statement)statements.get(i + 1) : null;
                        checkFields.add(new CheckField(vd, nextStatement));
                        continue;
                    }
                    if (!(statement instanceof J.MethodDeclaration) || !(md = (J.MethodDeclaration)statement).hasModifier(J.Modifier.Type.Native)) continue;
                    return cd;
                }
                if (checkFields.isEmpty()) {
                    return cd;
                }
                J.ClassDeclaration outer = cd;
                for (Cursor parent = this.getCursor().getParent(); parent != null; parent = parent.getParent()) {
                    if (!(parent.getValue() instanceof J.ClassDeclaration)) continue;
                    outer = (J.ClassDeclaration)parent.getValue();
                }
                for (CheckField checkField : checkFields) {
                    Map<J.VariableDeclarations.NamedVariable, List<J.Identifier>> inUse = VariableUses.find(checkField.declarations, outer);
                    for (Map.Entry<J.VariableDeclarations.NamedVariable, List<J.Identifier>> entry : inUse.entrySet()) {
                        if (!entry.getValue().isEmpty()) continue;
                        AtomicBoolean declarationDeleted = new AtomicBoolean();
                        J.VariableDeclarations.NamedVariable fieldToRemove = entry.getKey();
                        cd = (J.ClassDeclaration)new RemoveUnusedField(fieldToRemove).visitNonNull((Tree)cd, declarationDeleted);
                        if (fieldToRemove.getType() != null) {
                            this.maybeRemoveImport(fieldToRemove.getType().toString());
                        }
                        if (!declarationDeleted.get()) continue;
                        cd = (J.ClassDeclaration)new MaybeRemoveComment(checkField.nextStatement, cd).visitNonNull((Tree)cd, ctx);
                    }
                }
                return cd;
            }

            private boolean isSerialVersionUid(J.VariableDeclarations vd) {
                return vd.hasModifier(J.Modifier.Type.Private) && vd.hasModifier(J.Modifier.Type.Static) && vd.hasModifier(J.Modifier.Type.Final) && TypeUtils.isOfClassType((JavaType)vd.getType(), (String)"long") && vd.getVariables().stream().anyMatch(it -> "serialVersionUID".equals(it.getSimpleName()));
            }

            final class CheckField {
                private final J.VariableDeclarations declarations;
                private final @Nullable Statement nextStatement;

                @Generated
                public CheckField(// Could not load outer class - annotation placement on inner may be incorrect
                @Nullable J.VariableDeclarations declarations, Statement nextStatement) {
                    this.declarations = declarations;
                    this.nextStatement = nextStatement;
                }

                @Generated
                public J.VariableDeclarations getDeclarations() {
                    return this.declarations;
                }

                @Generated
                public @Nullable Statement getNextStatement() {
                    return this.nextStatement;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof CheckField)) {
                        return false;
                    }
                    CheckField other = (CheckField)o;
                    J.VariableDeclarations this$declarations = this.getDeclarations();
                    J.VariableDeclarations other$declarations = other.getDeclarations();
                    if (this$declarations == null ? other$declarations != null : !this$declarations.equals(other$declarations)) {
                        return false;
                    }
                    Statement this$nextStatement = this.getNextStatement();
                    Statement other$nextStatement = other.getNextStatement();
                    return !(this$nextStatement == null ? other$nextStatement != null : !this$nextStatement.equals(other$nextStatement));
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    J.VariableDeclarations $declarations = this.getDeclarations();
                    result = result * 59 + ($declarations == null ? 43 : $declarations.hashCode());
                    Statement $nextStatement = this.getNextStatement();
                    result = result * 59 + ($nextStatement == null ? 43 : $nextStatement.hashCode());
                    return result;
                }

                @Generated
                public String toString() {
                    return "CheckField(declarations=" + this.getDeclarations() + ", nextStatement=" + this.getNextStatement() + ")";
                }
            }
        };
    }

    @Generated
    public RemoveUnusedPrivateFields() {
    }

    @Generated
    public String toString() {
        return "RemoveUnusedPrivateFields()";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveUnusedPrivateFields)) {
            return false;
        }
        RemoveUnusedPrivateFields other = (RemoveUnusedPrivateFields)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RemoveUnusedPrivateFields;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    private static class MaybeRemoveComment
    extends JavaVisitor<ExecutionContext> {
        private final @Nullable Statement statement;
        private final J.ClassDeclaration classDeclaration;

        public MaybeRemoveComment(@Nullable Statement statement, J.ClassDeclaration classDeclaration) {
            this.statement = statement;
            this.classDeclaration = classDeclaration;
        }

        public J visitStatement(Statement s, ExecutionContext ctx) {
            Space prefix;
            if (s == this.statement && (prefix = s.getPrefix()).getComments().size() > 0 && !prefix.getWhitespace().contains("\n")) {
                return s.withPrefix(prefix.withWhitespace(((Comment)prefix.getComments().get(0)).getSuffix()).withComments(prefix.getComments().subList(1, prefix.getComments().size())));
            }
            return super.visitStatement(s, (Object)ctx);
        }

        public J visitClassDeclaration(J.ClassDeclaration c, ExecutionContext ctx) {
            Space end;
            if (this.statement == null && c == this.classDeclaration && (end = c.getBody().getEnd()).getComments().size() > 0 && !end.getWhitespace().contains("\n")) {
                return c.withBody(c.getBody().withEnd(end.withWhitespace(((Comment)end.getComments().get(0)).getSuffix()).withComments(end.getComments().subList(1, end.getComments().size()))));
            }
            return super.visitClassDeclaration(c, (Object)ctx);
        }
    }

    private static class RemoveUnusedField
    extends JavaVisitor<AtomicBoolean> {
        private final J.VariableDeclarations.NamedVariable namedVariable;

        public RemoveUnusedField(J.VariableDeclarations.NamedVariable namedVariable) {
            this.namedVariable = namedVariable;
        }

        public @Nullable J visitVariableDeclarations(J.VariableDeclarations multiVariable, AtomicBoolean declarationDeleted) {
            if (multiVariable.getVariables().size() == 1 && multiVariable.getVariables().contains(this.namedVariable)) {
                declarationDeleted.set(true);
                return null;
            }
            return super.visitVariableDeclarations(multiVariable, (Object)declarationDeleted);
        }

        public @Nullable J visitVariable(J.VariableDeclarations.NamedVariable variable, AtomicBoolean declarationDeleted) {
            if (variable == this.namedVariable) {
                return null;
            }
            return super.visitVariable(variable, (Object)declarationDeleted);
        }
    }

    private static class VariableUses {
        private VariableUses() {
        }

        public static Map<J.VariableDeclarations.NamedVariable, List<J.Identifier>> find(final J.VariableDeclarations declarations, J.ClassDeclaration parent) {
            IdentityHashMap<J.VariableDeclarations.NamedVariable, List<J.Identifier>> found = new IdentityHashMap<J.VariableDeclarations.NamedVariable, List<J.Identifier>>(declarations.getVariables().size());
            final HashMap<String, J.VariableDeclarations.NamedVariable> signatureMap = new HashMap<String, J.VariableDeclarations.NamedVariable>();
            for (J.VariableDeclarations.NamedVariable variable : declarations.getVariables()) {
                if (variable.getVariableType() == null) continue;
                found.computeIfAbsent(variable, k -> new ArrayList());
                signatureMap.put(variable.getVariableType().toString(), variable);
            }
            JavaIsoVisitor<Map<J.VariableDeclarations.NamedVariable, List<J.Identifier>>> visitor = new JavaIsoVisitor<Map<J.VariableDeclarations.NamedVariable, List<J.Identifier>>>(){

                public J.Identifier visitIdentifier(J.Identifier identifier, Map<J.VariableDeclarations.NamedVariable, List<J.Identifier>> identifiers) {
                    Cursor parent;
                    if (identifier.getFieldType() != null && signatureMap.containsKey(identifier.getFieldType().toString()) && (!((parent = this.getCursor().dropParentUntil(is -> is instanceof J.VariableDeclarations || is instanceof J.ClassDeclaration)).getValue() instanceof J.VariableDeclarations) || parent.getValue() != declarations)) {
                        J.VariableDeclarations.NamedVariable name = (J.VariableDeclarations.NamedVariable)signatureMap.get(identifier.getFieldType().toString());
                        if (declarations.getVariables().contains(name)) {
                            J.VariableDeclarations.NamedVariable used = (J.VariableDeclarations.NamedVariable)signatureMap.get(identifier.getFieldType().toString());
                            identifiers.computeIfAbsent(used, k -> new ArrayList()).add(identifier);
                        }
                    }
                    return super.visitIdentifier(identifier, identifiers);
                }
            };
            visitor.visit((Tree)parent, found);
            return found;
        }
    }
}

