/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.RenameVariable;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;

public abstract class RenameToCamelCase
extends JavaIsoVisitor<ExecutionContext> {
    @Nullable
    private Cursor sourceFileCursor;

    private Cursor getSourceFileCursor() {
        if (this.sourceFileCursor == null) {
            this.sourceFileCursor = (Cursor)this.getCursor().getPathAsCursors(c -> c.getValue() instanceof JavaSourceFile).next();
        }
        return this.sourceFileCursor;
    }

    @Nullable
    public J postVisit(J tree, ExecutionContext ctx) {
        if (tree instanceof JavaSourceFile) {
            JavaSourceFile cu = (JavaSourceFile)tree;
            Map renameVariablesMap = (Map)this.getCursor().getMessage("RENAME_VARIABLES_KEY", Collections.emptyMap());
            Set hasNameSet = (Set)this.getCursor().computeMessageIfAbsent("HAS_NAME_KEY", k -> new HashSet());
            for (Map.Entry entry : renameVariablesMap.entrySet()) {
                String toName;
                J.VariableDeclarations.NamedVariable variable = (J.VariableDeclarations.NamedVariable)entry.getKey();
                if (!this.shouldRename(hasNameSet, variable, toName = (String)entry.getValue())) continue;
                cu = (JavaSourceFile)new RenameVariable(variable, toName).visitNonNull((Tree)cu, (Object)ctx);
                hasNameSet.add(this.computeKey(toName, (J)variable));
            }
            return cu;
        }
        return (J)super.postVisit((Tree)tree, (Object)ctx);
    }

    protected abstract boolean shouldRename(Set<String> var1, J.VariableDeclarations.NamedVariable var2, String var3);

    protected void renameVariable(J.VariableDeclarations.NamedVariable variable, String toName) {
        ((LinkedHashMap)this.getSourceFileCursor().computeMessageIfAbsent("RENAME_VARIABLES_KEY", k -> new LinkedHashMap())).put(variable, toName);
    }

    protected void hasNameKey(String variableName) {
        ((HashSet)this.getSourceFileCursor().computeMessageIfAbsent("HAS_NAME_KEY", k -> new HashSet())).add(variableName);
    }

    protected String computeKey(String identifier, J context) {
        JavaType.Variable fieldType = this.getFieldType(context);
        if (fieldType != null && fieldType.getOwner() != null) {
            return fieldType.getOwner() + " " + identifier;
        }
        return identifier;
    }

    @Nullable
    protected JavaType.Variable getFieldType(J tree) {
        if (tree instanceof J.Identifier) {
            return ((J.Identifier)tree).getFieldType();
        }
        if (tree instanceof J.VariableDeclarations.NamedVariable) {
            return ((J.VariableDeclarations.NamedVariable)tree).getVariableType();
        }
        return null;
    }
}

