/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.cleanup;

import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.template.SourceTemplate;

public final class TestsShouldIncludeAssertions
extends Recipe {
    private static final List<String> TEST_ANNOTATIONS = Collections.singletonList("org.junit.jupiter.api.Test");
    private static final List<String> DEFAULT_ASSERTIONS = Arrays.asList("org.assertj.core.api", "org.junit.jupiter.api.Assertions", "org.hamcrest.MatcherAssert", "org.mockito.Mockito.verify", "org.easymock", "org.jmock", "mockit", "io.restassured", "org.springframework.test.web.servlet.ResultActions", "com.github.tomakehurst.wiremock.client.WireMock", "org.junit.Assert");
    @Option(displayName="Additional assertions", description="A comma delimited list of packages and/or classes that will be identified as assertions. I.E. a common assertion utility `org.foo.TestUtil`.", example="org.foo.TestUtil, org.bar", required=false)
    @Nullable
    private final String additionalAsserts;

    public String getDisplayName() {
        return "Include an assertion in tests";
    }

    public String getDescription() {
        return "For tests not having any assertions, wrap the statements with JUnit Jupiter's `Assertions#assertThrowDoesNotThrow(..)`.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-2699");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public Validated validate() {
        Validated validated = super.validate().and(Validated.required((String)"assertions", DEFAULT_ASSERTIONS));
        if (validated.isValid()) {
            validated = validated.and(Validated.test((String)"assertions", (String)"Assertions must not be empty and at least contain org.junit.jupiter.api.Assertions", DEFAULT_ASSERTIONS, a -> a.stream().filter("org.junit.jupiter.api.Assertions"::equals).findAny().isPresent()));
        }
        return validated;
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesType("org.junit.jupiter.api.Test");
    }

    protected TestShouldIncludeAssertionsVisitor getVisitor() {
        return new TestShouldIncludeAssertionsVisitor(this.additionalAsserts);
    }

    @ConstructorProperties(value={"additionalAsserts"})
    public TestsShouldIncludeAssertions(@Nullable String additionalAsserts) {
        this.additionalAsserts = additionalAsserts;
    }

    @Nullable
    public String getAdditionalAsserts() {
        return this.additionalAsserts;
    }

    @NonNull
    public String toString() {
        return "TestsShouldIncludeAssertions(additionalAsserts=" + this.getAdditionalAsserts() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TestsShouldIncludeAssertions)) {
            return false;
        }
        TestsShouldIncludeAssertions other = (TestsShouldIncludeAssertions)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$additionalAsserts = this.getAdditionalAsserts();
        String other$additionalAsserts = other.getAdditionalAsserts();
        return !(this$additionalAsserts == null ? other$additionalAsserts != null : !this$additionalAsserts.equals(other$additionalAsserts));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof TestsShouldIncludeAssertions;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $additionalAsserts = this.getAdditionalAsserts();
        result = result * 59 + ($additionalAsserts == null ? 43 : $additionalAsserts.hashCode());
        return result;
    }

    private static class TestShouldIncludeAssertionsVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private static final Supplier<JavaParser> ASSERTJ_JAVA_PARSER = () -> JavaParser.fromJavaVersion().classpath(new String[]{"junit-jupiter-api"}).build();
        private final Map<String, Set<J.Block>> matcherPatternToClassInvocation = new HashMap<String, Set<J.Block>>();
        private final List<String> additionalAsserts;

        TestShouldIncludeAssertionsVisitor(@Nullable String additionalAsserts) {
            ArrayList<String> assertions = new ArrayList<String>();
            if (additionalAsserts != null) {
                assertions.addAll(Arrays.asList(additionalAsserts.split(",\\s*")));
            }
            this.additionalAsserts = assertions;
        }

        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext executionContext) {
            if (!this.methodIsTest(method) || method.getBody() == null || this.methodHasAssertion(method.getBody()) || this.methodInvocationInBodyContainsAssertion()) {
                return method;
            }
            J.MethodDeclaration md = super.visitMethodDeclaration(method, (Object)executionContext);
            J.Block body = md.getBody();
            if (body != null) {
                md = (J.MethodDeclaration)method.withTemplate((SourceTemplate)JavaTemplate.builder(() -> ((TestShouldIncludeAssertionsVisitor)this).getCursor(), (String)"assertDoesNotThrow(() -> #{any()});").staticImports(new String[]{"org.junit.jupiter.api.Assertions.assertDoesNotThrow"}).javaParser(ASSERTJ_JAVA_PARSER).build(), method.getCoordinates().replaceBody(), new Object[]{body});
                this.maybeAddImport("org.junit.jupiter.api.Assertions", "assertDoesNotThrow");
            }
            return md;
        }

        private boolean methodIsTest(J.MethodDeclaration methodDeclaration) {
            for (J.Annotation leadingAnnotation : methodDeclaration.getLeadingAnnotations()) {
                for (String testAnnotation : TEST_ANNOTATIONS) {
                    if (!TypeUtils.isOfClassType((JavaType)leadingAnnotation.getType(), (String)testAnnotation)) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean methodHasAssertion(J.Block body) {
            AtomicBoolean hasAssertion = new AtomicBoolean(Boolean.FALSE);
            JavaIsoVisitor<AtomicBoolean> findAssertionVisitor = new JavaIsoVisitor<AtomicBoolean>(){

                public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, AtomicBoolean atomicBoolean) {
                    J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)atomicBoolean);
                    if (this.isAssertion(mi)) {
                        atomicBoolean.set(Boolean.TRUE);
                    }
                    return mi;
                }
            };
            findAssertionVisitor.visit((Tree)body, (Object)hasAssertion);
            return hasAssertion.get();
        }

        private boolean methodInvocationInBodyContainsAssertion() {
            final J.ClassDeclaration classDeclaration = (J.ClassDeclaration)this.getCursor().dropParentUntil(is -> is instanceof J.ClassDeclaration).getValue();
            JavaIsoVisitor<Set<MethodMatcher>> findMethodDeclarationsVisitor = new JavaIsoVisitor<Set<MethodMatcher>>(){

                public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, Set<MethodMatcher> methodMatchers) {
                    J.MethodInvocation mi = super.visitMethodInvocation(method, methodMatchers);
                    if (classDeclaration.getType() != null && mi.getMethodType() != null) {
                        JavaType.Method mType = mi.getMethodType();
                        if (classDeclaration.getType().getFullyQualifiedName().equals(mType.getDeclaringType().getFullyQualifiedName())) {
                            methodMatchers.add(new MethodMatcher(mType));
                        }
                    }
                    return mi;
                }
            };
            HashSet methodMatchers = new HashSet();
            findMethodDeclarationsVisitor.visit((Tree)classDeclaration, methodMatchers);
            HashSet methodBodies = new HashSet();
            methodMatchers.forEach(matcher -> {
                Set declarationBodies = this.matcherPatternToClassInvocation.computeIfAbsent(this.matcherPattern((MethodMatcher)matcher), k -> this.findMethodDeclarations(classDeclaration, (MethodMatcher)matcher));
                methodBodies.addAll(declarationBodies);
            });
            return methodBodies.stream().anyMatch(this::methodHasAssertion);
        }

        private String matcherPattern(MethodMatcher methodMatcher) {
            return methodMatcher.getTargetTypePattern() + " " + methodMatcher.getMethodNamePattern() + "(" + methodMatcher.getArgumentPattern() + ")";
        }

        private Set<J.Block> findMethodDeclarations(final J.ClassDeclaration classDeclaration, final MethodMatcher methodMatcher) {
            JavaIsoVisitor<Set<J.Block>> findMethodDeclarationVisitor = new JavaIsoVisitor<Set<J.Block>>(){

                public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, Set<J.Block> blocks) {
                    J.MethodDeclaration m = super.visitMethodDeclaration(method, blocks);
                    if (methodMatcher.matches(m, classDeclaration) && m.getBody() != null) {
                        blocks.add(m.getBody());
                    }
                    return m;
                }
            };
            HashSet<J.Block> blocks = new HashSet<J.Block>();
            findMethodDeclarationVisitor.visit((Tree)classDeclaration, blocks);
            return blocks;
        }

        private boolean isAssertion(J.MethodInvocation methodInvocation) {
            if (methodInvocation.getMethodType() == null) {
                return false;
            }
            String fqt = methodInvocation.getMethodType().getDeclaringType().getFullyQualifiedName();
            for (String assertionClassOrPackage : DEFAULT_ASSERTIONS) {
                if (!fqt.startsWith(assertionClassOrPackage)) continue;
                return true;
            }
            String methodFqn = methodInvocation.getMethodType().getDeclaringType().getFullyQualifiedName() + "." + methodInvocation.getSimpleName();
            for (String assertMethod : DEFAULT_ASSERTIONS) {
                if (!assertMethod.equals(methodFqn)) continue;
                return true;
            }
            if (this.additionalAsserts != null) {
                for (String assertionClassOrPackage : this.additionalAsserts) {
                    if (!fqt.startsWith(assertionClassOrPackage)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

