/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.jmockit;

import java.util.ArrayList;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.NonNullApi;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.FindAnnotations;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;

@NonNullApi
public final class JMockitMockedVariableToMockito
extends Recipe {
    public String getDisplayName() {
        return "Rewrite JMockit Mocked Variable";
    }

    public String getDescription() {
        return "Rewrites JMockit `Mocked Variable` to Mockito statements.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType("mockit.Mocked", Boolean.valueOf(false)), (TreeVisitor)new RewriteMockedVariableVisitor());
    }

    @NonNull
    public String toString() {
        return "JMockitMockedVariableToMockito()";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JMockitMockedVariableToMockito)) {
            return false;
        }
        JMockitMockedVariableToMockito other = (JMockitMockedVariableToMockito)((Object)o);
        return other.canEqual((Object)this);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof JMockitMockedVariableToMockito;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    private static class RewriteMockedVariableVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private RewriteMockedVariableVisitor() {
        }

        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration methodDeclaration, ExecutionContext ctx) {
            J.MethodDeclaration md = super.visitMethodDeclaration(methodDeclaration, (Object)ctx);
            List parameters = md.getParameters();
            if (!parameters.isEmpty() && !(parameters.get(0) instanceof J.Empty)) {
                this.maybeRemoveImport("mockit.Mocked");
                this.maybeAddImport("org.mockito.Mockito");
                ArrayList mockedParameter = new ArrayList();
                md = md.withParameters(ListUtils.map((List)parameters, parameter -> {
                    J.VariableDeclarations variableDeclarations;
                    if (parameter instanceof J.VariableDeclarations && !FindAnnotations.find((J)(variableDeclarations = (J.VariableDeclarations)parameter), (String)"mockit.Mocked").isEmpty()) {
                        mockedParameter.add(variableDeclarations);
                        return null;
                    }
                    return parameter;
                }));
                if (!mockedParameter.isEmpty()) {
                    JavaTemplate addStatementsTemplate = JavaTemplate.builder((String)"#{} #{} = Mockito.mock(#{}.class);\n").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"mockito-core-3.12"})).imports(new String[]{"org.mockito.Mockito"}).contextSensitive().build();
                    for (int i = mockedParameter.size() - 1; i >= 0; --i) {
                        J.VariableDeclarations variableDeclarations = (J.VariableDeclarations)mockedParameter.get(i);
                        md = (J.MethodDeclaration)addStatementsTemplate.apply(this.updateCursor((Tree)md), md.getBody().getCoordinates().firstStatement(), new Object[]{variableDeclarations.getTypeExpression().toString(), ((J.VariableDeclarations.NamedVariable)variableDeclarations.getVariables().get(0)).getSimpleName(), variableDeclarations.getTypeExpression().toString()});
                    }
                }
            }
            return md;
        }
    }
}

