/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.assertj;

import com.google.errorprone.refaster.Refaster;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.data.Offset;
import org.assertj.core.data.Percentage;
import org.openrewrite.java.template.RecipeDescriptor;

@RecipeDescriptor(name="Adopt AssertJ Integer Assertions", description="Adopt AssertJ Integer Assertions. Favor semantically explicit methods (e.g. `myInteger.isZero()` over `myInteger.isEqualTo(0)`).")
public class AssertJIntegerRules {

    @RecipeDescriptor(name="Replace `isEqualTo(1)` with `isOne()`", description="Replace `isEqualTo(1)` with `isOne()`.")
    static final class AbstractIntegerAssertIsOne {
        AbstractIntegerAssertIsOne() {
        }

        AbstractIntegerAssert<?> before(AbstractIntegerAssert<?> intAssert) {
            return intAssert.isEqualTo(1);
        }

        AbstractIntegerAssert<?> after(AbstractIntegerAssert<?> intAssert) {
            return intAssert.isOne();
        }
    }

    @RecipeDescriptor(name="Replace `isNotEqualTo(0)` with `isNotZero()`", description="Replace `isNotEqualTo(0)` with `isNotZero()`.")
    static final class AbstractIntegerAssertIsNotZero {
        AbstractIntegerAssertIsNotZero() {
        }

        AbstractIntegerAssert<?> before(AbstractIntegerAssert<?> intAssert) {
            return intAssert.isNotEqualTo(0);
        }

        AbstractIntegerAssert<?> after(AbstractIntegerAssert<?> intAssert) {
            return intAssert.isNotZero();
        }
    }

    @RecipeDescriptor(name="Replace `isEqualTo(0)` with `isZero()`", description="Replace `isEqualTo(0)` with `isZero()`.")
    static final class AbstractIntegerAssertIsZero {
        AbstractIntegerAssertIsZero() {
        }

        AbstractIntegerAssert<?> before(AbstractIntegerAssert<?> intAssert) {
            return intAssert.isEqualTo(0);
        }

        AbstractIntegerAssert<?> after(AbstractIntegerAssert<?> intAssert) {
            return intAssert.isZero();
        }
    }

    @RecipeDescriptor(name="Replace `isNotCloseTo` with `isNotEqualTo`", description="Replace `isNotCloseTo` with `isNotEqualTo` when `offset` or `percentage` is zero.")
    static final class AbstractIntegerAssertIsNotEqualTo {
        AbstractIntegerAssertIsNotEqualTo() {
        }

        AbstractIntegerAssert<?> before(AbstractIntegerAssert<?> intAssert, int n) {
            return (AbstractIntegerAssert)Refaster.anyOf((Object[])new AbstractIntegerAssert[]{intAssert.isNotCloseTo(n, Offset.offset((Number)0)), intAssert.isNotCloseTo(n, Percentage.withPercentage((double)0.0))});
        }

        AbstractIntegerAssert<?> after(AbstractIntegerAssert<?> intAssert, int n) {
            return intAssert.isNotEqualTo(n);
        }
    }

    @RecipeDescriptor(name="Replace `isCloseTo` with `isEqualTo`", description="Replace `isCloseTo` with `isEqualTo` when `offset` or `percentage` is zero.")
    static final class AbstractIntegerAssertIsEqualTo {
        AbstractIntegerAssertIsEqualTo() {
        }

        AbstractIntegerAssert<?> before(AbstractIntegerAssert<?> intAssert, int n) {
            return (AbstractIntegerAssert)Refaster.anyOf((Object[])new AbstractIntegerAssert[]{intAssert.isCloseTo(n, Offset.offset((Number)0)), intAssert.isCloseTo(n, Percentage.withPercentage((double)0.0))});
        }

        AbstractIntegerAssert<?> after(AbstractIntegerAssert<?> intAssert, int n) {
            return intAssert.isEqualTo(n);
        }
    }
}

