/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.assertj;

import com.google.errorprone.refaster.Refaster;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.data.Offset;
import org.assertj.core.data.Percentage;
import org.openrewrite.java.template.RecipeDescriptor;

@RecipeDescriptor(name="Adopt AssertJ Long Assertions", description="Adopt AssertJ Long Assertions. Favor semantically explicit methods (e.g. `myLong.isZero()` over `myLong.isEqualTo(0)`).")
public class AssertJLongRules {

    @RecipeDescriptor(name="Replace `isEqualTo(1)` with `isOne()`", description="Replace `isEqualTo(1)` with `isOne()`.")
    static final class AbstractLongAssertIsOne {
        AbstractLongAssertIsOne() {
        }

        AbstractLongAssert<?> before(AbstractLongAssert<?> longAssert) {
            return longAssert.isEqualTo(1L);
        }

        AbstractLongAssert<?> after(AbstractLongAssert<?> longAssert) {
            return longAssert.isOne();
        }
    }

    @RecipeDescriptor(name="Replace `isNotEqualTo(0)` with `isNotZero()`", description="Replace `isNotEqualTo(0)` with `isNotZero()`.")
    static final class AbstractLongAssertIsNotZero {
        AbstractLongAssertIsNotZero() {
        }

        AbstractLongAssert<?> before(AbstractLongAssert<?> longAssert) {
            return longAssert.isNotEqualTo(0L);
        }

        AbstractLongAssert<?> after(AbstractLongAssert<?> longAssert) {
            return longAssert.isNotZero();
        }
    }

    @RecipeDescriptor(name="Replace `isEqualTo(0)` with `isZero()`", description="Replace `isEqualTo(0)` with `isZero()`.")
    static final class AbstractLongAssertIsZero {
        AbstractLongAssertIsZero() {
        }

        AbstractLongAssert<?> before(AbstractLongAssert<?> longAssert) {
            return longAssert.isEqualTo(0L);
        }

        AbstractLongAssert<?> after(AbstractLongAssert<?> longAssert) {
            return longAssert.isZero();
        }
    }

    @RecipeDescriptor(name="Replace `isNotCloseTo` with `isNotEqualTo`", description="Replace `isNotCloseTo` with `isNotEqualTo` when `offset` or `percentage` is zero.")
    static final class AbstractLongAssertIsNotEqualTo {
        AbstractLongAssertIsNotEqualTo() {
        }

        AbstractLongAssert<?> before(AbstractLongAssert<?> longAssert, long n) {
            return (AbstractLongAssert)Refaster.anyOf((Object[])new AbstractLongAssert[]{longAssert.isNotCloseTo(n, Offset.offset((Number)0L)), longAssert.isNotCloseTo(n, Percentage.withPercentage((double)0.0))});
        }

        AbstractLongAssert<?> after(AbstractLongAssert<?> longAssert, long n) {
            return longAssert.isNotEqualTo(n);
        }
    }

    @RecipeDescriptor(name="Replace `isCloseTo` with `isEqualTo`", description="Replace `isCloseTo` with `isEqualTo` when `offset` or `percentage` is zero.")
    static final class AbstractLongAssertIsEqualTo {
        AbstractLongAssertIsEqualTo() {
        }

        AbstractLongAssert<?> before(AbstractLongAssert<?> longAssert, long n) {
            return (AbstractLongAssert)Refaster.anyOf((Object[])new AbstractLongAssert[]{longAssert.isCloseTo(n, Offset.offset((Number)0L)), longAssert.isCloseTo(n, Percentage.withPercentage((double)0.0))});
        }

        AbstractLongAssert<?> after(AbstractLongAssert<?> longAssert, long n) {
            return longAssert.isEqualTo(n);
        }
    }
}

