/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.mockito;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.testing.junit5.RemoveObsoleteRunners;
import org.openrewrite.java.testing.junit5.RunnerToExtension;
import org.openrewrite.java.trait.Annotated;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class MockitoJUnitRunnerToExtension
extends Recipe {
    public String getDisplayName() {
        return "Replace JUnit 4 MockitoJUnitRunner with junit-jupiter MockitoExtension";
    }

    public String getDescription() {
        return "Replace JUnit 4 MockitoJUnitRunner annotations with JUnit 5 `@ExtendWith(MockitoExtension.class)` using the appropriate strictness levels (LENIENT, WARN, STRICT_STUBS).";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType("org.mockito.junit.MockitoJUnitRunner*", Boolean.valueOf(false)), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
            final String runWith = "@org.junit.runner.RunWith";
            final String extendWithMockito = "@org.junit.jupiter.api.extension.ExtendWith(org.mockito.junit.jupiter.MockitoExtension.class)";
            final String mockitoSettings = "@org.mockito.junit.jupiter.MockitoSettings";
            final String mockitoStrictness = "org.mockito.quality.Strictness";

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)ctx);
                Strictness runnerStrictness = this.getStrictness(cd, "@org.junit.runner.RunWith");
                Strictness extensionStrictness = this.getStrictness(cd, "@org.mockito.junit.jupiter.MockitoSettings");
                if (runnerStrictness == null) {
                    return cd;
                }
                this.registerAfterVisit(cd);
                if (extensionStrictness == null || extensionStrictness.isGreaterThan(runnerStrictness)) {
                    List annotations = ListUtils.map((List)cd.getLeadingAnnotations(), a -> a == null || new AnnotationMatcher("@org.mockito.junit.jupiter.MockitoSettings").matches(a) ? null : a);
                    J.ClassDeclaration _cd = cd.withLeadingAnnotations(annotations);
                    return this.getTemplate(runnerStrictness, ctx).map(t -> (J.ClassDeclaration)this.maybeAutoFormat((J)_cd, (J)((J.ClassDeclaration)t.apply(this.updateCursor((Tree)_cd), _cd.getCoordinates().addAnnotation(Comparator.comparing(J.Annotation::getSimpleName)), new Object[0])), ctx)).orElse(_cd);
                }
                return cd;
            }

            private @Nullable Strictness getStrictness(J.ClassDeclaration cd, String signature) {
                return (Strictness)((Object)((AtomicReference)new Annotated.Matcher(signature).asVisitor((a, s) -> ((J.Annotation)a.getTree()).acceptJava((JavaVisitor)new JavaIsoVisitor<AtomicReference<Strictness>>(){

                    public J.FieldAccess visitFieldAccess(J.FieldAccess fieldAccess, AtomicReference<Strictness> strictness) {
                        for (Strictness strict : Strictness.values()) {
                            if (TypeUtils.isOfClassType((JavaType)fieldAccess.getTarget().getType(), (String)strict.runner)) {
                                strictness.set(strict);
                                break;
                            }
                            if (!TypeUtils.isOfClassType((JavaType)fieldAccess.getType(), (String)"org.mockito.quality.Strictness") || !fieldAccess.getName().getSimpleName().equals(strict.name())) continue;
                            strictness.set(strict);
                            break;
                        }
                        return fieldAccess;
                    }
                }, s)).reduce((Tree)cd, new AtomicReference())).get());
            }

            private void registerAfterVisit(J.ClassDeclaration cd) {
                boolean hasMockitoExtensions = ((AtomicBoolean)new Annotated.Matcher("@org.junit.jupiter.api.extension.ExtendWith(org.mockito.junit.jupiter.MockitoExtension.class)").asVisitor((a, flag) -> {
                    flag.set(true);
                    return a.getTree();
                }).reduce((Tree)cd, (Object)new AtomicBoolean(false))).get();
                List<String> obsoleteRunners = Arrays.asList("org.mockito.junit.MockitoJUnitRunner.Silent", "org.mockito.junit.MockitoJUnitRunner.Strict", "org.mockito.junit.MockitoJUnitRunner");
                if (hasMockitoExtensions) {
                    this.doAfterVisit(new RemoveObsoleteRunners(obsoleteRunners).getVisitor());
                } else {
                    this.doAfterVisit(new RunnerToExtension(obsoleteRunners, "org.mockito.junit.jupiter.MockitoExtension").getVisitor());
                }
                for (Strictness strictness : Strictness.values()) {
                    this.maybeRemoveImport(strictness.runner);
                }
                this.maybeAddImport("org.mockito.quality.Strictness");
                this.maybeAddImport("org.mockito.junit.jupiter.MockitoSettings");
            }

            private Optional<JavaTemplate> getTemplate(Strictness strictness, ExecutionContext ctx) {
                if (strictness == Strictness.STRICT_STUBS) {
                    return Optional.empty();
                }
                return Optional.of(JavaTemplate.builder((String)("@MockitoSettings(strictness = Strictness." + (Object)((Object)strictness) + ")")).imports(new String[]{"org.mockito.quality.Strictness", "org.mockito.junit.jupiter.MockitoSettings"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"mockito-junit-jupiter-3.12", "mockito-core-3.12"})).build());
            }
        });
    }

    private static enum Strictness {
        LENIENT("org.mockito.junit.MockitoJUnitRunner.Silent"),
        WARN("org.mockito.junit.MockitoJUnitRunner"),
        STRICT_STUBS("org.mockito.junit.MockitoJUnitRunner.Strict");

        final String runner;

        private Strictness(String runner) {
            this.runner = runner;
        }

        boolean isGreaterThan(Strictness strictness) {
            return this.ordinal() > strictness.ordinal();
        }
    }
}

