/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.marker.ci;

import com.sun.jna.platform.win32.Kernel32Util;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.ci.POSIXUtil;

public abstract class OperatingSystem {
    public static final Windows WINDOWS = new Windows();
    public static final MacOs MAC_OS = new MacOs();
    public static final Solaris SOLARIS = new Solaris();
    public static final Linux LINUX = new Linux();
    public static final FreeBSD FREE_BSD = new FreeBSD();
    public static final Unix UNIX = new Unix();
    private static OperatingSystem currentOs;
    private final String toStringValue;
    private final String osName = System.getProperty("os.name");
    private final String osVersion = System.getProperty("os.version");

    OperatingSystem() {
        this.toStringValue = this.getName() + " " + this.getVersion() + " " + System.getProperty("os.arch");
    }

    public static String hostname() {
        OperatingSystem currentOs = OperatingSystem.current();
        if (currentOs.isWindows()) {
            try {
                return Kernel32Util.getComputerName();
            }
            catch (Throwable throwable) {
            }
        } else if (currentOs.isUnix()) {
            try {
                return POSIXUtil.getHostName();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return "localhost";
    }

    public static OperatingSystem current() {
        if (currentOs == null) {
            currentOs = OperatingSystem.forName(System.getProperty("os.name"));
        }
        return currentOs;
    }

    static void resetCurrent() {
        currentOs = null;
    }

    public static OperatingSystem forName(String os) {
        String osName = os.toLowerCase();
        if (osName.contains("windows")) {
            return WINDOWS;
        }
        if (osName.contains("mac os x") || osName.contains("darwin") || osName.contains("osx")) {
            return MAC_OS;
        }
        if (osName.contains("sunos") || osName.contains("solaris")) {
            return SOLARIS;
        }
        if (osName.contains("linux")) {
            return LINUX;
        }
        if (osName.contains("freebsd")) {
            return FREE_BSD;
        }
        return UNIX;
    }

    public String toString() {
        return this.toStringValue;
    }

    public String getName() {
        return this.osName;
    }

    public String getVersion() {
        return this.osVersion;
    }

    public boolean isWindows() {
        return false;
    }

    public boolean isUnix() {
        return false;
    }

    public boolean isMacOsX() {
        return false;
    }

    public boolean isLinux() {
        return false;
    }

    public abstract String getNativePrefix();

    public abstract String getScriptName(String var1);

    public abstract String getExecutableName(String var1);

    public abstract String getExecutableSuffix();

    public abstract String getSharedLibraryName(String var1);

    public abstract String getSharedLibrarySuffix();

    public abstract String getStaticLibraryName(String var1);

    public abstract String getStaticLibrarySuffix();

    public abstract String getLinkLibrarySuffix();

    public abstract String getLinkLibraryName(String var1);

    public abstract String getFamilyName();

    @Nullable
    public File findInPath(String name) {
        String exeName = this.getExecutableName(name);
        if (exeName.contains(File.separator)) {
            File candidate = new File(exeName);
            if (candidate.isFile()) {
                return candidate;
            }
            return null;
        }
        for (File dir : this.getPath()) {
            File candidate = new File(dir, exeName);
            if (!candidate.isFile()) continue;
            return candidate;
        }
        return null;
    }

    public List<File> findAllInPath(String name) {
        ArrayList<File> all = new ArrayList<File>();
        for (File dir : this.getPath()) {
            File candidate = new File(dir, name);
            if (!candidate.isFile()) continue;
            all.add(candidate);
        }
        return all;
    }

    public List<File> getPath() {
        String path = System.getenv(this.getPathVar());
        if (path == null) {
            return Collections.emptyList();
        }
        ArrayList<File> entries = new ArrayList<File>();
        for (String entry : path.split(Pattern.quote(File.pathSeparator))) {
            entries.add(new File(entry));
        }
        return entries;
    }

    public String getPathVar() {
        return "PATH";
    }

    private static String withExtension(String filePath, String extension) {
        if (filePath.toLowerCase().endsWith(extension)) {
            return filePath;
        }
        return OperatingSystem.removeExtension(filePath) + extension;
    }

    private static String removeExtension(String filePath) {
        int fileNameStart = Math.max(filePath.lastIndexOf(47), filePath.lastIndexOf(92));
        int extensionPos = filePath.lastIndexOf(46);
        if (extensionPos > fileNameStart) {
            return filePath.substring(0, extensionPos);
        }
        return filePath;
    }

    static class Windows
    extends OperatingSystem {
        private final String nativePrefix = this.resolveNativePrefix();

        Windows() {
        }

        @Override
        public boolean isWindows() {
            return true;
        }

        @Override
        public String getFamilyName() {
            return "windows";
        }

        @Override
        public String getScriptName(String scriptPath) {
            return OperatingSystem.withExtension(scriptPath, ".bat");
        }

        @Override
        public String getExecutableSuffix() {
            return ".exe";
        }

        @Override
        public String getExecutableName(String executablePath) {
            return OperatingSystem.withExtension(executablePath, ".exe");
        }

        @Override
        public String getSharedLibrarySuffix() {
            return ".dll";
        }

        @Override
        public String getSharedLibraryName(String libraryPath) {
            return OperatingSystem.withExtension(libraryPath, ".dll");
        }

        @Override
        public String getLinkLibrarySuffix() {
            return ".lib";
        }

        @Override
        public String getLinkLibraryName(String libraryPath) {
            return OperatingSystem.withExtension(libraryPath, ".lib");
        }

        @Override
        public String getStaticLibrarySuffix() {
            return ".lib";
        }

        @Override
        public String getStaticLibraryName(String libraryName) {
            return OperatingSystem.withExtension(libraryName, ".lib");
        }

        @Override
        public String getNativePrefix() {
            return this.nativePrefix;
        }

        private String resolveNativePrefix() {
            String arch = System.getProperty("os.arch");
            if ("i386".equals(arch)) {
                arch = "x86";
            }
            return "win32-" + arch;
        }

        @Override
        public String getPathVar() {
            return "Path";
        }
    }

    static class MacOs
    extends Unix {
        MacOs() {
        }

        @Override
        public boolean isMacOsX() {
            return true;
        }

        @Override
        public String getFamilyName() {
            return "os x";
        }

        @Override
        public String getSharedLibrarySuffix() {
            return ".dylib";
        }

        @Override
        public String getNativePrefix() {
            return "darwin";
        }
    }

    static class Solaris
    extends Unix {
        Solaris() {
        }

        @Override
        public String getFamilyName() {
            return "solaris";
        }

        @Override
        protected String getOsPrefix() {
            return "sunos";
        }

        @Override
        protected String getArch() {
            String arch = System.getProperty("os.arch");
            if (arch.equals("i386") || arch.equals("x86")) {
                return "x86";
            }
            return super.getArch();
        }
    }

    static class Linux
    extends Unix {
        Linux() {
        }

        @Override
        public boolean isLinux() {
            return true;
        }

        @Override
        public String getFamilyName() {
            return "linux";
        }
    }

    static class FreeBSD
    extends Unix {
        FreeBSD() {
        }
    }

    static class Unix
    extends OperatingSystem {
        private final String nativePrefix = this.resolveNativePrefix();

        Unix() {
        }

        @Override
        public String getScriptName(String scriptPath) {
            return scriptPath;
        }

        @Override
        public String getFamilyName() {
            return "unknown";
        }

        @Override
        public String getExecutableSuffix() {
            return "";
        }

        @Override
        public String getExecutableName(String executablePath) {
            return executablePath;
        }

        @Override
        public String getSharedLibraryName(String libraryName) {
            return this.getLibraryName(libraryName, this.getSharedLibrarySuffix());
        }

        private String getLibraryName(String libraryName, String suffix) {
            if (libraryName.endsWith(suffix)) {
                return libraryName;
            }
            int pos = libraryName.lastIndexOf(47);
            if (pos >= 0) {
                return libraryName.substring(0, pos + 1) + "lib" + libraryName.substring(pos + 1) + suffix;
            }
            return "lib" + libraryName + suffix;
        }

        @Override
        public String getSharedLibrarySuffix() {
            return ".so";
        }

        @Override
        public String getLinkLibrarySuffix() {
            return this.getSharedLibrarySuffix();
        }

        @Override
        public String getLinkLibraryName(String libraryPath) {
            return this.getSharedLibraryName(libraryPath);
        }

        @Override
        public String getStaticLibrarySuffix() {
            return ".a";
        }

        @Override
        public String getStaticLibraryName(String libraryName) {
            return this.getLibraryName(libraryName, ".a");
        }

        @Override
        public boolean isUnix() {
            return true;
        }

        @Override
        public String getNativePrefix() {
            return this.nativePrefix;
        }

        private String resolveNativePrefix() {
            String arch = this.getArch();
            String osPrefix = this.getOsPrefix();
            osPrefix = osPrefix + "-" + arch;
            return osPrefix;
        }

        protected String getArch() {
            String arch = System.getProperty("os.arch");
            if ("x86".equals(arch)) {
                arch = "i386";
            }
            if ("x86_64".equals(arch)) {
                arch = "amd64";
            }
            if ("powerpc".equals(arch)) {
                arch = "ppc";
            }
            return arch;
        }

        protected String getOsPrefix() {
            String osPrefix = this.getName().toLowerCase();
            int space = osPrefix.indexOf(" ");
            if (space != -1) {
                osPrefix = osPrefix.substring(0, space);
            }
            return osPrefix;
        }
    }
}

