/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.openrewrite.DataTable;
import org.openrewrite.RecipeRunStats;
import org.openrewrite.Result;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

public final class RecipeRun {
    private final RecipeRunStats stats;
    private final List<Result> results;
    private final Map<DataTable<?>, List<?>> dataTables;

    @Nullable
    public DataTable<?> getDataTable(String name) {
        for (DataTable<?> dataTable : this.dataTables.keySet()) {
            if (!dataTable.getName().equals(name)) continue;
            return dataTable;
        }
        return null;
    }

    @Nullable
    public <E> List<E> getDataTableRows(String name) {
        for (Map.Entry<DataTable<?>, List<?>> dataTableAndRows : this.dataTables.entrySet()) {
            if (!dataTableAndRows.getKey().getName().equals(name)) continue;
            return dataTableAndRows.getValue();
        }
        return Collections.emptyList();
    }

    public RecipeRun(RecipeRunStats stats, List<Result> results, Map<DataTable<?>, List<?>> dataTables) {
        this.stats = stats;
        this.results = results;
        this.dataTables = dataTables;
    }

    public RecipeRunStats getStats() {
        return this.stats;
    }

    public List<Result> getResults() {
        return this.results;
    }

    public Map<DataTable<?>, List<?>> getDataTables() {
        return this.dataTables;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RecipeRun)) {
            return false;
        }
        RecipeRun other = (RecipeRun)o;
        RecipeRunStats this$stats = this.getStats();
        RecipeRunStats other$stats = other.getStats();
        if (this$stats == null ? other$stats != null : !this$stats.equals(other$stats)) {
            return false;
        }
        List<Result> this$results = this.getResults();
        List<Result> other$results = other.getResults();
        if (this$results == null ? other$results != null : !((Object)this$results).equals(other$results)) {
            return false;
        }
        Map<DataTable<?>, List<?>> this$dataTables = this.getDataTables();
        Map<DataTable<?>, List<?>> other$dataTables = other.getDataTables();
        return !(this$dataTables == null ? other$dataTables != null : !((Object)this$dataTables).equals(other$dataTables));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RecipeRunStats $stats = this.getStats();
        result = result * 59 + ($stats == null ? 43 : $stats.hashCode());
        List<Result> $results = this.getResults();
        result = result * 59 + ($results == null ? 43 : ((Object)$results).hashCode());
        Map<DataTable<?>, List<?>> $dataTables = this.getDataTables();
        result = result * 59 + ($dataTables == null ? 43 : ((Object)$dataTables).hashCode());
        return result;
    }

    @NonNull
    public String toString() {
        return "RecipeRun(stats=" + this.getStats() + ", results=" + this.getResults() + ", dataTables=" + this.getDataTables() + ")";
    }

    @NonNull
    public RecipeRun withResults(List<Result> results) {
        return this.results == results ? this : new RecipeRun(this.stats, results, this.dataTables);
    }

    @NonNull
    public RecipeRun withDataTables(Map<DataTable<?>, List<?>> dataTables) {
        return this.dataTables == dataTables ? this : new RecipeRun(this.stats, this.results, dataTables);
    }
}

