/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.marker;

import java.util.Objects;
import java.util.UUID;
import java.util.function.UnaryOperator;
import org.openrewrite.Cursor;
import org.openrewrite.Incubating;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Marker;

public class SearchResult
implements Marker {
    private final UUID id;
    @Nullable
    private final String description;

    public static <T extends Tree> T found(@Nullable T t) {
        return SearchResult.found(t, null);
    }

    public static <T extends Tree> T found(@Nullable T t, @Nullable String description) {
        if (t == null) {
            return null;
        }
        return t.withMarkers(t.getMarkers().computeByType(new SearchResult(Tree.randomId(), description), (s1, s2) -> s1 == null ? s2 : s1));
    }

    @Incubating(since="8.0.0")
    public static <T extends Tree> T mergingFound(@Nullable T t, String description) {
        return SearchResult.mergingFound(t, description, ", ");
    }

    @Incubating(since="8.0.0")
    public static <T extends Tree> T mergingFound(@Nullable T t, String description, String delimiter) {
        Objects.requireNonNull(delimiter, "delimiter must not be null");
        if (t == null) {
            return null;
        }
        return t.withMarkers(t.getMarkers().computeByType(new SearchResult(Tree.randomId(), description), (s1, s2) -> {
            if (s1 == null) {
                return s2;
            }
            if (s2 == null) {
                return s1;
            }
            if (s1.getDescription() == null) {
                return s2;
            }
            if (s2.getDescription() == null) {
                return s1;
            }
            return s1.withDescription(s1.getDescription() + delimiter + s2.getDescription());
        }));
    }

    @Override
    public String print(Cursor cursor, UnaryOperator<String> commentWrapper, boolean verbose) {
        return (String)commentWrapper.apply(this.description == null ? "" : "(" + this.description + ")");
    }

    public SearchResult(UUID id, @Nullable String description) {
        this.id = id;
        this.description = description;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SearchResult)) {
            return false;
        }
        SearchResult other = (SearchResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof SearchResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @NonNull
    public SearchResult withId(UUID id) {
        return this.id == id ? this : new SearchResult(id, this.description);
    }

    @NonNull
    public SearchResult withDescription(@Nullable String description) {
        return this.description == description ? this : new SearchResult(this.id, description);
    }
}

