/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.semver;

import java.util.Scanner;
import java.util.regex.Pattern;
import org.openrewrite.Incubating;
import org.openrewrite.Validated;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.semver.CaretRange;
import org.openrewrite.semver.ExactVersion;
import org.openrewrite.semver.HyphenRange;
import org.openrewrite.semver.LatestPatch;
import org.openrewrite.semver.LatestRelease;
import org.openrewrite.semver.SetRange;
import org.openrewrite.semver.TildeRange;
import org.openrewrite.semver.XRange;

public class Semver {
    private Semver() {
    }

    public static boolean isVersion(String version) {
        return LatestRelease.RELEASE_PATTERN.matcher(version).matches();
    }

    public static Validated validate(String toVersion, @Nullable String metadataPattern) {
        return Validated.test("metadataPattern", "must be a valid regular expression", metadataPattern, metadata -> {
            try {
                if (metadata != null) {
                    Pattern.compile(metadata);
                }
                return true;
            }
            catch (Throwable e) {
                return false;
            }
        }).and(LatestRelease.build(toVersion, metadataPattern).or(LatestPatch.build(toVersion, metadataPattern)).or(HyphenRange.build(toVersion, metadataPattern)).or(XRange.build(toVersion, metadataPattern)).or(TildeRange.build(toVersion, metadataPattern)).or(CaretRange.build(toVersion, metadataPattern)).or(SetRange.build(toVersion, metadataPattern)).or(ExactVersion.build(toVersion)));
    }

    @Incubating(since="7.16.0")
    public static String majorVersion(String version) {
        Scanner scanner = new Scanner(version);
        scanner.useDelimiter("[.\\-$]");
        if (scanner.hasNext()) {
            return scanner.next();
        }
        return version;
    }

    @Incubating(since="7.16.0")
    public static String minorVersion(String version) {
        String minor;
        Scanner scanner = new Scanner(version);
        scanner.useDelimiter("[.\\-$]");
        if (scanner.hasNext()) {
            scanner.next();
        }
        if (scanner.hasNext() && StringUtils.isNumeric(minor = scanner.next())) {
            return minor;
        }
        return version;
    }
}

