/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.marker.ci;

import java.util.Collections;
import java.util.UUID;
import java.util.function.UnaryOperator;
import org.openrewrite.Tree;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.GitProvenance;
import org.openrewrite.marker.ci.BuildEnvironment;
import org.openrewrite.marker.ci.IncompleteGitConfigException;

public final class BitbucketBuildEnvironment
implements BuildEnvironment {
    private final UUID id;
    private final String httpOrigin;
    private final String branch;
    private final String sha;

    public static BitbucketBuildEnvironment build(UnaryOperator<String> environment) {
        return new BitbucketBuildEnvironment(Tree.randomId(), (String)environment.apply("BITBUCKET_GIT_HTTP_ORIGIN"), (String)environment.apply("BITBUCKET_BRANCH"), (String)environment.apply("BITBUCKET_COMMIT"));
    }

    @Override
    public GitProvenance buildGitProvenance() throws IncompleteGitConfigException {
        if (StringUtils.isBlank(this.httpOrigin) || StringUtils.isBlank(this.branch) || StringUtils.isBlank(this.sha)) {
            throw new IncompleteGitConfigException();
        }
        return new GitProvenance(UUID.randomUUID(), this.httpOrigin, this.branch, this.sha, null, null, Collections.emptyList());
    }

    public BitbucketBuildEnvironment(UUID id, String httpOrigin, String branch, String sha) {
        this.id = id;
        this.httpOrigin = httpOrigin;
        this.branch = branch;
        this.sha = sha;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    public String getHttpOrigin() {
        return this.httpOrigin;
    }

    public String getBranch() {
        return this.branch;
    }

    public String getSha() {
        return this.sha;
    }

    @NonNull
    public String toString() {
        return "BitbucketBuildEnvironment(id=" + this.getId() + ", httpOrigin=" + this.getHttpOrigin() + ", branch=" + this.getBranch() + ", sha=" + this.getSha() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BitbucketBuildEnvironment)) {
            return false;
        }
        BitbucketBuildEnvironment other = (BitbucketBuildEnvironment)o;
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$httpOrigin = this.getHttpOrigin();
        String other$httpOrigin = other.getHttpOrigin();
        if (this$httpOrigin == null ? other$httpOrigin != null : !this$httpOrigin.equals(other$httpOrigin)) {
            return false;
        }
        String this$branch = this.getBranch();
        String other$branch = other.getBranch();
        if (this$branch == null ? other$branch != null : !this$branch.equals(other$branch)) {
            return false;
        }
        String this$sha = this.getSha();
        String other$sha = other.getSha();
        return !(this$sha == null ? other$sha != null : !this$sha.equals(other$sha));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $httpOrigin = this.getHttpOrigin();
        result = result * 59 + ($httpOrigin == null ? 43 : $httpOrigin.hashCode());
        String $branch = this.getBranch();
        result = result * 59 + ($branch == null ? 43 : $branch.hashCode());
        String $sha = this.getSha();
        result = result * 59 + ($sha == null ? 43 : $sha.hashCode());
        return result;
    }

    @NonNull
    public BitbucketBuildEnvironment withId(UUID id) {
        return this.id == id ? this : new BitbucketBuildEnvironment(id, this.httpOrigin, this.branch, this.sha);
    }
}

