/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.table;

import java.time.LocalDate;
import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

public class CommitsByDay
extends DataTable<Row> {
    public CommitsByDay(Recipe recipe) {
        super(recipe, "Commits by day", "The commit activity by day by committer.");
    }

    public static final class Row {
        @Column(displayName="Name", description="The name of the committer.")
        private final String name;
        @Column(displayName="Email", description="The email of the committer.")
        private final String email;
        @Column(displayName="Date", description="The date of the day.")
        private final LocalDate day;
        @Column(displayName="Number of commits", description="The number of commits made by this committer on this day.")
        private final int commits;

        public Row(String name, String email, LocalDate day, int commits) {
            this.name = name;
            this.email = email;
            this.day = day;
            this.commits = commits;
        }

        public String getName() {
            return this.name;
        }

        public String getEmail() {
            return this.email;
        }

        public LocalDate getDay() {
            return this.day;
        }

        public int getCommits() {
            return this.commits;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            if (this.getCommits() != other.getCommits()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$email = this.getEmail();
            String other$email = other.getEmail();
            if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
                return false;
            }
            LocalDate this$day = this.getDay();
            LocalDate other$day = other.getDay();
            return !(this$day == null ? other$day != null : !((Object)this$day).equals(other$day));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getCommits();
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $email = this.getEmail();
            result = result * 59 + ($email == null ? 43 : $email.hashCode());
            LocalDate $day = this.getDay();
            result = result * 59 + ($day == null ? 43 : ((Object)$day).hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "CommitsByDay.Row(name=" + this.getName() + ", email=" + this.getEmail() + ", day=" + this.getDay() + ", commits=" + this.getCommits() + ")";
        }
    }
}

