/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.marketplace;

import com.univocity.parsers.csv.CsvFormat;
import com.univocity.parsers.csv.CsvWriter;
import com.univocity.parsers.csv.CsvWriterSettings;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.intellij.lang.annotations.Language;
import org.openrewrite.marketplace.RecipeBundle;
import org.openrewrite.marketplace.RecipeListing;
import org.openrewrite.marketplace.RecipeMarketplace;

public class RecipeMarketplaceWriter {
    @Language(value="csv")
    public String toCsv(RecipeMarketplace marketplace) {
        StringWriter sw = new StringWriter();
        this.toCsv(marketplace, sw);
        return sw.toString();
    }

    public void toCsv(RecipeMarketplace marketplace, Path csvFile) {
        try (BufferedWriter writer = Files.newBufferedWriter(csvFile, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            this.toCsv(marketplace, writer);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toCsv(RecipeMarketplace marketplace, Writer writer) {
        CsvWriterSettings settings = new CsvWriterSettings();
        ((CsvFormat)settings.getFormat()).setLineSeparator("\n");
        try (CsvWriter csv = new CsvWriter(writer, settings);){
            int i;
            int startDepth = marketplace.isRoot() ? 0 : 1;
            int maxCategoryDepth = this.calculateMaxCategoryDepth(marketplace, startDepth);
            int maxOptions = this.calculateMaxOptions(marketplace);
            ArrayList<String> headers = new ArrayList<String>();
            Set<String> optionalColumns = this.findUsedOptionalColumns(marketplace);
            if (optionalColumns.contains("ecosystem")) {
                headers.add("ecosystem");
            }
            if (optionalColumns.contains("packageName")) {
                headers.add("packageName");
            }
            if (optionalColumns.contains("version")) {
                headers.add("version");
            }
            headers.add("name");
            headers.add("displayName");
            headers.add("description");
            for (i = 1; i <= maxCategoryDepth; ++i) {
                headers.add("category" + i);
            }
            for (i = 1; i <= maxOptions; ++i) {
                headers.add("option" + i + "Name");
                headers.add("option" + i + "DisplayName");
                headers.add("option" + i + "Description");
            }
            if (optionalColumns.contains("team")) {
                headers.add("team");
            }
            csv.writeHeaders(headers);
            ArrayList<String> categoryPath = new ArrayList<String>();
            if (!marketplace.isRoot()) {
                categoryPath.add(marketplace.getDisplayName());
            }
            this.writeCsvRecursive(csv, marketplace, categoryPath, maxCategoryDepth, maxOptions, optionalColumns);
        }
    }

    private void writeCsvRecursive(CsvWriter csv, RecipeMarketplace marketplace, List<String> categoryPath, int maxCategoryDepth, int maxOptions, Set<String> optionalColumns) {
        for (RecipeListing recipe : marketplace.getRecipes()) {
            ArrayList<String> row = new ArrayList<String>();
            RecipeBundle bundle = recipe.getBundle();
            if (optionalColumns.contains("ecosystem")) {
                row.add(bundle != null ? bundle.getPackageEcosystem() : "");
            }
            if (optionalColumns.contains("packageName")) {
                row.add(bundle != null ? bundle.getPackageName() : "");
            }
            if (optionalColumns.contains("version")) {
                if (bundle == null) {
                    row.add("");
                } else {
                    row.add(bundle.getVersion() == null ? "" : bundle.getVersion());
                }
            }
            row.add(recipe.getName());
            row.add(recipe.getDisplayName());
            row.add(recipe.getDescription());
            ArrayList<String> filteredPath = new ArrayList<String>();
            for (String category : categoryPath) {
                if ("\u03b5".equals(category)) continue;
                filteredPath.add(category);
            }
            Collections.reverse(filteredPath);
            int padding = maxCategoryDepth - filteredPath.size();
            for (int i = 0; i < maxCategoryDepth; ++i) {
                if (i < padding) {
                    row.add("");
                    continue;
                }
                row.add((String)filteredPath.get(i - padding));
            }
            List<? extends RecipeListing.Option> options = recipe.getOptions();
            for (int i = 0; i < maxOptions; ++i) {
                if (i < options.size()) {
                    RecipeListing.Option option = options.get(i);
                    row.add(option.getName());
                    row.add(option.getDisplayName());
                    row.add(option.getDescription());
                    continue;
                }
                row.add("");
                row.add("");
                row.add("");
            }
            if (optionalColumns.contains("team")) {
                String team = bundle != null ? bundle.getTeam() : null;
                row.add(team != null ? team : "");
            }
            csv.writeRow(row.toArray(new String[0]));
        }
        for (RecipeMarketplace child : marketplace.getCategories()) {
            ArrayList<String> childPath = new ArrayList<String>(categoryPath);
            childPath.add(child.getDisplayName());
            this.writeCsvRecursive(csv, child, childPath, maxCategoryDepth, maxOptions, optionalColumns);
        }
    }

    private int calculateMaxCategoryDepth(RecipeMarketplace marketplace, int currentDepth) {
        int maxDepth = 0;
        if (!marketplace.getRecipes().isEmpty()) {
            maxDepth = currentDepth;
        }
        for (RecipeMarketplace child : marketplace.getCategories()) {
            int childDepth = this.calculateMaxCategoryDepth(child, currentDepth + 1);
            maxDepth = Math.max(maxDepth, childDepth);
        }
        return maxDepth;
    }

    private int calculateMaxOptions(RecipeMarketplace marketplace) {
        int max = 0;
        for (RecipeListing recipe : marketplace.getRecipes()) {
            max = Math.max(max, recipe.getOptions().size());
        }
        for (RecipeMarketplace child : marketplace.getCategories()) {
            max = Math.max(max, this.calculateMaxOptions(child));
        }
        return max;
    }

    private Set<String> findUsedOptionalColumns(RecipeMarketplace marketplace) {
        LinkedHashSet<String> columns = new LinkedHashSet<String>();
        if (this.hasAnyBundle(marketplace)) {
            columns.add("ecosystem");
            columns.add("packageName");
            if (this.hasAnyVersion(marketplace)) {
                columns.add("version");
            }
            if (this.hasAnyTeam(marketplace)) {
                columns.add("team");
            }
        }
        return columns;
    }

    private boolean hasAnyBundle(RecipeMarketplace marketplace) {
        for (RecipeListing recipe : marketplace.getRecipes()) {
            if (recipe.getBundle() == null) continue;
            return true;
        }
        for (RecipeMarketplace child : marketplace.getCategories()) {
            if (!this.hasAnyBundle(child)) continue;
            return true;
        }
        return false;
    }

    private boolean hasAnyTeam(RecipeMarketplace marketplace) {
        for (RecipeListing recipe : marketplace.getRecipes()) {
            RecipeBundle bundle = recipe.getBundle();
            if (bundle == null || bundle.getTeam() == null) continue;
            return true;
        }
        for (RecipeMarketplace child : marketplace.getCategories()) {
            if (!this.hasAnyTeam(child)) continue;
            return true;
        }
        return false;
    }

    private boolean hasAnyVersion(RecipeMarketplace marketplace) {
        for (RecipeListing recipe : marketplace.getRecipes()) {
            RecipeBundle bundle = recipe.getBundle();
            if (bundle == null || bundle.getVersion() == null) continue;
            return true;
        }
        for (RecipeMarketplace child : marketplace.getCategories()) {
            if (!this.hasAnyVersion(child)) continue;
            return true;
        }
        return false;
    }
}

