/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.rpc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import org.jspecify.annotations.Nullable;
import org.openrewrite.rpc.RpcCodec;

public abstract class DynamicDispatchRpcCodec<T>
implements RpcCodec<T> {
    private static final Map<String, List<DynamicDispatchRpcCodec<?>>> CODEC_BY_TYPE = new ConcurrentHashMap();

    public static <T> @Nullable RpcCodec<T> getCodec(Object t, @Nullable String sourceFileType) {
        if (sourceFileType == null) {
            return null;
        }
        for (DynamicDispatchRpcCodec codec : CODEC_BY_TYPE.getOrDefault(sourceFileType, Collections.emptyList())) {
            if (!codec.getType().isAssignableFrom(t.getClass())) continue;
            return codec;
        }
        return null;
    }

    public abstract String getSourceFileType();

    public abstract Class<? extends T> getType();

    static {
        ServiceLoader<DynamicDispatchRpcCodec> loader = ServiceLoader.load(DynamicDispatchRpcCodec.class);
        for (DynamicDispatchRpcCodec provider : loader) {
            CODEC_BY_TYPE.computeIfAbsent(provider.getSourceFileType(), p -> new ArrayList()).add(provider);
        }
    }
}

