/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.gradle.AddDependencyVisitor;
import org.openrewrite.gradle.IsBuildGradle;
import org.openrewrite.gradle.marker.GradleDependencyConfiguration;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.gradle.search.FindJVMTestSuites;
import org.openrewrite.groovy.GroovyIsoVisitor;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.marker.JavaProject;
import org.openrewrite.java.marker.JavaSourceSet;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.maven.table.MavenMetadataFailures;
import org.openrewrite.semver.Semver;

public final class AddDependency
extends ScanningRecipe<Scanned> {
    private final MavenMetadataFailures metadataFailures = new MavenMetadataFailures((Recipe)this);
    @Option(displayName="Group", description="The first part of a dependency coordinate 'com.google.guava:guava:VERSION'.", example="com.google.guava")
    private final String groupId;
    @Option(displayName="Artifact", description="The second part of a dependency coordinate 'com.google.guava:guava:VERSION'", example="guava")
    private final String artifactId;
    @Option(displayName="Version", description="An exact version number or node-style semver selector used to select the version number. You can also use `latest.release` for the latest available version and `latest.patch` if the current version is a valid semantic version. For more details, you can look at the documentation page of [version selectors](https://docs.openrewrite.org/reference/dependency-version-selectors).", example="29.X", required=false)
    private final @Nullable String version;
    @Option(displayName="Version pattern", description="Allows version selection to be extended beyond the original Node Semver semantics. So for example, Setting 'version' to \"25-29\" can be paired with a metadata pattern of \"-jre\" to select Guava 29.0-jre", example="-jre", required=false)
    private final @Nullable String versionPattern;
    @Option(displayName="Configuration", description="A configuration to use when it is not what can be inferred from usage. Most of the time this will be left empty, but is used when adding a new as of yet unused dependency.", example="implementation", required=false)
    private final @Nullable String configuration;
    @Option(displayName="Only if using", description="Used to determine if the dependency will be added and in which scope it should be placed.", example="org.junit.jupiter.api.*", required=false)
    private final @Nullable String onlyIfUsing;
    @Option(displayName="Classifier", description="A classifier to add. Commonly used to select variants of a library.", example="test", required=false)
    private final @Nullable String classifier;
    @Option(displayName="Extension", description="The extension of the dependency to add. If omitted Gradle defaults to assuming the type is \"jar\".", example="jar", required=false)
    private final @Nullable String extension;
    @Option(displayName="Family pattern", description="A pattern, applied to groupIds, used to determine which other dependencies should have aligned version numbers. Accepts '*' as a wildcard character.", example="com.fasterxml.jackson*", required=false)
    private final @Nullable String familyPattern;
    @Option(displayName="Accept transitive", description="Default false. If enabled, the dependency will not be added if it is already on the classpath as a transitive dependency.", example="true", required=false)
    private final @Nullable Boolean acceptTransitive;

    public String getDisplayName() {
        return "Add Gradle dependency";
    }

    public String getInstanceNameSuffix() {
        return String.format("`%s:%s:%s`", this.groupId, this.artifactId, this.version);
    }

    public String getDescription() {
        return "Add a gradle dependency to a `build.gradle` file in the correct configuration based on where it is used.";
    }

    public Validated<Object> validate() {
        Validated validated = super.validate();
        if (this.version != null) {
            validated = validated.and(Semver.validate((String)this.version, (String)this.versionPattern));
        }
        return validated;
    }

    public Scanned getInitialValue(ExecutionContext ctx) {
        return new Scanned();
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final Scanned acc) {
        return new TreeVisitor<Tree, ExecutionContext>(){
            @Nullable UsesType<ExecutionContext> usesType = null;

            private boolean usesType(SourceFile sourceFile, ExecutionContext ctx) {
                if (AddDependency.this.onlyIfUsing == null) {
                    return true;
                }
                if (this.usesType == null) {
                    this.usesType = new UsesType(AddDependency.this.onlyIfUsing, Boolean.valueOf(true));
                }
                return this.usesType.isAcceptable(sourceFile, (Object)ctx) && this.usesType.visit((Tree)sourceFile, (Object)ctx) != sourceFile;
            }

            public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (!(tree instanceof SourceFile)) {
                    return tree;
                }
                SourceFile sourceFile = (SourceFile)tree;
                sourceFile.getMarkers().findFirst(JavaProject.class).ifPresent(javaProject -> {
                    if (this.usesType(sourceFile, ctx)) {
                        acc2.usingType = true;
                    }
                    acc2.customJvmTestSuitesWithDependencies.computeIfAbsent((JavaProject)javaProject, ignored -> new HashSet()).addAll(FindJVMTestSuites.jvmTestSuiteNames(tree, true));
                    Set configurations = acc2.configurationsByProject.computeIfAbsent((JavaProject)javaProject, ignored -> new HashSet());
                    sourceFile.getMarkers().findFirst(JavaSourceSet.class).ifPresent(sourceSet -> configurations.add("main".equals(sourceSet.getName()) ? "implementation" : sourceSet.getName() + "Implementation"));
                });
                return tree;
            }
        };
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(final Scanned acc) {
        return Preconditions.check(((this.onlyIfUsing == null || acc.usingType) && !acc.configurationsByProject.isEmpty() ? 1 : 0) != 0, (TreeVisitor)Preconditions.check(new IsBuildGradle(), (TreeVisitor)new GroovyIsoVisitor<ExecutionContext>(){
            private final Set<String> gradleStandardConfigurations = new HashSet<String>(Arrays.asList("api", "implementation", "compileOnly", "compileOnlyApi", "runtimeOnly", "testImplementation", "testCompileOnly", "testRuntimeOnly"));

            public @Nullable J visit(@Nullable Tree tree, ExecutionContext ctx) {
                GradleDependencyConfiguration gdc;
                HashSet<String> resolvedConfigurations;
                if (!(tree instanceof JavaSourceFile)) {
                    return (J)tree;
                }
                JavaSourceFile s = (JavaSourceFile)tree;
                if (!s.getSourcePath().toString().endsWith(".gradle") || s.getSourcePath().getFileName().toString().equals("settings.gradle")) {
                    return s;
                }
                Optional maybeJp = s.getMarkers().findFirst(JavaProject.class);
                if (!maybeJp.isPresent()) {
                    return s;
                }
                JavaProject jp = (JavaProject)maybeJp.get();
                if (!acc.configurationsByProject.containsKey(jp)) {
                    return s;
                }
                Optional maybeGp = s.getMarkers().findFirst(GradleProject.class);
                if (!maybeGp.isPresent()) {
                    return s;
                }
                GradleProject gp = (GradleProject)maybeGp.get();
                Set<String> set = resolvedConfigurations = StringUtils.isBlank((String)AddDependency.this.configuration) ? (Set)acc.configurationsByProject.getOrDefault(jp, new HashSet()) : new HashSet<String>(Collections.singletonList(AddDependency.this.configuration));
                if (resolvedConfigurations.isEmpty()) {
                    resolvedConfigurations.add("implementation");
                }
                HashSet<String> tmpConfigurations = new HashSet<String>(resolvedConfigurations);
                for (String tmpConfiguration : tmpConfigurations) {
                    gdc = gp.getConfiguration(tmpConfiguration);
                    if (gdc != null && gdc.findRequestedDependency(AddDependency.this.groupId, AddDependency.this.artifactId) == null) continue;
                    resolvedConfigurations.remove(tmpConfiguration);
                }
                tmpConfigurations = new HashSet<String>(resolvedConfigurations);
                for (String tmpConfiguration : tmpConfigurations) {
                    gdc = Objects.requireNonNull(gp.getConfiguration(tmpConfiguration));
                    for (GradleDependencyConfiguration transitive : gp.configurationsExtendingFrom(gdc, true)) {
                        if (!resolvedConfigurations.contains(transitive.getName()) && (!Boolean.TRUE.equals(AddDependency.this.acceptTransitive) || transitive.findResolvedDependency(AddDependency.this.groupId, AddDependency.this.artifactId) == null)) continue;
                        resolvedConfigurations.remove(transitive.getName());
                    }
                }
                if (resolvedConfigurations.isEmpty()) {
                    return s;
                }
                G.CompilationUnit g = (G.CompilationUnit)s;
                for (String resolvedConfiguration : resolvedConfigurations) {
                    if (this.targetsCustomJVMTestSuite(resolvedConfiguration, acc.customJvmTestSuitesWithDependencies.get(jp))) {
                        g = (G.CompilationUnit)new AddDependencyVisitor(AddDependency.this.groupId, AddDependency.this.artifactId, AddDependency.this.version, AddDependency.this.versionPattern, this.purgeSourceSet(AddDependency.this.configuration), AddDependency.this.classifier, AddDependency.this.extension, AddDependency.this.metadataFailures, this.isMatchingJVMTestSuite(resolvedConfiguration)).visitNonNull((Tree)g, ctx);
                        continue;
                    }
                    g = (G.CompilationUnit)new AddDependencyVisitor(AddDependency.this.groupId, AddDependency.this.artifactId, AddDependency.this.version, AddDependency.this.versionPattern, resolvedConfiguration, AddDependency.this.classifier, AddDependency.this.extension, AddDependency.this.metadataFailures, this::isTopLevel).visitNonNull((Tree)g, ctx);
                }
                return g;
            }

            private boolean isTopLevel(Cursor cursor) {
                return cursor.getParentOrThrow().firstEnclosing(J.MethodInvocation.class) == null;
            }

            private Predicate<Cursor> isMatchingJVMTestSuite(String resolvedConfiguration) {
                return cursor -> {
                    String sourceSet = this.purgeConfigurationSuffix(resolvedConfiguration);
                    J.MethodInvocation methodInvocation = (J.MethodInvocation)cursor.getParentOrThrow().firstEnclosing(J.MethodInvocation.class);
                    return methodInvocation != null && sourceSet.equals(methodInvocation.getSimpleName());
                };
            }

            boolean targetsCustomJVMTestSuite(String configuration, Set<String> customJvmTestSuites) {
                if (this.gradleStandardConfigurations.contains(configuration) || "default".equals(configuration)) {
                    return false;
                }
                String sourceSet = this.purgeConfigurationSuffix(configuration);
                return customJvmTestSuites.contains(sourceSet);
            }

            private String purgeConfigurationSuffix(String configuration) {
                if (configuration.endsWith("Implementation")) {
                    return configuration.substring(0, configuration.length() - 14);
                }
                if (configuration.endsWith("CompileOnly")) {
                    return configuration.substring(0, configuration.length() - 11);
                }
                if (configuration.endsWith("RuntimeOnly")) {
                    return configuration.substring(0, configuration.length() - 11);
                }
                if (configuration.endsWith("AnnotationProcessor")) {
                    return configuration.substring(0, configuration.length() - 19);
                }
                return configuration;
            }

            private String purgeSourceSet(@Nullable String configuration) {
                if (StringUtils.isBlank((String)configuration) || configuration.endsWith("Implementation")) {
                    return "implementation";
                }
                if (configuration.endsWith("CompileOnly")) {
                    return "compileOnly";
                }
                if (configuration.endsWith("RuntimeOnly")) {
                    return "runtimeOnly";
                }
                if (configuration.endsWith("AnnotationProcessor")) {
                    return "annotationProcessor";
                }
                return configuration;
            }
        }));
    }

    @Generated
    public AddDependency(String groupId, String artifactId, @Nullable String version, @Nullable String versionPattern, @Nullable String configuration, @Nullable String onlyIfUsing, @Nullable String classifier, @Nullable String extension, @Nullable String familyPattern, @Nullable Boolean acceptTransitive) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.versionPattern = versionPattern;
        this.configuration = configuration;
        this.onlyIfUsing = onlyIfUsing;
        this.classifier = classifier;
        this.extension = extension;
        this.familyPattern = familyPattern;
        this.acceptTransitive = acceptTransitive;
    }

    @Generated
    public MavenMetadataFailures getMetadataFailures() {
        return this.metadataFailures;
    }

    @Generated
    public String getGroupId() {
        return this.groupId;
    }

    @Generated
    public String getArtifactId() {
        return this.artifactId;
    }

    @Generated
    public @Nullable String getVersion() {
        return this.version;
    }

    @Generated
    public @Nullable String getVersionPattern() {
        return this.versionPattern;
    }

    @Generated
    public @Nullable String getConfiguration() {
        return this.configuration;
    }

    @Generated
    public @Nullable String getOnlyIfUsing() {
        return this.onlyIfUsing;
    }

    @Generated
    public @Nullable String getClassifier() {
        return this.classifier;
    }

    @Generated
    public @Nullable String getExtension() {
        return this.extension;
    }

    @Generated
    public @Nullable String getFamilyPattern() {
        return this.familyPattern;
    }

    @Generated
    public @Nullable Boolean getAcceptTransitive() {
        return this.acceptTransitive;
    }

    @NonNull
    @Generated
    public String toString() {
        return "AddDependency(metadataFailures=" + this.getMetadataFailures() + ", groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", version=" + this.getVersion() + ", versionPattern=" + this.getVersionPattern() + ", configuration=" + this.getConfiguration() + ", onlyIfUsing=" + this.getOnlyIfUsing() + ", classifier=" + this.getClassifier() + ", extension=" + this.getExtension() + ", familyPattern=" + this.getFamilyPattern() + ", acceptTransitive=" + this.getAcceptTransitive() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddDependency)) {
            return false;
        }
        AddDependency other = (AddDependency)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$acceptTransitive = this.getAcceptTransitive();
        Boolean other$acceptTransitive = other.getAcceptTransitive();
        if (this$acceptTransitive == null ? other$acceptTransitive != null : !((Object)this$acceptTransitive).equals(other$acceptTransitive)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$versionPattern = this.getVersionPattern();
        String other$versionPattern = other.getVersionPattern();
        if (this$versionPattern == null ? other$versionPattern != null : !this$versionPattern.equals(other$versionPattern)) {
            return false;
        }
        String this$configuration = this.getConfiguration();
        String other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !this$configuration.equals(other$configuration)) {
            return false;
        }
        String this$onlyIfUsing = this.getOnlyIfUsing();
        String other$onlyIfUsing = other.getOnlyIfUsing();
        if (this$onlyIfUsing == null ? other$onlyIfUsing != null : !this$onlyIfUsing.equals(other$onlyIfUsing)) {
            return false;
        }
        String this$classifier = this.getClassifier();
        String other$classifier = other.getClassifier();
        if (this$classifier == null ? other$classifier != null : !this$classifier.equals(other$classifier)) {
            return false;
        }
        String this$extension = this.getExtension();
        String other$extension = other.getExtension();
        if (this$extension == null ? other$extension != null : !this$extension.equals(other$extension)) {
            return false;
        }
        String this$familyPattern = this.getFamilyPattern();
        String other$familyPattern = other.getFamilyPattern();
        return !(this$familyPattern == null ? other$familyPattern != null : !this$familyPattern.equals(other$familyPattern));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof AddDependency;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $acceptTransitive = this.getAcceptTransitive();
        result = result * 59 + ($acceptTransitive == null ? 43 : ((Object)$acceptTransitive).hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $versionPattern = this.getVersionPattern();
        result = result * 59 + ($versionPattern == null ? 43 : $versionPattern.hashCode());
        String $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : $configuration.hashCode());
        String $onlyIfUsing = this.getOnlyIfUsing();
        result = result * 59 + ($onlyIfUsing == null ? 43 : $onlyIfUsing.hashCode());
        String $classifier = this.getClassifier();
        result = result * 59 + ($classifier == null ? 43 : $classifier.hashCode());
        String $extension = this.getExtension();
        result = result * 59 + ($extension == null ? 43 : $extension.hashCode());
        String $familyPattern = this.getFamilyPattern();
        result = result * 59 + ($familyPattern == null ? 43 : $familyPattern.hashCode());
        return result;
    }

    public static class Scanned {
        boolean usingType;
        Map<JavaProject, Set<String>> configurationsByProject = new HashMap<JavaProject, Set<String>>();
        Map<JavaProject, Set<String>> customJvmTestSuitesWithDependencies = new HashMap<JavaProject, Set<String>>();
    }
}

