/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.search;

import java.util.List;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.IsBuildGradle;
import org.openrewrite.groovy.GroovyVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.marker.SearchResult;

public final class FindDependency
extends Recipe {
    @Option(displayName="Group", description="The first part of a dependency coordinate identifying its publisher.", example="com.google.guava")
    private final String groupId;
    @Option(displayName="Artifact", description="The second part of a dependency coordinate uniquely identifying it among artifacts from the same publisher.", example="guava")
    private final String artifactId;
    @Option(displayName="Dependency configuration", description="The dependency configuration to search for dependencies in. If omitted then all configurations will be searched.", example="api", required=false)
    private final @Nullable String configuration;

    public String getDisplayName() {
        return "Find Gradle dependency";
    }

    public String getInstanceNameSuffix() {
        return String.format("`%s:%s`", this.groupId, this.artifactId);
    }

    public String getDescription() {
        return "Finds dependencies declared in `build.gradle` files. See the [reference](https://docs.gradle.org/current/userguide/java_library_plugin.html#sec:java_library_configurations_graph) on Gradle configurations or the diagram below for a description of what configuration to use. A project's compile and runtime classpath is based on these configurations.\n\n<img alt=\"Gradle compile classpath\" src=\"https://docs.gradle.org/current/userguide/img/java-library-ignore-deprecated-main.png\" width=\"200px\"/>\n A project's test classpath is based on these configurations.\n\n<img alt=\"Gradle test classpath\" src=\"https://docs.gradle.org/current/userguide/img/java-library-ignore-deprecated-test.png\" width=\"200px\"/>.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final MethodMatcher dependency = new MethodMatcher("DependencyHandlerSpec *(..)");
        return Preconditions.check(new IsBuildGradle(), (TreeVisitor)new GroovyVisitor<ExecutionContext>(){

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                List depArgs;
                if (dependency.matches((MethodCall)method) && (StringUtils.isBlank((String)FindDependency.this.configuration) || method.getSimpleName().equals(FindDependency.this.configuration)) && (depArgs = method.getArguments()).get(0) instanceof J.Literal) {
                    String gav = (String)((J.Literal)depArgs.get(0)).getValue();
                    assert (gav != null);
                    String[] parts = gav.split(":");
                    if (gav.length() >= 2 && StringUtils.matchesGlob((String)parts[0], (String)FindDependency.this.groupId) && StringUtils.matchesGlob((String)parts[1], (String)FindDependency.this.artifactId)) {
                        return (J)SearchResult.found((Tree)method);
                    }
                }
                return super.visitMethodInvocation(method, (Object)ctx);
            }
        });
    }

    @Generated
    public FindDependency(String groupId, String artifactId, @Nullable String configuration) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.configuration = configuration;
    }

    @Generated
    public String getGroupId() {
        return this.groupId;
    }

    @Generated
    public String getArtifactId() {
        return this.artifactId;
    }

    @Generated
    public @Nullable String getConfiguration() {
        return this.configuration;
    }

    @NonNull
    @Generated
    public String toString() {
        return "FindDependency(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", configuration=" + this.getConfiguration() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindDependency)) {
            return false;
        }
        FindDependency other = (FindDependency)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$configuration = this.getConfiguration();
        String other$configuration = other.getConfiguration();
        return !(this$configuration == null ? other$configuration != null : !this$configuration.equals(other$configuration));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof FindDependency;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : $configuration.hashCode());
        return result;
    }
}

