/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.hcl;

import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.hcl.HclVisitor;
import org.openrewrite.hcl.format.AttributeSpaceVisitor;
import org.openrewrite.hcl.internal.template.HclTemplateParser;
import org.openrewrite.hcl.internal.template.Substitutions;
import org.openrewrite.hcl.style.SpacesStyle;
import org.openrewrite.hcl.tree.BodyContent;
import org.openrewrite.hcl.tree.Expression;
import org.openrewrite.hcl.tree.Hcl;
import org.openrewrite.hcl.tree.HclCoordinates;
import org.openrewrite.hcl.tree.Space;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.template.SourceTemplate;

public class HclTemplate
implements SourceTemplate<Hcl, HclCoordinates> {
    private final String code;
    private final int parameterCount;
    private final Consumer<String> onAfterVariableSubstitution;
    private final HclTemplateParser templateParser;

    private HclTemplate(String code, Consumer<String> onAfterVariableSubstitution, Consumer<String> onBeforeParseTemplate) {
        this.code = code;
        this.onAfterVariableSubstitution = onAfterVariableSubstitution;
        this.parameterCount = StringUtils.countOccurrences((String)code, (String)"#{");
        this.templateParser = new HclTemplateParser(onAfterVariableSubstitution, onBeforeParseTemplate);
    }

    public static <H extends Hcl> H apply(String template, Cursor scope, HclCoordinates coordinates, Object ... parameters) {
        return HclTemplate.builder(template).build().apply(scope, coordinates, parameters);
    }

    public <H extends Hcl> H apply(Cursor scope, final HclCoordinates coordinates, Object ... parameters) {
        if (!(scope.getValue() instanceof Hcl)) {
            throw new IllegalArgumentException("`scope` must point to a Hcl instance.");
        }
        if (parameters.length != this.parameterCount) {
            throw new IllegalArgumentException("This template requires " + this.parameterCount + " parameters.");
        }
        final Substitutions substitutions = new Substitutions(this.code, parameters);
        final String substitutedTemplate = substitutions.substitute();
        this.onAfterVariableSubstitution.accept(substitutedTemplate);
        final Hcl insertionPoint = coordinates.getTree();
        final Space.Location loc = coordinates.getSpaceLocation();
        Hcl h = (Hcl)new HclVisitor<Integer>(){

            @Override
            public Hcl visitConfigFile(Hcl.ConfigFile configFile, Integer p) {
                Hcl.ConfigFile c = (Hcl.ConfigFile)super.visitConfigFile(configFile, p);
                if (loc.equals((Object)Space.Location.CONFIG_FILE_EOF)) {
                    List<BodyContent> gen = substitutions.unsubstitute(HclTemplate.this.templateParser.parseBodyContent(substitutedTemplate));
                    if (coordinates.getComparator() != null) {
                        for (int i2 = 0; i2 < gen.size(); ++i2) {
                            BodyContent g = gen.get(i2);
                            BodyContent formatted = i2 == 0 ? (c.getBody().isEmpty() ? g : g.withPrefix(Space.format("\n"))) : g;
                            c = c.withBody(ListUtils.insertInOrder(c.getBody(), (Object)this.autoFormat(formatted, p, this.getCursor()), coordinates.getComparator()));
                        }
                    } else {
                        c = c.withBody(ListUtils.concatAll(c.getBody(), (List)ListUtils.map(gen, (i, s) -> this.autoFormat(i == 0 ? s.withPrefix(Space.format("\n")) : s, p, this.getCursor()))));
                    }
                } else if (loc.equals((Object)Space.Location.CONFIG_FILE)) {
                    List<BodyContent> gen = substitutions.unsubstitute(HclTemplate.this.templateParser.parseBodyContent(substitutedTemplate));
                    c = c.withBody(ListUtils.concatAll((List)ListUtils.map(gen, (i, s) -> this.autoFormat(s, p, this.getCursor())), Space.formatFirstPrefix(c.getBody(), c.getBody().isEmpty() ? Space.EMPTY : c.getBody().get(0).getPrefix().withWhitespace("\n"))));
                }
                return c;
            }

            @Override
            public Hcl visitBlock(Hcl.Block block, Integer p) {
                Hcl.Block b = (Hcl.Block)super.visitBlock(block, p);
                if (loc.equals((Object)Space.Location.BLOCK_CLOSE)) {
                    if (b.isScope(insertionPoint)) {
                        List<BodyContent> gen = substitutions.unsubstitute(HclTemplate.this.templateParser.parseBodyContent(substitutedTemplate));
                        if (coordinates.getComparator() != null) {
                            for (BodyContent ignored : gen) {
                                b = b.withBody(ListUtils.insertInOrder(b.getBody(), (Object)this.autoFormat(gen.get(0), p, this.getCursor()), coordinates.getComparator()));
                            }
                            return b;
                        }
                        b = b.withBody(ListUtils.concatAll(block.getBody(), (List)ListUtils.map(gen, (i, s) -> this.autoFormat(i == 0 ? s.withPrefix(Space.format("\n")) : s, p, this.getCursor()))));
                        Hcl.ConfigFile cf = (Hcl.ConfigFile)this.getCursor().firstEnclosingOrThrow(Hcl.ConfigFile.class);
                        b = (Hcl.Block)new AttributeSpaceVisitor(Optional.ofNullable((SpacesStyle)cf.getStyle(SpacesStyle.class)).orElse(SpacesStyle.DEFAULT)).visit(b, p, this.getCursor().getParentOrThrow());
                        assert (b != null);
                    }
                } else if (loc.equals((Object)Space.Location.BLOCK) && b.isScope(insertionPoint)) {
                    b = (Hcl.Block)this.autoFormat(HclTemplate.this.templateParser.parseBodyContent(substitutedTemplate).get(0), p, this.getCursor().getParentOrThrow());
                }
                return b;
            }

            @Override
            public Hcl visitExpression(Expression expression, Integer p) {
                Hcl e = super.visitExpression(expression, p);
                if (loc.equals((Object)Space.Location.EXPRESSION_PREFIX) && e.isScope(insertionPoint)) {
                    e = HclTemplate.this.templateParser.parseExpression(substitutedTemplate).withPrefix(expression.getPrefix());
                }
                return e;
            }
        }.visit((Tree)scope.getValue(), 0, scope.getParentOrThrow());
        assert (h != null);
        return (H)h;
    }

    public static Builder builder(String code) {
        return new Builder(code);
    }

    public static class Builder {
        private final String code;
        private Consumer<String> onAfterVariableSubstitution = s -> {};
        private Consumer<String> onBeforeParseTemplate = s -> {};

        Builder(String code) {
            this.code = code.trim();
        }

        public Builder doAfterVariableSubstitution(Consumer<String> afterVariableSubstitution) {
            this.onAfterVariableSubstitution = afterVariableSubstitution;
            return this;
        }

        public Builder doBeforeParseTemplate(Consumer<String> beforeParseTemplate) {
            this.onBeforeParseTemplate = beforeParseTemplate;
            return this;
        }

        public HclTemplate build() {
            return new HclTemplate(this.code, this.onAfterVariableSubstitution, this.onBeforeParseTemplate);
        }
    }
}

