/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;

public class NoDoubleBraceInitialization
extends Recipe {
    private static final JavaType MAP_TYPE = JavaType.buildType("java.util.Map");
    private static final JavaType LIST_TYPE = JavaType.buildType("java.util.List");
    private static final JavaType SET_TYPE = JavaType.buildType("java.util.Set");

    public String getDisplayName() {
        return "No double brace initialization";
    }

    public String getDescription() {
        return "Replace `List`, `Map`, and `Set` double brace initialization with an initialization block.";
    }

    public Set<String> getTags() {
        return new LinkedHashSet<String>(Arrays.asList("RSPEC-1171", "RSPEC-3599"));
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(30L);
    }

    protected JavaIsoVisitor<ExecutionContext> getSingleSourceApplicableTest() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public JavaSourceFile visitJavaSourceFile(JavaSourceFile cu, ExecutionContext executionContext) {
                this.doAfterVisit(new UsesType("java.util.Map"));
                this.doAfterVisit(new UsesType("java.util.List"));
                this.doAfterVisit(new UsesType("java.util.Set"));
                return cu;
            }
        };
    }

    public NoDoubleBraceInitializationVisitor getVisitor() {
        return new NoDoubleBraceInitializationVisitor();
    }

    private static class NoDoubleBraceInitializationVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private NoDoubleBraceInitializationVisitor() {
        }

        private boolean isSupportedDoubleBraceInitialization(J.NewClass nc) {
            if (this.getCursor().getParent() == null || this.getCursor().getParent().firstEnclosing(J.class) instanceof J.MethodInvocation || this.getCursor().getParent().firstEnclosing(J.class) instanceof J.NewClass) {
                return false;
            }
            if (nc.getBody() != null && !nc.getBody().getStatements().isEmpty() && nc.getBody().getStatements().get(0) instanceof J.Block && this.getCursor().getParent(3) != null) {
                return TypeUtils.isAssignableTo(MAP_TYPE, nc.getType()) || TypeUtils.isAssignableTo(LIST_TYPE, nc.getType()) || TypeUtils.isAssignableTo(SET_TYPE, nc.getType());
            }
            return false;
        }

        @Override
        public J.NewClass visitNewClass(J.NewClass newClass, ExecutionContext executionContext) {
            J nc = super.visitNewClass(newClass, executionContext);
            if (this.isSupportedDoubleBraceInitialization(newClass)) {
                Cursor parentBlockCursor = this.getCursor().dropParentUntil(J.Block.class::isInstance);
                J.VariableDeclarations.NamedVariable var = (J.VariableDeclarations.NamedVariable)this.getCursor().firstEnclosing(J.VariableDeclarations.NamedVariable.class);
                List<Statement> initStatements = ((J.Block)((J.NewClass)nc).getBody().getStatements().get(0)).getStatements();
                if (var != null && parentBlockCursor.getParent() != null) {
                    if (parentBlockCursor.getParent().getValue() instanceof J.ClassDeclaration) {
                        JavaType.FullyQualified fq = TypeUtils.asFullyQualified(((J.NewClass)nc).getType());
                        if (fq != null && fq.getSupertype() != null) {
                            Cursor varDeclsCursor = this.getCursor().dropParentUntil(parent -> parent instanceof J.VariableDeclarations);
                            Cursor namedVarCursor = this.getCursor().dropParentUntil(J.VariableDeclarations.NamedVariable.class::isInstance);
                            namedVarCursor.putMessage("DROP_INITIALIZER", (Object)Boolean.TRUE);
                            fq = fq.getSupertype();
                            String newInitializer = " new " + fq.getClassName() + "<>();";
                            JavaTemplate template = JavaTemplate.builder(() -> ((NoDoubleBraceInitializationVisitor)this).getCursor(), newInitializer).imports(fq.getFullyQualifiedName()).build();
                            nc = (J.NewClass)nc.withTemplate(template, ((J.NewClass)nc).getCoordinates().replace(), new Object[0]);
                            initStatements = this.addSelectToInitStatements(initStatements, var.getName(), executionContext);
                            initStatements.add(0, new J.Assignment(UUID.randomUUID(), Space.EMPTY, Markers.EMPTY, var.getName().withId(UUID.randomUUID()), JLeftPadded.build(nc), fq));
                            ((HashMap)parentBlockCursor.computeMessageIfAbsent("INIT_STATEMENTS", v -> new HashMap())).put((Statement)varDeclsCursor.getValue(), initStatements);
                        }
                    } else if (parentBlockCursor.getParent().getValue() instanceof J.MethodDeclaration) {
                        initStatements = this.addSelectToInitStatements(initStatements, var.getName(), executionContext);
                        Cursor varDeclsCursor = this.getCursor().dropParentUntil(parent -> parent instanceof J.VariableDeclarations);
                        ((HashMap)parentBlockCursor.computeMessageIfAbsent("METHOD_DECL_STATEMENTS", v -> new HashMap())).put((Statement)varDeclsCursor.getValue(), initStatements);
                        nc = ((J.NewClass)nc).withBody(null);
                    }
                }
            }
            return nc;
        }

        private List<Statement> addSelectToInitStatements(List<Statement> statements, J.Identifier identifier, ExecutionContext ctx) {
            AddSelectVisitor selectVisitor = new AddSelectVisitor(identifier);
            ArrayList<Statement> statementList = new ArrayList<Statement>();
            for (Statement statement : statements) {
                statementList.add((Statement)selectVisitor.visit(statement, ctx));
            }
            return statementList;
        }

        @Override
        public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, ExecutionContext executionContext) {
            J var = super.visitVariable(variable, executionContext);
            if (this.getCursor().pollMessage("DROP_INITIALIZER") != null) {
                var = ((J.VariableDeclarations.NamedVariable)var).withInitializer(null);
            }
            return var;
        }

        @Override
        public J.Block visitBlock(J.Block block, ExecutionContext ctx) {
            J bl;
            block3: {
                Map methodInitStatemnts;
                block2: {
                    bl = super.visitBlock(block, ctx);
                    Map initStatements = (Map)this.getCursor().pollMessage("INIT_STATEMENTS");
                    methodInitStatemnts = (Map)this.getCursor().pollMessage("METHOD_DECL_STATEMENTS");
                    if (initStatements == null) break block2;
                    for (Map.Entry objectListEntry : initStatements.entrySet()) {
                        Object statement = objectListEntry.getKey();
                        int statementIndex = ((J.Block)bl).getStatements().indexOf(statement);
                        if (statementIndex <= -1) continue;
                        JRightPadded<Boolean> isStatic = objectListEntry.getKey() instanceof J.VariableDeclarations && J.Modifier.hasModifier(((J.VariableDeclarations)statement).getModifiers(), J.Modifier.Type.Static) ? JRightPadded.build(true).withAfter(Space.format(" ")) : JRightPadded.build(false);
                        J.Block initBlock = new J.Block(Tree.randomId(), Space.EMPTY, Markers.EMPTY, isStatic, ((List)objectListEntry.getValue()).stream().map(JRightPadded::build).collect(Collectors.toList()), Space.EMPTY);
                        bl = this.maybeAutoFormat(bl, ((J.Block)bl).withStatements(ListUtils.insertAll(((J.Block)bl).getStatements(), (int)(statementIndex + 1), Collections.singletonList(initBlock))), initBlock, ctx, this.getCursor().getParent(2));
                    }
                    break block3;
                }
                if (methodInitStatemnts == null) break block3;
                for (Map.Entry objectListEntry : methodInitStatemnts.entrySet()) {
                    int statementIndex = ((J.Block)bl).getStatements().indexOf(objectListEntry.getKey());
                    if (statementIndex <= -1) continue;
                    bl = this.maybeAutoFormat(bl, ((J.Block)bl).withStatements(ListUtils.insertAll(((J.Block)bl).getStatements(), (int)(statementIndex + 1), (List)((List)objectListEntry.getValue()))), (J)((List)objectListEntry.getValue()).get(((List)objectListEntry.getValue()).size() - 1), ctx, this.getCursor().getParent());
                }
            }
            return bl;
        }

        private static class AddSelectVisitor
        extends JavaIsoVisitor<ExecutionContext> {
            private final J.Identifier identifier;

            public AddSelectVisitor(J.Identifier identifier) {
                this.identifier = identifier;
            }

            @Override
            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
                J mi = super.visitMethodInvocation(method, executionContext);
                if (((J.MethodInvocation)mi).getMethodType() != null && TypeUtils.isAssignableTo(this.identifier.getFieldType(), (JavaType)((J.MethodInvocation)mi).getMethodType().getDeclaringType()) && (((J.MethodInvocation)mi).getSelect() == null || ((J.MethodInvocation)mi).getSelect() instanceof J.Identifier && "this".equals(((J.Identifier)((J.MethodInvocation)mi).getSelect()).getSimpleName()))) {
                    return ((J.MethodInvocation)mi).withSelect(this.identifier);
                }
                return mi;
            }
        }
    }
}

