/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.text.StringEscapeUtils;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeUtils;

public class UseStringReplace
extends Recipe {
    public String getDisplayName() {
        return "Use `String::replace()` when fist parameter is not a real regular expression";
    }

    public String getDescription() {
        return "When `String::replaceAll` is used, the first argument should be a real regular expression. If it\u2019s not the case, `String::replace` does exactly the same thing as `String::replaceAll` without the performance drawback of the regex.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-5361");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(2L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new UseStringReplaceVisitor();
    }

    private static class UseStringReplaceVisitor
    extends JavaVisitor<ExecutionContext> {
        private static final MethodMatcher REPLACE_ALL = new MethodMatcher("java.lang.String replaceAll(..)");
        private static final Pattern ESCAPED_CHARACTER = Pattern.compile("\\\\\\.");
        private static final Pattern METACHARACTERS = Pattern.compile("[(\\[{\\\\^\\-=$!|\\]})?*+.]");
        private static final Pattern CHARACTER_CLASSES = Pattern.compile("\\\\d|\\\\D|\\\\s|\\\\S|\\\\w|\\\\W");

        private UseStringReplaceVisitor() {
        }

        @Override
        public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext context) {
            J.Literal literal;
            String value;
            Expression firstArgument;
            MethodCall invocation = (J.MethodInvocation)super.visitMethodInvocation(method, context);
            if (REPLACE_ALL.matches((J.MethodInvocation)invocation) && this.isStringLiteral(firstArgument = invocation.getArguments().get(0)) && Objects.nonNull(value = (String)(literal = (J.Literal)firstArgument).getValue()) && !this.mayBeRegExp(value)) {
                String unEscapedLiteral = this.unEscapeCharacters(value);
                invocation = invocation.withName(invocation.getName().withSimpleName("replace")).withArguments(ListUtils.mapFirst(invocation.getArguments(), arg -> ((J.Literal)arg).withValue(unEscapedLiteral).withValueSource(String.format("\"%s\"", StringEscapeUtils.escapeJava((String)unEscapedLiteral)))));
            }
            return invocation;
        }

        private boolean isStringLiteral(Expression expression) {
            return expression instanceof J.Literal && TypeUtils.isString(((J.Literal)expression).getType());
        }

        private boolean mayBeRegExp(String argument) {
            String cleanedValue = ESCAPED_CHARACTER.matcher(argument).replaceAll("");
            return METACHARACTERS.matcher(cleanedValue).find() || CHARACTER_CLASSES.matcher(cleanedValue).find();
        }

        private String unEscapeCharacters(String argument) {
            return argument.replace("\\\\", "\\").replace("\\\"", "\"").replace("\\'", "'").replace("\\", "");
        }
    }
}

