/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.style;

import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaStyle;
import org.openrewrite.java.style.IntelliJ;
import org.openrewrite.style.Style;
import org.openrewrite.style.StyleHelper;

public final class TabsAndIndentsStyle
implements JavaStyle {
    private final Boolean useTabCharacter;
    private final Integer tabSize;
    private final Integer indentSize;
    private final Integer continuationIndent;
    private final Boolean indentsRelativeToExpressionStart;
    private final MethodDeclarationParameters methodDeclarationParameters;

    public Style applyDefaults() {
        return (Style)StyleHelper.merge((Object)IntelliJ.tabsAndIndents(), (Object)this);
    }

    public TabsAndIndentsStyle(Boolean useTabCharacter, Integer tabSize, Integer indentSize, Integer continuationIndent, Boolean indentsRelativeToExpressionStart, MethodDeclarationParameters methodDeclarationParameters) {
        this.useTabCharacter = useTabCharacter;
        this.tabSize = tabSize;
        this.indentSize = indentSize;
        this.continuationIndent = continuationIndent;
        this.indentsRelativeToExpressionStart = indentsRelativeToExpressionStart;
        this.methodDeclarationParameters = methodDeclarationParameters;
    }

    public Boolean getUseTabCharacter() {
        return this.useTabCharacter;
    }

    public Integer getTabSize() {
        return this.tabSize;
    }

    public Integer getIndentSize() {
        return this.indentSize;
    }

    public Integer getContinuationIndent() {
        return this.continuationIndent;
    }

    public Boolean getIndentsRelativeToExpressionStart() {
        return this.indentsRelativeToExpressionStart;
    }

    public MethodDeclarationParameters getMethodDeclarationParameters() {
        return this.methodDeclarationParameters;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TabsAndIndentsStyle)) {
            return false;
        }
        TabsAndIndentsStyle other = (TabsAndIndentsStyle)o;
        Boolean this$useTabCharacter = this.getUseTabCharacter();
        Boolean other$useTabCharacter = other.getUseTabCharacter();
        if (this$useTabCharacter == null ? other$useTabCharacter != null : !((Object)this$useTabCharacter).equals(other$useTabCharacter)) {
            return false;
        }
        Integer this$tabSize = this.getTabSize();
        Integer other$tabSize = other.getTabSize();
        if (this$tabSize == null ? other$tabSize != null : !((Object)this$tabSize).equals(other$tabSize)) {
            return false;
        }
        Integer this$indentSize = this.getIndentSize();
        Integer other$indentSize = other.getIndentSize();
        if (this$indentSize == null ? other$indentSize != null : !((Object)this$indentSize).equals(other$indentSize)) {
            return false;
        }
        Integer this$continuationIndent = this.getContinuationIndent();
        Integer other$continuationIndent = other.getContinuationIndent();
        if (this$continuationIndent == null ? other$continuationIndent != null : !((Object)this$continuationIndent).equals(other$continuationIndent)) {
            return false;
        }
        Boolean this$indentsRelativeToExpressionStart = this.getIndentsRelativeToExpressionStart();
        Boolean other$indentsRelativeToExpressionStart = other.getIndentsRelativeToExpressionStart();
        if (this$indentsRelativeToExpressionStart == null ? other$indentsRelativeToExpressionStart != null : !((Object)this$indentsRelativeToExpressionStart).equals(other$indentsRelativeToExpressionStart)) {
            return false;
        }
        MethodDeclarationParameters this$methodDeclarationParameters = this.getMethodDeclarationParameters();
        MethodDeclarationParameters other$methodDeclarationParameters = other.getMethodDeclarationParameters();
        return !(this$methodDeclarationParameters == null ? other$methodDeclarationParameters != null : !((Object)this$methodDeclarationParameters).equals(other$methodDeclarationParameters));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $useTabCharacter = this.getUseTabCharacter();
        result = result * 59 + ($useTabCharacter == null ? 43 : ((Object)$useTabCharacter).hashCode());
        Integer $tabSize = this.getTabSize();
        result = result * 59 + ($tabSize == null ? 43 : ((Object)$tabSize).hashCode());
        Integer $indentSize = this.getIndentSize();
        result = result * 59 + ($indentSize == null ? 43 : ((Object)$indentSize).hashCode());
        Integer $continuationIndent = this.getContinuationIndent();
        result = result * 59 + ($continuationIndent == null ? 43 : ((Object)$continuationIndent).hashCode());
        Boolean $indentsRelativeToExpressionStart = this.getIndentsRelativeToExpressionStart();
        result = result * 59 + ($indentsRelativeToExpressionStart == null ? 43 : ((Object)$indentsRelativeToExpressionStart).hashCode());
        MethodDeclarationParameters $methodDeclarationParameters = this.getMethodDeclarationParameters();
        result = result * 59 + ($methodDeclarationParameters == null ? 43 : ((Object)$methodDeclarationParameters).hashCode());
        return result;
    }

    @NonNull
    public String toString() {
        return "TabsAndIndentsStyle(useTabCharacter=" + this.getUseTabCharacter() + ", tabSize=" + this.getTabSize() + ", indentSize=" + this.getIndentSize() + ", continuationIndent=" + this.getContinuationIndent() + ", indentsRelativeToExpressionStart=" + this.getIndentsRelativeToExpressionStart() + ", methodDeclarationParameters=" + this.getMethodDeclarationParameters() + ")";
    }

    @NonNull
    public TabsAndIndentsStyle withUseTabCharacter(Boolean useTabCharacter) {
        return this.useTabCharacter == useTabCharacter ? this : new TabsAndIndentsStyle(useTabCharacter, this.tabSize, this.indentSize, this.continuationIndent, this.indentsRelativeToExpressionStart, this.methodDeclarationParameters);
    }

    @NonNull
    public TabsAndIndentsStyle withTabSize(Integer tabSize) {
        return this.tabSize == tabSize ? this : new TabsAndIndentsStyle(this.useTabCharacter, tabSize, this.indentSize, this.continuationIndent, this.indentsRelativeToExpressionStart, this.methodDeclarationParameters);
    }

    @NonNull
    public TabsAndIndentsStyle withIndentSize(Integer indentSize) {
        return this.indentSize == indentSize ? this : new TabsAndIndentsStyle(this.useTabCharacter, this.tabSize, indentSize, this.continuationIndent, this.indentsRelativeToExpressionStart, this.methodDeclarationParameters);
    }

    @NonNull
    public TabsAndIndentsStyle withContinuationIndent(Integer continuationIndent) {
        return this.continuationIndent == continuationIndent ? this : new TabsAndIndentsStyle(this.useTabCharacter, this.tabSize, this.indentSize, continuationIndent, this.indentsRelativeToExpressionStart, this.methodDeclarationParameters);
    }

    @NonNull
    public TabsAndIndentsStyle withIndentsRelativeToExpressionStart(Boolean indentsRelativeToExpressionStart) {
        return this.indentsRelativeToExpressionStart == indentsRelativeToExpressionStart ? this : new TabsAndIndentsStyle(this.useTabCharacter, this.tabSize, this.indentSize, this.continuationIndent, indentsRelativeToExpressionStart, this.methodDeclarationParameters);
    }

    @NonNull
    public TabsAndIndentsStyle withMethodDeclarationParameters(MethodDeclarationParameters methodDeclarationParameters) {
        return this.methodDeclarationParameters == methodDeclarationParameters ? this : new TabsAndIndentsStyle(this.useTabCharacter, this.tabSize, this.indentSize, this.continuationIndent, this.indentsRelativeToExpressionStart, methodDeclarationParameters);
    }

    public static final class MethodDeclarationParameters {
        private final Boolean alignWhenMultiple;

        public MethodDeclarationParameters(Boolean alignWhenMultiple) {
            this.alignWhenMultiple = alignWhenMultiple;
        }

        public Boolean getAlignWhenMultiple() {
            return this.alignWhenMultiple;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MethodDeclarationParameters)) {
                return false;
            }
            MethodDeclarationParameters other = (MethodDeclarationParameters)o;
            Boolean this$alignWhenMultiple = this.getAlignWhenMultiple();
            Boolean other$alignWhenMultiple = other.getAlignWhenMultiple();
            return !(this$alignWhenMultiple == null ? other$alignWhenMultiple != null : !((Object)this$alignWhenMultiple).equals(other$alignWhenMultiple));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $alignWhenMultiple = this.getAlignWhenMultiple();
            result = result * 59 + ($alignWhenMultiple == null ? 43 : ((Object)$alignWhenMultiple).hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "TabsAndIndentsStyle.MethodDeclarationParameters(alignWhenMultiple=" + this.getAlignWhenMultiple() + ")";
        }

        @NonNull
        public MethodDeclarationParameters withAlignWhenMultiple(Boolean alignWhenMultiple) {
            return this.alignWhenMultiple == alignWhenMultiple ? this : new MethodDeclarationParameters(alignWhenMultiple);
        }
    }
}

