/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.tree;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openrewrite.ExecutionContext;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.PropertyPlaceholderHelper;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenDownloadingException;
import org.openrewrite.maven.MavenDownloadingExceptions;
import org.openrewrite.maven.MavenExecutionContextView;
import org.openrewrite.maven.cache.MavenPomCache;
import org.openrewrite.maven.internal.MavenParsingException;
import org.openrewrite.maven.internal.MavenPomDownloader;
import org.openrewrite.maven.internal.VersionRequirement;
import org.openrewrite.maven.tree.Dependency;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.GroupArtifactVersion;
import org.openrewrite.maven.tree.ManagedDependency;
import org.openrewrite.maven.tree.MavenRepository;
import org.openrewrite.maven.tree.Pom;
import org.openrewrite.maven.tree.Profile;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.maven.tree.ResolvedGroupArtifactVersion;
import org.openrewrite.maven.tree.ResolvedManagedDependency;
import org.openrewrite.maven.tree.Scope;

@JsonIdentityInfo(generator=ObjectIdGenerators.IntSequenceGenerator.class, property="@ref")
public class ResolvedPom {
    public static final PropertyPlaceholderHelper placeholderHelper = new PropertyPlaceholderHelper("${", "}", null);
    private static final ResolvedPom SUPER_POM = new ResolvedPom(new Pom(null, null, null, null, null, null, Collections.emptyMap(), Collections.emptyList(), Collections.emptyList(), Collections.singletonList(MavenRepository.MAVEN_CENTRAL), Collections.emptyList(), Collections.emptyList(), null, null), Collections.emptyList());
    Pom requested;
    Iterable<String> activeProfiles;
    Map<String, String> properties;
    List<ResolvedManagedDependency> dependencyManagement;
    List<MavenRepository> initialRepositories;
    List<MavenRepository> repositories;
    List<Dependency> requestedDependencies;

    public ResolvedPom(Pom requested, Iterable<String> activeProfiles) {
        this(requested, activeProfiles, Collections.emptyMap(), Collections.emptyList(), null, Collections.emptyList(), Collections.emptyList());
    }

    @JsonCreator
    ResolvedPom(Pom requested, Iterable<String> activeProfiles, Map<String, String> properties, List<ResolvedManagedDependency> dependencyManagement, @Nullable List<MavenRepository> initialRepositories, List<MavenRepository> repositories, List<Dependency> requestedDependencies) {
        this.requested = requested;
        this.activeProfiles = activeProfiles;
        this.properties = properties;
        this.dependencyManagement = dependencyManagement;
        this.initialRepositories = initialRepositories;
        this.repositories = repositories;
        this.requestedDependencies = requestedDependencies;
    }

    public ResolvedPom deduplicate() {
        List dedupD;
        List dedupMd;
        HashSet uniqueManagedDependencies = new HashSet(this.dependencyManagement.size());
        this.dependencyManagement = dedupMd = ListUtils.map(this.dependencyManagement, dm -> uniqueManagedDependencies.add(new UniqueDependencyKey(dm.getGav(), dm.getType(), dm.getClassifier(), (Object)dm.getScope())) ? dm : null);
        uniqueManagedDependencies.clear();
        this.requestedDependencies = dedupD = ListUtils.map(this.requestedDependencies, d -> uniqueManagedDependencies.add(new UniqueDependencyKey(d.getGav(), d.getType(), d.getClassifier(), d.getScope())) ? d : null);
        return this;
    }

    public ResolvedPom resolve(ExecutionContext ctx, MavenPomDownloader downloader) throws MavenDownloadingException {
        ResolvedPom resolved = new ResolvedPom(this.requested, this.activeProfiles, Collections.emptyMap(), Collections.emptyList(), this.initialRepositories, Collections.emptyList(), Collections.emptyList()).resolver(ctx, downloader).resolve();
        for (Map.Entry<String, String> property : resolved.getProperties().entrySet()) {
            if (property.getValue() == null || property.getValue().equals(this.properties.get(property.getKey()))) continue;
            return resolved;
        }
        List<Dependency> resolvedRequestedDependencies = resolved.getRequestedDependencies();
        if (this.requestedDependencies.size() != resolvedRequestedDependencies.size()) {
            return resolved;
        }
        for (int i = 0; i < resolvedRequestedDependencies.size(); ++i) {
            if (this.requestedDependencies.get(i).equals(resolvedRequestedDependencies.get(i))) continue;
            return resolved;
        }
        List<ResolvedManagedDependency> resolvedDependencyManagement = resolved.getDependencyManagement();
        if (this.dependencyManagement.size() != resolvedDependencyManagement.size()) {
            return resolved;
        }
        for (int i = 0; i < resolvedDependencyManagement.size(); ++i) {
            if (this.dependencyManagement.get(i).equals(resolvedDependencyManagement.get(i))) continue;
            return resolved;
        }
        List<MavenRepository> resolvedRepositories = resolved.getRepositories();
        if (this.repositories.size() != resolvedRepositories.size()) {
            return resolved;
        }
        for (int i = 0; i < resolvedRepositories.size(); ++i) {
            if (this.repositories.get(i).equals(resolvedRepositories.get(i))) continue;
            return resolved;
        }
        return this;
    }

    Resolver resolver(ExecutionContext ctx, MavenPomDownloader downloader) {
        return new Resolver(ctx, downloader);
    }

    public ResolvedGroupArtifactVersion getGav() {
        return this.requested.getGav();
    }

    public String getGroupId() {
        return this.requested.getGroupId();
    }

    public String getArtifactId() {
        return this.requested.getArtifactId();
    }

    public String getVersion() {
        return this.requested.getVersion();
    }

    @Nullable
    public String getDatedSnapshotVersion() {
        return this.requested.getDatedSnapshotVersion();
    }

    public String getPackaging() {
        return this.requested.getPackaging() == null ? "jar" : this.requested.getPackaging();
    }

    @Nullable
    public String getValue(@Nullable String value) {
        if (value == null) {
            return null;
        }
        return placeholderHelper.replacePlaceholders(value, this::getProperty);
    }

    @Nullable
    private String getProperty(@Nullable String property) {
        if (property == null) {
            return null;
        }
        switch (property) {
            case "groupId": 
            case "project.groupId": 
            case "pom.groupId": {
                return this.requested.getGroupId();
            }
            case "project.parent.groupId": {
                return this.requested.getParent() != null ? this.requested.getParent().getGroupId() : null;
            }
            case "artifactId": 
            case "project.artifactId": 
            case "pom.artifactId": {
                return this.requested.getArtifactId();
            }
            case "project.parent.artifactId": {
                return this.requested.getParent() == null ? null : this.requested.getParent().getArtifactId();
            }
            case "version": 
            case "project.version": 
            case "pom.version": {
                return this.requested.getVersion();
            }
            case "project.parent.version": {
                return this.requested.getParent() != null ? this.requested.getParent().getVersion() : null;
            }
        }
        return System.getProperty(property, this.properties.get(property));
    }

    @Nullable
    public String getManagedVersion(String groupId, String artifactId, @Nullable String type, @Nullable String classifier) {
        for (ResolvedManagedDependency dm : this.dependencyManagement) {
            if (!dm.matches(groupId, artifactId, type, classifier)) continue;
            return this.getValue(dm.getVersion());
        }
        return null;
    }

    public List<GroupArtifact> getManagedExclusions(String groupId, String artifactId, @Nullable String type, @Nullable String classifier) {
        for (ResolvedManagedDependency dm : this.dependencyManagement) {
            if (!dm.matches(groupId, artifactId, type, classifier)) continue;
            return dm.getExclusions() == null ? Collections.emptyList() : dm.getExclusions();
        }
        return Collections.emptyList();
    }

    @Nullable
    public Scope getManagedScope(String groupId, String artifactId, @Nullable String type, @Nullable String classifier) {
        for (ResolvedManagedDependency dm : this.dependencyManagement) {
            if (!dm.matches(groupId, artifactId, type, classifier)) continue;
            return dm.getScope();
        }
        return null;
    }

    public GroupArtifactVersion getValues(GroupArtifactVersion gav) {
        return gav.withGroupId(this.getValue(gav.getGroupId())).withArtifactId(this.getValue(gav.getArtifactId())).withVersion(this.getValue(gav.getVersion()));
    }

    public GroupArtifact getValues(GroupArtifact ga) {
        return ga.withGroupId(this.getValue(ga.getGroupId())).withArtifactId(this.getValue(ga.getArtifactId()));
    }

    public List<ResolvedDependency> resolveDependencies(Scope scope, MavenPomDownloader downloader, ExecutionContext ctx) throws MavenDownloadingExceptions {
        return this.resolveDependencies(scope, new HashMap<GroupArtifact, VersionRequirement>(), downloader, ctx);
    }

    public List<ResolvedDependency> resolveDependencies(Scope scope, Map<GroupArtifact, VersionRequirement> requirements, MavenPomDownloader downloader, ExecutionContext ctx) throws MavenDownloadingExceptions {
        ArrayList<ResolvedDependency> dependencies = new ArrayList<ResolvedDependency>();
        ArrayList<DependencyAndDependent> dependenciesAtDepth = new ArrayList<DependencyAndDependent>();
        for (Dependency requestedDependency : this.getRequestedDependencies()) {
            Dependency d = this.getValues(requestedDependency, 0);
            Scope dScope = Scope.fromName(d.getScope());
            if (dScope != scope && !dScope.isInClasspathOf(scope)) continue;
            dependenciesAtDepth.add(new DependencyAndDependent(requestedDependency, Scope.Compile, null, requestedDependency, this));
        }
        MavenDownloadingExceptions exceptions = null;
        int depth = 0;
        while (!dependenciesAtDepth.isEmpty()) {
            ArrayList<DependencyAndDependent> dependenciesAtNextDepth = new ArrayList<DependencyAndDependent>();
            for (DependencyAndDependent dd : dependenciesAtDepth) {
                Dependency d = dd.getDefinedIn().getValues(dd.getDependency(), depth);
                d = this.getValues(d, depth);
                try {
                    VersionRequirement newRequirement;
                    if (d.getVersion() == null) {
                        throw new MavenDownloadingException("No version provided", null, dd.getDependency().getGav());
                    }
                    if (d.getType() != null && !"jar".equals(d.getType()) && !"pom".equals(d.getType())) continue;
                    GroupArtifact ga = new GroupArtifact(d.getGroupId(), d.getArtifactId());
                    VersionRequirement existingRequirement = requirements.get(ga);
                    if (existingRequirement == null) {
                        newRequirement = VersionRequirement.fromVersion(d.getVersion(), depth);
                        requirements.put(ga, newRequirement);
                        String newRequiredVersion = newRequirement.resolve(ga, downloader, this.getRepositories());
                        if (newRequiredVersion == null) {
                            throw new MavenParsingException("Could not resolve version for [" + ga + "] matching version requirements " + newRequirement);
                        }
                        d = d.withGav(d.getGav().withVersion(newRequiredVersion));
                    } else {
                        newRequirement = existingRequirement.addRequirement(d.getVersion());
                        requirements.put(ga, newRequirement);
                        String existingRequiredVersion = existingRequirement.resolve(ga, downloader, this.getRepositories());
                        String newRequiredVersion = newRequirement.resolve(ga, downloader, this.getRepositories());
                        if (newRequiredVersion == null) {
                            throw new MavenParsingException("Could not resolve version for [" + ga + "] matching version requirements " + newRequirement);
                        }
                        d = d.withGav(d.getGav().withVersion(newRequiredVersion));
                        if (!Objects.equals(existingRequiredVersion, newRequiredVersion)) {
                            MavenExecutionContextView.view(ctx).getResolutionListener().clear();
                            return this.resolveDependencies(scope, requirements, downloader, ctx);
                        }
                        if (this.contains(dependencies, ga, d.getClassifier())) continue;
                    }
                    if (d.getGav().getGroupId() != null && d.getGav().getGroupId().startsWith("${") && d.getGav().getGroupId().endsWith("}") || d.getGav().getArtifactId().startsWith("${") && d.getGav().getArtifactId().endsWith("}") || d.getGav().getVersion() != null && d.getGav().getVersion().startsWith("${") && d.getGav().getVersion().endsWith("}")) {
                        throw new MavenDownloadingException("Could not resolve property", null, d.getGav());
                    }
                    Pom dPom = downloader.download(d.getGav(), null, dd.definedIn, this.getRepositories());
                    MavenPomCache cache = MavenExecutionContextView.view(ctx).getPomCache();
                    ResolvedPom resolvedPom = cache.getResolvedDependencyPom(dPom.getGav());
                    if (resolvedPom == null) {
                        resolvedPom = new ResolvedPom(dPom, this.getActiveProfiles(), Collections.emptyMap(), Collections.emptyList(), this.initialRepositories, Collections.emptyList(), Collections.emptyList());
                        resolvedPom.resolver(ctx, downloader).resolveParentsRecursively(dPom);
                        cache.putResolvedDependencyPom(dPom.getGav(), resolvedPom);
                    }
                    ResolvedDependency resolved = new ResolvedDependency(dPom.getRepository(), resolvedPom.getGav(), dd.getDependency(), Collections.emptyList(), resolvedPom.getRequested().getLicenses(), resolvedPom.getValue(dd.getDependency().getType()), resolvedPom.getValue(dd.getDependency().getClassifier()), Boolean.valueOf(resolvedPom.getValue(dd.getDependency().getOptional())), depth);
                    MavenExecutionContextView.view(ctx).getResolutionListener().dependency(scope, resolved, dd.getDefinedIn());
                    ResolvedDependency includedBy = dd.getDependent();
                    if (includedBy != null) {
                        if (includedBy.getDependencies().isEmpty()) {
                            includedBy.unsafeSetDependencies(new ArrayList<ResolvedDependency>());
                        }
                        includedBy.getDependencies().add(resolved);
                    }
                    dependencies.add(resolved);
                    block5: for (Dependency d2 : resolvedPom.getRequestedDependencies()) {
                        Scope d2Scope;
                        String optional;
                        if (d2.getGroupId() == null) {
                            d2 = d2.withGav(d2.getGav().withGroupId(resolvedPom.getGroupId()));
                        }
                        if ((optional = resolvedPom.getValue(d2.getOptional())) != null && Boolean.parseBoolean(optional.trim())) continue;
                        if (d.getExclusions() != null) {
                            for (GroupArtifact exclusion : d.getExclusions()) {
                                if (!StringUtils.matchesGlob((String)this.getValue(d2.getGroupId()), (String)this.getValue(exclusion.getGroupId())) || !StringUtils.matchesGlob((String)this.getValue(d2.getArtifactId()), (String)this.getValue(exclusion.getArtifactId()))) continue;
                                continue block5;
                            }
                        }
                        if (!(d2Scope = this.getDependencyScope(d2, resolvedPom)).isInClasspathOf(dd.getScope())) continue;
                        dependenciesAtNextDepth.add(new DependencyAndDependent(d2, d2Scope, resolved, dd.getRootDependent(), resolvedPom));
                    }
                }
                catch (MavenDownloadingException e) {
                    exceptions = MavenDownloadingExceptions.append(exceptions, e.setRoot(dd.getRootDependent().getGav()));
                }
            }
            dependenciesAtDepth = dependenciesAtNextDepth;
            ++depth;
        }
        if (exceptions != null) {
            throw exceptions;
        }
        return dependencies;
    }

    private boolean contains(List<ResolvedDependency> dependencies, GroupArtifact ga, @Nullable String classifier) {
        for (ResolvedDependency it : dependencies) {
            if (!it.getGroupId().equals(ga.getGroupId()) || !it.getArtifactId().equals(ga.getArtifactId()) || !Objects.equals(classifier, it.getClassifier())) continue;
            return true;
        }
        return false;
    }

    private Scope getDependencyScope(Dependency d2, ResolvedPom containingPom) {
        Scope scopeInContainingPom;
        if (d2.getScope() != null) {
            scopeInContainingPom = Scope.fromName(this.getValue(d2.getScope()));
        } else {
            scopeInContainingPom = containingPom.getManagedScope(this.getValue(d2.getGroupId()), this.getValue(d2.getArtifactId()), this.getValue(d2.getType()), this.getValue(d2.getClassifier()));
            if (scopeInContainingPom == null) {
                scopeInContainingPom = Scope.Compile;
            }
        }
        Scope scopeInThisProject = this.getManagedScope(this.getValue(d2.getGroupId()), this.getValue(d2.getArtifactId()), this.getValue(d2.getType()), this.getValue(d2.getClassifier()));
        if (scopeInThisProject == null) {
            scopeInThisProject = Scope.Compile;
        }
        return scopeInContainingPom.isInClasspathOf(scopeInThisProject) ? scopeInThisProject : scopeInContainingPom;
    }

    private Dependency getValues(Dependency dep, int depth) {
        Scope parsedScope;
        Dependency d = dep.withGav(this.getValues(dep.getGav())).withScope(this.getValue(dep.getScope()));
        if (d.getGroupId() == null) {
            return d;
        }
        String version = d.getVersion();
        if ((d.getVersion() == null || depth > 0) && (version = this.getManagedVersion(d.getGroupId(), d.getArtifactId(), d.getType(), d.getClassifier())) == null) {
            version = d.getVersion();
        }
        String scope = d.getScope() == null ? ((parsedScope = this.getManagedScope(d.getGroupId(), d.getArtifactId(), d.getType(), d.getClassifier())) == null ? null : parsedScope.toString().toLowerCase()) : this.getValue(d.getScope());
        List<GroupArtifact> managedExclusions = this.getManagedExclusions(d.getGroupId(), d.getArtifactId(), d.getType(), d.getClassifier());
        if (!managedExclusions.isEmpty()) {
            d = d.withExclusions(ListUtils.concatAll(d.getExclusions(), managedExclusions));
        }
        if (d.getClassifier() != null) {
            d = d.withClassifier(this.getValue(d.getClassifier()));
        }
        if (d.getType() != null) {
            d = d.withType(this.getValue(d.getType()));
        }
        return d.withGav(d.getGav().withVersion(version)).withScope(scope);
    }

    public Pom getRequested() {
        return this.requested;
    }

    public Iterable<String> getActiveProfiles() {
        return this.activeProfiles;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public List<ResolvedManagedDependency> getDependencyManagement() {
        return this.dependencyManagement;
    }

    public List<MavenRepository> getInitialRepositories() {
        return this.initialRepositories;
    }

    public List<MavenRepository> getRepositories() {
        return this.repositories;
    }

    public List<Dependency> getRequestedDependencies() {
        return this.requestedDependencies;
    }

    @NonNull
    public ResolvedPom withRequested(Pom requested) {
        return this.requested == requested ? this : new ResolvedPom(requested, this.activeProfiles, this.properties, this.dependencyManagement, this.initialRepositories, this.repositories, this.requestedDependencies);
    }

    @NonNull
    public ResolvedPom withActiveProfiles(Iterable<String> activeProfiles) {
        return this.activeProfiles == activeProfiles ? this : new ResolvedPom(this.requested, activeProfiles, this.properties, this.dependencyManagement, this.initialRepositories, this.repositories, this.requestedDependencies);
    }

    final class Resolver {
        private final ExecutionContext ctx;
        private final MavenPomDownloader downloader;

        public ResolvedPom resolve() throws MavenDownloadingException {
            this.resolveParentsRecursively(ResolvedPom.this.requested);
            return ResolvedPom.this;
        }

        void resolveParentsRecursively(Pom requested) throws MavenDownloadingException {
            ArrayList<Pom> pomAncestry = new ArrayList<Pom>();
            pomAncestry.add(requested);
            if (ResolvedPom.this.initialRepositories != null) {
                this.mergeRepositories(ResolvedPom.this.initialRepositories);
            }
            this.resolveParentPropertiesAndRepositoriesRecursively(pomAncestry);
            if (ResolvedPom.this.initialRepositories == null) {
                ResolvedPom.this.initialRepositories = ResolvedPom.this.repositories;
            }
            Pom pomReference = ResolvedPom.this.requested;
            pomReference = pomReference.withGav(pomReference.getGav().withRepository(ResolvedPom.this.getValue(pomReference.getGav().getRepository())));
            pomReference = pomReference.withGav(pomReference.getGav().withGroupId(ResolvedPom.this.getValue(pomReference.getGav().getGroupId())));
            pomReference = pomReference.withGav(pomReference.getGav().withArtifactId(ResolvedPom.this.getValue(pomReference.getGav().getArtifactId())));
            pomReference = pomReference.withGav(pomReference.getGav().withVersion(ResolvedPom.this.getValue(pomReference.getGav().getVersion())));
            if (ResolvedPom.this.requested != (pomReference = pomReference.withGav(pomReference.getGav().withDatedSnapshotVersion(ResolvedPom.this.getValue(pomReference.getGav().getDatedSnapshotVersion()))))) {
                ResolvedPom.this.requested = pomReference;
            }
            pomAncestry.clear();
            pomAncestry.add(requested);
            this.resolveParentDependenciesRecursively(pomAncestry);
        }

        private void resolveParentPropertiesAndRepositoriesRecursively(List<Pom> pomAncestry) throws MavenDownloadingException {
            Pom pom = pomAncestry.get(0);
            for (Profile profile : pom.getProfiles()) {
                if (!profile.isActive(ResolvedPom.this.activeProfiles)) continue;
                this.mergeProperties(profile.getProperties(), pom);
            }
            this.mergeProperties(pom.getProperties(), pom);
            for (Profile profile : pom.getProfiles()) {
                if (!profile.isActive(ResolvedPom.this.activeProfiles)) continue;
                this.mergeRepositories(profile.getRepositories());
            }
            this.mergeRepositories(pom.getRepositories());
            if (pom.getParent() != null) {
                Pom parentPom = this.downloader.download(ResolvedPom.this.getValues(pom.getParent().getGav()), pom.getParent().getRelativePath(), ResolvedPom.this, ResolvedPom.this.repositories);
                for (Pom ancestor : pomAncestry) {
                    if (!ancestor.getGav().equals(parentPom.getGav())) continue;
                    return;
                }
                pomAncestry.add(0, parentPom);
                this.resolveParentPropertiesAndRepositoriesRecursively(pomAncestry);
            }
        }

        private void resolveParentDependenciesRecursively(List<Pom> pomAncestry) throws MavenDownloadingException {
            Pom pom = pomAncestry.get(0);
            for (Profile profile : pom.getProfiles()) {
                if (!profile.isActive(ResolvedPom.this.activeProfiles)) continue;
                this.mergeDependencyManagement(profile.getDependencyManagement(), pom);
                this.mergeRequestedDependencies(profile.getDependencies());
            }
            this.mergeDependencyManagement(pom.getDependencyManagement(), pom);
            this.mergeRequestedDependencies(pom.getDependencies());
            if (pom.getParent() != null) {
                Pom parentPom = this.downloader.download(ResolvedPom.this.getValues(pom.getParent().getGav()), pom.getParent().getRelativePath(), ResolvedPom.this, ResolvedPom.this.repositories);
                MavenExecutionContextView.view(this.ctx).getResolutionListener().parent(parentPom, pom);
                for (Pom ancestor : pomAncestry) {
                    if (!ancestor.getGav().equals(parentPom.getGav())) continue;
                    return;
                }
                pomAncestry.add(0, parentPom);
                this.resolveParentDependenciesRecursively(pomAncestry);
            }
        }

        private void mergeRequestedDependencies(List<Dependency> incomingRequestedDependencies) {
            if (!incomingRequestedDependencies.isEmpty()) {
                if (ResolvedPom.this.requestedDependencies == null || ResolvedPom.this.requestedDependencies.isEmpty()) {
                    ResolvedPom.this.requestedDependencies = new ArrayList<Dependency>(incomingRequestedDependencies);
                } else {
                    ResolvedPom.this.requestedDependencies.addAll(incomingRequestedDependencies);
                }
            }
        }

        private void mergeRepositories(List<MavenRepository> incomingRepositories) {
            if (!incomingRepositories.isEmpty()) {
                if (ResolvedPom.this.repositories == null || ResolvedPom.this.repositories.isEmpty()) {
                    ResolvedPom.this.repositories = new ArrayList<MavenRepository>(incomingRepositories.size());
                }
                block0: for (MavenRepository incomingRepository : incomingRepositories) {
                    MavenRepository incoming = new MavenRepository(ResolvedPom.this.getValue(incomingRepository.getId()), ResolvedPom.this.getValue(incomingRepository.getUri()), incomingRepository.getReleases(), incomingRepository.getSnapshots(), incomingRepository.isKnownToExist(), incomingRepository.getUsername(), incomingRepository.getPassword(), incomingRepository.getDeriveMetadataIfMissing());
                    if (incoming.getId() != null) {
                        for (MavenRepository repository : ResolvedPom.this.repositories) {
                            if (!incoming.getId().equals(repository.getId())) continue;
                            continue block0;
                        }
                    }
                    ResolvedPom.this.repositories.add(incoming);
                }
            }
        }

        private void mergeProperties(Map<String, String> incomingProperties, Pom pom) {
            if (!incomingProperties.isEmpty()) {
                if (ResolvedPom.this.properties == null || ResolvedPom.this.properties.isEmpty()) {
                    ResolvedPom.this.properties = new HashMap<String, String>(incomingProperties.size());
                }
                for (Map.Entry<String, String> property : incomingProperties.entrySet()) {
                    MavenExecutionContextView.view(this.ctx).getResolutionListener().property(property.getKey(), property.getValue(), pom);
                    if (ResolvedPom.this.properties.containsKey(property.getKey())) continue;
                    ResolvedPom.this.properties.put(property.getKey(), property.getValue());
                }
            }
        }

        private void mergeDependencyManagement(List<ManagedDependency> incomingDependencyManagement, Pom pom) throws MavenDownloadingException {
            if (!incomingDependencyManagement.isEmpty()) {
                if (ResolvedPom.this.dependencyManagement == null || ResolvedPom.this.dependencyManagement.isEmpty()) {
                    ResolvedPom.this.dependencyManagement = new ArrayList<ResolvedManagedDependency>();
                }
                for (ManagedDependency d : incomingDependencyManagement) {
                    if (d instanceof ManagedDependency.Imported) {
                        ResolvedPom bom = this.downloader.download(ResolvedPom.this.getValues(((ManagedDependency.Imported)d).getGav()), null, ResolvedPom.this, ResolvedPom.this.repositories).resolve(ResolvedPom.this.activeProfiles, this.downloader, ResolvedPom.this.initialRepositories, this.ctx);
                        MavenExecutionContextView.view(this.ctx).getResolutionListener().bomImport(bom.getGav(), pom);
                        ResolvedPom.this.dependencyManagement.addAll(ListUtils.map(bom.getDependencyManagement(), dm -> dm.withRequestedBom(d).withBomGav(bom.getGav())));
                        continue;
                    }
                    if (!(d instanceof ManagedDependency.Defined)) continue;
                    ManagedDependency.Defined defined = (ManagedDependency.Defined)d;
                    MavenExecutionContextView.view(this.ctx).getResolutionListener().dependencyManagement(defined.withGav(ResolvedPom.this.getValues(defined.getGav())), pom);
                    ResolvedPom.this.dependencyManagement.add(new ResolvedManagedDependency(ResolvedPom.this.getValues(defined.getGav()), Scope.fromName(ResolvedPom.this.getValue(defined.getScope())), ResolvedPom.this.getValue(defined.getType()), ResolvedPom.this.getValue(defined.getClassifier()), ListUtils.map(defined.getExclusions(), ResolvedPom.this::getValues), defined, null, null));
                }
            }
        }

        public Resolver(ExecutionContext ctx, MavenPomDownloader downloader) {
            this.ctx = ctx;
            this.downloader = downloader;
        }

        public ExecutionContext getCtx() {
            return this.ctx;
        }

        public MavenPomDownloader getDownloader() {
            return this.downloader;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Resolver)) {
                return false;
            }
            Resolver other = (Resolver)o;
            ExecutionContext this$ctx = this.getCtx();
            ExecutionContext other$ctx = other.getCtx();
            if (this$ctx == null ? other$ctx != null : !this$ctx.equals(other$ctx)) {
                return false;
            }
            MavenPomDownloader this$downloader = this.getDownloader();
            MavenPomDownloader other$downloader = other.getDownloader();
            return !(this$downloader == null ? other$downloader != null : !this$downloader.equals(other$downloader));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ExecutionContext $ctx = this.getCtx();
            result = result * 59 + ($ctx == null ? 43 : $ctx.hashCode());
            MavenPomDownloader $downloader = this.getDownloader();
            result = result * 59 + ($downloader == null ? 43 : $downloader.hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "ResolvedPom.Resolver(ctx=" + this.getCtx() + ", downloader=" + this.getDownloader() + ")";
        }
    }

    private static final class DependencyAndDependent {
        private final Dependency dependency;
        private final Scope scope;
        private final ResolvedDependency dependent;
        private final Dependency rootDependent;
        private final ResolvedPom definedIn;

        public DependencyAndDependent(Dependency dependency, Scope scope, ResolvedDependency dependent, Dependency rootDependent, ResolvedPom definedIn) {
            this.dependency = dependency;
            this.scope = scope;
            this.dependent = dependent;
            this.rootDependent = rootDependent;
            this.definedIn = definedIn;
        }

        public Dependency getDependency() {
            return this.dependency;
        }

        public Scope getScope() {
            return this.scope;
        }

        public ResolvedDependency getDependent() {
            return this.dependent;
        }

        public Dependency getRootDependent() {
            return this.rootDependent;
        }

        public ResolvedPom getDefinedIn() {
            return this.definedIn;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DependencyAndDependent)) {
                return false;
            }
            DependencyAndDependent other = (DependencyAndDependent)o;
            Dependency this$dependency = this.getDependency();
            Dependency other$dependency = other.getDependency();
            if (this$dependency == null ? other$dependency != null : !((Object)this$dependency).equals(other$dependency)) {
                return false;
            }
            Scope this$scope = this.getScope();
            Scope other$scope = other.getScope();
            if (this$scope == null ? other$scope != null : !((Object)((Object)this$scope)).equals((Object)other$scope)) {
                return false;
            }
            ResolvedDependency this$dependent = this.getDependent();
            ResolvedDependency other$dependent = other.getDependent();
            if (this$dependent == null ? other$dependent != null : !((Object)this$dependent).equals(other$dependent)) {
                return false;
            }
            Dependency this$rootDependent = this.getRootDependent();
            Dependency other$rootDependent = other.getRootDependent();
            if (this$rootDependent == null ? other$rootDependent != null : !((Object)this$rootDependent).equals(other$rootDependent)) {
                return false;
            }
            ResolvedPom this$definedIn = this.getDefinedIn();
            ResolvedPom other$definedIn = other.getDefinedIn();
            return !(this$definedIn == null ? other$definedIn != null : !this$definedIn.equals(other$definedIn));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Dependency $dependency = this.getDependency();
            result = result * 59 + ($dependency == null ? 43 : ((Object)$dependency).hashCode());
            Scope $scope = this.getScope();
            result = result * 59 + ($scope == null ? 43 : ((Object)((Object)$scope)).hashCode());
            ResolvedDependency $dependent = this.getDependent();
            result = result * 59 + ($dependent == null ? 43 : ((Object)$dependent).hashCode());
            Dependency $rootDependent = this.getRootDependent();
            result = result * 59 + ($rootDependent == null ? 43 : ((Object)$rootDependent).hashCode());
            ResolvedPom $definedIn = this.getDefinedIn();
            result = result * 59 + ($definedIn == null ? 43 : $definedIn.hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "ResolvedPom.DependencyAndDependent(dependency=" + this.getDependency() + ", scope=" + (Object)((Object)this.getScope()) + ", dependent=" + this.getDependent() + ", rootDependent=" + this.getRootDependent() + ", definedIn=" + this.getDefinedIn() + ")";
        }
    }

    private static final class UniqueDependencyKey {
        private final GroupArtifactVersion gav;
        @Nullable
        private final String type;
        @Nullable
        private final String classifier;
        private final Object scope;

        public UniqueDependencyKey(GroupArtifactVersion gav, @Nullable String type, @Nullable String classifier, Object scope) {
            this.gav = gav;
            this.type = type;
            this.classifier = classifier;
            this.scope = scope;
        }

        public GroupArtifactVersion getGav() {
            return this.gav;
        }

        @Nullable
        public String getType() {
            return this.type;
        }

        @Nullable
        public String getClassifier() {
            return this.classifier;
        }

        public Object getScope() {
            return this.scope;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UniqueDependencyKey)) {
                return false;
            }
            UniqueDependencyKey other = (UniqueDependencyKey)o;
            GroupArtifactVersion this$gav = this.getGav();
            GroupArtifactVersion other$gav = other.getGav();
            if (this$gav == null ? other$gav != null : !((Object)this$gav).equals(other$gav)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$classifier = this.getClassifier();
            String other$classifier = other.getClassifier();
            if (this$classifier == null ? other$classifier != null : !this$classifier.equals(other$classifier)) {
                return false;
            }
            Object this$scope = this.getScope();
            Object other$scope = other.getScope();
            return !(this$scope == null ? other$scope != null : !this$scope.equals(other$scope));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            GroupArtifactVersion $gav = this.getGav();
            result = result * 59 + ($gav == null ? 43 : ((Object)$gav).hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $classifier = this.getClassifier();
            result = result * 59 + ($classifier == null ? 43 : $classifier.hashCode());
            Object $scope = this.getScope();
            result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "ResolvedPom.UniqueDependencyKey(gav=" + this.getGav() + ", type=" + this.getType() + ", classifier=" + this.getClassifier() + ", scope=" + this.getScope() + ")";
        }
    }
}

