/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.search;

import java.util.StringJoiner;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.maven.MavenExecutionContextView;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.maven.tree.MavenRepository;
import org.openrewrite.maven.tree.MavenResolutionResult;
import org.openrewrite.xml.tree.Xml;

public class EffectiveMavenRepositories
extends Recipe {
    public String getDisplayName() {
        return "List effective Maven repositories";
    }

    public String getDescription() {
        return "Lists the Maven repositories that would be used for dependency resolution, in order of precedence. This includes Maven repositories defined in the Maven settings file (and those contributed by active profiles) as determined when the LST was produced.";
    }

    protected MavenVisitor<ExecutionContext> getVisitor() {
        return new MavenIsoVisitor<ExecutionContext>(){

            @Override
            public Xml.Document visitDocument(Xml.Document document, ExecutionContext ctx) {
                MavenResolutionResult mrr = this.getResolutionResult();
                StringJoiner repositories = new StringJoiner("\n");
                for (MavenRepository repository : mrr.getPom().getRepositories()) {
                    repositories.add(repository.getUri());
                }
                for (MavenRepository repository : MavenExecutionContextView.view(ctx).getRepositories(mrr.getMavenSettings(), mrr.getActiveProfiles())) {
                    repositories.add(repository.getUri());
                }
                repositories.add(MavenRepository.MAVEN_CENTRAL.getUri());
                return (Xml.Document)SearchResult.found((Tree)document, (String)repositories.toString());
            }
        };
    }
}

