/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.tree;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import java.io.File;
import java.io.Serializable;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

@JsonIdentityInfo(generator=ObjectIdGenerators.IntSequenceGenerator.class, property="@ref")
public class MavenRepository
implements Serializable {
    public static final MavenRepository MAVEN_LOCAL_USER_NEUTRAL = new MavenRepository("local", new File("~/.m2/repository").toString(), "true", "true", true, null, null, false);
    public static final MavenRepository MAVEN_LOCAL_DEFAULT = new MavenRepository("local", new File(System.getProperty("user.home") + "/.m2/repository").toURI().toString(), "true", "true", true, null, null, false);
    public static final MavenRepository MAVEN_CENTRAL = new MavenRepository("central", "https://repo.maven.apache.org/maven2", "true", "false", true, null, null, true);
    @Nullable
    private final String id;
    private final String uri;
    @Nullable
    private final String releases;
    @Nullable
    private final String snapshots;
    private boolean knownToExist;
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    @Nullable
    private final String username;
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    @Nullable
    private final String password;
    @Nullable
    private Boolean deriveMetadataIfMissing;

    @JsonIgnore
    public MavenRepository(@Nullable String id, String uri, @Nullable String releases, @Nullable String snapshots, boolean knownToExist, @Nullable String username, @Nullable String password, @Nullable Boolean deriveMetadataIfMissing) {
        this.id = id;
        this.uri = uri;
        this.releases = releases;
        this.snapshots = snapshots;
        this.knownToExist = knownToExist;
        this.username = username;
        this.password = password;
        this.deriveMetadataIfMissing = deriveMetadataIfMissing;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MavenRepository)) {
            return false;
        }
        MavenRepository other = (MavenRepository)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$uri = this.getUri();
        String other$uri = other.getUri();
        if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
            return false;
        }
        String this$releases = this.getReleases();
        String other$releases = other.getReleases();
        if (this$releases == null ? other$releases != null : !this$releases.equals(other$releases)) {
            return false;
        }
        String this$snapshots = this.getSnapshots();
        String other$snapshots = other.getSnapshots();
        return !(this$snapshots == null ? other$snapshots != null : !this$snapshots.equals(other$snapshots));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof MavenRepository;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $uri = this.getUri();
        result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
        String $releases = this.getReleases();
        result = result * 59 + ($releases == null ? 43 : $releases.hashCode());
        String $snapshots = this.getSnapshots();
        result = result * 59 + ($snapshots == null ? 43 : $snapshots.hashCode());
        return result;
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    public String getUri() {
        return this.uri;
    }

    @Nullable
    public String getReleases() {
        return this.releases;
    }

    @Nullable
    public String getSnapshots() {
        return this.snapshots;
    }

    public boolean isKnownToExist() {
        return this.knownToExist;
    }

    @Nullable
    public String getUsername() {
        return this.username;
    }

    @Nullable
    public String getPassword() {
        return this.password;
    }

    @Nullable
    public Boolean getDeriveMetadataIfMissing() {
        return this.deriveMetadataIfMissing;
    }

    public void setKnownToExist(boolean knownToExist) {
        this.knownToExist = knownToExist;
    }

    public void setDeriveMetadataIfMissing(@Nullable Boolean deriveMetadataIfMissing) {
        this.deriveMetadataIfMissing = deriveMetadataIfMissing;
    }

    @NonNull
    public String toString() {
        return "MavenRepository(id=" + this.getId() + ", uri=" + this.getUri() + ", releases=" + this.getReleases() + ", snapshots=" + this.getSnapshots() + ", knownToExist=" + this.isKnownToExist() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", deriveMetadataIfMissing=" + this.getDeriveMetadataIfMissing() + ")";
    }

    public MavenRepository(@Nullable String id, String uri, @Nullable String releases, @Nullable String snapshots, @Nullable String username, @Nullable String password) {
        this.id = id;
        this.uri = uri;
        this.releases = releases;
        this.snapshots = snapshots;
        this.username = username;
        this.password = password;
    }

    @NonNull
    public MavenRepository withId(@Nullable String id) {
        return this.id == id ? this : new MavenRepository(id, this.uri, this.releases, this.snapshots, this.knownToExist, this.username, this.password, this.deriveMetadataIfMissing);
    }

    @NonNull
    public MavenRepository withUri(String uri) {
        return this.uri == uri ? this : new MavenRepository(this.id, uri, this.releases, this.snapshots, this.knownToExist, this.username, this.password, this.deriveMetadataIfMissing);
    }

    @NonNull
    public MavenRepository withReleases(@Nullable String releases) {
        return this.releases == releases ? this : new MavenRepository(this.id, this.uri, releases, this.snapshots, this.knownToExist, this.username, this.password, this.deriveMetadataIfMissing);
    }

    @NonNull
    public MavenRepository withSnapshots(@Nullable String snapshots) {
        return this.snapshots == snapshots ? this : new MavenRepository(this.id, this.uri, this.releases, snapshots, this.knownToExist, this.username, this.password, this.deriveMetadataIfMissing);
    }

    @NonNull
    public MavenRepository withUsername(@Nullable String username) {
        return this.username == username ? this : new MavenRepository(this.id, this.uri, this.releases, this.snapshots, this.knownToExist, username, this.password, this.deriveMetadataIfMissing);
    }

    @NonNull
    public MavenRepository withPassword(@Nullable String password) {
        return this.password == password ? this : new MavenRepository(this.id, this.uri, this.releases, this.snapshots, this.knownToExist, this.username, password, this.deriveMetadataIfMissing);
    }

    public static class Builder {
        private String id;
        private String uri;
        private String releases;
        private String snapshots;
        private boolean knownToExist;
        private String username;
        private String password;
        private Boolean deriveMetadataIfMissing;

        private Builder() {
        }

        public MavenRepository build() {
            return new MavenRepository(this.id, this.uri, this.releases, this.snapshots, this.knownToExist, this.username, this.password, this.deriveMetadataIfMissing);
        }

        public Builder releases(boolean releases) {
            this.releases = Boolean.toString(releases);
            return this;
        }

        public Builder releases(String releases) {
            this.releases = releases;
            return this;
        }

        public Builder snapshots(boolean snapshots) {
            this.snapshots = Boolean.toString(snapshots);
            return this;
        }

        public Builder snapshots(String snapshots) {
            this.snapshots = snapshots;
            return this;
        }

        public Builder username(String username) {
            if (username.startsWith("${env.")) {
                this.username = Builder.resolveEnvironmentProperty(username);
                return this;
            }
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            if (password.startsWith("${env.")) {
                this.password = Builder.resolveEnvironmentProperty(password);
                return this;
            }
            this.password = password;
            return this;
        }

        @Nullable
        private static String resolveEnvironmentProperty(@Nullable String rawProperty) {
            if (rawProperty == null) {
                return null;
            }
            String propertyName = rawProperty.replace("${env.", "").replace("}", "");
            return System.getenv(propertyName);
        }

        public String id() {
            return this.id;
        }

        public String uri() {
            return this.uri;
        }

        public String releases() {
            return this.releases;
        }

        public String snapshots() {
            return this.snapshots;
        }

        public boolean knownToExist() {
            return this.knownToExist;
        }

        public String username() {
            return this.username;
        }

        public String password() {
            return this.password;
        }

        public Boolean deriveMetadataIfMissing() {
            return this.deriveMetadataIfMissing;
        }

        @NonNull
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        @NonNull
        public Builder uri(String uri) {
            this.uri = uri;
            return this;
        }

        @NonNull
        public Builder knownToExist(boolean knownToExist) {
            this.knownToExist = knownToExist;
            return this;
        }

        @NonNull
        public Builder deriveMetadataIfMissing(Boolean deriveMetadataIfMissing) {
            this.deriveMetadataIfMissing = deriveMetadataIfMissing;
            return this;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Builder)) {
                return false;
            }
            Builder other = (Builder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.knownToExist() != other.knownToExist()) {
                return false;
            }
            Boolean this$deriveMetadataIfMissing = this.deriveMetadataIfMissing();
            Boolean other$deriveMetadataIfMissing = other.deriveMetadataIfMissing();
            if (this$deriveMetadataIfMissing == null ? other$deriveMetadataIfMissing != null : !((Object)this$deriveMetadataIfMissing).equals(other$deriveMetadataIfMissing)) {
                return false;
            }
            String this$id = this.id();
            String other$id = other.id();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$uri = this.uri();
            String other$uri = other.uri();
            if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
                return false;
            }
            String this$releases = this.releases();
            String other$releases = other.releases();
            if (this$releases == null ? other$releases != null : !this$releases.equals(other$releases)) {
                return false;
            }
            String this$snapshots = this.snapshots();
            String other$snapshots = other.snapshots();
            if (this$snapshots == null ? other$snapshots != null : !this$snapshots.equals(other$snapshots)) {
                return false;
            }
            String this$username = this.username();
            String other$username = other.username();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            String this$password = this.password();
            String other$password = other.password();
            return !(this$password == null ? other$password != null : !this$password.equals(other$password));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Builder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.knownToExist() ? 79 : 97);
            Boolean $deriveMetadataIfMissing = this.deriveMetadataIfMissing();
            result = result * 59 + ($deriveMetadataIfMissing == null ? 43 : ((Object)$deriveMetadataIfMissing).hashCode());
            String $id = this.id();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $uri = this.uri();
            result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
            String $releases = this.releases();
            result = result * 59 + ($releases == null ? 43 : $releases.hashCode());
            String $snapshots = this.snapshots();
            result = result * 59 + ($snapshots == null ? 43 : $snapshots.hashCode());
            String $username = this.username();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            String $password = this.password();
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "MavenRepository.Builder(id=" + this.id() + ", uri=" + this.uri() + ", releases=" + this.releases() + ", snapshots=" + this.snapshots() + ", knownToExist=" + this.knownToExist() + ", username=" + this.username() + ", password=" + this.password() + ", deriveMetadataIfMissing=" + this.deriveMetadataIfMissing() + ")";
        }
    }
}

