/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.cleanup;

import java.util.Comparator;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenTagInsertionComparator;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.xml.AddToTagVisitor;
import org.openrewrite.xml.tree.Xml;

public final class ExplicitPluginGroupId
extends Recipe {
    public String getDisplayName() {
        return "Add explicit `groupId` to Maven plugins";
    }

    public String getDescription() {
        return "Add the default `<groupId>org.apache.maven.plugins</groupId>` to plugins for clarity.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenVisitor<ExecutionContext>(){

            public Xml visitTag(Xml.Tag tag, ExecutionContext ctx) {
                Xml.Tag t = (Xml.Tag)super.visitTag(tag, (Object)ctx);
                if (this.isPluginTag() && !t.getChild("groupId").isPresent()) {
                    Xml.Tag groupIdTag = Xml.Tag.build((String)"<groupId>org.apache.maven.plugins</groupId>");
                    t = (Xml.Tag)new AddToTagVisitor(t, groupIdTag, (Comparator)new MavenTagInsertionComparator(t.getChildren())).visitNonNull((Tree)t, (Object)ctx, this.getCursor().getParentOrThrow());
                    this.maybeUpdateModel();
                }
                return t;
            }
        };
    }

    @NonNull
    public String toString() {
        return "ExplicitPluginGroupId()";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExplicitPluginGroupId)) {
            return false;
        }
        ExplicitPluginGroupId other = (ExplicitPluginGroupId)((Object)o);
        return other.canEqual((Object)this);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ExplicitPluginGroupId;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

