/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.tree.Dependency;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.maven.tree.ResolvedManagedDependency;
import org.openrewrite.maven.tree.Scope;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.tree.Xml;

public final class RemoveDuplicateDependencies
extends Recipe {
    public String getDisplayName() {
        return "Remove duplicate Maven dependencies";
    }

    public String getDescription() {
        return "Removes duplicated dependencies in the `<dependencies>` and `<dependencyManagement>` sections of the `pom.xml`.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(2L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new MavenIsoVisitor<ExecutionContext>(){

            @Override
            public Xml.Document visitDocument(Xml.Document document, ExecutionContext executionContext) {
                Xml.Tag root = document.getRoot();
                if (root.getChild("dependencies").isPresent() || root.getChild("dependencyManagement").isPresent()) {
                    return (Xml.Document)SearchResult.found((Tree)document);
                }
                return document;
            }
        }, (TreeVisitor)new MavenIsoVisitor<ExecutionContext>(){
            private final XPathMatcher DEPENDENCIES_MATCHER = new XPathMatcher("/project/dependencies");
            private final XPathMatcher MANAGED_DEPENDENCIES_MATCHER = new XPathMatcher("/project/dependencyManagement/dependencies");

            @Override
            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                if (this.isDependenciesTag()) {
                    this.getCursor().putMessage("dependencies", new HashMap());
                } else if (this.isManagedDependenciesTag()) {
                    this.getCursor().putMessage("managedDependencies", new HashMap());
                } else if (this.isDependencyTag()) {
                    Xml.Tag existing;
                    Map dependencies = (Map)this.getCursor().getNearestMessage("dependencies");
                    DependencyKey dependencyKey = this.getDependencyKey(tag);
                    if (dependencyKey != null && (existing = dependencies.putIfAbsent(dependencyKey, tag)) != null && existing != tag) {
                        this.maybeUpdateModel();
                        return null;
                    }
                } else if (this.isManagedDependencyTag()) {
                    Xml.Tag existing;
                    Map dependencies = (Map)this.getCursor().getNearestMessage("managedDependencies");
                    DependencyKey dependencyKey = this.getManagedDependencyKey(tag);
                    if (dependencyKey != null && (existing = dependencies.putIfAbsent(dependencyKey, tag)) != null && existing != tag) {
                        this.maybeUpdateModel();
                        return null;
                    }
                }
                return super.visitTag(tag, ctx);
            }

            private boolean isDependenciesTag() {
                return this.DEPENDENCIES_MATCHER.matches(this.getCursor());
            }

            private boolean isManagedDependenciesTag() {
                return this.MANAGED_DEPENDENCIES_MATCHER.matches(this.getCursor());
            }

            @Nullable
            private DependencyKey getDependencyKey(Xml.Tag tag) {
                Scope scope;
                Map<Scope, List<ResolvedDependency>> dependencies = this.getResolutionResult().getDependencies();
                if (dependencies.containsKey((Object)(scope = tag.getChildValue("scope").map(Scope::fromName).orElse(Scope.Compile)))) {
                    for (ResolvedDependency resolvedDependency : dependencies.get((Object)scope)) {
                        Dependency req = resolvedDependency.getRequested();
                        String reqGroup = req.getGroupId();
                        if (reqGroup != null && !reqGroup.equals(tag.getChildValue("groupId").orElse(null)) || !Objects.equals(req.getArtifactId(), tag.getChildValue("artifactId").orElse(null)) || !Objects.equals(Optional.ofNullable(req.getType()).orElse("jar"), tag.getChildValue("type").orElse("jar")) || !Objects.equals(req.getClassifier(), tag.getChildValue("classifier").orElse(null))) continue;
                        return DependencyKey.from(resolvedDependency, scope);
                    }
                }
                return null;
            }

            @Nullable
            private DependencyKey getManagedDependencyKey(Xml.Tag tag) {
                ResolvedManagedDependency resolvedDependency = this.findManagedDependency(tag);
                return resolvedDependency != null ? DependencyKey.from(resolvedDependency) : null;
            }
        });
    }

    @NonNull
    public String toString() {
        return "RemoveDuplicateDependencies()";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveDuplicateDependencies)) {
            return false;
        }
        RemoveDuplicateDependencies other = (RemoveDuplicateDependencies)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof RemoveDuplicateDependencies;
    }

    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    private static final class DependencyKey {
        @Nullable
        private final String groupId;
        private final String artifactId;
        private final String type;
        @Nullable
        private final String classifier;
        private final Scope scope;

        public static DependencyKey from(ResolvedDependency dependency, Scope scope) {
            return new DependencyKey(dependency.getGroupId(), dependency.getArtifactId(), dependency.getType(), dependency.getClassifier(), scope);
        }

        public static DependencyKey from(ResolvedManagedDependency dependency) {
            return new DependencyKey(dependency.getGroupId(), dependency.getArtifactId(), dependency.getType(), dependency.getClassifier(), Scope.Compile);
        }

        public DependencyKey(@Nullable String groupId, String artifactId, String type, @Nullable String classifier, Scope scope) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.type = type;
            this.classifier = classifier;
            this.scope = scope;
        }

        @Nullable
        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getType() {
            return this.type;
        }

        @Nullable
        public String getClassifier() {
            return this.classifier;
        }

        public Scope getScope() {
            return this.scope;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DependencyKey)) {
                return false;
            }
            DependencyKey other = (DependencyKey)o;
            String this$groupId = this.getGroupId();
            String other$groupId = other.getGroupId();
            if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
                return false;
            }
            String this$artifactId = this.getArtifactId();
            String other$artifactId = other.getArtifactId();
            if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$classifier = this.getClassifier();
            String other$classifier = other.getClassifier();
            if (this$classifier == null ? other$classifier != null : !this$classifier.equals(other$classifier)) {
                return false;
            }
            Scope this$scope = this.getScope();
            Scope other$scope = other.getScope();
            return !(this$scope == null ? other$scope != null : !((Object)((Object)this$scope)).equals((Object)other$scope));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $groupId = this.getGroupId();
            result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
            String $artifactId = this.getArtifactId();
            result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $classifier = this.getClassifier();
            result = result * 59 + ($classifier == null ? 43 : $classifier.hashCode());
            Scope $scope = this.getScope();
            result = result * 59 + ($scope == null ? 43 : ((Object)((Object)$scope)).hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "RemoveDuplicateDependencies.DependencyKey(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", type=" + this.getType() + ", classifier=" + this.getClassifier() + ", scope=" + (Object)((Object)this.getScope()) + ")";
        }
    }
}

