/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.search;

import java.util.Optional;
import java.util.UUID;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.marker.JavaProject;
import org.openrewrite.java.marker.JavaSourceSet;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.table.DependenciesInUse;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.maven.tree.Scope;
import org.openrewrite.xml.tree.Xml;

public final class DependencyInsight
extends Recipe {
    private final transient DependenciesInUse dependenciesInUse = new DependenciesInUse(this);
    @Option(displayName="Group pattern", description="Group glob pattern used to match dependencies.", example="com.fasterxml.jackson.module")
    private final String groupIdPattern;
    @Option(displayName="Artifact pattern", description="Artifact glob pattern used to match dependencies.", example="jackson-module-*")
    private final String artifactIdPattern;
    @Option(displayName="Scope", description="Match dependencies with the specified scope", valid={"compile", "test", "runtime", "provided"}, example="compile")
    private final String scope;
    @Option(displayName="Only direct", description="Default false. If enabled, transitive dependencies will not be considered.", required=false, example="true")
    @Nullable
    private final Boolean onlyDirect;
    private final UUID searchId = Tree.randomId();

    public Validated<Object> validate() {
        return super.validate().and(Validated.test((String)"scope", (String)"scope is a valid Maven scope", (Object)this.scope, s -> Scope.fromName(s) != Scope.Invalid));
    }

    public String getDisplayName() {
        return "Maven dependency insight";
    }

    public String getDescription() {
        return "Find direct and transitive dependencies matching a group, artifact, and scope. Results include dependencies that either directly match or transitively include a matching dependency.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final Scope aScope = Scope.fromName(this.scope);
        return new MavenIsoVisitor<ExecutionContext>(){

            @Override
            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                ResolvedDependency match;
                ResolvedDependency dependency;
                Xml.Tag t = super.visitTag(tag, ctx);
                if (this.isDependencyTag() && (dependency = this.findDependency(t, aScope)) != null && (match = dependency.findDependency(DependencyInsight.this.groupIdPattern, DependencyInsight.this.artifactIdPattern)) != null) {
                    if (match == dependency) {
                        t = (Xml.Tag)SearchResult.found((Tree)t);
                    } else {
                        if (Boolean.TRUE.equals(DependencyInsight.this.onlyDirect)) {
                            return t;
                        }
                        t = (Xml.Tag)SearchResult.found((Tree)t, (String)match.getGav().toString());
                    }
                    Optional javaProject = ((Xml.Document)this.getCursor().firstEnclosingOrThrow(Xml.Document.class)).getMarkers().findFirst(JavaProject.class);
                    Optional javaSourceSet = ((Xml.Document)this.getCursor().firstEnclosingOrThrow(Xml.Document.class)).getMarkers().findFirst(JavaSourceSet.class);
                    DependencyInsight.this.dependenciesInUse.insertRow(ctx, new DependenciesInUse.Row(javaProject.map(JavaProject::getProjectName).orElse(""), javaSourceSet.map(JavaSourceSet::getName).orElse("main"), match.getGroupId(), match.getArtifactId(), match.getVersion(), match.getDatedSnapshotVersion(), StringUtils.isBlank((String)match.getRequested().getScope()) ? "compile" : match.getRequested().getScope(), match.getDepth()));
                }
                return t;
            }
        };
    }

    public DependencyInsight(String groupIdPattern, String artifactIdPattern, String scope, @Nullable Boolean onlyDirect) {
        this.groupIdPattern = groupIdPattern;
        this.artifactIdPattern = artifactIdPattern;
        this.scope = scope;
        this.onlyDirect = onlyDirect;
    }

    public DependenciesInUse getDependenciesInUse() {
        return this.dependenciesInUse;
    }

    public String getGroupIdPattern() {
        return this.groupIdPattern;
    }

    public String getArtifactIdPattern() {
        return this.artifactIdPattern;
    }

    public String getScope() {
        return this.scope;
    }

    @Nullable
    public Boolean getOnlyDirect() {
        return this.onlyDirect;
    }

    public UUID getSearchId() {
        return this.searchId;
    }

    @NonNull
    public String toString() {
        return "DependencyInsight(dependenciesInUse=" + (Object)((Object)this.getDependenciesInUse()) + ", groupIdPattern=" + this.getGroupIdPattern() + ", artifactIdPattern=" + this.getArtifactIdPattern() + ", scope=" + this.getScope() + ", onlyDirect=" + this.getOnlyDirect() + ", searchId=" + this.getSearchId() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DependencyInsight)) {
            return false;
        }
        DependencyInsight other = (DependencyInsight)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$onlyDirect = this.getOnlyDirect();
        Boolean other$onlyDirect = other.getOnlyDirect();
        if (this$onlyDirect == null ? other$onlyDirect != null : !((Object)this$onlyDirect).equals(other$onlyDirect)) {
            return false;
        }
        String this$groupIdPattern = this.getGroupIdPattern();
        String other$groupIdPattern = other.getGroupIdPattern();
        if (this$groupIdPattern == null ? other$groupIdPattern != null : !this$groupIdPattern.equals(other$groupIdPattern)) {
            return false;
        }
        String this$artifactIdPattern = this.getArtifactIdPattern();
        String other$artifactIdPattern = other.getArtifactIdPattern();
        if (this$artifactIdPattern == null ? other$artifactIdPattern != null : !this$artifactIdPattern.equals(other$artifactIdPattern)) {
            return false;
        }
        String this$scope = this.getScope();
        String other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
            return false;
        }
        UUID this$searchId = this.getSearchId();
        UUID other$searchId = other.getSearchId();
        return !(this$searchId == null ? other$searchId != null : !((Object)this$searchId).equals(other$searchId));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof DependencyInsight;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $onlyDirect = this.getOnlyDirect();
        result = result * 59 + ($onlyDirect == null ? 43 : ((Object)$onlyDirect).hashCode());
        String $groupIdPattern = this.getGroupIdPattern();
        result = result * 59 + ($groupIdPattern == null ? 43 : $groupIdPattern.hashCode());
        String $artifactIdPattern = this.getArtifactIdPattern();
        result = result * 59 + ($artifactIdPattern == null ? 43 : $artifactIdPattern.hashCode());
        String $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        UUID $searchId = this.getSearchId();
        result = result * 59 + ($searchId == null ? 43 : ((Object)$searchId).hashCode());
        return result;
    }
}

