/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.diagnostic.ImplementationConflictException;
import com.intellij.diagnostic.PluginException;
import com.intellij.lang.MetaLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.DefaultPluginDescriptor;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Language
extends UserDataHolderBase {
    private static final Map<Class<? extends Language>, Language> ourRegisteredLanguages = new ConcurrentHashMap<Class<? extends Language>, Language>();
    private static final ConcurrentMap<String, List<Language>> ourRegisteredMimeTypes = new ConcurrentHashMap<String, List<Language>>();
    private static final Map<String, Language> ourRegisteredIDs = new ConcurrentHashMap<String, Language>();
    private final Language myBaseLanguage;
    private final String myID;
    private final String[] myMimeTypes;
    private final List<Language> myDialects;
    public static final Language ANY = new Language(""){

        @Override
        public String toString() {
            return "Language: ANY";
        }

        @Override
        @Nullable
        public LanguageFileType getAssociatedFileType() {
            return null;
        }
    };

    protected Language(@NonNls @NotNull String ID2) {
        if (ID2 == null) {
            Language.$$$reportNull$$$0(0);
        }
        this(ID2, ArrayUtilRt.EMPTY_STRING_ARRAY);
    }

    protected Language(@NonNls @NotNull String ID2, String ... mimeTypes) {
        if (ID2 == null) {
            Language.$$$reportNull$$$0(1);
        }
        if (mimeTypes == null) {
            Language.$$$reportNull$$$0(2);
        }
        this((Language)null, ID2, mimeTypes);
    }

    protected Language(@Nullable Language baseLanguage, @NonNls @NotNull String ID2, String ... mimeTypes) {
        if (ID2 == null) {
            Language.$$$reportNull$$$0(3);
        }
        if (mimeTypes == null) {
            Language.$$$reportNull$$$0(4);
        }
        this.myDialects = ContainerUtil.createLockFreeCopyOnWriteList();
        if (baseLanguage instanceof MetaLanguage) {
            throw new ImplementationConflictException("MetaLanguage cannot be a base language.\nThis language: '" + ID2 + "'\nBase language: '" + baseLanguage.getID() + "'", null, this, baseLanguage);
        }
        this.myBaseLanguage = baseLanguage;
        this.myID = ID2;
        this.myMimeTypes = mimeTypes.length == 0 ? ArrayUtilRt.EMPTY_STRING_ARRAY : mimeTypes;
        Class<?> langClass = this.getClass();
        Language prev = ourRegisteredLanguages.putIfAbsent(langClass, this);
        if (prev != null) {
            throw new ImplementationConflictException("Language of '" + langClass + "' is already registered: " + prev, null, prev, this);
        }
        prev = ourRegisteredIDs.putIfAbsent(ID2, this);
        if (prev != null) {
            throw new ImplementationConflictException("Language with ID '" + ID2 + "' is already registered: " + prev.getClass(), null, prev, this);
        }
        for (String mimeType : mimeTypes) {
            if (StringUtil.isEmpty(mimeType)) continue;
            List languagesByMimeType = (List)ourRegisteredMimeTypes.get(mimeType);
            if (languagesByMimeType == null) {
                languagesByMimeType = ConcurrencyUtil.cacheOrGet(ourRegisteredMimeTypes, mimeType, ContainerUtil.createConcurrentList());
            }
            languagesByMimeType.add(this);
        }
        if (baseLanguage != null) {
            baseLanguage.myDialects.add(this);
        }
    }

    @NotNull
    public static Collection<Language> getRegisteredLanguages() {
        Collection<Language> languages = ourRegisteredLanguages.values();
        Collection<Language> collection = Collections.unmodifiableCollection(new ArrayList<Language>(languages));
        if (collection == null) {
            Language.$$$reportNull$$$0(5);
        }
        return collection;
    }

    @ApiStatus.Internal
    public static void unregisterAllLanguagesIn(@NotNull ClassLoader classLoader, @NotNull PluginDescriptor pluginDescriptor) {
        if (classLoader == null) {
            Language.$$$reportNull$$$0(6);
        }
        if (pluginDescriptor == null) {
            Language.$$$reportNull$$$0(7);
        }
        for (Map.Entry<Class<? extends Language>, Language> e : new ArrayList<Map.Entry<Class<? extends Language>, Language>>(ourRegisteredLanguages.entrySet())) {
            Class<? extends Language> clazz = e.getKey();
            Language language = e.getValue();
            if (clazz.getClassLoader() != classLoader) continue;
            language.unregisterLanguage(pluginDescriptor);
        }
        IElementType.unregisterElementTypes(classLoader, pluginDescriptor);
    }

    @Deprecated
    @ApiStatus.Internal
    public static void unregisterLanguage(@NotNull Language language) {
        if (language == null) {
            Language.$$$reportNull$$$0(8);
        }
        PluginException.reportDeprecatedUsage("this method", "");
        language.unregisterLanguage(new DefaultPluginDescriptor("unknown"));
    }

    @ApiStatus.Internal
    public void unregisterLanguage(@NotNull PluginDescriptor pluginDescriptor) {
        if (pluginDescriptor == null) {
            Language.$$$reportNull$$$0(9);
        }
        IElementType.unregisterElementTypes(this, pluginDescriptor);
        ReferenceProvidersRegistry referenceProvidersRegistry = ApplicationManager.getApplication().getServiceIfCreated(ReferenceProvidersRegistry.class);
        if (referenceProvidersRegistry != null) {
            referenceProvidersRegistry.unloadProvidersFor(this);
        }
        ourRegisteredLanguages.remove(this.getClass());
        ourRegisteredIDs.remove(this.getID());
        for (String mimeType : this.getMimeTypes()) {
            ourRegisteredMimeTypes.remove(mimeType);
        }
        Language baseLanguage = this.getBaseLanguage();
        if (baseLanguage != null) {
            baseLanguage.unregisterDialect(this);
        }
    }

    @ApiStatus.Internal
    public void unregisterDialect(@NotNull Language language) {
        if (language == null) {
            Language.$$$reportNull$$$0(10);
        }
        this.myDialects.remove(language);
    }

    public static <T extends Language> T findInstance(@NotNull Class<T> klass) {
        if (klass == null) {
            Language.$$$reportNull$$$0(11);
        }
        return (T)ourRegisteredLanguages.get(klass);
    }

    @NotNull
    public static Collection<Language> findInstancesByMimeType(@Nullable String mimeType) {
        List result = mimeType == null ? null : (List)ourRegisteredMimeTypes.get(mimeType);
        Collection collection = result == null ? Collections.emptyList() : Collections.unmodifiableCollection(result);
        if (collection == null) {
            Language.$$$reportNull$$$0(12);
        }
        return collection;
    }

    @Override
    public String toString() {
        return "Language: " + this.myID;
    }

    public String @NotNull [] getMimeTypes() {
        if (this.myMimeTypes == null) {
            Language.$$$reportNull$$$0(13);
        }
        return this.myMimeTypes;
    }

    @NotNull
    @NlsSafe
    public String getID() {
        String string = this.myID;
        if (string == null) {
            Language.$$$reportNull$$$0(14);
        }
        return string;
    }

    @Nullable
    public LanguageFileType getAssociatedFileType() {
        return FileTypeRegistry.getInstance().findFileTypeByLanguage(this);
    }

    @ApiStatus.Internal
    @Nullable
    public LanguageFileType findMyFileType(FileType @NotNull [] types) {
        LanguageFileType languageFileType;
        if (types == null) {
            Language.$$$reportNull$$$0(15);
        }
        for (FileType fileType : types) {
            if (!(fileType instanceof LanguageFileType) || (languageFileType = (LanguageFileType)fileType).getLanguage() != this || languageFileType.isSecondary()) continue;
            return languageFileType;
        }
        for (FileType fileType : types) {
            if (!(fileType instanceof LanguageFileType) || !this.isKindOf((languageFileType = (LanguageFileType)fileType).getLanguage()) || languageFileType.isSecondary()) continue;
            return languageFileType;
        }
        return null;
    }

    @Nullable
    public Language getBaseLanguage() {
        return this.myBaseLanguage;
    }

    @NotNull
    @NlsSafe
    public String getDisplayName() {
        String string = this.getID();
        if (string == null) {
            Language.$$$reportNull$$$0(16);
        }
        return string;
    }

    public final boolean is(Language another) {
        return this == another;
    }

    public boolean isCaseSensitive() {
        return this.myBaseLanguage != null && this.myBaseLanguage.isCaseSensitive();
    }

    @Contract(pure=true)
    public final boolean isKindOf(Language another) {
        for (Language l = this; l != null; l = l.getBaseLanguage()) {
            if (!l.is(another)) continue;
            return true;
        }
        return false;
    }

    public final boolean isKindOf(@NotNull @NonNls String anotherLanguageId) {
        if (anotherLanguageId == null) {
            Language.$$$reportNull$$$0(17);
        }
        for (Language l = this; l != null; l = l.getBaseLanguage()) {
            if (!l.getID().equals(anotherLanguageId)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public List<Language> getDialects() {
        List<Language> list = this.myDialects;
        if (list == null) {
            Language.$$$reportNull$$$0(18);
        }
        return list;
    }

    @Nullable
    public static Language findLanguageByID(@NonNls String id) {
        return id == null ? null : ourRegisteredIDs.get(id);
    }

    protected Language(@NotNull String ID2, boolean register) {
        if (ID2 == null) {
            Language.$$$reportNull$$$0(19);
        }
        this.myDialects = ContainerUtil.createLockFreeCopyOnWriteList();
        Language language = Language.findLanguageByID(ID2);
        if (language != null) {
            throw new IllegalArgumentException("Language with ID=" + ID2 + " already registered: " + language + "; " + language.getClass());
        }
        this.myID = ID2;
        this.myBaseLanguage = null;
        this.myMimeTypes = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ID";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mimeTypes";
                break;
            }
            case 5: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/Language";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classLoader";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "klass";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anotherLanguageId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/Language";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegisteredLanguages";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "findInstancesByMimeType";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getMimeTypes";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getDialects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "unregisterAllLanguagesIn";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "unregisterLanguage";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "unregisterDialect";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findInstance";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findMyFileType";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isKindOf";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

